set define '^'
set verify off
prompt ...wwv_flow_instance_admin


Rem  Copyright (c) Oracle Corporation 2007. All Rights Reserved.
Rem
Rem    NAME
Rem      wwv_flow_instance_admin.sql
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem
Rem    INTERNATIONALIZATION
Rem      unknown
Rem
Rem    MULTI-CUSTOMER
Rem      unknown
Rem
Rem    SCRIPT ARGUMENTS
Rem      None
Rem
Rem    RUNTIME DEPLOYMENT: YES
Rem
Rem    MODIFIED    (MM/DD/YYYY)
Rem      jstraub    08/10/2007 - Created
Rem      jstraub    09/18/2007 - Added grant to APEX_ADMINISTRATOR_ROLE
Rem      jstraub    10/30/2007 - Added remove_workspace
Rem      jstraub    11/08/2007 - Added add_workspace
Rem      jstraub    01/21/2009 - Added remove_saved_reports


create or replace package wwv_flow_instance_admin as


procedure set_parameter(
    p_parameter           in varchar2,
    p_value               in varchar2 default 'N' );


function get_parameter(
    p_parameter           in varchar2 )
return varchar2;

function get_schemas(
    p_workspace           in varchar2 )
return varchar2;

procedure add_schema(
    p_workspace           in varchar2,
    p_schema              in varchar2 );

procedure remove_schema(
    p_workspace           in varchar2,
    p_schema              in varchar2 );

procedure add_workspace(
    p_workspace_id        in number default null,
    p_workspace           in varchar2,
    p_primary_schema      in varchar2,
    p_additional_schemas  in varchar2 );

procedure remove_workspace(
    p_workspace           in varchar2,
    p_drop_users          in varchar2 default 'N',
    p_drop_tablespaces    in varchar2 default 'N' );

procedure remove_saved_reports(
    p_application_id      in number default null );

end wwv_flow_instance_admin;
/

grant execute on wwv_flow_instance_admin to APEX_ADMINISTRATOR_ROLE
/
