set define '^'

set verify off
prompt ...wwv_flow_page_cache_api


Rem  Copyright (c) Oracle Corporation 2006 - 2007. All Rights Reserved.
Rem
Rem    NAME
Rem      wwv_flow_page_cache_api
Rem
Rem    DESCRIPTION
Rem      Application Express page caching logic
Rem
Rem    MODIFIED  (MM/DD/YYYY)
Rem      mhichwa  06/09/2006 - Created
Rem      mhichwa  06/12/2006 - Modified
Rem      mhichwa  06/16/2006 - Added purge_stale, get_date_cached
Rem      mhichwa  12/21/2006 - Added display_region
Rem      mhichwa  12/27/2006 - Added purge region cache procedures
Rem      mhichwa  12/28/2006 - Added function verify_cache_condition
Rem      mhichwa  12/28/2006 - Added procedure purge_regions_by_id
Rem      mhichwa  01/02/2007 - Added purge_regions_by_name, purge_regions_by_page
Rem      mhichwa  01/05/2007 - Added purge_stale_regions procedure, added functions count_stale_regions, count_stale_pages
Rem      mhichwa  01/10/2007 - Added chart caching procedures and function
Rem      cbcho    01/24/2007 - Changed lob_replace to take p_with with null value
Rem      madelfio 02/15/2007 - Updated chart caching APIs and added chart_region_exists function
Rem      sspadafo 04/27/2007 - Added overloaded version of function get_date_cached for regions (Bug 5996963)
Rem      jkallman 04/14/2008 - Correct implementation of purge_all (remove parameter) (Bug 6963877)


create or replace package wwv_flow_page_cache_api
as

procedure cache_page;

function display_page
    return boolean;
    
--------------------
-- Manage Page Cache
--
function count_stale_pages (
    p_application    in number)
    return number;

procedure purge_by_application (
   p_application   in number);

procedure purge_stale (
    p_application    in number);
   
procedure purge_by_page (
   p_application   in number,
   p_page          in number,
   p_user_name     in varchar2 default null);
   
procedure purge_all;

function get_date_cached (
    p_application  in number,
    p_page         in number)
    return date;

---------------------------------------
-- manage region cache 
--

procedure purge_stale_regions (
    p_application    in number);
    
function count_stale_regions (
    p_application    in number)
    return number;

procedure purge_regions_by_app (
     p_application in number);

procedure purge_regions_by_id (
     p_application in number,
     p_region_id   in number);

procedure purge_expired_regions (
     p_application in number);

procedure purge_regions_by_name (
     p_application  in number,
     p_page_id      in number,
     p_region_name  in varchar2);
     
procedure purge_regions_by_page (
     p_application  in number,
     p_page_id      in number);
   
function display_region (
   p_application_id in number,
   p_region_id      in number)
   return boolean;

function get_date_cached (
    p_application  in number,
    p_page         in number,    
    p_region_name  in varchar2)
    return date;   
--
--
--

procedure lob_replace( 
    p_lob in out clob,  
    p_what in varchar2, 
    p_with in varchar2 default null);
    
function verify_cache_condition (
   p_application_id in number,
   p_region_id      in number)
   return boolean;
   
   
--
-- Chart Caching
--
procedure cache_chart_region (
   -- save xml to cache table
   p_application_id    in number,
   p_region_id         in number)
   ;

function display_chart_region (
   -- fetch xml from cache table
   p_application_id in number,
   p_region_id      in number)
   return boolean;
   
function chart_region_exists (
   -- does a unexpired cache of this chart exist
   p_application_id in number,
   p_region_id      in number)
   return boolean;

procedure purge_chart_cache_by_app (
    p_application_id in number);

procedure purge_chart_cache_by_region (
    p_application_id in number,
    p_region_id      in number);

end wwv_flow_page_cache_api;
/
show errors