set define '^'
set verify off
prompt ...wwv_flow_theme_files


Rem    NAME
Rem      wwv_flow_theme_files.sql

Rem    MODIFIED (MM/DD/YYYY)
Rem     mhichwa  06/21/2004 - Created
Rem     mhichwa  06/24/2004 - Added css functionality
Rem     mhichwa  06/24/2004 - Added template substitution strings for pages and regions
Rem     mhichwa  06/28/2004 - Added procedure to track database object dependancies
Rem     mhichwa  06/29/2004 - Extended functionality of database object dep reporting
Rem     sspadafo 07/05/2004 - Change spelling in procedure name to find_object_dependencies
Rem     mhichwa  12/04/2007 - Added get_theme_image_name



create or replace package wwv_flow_theme_files 
as
procedure find_template_files (
    p_flow_id              in number,
    p_theme                in number   default null,
    p_show_templates       in varchar2 default 'N',
    p_show_page_components in varchar2 default 'N',
    p_show_components      in varchar2 default 'N',
    p_show_gif             in varchar2 default 'N',
    p_show_jpg             in varchar2 default 'N',
    p_show_png             in varchar2 default 'N',
    p_show_css             in varchar2 default 'N',
    p_show_js              in varchar2 default 'N',
    p_show_swf             in varchar2 default 'N',
    p_show_ico             in varchar2 default 'N'
    )	
    ;

procedure find_css_classes (
    p_flow_id              in number,
    p_theme                in number   default null,
    p_show_templates       in varchar2 default 'N',
    p_show_page_components in varchar2 default 'N',
    p_show_components      in varchar2 default 'N')
    ;

procedure find_substitution_strings (
    p_flow_id              in number,
    p_theme                in number   default null)
    ;
    
procedure find_object_dependencies (
   p_flow_id      in number,
   p_page_id      in number default null)
   ;
   
function get_theme_image_name (
   p_id           in number)
   return         varchar2
   ;
   
end wwv_flow_theme_files;
/

show errors

