set define '^'
set verify off
prompt ...wwv_flow_theme_globals

Rem  Copyright (c) Oracle Corporation 2003. All Rights Reserved.
Rem
Rem    NAME
Rem      wwv_flow_theme_globals.sql
Rem
Rem    DESCRIPTION
Rem      Package used to hole theme defaults which will be set by wwv_flow_theme_? packages
Rem      This is to facilitate application creation.
Rem
Rem    NOTES
Rem
Rem    MODIFIED    (MM/DD/YYYY)
Rem       skutz  06/05/2004 - Created
Rem       skutz  06/11/2004 - Added g_default_option_label and g_default_required_label globals
Rem       skutz  06/17/2004 - Added g_default_chart_list and g_default_report_list globals
Rem       skutz  06/18/2004 - Added g_default_breadcrumb_region
Rem       skutz  06/22/2004 - Added g_default_sb_page_template and g_default_sb_region_template
Rem       skutz  06/24/2004 - Added g_default_sb_nav_template
Rem       skutz  08/02/2004 - Added g_default_ul_list

create or replace package wwv_flow_theme_globals
as

    g_theme_id                    number;
    -- page
    g_default_page_template       number;
    g_error_template              number;
    g_printer_friendly_template   number;
    g_breadcrumb_display_point    varchar2(2000);
    g_sidebar_display_point       varchar2(2000);
    g_login_template              number;
    -- region
    g_default_button_template     number;
    g_default_region_template     number;
    g_default_chart_template      number;
    g_default_form_template       number;
    g_default_reportr_template    number;
    g_default_tabform_template    number;
    g_default_wizard_template     number;
    g_default_menur_template      number;
    g_default_listr_template      number;
    --row/report
    g_default_report_template     number;
    -- field/label
    g_default_label_template      number;
    -- menu
    g_default_menu_template       number;
    -- calendar
    g_default_calendar_template   number;
    -- lists
    g_default_list_template       number;
    g_default_option_label        number;
    g_default_required_label      number;
    -- list globals
    g_default_chart_list          number;
    g_default_report_list         number;
    g_default_ul_wo_bullet_list   number;
    --
    g_default_breadcrumb_region   number;

    g_default_sb_page_template    number;
    g_default_sb_region_template  number;
    g_default_sb_nav_template     number;

end wwv_flow_theme_globals;
/
show errors;