Rem
Rem
Rem Copyright (c) 2005, Oracle.  All rights reserved.  
Rem
Rem    NAME
Rem      wwv_flow_val.sql
Rem
Rem    DESCRIPTION
Rem      Access library SYS.WWV_FLOW_VAL_LIB 
Rem
Rem    NOTES
Rem      Hard-coded reference to schema name, e.g., FLOWS_020100 must be maintained for each release
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    lvbcheng    09/06/2005 - Created
Rem    sspadafo    10/25/2005 - Split into separate spec and body files	
Rem    mhichwa     12/08/2005 - Removed references to product name
Rem    jkallman    01/23/2006 - Adjust flows_020100 references to flows_020200
Rem    jkallman    09/29/2006 - Adjust flows_020200 references to flows_030000
Rem    jkallman    08/02/2007 - Change FLOWS_030000 references to FLOWS_030100
Rem    jkallman    09/09/2008 - Change FLOWS_030100 references to APEX_030200


create or replace package SYS.WWV_FLOW_VAL authid current_user
as
  /*********************************/
  /* return values for verify_user */
  /*********************************/

  valid_user CONSTANT PLS_INTEGER := 0;
  invalid_user CONSTANT PLS_INTEGER := 1;
  null_input CONSTANT PLS_INTEGER := -1;

  /******************************/
  /* exceptions for verify_user */
  /******************************/

  invalid_caller exception; /* this exception is raised if the user
                               is not allowed to call this package
                             */
  internal_error exception; /* this exception is raised only in unusual
                               situations (i.e., out of memory, database
                               down) */
  account_locked exception; /* this exception is raised if the account
                               is locked */
  password_expired exception; /* this exception is raised if the password
                                 has expired */
  /***********************/
  /* exception constants */
  /***********************/

  invalid_caller_errcode     CONSTANT PLS_INTEGER:= -32058;
  internal_error_errcode     CONSTANT PLS_INTEGER:= -600;
  account_locked_errcode     CONSTANT PLS_INTEGER:= -28000;
  password_expired_errcode   CONSTANT PLS_INTEGER:= -28001;

  PRAGMA EXCEPTION_INIT(invalid_caller,     -32058);
  PRAGMA EXCEPTION_INIT(internal_error,     -600);
  PRAGMA EXCEPTION_INIT(account_locked,     -28000);
  PRAGMA EXCEPTION_INIT(password_expired,   -28001);

  function verify_user(username IN varchar2 character set any_cs,
                       password IN varchar2 character set any_cs) 
    return PLS_INTEGER;
  /* 
    DESCRIPTION:
    Verify that the username and password pair is valid.

    PARAMETERS:
    username (IN) - username to be validated. Blank padded
                    usernames are not valid. Thus, 'SCOTT  '
                    is not equal to 'SCOTT'.
    password (IN) - password to be validated. Blank padded
                    usernames are not valid. Thus, 'TIGER  '
                    is not equal to 'TIGER'.

    USAGE NOTES:
    This package can only be called by the user FLOWS_xxxxxx (product release-specific)
    Any other caller will be rejected.

    SECURITY:

    TBD
 
  */
end WWV_FLOW_VAL;
/
show errors

create or replace library SYS.WWV_FLOW_VAL_LIB trusted is static
/

grant execute on WWV_FLOW_VAL to apex_030200
/
