set define '^'
set verify off
prompt ...wwv_flow_worksheet_attachment

Rem  Copyright (c) Oracle Corporation 2007. All Rights Reserved.
Rem
Rem    NAME
Rem      wwv_flow_worksheet_attachment.sql
Rem    DESCRIPTION
Rem     Interface to add attachments to data store.
Rem
Rem    NOTES
Rem      API to handle worksheet attachements.
Rem
Rem    SECURITY
Rem      No grants, must be run as FLOW schema owner.
Rem
Rem    MODIFIED (MM/DD/YYYY)
Rem     jstraub  04/17/2007 - Created



create or replace package wwv_flow_worksheet_attachment
as

procedure add_doc (
    p_row_id    in varchar2,
    p_file_name in varchar2,
    p_desc      in varchar2
    );

procedure delete_doc (
    p_doc_id    in varchar2
    );

procedure download_doc (
    p_doc_id    in varchar2
    );

end wwv_flow_worksheet_attachment;
/
show errors;

