
set define '^'
set verify off
prompt ...wwv_flow_worksheet_dialogue

Rem
Rem    INTERNATIONALIZATION
Rem      unknown
Rem
Rem    MULTI-CUSTOMER
Rem      unknown
Rem
Rem    SCRIPT ARGUMENTS
Rem      none
Rem
Rem    RUNTIME DEPLOYMENT: YES
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      cbcho     08/17/2007 - Created
Rem      cbcho     08/21/2007 - Added show_highlight, show_filter
Rem      cbcho     08/23/2007 - Added show_ordering
Rem      jstraub   08/27/2007 - Added show_save
Rem      cbcho     09/12/2007 - Changed show_column_list to accept p_column_type
Rem      cbcho     09/12/2007 - Added show_chart
Rem      cbcho     09/13/2007 - Added show_calendar, show_delete_confirm
Rem      cbcho     09/17/2007 - Added show_aggregate
Rem      cbcho     10/10/2007 - Removed show_rename, added p_save_type to show_save to do rename
Rem      cbcho     11/30/2007 - Added p_aggregate to show_aggregate
Rem      cbcho     12/12/2007 - Added show_select_columns
Rem      cbcho     12/14/2007 - Added show_control_break
Rem      cbcho     12/17/2007 - Added show_save_default
Rem      cbcho     01/22/2008 - Added get_valid_sql_functions, show_format_mask
Rem      cbcho     01/26/2008 - Added get_group_name
Rem      cbcho     01/26/2008 - Removed get_group_name to use wwv_flow_worksheet_standar.get_group_name instead


create or replace package wwv_flow_worksheet_dialogue
as

function get_valid_sql_functions return wwv_flow_global.vc_arr2;
    
procedure show_format_mask (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in varchar2);

procedure show_column_list (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in varchar2,
    p_column_type  in varchar2 default null);
    
procedure show_select_columns (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in varchar2);
    
procedure save_column_list (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in varchar2,
    p_column_list  in wwv_flow_global.vc_arr2);

procedure show_highlight (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in number,
    p_condition_id in varchar2 default null);

procedure show_filter (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in number,
    p_condition_id in varchar2 default null);

procedure show_ordering (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in number);

procedure show_save (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in number,
    p_save_type    in varchar2 default 'SAVE');
    
procedure show_save_default (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in number);    
    
procedure show_chart (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in number);
    
procedure show_calendar (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in number);      

procedure show_delete (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in number);
    
procedure show_aggregate (
    p_worksheet_id in number,    
    p_app_user     in varchar2,
    p_report_id    in number,
    p_aggregate    in varchar2 default null);
    
procedure show_flashback (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in number);
    
procedure show_reset (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in number);

procedure show_computation (
    p_worksheet_id   in number,
    p_app_user       in varchar2,
    p_report_id      in number,
    p_computation_id in varchar2 default null);
    
procedure show_download (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in number);  
    
procedure show_control_break (
    p_worksheet_id in number,
    p_app_user     in varchar2,
    p_report_id    in number);          
end  wwv_flow_worksheet_dialogue;
/
show errors
