set define '^'
set verify off
prompt ...wwv_flow_webpage

Rem  Copyright (c) Oracle Corporation 2007. All Rights Reserved.
Rem
Rem    NAME
Rem      wwv_flow_worksheet_geocode.sql
Rem    DESCRIPTION
Rem     Interface for geocoding data.
Rem
Rem    NOTES
Rem      API to generate geocode data and store in worksheet.
Rem
Rem    SECURITY
Rem      No grants, must be run as FLOW schema owner.
Rem
Rem    MODIFIED (MM/DD/YYYY)
Rem     mhichwa  04/04/2007 - Created
Rem     mhichwa  04/17/2007 - Added sharing



create or replace package wwv_flow_webpage
as

procedure create_region_links (
    p_webpage_id  in number,
    p_region_id   in number,
    p_link_01     in varchar2 default null,
    p_target_01   in varchar2 default null,
    p_link_02     in varchar2 default null,
    p_target_02   in varchar2 default null,
    p_link_03     in varchar2 default null,
    p_target_03   in varchar2 default null,
    p_link_04     in varchar2 default null,
    p_target_04   in varchar2 default null
    );

procedure create_webpage (
    p_name        in varchar2,
    p_folder_id   in number   default null,
    p_sharing     in varchar2 default 'AVAILABLE_FOR_OWNER',
    p_region_name in varchar2 default null,
    p_link_01     in varchar2 default null,
    p_target_01   in varchar2 default null,
    p_link_02     in varchar2 default null,
    p_target_02   in varchar2 default null,
    p_link_03     in varchar2 default null,
    p_target_03   in varchar2 default null
    );

procedure show_page (
    p_page_id     in number
    );	


procedure show_region (
    p_page_id     in number,
	p_position    in varchar
    );

procedure show_list ( 
		p_page_id		in number, 
		p_app_user		in varchar2,
		p_region_id		in varchar2,
		p_ok_to_edit      in boolean
	);

procedure wb_widget_html(
	p_worksheet     in varchar2 default null,
	p_col			in varchar2 default null,
	p_col_state     in varchar2 default null,
	p_filter		in varchar2 default null
);

end wwv_flow_webpage;
/
show errors;

