set define '^'
set verify off
prompt ...wwv_flow_xliff


Rem  Copyright (c) Oracle Corporation 2001. All Rights Reserved.
Rem
Rem    NAME
Rem      wwv_flow_xliff.sql
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem
Rem    INTERNATIONALIZATION
Rem      unknown
Rem
Rem    MULTI-CUSTOMER
Rem      unknown
Rem
Rem    SCRIPT ARGUMENTS
Rem      None
Rem
Rem    RUNTIME DEPLOYMENT: YES
Rem
Rem    MODIFIED    (MM/DD/YYYY)
Rem      jkallman   05/03/2002 - Created
Rem      jkallman   06/18/2002 - Added apply_xliff_translations
Rem      jkallman   10/02/2002 - Added apply_xliff_file
Rem      jkallman   05/13/2003 - Added support for g_include_target to include target elements on-demand (per WPTG)
Rem      jkallman   07/28/2003 - Add support for download of only those strings requiring translation via p_include_all (Bug 3011738)
Rem      jkallman   05/30/2006 - Add p_item_help parameter for generation of internal translations
Rem      jkallman   06/01/206  - Added get_translation_document


create or replace package wwv_flow_xliff as


procedure generate_translation_document(
    p_flow_id             in number,
    p_page_id             in number default null,
    p_translation_flow_id in number,
    p_include_target      in varchar2 default 'N',
    p_include_all         in varchar2 default 'N',
    p_item_help           in varchar2 default null );

procedure print_translation_document(
    p_flow_id             in number,
    p_page_id             in number default null,
    p_translation_flow_id in number,
    p_include_target      in varchar2 default 'N',
    p_include_all         in varchar2 default 'N',
    p_download            in varchar2 default 'Y',
    p_item_help           in varchar2 default null );

procedure apply_xliff_translations(
    p_flow_id             in number,
    p_translation_flow_id in number,
    p_clob                in clob );

procedure apply_xliff_file(
    p_flow_id             in number,
    p_translation_flow_id in number,
    p_file_id             in number );
    
function get_translation_document(
    p_flow_id             in number,
    p_page_id             in number default null,
    p_translation_flow_id in number,
    p_include_target      in varchar2 default 'N',
    p_include_all         in varchar2 default 'N',
    p_item_help           in varchar2 default null )
return blob;

end wwv_flow_xliff;
/


