// Util.java

import java.io.*;

public class Util
{
  public static byte[] serializeObject (Object obj)
       throws IOException
  {
    if (obj == null) return null;
    ByteArrayOutputStream ostream = new ByteArrayOutputStream ();
    ObjectOutputStream p = new ObjectOutputStream (ostream);
    p.writeObject (obj);
    p.flush ();
    return ostream.toByteArray ();
  }

  public static Object deserializeObject (byte[] bytes)
       throws IOException, ClassNotFoundException
  {
    if (bytes == null) return null;
    InputStream istream = new ByteArrayInputStream (bytes);
    return new ObjectInputStream (istream).readObject ();
  }
}
