#!/bin/sh
#
# $Header: ldap/schema/oid/create_default_subscriber.sh /main/7 2009/05/25 14:20:34 fwu Exp $
#
# create_default_subscriber.sh
#
# Copyright (c) 2002, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      create_default_subscriber.sh : creates the default subscriber
#
#    DESCRIPTION
#      This script creates the default subscriber including the parent
#       of the subscriber. Using this script you can create a DIT that
#       is two levels deep with the second node representing the subscriber.
#      For example: o=oracle,dc=com or dc=acme,dc=com.
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    fwu           05/22/09 - Revert ldifmigrator.bat changes
#    ntregres      05/14/09 - Fix 8497498
#    fwu           12/28/06 - Use ldifmigrator from SRCHOME until bug 5734836
#                             fixed
#    sshrivas      07/11/02 - New Substitution variable
#    jwei          04/24/02 - fix for whitespace in subscriber name 
#    stlee         04/08/02 - stlee_bug-2310185
#    akolli        04/01/02 - Creation

usage() {

cat << USAGE_MESSAGE
usage: ${0} -host <host> -port <port>
            -SubscriberName <SubscriberName>
            -SubscriberNamingAttribute <SubscriberNamingAttribute>
            -SubscriberObjectclass <SubscriberObjectclass>
            -SubscriberParent1Name <SubscriberParent1Name>
	    -SubscriberParent1NamingAttribute <SubscriberParent1NamingAttribute>
	    -SubscriberParent1Objectclass <SubscriberParent1Objectclass>
            -CurrentUserDN <CurrentUserDN>
            -CurrentUserPassword <CurrentUserPassword>
             

mandatory arguments:
  None. All arguments can be defaulted.

Default values are:
  host: $HOST
  port: 389
  SubscriberName: oracle
  SubscriberNamingAttribute: o
  SubscriberObjectclass: organization
  SubscriberParent1Name: com
  SubscriberParent1NamingAttribute: dc
  SubscriberParent1Objectclass: domain
  CurrentUserDN: cn=orcladmin
  CurrentUserPassword: welcome
USAGE_MESSAGE
}

host=$HOST
port=389
SubscriberName="oracle"
SubscriberNamingAttribute="o"
SubscriberObjectclass="organization"
SubscriberParent1Name="com"
SubscriberParent1NamingAttribute="dc"
SubscriberParent1Objectclass="domain"
CurrentUserDN="cn=orcladmin"
CurrentUserPassword="welcome"

# parce command line input
while [ $# -gt 0 ] ; do
  case $1 in

    -host) host=$2;
      if [ -z "${host}" ] ; then
         host=$HOST ;
      else
         shift;
      fi;;

    -port) port=$2;
      if [ -z "${port}" ] ; then
         port="389" ;
      else
         shift;
      fi;;

    -SubscriberName) SubscriberName=$2;
      if [ -z "${SubscriberName}" ] ; then
         SubscriberName="oracle" ;
      else
         shift;
      fi;;

    -SubscriberNamingAttribute) SubscriberNamingAttribute=$2;
      if [ -z "${SubscriberNamingAttribute}" ] ; then
         SubscriberNamingAttribute="o" ;
      else
         shift;
      fi;;

    -SubscriberObjectclass) SubscriberObjectclass=$2;
      if [ -z "${SubscriberObjectclass}" ] ; then
         SubscriberObjectclass="organization" ;
      else
         shift;
      fi;;

    -SubscriberParent1Name) SubscriberParent1Name=$2;
      if [ -z "${SubscriberParent1Name}" ] ; then
         SubscriberParent1Name="com" ;
      else
         shift;
      fi;;

    -SubscriberParent1NamingAttribute) SubscriberParent1NamingAttribute=$2;
      if [ -z "${SubscriberParent1NamingAttribute}" ] ; then
         SubscriberParent1NamingAttribute="dc" ;
      else
         shift;
      fi;;

    -SubscriberParent1Objectclass) SubscriberParent1Objectclass=$2;
      if [ -z "${SubscriberParent1Objectclass}" ] ; then
         SubscriberParent1Objectclass="domain" ;
      else
         shift;
      fi;;

    -CurrentUserDN) CurrentUserDN=$2;
      if [ -z "${CurrentUserDN}" ] ; then
         CurrentUserDN="cn=orcladmin" ;
      else
         shift;
      fi;;

    -CurrentUserPassword) CurrentUserPassword=$2;
      if [ -z "${CurrentUserPassword}" ] ; then
         CurrentUserPassword="welcome" ;
      else
         shift;
      fi;;

    -help) usage ; exit 1 ;;

    *) echo "$1 Not Found " ; usage ; exit 2 ;;

  esac
  shift
done

# setup other variables
SubscriberParentDN="$SubscriberParent1NamingAttribute=$SubscriberParent1Name"
SubscriberDN="$SubscriberNamingAttribute=$SubscriberName,$SubscriberParentDN"
RootOracleContextDN="cn=oraclecontext"
OracleContextDN="cn=oraclecontext,$SubscriberDN"
OracleContextParentDN="$SubscriberDN"
groupSearchBase="cn=groups,$SubscriberDN"

echo "Creating default subscriber: " $SubscriberName
flat_sbs_name="$SubscriberName.flt"
ldif_file_name="$SubscriberName.ldif"

# remove the flat sbs file just in case
rm -f "$flat_sbs_name"
perl flattenlst.pl -i oidDefaultSubscriberCreate.lst -o "$flat_sbs_name"

echo "Performing variable substitution for subscriber..."
# remove the ldif file just in case
rm -f "$ldif_file_name"
# run the ldifmigrator to get the substituted data file
$SRCHOME/bin/ldifmigrator input_file="$flat_sbs_name" \
                             output_file="$ldif_file_name" \
   s_SubscriberParent1Objectclass="$SubscriberParent1Objectclass" \
   s_SubscriberParent1NamingAttribute="$SubscriberParent1NamingAttribute" \
   s_SubscriberParent1Name="$SubscriberParent1Name" \
   s_SubscriberObjectclass="$SubscriberObjectclass" \
   s_SubscriberNamingAttribute="$SubscriberNamingAttribute" \
   s_SubscriberName="$SubscriberName" \
   s_SubscriberParentDN="$SubscriberParentDN" \
   s_SubscriberDN="$SubscriberDN" \
   s_RootOracleContextDN="$RootOracleContextDN" \
   s_OracleContextDN="$OracleContextDN" \
   s_OracleContextParentDN="$OracleContextParentDN" \
   s_CurrentUserDN="$CurrentUserDN" \
   s_GroupSearchBase="$groupSearchBase"
   

ldifmigret=$?
if [ $ldifmigret -ne 0 ] ; then
  echo "LDIF substitution failed with error code $ldifmigret.";
  exit  $ldifmigret;
fi

# load the subscriber into OID
echo "loading subscriber data into OID..."
log_file_name="$SubscriberName.log"
err_file_name="$SubscriberName.err"
rm -f "$log_file_name"
rm -f "$err_file_name"
$ORACLE_HOME/bin/ldapmodify -h $host -p $port -D $CurrentUserDN -w $CurrentUserPassword -o "$err_file_name" -v -c -f  "$ldif_file_name" > "$log_file_name" 2>&1

ldapmodret=$?
if [ $ldapmodret -ne 0 ] ; then
  echo "ldapmodify returned error code $ldapmodret.";
  exit  $ldapmodret;
fi

# return success
exit 0
 
