#!/usr/local/bin/perl
# 
# $Header: host.pl 13-jul-2005.12:17:44 xuliu Exp $
#
# host.pl
# 
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#    NAME
#      host.pl - <one-line expansion of the name>
#    creates a host target with just name and type.
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    xuliu       07/13/05 - CLUSTER_NAME
#    xuliu       05/11/05 - OMSENV_CLUSTER_NAME: bug 4346269 
#    hying       01/07/05 - use AssocTargetInstance 
#    xuliu       12/03/04 - csrhome warning 
#    xuliu       11/08/04 - use new getClusterName() 
#    xuliu       10/26/04 - CRSHome -> OracleHome 
#    xuliu       06/28/04 - CRSHome
#    xuliu       11/05/03 - use getClusterName() 
#    ysun        08/05/03 - add association
#    ysun        01/29/03 - support cluster discovery
#    kduvvuri    07/15/02 - kduvvuri_bug-2442426_main
#    kduvvuri    07/12/02 - Creation
# 

($emdRoot,$hostName,$crsHome) = @ARGV;
require "$emdRoot/sysman/admin/scripts/semd_common.pl";

print "<Targets>\n";
nmep_printHostTarget();
print "</Targets>\n";

sub nmep_printHostTarget {
  # This should never happen.
  if ( (! defined $hostName ) || (!defined $emdRoot) ) {
    #TODO, log an error message that we can not proceed
    return;
  }

  if (defined $ENV{OMSENV_CRS_HOME})
  {
    $crsHome = $ENV{OMSENV_CRS_HOME};
    my $oldOH = $ENV{ORACLE_HOME};
    $ENV{ORACLE_HOME} = $crsHome;
    `$crsHome/bin/cemutlo -n 2>&1`;
    $ENV{ORACLE_HOME} = $oldOH;
    if ($?)
    {
        print "<DiscoveryWarning DISCOVERY_SCRIPT=\"INVALID_CRSHOME\"/>\n";
    }    
  }  

  ($clusterName, $crsHome) = getClusterName($emdRoot, $crsHome);
  

  if (defined $ENV{CLUSTER_NAME} && $ENV{CLUSTER_NAME} ne '')
  {
    $clusterName = $ENV{CLUSTER_NAME};
  }
  
  if ( $clusterName ne '') {
      print "  <Target TYPE=\"cluster\" NAME=\"$clusterName\" >\n";

      if ($crsHome ne "")
      {
          print "    <Property NAME=\"OracleHome\" VALUE=\"$crsHome\"/>\n";
      }
      
      print "  </Target>\n"
  }
  
  print "  <Target TYPE=\"host\" NAME=\"$hostName\" >\n";
    if ( $clusterName ne '') {
        print "    <AssocTargetInstance ASSOCIATION_NAME=\"cluster_instance\" ASSOC_TARGET_TYPE=\"cluster\" ASSOC_TARGET_NAME=\"$clusterName\"/>\n";
        print "    <CompositeMembership>\n";
        print "    <MemberOf TYPE=\"cluster\" NAME=\"$clusterName\" ASSOCIATION=\"cluster_member\" />\n";
        print "    </CompositeMembership>\n";
    }
  print "  </Target>\n";
}

