---------------------------------------------
-- This script is to grant privileges dbsnmp.
---------------------------------------------

set serveroutput on;
set echo on;

-----------------------------
-- Make sure DBSNMP exist
-----------------------------
prompt ... Make sure DBSNMP user exist ...
prompt ...

DECLARE
   v    varchar2(300);
   version    VARCHAR2(20);
   compat     VARCHAR2(20);
BEGIN 
   v := 'create user DBSNMP identified by &&dbm_password';
   execute immediate v;
   v := 'grant CONNECT to DBSNMP';	
   execute immediate v;
EXCEPTION
  WHEN others THEN
   dbms_output.put_line('User DBSNMP exists');
END;
/

-----------------------------
-- Grant privileges to DBSNMP
-----------------------------
prompt ... Grant privileges to DBSNMP user ...
prompt

whenever sqlerror continue

/*  System privileges  */
grant create table                to DBSNMP;
grant create procedure            to DBSNMP;
grant create sequence             to DBSNMP;
grant create type                 to DBSNMP;
grant unlimited tablespace        to DBSNMP;
 

disconnect

