Rem  Copyright (c) Oracle Corporation 1999 - 2007. All Rights Reserved.
Rem
Rem    NAME
Rem      apxdvins.sql
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem      Assumes the SYS user is connected.
Rem
Rem    REQUIRENTS
Rem      - Oracle Database 9.2.0.3 or later
Rem
Rem    Example:
Rem
Rem    1)Local
Rem      sqlplus "sys/syspass as sysdba" @apxdvins
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      jstraub   07/11/2007 - Created
Rem      jkallman  08/02/2007 - Change FLOWS_030000 references to FLOWS_030100
Rem      jstraub   09/14/2007 - Added spool off and SQL prompt ending
Rem      jstraub   12/20/2007 - Added logic to exit if not connected as SYSDBA
Rem      jstraub   02/08/2008 - Added alter session set nls_length_semantics = byte
Rem      jkallman  09/09/2008 - Change FLOWS_030100 references to APEX_030200

alter session set nls_length_semantics = byte;

prompt .  ____   ____           ____        ____
prompt . /    \ |    \   /\    /     |     /
prompt .|      ||    /  /  \  |      |    |
prompt .|      ||---    ----  |      |    |---

prompt .|      ||   \  /    \ |      |    |
prompt . \____/ |    \/      \ \____ |____ \____
prompt .
prompt . Application Express Installation.
prompt ...................................


set define '^'
set concat on
set concat .
set verify off
set termout off
spool off
set termout on

Rem
Rem  Check that user has SYSDBA privilege before proceeding
Rem

set termout off

define foo2 = 'NOSYSDBA'
column foo new_val foo2

select privilege foo from session_privs where privilege = 'SYSDBA';
set termout on

whenever sqlerror exit
set serveroutput on
begin
    if '^foo2' = 'NOSYSDBA' then
        dbms_output.put_line('Application Express installation requires a connection with the SYSDBA privilege.');
        execute immediate 'bogus statement to force exit';
    end if;
end;
/
whenever sqlerror continue

column foo3 new_val LOG1

select 'installdev'||to_char(sysdate,'YYYY-MM-DD_HH24-MI-SS')||'.log' foo3 from dual;

define LOG2 = ^LOG1.english.log
define LOG3 = ^LOG1.english.bad
spool ^LOG1
define UPGRADE = '1'

define INSTALL_TYPE = 'ADD_DEV'

define APPUN = 'APEX_030200'
define ADM_PWD = 'x'

column foo2 new_val UPGRADE

select '2' foo2 from dba_users where (username in ('FLOWS_030100','FLOWS_030000','FLOWS_020200','FLOWS_020100','FLOWS_020000','FLOWS_010600','FLOWS_010500')) and rownum = 1;

define DATTS     = 'x'
define FF_TBLS   = 'x'
define TEMPTBL   = 'x'

column :img_prefix new_value IMGPR NOPRINT
variable img_prefix varchar2(30)
begin
    :img_prefix := ^APPUN..wwv_flow_global.g_image_prefix;
end;
/
select :img_prefix from dual;

define DB_VERSION = '10'
define PREFIX     = '@'

@@devins.sql ^LOG1 ^UPGRADE ^APPUN ^TEMPTBL ^IMGPR ^DATTS ^FF_TBLS ^ADM_PWD ^PREFIX

spool off

timing stop

column global_name new_value gname
set termout off
select user global_name from dual;
set termout on
set heading on
set feedback on
set sqlprompt '^gname> '

exit
