Rem
Rem
Rem apxldimg.sql
Rem
Rem Copyright (c) 2004,2007, Oracle Corporation.  All rights reserved.
Rem
Rem    NAME
Rem      apxldimg.sql - Application Express Load Images
Rem
Rem    DESCRIPTION
Rem      This script should be run as SYS and takes one argument, the path
Rem      to the directory where the Application Express software exists on
Rem      the filesystem. The script will load the images into XDB.
Rem
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem     jstraub    05/22/2007 - Created
Rem     jkallman   06/26/2007 - Always upload doc_map.xml encoded as AL32UTF8
Rem     jstraub    08/27/2007 - Altered for 11g
Rem     jstraub    11/21/2007 - Added setting anonymous ACL for /images directory resources for 11g
Rem     jstraub    04/07/2008 - Corrected comments in the description
Rem     jkallman   01/09/2009 - Load all JA online help files with .xml extension as AL32UTF8 (Bug 7700562)
Rem     jkallman   01/09/2009 - Delete incorrectly encoded files in JA online help (Bug 7700562)
Rem     jkallman   07/01/2009 - Change JA16SJIS charset reference to AL32UTF8 to account for Japanese online help encoding
Rem

timing start "Load Images"

begin
    execute immediate 'drop directory APEX_IMAGES';
exception when others then
    null;
end;
/

create directory APEX_IMAGES as '&1/apex/images';

set serveroutput on

declare
    file_list               varchar2(30) default 'imagelist.xml';
    upload_directory_name   varchar2(30) default 'APEX_IMAGES';
    repository_folder_path  varchar2(30);
    pathseperator varchar2(1) := '/';

    directory_path      varchar2(256);

    target_folder_path  varchar2(256);
    target_file_path    varchar2(256);
    target_file_name    varchar2(256);

    resource_path       varchar2(256);

    filelist_xml        xmltype := xmltype(bfilename(upload_directory_name,file_list),nls_charset_id('AL32UTF8'));
    content_bfile       bfile;

    result              boolean;

    filelist_dom    dbms_xmldom.domdocument;
    files_nl        dbms_xmldom.domnodelist;
    directory_nl    dbms_xmldom.domnodelist;
    filename_nl     dbms_xmldom.domnodelist;
    files_node      dbms_xmldom.domnode;
    directory_node  dbms_xmldom.domnode;
    file_node       dbms_xmldom.domnode;
    text_node       dbms_xmldom.domnode;
    l_mv_folder     varchar2(30);

begin

  if wwv_flow_utilities.db_version_is_at_least('11') then
    repository_folder_path := '/images/';
  else
    repository_folder_path := '/i/';
  end if;

  if dbms_xdb.existsresource(repository_folder_path) then

    for c1 in (select to_char(sysdate,'YYYYMMDDHH24MI') x from dual) loop
        l_mv_folder := substr(repository_folder_path,2,instr(repository_folder_path,'/',-1)-2)||'_'||c1.x;
    end loop;

    dbms_xdb.renameresource(repository_folder_path,'/',l_mv_folder);

  end if;

  result          := dbms_xdb.createfolder(repository_folder_path);

  -- create the set of folders in the xdb repository

  filelist_dom := dbms_xmldom.newdomdocument(filelist_xml);

  directory_nl := dbms_xmldom.getelementsbytagname(filelist_dom,'directory');

  for i in 0 .. (dbms_xmldom.getlength(directory_nl) - 1) loop
    directory_node := dbms_xmldom.item(directory_nl,i);
    text_node      := dbms_xmldom.getfirstchild(directory_node);
    directory_path := dbms_xmldom.getnodevalue(text_node);
    directory_path := repository_folder_path || directory_path;
    result          := dbms_xdb.createfolder(directory_path);
  end loop;

    -- load the resources into the xml db repository

  files_nl           := dbms_xmldom.getelementsbytagname(filelist_dom,'files');
  files_node         := dbms_xmldom.item(files_nl,0);

  filename_nl := dbms_xmldom.getelementsbytagname(filelist_dom,'file');

  for i in 0 .. (dbms_xmldom.getlength(filename_nl) - 1) loop
    file_node          := dbms_xmldom.item(filename_nl,i);

    text_node          := dbms_xmldom.getfirstchild(file_node);

    target_file_path   := dbms_xmldom.getnodevalue(text_node);
    target_file_name   := substr(target_file_path,instr(target_file_path,pathseperator,-1)+1);
    target_folder_path := substr(target_file_path,1,instr(target_file_path,pathseperator,-1));
    target_folder_path := substr(target_folder_path,instr(target_folder_path,pathseperator));
    target_folder_path := substr(target_folder_path,1,length(target_folder_path)-1);
    resource_path := repository_folder_path || target_folder_path || '/' || target_file_name;

    begin
    content_bfile := bfilename(upload_directory_name,target_file_path);
    if instr(target_file_path,'/doc/ja/') = 1 and target_file_name not like '%.xml' then
        result := dbms_xdb.createresource(resource_path,content_bfile,nls_charset_id('AL32UTF8'));
    else
        result := dbms_xdb.createresource(resource_path,content_bfile,nls_charset_id('AL32UTF8'));
    end if;
    exception when others then
        dbms_output.put_line('file not found: '||target_file_path);
    end;

  end loop;


end;
/


--
-- During an upgrade of Application Express, the previous images directory is copied and renamed.  There are
-- resources in the images directory shipped with Application Express 3.0 and DB 11.1.0.6 which were marked as
-- encoded in Shift JIS when, in fact, they were encoded in utf-8.  Locate these resources and delete them.
--
begin
    for c1 in (select any_path
      from xdb.resource_view
     where any_path like '/images_200%'
       and (any_path like '%ja/toc.xml' or any_path like '%ja/TDPAX/toc.xml')
       and extractvalue(res,'/Resource/CharacterSet/text()') = 'SHIFT_JIS') loop
        --
        dbms_xdb.deleteresource( abspath => c1.any_path, delete_option => dbms_xdb.delete_force );
    end loop;
    --
    commit;
end;
/


Rem Creates a new ACL for "/images" and give ANONYMOUS read-only access to it,
Rem ACL for the root folder and gives ANONYMOUS read access to it also

declare
  ro_anonymous_acl   varchar2(80) := '/sys/acls/ro_anonymous_acl.xml';

  procedure publish_folder(folder varchar2, acl varchar2) is
  begin
    for r in (select r.any_path path
                from resource_view r
               where under_path(r.res, folder) = 1 or
                     equals_path(r.res, folder) = 1) loop
      dbms_xdb.setACL(r.path, acl);
    end loop;
  end;

begin

  if wwv_flow_utilities.db_version_is_at_least('11') then --11g only

    if not dbms_xdb.existsResource(ro_anonymous_acl) and
      (not dbms_xdb.createResource(ro_anonymous_acl,
            XMLType('<acl description="Read-only privileges to anonymous"
                          xmlns="http://xmlns.oracle.com/xdb/acl.xsd"
                          xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                          xsi:schemaLocation="http://xmlns.oracle.com/xdb/acl.xsd
                          http://xmlns.oracle.com/xdb/acl.xsd">
                       <ace>
                         <grant>true</grant>
                         <principal>ANONYMOUS</principal>
                         <privilege>
                           <read-properties/>
                           <read-contents/>
                           <resolve/>
                         </privilege>
                       </ace>
                     </acl>'))) then
      raise program_error;
    end if;
    publish_folder('/images', ro_anonymous_acl);

    if (not dbms_xdb.changePrivileges('/',
                 XMLType('<ace xmlns="http://xmlns.oracle.com/xdb/acl.xsd"
                          xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                          xsi:schemaLocation="http://xmlns.oracle.com/xdb/acl.xsd
                          http://xmlns.oracle.com/xdb/acl.xsd">
                            <grant>true</grant>
                            <principal>ANONYMOUS</principal>
                            <privilege>
                              <read-properties/>
                              <resolve/>
                            </privilege>
                          </ace>')) > 0) then
      raise program_error;
    end if;

  end if;
end;
/

commit;

timing stop

drop directory APEX_IMAGES;

