Rem  Copyright (c) Oracle Corporation 1999 - 2007. All Rights Reserved.
Rem
Rem    NAME
Rem      coreins.sql
Rem
Rem    DESCRIPTION
Rem      This is the primary installation script for Oracle APEX, but this should never be invoked directly.
Rem      This file should only be invoked by apexins.sql, the primary installation script for APEX.
Rem
Rem    NOTES
Rem      Ensure that all arguments (except image prefix) are entered in UPPERCASE.
Rem
Rem    REQUIREMENTS
Rem      - Oracle database 9.2.0.3 or better
Rem      - PL/SQL Web Toolkit
Rem
Rem    Arguments:
Rem      1 - LOG1      = Installation log file
Rem      2 - UPGRADE   = Upgrade flag (1 = NO, 2 = YES)
Rem      3 - APPUN     = APEX schema name
Rem      4 - TEMPTBL   = Temporary tablespace
Rem      5 - IMGPR     = Image prefix
Rem      6 - DATTS     = APEX tablespace
Rem      7 - FF_TBLS   = APEX files tablespace
Rem      8 - ADM_PWD   = APEX administrator password
Rem
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      mhichwa   08/14/2000 - Created
Rem      mhichwa   08/15/2000 - Added update of wwv_flows owner to install owner
Rem      mhichwa   08/24/2000 - Added lov function
Rem      mhichwa   08/25/2000 - Added grant on flow_utilities to public
Rem      mhichwa   09/03/2000 - Added audit.sql
Rem      mhichwa   09/04/2000 - Added shortcut.sql and .plb
Rem      mhichwa   09/25/2000 - Removed sys info from calls to sub programs
Rem      mhichwa   09/29/2000 - Added java
Rem      mhichwa   09/30/2000 - Added create procedure grant
Rem      mhichwa   10/19/2000 - Create user with APPPW password
Rem      mhichwa   10/24/2000 - Changed javachart.plb to .sql
Rem      mhichwa   10/24/2000 - Added wwv_flow_rewrite_query
Rem      mhichwa   10/25/2000 - Added temp_table_init
Rem      jkallman  11/01/2000 - Added wwv_flow_mail
Rem      mhichwa   11/01/2000 - Added core/wwv_flow_page_cache.sql
Rem      mhichwa   11/02/2000 - Reorganize caching tables package and body
Rem      mhichwa   11/08/2000 - Fixed link
Rem      mhichwa   11/11/2000 - Added view on v$session
Rem      mhichwa   11/12/2000 - Added additional grants from sys to flows
Rem      mhichwa   12/01/2000 - Added flows 4100, 4200, 4300, 4400, 4500
Rem      mhichwa   12/10/2000 - Added flow 4450
Rem      mhichwa   12/12/2000 - Added gen_trans.sql
Rem      mhichwa   12/12/2000 - Changed reference of wwv_flow_java_chart to javachart.sql
Rem      mhichwa   12/15/2000 - Added additional sys grants
Rem      mhichwa   12/21/2000 - Added file_mgr
Rem      mhichwa   12/21/2000 - Added f4600.sql
Rem      mhichwa   01/16/2001 - Added wwv_flow_gen_global_api spec and body and platform_tabs.sql
Rem      mhichwa   01/17/2001 - Added obj$ grant to flows
Rem      mhichwa   01/18/2001 - Added grant all on wwv_flow_file_objects$ to PUBLIC
Rem      jstraub   01/23/2001 - Removed grant drop procedure - privelage does not exist
Rem      mhichwa   01/23/2001 - Added provisioning_tables.sql
Rem      mhichwa   01/24/2001 - Added wwv_apply_configuration.sql
Rem      mhichwa   01/26/2001 - removed duplicate audit.sql added dynsql.sql
Rem      mhichwa   01/31/2001 - Added f4900
Rem      mhichwa   02/05/2001 - Added p.sql
Rem      mhichwa   02/05/2001 - Added f4950
Rem      mhichwa   02/16/2001 - Moved dynsql.sql
Rem      mhichwa   02/16/2001 - Added f4050
Rem      jkallman  02/19/2001 - Added auth.sql before tab.sql
Rem      mhichwa   02/20/2001 - Added wizard.sql and wizard.plb
Rem      mhichwa   02/21/2001 - Added f4700
Rem      mhichwa   02/21/2001 - Added f4650
Rem      sdillon   02/23/2001 - Added provisioning api
Rem      sdillon   02/23/2001 - Added many sys & object privs with admin option for provisioning
Rem      mhichwa   02/23/2001 - Added provision.sql
Rem      mhichwa   02/25/2001 - Added db_auth_tables.sql
Rem      jstraub   02/28/2001 - Added trigger.sql
Rem      sdillon   03/01/2001 - Added wwv_flow_job api for submitting processes to dbms_job
Rem      jstraub   03/01/2001 - Added grant on wwv_flow_lov_temp to PUBLIC
Rem      mhichwa   03/01/2001 - Added default temporary tablespace to creation script
Rem      mhichwa   03/02/2001 - Added wwv_flow_item
Rem      mhichwa   03/02/2001 - Added removed prompt for index tablespace
Rem      mhichwa   03/02/2001 - Changed name of flow_job to flowjob
Rem      mhichwa   03/04/2001 - Added flowjob.ddl
Rem      mhichwa   03/04/2001 - Added platform.sql
Rem      mhichwa   03/04/2001 - Added flow 4150 dbol
Rem      sdillon   03/05/2001 - Fixed alter user default temp tblspc bug
Rem      mhichwa   03/07/2001 - Added public syn
Rem      mhichwa   03/08/2001 - Added wwv_flow_init_htp_buffer public syn
Rem      mhichwa   03/09/2001 - Added V_$SESSION grant and added an additional public syn
Rem      mhichwa   03/12/2001 - Added tree
Rem      sdillon   03/15/2001 - Added plsqljob.sql,plb; removed flowjob.ddl (moved to tab.sql)
Rem      sdillon   03/15/2001 - Added grant execute on dbms_lock to flows
Rem      tmuth     03/14/2001 - Added public syn WWV_RENDER_REPORT2
Rem      mhichwa   03/17/2001 - Moved job above v to avoid compile error on v
Rem      mhichwa   03/17/2001 - Added drop public syn that were missing
Rem      mhichwa   03/18/2001 - Added wizapi
Rem      sdillon   03/19/2001 - Added wwv_flow_debug
Rem      mhichwa   03/19/2001 - Added flow 4250 for help text editing
Rem      mhichwa   03/20/2001 - Added cookie users and db auth user mapping for flows user
Rem      sleuniss  03/20/2001 - Added wwv_flow_csv_data table ddl
Rem      sleuniss  03/20/2001 - Added wwv_flow_load_data .sql and .plb
Rem      mhichwa   03/21/2001 - Added core home
Rem      sdillon   03/22/2001 - Granted exec on dbms_random
Rem      mhichwa   03/22/2001 - Added f4350, f4550, removed home from builder dir
Rem      mhichwa   03/26/2001 - Do not install flows 1000, 4200 and 4100.
Rem      sdillon   03/30/2001 - Added platdemo.sql (wwv_flow_demo)
Rem      mhichwa   03/30/2001 - Added execute any procedure priv to sys grants
Rem      sleuniss  03/31/2001 - Added demo.sql
Rem      mhichwa   04/05/2001 - Added repurposed f4100.sql and generic login.sql
Rem      jkallman  04/09/2001 - Added public syn for WWV_FLOW_SESSION_SEQ
Rem      jstraub   04/09/2001 - Added install for new f4200 - Web Calendar Environment Administration
Rem      mhichwa   04/09/2001 - Added provision.plb
Rem      mhichwa   04/09/2001 - Commented out grant on sys dbms random because it is not gernic oracle
Rem      mhichwa   04/09/2001 - Moved random below sequence creation to avoid install error
Rem      mhichwa   04/10/2001 - Added drop public syn added set define before tab sql
Rem      mhichwa   04/12/2001 - Added tree3 sql and plb
Rem      mhichwa   04/13/2001 - Added gen_demo.sql
Rem      mhichwa   04/18/2001 - Added f4955_demo.sql
Rem      mhichwa   04/19/2001 - Fixed update flow owner to allow install in schema other then flows
Rem      sdillon   04/25/2001 - Added capability for FLOWS user to grant java file.io.FilePermission
Rem      sdillon   05/01/2001 - Added image functionality, and the crypt package for MD5 hashing
Rem      sdillon   05/11/2001 - Fixed java.io.FilePermission grant, by wrapping quotes around ^P_IMG_DIR
Rem      sdillon   05/11/2001 - Moved crypt.sql & plb BEFORE trigger.sql due to dependency rqmts
Rem      sdillon   05/11/2001 - Commented insert into wwv_flow_db_auth. That insert is already in db_auth_tables.sql
Rem      sleuniss  05/15/2001 - removed duplicate grant_policy from dbms java grants
Rem      sdillon   05/15/2001 - Added fileapi and cssapi specs & bodies
Rem      sdillon   05/24/2001 - Fixed dbms_java.grant_permission call for P_IMG_DIR grant
Rem      mhichwa   05/24/2001 - Added wwv flow fnd user api
Rem      mhichwa   05/24/2001 - Added html apis
Rem      sdillon   06/04/2001 - Granted select on dba_tab_columns & dba_objects to ^APPUN, created pub syn wwv_flow_files
Rem      mhichwa   06/07/2001 - Added flow user api and trans util spec
Rem      mhichwa   06/08/2001 - Moved translation above seed to avoid ins errors per sdillon instruction
Rem      mhichwa   06/19/2001 - Added runtime company id preference (flow runtime configuration setting)
Rem      mhichwa   06/20/2001 - Changed comments
Rem      mhichwa   06/26/2001 - Changed order of api.sql to occur before create tables
Rem      mhichwa   06/26/2001 - Added RTCN (runtime company name) and RTS (runtime schema)
Rem      mhichwa   06/26/2001 - Changed order of fileapi.sql
Rem      mhichwa   06/28/2001 - Added additional public synonym (moved from create scripts)
Rem      mhichwa   06/29/2001 - Removed extra semicolon on creation of runtime company
Rem      mhichwa   06/29/2001 - Moved flows 4100 and 4750 (runtime flows) to the core directory
Rem      mhichwa   07/02/2001 - Changed one of the two synonym scripts to be remove_synonyms.sql
Rem      mhichwa   07/02/2001 - Added wwv_flow_template_api
Rem      mhichwa   07/03/2001 - Added wwv_flow_upgrade
Rem      mhichwa   07/23/2001 - Added flows version
Rem      mhichwa   07/26/2001 - Remove drop synonyms
Rem      jstraub   08/08/2001 - Corrected SYS connect string for 9i compatability
Rem      tmuth     08/08/2001 - Added wwv_flow_upgrade_report
Rem      mhichwa   08/21/2001 - Merged apps tab.sql into tab.sql
Rem      jstraub   08/21/2001 - Removed reference to db_auth_tables since it merged into tab.sql
Rem      mhichwa   09/19/2001 - Added ask us url link
Rem      cbcho     09/20/2001 - Added alter database priv to flows owner
Rem      cbcho     09/21/2001 - Added grant select on v_$parameter to flows owner
Rem      mhichwa   09/21/2001 - Removed f4900
Rem      cbcho     09/27/2001 - Added 9i system privilege, grant select any dictionary to flows owner.
Rem      tmuth     09/28/2001 - Removed inline creation of push_mail_queue job and added call to dbms_jobs.sql
Rem      ---------------------------------------------------------------------------------------------------------------------------------------
Rem      tmuth     10/09/2001 - Made many changes to eliminate localins.sql and rtins.sql etc.  This is a major revision point in the installer.
Rem      tmuth     10/09/2001 - Added collection.sql and collection.plb
Rem      jstraub   10/10/2001 - Automated burned in APPUN and APPPW parameters
Rem      tmuth     10/10/2001 - Replaced '' with chr(32) for ^LINK
Rem      jstraub   10/10/2001 - Added markup for auto-generated rtins support
Rem      tmuth     10/10/2001 - Moved connect info from flows_files_new(2) to ins.sql since you can't pass a null connect string
Rem      jstraub   10/11/2001 - Added wwv_flow_item.plb
Rem      tmuth     10/12/2001 - Removed comment on dictionary install
Rem      tmuth     10/12/2001 - Changed hard-coded temp tablespace.  Changed create flows_files.
Rem      tmuth     10/12/2001 - Added exception handling
Rem      tmuth     10/14/2001 - Fixed public synonym errors
Rem      tmuth     10/22/2001 - Changed NEW/UPGRADE question to a number
Rem      tmuth     10/23/2001 - Added link information at the end of installation
Rem      jstraub   10/29/2001 - Added prompts for SMTP host & port, inserted those in platform prefs table
Rem      jstraub   10/29/2001 - Added sys create any directory grant to FLOWS user
Rem      jstraub   10/29/2001 - Enclosed /* */ blocks with set termout off & on
Rem      jstraub   10/29/2001 - Added wwv_flow_runtime_dist.*
Rem      mhichwa   10/30/2001 - Added copy button procedure
Rem      jkallman  11/01/2001 - Clean up Java permissions for Windows and Unix
Rem      tmuth     11/02/2001 - Added stage.sql
Rem      tmuth     11/05/2001 - Added template_gallery.sql
Rem      cbcho     11/15/2001 - Added wwv_flow_load_excel_data.sql and wwv_flow_load_excel_data.plb
Rem      jstraub   11/15/2001 - Added z.sql to support counting clickthrus
Rem      sleuniss  11/27/2001 - Added custom_auth_api.sql and plb
Rem      tmuth     11/30/2001 - Added set termout off for 9i  specific grant
Rem      tmuth     11/30/2001 - Added upgrade instructions
Rem      tmuth     12/06/2001 - Added flow 4300 (Data Workshop) to the runtime
Rem      tmuth     12/06/2001 - Added build options for Data Workshop
Rem      tmuth     12/11/2001 - Modified Java Permissions to include dir* read
Rem      cbcho     12/13/2001 - Added sw_api.sql and plb
Rem      cbcho     12/13/2001 - Added wwv_flow_script_export.sql and plb
Rem      jstraub   12/18/2001 - Added correcting Data Workshop Login and Logout URL's
Rem      jstraub   12/18/2001 - Fixed build options for Data Workshop, need '/' after end;
Rem      tmuth     12/19/2001 - Added wwv_flow_xml_deploy and wwv_flow_xml_import
Rem      jstraub   01/14/2001 - moved app_auth.* to install in both run-time & full installation
Rem      cbcho     01/23/2002 - Added copy_metadata.sql and plb
Rem      cbcho     02/15/2002 - Added create_flow_api.sql and plb
Rem      mhichwa   02/22/2002 - Changed flows_20020101 to flows_20020301
Rem      tmuth     02/26/2002 - Changed ^LINK decode statement to handle "AS SYSDBA" for 9i, but not for 817.  In some combinations
Rem                             of 817 and different versions of SQL Plus, the installer was unable to connect.
Rem      rmattama  02/27/2002 - Added ihelp.sql and plb
Rem      tmuth     03/01/2002 - Added flows_backup
Rem      cbcho     03/04/2002 - Added copyu.sql and plb
Rem      cbcho     03/08/2002 - Added wwv_flow_admin_api.sql and plb
Rem      tmuth     03/25/2002 - Added wwv_flow_xml_report
Rem      tmuth     03/25/2002 - Fixed / direction for upgrade.sql
Rem      tmuth     03/25/2002 - Moved user to check to immediately after login info is entered to save user a lot of typing.
Rem      tmuth     03/25/2002 - Added f4850
Rem      tmuth     03/26/2002 - Added flows_files prompt
Rem      tmuth     04/03/2002 - Moved define APPUN = 'FLOWS_20020401' up
Rem      cbcho     04/04/2002 - Added wwv_flow_xml_report2.sql and plb
Rem      cbcho     04/18/2002 - Added xmlutil.sql and plb
Rem      cbcho     04/18/2002 - Added wwv_flow_dataload_xml.sql and plb
Rem      cbcho     04/18/2002 - Added create public synonym entry for sys.XSLPROCESSOR, sys.XMLDOM, sys.XMLPARSER
Rem      cbcho     04/26/2002 - Added processu.sql and plb
Rem      tmuth     05/01/2002 - Removed some questions, added question for logfile dir
Rem      tmuth     05/01/2002 - Added migrate_metadata
Rem      tmuth     05/02/2002 - Moved migrate_metadata.plb below tab.sql
Rem      tmuth     05/02/2002 - Moved migrate_metadata.plb below wwv_flow_security
Rem      tmuth     05/02/2002 - Added build options to remove data workshop
Rem      tmuth     05/03/2002 - Removed hard ref to install.lst
Rem      tmuth     05/03/2002 - Moved XSLPROCESSOR related packages to end for Mike to comment
Rem      mhichwa   05/03/2002 - Changed message
Rem      mhichwa   05/06/2002 - Added flowcon.sql and flowcon.plb
Rem      mhichwa   05/08/2002 - Added log2 and log3
Rem      tmuth     06/21/2002 - Added wwv_flow_tab_mgr
Rem      mhichwa   06/24/2002 - Changed banner
Rem      mhichwa   06/26/2002 - Added forum_demo.sql
Rem      mhichwa   06/27/2002 - Two new grants  with admin option
Rem      cbcho     06/28/2002 - Added f145_demo.sql
Rem      cbcho     07/09/2002 - Fixed bug to include wwv_flow_tab_mgr.plb
Rem      jstraub   07/10/2002 - Removed java permission grant to l_img_dir2
Rem      jstraub   07/11/2002 - Changed text for runtime install to reference Project Marvel
Rem      jkallman  07/22/2002 - Added call to set define after invocation of random.sql
Rem      jkallman  07/22/2002 - Added call to collections_showcase.sql
Rem      cbcho     07/29/2002 - Added call to wwv_flow_lookup_tables.sql
Rem      cbcho     08/02/2002 - Added call to generate_ddl.sql and .plb
Rem      cbcho     08/02/2002 - Added select_catalog_role grant to flows owner
Rem      mhichwa   08/08/2002 - Added web services package and body and tables
Rem      jstraub   08/15/2002 - Conditionally exec wwv_flow_web_services based upon db version
Rem      tmuth     08/16/2002 - Commented out call to platform_tabs.sql
Rem      jstraub   08/16/2002 - Added prompts before wwv_flow_web_services.sql
Rem      cbcho     08/19/2002 - Added comment on installing wwv_flow_dataload_xml is 9i specific
Rem      cbcho     08/19/2002 - Added comment about SYS.XSLPROCESSOR, SYS.XMLDOM, SYS.XMLPARSER grants are XML XDK dependant
Rem      mhichwa   08/22/2002 - Added f4660 (quick tour technical to install)
Rem      mhichwa   09/10/2002 - Added escape_sc function
Rem      mhichwa   09/17/2002 - Added business_look.sql, petstore.sql
Rem      cbcho     09/17/2002 - Added call to table_drill.sql and .plb
Rem      jstraub   09/17/2002 - Added presidents.sql to demonstration flows, moved collections_showcase.sql to same area
Rem      jstraub   09/17/2002 - Added grants for ctx_doc and ctx_ddl with grant option
Rem      jstraub   09/19/2002 - Added webservices.sql to demonstration flows
Rem      tmuth     10/07/2002 - Added grant select on sys.dba_ind_columns and sys.dba_sequences
Rem      cbcho     10/08/2002 - Added call to wwv_flow_svg.sql and .plb
Rem      mhichwa   10/10/2002 - Added customized
Rem      mhichwa   10/12/2002 - Added generic.sql plb
Rem      tmuth     10/14/2002 - Added ctx_ddl
Rem      jkallman  10/14/2002 - Changed script name from ctx_ddl.sql to flow_helptext_ddl.sql
Rem      tmuth     10/24/2002 - Added reports3.sql and reports3.plb
Rem      mhichwa   10/25/2002 - Added f4150.sql
Rem      tmuth     10/28/2002 - Added ctx_ddl.sync_index('WWV_HELPTEXT_IDX') after flow 4200 is installed.
Rem      tmuth     10/28/2002 - Added XLIFF to installation only when db version is 9i R2 or greater
Rem      mhichwa   10/28/2002 - Removed wwv flow java and javachart
Rem      jstraub   11/01/2002 - Added projstat.sql to demonstration flows
Rem      tmuth     11/04/2002 - Added ldap.sql and ldap.plb
Rem      tmuth     11/05/2002 - Fixed db_version statement
Rem      tmuth     11/05/2002 - Fixed 2nd db_version statement
Rem      tmuth     11/06/2002 - Changed install of ldap.sql and .plb to be dynamic based on existence of dbms_ldap
Rem      sspadafo  11/06/2002 - Added custom_auth_ldap.sql and .plb
Rem      tmuth     11/06/2002 - Made install of custom_auth_ldap.sql and .plb dynamic. Supplied ldap warning to users without dbms_ldap.
Rem      tmuth     11/07/2002 - Added pointer to doc/ldap.html
Rem      msewtz    11/13/2002 - Added wwv_flow_edit_query.sql and wwv_flow_edit_query.plb
Rem      tmuth     11/25/2002 - Added meta_cleanup and turned heading
Rem      tmuth     11/26/2002 - Changed order of upgrade and meta_cleanup
Rem      sspadafo  11/28/2002 - Added custom_auth_sso.sql and .plb conditional on existence of Portal SSO package
Rem      tmuth     12/02/2002 - Added view.sql and column_exceptions.sql
Rem      tmuth     12/03/2002 - Removed f4550, added f4660
Rem      tmuth     12/03/2002 - Moved column_exceptions down
Rem      mhichwa   12/04/2002 - Removed obsolete flows 4400, 4450, 4800, 4600, 4650
Rem      msewtz    12/09/2002 - Added Flow 4550
Rem      mhichwa   12/10/2002 - Added wwv_flow_fnd_developer_api.sql and plb
Rem      jstraub   12/11/2002 - Added wwv_flow_download.sql and .plb
Rem      jstraub   12/12/2002 - Added DB version check & exit if less than 9.2
Rem      mhichwa   12/20/2002 - Removed reports.plb
Rem      jkallman  01/02/2003 - Remove all references to flow 4150, per SSpadafore
Rem      jkallman  01/08/2003 - Removed references to wwv_flow_page_cache
Rem      jkallman  01/08/2003 - Removed references to wwv_flow_cache_tables.sql
Rem      cbcho     01/09/2003 - Added wwv_flow_copy_page.sql and plb (Bug 2743418)
Rem      cbcho     01/09/2003 - Removed reference to copy_page.sql
Rem      cbcho     01/16/2003 - Removed reference to copy_plug.sql (Bug 2754327)
Rem      tmuth     01/17/2003 - Added sw_util.sql and sw_util.plb to install
Rem      tmuth     01/29/2003 - Added call to update image prefix of all f4000 flows on install
Rem      tmuth     01/31/2003 - Added wwv_flow_quick_flow to install
Rem      jstraub   02/04/2003 - Fixed call to wwv_flow_quick_flow, precede with @^PREFIX.
Rem      jstraub   02/06/2003 - Fixed call to wwv_flow_quick_flow, precede with core/
Rem      jkallman  02/06/2003 - Added grant on dbms_flashback
Rem      jkallman  02/14/2003 - Conditionally invoke flow_helptext for 9i/10i
Rem      mhichwa   02/19/2003 - Added popup.sql and popup.plb
Rem      jstraub   02/24/2003 - Removed prompts about errors if installing in 8i, no longer support installing in 8i
Rem      tmuth     02/24/2003 - Bug 2772864: Added dynamic computation of image directory and tablspaces IF upgrading.
Rem      tmuth     02/24/2003 - Added max() to query that determines db version ensuring only 1 row is returned.
Rem      jstraub   02/25/2003 - Changed naming convention from based on date, to based on version
Rem      jstraub   02/25/2003 - Added generate_table_api.* for bug #2819189
Rem      tmuth     02/26/2003 - Set spool off first, then spool all inputs and don't stop spooling until end of install.
Rem                             Changed exit calls from a different file to use "whenever sqlerror exit" and intentially
Rem                             issue erroneous sqlstmnt after printing out error.
Rem      tmuth     02/27/2003 - Added termout off/on around pl/sql anonymous block to hide error that is trapped anyway.
Rem      jstraub   03/03/2003 - Removed grants and synonyms for SYS.XSLPROCESSOR, SYS.XMLDOM, SYS.XMLPARSER
Rem      tmuth     03/07/2003 - Added "whenever sqlerror exit" around sys connect.  Modified how flows owner is computed.
Rem                             Modified how temporary and image directories are computed.
Rem      jstraub   03/11/2003 - Added as file separate from ins.sql, with all parameters passed in
Rem      jstraub   03/11/2003 - Changed to stay connected as SYS user at all times, issue alter session set current_schema
Rem      jstraub   03/11/2003 - Changed call to ctx_ddl.sync_index, to use wwv_execute_immediate to be compatible with commment above
Rem      jstraub   03/11/2003 - Removed all unnecessary comments
Rem      jstraub   03/17/2003 - Added xmlschema.* per msewtz
Rem      jstraub   03/25/2003 - Removed wstab.sql, ddl moved to tab.sql and trigger.sql
Rem      cbcho     04/02/2003 - Added wwv_flow_hint.sql and plb
Rem      tmuth     04/07/2003 - Added core/table_ddl_changes.sql
Rem      jstraub   04/08/2003 - Added wwv_flow_regexp.sql and wwv_flow_regexp9.plb or wwv_flow_regexp.plb, based on db version
Rem      jstraub   04/10/2003 - Removed f4750 (Runtime Flow) - obsolete
Rem      cbcho     04/10/2003 - Added wwv_flow_gen_hint.sql and plb
Rem      cbcho     04/15/2003 - Added wwv_flow_series_attr.sql and plb
Rem      jstraub   04/16/2003 - Removed project status tracking demonstration
Rem      jstraub   04/22/2003 - Added set defines after running of builder flows
Rem      jstraub   04/29/2003 - Added comments.sql and hint_seed.sql per sbkenned
Rem      jkallman  05/02/2003 - Moved meta_cleanup.plb, wwv_flow_upgrade.plb
Rem      sspadafo  05/05/2003 - Added wwv_flow_element.sql and .plb
Rem      jkallman  05/05/2003 - Removed call to core/trans.sql (obsolete)
Rem      jstraub   05/12/2003 - Removed 9iR2 check for running of wwv_flow_xliff.*
Rem      cbcho     05/12/2003 - Removed entry for wwv_flow_vbschart.sql and plb
Rem      jkallman  05/13/2003 - Correct invocation of wwv_flow_element.* (was not referencing core directory)
Rem      jkallman  05/13/2003 - Remove reference to builder/f4955.sql
Rem      jkallman  05/14/2003 - Added reference to builder/f4411.sql
Rem      jkallman  05/15/2003 - Load f4411.sql before all other flows
Rem      jstraub   05/20/2003 - Added edit_report.* and query_api.* for bug 2861658
Rem      jstraub   05/20/2003 - Changed reference from Project Marvel to Oracle HTML DB
Rem      cbcho     05/20/2003 - Added imp_parser.sql and plb
Rem      jstraub   05/29/2003 - Removed stage.sql, wwv_flow_xml_deploy.*, wwv_flow_xml_export.*, wwv_flow_xml_import.*,
Rem                             wwv_flow_gen_xml.*, xmlschema.*, bug 2972214
Rem      jstraub   05/29/2003 - Removed wwv_flow_edit_query.*, load_xml_structure.sql and load_xml_mapping.sql
Rem      jstraub   05/30/2003 - Removed f4250.sql, since it is obsolete
Rem      tmuth     06/16/2003 - Added timer to various components of flows install, bug:2772866
Rem      jstraub   06/19/2003 - Added flows_release.sql and stmt to update flow_version in wwv_flows with value of wwv_flows_release
Rem      jkallman  06/20/2003 - Added call to htmldb_admin.sql (bug 3017850)
Rem      sspadafo  06/21/2003 - Add wwv_flow_developer_toolbar.sql/.plb (Bug 3018687)
Rem      jkallman  06/23/2003 - Added call to flow_isc.* (Bug 3020053)
Rem      jkallman  06/26/2003 - Modified printed URLs at end of installation to include ref to htmldb_admin
Rem      jkallman  06/26/2003 - Added additional argument for Administration password, ordered reports3.sql after auth.sql
Rem      jkallman  06/30/2003 - Order flow_isc.sql before home.sql
Rem      jstraub   07/16/2003 - Removed f4850.sql per mhichwa
Rem      jkallman  08/04/2003 - Added call to flows_files_upgrade.sql during upgrade installation (Bug 3033761)
Rem      jstraub   08/05/2003 - Changed reference in example URL from development_service_home to htmldb (Bug 3078080)
Rem      jstraub   08/05/2003 - Removed installing business_look demonstration, replaced with wwv_flow_sample_app.sql (Bug 3044729)
Rem      jstraub   08/06/2003 - Removed logic of only running wwv_flow_web_services.plb if database is 9.2 (Bug 3085909)
Rem      jstraub   08/06/2003 - Removed APPPW, replace with ADM_PWD, and used it for the flows_files password
Rem      jkallman  08/15/2003 - Remove call to flow_helptext_ddl_10.sql (replace with null1.sql, Bug 3091983)
Rem      jstraub   08/18/2003 - Removed build optioning out of Data Workshop (Bug 3065853)
Rem      jkallman  08/18/2003 - Remove invocation of fileutil.sql, dbms_java permissions, removed all references to P_IMG_DIR (Bug 3063954)
Rem      jstraub   08/20/2003 - Removed flow_helptext_ddl.sql and f4200.sql, help replaced with static html in images directory
Rem      jkallman  08/22/2003 - Set termout before and after grants on ctx_doc, ctx_ddl
Rem      jstraub   08/22/2003 - Added wwv_flow_sample_app.plb
Rem      jstraub   08/26/2003 - Removed flow 4660
Rem      jstraub   08/28/2003 - Disabled trigger bi_wwv_dictionary$_fer before sqlldr call, and enable after.
Rem                             Trigger no longer necessary on load, due to new english.ctl file which includes all columns (bug 3115564)
Rem      jkallman  08/28/2003 - Remove installation of f4100
Rem      jstraub   08/29/2003 - Removed gen_demo.sql
Rem      jstraub   09/02/2003 - Added wwv_flow_help.sql
Rem      jstraub   09/25/2003 - Removed duplicate grant for create any directory
Rem      jstraub   09/25/2003 - Removed installing petstore, platdemo.*, f4955_demo.sql and f145_demo.sql
Rem      jstraub   09/25/2003 - Added conditionally creating hmldb_public_user, and lock accounts of flows_files & ^APPUN
Rem      jstraub   09/29/2003 - Added with admin option to create database link priv, added create job, library to privs granted (Bug 3159606)
Rem      tmuth     10/03/2003 - Added XML DB as required in the XML XDK / XML DB related section of installation (3172569)
Rem      jstraub   10/06/2003 - Added inserts into wwv_flow_platform_prefs for default SMTP server settings
Rem      jstraub   10/08/2003 - Added htmldb_util.*, htmldb_item.*, htmldb_custom_auth.* (Bug 3180502)
Rem      jstraub   10/16/2003 - Added htmldb_lang.*
Rem      jstraub   02/11/2004 - Removed duplicate references to flowl.sql and plsqljob.sql, moved call to switch_schemas to before
Rem                             package bodies, moved meta_cleanup.plb to before and after call to switch_schemas, moved v.sql to
Rem                             before trigger.sql, moved meta_cleanup.plb before and after call to switch_schemas in order to
Rem                             avoid invalid objects at the end of installation (Bug 3425094)
Rem      jstraub   03/03/2004 - Moved htmldb_item.sql before flowu.sql, since flowu.sql now references object in htmldb_item (bugs 3174478, 3119694)
Rem      jstraub   03/05/2004 - Removed description of ADMIN user in insert into wwv_flow_fnd_user (Bug 3191317)
Rem      jstraub   03/25/2004 - Added grant all on wwv_flow_file_objects$ to ^APPUN after flows_files script (Bug 3532644)
Rem      cbcho     04/06/2004 - Added wwv_flow_form_control.sql and plb
Rem      klrice    04/26/2004 - wwv_flow_calendar3.sql and plb
Rem      cbcho     05/19/2004 - Added wwv_flow_data_quick_flow.sql and plb
Rem      jkallman  06/02/2004 - Remove call to import_export.sql
Rem      jkallman  06/02/2004 - Remove calls to xmlutil.sql and xmlutil.plb
Rem      jkallman  06/08/2004 - Add wwv_flow_svg_util.sql and wwv_flow_svg_util.plb
Rem      skutz     06/10/2004 - added theme calls
Rem      cbcho     06/15/2004 - Remove calls to wwv_flow_quick_flow.sql and wwv_flow_quick_flow.plb
Rem      jstraub   06/17/2004 - Added in-line upgrade logic not requiring user intervention to upgrade from 1.5.*
Rem      jstraub   06/17/2004 - Corrected URLS at end of installation to coincide with Install Guide (bug 3332996)
Rem      jstraub   06/21/2004 - Added wwv_flow_theme_files.* for mhichwa
Rem      jstraub   07/08/2004 - Altered to only run hint_seed.sql if new install
Rem      jstraub   07/14/2004 - Removed consideration of FLOWS_010501 schema per conversation with jkallman
Rem      jkallman  07/14/2004 - Added wwv_flow_help.plb
Rem      jkallman  07/27/2004 - Remove references to wwv_flow_svg_util.*
Rem      jkallman  08/05/2004 - Remove references to wwv_flow_xml_report.* and wwv_flow_xml_report2.*
Rem      sspadafo  08/12/2004 - Added htmldb_site_admin_privs.sql/.plb
Rem      jstraub   08/13/2004 - Moved each call to wwv_flow_upgrade in own block with commit
Rem      jstraub   08/27/2004 - Added call to wwv_flow_upgrade.template_name_cleanup if upgrade (Bug 3858934)
Rem      jstraub   09/09/2004 - Moved audit.sql before trigger.sql to support new trigger references to wwv_flow_audit.g_cascade
Rem      jstraub   09/23/2004 - Added wwv_flow_login.* for 4550 per mhichwa
Rem      jkallman  10/31/2004 - Remove calls to utilities/backup_utilities/flows_backup.*
Rem      skutz     12/14/2004 - Added additional feedback to upgrade processes (Bug 4064137)
Rem      sspadafo  01/08/2005 - Add wwv_flow_ppr_util.sql/.plb
Rem      klrice    01/26/2005 - Add wwv_flow_query_builder.sql/.plb
Rem      cbcho     01/27/2005 - Add wwv_flow_sw_script.sql and plb
Rem      msewtz    01/31/2005 - Added wwv_flow_render_query.sql/plb
Rem      jkallman  02/07/2005 - Corrected reference to portal_sso.html
Rem      jkallman  02/07/2005 - Added wwv_flow_sw_object_feed.sql and plb
Rem      sspadafo  02/08/2005 - Add wwv_flow_list.sql/.plb
Rem      jkallman  02/16/2005 - Move auth.sql before flowu.sql
Rem      cbcho     02/18/2005 - Removed wwv_flow_parser.sql/.plb,wwv_flow_parser_public.sql/plb
Rem      jkallman  02/21/2005 - Added wwv_flow_sw_parser.sql/plb
Rem      msewtz    03/02/2005 - Added wwv_flow_plsql_editor.sql/plb
Rem      msewtz    03/07/2005 - Added wwv_flow_model_api.sql/plb
Rem      cbcho     03/14/2005 - Added inserts into wwv_flow_platform_prefs for default script max size settings and PLSQL editing flag
Rem      cbcho     03/25/2005 - Added wwv_flow_create_model_app.sql/plb
Rem      jkallman  04/11/2005 - Remove calls to wwv_flow_file_system.*
Rem      jkallman  04/14/2005 - Add system preference WORKSPACE_PROVISION_DEMO_OBJECTS, added references to wwv_flow_sc_transactions.
Rem      jkallman  04/19/2005 - Change YES system preference seed values to Y
Rem      jkallman  04/25/2005 - Added system preference ENABLE_TRANSACTIONAL_SQL
Rem      jkallman  05/02/2005 - Add wwv_flow_user_api.sql before trigger.sql, modified system preference for ENABLE_TRANSACTIONAL_SQL to be Y
Rem      jkallman  05/04/2005 - Add wwv_flow_session_mon.sql and wwv_flow_session_mon.plb
Rem      jkallman  05/05/2005 - Removed core/comments.sql
Rem      jkallman  05/10/2005 - Seed values for system preferences DISABLE_ADMIN_LOGIN, DISABLE_WORKSPACE_LOGIN
Rem      jkallman  05/19/2005 - Add conditional compilation of wwv_flow_sql_injection.sql/plb, add grants for SQL injection packages
Rem      jkallman  05/27/2005 - Add wwv_flow_sw_page_calls.sql/plb
Rem      cbcho     06/02/2005 - Added call to wwv_flow_upgrade.sw_cleanup
Rem      jkallman  06/10/2005 - Remove sqlldr reference, call dictionary_load.sql (Bug 4411739)
Rem      cbcho     06/13/2005 - Added wwv_flow_sw_upgrade.sql/plb
Rem      jduan     07/07/2005 - Modify for upgrade to 2.0
Rem      jkallman  07/08/2005 - Add seed value for system preference ALLOW_DB_MONITOR
Rem      jkallman  07/11/2005 - Add seed value for system preference SERVICE_DEFAULT_FLOW
Rem      jduan     07/13/2005 - List job_queue_processes
Rem      sspadafo  07/14/2005 - Add seed values for wwv_flow_restricted_schemas
Rem      sspadafo  07/14/2005 - Fix condition around block that adds seed values for wwv_flow_restricted_schemas
Rem      jduan     07/15/2005 - Check for database version around grant of create job (Bug 4228236)
Rem      jkallman  07/18/2005 - Correct errors with block to seed restricted schemas
Rem      jkallman  08/02/2005 - Add UFROM in p_from parameter to upgrade_to_020000
Rem      jkallman  09/14/2005 - Add calls to wwv_flow_xe_config.sql/plb
Rem      jkallman  09/21/2005 - Add conditional compilation for XE packages
Rem      jkallman  09/22/2005 - Move compilation of wwv_flow_val to primary SYS section
Rem      jkallman  09/22/2005 - Add conditional compilation for wwv_flow_login(_xe)
Rem      jkallman  09/27/2005 - Grant DBA to APPUN if XE
Rem      jkallman  09/29/2005 - Remove 4200 from installation
Rem      jkallman  09/29/2005 - Only restrict HR and SCOTT if not XE
Rem      jkallman  10/17/2005 - Add TSMSYS to list of restricted schemas (Bug 4659228)
Rem      sspadafo  10/25/2005 - Compile wwv_flow_val.sql and wwv_flow_val.plb as separate files sequenced to allow compilation of auth.sql and auth.plb
Rem      sspadafo  10/25/2005 - Remove XE-only condition on wwv_flow_val.sql
Rem      sspadafo  10/25/2005 - Compile sw_api_xe.plb, wwv_flow_render_query_xe.plb for XE only and sw_api.plb, wwv_flow_render_query.plb for non-XE only
Rem      jkallman  10/26/2006 - Remove conditional compilation of sw_api.sql and wwv_flow_render_query.sql
Rem      jkallman  10/27/2005 - Add grant of ALTER SYSTEM (Bug 4704840)
Rem      jkallman  11/10/2005 - Add conditional compilation of sw_util.plb and sw_util_xe.plb (Bug 4730186)
Rem      jkallman  11/14/2005 - Add conditional compilation of sw_util.sql and sw_util_xe.sql (Bug 4730186)
Rem      sspadafo  11/16/2005 - Remove conditional compilation of sw_util.sql and sw_util_xe.sql (now gone), replace with unconditional sw_util.sql (Bug 4730186)
Rem      sspadafo  11/22/2005 - Add conditional compilation for xe of wwv_flow_epg_include_local.sql, wwv_flow_epg_include.sql
Rem      sspadafo  11/27/2005 - Change rule for conditional compilation of custom_auth_sso.plb to compile custom_auth_sso_902.plb instead in some cases (Bug 4244603)
Rem      jkallman  11/29/2005 - Move compilation of wwv_flow_epg_include.sql and wwv_flow_epg_include_local.sql after flow.sql
Rem      sspadafo  11/30/2005 - Add grant execute on SYS.dbms_crypto to APPUN if XE
Rem      sspadafo  12/02/2005 - Add conditional compilation for xe of wwv_flow_epg_include.plb, now split into separate .sql/.plb files
Rem      jkallman  12/03/2005 - Remove wwv_flow_runtime_dist
Rem      jkallman  12/06/2005 - Add wwv_flow_dynsql_util.sql and conditional compilation of wwv_flow_dynsql_util[_xe].plb (Bug 4864382)
Rem      jkallman  12/06/2005 - Always set SSO_PLB to null1.sql if XE
Rem      jkallman  12/08/2005 - Lock APPUN and FLOWS_FILES if XE
Rem      sspadafo  12/09/2005 - Remove compilation of wwv_test_apps.sql (obsolete) (Bug 4864511)
Rem      jkallman  12/09/2005 - Remove unused debug tables
Rem      sspadafo  12/10/2005 - Remove compilation of pmessage.sql/.plb (obsolete) (Bug 4870920)
Rem      sspadafo  12/10/2005 - Remove insert of 'TEST' into wwv_flow_restricted_schemas
Rem      jkallman  12/16/2005 - Remove flowm.*, flowa.*, compile app_auth if not XE (Bugs 4871017, 4870818, 4870818)
Rem      jkallman  12/16/2005 - Change update of flow_version of internal applications to not show version number in 4550 (Bug 4886104)
Rem      jkallman  12/20/2005 - Remove deprecated files wwv_apply_configuration.sql, gen_trans.sql, flow_designer.sql (Bug 4886210)
Rem      jkallman  12/20/2005 - Add direct grants on utl_http, utl_smtp and utl_file to APPUN
Rem      jkallman  01/19/2006 - Replace htmldb_admin with apex_admin, change other occurrences of HTML DB
Rem      jkallman  01/23/2006 - Adjust XE flag to 0, modify calculation of upgrade schema to account for versions prior to 2.2
Rem      madelfio  01/30/2006 - Added wwv_flow_install_wizard.sql/plb
Rem      jkallman  02/14/2006 - Add direct grants on dbms_lob to APPUN
Rem      jkallman  02/17/2006 - Add themes 13,14,15 - also change upgrade procedure to upgrade_to_020200
Rem      jduan     02/20/2006 - Change foo_user to foo_usr in the select statement on line 500
Rem      cbcho     03/02/2006 - Remove compilation of webservices.sql/.plb (obsolete)
Rem      cbcho     03/02/2006 - Remove compilation of presidents.sql/.plb (obsolete)
Rem      jduan     03/03/2006 - Change the query that determins the existence of wwsec_sso_enabler_private for SSO
Rem      jduan     03/08/2006 - Add column name 'temp' to the query that determins the existence of wwsec_sso_enabler_private for SSO (bug 5084545)
Rem      jkallman  03/23/2006 - Remove flow_ views created in SYS schema from previous installations
Rem      jkallman  03/24/2006 - Merged XE and previous help packages, removed wwv_flow_help_xe from installation (Bug 5112535)
Rem      jkallman  03/24/2006 - Changed creation of HTMLDB_PUBLIC_USER to APEX_PUBLIC_USER
Rem      cbcho     03/30/2006 - Added wwv_flow_wiz_confirm.sql/plb
Rem      jkallman  04/25/2006 - Add audit.plb, audit_trigger.sql (Bug 5070914)
Rem      jkallman  04/26/2006 - Remove grants of execute any procedure, create database link (Bug 4922214)
Rem      jkallman  04/27/2006 - Remove g_xe condition from grant on dbms_crypto.  Silently fail if it does not exist.
Rem      jduan     04/27/2006 - Added logic to handle the conditional compilation of custom_auth_sso.sql and custom_auth_sso_902.sql
Rem      jkallman  05/01/2006 - Grant execute on previous version's wwv_flows_version procedure, as no longer granted execute any procedure
Rem      jkallman  05/03/2006 - Correct grant on wwv_flows_version procedure (Bug 5202724)
Rem      jkallman  05/09/2006 - Add themes 16 and 17
Rem      jkallman  06/02/2006 - Remove conditional compilation from wwv_flow_regexp.plb
Rem      msewtz    06/13/2006 - Added wwv_flow_page_cache_api.sql and wwv_flow_page_cache_api.plb
Rem      jkallman  06/16/2006 - Added wwv_flow_f4000_util.sql and wwv_flow_f4000_util.plb
Rem      jstraub   06/21/2006 - Added logic to register APEX as a server component of the database
Rem      jstraub   06/22/2006 - Added timing for validating installation
Rem      jstraub   06/22/2006 - Added SQLPlus column called version to use with both updating flow_version in wwv_flows and registering APEX as component
Rem      jstraub   06/22/2006 - Added desc to query that determines UFROM to ensure proper upgrade (bug 5343712)
Rem      mhichwa   06/23/2006 - Added core/apex_views.sql to install apex views for the purpose of system doc and developer productivity
Rem      msewtz    06/26/2006 - Added wwv_flow_theme_18.sql/plb
Rem      sspadafo  06/26/2006 - Added imgapi_public.*, cssapi_public.*, htmlapi_public.*
Rem      jstraub   06/29/2006 - Added logic to put validate_apex as standalone procedure again on advice from rburns
Rem      jstraub   06/29/2006 - Moved registering FLOWS_FILES as auxilary schema in execute immediate calls to DBMS_REGISTRY for compatibility prior to 10.2 (bug 5366916)
Rem      jstraub   07/11/2006 - Removed creating new ADMIN user in internal, as well as FLOWS as developer user
Rem      jstraub   07/11/2006 - Fixed above so ADMIN user is created in new installation
Rem      jkallman  07/18/2006 - Restore grant of execute any procedure
Rem      jkallman  07/19/2006 - Always compile wwv_flow_epg_include* files
Rem      jkallman  07/19/2006 - Remove refererences to portal_sso.html, ldap.html
Rem      jkallman  08/01/2006 - Alter grant of create job to check for appropriate db version
Rem      jstraub   08/11/2006 - Added PREFIX to allow calling files either based on Oracle home or current working directory
Rem      jstraub   08/14/2006 - Added calls to dbms_registry.set_required_comps for 11g
Rem      sspadafo  08/20/2006 - Consolidated xe and non-xe versions of wwv_flow_render_query.plb, wwv_flow_dynsql_util.plb, wwv_flow_sw_api.plb, wwv_flow_sw_util.plb (Bug 5453611)
Rem      sspadafo  08/20/2006 - Added wwv_flow_dynsql_parse.sql, wwv_flow_dynsql_parse.plb (pre-10.2.0.3/non-xe) and wwv_flow_dynsql_parse_roles.plb (10.2.0.3/xe) (Bug 5453611)
Rem      sspadafo  08/21/2006 - Made wwv_flow_dynsql_parse_roles.plb compile conditionally using db version check logic enabled after flowu.plb compiles
Rem      jstraub   08/22/2006 - Wrapped passwords in create user statements in double quotes to support apxdbmig.sql (random password)
Rem      jstraub   08/24/2006 - Changed condition on wwv_flow_dynsql_parse_roles.plb to include compilation for XE edition
Rem      jkallman  09/29/2006 - Add FLOWS_020200 to previous version query, change upgrade to call upgrade_to_030000
Rem      sspadafo  11/27/2006 - Added @^PREFIX.core/wwv_flow_builder30.sql and @^PREFIX.core/wwv_flow_builder30.plb (for Mike)
Rem      sspadafo  11/27/2006 - Added select grants on sys tables/views and removed "select any table" grant from APPUN (Bug 5684179)
Rem      sspadafo  11/27/2006 - Added update of wwv_flow_fnd_user.expiry columns to set to sysdate if they are null (new account management features)
Rem      sspadafo  11/27/2006 - Changed insert into wwv_flow_fnd_user for ADMIN account, set new columns (new account management features)
Rem      sspadafo  11/30/2006 - Restored "grant select any table", this fix will be deferred (Bug 5684179)
Rem      sspadafo  12/01/2006 - Fixed date on previous Rem. Removed "grant select any dictionary to ^APPUN;" (Bug 5684179)
Rem      sspadafo  12/02/2006 - Added more select grants on sys tables (Bug 5684179)
Rem      sspadafo  12/04/2006 - Add "grant select on sys.dba_tab_comments to ^APPUN;" (Bug 5684179)
Rem      jstraub   12/06/2006 - Added wwv_flow_print_util.*
Rem      hfarrell  12/07/2006 - Added 4400 install statements, commented as Application Migration Workshop
Rem      sspadafo  12/11/2006 - Removed HR from restricted schema insert statements (per sbkenned, bug 5712312)
Rem      jkallman  12/12/2006 - Conditionally grant certain 10g and greater SYS privileges, correct insert into wwv_flow_fnd_user,
Rem                             add compilation of wwv_flow_flash_chart, change wwv_flow_builder30 to wwv_flow_page_map
Rem      sspadafo  12/12/2006 - Added bug number to 'HR' fix, above
Rem      jkallman  12/15/2006 - Add output before component validation
Rem      jkallman  12/19/2006 - Remove feedback.sql
Rem      jkallman  12/22/2006 - Remove grant of CREATE LIBRARY system privilege (Bug 5729908)
Rem      jkallman  01/06/2007 - Remove SQL Injection packages and grants
Rem      cbcho     01/09/2007 - Added compilation of wwv_flow_flash_chart_util.sql/plb
Rem      jkallman  01/11/2007 - Add call to verification_images_load.sql
Rem      jkallman  01/11/2007 - Change incorrect compilation of wwv_flow_page_cache_api.sql to wwv_flow_page_cache_api.plb
Rem      jkallman  01/15/2007 - Move flow.sql before auth.sql
Rem      msewtz    01/22/2007 - Added PRINT_BIB_LICENSED to platform preferences
Rem      jkallman  01/23/2007 - Add call to apex_install_data.sql
Rem      sspadafo  01/24/2007 - Added LBACSYS, DVSYS, DVF, AVSYS to restricted schema insert statements for label security, database vault, audit vault
Rem      cbackstr  01/26/2007 - Added compilation of wwv_flow_drag_layout.sql/plb
Rem      sspadafo  01/27/2007 - Revise block that creates flows_files user
Rem      sspadafo  01/27/2007 - Remove obsolete generic_login.sql/.plb directives
Rem      sspadafo  01/28/2007 - Revise block that alters flows_files user during upgrade
Rem      sspadafo  01/28/2007 - Remove grants of select/drop any directory privilege to APPUN
Rem      sspadafo  01/29/2007 - Added with grant option to grant execute on sys.dbms_lob to APPUN
Rem      jkallman  01/30/2007 - Add wwv_flow_image_generator.sql and wwv_flow_image_generator.plb
Rem      jkallman  02/06/2007 - Add compilation of wwv_flow_image_prefix.sql
Rem      jstraub   02/08/2007 - Removed WHENEVER SQLERROR statements to comply with component install/upgrade guidelines
Rem      sspadafo  02/09/2007 - Add "grant select on sys.dba_trigger_cols to ^APPUN;" (Bug 5872695)
Rem      jkallman  02/19/2007 - Add grant on sys.v_$process to ^APPUN (Bug 5860771)
Rem      jkallman  03/09/2007 - Account for ungranted role when revoking privs from FLOWS_FILES
Rem      jstraub   04/10/2007 - Added conditional setting of WHENEVER SQLERROR EXIT before installing internal applications, if manual install
Rem      jstraub   04/11/2007 - Fixed conditional logic of running apxsqler.sql, should run if INSTALL_TYPE is MANUAL
Rem      jstraub   05/01/2007 - Added Oracle XML DB HTTP listener with the embedded PL/SQL gateway to end of install prompts for link structures
Rem      jstraub   05/08/2007 - Removed grant on sys.dba_java_policy for lrg 2947476
Rem      jstraub   07/13/2007 - Split off files to support runtime, devins.sql, core_grants.sql, dev_grants.sql, endins.sql
Rem      jkallman  08/02/2007 - Change reference to wwv_flow_upgrade.upgrade_to_030100
Rem      jstraub   08/13/2007 - Added worksheet specs and bodies
Rem      jstraub   08/16/2007 - Moved wwv_flow_sample.* to before provision.plb
Rem      jstraub   08/28/2007 - Added wwv_flow_worksheet_dialog.* for worksheets
Rem      jstraub   09/05/2007 - Removed wwv_flow_worksheet_webpage.*
Rem      jstraub   09/06/2007 - Added wwv_flow_instance_admin.*
Rem      jkallman  09/11/2007 - Remove app_auth.* (Bug 6355820)
Rem      cbcho     09/13/2007 - Added wwv_flow_worksheet_form.*
Rem      jstraub   09/18/2007 - Added role APEX_ADMINISTRATOR_ROLE and installing internal 4155 to support runtime
Rem      jkallman  10/11/2007 - Added wwv_flow_worksheet_ajax.*
Rem      jkallman  10/12/2007 - Added wwv_flow_calendar_ajax.*
Rem      cbcho     11/06/2007 - Added wwv_flow_flash_chart2.*
Rem      cbcho     11/06/2007 - Moved wwv_flow_flash_chart2.* above wwv_flow_flash_chart_util.*
Rem      jkallman  11/08/2007 - Added creation of nv stub
Rem      jkallman  11/21/2007 - Move compilation of v.sql after plug.sql (new dependencies on region id)
Rem      nagkrish  11/22/2007 - Seed values for system preferences DISABLE_WS_PROV, REQ_NEW_SCHEMA
Rem      jkallman  12/13/2007 - Move wwv_flow_fnd_developer_api.sql before provisioning_tables.sql
Rem      jkallman  12/13/2007 - Added wwv_flow_theme_1-20.* (dependencies in wwv_flow_theme_manager)
Rem      jstraub   12/19/2007 - Changed creating APEX_ADMINISTRATOR_ROLE only if it does not already exist
Rem      jstraub   01/07/2008 - Added wwv_flow_assert.*
Rem      jkallman  01/11/2008 - Moved up compilation of wwv_flow_assert package body
Rem      madelfio  01/17/2008 - Added wwv_flow_rpt_std_msg.*
Rem      jkallman  01/25/2008 - Moved compilation of crypt.plb
Rem      jstraub   01/29/2008 - Removed ^XE substituion and all references
Rem      jkallman  01/30/2008 - Compile wwv_dbms_sql.*
Rem      jkallman  01/31/2008 - Remove dynsql.*, wwv_flow_dynsql.*, wwv_flow_dynsql_util.*;  Add wwv_dbms_sql_noroles.plb
Rem      jkallman  02/01/2008 - Reorder compilation of wwv_flow_sw_parser.sql, move flows_files_objects_remove and create.
Rem      jkallman  02/04/2008 - Move up compilation of wwv_dbms_sql
Rem      jkallman  02/05/2008 - Add recompilation of wwv_dbms_sql to upgrade steps
Rem      jkallman  02/16/2008 - Change order of wwv_flow_worksheet_standard.sql and wwv_flow_worksheet_expr.sql
Rem      jkallman  02/19/2008 - Remove wwv_flow_worksheet_geocode
Rem      jkallman  02/21/2008 - Remove wwv_flow_worksheet_import
Rem      jstraub   04/02/2008 - Added wwv_flow_create_app_from_query.*
Rem      jstraub   04/17/2008 - Removed compilation of custom_auth_sso packages, moved to utilities script
Rem      jkallman  07/17/2008 - Add explict create synonym grant to FLOWS_FILES, per DAlpern 11.2 change (Bug 6690853)
Rem      sspadafo  07/20/2008 - Revoke/re-grant unlimited tablespace to da flows to rid it of the "admin option" (Bug 7225208)
Rem      jstraub   07/22/2008 - Changed creating APEX_PUBLIC_USER as locked account to be consistent with documentation
Rem      jkallman  11/14/2008 - Change default of ALLOW_DB_MONITOR to N
Rem      jstraub   12/04/2008 - Added changes prior to upgrade logic suggested by sspadafo giving/revoking select any table to ^APPUN
Rem      sspadafo  01/17/2009 - Removed "update wwv_flow_fnd_user set account_expiry ..." (moved to upgrade_to_030200)
Rem      sspadafo  01/18/2009 - Added insert statements for platform prefs default values for ALLOW_PUBLIC_FILE_UPLOAD, STRONG_SITE_ADMIN_PASSWORD, MAX_SESSION_LENGTH_SEC, MAX_SESSION_IDLE_SEC
Rem      jstraub   01/29/2009 - Moved wwv_flow_fnd_user_api.sql prior to trigger.sql
Rem      sspadafo  01/29/2009 - Added compilation, execution, and drop of wwv_flow_create_key_package in SYS section
Rem      sspadafo  01/29/2009 - Added grant execute on sys.wwv_flow_key to ^APPUN;
Rem      sspadafo  01/29/2009 - Fixed file directory error in reference to wwv_flow_create_key_package
Rem      jkallman  01/30/2009 - Changed reference to wwv_flow_create_key_package.plb to be from core directory
Rem      sspadafo  02/03/2009 - Added inserts for wwv_flow_platform_prefs for PASSWORD_ALPHA_CHARACTERS and PASSWORD_PUNCTUATION_CHARACTERS (Bug 8222823)
Rem      jkallman  02/13/2009 - Compile WWV_DBMS_SQL before call to wwv_flow_upgrade.sw_cleanup (Bug 8240324)
Rem      jstraub   03/24/2009 - Removed spool off, was stopping spool for catupgrd
Rem      jstraub   04/02/2009 - Added compile of wwv_flow_assert before call to wwv_flow_upgrade.upgrade_to_030200 (Bug 8399978)
Rem      jkallman  07/23/2009 - Move wwv_flow_install_wizard to devins.sql

set define '^'
set concat on
set concat .
set verify off

define LOG1      = '^1'
define UPGRADE   = '^2'
define APPUN     = '^3'
define TEMPTBL   = '^4'
define IMGPR     = '^5'
define DATTS     = '^6'
define FF_TBLS   = '^7'
define ADM_PWD   = '^8'
define PREFIX    = '^9'


set termout off
define UFROM     = 'FLOWS_010500'
column foo_usr new_val UFROM
select username foo_usr from (select username from dba_users where username in ('FLOWS_010500','FLOWS_010600','FLOWS_020000','FLOWS_020100','FLOWS_020200','FLOWS_030000','FLOWS_030100') order by username desc) x where rownum = 1;

set termout on

timing start "Complete Installation"

begin
    if '^UPGRADE' = '1' then
        dbms_output.put_line('Proceeding with new installation.');
    elsif '^UPGRADE' = '2' then
        dbms_output.put_line('Proceeding with upgrade installation.');
    else
        dbms_output.put_line('Could not determine installation type.');
    end if;
end;
/

begin
    if '^UPGRADE' = '1' then
        execute immediate 'create user flows_files identified by "^ADM_PWD" default tablespace ^FF_TBLS temporary tablespace ^TEMPTBL quota unlimited on ^FF_TBLS';
    else
        declare
            system_privilege_not_granted EXCEPTION;
            PRAGMA EXCEPTION_INIT(system_privilege_not_granted, -1952);
            role_not_granted EXCEPTION;
            PRAGMA EXCEPTION_INIT(role_not_granted, -1951);
        begin
            execute immediate 'revoke connect from flows_files';
            execute immediate 'revoke create any synonym from flows_files';
            execute immediate 'revoke create public synonym from flows_files';
        exception
            when system_privilege_not_granted then
                null;
            when role_not_granted then
                null;
        end;
    end if;
    execute immediate 'grant create synonym to flows_files';
end;
/


define foo2 = 'NOPUBUSER'
column foo new_val foo2

select 'INSTALLED' foo from dba_users where username = 'APEX_PUBLIC_USER';

begin
    if '^foo2' = 'NOPUBUSER' then
        execute immediate 'create user apex_public_user identified by "^ADM_PWD" account lock';
        execute immediate 'grant create session to apex_public_user';
    else
        dbms_output.put_line('APEX_PUBLIC_USER exists.');
    end if;
end;
/

define foo2 = 'NOADMINROLE'
column foo new_val foo2

select 'ADMINROLE' foo from dba_roles where role = 'APEX_ADMINISTRATOR_ROLE';

begin
    if '^foo2' = 'NOADMINROLE' then
        execute immediate 'create role APEX_ADMINISTRATOR_ROLE';
    else
        dbms_output.put_line('APEX_ADMINISTRATOR_ROLE exists.');
    end if;
end;
/

prompt I.    O R A C L E   S Y S   I N S T A L L   P R O C E S S

prompt ...create flows user

create user ^APPUN identified by "^ADM_PWD";
alter  user ^APPUN default tablespace ^DATTS;
alter  user ^APPUN temporary tablespace ^TEMPTBL;
grant  connect, resource              to ^APPUN;

revoke unlimited tablespace from ^APPUN;
grant unlimited tablespace to ^APPUN;

prompt ...create validate procedure in SYS schema and start registration
@^PREFIX.apexvalidate.sql x x ^APPUN x x x x x x

@^PREFIX.core/core_grants.sql

begin
    if '^UPGRADE' = '1' then
        dbms_registry.loading('APEX','Oracle Application Express','validate_apex', '^APPUN');
        execute immediate 'begin dbms_registry.update_schema_list(''APEX'', dbms_registry.schema_list_t(''FLOWS_FILES'')); end;';
        execute immediate 'begin dbms_registry.set_required_comps(''APEX'', dbms_registry.comp_depend_list_t(''XDB'',''CONTEXT'')); end;';
    elsif '^UPGRADE' = '2' then
        if dbms_registry.is_valid('APEX') is not null then
            dbms_registry.upgrading('APEX','Oracle Application Express','validate_apex', '^APPUN');
            execute immediate 'begin dbms_registry.update_schema_list(''APEX'', dbms_registry.schema_list_t(''FLOWS_FILES'')); end;';
            execute immediate 'begin dbms_registry.set_required_comps(''APEX'', dbms_registry.comp_depend_list_t(''XDB'',''CONTEXT'')); end;';
        else --it has never been registered, so register it now
            dbms_registry.loading('APEX','Oracle Application Express','validate_apex', '^APPUN');
            execute immediate 'begin dbms_registry.update_schema_list(''APEX'', dbms_registry.schema_list_t(''FLOWS_FILES'')); end;';
            execute immediate 'begin dbms_registry.set_required_comps(''APEX'', dbms_registry.comp_depend_list_t(''XDB'',''CONTEXT'')); end;';
        end if;
    end if;
exception
    when others then null;
end;
/


@^PREFIX.core/wwv_flow_val.sql

prompt ...remove views created from previous APEX installations
begin
    if '^UPGRADE' = '2' then
        execute immediate 'drop view sys.flow_sessions';
        execute immediate 'drop view sys.flow_parameters';
        execute immediate 'drop view sys.flow_sqlarea';
        execute immediate 'drop view sys.flow_sga';
    end if;
exception
    when others then null;
end;
/


prompt ...wwv_dbms_sql
@^PREFIX.core/wwv_dbms_sql.sql
grant execute on sys.wwv_dbms_sql to ^APPUN;

prompt ...wwv_flow_create_key_package
@^PREFIX.core/wwv_flow_create_key_package.plb
exec wwv_flow_create_key_package
drop package sys.wwv_flow_create_key_pkg
/
drop procedure sys.wwv_flow_create_key_package
/
grant execute on sys.wwv_flow_key to ^APPUN;


prompt ...CONNECT as the Oracle user who will own the flows engine

alter session set current_schema = ^APPUN;

prompt I.    I N S T A L L    P R E - C R E A T E   T A B L E   S P E C S
@^PREFIX.core/init_htp.sql
@^PREFIX.core/wwv_flow_image_prefix.sql    x x x x x x ^IMGPR x x x
@^PREFIX.core/flowg.sql                    x x x x x x x x x 0
@^PREFIX.core/htmldb_item.sql
@^PREFIX.core/flow.sql
@^PREFIX.core/auth.sql
@^PREFIX.core/flowu.sql
@^PREFIX.core/flowl.sql
@^PREFIX.core/wwv_htf.sql
@^PREFIX.core/wwv_htp.sql
@^PREFIX.core/escape_sc.sql
@^PREFIX.core/meta.sql
@^PREFIX.core/template.sql
@^PREFIX.core/calendar.sql
@^PREFIX.core/chart.sql
@^PREFIX.core/check.sql
@^PREFIX.core/reports3.sql
@^PREFIX.core/wwv_flow_page_cache_api.sql
@^PREFIX.core/wwv_flow_render_query.sql
@^PREFIX.core/wwv_flow_element.sql
@^PREFIX.core/crypt.sql
@^PREFIX.core/api.sql
@^PREFIX.core/fileapi.sql
@^PREFIX.core/file_mgr.sql
@^PREFIX.core/wwv_flow_file_object_id.sql





@^PREFIX.core/wwv_flow_epg_include_local.sql
@^PREFIX.core/wwv_flow_epg_include.sql


prompt II.   I N S T A L L   F L O W   T A B L E S

prompt ...create v function stub
create or replace function v ( p_item in varchar2) return varchar2 is begin return null; end;
/
show error

prompt ...create nv function stub
create or replace function nv ( p_item in varchar2) return number is begin return null; end;
/
show error


set define '^'
prompt ...install flow rendering engine tables
@^PREFIX.core/random.sql
set define '^'
@^PREFIX.core/wwv_id.sql
@^PREFIX.core/random.plb
@^PREFIX.core/wwv_id.plb
set define '^'


column thescript  new_val script
set termout off
select decode('^UPGRADE','1','flows_files_new.sql','flows_files_upgrade.sql') thescript from dual;
set termout on

alter session set current_schema = SYS;

@^PREFIX.core/wwv_flow_val.plb


prompt  Installing flows_files objects 1


alter session set current_schema = FLOWS_FILES;

@^PREFIX.core/^script

grant all on wwv_flow_file_objects$ to ^APPUN with grant option;

alter session set current_schema = ^APPUN;


@^PREFIX.core/migrate_metadata.sql

@^PREFIX.core/tab.sql                          x x x x x x x ^DATTS x
@^PREFIX.core/table_ddl_changes.sql

@^PREFIX.core/wwv_flow_assert.sql
@^PREFIX.core/wwv_flow_assert.plb
@^PREFIX.core/crypt.plb
@^PREFIX.core/column_exceptions.sql
@^PREFIX.core/meta_cleanup.sql
@^PREFIX.core/wwv_flow_sw_upgrade.sql
@^PREFIX.core/wwv_flow_upgrade.sql
@^PREFIX.core/wwv_flow_upgrade.plb

@^PREFIX.core/plsqljob.sql

@^PREFIX.core/wwv_flow_rpt_std_msg.sql

-- Worksheet
@^PREFIX.core/wwv_flow_worksheet_standard.sql
@^PREFIX.core/wwv_flow_worksheet_expr.sql
@^PREFIX.core/wwv_flow_worksheet.sql
@^PREFIX.core/wwv_flow_worksheet_api.sql
@^PREFIX.core/wwv_flow_worksheet_ui.sql
@^PREFIX.core/wwv_flow_ajax.sql
@^PREFIX.core/wwv_flow_worksheet_attachment.sql
@^PREFIX.core/wwv_flow_worksheet_stickies.sql
@^PREFIX.core/wwv_flow_worksheet_dialogue.sql
@^PREFIX.core/wwv_flow_worksheet_form.sql
@^PREFIX.core/wwv_flow_worksheet_ajax.sql
@^PREFIX.core/wwv_flow_calendar_ajax.sql

@^PREFIX.core/apexws.sql

@^PREFIX.core/audit.sql
@^PREFIX.core/wwv_flow_user_api.sql
@^PREFIX.core/wwv_flow_fnd_user_api.sql
@^PREFIX.core/trigger.sql
@^PREFIX.core/apex_install_data.sql
@^PREFIX.core/wwv_flow_fnd_developer_api.sql
@^PREFIX.core/provisioning_tables.sql
@^PREFIX.core/wwv_flow_csv_data.sql


begin
    if '^UPGRADE' = '1' then
        wwv_flow_security.g_security_group_id := 10;
        insert into wwv_flow_fnd_user(USER_NAME,SECURITY_GROUP_ID,WEB_PASSWORD,change_password_on_first_use,first_password_use_occurred,account_expiry)values
                             ('ADMIN',10,'^ADM_PWD','Y','N',trunc(sysdate));
    end if;
end;
/
commit;

timing start "Package Specs"
prompt  III.   I N S T A L L   F L O W   P A C K A G E   S P E C S
@^PREFIX.core/http.sql

set define '^'

@^PREFIX.core/flow_log.sql
@^PREFIX.core/flow_dml.sql
@^PREFIX.core/flowp.sql
@^PREFIX.core/f.sql
@^PREFIX.core/nv.sql
@^PREFIX.core/vrn.sql
@^PREFIX.core/flowc.sql
@^PREFIX.core/gen_api_pkg.sql
@^PREFIX.core/plug.sql
@^PREFIX.core/v.sql
@^PREFIX.core/customize.sql
@^PREFIX.core/generic.sql
@^PREFIX.core/form.sql
@^PREFIX.core/popup_filter.sql
@^PREFIX.core/asfcookie.sql
@^PREFIX.core/spell.sql
@^PREFIX.core/wwv_calculator.sql
@^PREFIX.core/wwv_flow_builder.sql
@^PREFIX.core/shortcut.sql
@^PREFIX.core/popup.sql
@^PREFIX.core/wwv_flow_calendar3.sql

@^PREFIX.core/temp_table_init.sql
@^PREFIX.core/wwv_flow_mail.sql
@^PREFIX.core/prov.sql
@^PREFIX.core/provision.sql

@^PREFIX.core/flowjob.sql
@^PREFIX.core/wwv_flow_item.sql
@^PREFIX.core/platform.sql
@^PREFIX.core/tree.sql
@^PREFIX.core/tree3.sql
@^PREFIX.core/wizapi.sql
@^PREFIX.core/flow_isc.sql

@^PREFIX.core/home.sql

@^PREFIX.core/imgapi.sql
@^PREFIX.core/imgapi_public.sql
@^PREFIX.core/cssapi.sql
@^PREFIX.core/cssapi_public.sql
@^PREFIX.core/htmlapi.sql
@^PREFIX.core/htmlapi_public.sql
@^PREFIX.core/flows_version.sql
@^PREFIX.core/flows_release.sql
@^PREFIX.core/wwv_flow_upgrade_report.sql
@^PREFIX.core/collection.sql
@^PREFIX.core/z.sql
@^PREFIX.core/custom_auth_api.sql
@^PREFIX.core/custom_auth_std.sql
@^PREFIX.core/sw_api.sql
@^PREFIX.core/ihelp.sql
@^PREFIX.core/wwv_flow_admin_api.sql
@^PREFIX.core/flowcon.sql
@^PREFIX.core/wwv_flow_svg.sql
@^PREFIX.core/sw_util.sql
@^PREFIX.core/wwv_flow_hint.sql
@^PREFIX.core/wwv_flow_regexp.sql
@^PREFIX.core/wwv_flow_series_attr.sql
@^PREFIX.core/edit_report.sql
@^PREFIX.core/query_api.sql
@^PREFIX.core/imp_parser.sql

@^PREFIX.core/wwv_flow_login.sql


column thescript  new_val script
set termout off
select decode('^UPGRADE','1','hint_seed.sql','null1.sql') thescript from dual;
set termout on
@^PREFIX.core/^script

@^PREFIX.core/view.sql
@^PREFIX.core/wwv_flow_developer_toolbar.sql
@^PREFIX.core/htmldb_util.sql
@^PREFIX.core/htmldb_custom_auth.sql
@^PREFIX.core/htmldb_lang.sql
@^PREFIX.core/wwv_flow_form_control.sql
@^PREFIX.core/wwv_flow_theme_globals.sql

@^PREFIX.core/wwv_flow_theme_1.sql
@^PREFIX.core/wwv_flow_theme_2.sql
@^PREFIX.core/wwv_flow_theme_3.sql
@^PREFIX.core/wwv_flow_theme_4.sql
@^PREFIX.core/wwv_flow_theme_5.sql
@^PREFIX.core/wwv_flow_theme_6.sql
@^PREFIX.core/wwv_flow_theme_7.sql
@^PREFIX.core/wwv_flow_theme_8.sql
@^PREFIX.core/wwv_flow_theme_9.sql
@^PREFIX.core/wwv_flow_theme_10.sql
@^PREFIX.core/wwv_flow_theme_12.sql
@^PREFIX.core/wwv_flow_theme_11.sql
@^PREFIX.core/wwv_flow_theme_13.sql
@^PREFIX.core/wwv_flow_theme_14.sql
@^PREFIX.core/wwv_flow_theme_15.sql
@^PREFIX.core/wwv_flow_theme_16.sql
@^PREFIX.core/wwv_flow_theme_17.sql
@^PREFIX.core/wwv_flow_theme_18.sql
@^PREFIX.core/wwv_flow_theme_19.sql
@^PREFIX.core/wwv_flow_theme_20.sql


@^PREFIX.core/wwv_flow_theme_manager.sql
@^PREFIX.core/htmldb_site_admin_privs.sql
@^PREFIX.core/wwv_flow_ppr_util.sql
@^PREFIX.core/wwv_flow_sw_script.sql
@^PREFIX.core/wwv_flow_list.sql
-- Eventually break dependency from wwv_flow_sc_transactions to wwv_flow_sw_script
@^PREFIX.core/wwv_flow_sc_transactions.sql
@^PREFIX.core/wwv_flow_print_util.sql
@^PREFIX.core/wwv_flow_flash_chart.sql
@^PREFIX.core/wwv_flow_flash_chart2.sql
@^PREFIX.core/wwv_flow_flash_chart_util.sql
@^PREFIX.core/wwv_flow_instance_admin.sql
@^PREFIX.core/wwv_flow_create_app_from_query.sql


Rem  Only install the LDAP packages if dbms_ldap exists
column temp new_val LDAP_SQL
column temp2 new_val AUTH_LDAP_SQL
set termout off
select decode(count(*),0,'null1.sql','ldap.sql') temp from all_objects where object_name ='DBMS_LDAP' AND OBJECT_TYPE ='PACKAGE';
select decode(count(*),0,'null1.sql','custom_auth_ldap.sql') temp2 from all_objects where object_name ='DBMS_LDAP' AND OBJECT_TYPE ='PACKAGE';
set termout on
@^PREFIX.core/^LDAP_SQL
@^PREFIX.core/^AUTH_LDAP_SQL
set heading off
set termout off
column temp format a80
select decode(count(*),0,'DBMS_LDAP is not installed.','') temp
  from all_objects where object_name ='DBMS_LDAP' AND OBJECT_TYPE ='PACKAGE';
set heading on
set termout on
Rem  End LDAP package specs

prompt ...installing files dependend upon 9iR2
prompt ...if errors are encountered, ignore if not 9iR2
@^PREFIX.core/wwv_flow_web_services.sql

@^PREFIX.core/processu.sql

timing stop



timing start "Package Bodies"
set define '^'
prompt  IV.   I N S T A L L   F L O W   P A C K A G E   B O D I E S
@^PREFIX.core/wwv_dbms_sql_noroles.plb


begin
    if '^UPGRADE' = '1' then
        wwv_flow_upgrade.FLOWS_FILES_OBJECTS_REMOVE('^APPUN');
    end if;
end;
/

begin
    if '^UPGRADE' = '1' then
        wwv_flow_upgrade.FLOWS_FILES_OBJECTS_CREATE('^APPUN');
    end if;
end;
/

@^PREFIX.core/meta_cleanup.plb
begin
    if '^UPGRADE' = '1' then
        wwv_flow_upgrade.SWITCH_SCHEMAS('^APPUN','^APPUN');
    end if;
end;
/
@^PREFIX.core/wwv_flow_sw_parser.sql

@^PREFIX.core/calendar.plb
@^PREFIX.core/chart.plb
@^PREFIX.core/reports3.plb
@^PREFIX.core/wwv_flow_page_cache_api.plb
@^PREFIX.core/wwv_flow_render_query.plb
@^PREFIX.core/api.plb
@^PREFIX.core/gen_api_pkg.plb
@^PREFIX.core/wwv_htf.plb
@^PREFIX.core/wwv_htp.plb
@^PREFIX.core/flow_log.plb
@^PREFIX.core/flow_dml.plb
@^PREFIX.core/flowu.plb


--
-- Compile the version of sys.wwv_dbms_sql that uses logon roles if XE or 10.2.0.3 or greater
--
column :thescript new_val script NOPRINT
variable thescript varchar2(35)
begin
    if wwv_flow_utilities.db_version_is_at_least('10.2.0.3') or wwv_flow_utilities.db_edition_is_xe then
        :thescript := 'wwv_dbms_sql.plb';
    else
        :thescript := 'null1.sql';
    end if;
end;
/
select :thescript from dual;
@^PREFIX.core/^script


@^PREFIX.core/wwv_flow_rpt_std_msg.plb

--Worksheet
@^PREFIX.core/wwv_flow_worksheet_expr.plb
@^PREFIX.core/wwv_flow_worksheet_standard.plb
@^PREFIX.core/wwv_flow_worksheet.plb
@^PREFIX.core/wwv_flow_worksheet_api.plb
@^PREFIX.core/wwv_flow_worksheet_ui.plb
@^PREFIX.core/wwv_flow_ajax.plb
@^PREFIX.core/wwv_flow_worksheet_attachment.plb
@^PREFIX.core/wwv_flow_worksheet_stickies.plb
@^PREFIX.core/wwv_flow_worksheet_dialogue.plb
@^PREFIX.core/wwv_flow_worksheet_form.plb
@^PREFIX.core/wwv_flow_worksheet_ajax.plb
@^PREFIX.core/wwv_flow_calendar_ajax.plb
@^PREFIX.core/apexws.plb

@^PREFIX.core/audit.plb
@^PREFIX.core/audit_trigger.sql
@^PREFIX.core/flowc.plb
@^PREFIX.core/flowp.plb
@^PREFIX.core/meta.plb
@^PREFIX.core/flow.plb
@^PREFIX.core/flowl.plb
@^PREFIX.core/template.plb
@^PREFIX.core/plug.plb
@^PREFIX.core/customize.plb
@^PREFIX.core/sw_util.plb
@^PREFIX.core/generic.plb
@^PREFIX.core/auth.plb
@^PREFIX.core/wwv_flow_element.plb
@^PREFIX.core/form.plb
@^PREFIX.core/check.plb
@^PREFIX.core/spell.plb
@^PREFIX.core/wwv_calculator.plb
@^PREFIX.core/wwv_flow_builder.plb
@^PREFIX.core/shortcut.plb
@^PREFIX.core/wwv_flow_fnd_developer_api.plb

prompt ...install demonstration flow specs
@^PREFIX.core/wwv_flow_sample_app.sql

prompt ...install demonstration flow bodies
@^PREFIX.core/wwv_flow_sample_app.plb

@^PREFIX.core/temp_table_init.plb
@^PREFIX.core/wwv_flow_mail.plb
@^PREFIX.core/file_mgr.plb
@^PREFIX.core/prov.plb


@^PREFIX.core/provision.plb
@^PREFIX.core/flowjob.plb

set define '^'

@^PREFIX.core/plsqljob.plb

set define '^'

@^PREFIX.core/tree.plb
@^PREFIX.core/tree3.plb
@^PREFIX.core/wizapi.plb
@^PREFIX.core/fileapi.plb
@^PREFIX.core/imgapi.plb
@^PREFIX.core/imgapi_public.plb
@^PREFIX.core/cssapi.plb
@^PREFIX.core/cssapi_public.plb
@^PREFIX.core/htmlapi.plb
@^PREFIX.core/htmlapi_public.plb
@^PREFIX.core/wwv_flow_fnd_user_api.plb
@^PREFIX.core/wwv_flow_user_api.plb
@^PREFIX.core/wwv_flow_upgrade_report.plb
@^PREFIX.core/collection.plb
@^PREFIX.core/wwv_flow_item.plb
@^PREFIX.core/custom_auth_api.plb
@^PREFIX.core/custom_auth_std.plb
@^PREFIX.core/sw_api.plb

@^PREFIX.core/ihelp.plb
@^PREFIX.core/wwv_flow_admin_api.plb
@^PREFIX.core/flowcon.plb
@^PREFIX.core/wwv_flow_svg.plb
@^PREFIX.core/popup.plb
@^PREFIX.core/wwv_flow_calendar3.plb
@^PREFIX.core/wwv_flow_hint.plb
@^PREFIX.core/wwv_flow_series_attr.plb
@^PREFIX.core/edit_report.plb
@^PREFIX.core/query_api.plb
@^PREFIX.core/imp_parser.plb
@^PREFIX.core/wwv_flow_developer_toolbar.plb
@^PREFIX.core/flow_isc.plb
@^PREFIX.core/wwv_flow_web_services.plb
@^PREFIX.core/htmldb_util.plb
@^PREFIX.core/htmldb_item.plb
@^PREFIX.core/htmldb_custom_auth.plb
@^PREFIX.core/htmldb_lang.plb
@^PREFIX.core/wwv_flow_form_control.plb
@^PREFIX.core/wwv_flow_theme_1.plb
@^PREFIX.core/wwv_flow_theme_2.plb
@^PREFIX.core/wwv_flow_theme_3.plb
@^PREFIX.core/wwv_flow_theme_4.plb
@^PREFIX.core/wwv_flow_theme_5.plb
@^PREFIX.core/wwv_flow_theme_6.plb
@^PREFIX.core/wwv_flow_theme_7.plb
@^PREFIX.core/wwv_flow_theme_8.plb
@^PREFIX.core/wwv_flow_theme_9.plb
@^PREFIX.core/wwv_flow_theme_10.plb
@^PREFIX.core/wwv_flow_theme_11.plb
@^PREFIX.core/wwv_flow_theme_12.plb
@^PREFIX.core/wwv_flow_theme_13.plb
@^PREFIX.core/wwv_flow_theme_14.plb
@^PREFIX.core/wwv_flow_theme_15.plb
@^PREFIX.core/wwv_flow_theme_16.plb
@^PREFIX.core/wwv_flow_theme_17.plb
@^PREFIX.core/wwv_flow_theme_18.plb
@^PREFIX.core/wwv_flow_theme_19.plb
@^PREFIX.core/wwv_flow_theme_20.plb
@^PREFIX.core/wwv_flow_theme_manager.plb
@^PREFIX.core/htmldb_site_admin_privs.plb

@^PREFIX.core/wwv_flow_login.plb

@^PREFIX.core/wwv_flow_ppr_util.plb
@^PREFIX.core/wwv_flow_sw_script.plb
@^PREFIX.core/wwv_flow_list.plb
@^PREFIX.core/wwv_flow_sw_parser.plb
@^PREFIX.core/wwv_flow_sc_transactions.plb
@^PREFIX.core/wwv_flow_sw_upgrade.plb
@^PREFIX.core/wwv_flow_print_util.plb
@^PREFIX.core/wwv_flow_flash_chart.plb
@^PREFIX.core/wwv_flow_flash_chart2.plb
@^PREFIX.core/wwv_flow_flash_chart_util.plb
@^PREFIX.core/wwv_flow_instance_admin.plb
@^PREFIX.core/wwv_flow_create_app_from_query.plb


@^PREFIX.core/wwv_flow_epg_include.plb

Rem  Only install the ldap packages if dbms_ldap exists
column temp new_val LDAP_PLB
column temp2 new_val AUTH_LDAP_PLB
set termout off
set heading off
select decode(count(*),0,'null1.sql','ldap.plb') temp from all_objects where object_name ='DBMS_LDAP' AND OBJECT_TYPE ='PACKAGE';
select decode(count(*),0,'null1.sql','custom_auth_ldap.plb') temp2 from all_objects where object_name ='DBMS_LDAP' AND OBJECT_TYPE ='PACKAGE';
set termout on
@^PREFIX.core/^LDAP_PLB
@^PREFIX.core/^AUTH_LDAP_PLB
set termout off
set heading off
column temp format a80
select decode(count(*),0,'DBMS_LDAP is not installed.','') temp
  from all_objects where object_name ='DBMS_LDAP' AND OBJECT_TYPE ='PACKAGE';
set termout on
set heading on
Rem  End LDAP package bodies

@^PREFIX.core/processu.plb
@^PREFIX.core/migrate_metadata.plb

set define '^'

prompt ...page Builder
@^PREFIX.core/p.sql

@^PREFIX.core/wwv_flow_regexp.plb

@^PREFIX.core/apex_views.sql

timing stop

timing start "Grants"
prompt  V.   P E R F O R M   F L O W   G R A N T S
grant select on WWV_FLOW_LOV_TEMP to PUBLIC;

column thescript new_val script
set termout off
select decode('^UPGRADE','1','flows_files_new2.sql','null1.sql') thescript from dual;
set termout on


prompt  Installing flows_files objects 2

alter session set current_schema = FLOWS_FILES;

@^PREFIX.core/^script

alter session set current_schema = ^APPUN;

timing stop

timing start "Install Internal Flows"
prompt  VI.   I N S T A L L    F L O W S
set define '^'
show define

column foo new_val script
set termout off
select decode('^INSTALL_TYPE','MANUAL','apxsqler.sql','RUNTIME','apxsqler.sql','core/null1.sql') foo from dual;
set termout on
@^PREFIX.^script


prompt ...internal messages
@^PREFIX.builder/f4411.sql

set define '^'

@^PREFIX.builder/f4155.sql

set define '^'


-- Set the mail preferences to default values
prompt ...Initialize SMTP server settings
insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('SMTP_HOST_ADDRESS','localhost','The address of the SMTP server used to relay mail.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('SMTP_HOST_PORT','25','The port that the SMTP server listens for requests.',10);

-- Set script and result quota preferences to default values
prompt ...Initialize preference settings
insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('MAX_SCRIPT_SIZE','500000','The maximum allowable size for a script text.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('SQL_SCRIPT_MAX_OUTPUT_SIZE','200000','The maximum allowable size for an individual script result.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('WORKSPACE_MAX_OUTPUT_SIZE','2000000','The maximum space allocated for script results.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('ENABLE_TRANSACTIONAL_SQL','Y','The flag which determines if Transactional SQL Commands are enabled on this instance.',10);

-- Set PL/SQL editing flag to default value
insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('PLSQL_EDITING','Y','The flag used in SQL Workshop Object Browser to enable user to edit and compile PL/SQL.',10);

-- Set Instance Administration creation of demonstration objects flag to default value
insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('WORKSPACE_PROVISION_DEMO_OBJECTS','Y','The flag used in Instance Adminstration which determines if demonstration applications and database objects are created in new workspaces.',10);


-- Default values for restrictions on workspace and adminstration login and general security settings
insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('DISABLE_ADMIN_LOGIN','N','The flag which determines if Adminstration services are disabled.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('DISABLE_WORKSPACE_LOGIN','N','The flag which determines if workspace login is disabled.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('ALLOW_PUBLIC_FILE_UPLOAD','Y','The flag which determines if file uploads are allowed without user authentication.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('STRONG_SITE_ADMIN_PASSWORD','Y','The flag which determines if the apex_admin password must conform to the default set of stong complexity rules.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('PASSWORD_ALPHA_CHARACTERS','abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ','The alphabetic characters used for pasword complexity rules.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('PASSWORD_PUNCTUATION_CHARACTERS','!"#$%&()``*+,-/:;<=>?_','The punctuation characters used for pasword complexity rules.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('MAX_SESSION_LENGTH_SEC','28800','The number of seconds an internal application session may exist.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('MAX_SESSION_IDLE_SEC','3600','The number of seconds an internal application may be idle.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('ALLOW_DB_MONITOR','N','The flag which determines if database monitoring is enabled.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('SERVICE_REQUEST_FLOW','MANUAL','Determines default provisioning mode.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('PRINT_BIB_LICENSED','STANDARD','Determines BI Publisher licensing level.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('DISABLE_WS_PROV','N','The flag which determines if workspace creation is disabled for requests sent out via e-mail notification.',10);

insert into wwv_flow_platform_prefs (name, value, pref_desc, security_group_id)
values ('REQ_NEW_SCHEMA','N','The flag which determines if option for new schema for new workspace requests is disabled.',10);


commit;

set verify off

prompt ...Initialize the table of Oracle default schema names
begin
--
-- Insert rows only if this is a new installation or an upgrade from a pre-2.0 version
-- For upgrades from version 2.x to a higher version it is not necessary to populate the
-- table here. Instead, the upgrade package will copy existing rows from the wwv_flow_restricted_schemas
-- in the FROM schema to the wwv_flow_restricted_schemas table in the TO schema.
--
if '^UPGRADE' = '1' or ('^UPGRADE' = 2 and '^UFROM' in ('FLOWS_010500','FLOWS_010600')) then
insert into wwv_flow_restricted_schemas(id,schema) values( 1,'SYS');
insert into wwv_flow_restricted_schemas(id,schema) values( 2,'SYSTEM');
insert into wwv_flow_restricted_schemas(id,schema) values( 3,'OUTLN');
insert into wwv_flow_restricted_schemas(id,schema) values( 4,'DIP');
insert into wwv_flow_restricted_schemas(id,schema) values( 5,'DBSNMP');
insert into wwv_flow_restricted_schemas(id,schema) values( 6,'WMSYS');
insert into wwv_flow_restricted_schemas(id,schema) values( 7,'EXFSYS');
insert into wwv_flow_restricted_schemas(id,schema) values( 8,'ORDSYS');
insert into wwv_flow_restricted_schemas(id,schema) values( 9,'ORDPLUGINS');
insert into wwv_flow_restricted_schemas(id,schema) values(10,'SI_INFORMTN_SCHEMA');
insert into wwv_flow_restricted_schemas(id,schema) values(11,'MDSYS');
insert into wwv_flow_restricted_schemas(id,schema) values(12,'DMSYS');
insert into wwv_flow_restricted_schemas(id,schema) values(13,'CTXSYS');
insert into wwv_flow_restricted_schemas(id,schema) values(14,'XDB');
insert into wwv_flow_restricted_schemas(id,schema) values(15,'ANONYMOUS');
insert into wwv_flow_restricted_schemas(id,schema) values(16,'OLAPSYS');
insert into wwv_flow_restricted_schemas(id,schema) values(17,'MDDATA');
insert into wwv_flow_restricted_schemas(id,schema) values(18,'WKSYS');
insert into wwv_flow_restricted_schemas(id,schema) values(19,'WKPROXY');
insert into wwv_flow_restricted_schemas(id,schema) values(20,'WK_TEST');
insert into wwv_flow_restricted_schemas(id,schema) values(21,'SYSMAN');
insert into wwv_flow_restricted_schemas(id,schema) values(22,'MGMT_VIEW');
insert into wwv_flow_restricted_schemas(id,schema) values(23,'LBACSYS');
insert into wwv_flow_restricted_schemas(id,schema) values(24,'ODM');
insert into wwv_flow_restricted_schemas(id,schema) values(25,'ODM_MTR');
insert into wwv_flow_restricted_schemas(id,schema) values(26,'OE');
insert into wwv_flow_restricted_schemas(id,schema) values(27,'PM');
insert into wwv_flow_restricted_schemas(id,schema) values(28,'SH');
insert into wwv_flow_restricted_schemas(id,schema) values(29,'QS');
insert into wwv_flow_restricted_schemas(id,schema) values(30,'QS_ADM');
insert into wwv_flow_restricted_schemas(id,schema) values(31,'QS_CB');
insert into wwv_flow_restricted_schemas(id,schema) values(32,'QS_CBADM');
insert into wwv_flow_restricted_schemas(id,schema) values(33,'QS_CS');
insert into wwv_flow_restricted_schemas(id,schema) values(34,'QS_ES');
insert into wwv_flow_restricted_schemas(id,schema) values(35,'QS_OS');
insert into wwv_flow_restricted_schemas(id,schema) values(36,'QS_WS');
insert into wwv_flow_restricted_schemas(id,schema) values(37,'RMAN');
if wwv_flow_global.g_xe = FALSE then
    insert into wwv_flow_restricted_schemas(id,schema) values(38,'SCOTT');
end if;
insert into wwv_flow_restricted_schemas(id,schema) values(39,'PERFSTAT');
insert into wwv_flow_restricted_schemas(id,schema) values(40,'AURORA$JIS$UTILITY$');
insert into wwv_flow_restricted_schemas(id,schema) values(41,'OSE$HTTP$ADMIN');
insert into wwv_flow_restricted_schemas(id,schema) values(42,'AURORA$ORB$UNAUTHENTICATED');
insert into wwv_flow_restricted_schemas(id,schema) values(43,'TSMSYS');
insert into wwv_flow_restricted_schemas(id,schema) values(44,'DVSYS');
insert into wwv_flow_restricted_schemas(id,schema) values(45,'DVF');
insert into wwv_flow_restricted_schemas(id,schema) values(46,'AVSYS');
commit;
end if;
end;
/

timing stop
---------------------------------

prompt ...Development install if necessary
column foo new_val script
set termout off
select decode('^INSTALL_TYPE','RUNTIME','core/null1.sql','devins.sql') foo from dual;
set termout on
@^PREFIX.^script ^LOG1 ^UPGRADE ^APPUN ^TEMPTBL ^IMGPR ^DATTS ^FF_TBLS ^ADM_PWD ^PREFIX

set termout on

prompt ...Adjust flow owner to install owner
update wwv_flows set owner = '^APPUN' where id between 4000 and 4999;
commit;

prompt ...Adjust flow version


column flow_version new_val version
set termout off
select wwv_flows_release flow_version from dual where rownum = 1;
set termout on

update wwv_flows set flow_version = '&PRODUCT_NAME. ' || '^version' where id between 4000 and 4999 and id <> 4550;
update wwv_flows set flow_version = '&PRODUCT_NAME. ' where id = 4550;
commit;



timing start "English Dictionary"
prompt  VII.   L O A D    E N G L I S H   D I C T I O N A R Y

alter trigger bi_wwv_dictionary$_fer disable;

@^PREFIX.core/dictionary_load.sql

alter trigger bi_wwv_dictionary$_fer enable;

timing stop

commit;

set verify off

alter user ^APPUN account lock;
alter user FLOWS_FILES account lock;

--
-- In the event of an upgrade, grant execute on the prior versions wwv_flows_version
-- procedure to the current APEX schema
--
begin
if '^UPGRADE' = '2' then
    execute immediate 'grant execute on ^UFROM..wwv_flows_version to ^APPUN';
end if;
end;
/


timing start "Upgrade"

set serveroutput on
set feedback off
Begin
If '^UPGRADE' = '2' Then
    dbms_output.put_line('');
    dbms_output.put_line('   -- Now beginning upgrade. This will take several minutes.-------');
    dbms_output.put_line('');
    dbms_output.put_line('');
End if;
end;
/

Begin
If '^UPGRADE' = '2' Then
    dbms_output.put_line('   -- Ensuring template names are unique -------');
    wwv_flow_upgrade.template_name_cleanup('^UFROM');
    wwv_flow_security.g_security_group_id := 10;
    commit;
End if;
end;
/

alter session set current_schema = SYS;
grant select any table to ^APPUN;
alter session set current_schema = ^APPUN;

Begin
If '^UPGRADE' = '2' Then
	dbms_output.put_line('   -- Migrating metadata to new schema -------');
    wwv_flow_upgrade.copy_flow_meta_data('^UFROM','^APPUN');
    commit;
End if;
end;
/

Begin
If '^UPGRADE' = '2' Then
	dbms_output.put_line('   -- Switching builder to new schema -------');
    wwv_flow_upgrade.switch_schemas('^UFROM','^APPUN');
    commit;
End if;
end;
/


begin
    if '^UPGRADE' = '2' Then
	    dbms_output.put_line('   -- Recompile WWV_DBMS_SQL -------');
        execute immediate 'alter package sys.wwv_dbms_sql compile body';
    end if;
end;
/


begin
if '^UPGRADE' = '2' Then
	dbms_output.put_line('   -- Migrating SQL Workshop metadata -------');
    wwv_flow_upgrade.sw_cleanup('^UFROM','^APPUN');
    commit;
end if;
end;
/

alter package wwv_flow_assert compile body;

Begin
If '^UPGRADE' = '2' Then
	dbms_output.put_line('   -- Upgrading new schema. -------');
    wwv_flow_upgrade.upgrade_to_030200(p_owner => '^APPUN', p_from => '^UFROM');
    commit;
End if;
end;
/

Begin
If '^UPGRADE' = '2' Then
	dbms_output.put_line('   -- Copying preferences to new schema. -------');
    wwv_flow_upgrade.copy_prefs('^UFROM','^APPUN');
    commit;
End if;
end;
/

alter session set current_schema = SYS;
revoke select any table from ^APPUN;
alter session set current_schema = ^APPUN;

Begin
If '^UPGRADE' = '2' Then
    for c1 in (select count(1) counter from WWV_FLOW_UPGRADE_PROGRESS where upgrade_error is not null) loop
	    if c1.counter > 0 then
            dbms_output.put_line('ERRORS EXIST!!!');
            dbms_output.put_line('...There are '||c1.counter||' errors in the log table!');
            dbms_output.put_line('...Select upgrade_error from WWV_FLOW_UPGRADE_PROGRESS to review errors.');
            dbms_output.put_line('');
        else
            dbms_output.put_line('Upgrade completed successfully no errors encountered.');
        end if;
    end loop;
    dbms_output.put_line('');
    dbms_output.put_line('');
    dbms_output.put_line('   -- Upgrade is complete -----------------------------------------');
End if;
end;
/

timing stop

prompt ...End of install if runtime install
column foo new_val script
set termout off
select decode('^INSTALL_TYPE','RUNTIME','endins.sql','core/null1.sql') foo from dual;
set termout on
@^PREFIX.^script

timing stop

column global_name new_value gname
set termout off
select user global_name from dual;
set termout on
set heading on
set feedback on
set sqlprompt '^gname> '
