Rem  Copyright (c) Oracle Corporation 1999 - 2007. All Rights Reserved.
Rem
Rem    NAME
Rem      devins.sql
Rem
Rem    DESCRIPTION
Rem      This is the development installation script for Oracle APEX, but this should never be invoked directly.
Rem      This file should only be invoked by apexins.sql or apxdvins.sql.
Rem
Rem    NOTES
Rem      Ensure that all arguments (except image prefix) are entered in UPPERCASE.
Rem
Rem    REQUIREMENTS
Rem      - Oracle database 9.2.0.3 or better
Rem      - PL/SQL Web Toolkit
Rem
Rem    Arguments:
Rem      1 - LOG1      = Installation log file
Rem      2 - UPGRADE   = Upgrade flag (1 = NO, 2 = YES)
Rem      3 - APPUN     = APEX schema name
Rem      4 - TEMPTBL   = Temporary tablespace
Rem      5 - IMGPR     = Image prefix
Rem      6 - DATTS     = APEX tablespace
Rem      7 - FF_TBLS   = APEX files tablespace
Rem      8 - ADM_PWD   = APEX administrator password
Rem
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      jstraub   06/26/2007 - Created
Rem      jstraub   09/14/2007 - Added calls to drop_private_synonyms and create_private_synonyms and removed spool off
Rem      jstraub   09/17/2007 - Removed 4155 from devins, moved to coreins
Rem      jkallman  11/21/2007 - Add wwv_flow_theme_19 and wwv_flow_theme_20
Rem      jstraub   11/26/2007 - Added running core_grants.sql
Rem      jkallman  12/13/2007 - Moved wwv_flow_theme_1-20.* to coreins.sql (dependencies in wwv_flow_theme_manager)
Rem      jstraub   12/18/2007 - Removed wwv_flow_hint.*, already compiled in coreins.sql (Bug 6651448)
Rem      jstraub   01/08/2008 - Added apex_ui_default_update.*
Rem      jstraub   01/11/2008 - Added apex_mig_projects_update.*
Rem      jstraub   01/11/2008 - Added mig_views.sql
Rem      jkallman  01/25/2008 - Removed compilation of creat_flow_api.*
Rem      jkallman  02/04/2008 - Add compilation of schema before grant_public_synonyms
Rem      jkallman  09/11/2008 - Add Forms Migration scripts
Rem      jkallman  09/19/2008 - Add wwv_mig_frm_load_xml.*
Rem      hfarrell  10/23/2008 - Removed wwv_mig_frm_load.* from compilation as no longer required. Replaced by wwv_mig_frm_load_xml.*
Rem      hfarrell  10/23/2008 - Added wwv_mig_frmmenu_load_xml.*, wwv_mig_rpt_load_xml.*
Rem      hfarrell  10/23/2008 - Added wwv_mig_frm_olb_load_xml.*
Rem      jkallman  03/31/2009 - Added compile_schema before wwv_flow_upgrade.drop_private_synonyms
Rem      jstraub   04/02/2009 - Added compile of wwv_flow_assert before call to wwv_flow_upgrade.* (Bug 8399978)
Rem      jkallman  07/23/2009 - Added wwv_flow_install_wizard


set define '^'
set concat on
set concat .
set verify off

define LOG1      = '^1'
define UPGRADE   = '^2'
define APPUN     = '^3'
define TEMPTBL   = '^4'
define IMGPR     = '^5'
define DATTS     = '^6'
define FF_TBLS   = '^7'
define ADM_PWD   = '^8'
define PREFIX    = '^9'

set termout on

timing start "Development Installation"

alter session set current_schema = SYS;

prompt I.    O R A C L E   S Y S   I N S T A L L   P R O C E S S

@^PREFIX.core/dev_grants.sql
@^PREFIX.core/core_grants.sql



prompt ...CONNECT as the Oracle user who will own the APEX engine

alter session set current_schema = ^APPUN;

timing start "Development Package Specs"
prompt  III.   I N S T A L L   F L O W   P A C K A G E   S P E C S

@^PREFIX.core/wwv_flow_plsql_editor.sql
@^PREFIX.core/wwv_flow_model_api.sql
@^PREFIX.core/wwv_flow_f4000_util.sql
@^PREFIX.core/wwv_flow_image_generator.sql

prompt  Installing Application Migration Workshop objects
@^PREFIX.core/wwv_mig_create_ddl.sql
@^PREFIX.core/wwv_mig_frm_create_ddl.sql
@^PREFIX.core/wwv_mig_exporter_ins.sql


@^PREFIX.core/mig_views.sql

prompt ...installing Application Migration Workshop package spec
@^PREFIX.core/wwv_mig_acc_load.sql
@^PREFIX.core/wwv_mig_frm_update_apx_app.sql
@^PREFIX.core/wwv_mig_frm_utilities.sql
@^PREFIX.core/wwv_mig_frm_load_xml.sql
@^PREFIX.core/wwv_mig_frmmenu_load_xml.sql
@^PREFIX.core/wwv_mig_rpt_load_xml.sql
@^PREFIX.core/wwv_mig_frm_olb_load_xml.sql

prompt ...install Application Migration Workshop package body
@^PREFIX.core/wwv_mig_acc_load.plb
@^PREFIX.core/wwv_mig_frm_update_apx_app.plb
@^PREFIX.core/wwv_mig_frm_utilities.plb
@^PREFIX.core/wwv_mig_frm_load_xml.plb
@^PREFIX.core/wwv_mig_frmmenu_load_xml.plb
@^PREFIX.core/wwv_mig_rpt_load_xml.plb
@^PREFIX.core/wwv_mig_frm_olb_load_xml.plb


@^PREFIX.core/wwv_flow_item_comps.sql
@^PREFIX.core/copy.sql
@^PREFIX.core/copy_lov.sql
@^PREFIX.core/copy_item.sql
@^PREFIX.core/copy_button.sql
@^PREFIX.core/wwv_flow_translation_utilities.sql
@^PREFIX.core/seed.sql
@^PREFIX.core/sync.sql
@^PREFIX.core/layout.sql
@^PREFIX.core/wwv_lov_used_on_pages.sql
@^PREFIX.core/wwv_flow_query_builder.sql
@^PREFIX.core/wwv_flow_sw_object_feed.sql
@^PREFIX.core/wwv_flow_load_data.sql
@^PREFIX.core/wwv_flow_load_excel_data.sql
@^PREFIX.core/copy_metadata.sql
@^PREFIX.core/copyu.sql
@^PREFIX.core/wwv_flow_tab_mgr.sql
@^PREFIX.core/generate_ddl.sql
@^PREFIX.core/table_drill.sql
@^PREFIX.core/wwv_flow_download.sql
@^PREFIX.core/wwv_flow_copy_page.sql
@^PREFIX.core/generate_table_api.sql
@^PREFIX.core/wwv_flow_gen_hint.sql
@^PREFIX.core/wwv_flow_xliff.sql
@^PREFIX.core/wwv_flow_create_model_app.sql
@^PREFIX.core/apex_admin.sql
@^PREFIX.core/wwv_flow_help.sql
@^PREFIX.core/wwv_flow_data_quick_flow.sql
@^PREFIX.core/wwv_flow_theme_files.sql
@^PREFIX.core/wwv_flow_session_mon.sql
@^PREFIX.core/wwv_flow_sw_page_calls.sql
@^PREFIX.core/wwv_flow_wiz_confirm.sql
@^PREFIX.core/wwv_flow_page_map.sql
@^PREFIX.core/wwv_flow_drag_layout.sql
@^PREFIX.core/wwv_flow_dataload_xml.sql
@^PREFIX.core/apex_ui_default_update.sql
@^PREFIX.core/apex_mig_projects_update.sql
@^PREFIX.core/wwv_flow_install_wizard.sql

timing stop

timing start "Development Package Bodies"

@^PREFIX.core/wwv_flow_plsql_editor.plb
@^PREFIX.core/wwv_flow_model_api.plb
@^PREFIX.core/wwv_flow_f4000_util.plb
@^PREFIX.core/wwv_flow_image_generator.plb
@^PREFIX.core/layout.plb
@^PREFIX.core/wwv_flow_query_builder.plb
@^PREFIX.core/wwv_flow_sw_object_feed.plb
@^PREFIX.core/wwv_flow_load_data.plb
@^PREFIX.core/wwv_flow_load_excel_data.plb
@^PREFIX.core/copy_metadata.plb
@^PREFIX.core/copyu.plb
@^PREFIX.core/wwv_flow_tab_mgr.plb
@^PREFIX.core/generate_ddl.plb
@^PREFIX.core/table_drill.plb
@^PREFIX.core/wwv_flow_download.plb
@^PREFIX.core/wwv_flow_copy_page.plb
@^PREFIX.core/generate_table_api.plb
@^PREFIX.core/wwv_flow_gen_hint.plb
@^PREFIX.core/wwv_flow_xliff.plb
@^PREFIX.core/wwv_flow_create_model_app.plb
@^PREFIX.core/wwv_flow_help.plb
@^PREFIX.core/wwv_flow_data_quick_flow.plb
@^PREFIX.core/wwv_flow_theme_files.plb
@^PREFIX.core/wwv_flow_session_mon.plb
@^PREFIX.core/wwv_flow_sw_page_calls.plb
@^PREFIX.core/wwv_flow_wiz_confirm.plb
@^PREFIX.core/wwv_flow_page_map.plb
@^PREFIX.core/wwv_flow_drag_layout.plb
@^PREFIX.core/wwv_flow_dataload_xml.plb
@^PREFIX.core/apex_ui_default_update.plb
@^PREFIX.core/apex_mig_projects_update.plb
@^PREFIX.core/wwv_flow_install_wizard.plb

prompt ...install demonstration flow specs
@^PREFIX.core/collections_showcase.sql

prompt ...install demonstration flow bodies
@^PREFIX.core/collections_showcase.plb

timing stop

grant execute on wwv_mig_acc_load to public;


begin
    wwv_flow_security.g_security_group_id := 10;
end;
/

timing start "Install Internal Development Applications"
prompt  VI.   I N S T A L L    F L O W S
set define '^'
show define

@^PREFIX.builder/f4000.sql

set define '^'

@^PREFIX.builder/f4350.sql

set define '^'

@^PREFIX.builder/f4050.sql

set define '^'

@^PREFIX.builder/f4550.sql

set define '^'

@^PREFIX.builder/f4700.sql

set define '^'

@^PREFIX.builder/f4500.sql

set define '^'

@^PREFIX.builder/f4300.sql

set define '^'

@^PREFIX.builder/f4400.sql

set define '^'

-- Update image prefix of all builder flows
begin
    wwv_flow_security.g_security_group_id := 10;
    for c1 in (select id
                 from wwv_flows
                where security_group_id = 10)
    loop
        wwv_flow_api.set_image_prefix(
            p_flow_id       => c1.id,
            p_image_prefix  => '^IMGPR'
        );
    end loop;--c1
end;
/

set verify off

---------------------------------

set termout on

prompt ...Adjust flow owner to install owner
update wwv_flows set owner = '^APPUN' where id between 4000 and 4999;
commit;

prompt ...Adjust flow version

column flow_version new_val version
set termout off
select wwv_flows_release flow_version from dual where rownum = 1;
set termout on

update wwv_flows set flow_version = '&PRODUCT_NAME. ' || '^version' where id between 4000 and 4999 and id <> 4550;
update wwv_flows set flow_version = '&PRODUCT_NAME. ' where id = 4550;
commit;

timing stop


timing start "Verification Images Load"
@^PREFIX.core/verification_images_load.sql
timing stop


set verify off


begin
    dbms_utility.compile_schema( '^APPUN',FALSE );
end;
/

alter package wwv_flow_assert compile body;

begin
    wwv_flow_upgrade.drop_private_synonyms('^APPUN');
end;
/

alter package wwv_flow_assert compile body;

begin
    wwv_flow_upgrade.drop_public_synonyms();
end;
/

alter package wwv_flow_assert compile body;

begin
    wwv_flow_upgrade.create_private_synonyms('^APPUN');
end;
/

alter package wwv_flow_assert compile body;

begin
    wwv_flow_upgrade.create_public_synonyms('^APPUN');
end;
/

alter package wwv_flow_assert compile body;

begin
    dbms_utility.compile_schema( '^APPUN',FALSE );
end;
/

alter package wwv_flow_assert compile body;

begin
    wwv_flow_upgrade.grant_public_synonyms('^APPUN');
end;
/

@^PREFIX.endins.sql
