Rem  Copyright (c) Oracle Corporation 1999 - 2007. All Rights Reserved.
Rem
Rem    NAME
Rem      endins.sql
Rem
Rem    DESCRIPTION
Rem      This is the end of installation script that prompts with structure of Application Express links
Rem      and performs component validation.
Rem
Rem    REQUIREMENTS
Rem      - Oracle database 9.2.0.3 or better
Rem      - PL/SQL Web Toolkit
Rem
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      jstraub   07/10/2007 - Created

prompt
prompt
prompt
prompt      Thank you for installing Oracle Application Express.
prompt
prompt      Oracle Application Express is installed in the ^APPUN schema.
prompt
prompt      The structure of the link to the Application Express administration services is as follows:
prompt      http://host:port/pls/apex/apex_admin (Oracle HTTP Server with mod_plsql)
prompt      http://host:port/apex/apex_admin     (Oracle XML DB HTTP listener with the embedded PL/SQL gateway)
prompt
prompt      The structure of the link to the Application Express development interface is as follows:
prompt      http://host:port/pls/apex (Oracle HTTP Server with mod_plsql)
prompt      http://host:port/apex     (Oracle XML DB HTTP listener with the embedded PL/SQL gateway)
prompt

begin
for c1 in (select value
             from v$parameter
            where name = 'job_queue_processes') loop
    dbms_output.put_line('JOB_QUEUE_PROCESSES: '|| c1.value);
    exit;
end loop;
end;
/

alter session set current_schema = SYS;

prompt
prompt      Performing Application Express component validation - please wait...
prompt
timing start "Validate Installation"
begin
    dbms_output.put_line('Completing registration process.');
    if '^UPGRADE' = '1' then
       dbms_registry.loaded('APEX','^version');
    elsif '^UPGRADE' = '2' then
        if dbms_registry.status('APEX') = 'UPGRADING' then
            dbms_registry.upgraded('APEX','^version');
        else --it has never been registered, so register it now
            dbms_registry.loaded('APEX','^version');
        end if;
    end if;
    dbms_output.put_line('Validating installation.');
    validate_apex;
end;
/
timing stop

alter session set current_schema = ^APPUN;
