#################################################################################
#
# $Header: BaseSession.pm 20-jul-2005.01:34:58 gsbhatia Exp $
#
# BaseSession.pm
#
# Copyright (c) 2003, 2005, Oracle. All rights reserved.  
#
#    NAME
#      BaseSession.pm - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YYYY)
#       gsbhatia   07/20/05 - Refactor code 
#       gsbhatia   01/25/05 - Added parameter support 
#       ktlaw      01/14/05 - add comments 
#       ktlaw      01/13/05 - ktlaw_new_repmgr
#       ktlaw      01/10/05 - created
################################################################################

#Base SQL session object for Component and Repository to execute commands and
#scripts, also encapsulate common repository operations. This class is considered
#to be an abstract class, subclass of this class should implement executeScript 
#and executeCmd accordingly

package BaseSession;

sub new
{
  my ($pkg) = @_ ;
  my $self = {};
  bless $self, $pkg ;
  return $self;
}

sub executeScripts
{
  my $self = shift ;
  my ($sqls) = @_ ;
  foreach $h (@$sqls)
  {
    #print "processing ".$h->{'path'}."\n";
    my $path = $h->{'path'};
    my @params = @{$h->{'params'}};
    for my $param (@params){
      $path .= " \&$param";
    } 
    $self->executeScript($path);
  }
}

sub recompileInvalidObjects
{
  my $self = shift ;
  $self->executeScript("$EM_SQL_SCRIPT_ROOT/core/latest/admin/admin_recompile_invalid.sql $EM_REPOS_USER");
}

sub setComponentVersion
{
  my $self = shift ;
  my ($comp,$ver) = @_ ;
  uc $comp ;
  $self->exeucteCmd("EXECUTE EMD_MAINTENANCE.SET_VERSION('$comp', '$ver', '$ver', '&&EM_REPOS_MODE', EMD_MAINTENANCE.G_STATUS_INITIALIZED);");
}

sub createViewUser
{
  my $self = shift ;
  $self->executeScript("$EM_SQL_SCRIPT_ROOT/core/latest/user_model/user_create_view_user.sql");
}

sub submitDBMSJobs
{
  my $self = shift ;
  $self->executeScript("$EM_SQL_SCRIPT_ROOT/core/latest/admin/admin_submit_dbms_jobs.sql");
}

sub removeDBMSJobs
{
  my $self = shift ;
  $self->exeuteScript("$EM_SQL_ROOT/core/latest/admin/admin_remove_dbms_jobs.sql");
}

sub setRepositoryStatusReady
{
  my $self = shift ;
  $self->executeCmd("EXECUTE EMD_MAINTENANCE.SET_COMP_STATUS('CORE', EMD_MAINTENANCE.G_STATUS_CONFIGURED_READY);");
}

sub setRepositoryVariables
{
  my $self = shift ;
  $self->executeScript("$EMDW_HOME/sysman/emdrep/config/repository.variables.template");
  $self->executeScript("$EMDW_HOME/sysman/emdrep/config/repository.variables");
}
sub preUpgrade
{
  my $self = shift ;
  $self->executeScript("$EMDW_HOME/sysman/emdrep/config/pre_upgrade.sql");
}

sub setUpgraded
{
  my $self = shift ;
  $self->executeCmd("DECLARE
  l_comp_name VARCHAR2(256);
BEGIN
  l_comp_name := 'EM';
  IF NOT ('&EM_REPOS_MODE' = 'CENTRAL') THEN
    EXECUTE IMMEDIATE 'BEGIN dbms_registry.upgraded(:1); dbms_registry.valid(:2); END;' USING l_comp_name, l_comp_name;
  END IF;
END;
/");
}

sub setUpgrading
{
  my $self = shift ;
  $self->executeCmd("DECLARE
  l_comp_name VARCHAR2(256);
BEGIN
  l_comp_name := 'EM';
  IF NOT ('&EM_REPOS_MODE' = 'CENTRAL') THEN
    EXECUTE IMMEDIATE 'BEGIN dbms_registry.upgrading(:1); END;' USING l_comp_name;
  END IF;
END;
/");
}

1;
