#################################################################################
#
# $Header: ExecJava.pm 16-apr-2007.11:02:07 mfidanbo Exp $
#
# ExecJava.pm
#
# Copyright (c) 2003, 2007, Oracle. All rights reserved.  
#
#    NAME
#      ExecJava.pm - Execute Java within rep manager
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YYYY)
#       mfidanbo   04/16/07 - fix NT problem
#       mfidanbo   03/14/07 - add debug statements
#       mfidanbo   03/14/07 - fix minor issues
#    mfidanbo    03/12/2007 - Created
################################################################################

package ExecJava;

use IO::Handle;
use Path;

sub new
{
  my $ref = {};
  $ref->{'output'} = undef ;
  $ref->{'classpath'} = new Path ;
  $ref->{'cmd'} = undef ;
  bless $ref;
  return $ref;
}


sub addClasspath
{
  my $self = shift ;
  (my $file) = @_;
  $self->{'classpath'}->add($file);
}

sub run
{
  my $self = shift ;
  (my $command, $connect_string, $sysman_user, $sysman_pw, $output, $args) = @_ ;

  $oracleHome = $ENV{'ORACLE_HOME'};
  my $classpath = $self->{'classpath'}->toString();

  $self->{'output'} = $output;
  $self->{'cmd'} = "$oracleHome/jdk/bin/java -cp \"$classpath\" $command $args" ;
  my $fh = IO::Handle->new();
   
  if(!(defined $self->{'output'}))
  {
    $self->{'output'} = "/dev/null";
  }

  print "ExecJava: Running ".$self->{'cmd'};

  open($fh,"|$self->{'cmd'} 2>>$self->{'output'}");
  print $fh "$connect_string|"; 
  print $fh "$sysman_user|";
  print $fh "$sysman_pw|";
  print $fh "$oracleHome";
  print $fh "\n";
  close($fh); 
}

1;
