#################################################################################
#
# $Header: Logger.pm 19-jul-2005.20:54:07 gsbhatia Exp $
#
# Logger.pm
#
# Copyright (c) 2003, 2005, Oracle. All rights reserved.  
#
#    NAME
#      Logger.pm - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YYYY)
#       gsbhatia   07/19/05 - Some enhancements 
#       gsbhatia   07/18/05 - gsbhatia_repmgr_fix
#       gsbhatia   07/15/05 - created 
################################################################################

package Logger;

use strict;
use Carp;

sub new{
  my ($class) = @_;
  my $self={}; 
  bless $self, $class;
  $self->{'verbose'} = 0;
  #By default log to stdout
  $self->setOutputFile('-');
  return $self; 
}

sub setOutputFile{
  my ($self, $file) = @_;
  $self->{'out'} = $file;
  $self->{'first'} = 1; 
}

sub setVerbose{
  my $self = shift;
  $self->{'verbose'}=1;
}

sub unsetVerbose{
  my $self = shift;
  $self->{'verbose'} = 0;
}

sub write_to_file($) {
  my ($self, $msg) = @_;
  
  my $file_to_open;
  chomp ($msg);
  if ($self->{'first'} > 0)
  {
    $file_to_open = "> " . $self->{'out'};
    $self->{'first'} = 0;
  }
  else
  {
    $file_to_open = ">> " . $self->{'out'};
  }

  if ( open(OUTPUT_FILE, $file_to_open) )
  {
    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
    if ($year<=1000) {$year += 1900;}
    $mon += 1;
    my $prefix = sprintf("%02d-%02d-%4d %02d:%02d:%02d",
                         $mday,$mon,$year,$hour,$min,$sec);
    
    printf(OUTPUT_FILE "[%s] %s\n",$prefix, $msg);
    close(OUTPUT_FILE);
  }
}

sub trace($){
  my ($self, $trcmsg) = @_;
  if ($self->{'verbose'}){
    $self->write_to_file("$trcmsg");
    print $trcmsg;
  }
}        
 
sub traceln($) {
  my ($self, $trcmsg) = @_;
  $self->trace("$trcmsg\n");
}

sub info($) {
  my ($self, $logmsg) = @_;
  $self->write_to_file("$logmsg");
}

sub infoln($) {
  my ($self, $logmsg) = @_;
  $self->info("$logmsg\n");
}

sub warn($){
  my ($self, $msg) = @_;
  my $warning = Carp::longmess($msg);
  $self->infoln($warning);
}

sub warnAndDie($){
  my ($self, $msg) = @_;
  $self->warn($msg);
  Carp::confess($msg);
}

1;
