#################################################################################
#
# $Header: ScriptSession.pm 18-jan-2005.15:46:46 ktlaw Exp $
#
# ScriptSession.pm
#
# Copyright (c) 2003, 2005, Oracle. All rights reserved.  
#
#    NAME
#      ScriptSession.pm - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YYYY)
#       ktlaw      01/18/05 - 
#       ktlaw      01/17/05 - 
#       ktlaw      01/14/05 - add comments 
#       ktlaw      01/13/05 - ktlaw_new_repmgr
#       ktlaw      01/10/05 - created
################################################################################

#
# ScriptSession - Implementation of BaseSession that output all SQL cmds to a file
# handle. This can be used to generate a SQL script for running the required 
# repository or component operation at a later time.
#
package ScriptSession;
use BaseSession;
@ISA = qw(BaseSession);

my $h ;

sub new
{
  my ($pkg,$fh) = @_;
  my $self = $pkg->SUPER::new();
  $self->{'fh'} = $fh ;
  return $self;
}

sub executeCmd
{
  my $self = shift ;
  my ($cmd) = @_;
  my $fh = $self->{'fh'}  ;
  print $fh "$cmd\n";
}

sub executeScript
{
  my $self = shift ;
  my ($cmd) = @_;
  my $fh = $self->{'fh'}  ;
  if($cmd =~ /emdrep\/sql\/(.*)$/)
  {
    $cmd = $1 ;
    $cmd = "&EM_SQL_ROOT/$cmd";
  }
  print $fh "\@$cmd\n";
}

1;
