#################################################################################
#
# $Header: TransX.pm 18-jun-2007.10:47:37 chyu Exp $
#
# TransX.pm
#
# Copyright (c) 2003, 2007, Oracle. All rights reserved.  
#
#    NAME
#      TransX.pm - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YYYY)
#       chyu       06/18/07 - XbranchMerge chyu_lrg-2912337 from
#                             st_emcore_10.2.0.3.1db11
#       minfan     05/09/07 - ojdbc14 sunset
#       chyu       04/10/07 - adding the new jars for jdbc5
#       chyu       10/06/06 - adding a secondary method for dynamic java
#                             loading way
#       chyu       04/28/06 - modifying the classpath construction to avoid 
#                             dynamic loading 
#       smodh      02/20/06 - XbranchMerge smodh_jdbc_emcore from main 
#       smodh      02/03/06 - use ojdbc14.jar 
#       gsbhatia   09/16/05 - bug 4594073 
#       ktlaw      08/29/05 - use TransxWrapper 
#       ktlaw      07/21/05 - fix # issue 
#       ktlaw      05/26/05 - bug 4367520 look also in OH/lib
#       ktlaw      04/26/05 - fixed security issue 
#       ktlaw      10/27/04 - ktlaw_add_repmanager_transx_support
#       ktlaw      10/22/04 - add -u option 
#       ktlaw      10/22/04 - add -w option 
#       ktlaw      10/22/04 - add xdb to classpath 
#       ktlaw      10/22/04 - fix classpath 
#       ktlaw      10/20/04 - add comment 
#       ktlaw      10/20/04 - created
#     ktlaw      10/14/2004 - Created
################################################################################

package TransX;

use Directory;
use Path;
use File::Basename;
use IO::Handle;

sub new
{
  my $ref = {};
  $ref->{'cmd'} = "" ;
  $ref->{'verbose'} = undef ;
  $ref->{'output'} = undef ;
  $ref->{'cp'} = undef ;
  bless $ref;
  return $ref;
}

#
# run
# main function to run TransX, compose classpath, search for DLF files and
# execute the java command line for transx for each DLF file found
#
# @param rsc_root the root directory of rsc
# @param connect_string DB connect string
# @param sysman_user SYSMAN schema user
# @param sysman_pw SYSMAN schema password
# @param output output file to write to
# @param verbose > 1 if in verbose mode
# @param verify_only execute transx in -v mode
#
sub run1
{
 my $self = shift ;
 (my $rsc_root,$connect_string,$sysman_user,$sysman_pw,$output,$verbose,$verify_only) = @_ ;
  my $oh = $ENV{'ORACLE_HOME'};
  # my $cp = "$oh/emcore/classes/debug:$oh/jlib/emCORE.jar:$oh/jdbc/lib/ojdbc14.jar:$oh/sysman/jlib/emagentSDK.jar";
  $self->{'cp'} = new Path;
  $self->{'cp'}->add("$oh/sysman/jlib/emCORE.jar");
  $self->{'cp'}->add("$oh/oc4j/jdbc/lib/orai18n.jar");
  $self->{'cp'}->add("$oh/jdbc/lib/ojdbc14.jar");
  $self->{'cp'}->add("$oh/sysman/jlib/emagentSDK.jar");
  $self->{'cp'}->add("$oh/oc4j/jdbc/lib/ojdbc14.jar");
  $self->{'cp'}->add("$oh/oc4j/jdbc/lib/ojdbc14dms.jar");
  $self->{'cp'}->add("$oh/jdbc/lib/ojdbc5.jar");
  $self->{'cp'}->add("$oh/jdbc/lib/ojdbc5dms.jar");
  $self->{'cp'}->add("$oh/oc4j/lib/dms.jar");
  $self->{'cp'}->add("$oh/oc4j/jdbc/lib/dms.jar");
  $self->{'cp'}->add("$oh/dms/lib/dms.jar");
  my $cp = $self->{'cp'}->toString();

  $self->{'output'} = $output;
  if(!(defined $self->{'output'}))
  {
    $self->{'output'} = "/dev/null";
  }
print $cp."\n";

  my $fh = IO::Handle->new();
  my $cmd = "$oh/jdk/bin/java -cp $cp oracle.sysman.emdrep.config.EMSchemaConfiguration" ;
  $cmd = $cmd." $oh";
  $cmd = $cmd." sys";
  $cmd = $cmd." \"\"";
  $cmd = $cmd." $sysman_user";
  $cmd = $cmd." $sysman_pw";
  $cmd = $cmd." \"$connect_string\"";
  $cmd = $cmd." CENTRAL";
  open($fh,"|$cmd 2>>$self->{'output'}");
  close($fh);
}

sub run
{
  my $self = shift ;
  (my $rsc_root,$connect_string,$sysman_user,$sysman_pw,$output,$verbose,$verify_only) = @_ ;
  $self->{'cp'} = new Path;
  my %names;

  sub transx
  {
    (my $file) = @_;
    #$self->vlog("\nexecuting transx for $file\n");
    #system("$self->{'cmd'} $file 2>>$self->{'output'}");
    my $f = $self->{'fh'} ;
    print $f "$file\n" ;
  }
  
  sub addClasspath
  {
    (my $file) = @_;
    if(!defined $names{basename($file)})
    {
      $self->{'cp'}->add($file);
      $names{basename($file)} = 1 ;
    }
  }

  $oracleHome = $ENV{'ORACLE_HOME'};
  $self->{'verbose'} = $verbose; 
  $self->{'output'} = $output;
 
#  my $xdkLib = new Directory;
#  $xdkLib->setPath("$oracleHome/xdk/lib");
#  $xdkLib->find(\&addClasspath,'false','\.(jar|zip)$');  
#  $xdkLib->setPath("$oracleHome/lib");
#  $xdkLib->find(\&addClasspath,'false','x[sm].*\.jar$');  
#  $xdkLib->find(\&addClasspath,'false','transx.zip$');  
#  $xdkLib->setPath("$oracleHome/jlib");
#  $xdkLib->find(\&addClasspath,'false','x[sm].*\.jari$');  
#  $xdkLib->find(\&addClasspath,'false','transx.zip$');  

# this class path order must be observed.  Otherwise, class overloading
# could cause severe performance issues
  $self->{'cp'}->add("$oracleHome/lib/oraclexsql.jar");
  $self->{'cp'}->add("$oracleHome/lib/transx.zip");
  $self->{'cp'}->add("$oracleHome/xdk/lib/transx.zip");
  $self->{'cp'}->add("$oracleHome/lib/xml.jar");
  $self->{'cp'}->add("$oracleHome/lib/xmlparserv2.jar");
  $self->{'cp'}->add("$oracleHome/lib/xschema.jar");
  $self->{'cp'}->add("$oracleHome/lib/xsu12.jar");

  $self->{'cp'}->add("$oracleHome/rdbms/jlib/xdb.jar");
  $self->{'cp'}->add("$oracleHome/jdk/lib/dt.jar");
  $self->{'cp'}->add("$oracleHome/oc4j/jdbc/lib/orai18n.jar");
  $self->{'cp'}->add("$oracleHome/jdbc/lib/ojdbc14.jar");
  $self->{'cp'}->add("$oracleHome/emcore/classes/debug");
  $self->{'cp'}->add("$oracleHome/emcore/lib/emCORE.jar");
  $self->{'cp'}->add("$oracleHome/sysman/jlib/emCORE.jar");
  $self->{'cp'}->add("$oracleHome/oc4j/jdbc/lib/ojdbc14.jar");
  $self->{'cp'}->add("$oracleHome/oc4j/jdbc/lib/ojdbc14dms.jar");
  $self->{'cp'}->add("$oracleHome/jdbc/lib/ojdbc5.jar");
  $self->{'cp'}->add("$oracleHome/jdbc/lib/ojdbc5dms.jar");
  $self->{'cp'}->add("$oracleHome/oc4j/lib/dms.jar");
  $self->{'cp'}->add("$oracleHome/oc4j/jdbc/lib/dms.jar");
  $self->{'cp'}->add("$oracleHome/dms/lib/dms.jar");
  
  my $classpath = $self->{'cp'}->toString();
 
  #$self->{'cmd'} = "$oracleHome/jdk/bin/java -cp $classpath oracle.xml.transx.loader -u -w \"$connect_string\"";
  $self->{'cmd'} = "$oracleHome/jdk/bin/java -cp $classpath oracle.sysman.emdrep.util.TransxWrapper" ;

  my $fh = IO::Handle->new();
   
  if(!(defined $self->{'output'}))
  {
    $self->{'output'} = "/dev/null";
  }
  open(OUTF, ">>$self->{'output'}"); 
 
  $self->vlog("\n *** running TransX for files under $rsc_root ***\n");
  $self->vlog("using transx command line :\n\n$self->{'cmd'} 2>> $self->{'output'}\n\n");

  close(OUTF);
  
  open($fh,"|$self->{'cmd'} 2>>$self->{'output'}");
  $self->{'fh'} = $fh ;
  print $fh "$connect_string\n"; 
  print $fh "$sysman_user\n";
  print $fh "$sysman_pw\n";

  my $d = new Directory;
  $d->setPath($rsc_root);
  $d->find(\&transx,'true','\.dlf$');  

  #open(OUTF, ">>$self->{'output'}"); 
  #$self->vlog("\n *** done running TransX ***\n");
  #close(OUTF);
  
  print $fh "___END___\n";
  
  close($fh); 
}

sub vlog
{
  my $self = shift;
  (my $msg) = @_ ;
  if($self->{'verbose'} > 0)
  {
    print $msg;
  }
  print OUTF $msg;
}

1;
