#!/usr/local/bin/perl
#################################################################################
#
# $Header: build.pl 18-jun-2007.10:54:43 chyu Exp $
#
# build.pl
#
# Copyright (c) 2003, 2007, Oracle. All rights reserved.  
#
#    NAME
#      build.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YYYY)
#       chyu       06/18/07 - adding the additional versions
#       chyu       07/18/06 - Backport chyu_bug-5305174 from 
#                             st_emcore_10.2.0.1.0 
#       chyu       07/13/06 - adding the 10.2.0.2 version to the upgrade path 
#       chyu       07/18/06 - Backport chyu_bug-5305174 from 
#                             st_emcore_10.2.0.1.0 
#       chyu       07/13/06 - adding the 10.2.0.2 version to the upgrade path 
#       bmallipe   08/13/06 - adding the 10.2.0.0 version
#       chyu       07/18/06 - Backport chyu_bug-5305174 from 
#                             st_emcore_10.2.0.1.0 
#       chyu       07/13/06 - adding the 10.2.0.2 version to the upgrade path 
#       chyu       07/18/06 - Backport chyu_bug-5305174 from 
#                             st_emcore_10.2.0.1.0 
#       chyu       07/13/06 - adding the 10.2.0.2 version to the upgrade path 
#       chyu       05/22/06 - adding mechanism for dbcontrol header 
#       tthakur    08/08/05 - adding post_data_upgrade 
#       chyu       07/25/05 - adding the pre_data_upgrade scripts to the 
#                             upgrade path 
#       gsbhatia   07/22/05 - Use getters/setters 
#       gsbhatia   07/22/05 - Refactor code 
#       gsbhatia   07/16/05 - Add logging capabilities 
#       ktlaw      01/17/05 - ktlaw_new_repmgr3
#       ktlaw      01/14/05 - add comments 
#       ktlaw      01/13/05 - ktlaw_new_repmgr
#       ktlaw      01/10/05 - created
################################################################################

use lib "$ENV{'ADE_VIEW_ROOT'}/emcore/scripts/install";
use lib "$ENV{'ADE_VIEW_ROOT'}/emcore/sysman/admin/emdrep/bin";

use strict;
use Component;
use Repository;
use ScriptSession;
use File::Basename;
use IO::Handle;
use Logger;

my $AVR = $ENV{'ADE_VIEW_ROOT'};
die "not in view!!" if(!defined $AVR);
die "Please specify ENV variable ORACLE_HOME \n" if (!defined $ENV{ORACLE_HOME} || $ENV{ORACLE_HOME} eq "" );
die "Please specify ENV variable T_WORK \n" if (!defined $ENV{T_WORK} || $ENV{T_WORK} eq "" );

my $compLabel = undef;
my $isSA = 0;
my $NDE_PRODUCT = $ENV{'NDE_PRODUCT'};
if ($NDE_PRODUCT eq "emcore")
{
  $compLabel = "core";
}
elsif ($NDE_PRODUCT eq "emdbgc" || $NDE_PRODUCT eq "emdbsa")
{
  $compLabel = "db";
  if ($NDE_PRODUCT eq "emdbsa")
  {
    $isSA = 1;
  }
}
elsif ($NDE_PRODUCT eq "empp")
{
  $compLabel = "pp";
}

my $mode = shift ;
my $path = shift ;
my $dbpath = $path."/db/";
print "$dbpath.....";

my $h;
my $logger = Logger->new();

my $outfile = "$ENV{'T_WORK'}/parse_components.log.$$";
print "Log generated in $outfile\n";
$logger->setOutputFile($outfile);

if($mode eq '-root')
{
  if(-d $path)
  {
    my $repo = Repository->new();
    $repo->setLogger($logger);
    $repo->init($path);
    my @comps = $repo->getComponentsOrdered();
    foreach $h (@comps)
    {
      buildComponent($h);
    }    
    exit(0);
  }else
  {
    print "\ndirectory $path does not exists\n";
  }
}elsif($mode eq '-comp')
{
  if(-e $path)
  {
    my $comp = Component->new();
    if($comp->init($path))
    {
      buildComponent($comp);
    }else
    {
      print "\nError parsing $path\n";
    }	    
    exit(0);
  }else
  {
    print "\nfile $path does not exists\n";
  }
}
printUsage();
exit(0);

sub buildComponent
{
  my ($comp) = @_ ;

  print "parsing component ".$comp->getName."\n";

  $comp->parse();
  my $fh ;
  $fh = IO::Handle->new();
  
  my $compRoot = $comp->getComponentRoot;
  my $compName = $comp->getName;
  my $session ;
  
  if ($isSA eq 1 && $compLabel eq "db")
  {
    $compRoot = $dbpath;
  }

  if ($isSA eq 1)
  {
    $comp->setCondition('EM_REPOS_MODE','SYSAUX');
  }
  else
  {
    $comp->setCondition('EM_REPOS_MODE','CENTRAL');
  }

  #generate _<comp>_cre.sql
  open($fh, ">$compRoot/${compName}_cre.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->create($session);
  close($fh);
  
  #generate _<comp>_init.sql
  open($fh, ">$compRoot/${compName}_init.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->post_create($session);
  close($fh);
  
  #generate _<comp>_outofbox.sql
  open($fh, ">$compRoot/${compName}_outofbox.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->outofbox($session);
  close($fh);
  
  #generate _<comp>_<ver>_schema_upgrade.sql
  open($fh, ">$compRoot/${compName}_schema_upgrade_10.1.0.2.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->schema_upgrade($session,"10.1.0.2");
  close($fh);
  
  open($fh, ">$compRoot/${compName}_schema_upgrade_10.1.0.3.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->schema_upgrade($session,"10.1.0.3");
  close($fh);
  
  open($fh, ">$compRoot/${compName}_schema_upgrade_10.1.0.4.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->schema_upgrade($session,"10.1.0.4");
  close($fh);

  open($fh, ">$compRoot/${compName}_schema_upgrade_10.1.0.5.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->schema_upgrade($session,"10.1.0.5");
  close($fh);

  open($fh, ">$compRoot/${compName}_schema_upgrade_10.1.0.6.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->schema_upgrade($session,"10.1.0.6");
  close($fh);

  open($fh, ">$compRoot/${compName}_schema_upgrade_10.2.0.0.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->schema_upgrade($session,"10.2.0.0");
  close($fh);

  open($fh, ">$compRoot/${compName}_schema_upgrade_10.2.0.1.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->schema_upgrade($session,"10.2.0.1");
  close($fh);

  open($fh, ">$compRoot/${compName}_schema_upgrade_10.2.0.2.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->schema_upgrade($session,"10.2.0.2");
  close($fh);

  open($fh, ">$compRoot/${compName}_schema_upgrade_10.2.0.3.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->schema_upgrade($session,"10.2.0.3");
  close($fh);

  open($fh, ">$compRoot/${compName}_schema_upgrade_10.2.0.4.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->schema_upgrade($session,"10.2.0.4");
  close($fh);

  open($fh, ">$compRoot/${compName}_schema_upgrade_10.2.0.5.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->schema_upgrade($session,"10.2.0.5");
  close($fh);

  open($fh, ">$compRoot/${compName}_schema_upgrade_10.2.0.6.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->schema_upgrade($session,"10.2.0.6");
  close($fh);

  open($fh, ">$compRoot/${compName}_schema_upgrade_10.2.0.7.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->schema_upgrade($session,"10.2.0.7");
  close($fh);

  open($fh, ">$compRoot/${compName}_schema_upgrade_10.2.0.8.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->schema_upgrade($session,"10.2.0.8");
  close($fh);

  open($fh, ">$compRoot/${compName}_schema_upgrade_10.2.0.9.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->schema_upgrade($session,"10.2.0.9");
  close($fh);

  #generate _<comp>_<ver>_data_upgrade.sql
  open($fh, ">$compRoot/${compName}_data_upgrade_10.1.0.2.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->data_upgrade($session,"10.1.0.2");
  close($fh);
  
  open($fh, ">$compRoot/${compName}_data_upgrade_10.1.0.3.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->data_upgrade($session,"10.1.0.3");
  close($fh);
  
  open($fh, ">$compRoot/${compName}_data_upgrade_10.1.0.4.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->data_upgrade($session,"10.1.0.4");
  close($fh);

  open($fh, ">$compRoot/${compName}_data_upgrade_10.1.0.5.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->data_upgrade($session,"10.1.0.5");
  close($fh);

  open($fh, ">$compRoot/${compName}_data_upgrade_10.1.0.6.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->data_upgrade($session,"10.1.0.6");
  close($fh);

  open($fh, ">$compRoot/${compName}_data_upgrade_10.2.0.0.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->data_upgrade($session,"10.2.0.0");
  close($fh);

  open($fh, ">$compRoot/${compName}_data_upgrade_10.2.0.1.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->data_upgrade($session,"10.2.0.1");
  close($fh);

  open($fh, ">$compRoot/${compName}_data_upgrade_10.2.0.2.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->data_upgrade($session,"10.2.0.2");
  close($fh);

  open($fh, ">$compRoot/${compName}_data_upgrade_10.2.0.3.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->data_upgrade($session,"10.2.0.3");
  close($fh);

  open($fh, ">$compRoot/${compName}_data_upgrade_10.2.0.4.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->data_upgrade($session,"10.2.0.4");
  close($fh);

  open($fh, ">$compRoot/${compName}_data_upgrade_10.2.0.5.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->data_upgrade($session,"10.2.0.5");
  close($fh);

  open($fh, ">$compRoot/${compName}_data_upgrade_10.2.0.6.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->data_upgrade($session,"10.2.0.6");
  close($fh);

  open($fh, ">$compRoot/${compName}_data_upgrade_10.2.0.7.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->data_upgrade($session,"10.2.0.7");
  close($fh);

  open($fh, ">$compRoot/${compName}_data_upgrade_10.2.0.8.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->data_upgrade($session,"10.2.0.8");
  close($fh);

  open($fh, ">$compRoot/${compName}_data_upgrade_10.2.0.9.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->data_upgrade($session,"10.2.0.9");
  close($fh);

  open($fh, ">$compRoot/${compName}_pre_data_upgrade_10.1.0.2.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->pre_data_upgrade($session,"10.1.0.2");
  close($fh);

  open($fh, ">$compRoot/${compName}_pre_data_upgrade_10.1.0.3.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->pre_data_upgrade($session,"10.1.0.3");
  close($fh);

  open($fh, ">$compRoot/${compName}_pre_data_upgrade_10.1.0.4.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->pre_data_upgrade($session,"10.1.0.4");
  close($fh);

  open($fh, ">$compRoot/${compName}_pre_data_upgrade_10.1.0.5.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->pre_data_upgrade($session,"10.1.0.5");
  close($fh);

  open($fh, ">$compRoot/${compName}_pre_data_upgrade_10.1.0.6.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->pre_data_upgrade($session,"10.1.0.6");
  close($fh);

  open($fh, ">$compRoot/${compName}_pre_data_upgrade_10.2.0.0.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->pre_data_upgrade($session,"10.2.0.0");
  close($fh);

  open($fh, ">$compRoot/${compName}_pre_data_upgrade_10.2.0.1.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->pre_data_upgrade($session,"10.2.0.1");
  close($fh);

  open($fh, ">$compRoot/${compName}_pre_data_upgrade_10.2.0.2.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->pre_data_upgrade($session,"10.2.0.2");
  close($fh);

  open($fh, ">$compRoot/${compName}_pre_data_upgrade_10.2.0.3.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->pre_data_upgrade($session,"10.2.0.3");
  close($fh);

  open($fh, ">$compRoot/${compName}_pre_data_upgrade_10.2.0.4.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->pre_data_upgrade($session,"10.2.0.4");
  close($fh);

  open($fh, ">$compRoot/${compName}_pre_data_upgrade_10.2.0.5.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->pre_data_upgrade($session,"10.2.0.5");
  close($fh);

  open($fh, ">$compRoot/${compName}_pre_data_upgrade_10.2.0.6.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->pre_data_upgrade($session,"10.2.0.6");
  close($fh);

  open($fh, ">$compRoot/${compName}_pre_data_upgrade_10.2.0.7.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->pre_data_upgrade($session,"10.2.0.7");
  close($fh);

  open($fh, ">$compRoot/${compName}_pre_data_upgrade_10.2.0.8.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->pre_data_upgrade($session,"10.2.0.8");
  close($fh);

  open($fh, ">$compRoot/${compName}_pre_data_upgrade_10.2.0.9.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->pre_data_upgrade($session,"10.2.0.9");
  close($fh);

  #generate _<comp>_post_data_upgrade.sql
  open($fh, ">$compRoot/${compName}_post_data_upgrade.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->post_data_upgrade($session);
  close($fh);

  open($fh, ">$compRoot/${compName}_recreate.sql");
  printHeader($fh);
  $session = ScriptSession->new($fh);
  $comp->recreate($session);
  close($fh);
  
}

sub printHeader
{
  my $fh = shift ;
  my $date = localtime();
  print $fh "Rem  
Rem Generated on $date
Rem

";
}

sub printUsage
{
  print "

build.pl - build component driver sql scripts
Usage : perl \$ADE_VIEW_ROOT/emcore/sysman/admin/emdrep/bin/build.pl [ -root <dir> | - comp <file> ]
  <dir>  = absolute path of sql root directory
  <file> = absolute path of component.xml
  
";
}


