#!/usr/local/bin/perl
# 
# $Header: repdiff.pl 23-feb-2005.16:33:17 ktlaw Exp $
#
# repdiff.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      repdiff.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ktlaw       02/23/05 - ktlaw_rep_diff
#    ktlaw       02/23/05 - 
#    chyu        02/23/05 - making subroutines better 
#    chyu        02/23/05 - Creation
# 

##################
# Main Program
##################
my $CREATED_FILE_DUMP;
my $UPGRADED_FILE_DUMP;
my $OUTPUT_FILE;

my $CREATE_TYPE;
my $CREATE_IDNEX;
my $CREATE_TABLE;
my $UPGRADE_TYPE;
my $UPGRADE_INDEX;
my $UPGRADE_TABLE;

my $CREATE_SUMMARY;
my $UPGRADE_SUMMARY;

ProcessCommandLine();
CheckFileExists();
ReadCreateDumpFile();
ReadUpgradeDumpFile();

CompareType();
CompareTable();
CompareIndex();

######################################################################
# ProcessCommandLine : Processes command line parameters.
######################################################################
sub ProcessCommandLine()
{
  my @args = @ARGV;

  my $argCount = scalar(@args);

  if ($argCount lt 2)
  {
    displayHelp();
    exit 1;
  }
  $CREATED_FILE_DUMP = $args[0];
  $UPGRADED_FILE_DUMP = $args[1];
  
  $OUTPUT_FILE = "./rep_diff.log";
  
  if ($argCount eq 3)
  {
    $OUTPUT_FILE = $args[2];
  }
  
  print "Schema File Dump from the Created Repository:$CREATED_FILE_DUMP \n";
  print "Schema File Dump from the Upgraded Repository:$UPGRADED_FILE_DUMP \n";
  print "Output File:$OUTPUT_FILE \n";
  open (outfile, ">$OUTPUT_FILE");
  print outfile ("");
  close(outfile);
}

################################
# CheckFileExists: Check whether or not the schema dump file exists
################################
sub CheckFileExists()
{
  if (!-e "$CREATED_FILE_DUMP")
  {
      print "Created Schema File: $CREATED_FILE_DUMP doesn't exists \n";
      exit 1;
  } elsif (!-r "$CREATED_FILE_DUMP")
  {
      print "Created Schema File: $CREATED_FILE_DUMP isn't readable \n";
      exit 1;
  }
  
  if (!-e "$UPGRADED_FILE_DUMP")
  {
      print "Upgraded Schema File: $UPGRADED_FILE_DUMP doesn't exists \n";
      exit 1;
  } elsif (!-r "$UPGRADED_FILE_DUMP")
  {
      print "Created Schema File: $UPGRADED_FILE_DUMP isn't readable \n";
      exit 1;
  }
}

################################
# Read[Created|Upgraded]DumpFile: These method read the dump files
# to store the objects in a hash.
################################
sub ReadCreateDumpFile()
{
    $CREATE_SUMMARY = "-------------------------------------\n";
    $CREATE_SUMMARY = $CREATE_SUMMARY."Summary Report for the Created Schema\n";
    
    open(CREATEDUMP, "$CREATED_FILE_DUMP");
    my $index_counter = 0;
    
    while ($line = <CREATEDUMP>) {
        if ($line =~ /End of Summary/) {
        	last;
        }
        if ($line =~ /Total number of/) {
            $CREATE_SUMMARY = $CREATE_SUMMARY.$line;
        }
        if ($line =~ /^INDEX\b/) {
            ($TEMP,$VALUE) = split(/\s+/, $line);
            $CREATE_INDEX{$VALUE} = "INDEX";
        }
        if ($line =~ /^TABLE\b/) {
            ($TEMP,$VALUE) = split(/\s+/, $line);
            $CREATE_TABLE{$VALUE} = "TABLE";
        }
        if ($line =~ /^TYPE\b/) {
            ($TEMP,$VALUE) = split(/\s+/, $line);
            $CREATE_TYPE{$VALUE} = "TYPE";
        }
    }
    
    $CREATE_SUMMARY = $CREATE_SUMMARY."-------------------------------------\n";
    
    print "$CREATE_SUMMARY \n";    
    
    open (outfile, ">>$OUTPUT_FILE");
    print outfile ($CREATE_SUMMARY);
    close(outfile);
}

sub ReadUpgradeDumpFile()
{
    $UPGRADE_SUMMARY = "-------------------------------------\n";
    $UPGRADE_SUMMARY = $UPGRADE_SUMMARY."Summary Report for the Upgraded Schema\n";
    
    open(UPGRADEDUMP, "$UPGRADED_FILE_DUMP");
    my $index_counter = 0;
    
    while ($line = <UPGRADEDUMP>) {
        if ($line =~ /End of Summary/) {
        	last;
        }
        if ($line =~ /Total number of/) {
            $UPGRADE_SUMMARY = $UPGRADE_SUMMARY.$line;
        }
        if ($line =~ /^INDEX\b/) {
            ($TEMP,$VALUE) = split(/\s+/, $line);
            $UPGRADE_INDEX{$VALUE} = "INDEX";
        }
        if ($line =~ /^TABLE\b/) {
            ($TEMP,$VALUE) = split(/\s+/, $line);
            $UPGRADE_TABLE{$VALUE} = "TABLE";
        }
        if ($line =~ /^TYPE\b/) {
            ($TEMP,$VALUE) = split(/\s+/, $line);
            $UPGRADE_TYPE{$VALUE} = "TYPE";
        }
    }
    
    $UPGRADE_SUMMARY = $UPGRADE_SUMMARY."-------------------------------------\n";
    
    print "$UPGRADE_SUMMARY \n";
    
    open (outfile, ">>$OUTPUT_FILE");
    print outfile ($UPGRADE_SUMMARY);
    close(outfile);
}

################################
# Compare[Index|Table|Type]: Compare the index/table/type objects
# and write them out to the outfile.
################################
sub CompareIndex()
{
    @INCREATED=();
    @INUPGRADED=();
    
    $C_INDEX = 0;
    $U_INDEX = 0;
    foreach $key (sort keys %CREATE_INDEX) {
        if ($UPGRADE_INDEX{$key} ne "INDEX") {
            $INCREATED[$C_INDEX++] = $key;
        }
    }
    foreach $key (sort keys %UPGRADE_INDEX) {
        if ($CREATE_INDEX{$key} ne "INDEX") {
            $INUPGRADED[$U_INDEX++] = $key;
        }
    }
    
    $C_COUNT = scalar(@INCREATED);
    $U_COUNT = scalar(@INUPGRADED);
    
    open (outfile, ">>$OUTPUT_FILE");
    print outfile ("\n"); 
    
    print outfile ("********START INDEX REPORT**********\n");
    print outfile ("--$C_COUNT INDEXES are missing in the upgraded schema\n");
    print outfile ("--$U_COUNT INDEXES should be obsoleted in the upgraded schema\n\n");
    print outfile ("--The following indexes are MISSING\n  ");
    print outfile join("\n  ", @INCREATED);
    print outfile ("\n\n");
    print outfile ("--The following indexes should be OBSOLETED\n  ");
    print outfile join("\n  ", @INUPGRADED);
    print outfile ("\n\n");
    print outfile ("********  END INDEX REPORT**********\n");
    close(outfile);
}

sub CompareTable()
{
    @INCREATED=();
    @INUPGRADED=();
    
    $C_INDEX = 0;
    $U_INDEX = 0;
    foreach $key (sort keys %CREATE_TABLE) {
        if ($UPGRADE_TABLE{$key} ne "TABLE") {
            $INCREATED[$C_INDEX++] = $key;
        }
    }
    foreach $key (sort keys %UPGRADE_TABLE) {
        if ($CREATE_TABLE{$key} ne "TABLE") {
            $INUPGRADED[$U_INDEX++] = $key;
        }
    }
    
    $C_COUNT = scalar(@INCREATED);
    $U_COUNT = scalar(@INUPGRADED);
    
    open (outfile, ">>$OUTPUT_FILE");
    print outfile ("\n"); 
    
    print outfile ("********START TABLE REPORT**********\n");
    print outfile ("--$C_COUNT TABLES are missing in the upgraded schema\n");
    print outfile ("--$U_COUNT TABLES should be obsoleted in the upgraded schema\n");
    print outfile ("--The following tables are MISSING\n  ");
    print outfile join("\n  ", @INCREATED);
    print outfile ("\n\n");
    print outfile ("     --The following tables should be OBSOLETED\n  ");
    print outfile join("\n  ", @INUPGRADED);
    print outfile ("\n\n");
    print outfile ("********  END TABLE REPORT**********\n");
    close(outfile);
}

sub CompareType()
{
    @INCREATED=();
    @INUPGRADED=();
    
    $C_INDEX = 0;
    $U_INDEX = 0;
    foreach $key (sort keys %CREATE_TYPE) {
        if ($UPGRADE_TYPE{$key} ne "TYPE") {
            $INCREATED[$C_INDEX++] = $key;
        }
    }
    foreach $key (sort keys %UPGRADE_TYPE) {
        if ($CREATE_TYPE{$key} ne "TYPE") {
            $INUPGRADED[$U_INDEX++] = $key;
        }
    }
    
    $C_COUNT = scalar(@INCREATED);
    $U_COUNT = scalar(@INUPGRADED);

    open (outfile, ">>$OUTPUT_FILE");
    print outfile ("\n"); 
    
    print outfile ("********START TYPE REPORT**********\n");
    print outfile ("--$C_COUNT TYPES are missing in the upgraded schema\n");
    print outfile ("--$U_COUNT TYPES should be obsoleted in the upgraded schema\n");
    print outfile ("--The following types are MISSING\n  ");
    print outfile join("\n  ", @INCREATED);
    print outfile ("\n\n");
    print outfile ("     --The following types should be OBSOLETED\n  ");
    print outfile join("\n  ", @INUPGRADED);
    print outfile ("\n\n");
    print outfile ("********  END TYPE REPORT**********\n");
    close(outfile);
}

sub displayHelp()
{
  print STDERR <<EOM;
Usage: $progName <created_schema_dump> <upgraded_schema_dump>
	Where


EOM
}
