set define off
set verify off
set serveroutput on size 1000000
set feedback off
begin wwv_flow.g_import_in_progress := true; end; 
/
 
 
--application/set_environment
prompt  APPLICATION 4004 - APEX - Application Builder
--
-- Application Export:
--   Application:     4004
--   Name:            APEX - Application Builder
--   Date and Time:   07:57 Tuesday May 19, 2009
--   Exported By:     
--   Flashback:       0
--   Export Type:     Application Export
--   Version: 3.2.1.00.08
 
-- Import:
--   Using application builder
--   or
--   Using SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
 
-- Application Statistics:
--   Pages:             1,094
--     Items:           6,375
--     Computations:      588
--     Validations:     1,439
--     Processes:       1,288
--     Regions:         4,881
--     Buttons:         2,584
--   Shared Components
--     Breadcrumbs:         1
--        Entries       1,012
--     Items:              27
--     Computations:        7
--     Processes:           8
--     Parent Tabs:         0
--     Tab Sets:            0
--        Tabs:             0
--     NavBars:             2
--     Lists:             318
--     Shortcuts:          16
--     Themes:              0
--     Templates:
--        Page:             9
--        List:            20
--        Report:          16
--        Label:            6
--        Region:          33
--     Messages:            0
--     Build Options:       0
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>10);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en-us'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2009.01.12');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := 4004;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(4004);
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(4004);
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => 4004,
  p_display_id=> 4004,
  p_owner => 'APEX_030200',
  p_name  => 'APEX - Application Builder',
  p_alias => 'A198382328030290353',
  p_page_view_logging => 'YES',
  p_default_page_template=> 3181227431044578.4004 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=> 7403029749876837.4004 + wwv_flow_api.g_id_offset,
  p_default_region_template=> 344742548.4004 + wwv_flow_api.g_id_offset,
  p_error_template    => 7403029749876837.4004 + wwv_flow_api.g_id_offset,
  p_charset           => 'utf-8',
  p_page_protection_enabled_y_n=> 'N',
  p_checksum_salt_last_reset => '20090519073429',
  p_max_session_length_sec=> 28800,
  p_home_link         => 'f?p=4000:1:&SESSION.',
  p_flow_language     => 'it',
  p_flow_language_derived_from=> 'BROWSER',
  p_flow_image_prefix => '/i/',
  p_documentation_banner=> '',
  p_authentication    => 'CUSTOM2',
  p_login_url         => '',
  p_logout_url        => 'wwv_flow_custom_auth_std.logout?p_this_flow=&FLOW_ID.&p_next_flow_page_sess=4550:8:&SESSION.',
  p_application_tab_set=> 1,
  p_logo_image => '#IMAGE_PREFIX#htmldb/apex_logo.gif',
  p_logo_image_attributes => 'width="300" height="30" alt="&PRODUCT_NAME."',
  p_public_url_prefix => '',
  p_public_user       => 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server      => '',
  p_cust_authentication_process=> '.'||to_char(60856310633085148 + wwv_flow_api.g_id_offset)||'.',
  p_cust_authentication_page=> '',
  p_custom_auth_login_url=> '',
  p_flow_version      => '&PRODUCT_NAME. 3.2.1.00.08',
  p_flow_status       => 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'This application is currently unavailable at this time.',
  p_build_status      => 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'N',
  p_vpd               => '',
  p_security_scheme=>'FLOW: EDIT',
  p_csv_encoding    => 'Y',
  p_theme_id => 3,
  p_default_label_template => 93372822814585113.4004 + wwv_flow_api.g_id_offset,
  p_default_report_template => 6600628282501516.4004 + wwv_flow_api.g_id_offset,
  p_default_list_template => 35066701739635046.4004 + wwv_flow_api.g_id_offset,
  p_default_menu_template => 13734421012904391.4004 + wwv_flow_api.g_id_offset,
  p_default_form_template => 344742548.4004 + wwv_flow_api.g_id_offset,
  p_default_wizard_template => 91980429263284255.4004 + wwv_flow_api.g_id_offset,
  p_default_tabform_template => 344742548.4004 + wwv_flow_api.g_id_offset,
  p_substitution_string_01 => 'LOGOUT',
  p_substitution_value_01  => 'Logout',
  p_substitution_string_02 => 'PRODUCT_NAME',
  p_substitution_value_02  => 'Application Express',
  p_substitution_string_03 => 'MSG_COMPANY',
  p_substitution_value_03  => 'Area di lavoro: &COMPANY.',
  p_substitution_string_04 => 'MSG_LANGUAGE',
  p_substitution_value_04  => 'Lingua',
  p_substitution_string_05 => 'MSG_COPYRIGHT',
  p_substitution_value_05  => 'Copyright &copy; 1999-2009, Oracle. Tutti i diritti riservati.',
  p_substitution_string_06 => 'MSG_USER',
  p_substitution_value_06  => 'Utente',
  p_substitution_string_07 => 'MSG_JSCRIPT',
  p_substitution_value_07  => 'Eseguire questo prodotto con JavaScript abilitato.',
  p_substitution_string_08 => 'MSG_TBL_SUMMARY',
  p_substitution_value_08  => 'Tabella di layout di pagina',
  p_substitution_string_09 => 'EDIT',
  p_substitution_value_09  => 'Modifica',
  p_substitution_string_10 => 'DONE',
  p_substitution_value_10  => 'Fine',
  p_substitution_string_11 => 'TOP',
  p_substitution_value_11  => 'Inizio pagina',
  p_substitution_string_12 => 'CLOSE',
  p_substitution_value_12  => 'Chiudi',
  p_substitution_string_13 => 'CONFIRM',
  p_substitution_value_13  => 'Conferma',
  p_substitution_string_14 => 'DATE_FORMAT',
  p_substitution_value_14  => 'dd/mm/yyyy',
  p_substitution_string_15 => 'LONG_DATE_FORMAT',
  p_substitution_value_15  => 'fmDay dd Month yyyy',
  p_substitution_string_16 => 'TIME_FORMAT',
  p_substitution_value_16  => 'hh24:mi:ss',
  p_substitution_string_17 => 'DATE_TIME_FORMAT',
  p_substitution_value_17  => 'dd/mm/yyyy hh24:mi:ss',
  p_substitution_string_18 => 'RETURN_TO_APP',
  p_substitution_value_18  => 'Torna all''applicazione',
  p_substitution_string_19 => 'DELETE_MSG',
  p_substitution_value_19  => 'Eseguire questa azione di eliminazione?',
  p_substitution_string_20 => 'PAGE',
  p_substitution_value_20  => 'Pagina',
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss=> '20090519073330',
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
null;
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
wwv_flow_api.create_icon_bar_item(
  p_id             => 39802102226728766.4004 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_icon_sequence  => 1,
  p_icon_image     => '',
  p_icon_subtext   => 'Guida',
  p_icon_target    => 'javascript:popupURL(''wwv_flow_help.show_help?p_lang=&BROWSER_LANGUAGE.&amp;p_session=&APP_SESSION.&amp;p_flow_id=&APP_TRANSLATION_ID.&amp;p_step_id=&APP_TRANSLATION_PAGE_ID.'');',
  p_icon_image_alt => 'Guida',
  p_icon_height    => null,
  p_icon_width     => null,
  p_icon_height2   => null,
  p_icon_width2    => null,
  p_icon_bar_disp_cond      => '',
  p_icon_bar_disp_cond_type => '',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> '');
 
wwv_flow_api.create_icon_bar_item(
  p_id             => 39804528545736393.4004 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_icon_sequence  => 10,
  p_icon_image     => '',
  p_icon_subtext   => 'Logout',
  p_icon_target    => 'wwv_flow_custom_auth_std.logout?p_this_flow=&APP_ID.&amp;p_next_flow_page_sess=4550:8:&SESSION.',
  p_icon_image_alt => 'Logout',
  p_icon_height    => null,
  p_icon_width     => null,
  p_icon_height2   => null,
  p_icon_width2    => null,
  p_icon_bar_disp_cond      => '',
  p_icon_bar_disp_cond_type => '',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> '');
 
 
end;
/

prompt  ...application processes
--
--application/shared_components/logic/application_processes/pg_5150_detail
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'carl_test.show_layout_region (1,1,1);';

wwv_flow_api.create_flow_process(
  p_id => 6184522853212743.4004 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'pg_5150_DETAIL',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/page_template_preview
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'select name into :F4000_P4029_TEMPLATE_NAME from wwv_flow_templates where id = :F4000_P4029_TEMPLATE_ID;'||chr(10)||
'wwv_flow_region_layout.show_page_template ('||chr(10)||
'   p_page=>v(''FB_FLOW_PAGE_ID''),'||chr(10)||
'   p_flow=>v(''FB_FLOW_ID''),'||chr(10)||
'   p_template=>v(''F4000_P4029_TEMPLATE_NAME''),'||chr(10)||
'   p_template_id=>v(''F4000_P4029_TEMPLATE_ID''));';

wwv_flow_api.create_flow_process(
  p_id => 13746503491403876.4004 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'PAGE_TEMPLATE_PREVIEW',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/p701_flashchart_preview
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'wwv_flow_flash_chart_util.show_preview('||chr(10)||
'  p_page_id => 701,'||chr(10)||
'  p_region_id => 0,'||chr(10)||
'  p_chart_type => v(''P701_DEFAULT_CHART_TYPE''),'||chr(10)||
'  p_bg_color => null);';

wwv_flow_api.create_flow_process(
  p_id => 23124919116403836.4004 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p701_flashchart_preview',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/returnnothing
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'null;'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 26098116757095708.4004 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'returnNothing',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'this is useful for setting item values where no return value is needed.');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/ajax_collect_clob
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'    l_code clob := empty_clob;'||chr(10)||
'begin'||chr(10)||
'   dbms_lob.createtemporary( l_code, false, dbms_lob.SESSION );'||chr(10)||
'   for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
'        dbms_lob.writeappend(l_code,length(wwv_flow.g_f01(i)),wwv_flow.g_f01(i));'||chr(10)||
'    end loop;'||chr(10)||
'apex_collection.create_or_truncate_collection(p_collection_name=>''CLOB_CONTENT'');'||chr(10)||
'apex_collection.add_member(p_collection_name=>''CLOB_CONTENT'',p_clob001=>';

p:=p||'l_code);'||chr(10)||
'htp.prn(''SUCCESS'');'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 49827831510641638.4004 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'AJAX_COLLECT_CLOB',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/parse_report_query
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_owner varchar2(4000)  := null;'||chr(10)||
'  l_query varchar2(32767) := null;'||chr(10)||
'  l_error varchar2(32767) := null;'||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  l_owner := wwv_flow_security.flow_owner ( '||chr(10)||
'     p_flow_id           =>:FB_FLOW_ID, '||chr(10)||
'     p_security_group_id =>:FLOW_SECURITY_GROUP_ID'||chr(10)||
'  );'||chr(10)||
''||chr(10)||
'  for c1 in ('||chr(10)||
'    select clob001 '||chr(10)||
'    from wwv_flow_collections '||chr(10)||
'    where collection_name = ''REPORT_QUERY_TEMP'''||chr(10)||
'  ) loop'||chr(10)||
'    l_query := ';

p:=p||'c1.clob001;'||chr(10)||
'    l_error := wwv_render_report3.is_valid_query ('||chr(10)||
'      p_region_id        => null,'||chr(10)||
'      p_plug_source      => l_query,'||chr(10)||
'      p_plug_source_type => ''SQL_QUERY'','||chr(10)||
'      p_owner            => l_owner'||chr(10)||
'    );'||chr(10)||
'  end loop;'||chr(10)||
'         '||chr(10)||
'  if l_error is null then'||chr(10)||
'    htp.p(''1''||wwv_flow_lang.system_message(''REPORT_QUERIES.VALID_QUERY''));'||chr(10)||
'  else'||chr(10)||
'    htp.p(''0''||wwv_flow_utilities.striphtml(l_error';

p:=p||'));'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 59589024396402332.4004 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'PARSE_REPORT_QUERY',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/p719_flashchart_preview
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'wwv_flow_flash_chart_util.show_preview('||chr(10)||
'  p_page_id => 719,'||chr(10)||
'  p_region_id => 0,'||chr(10)||
'  p_chart_type => v(''P719_DEFAULT_CHART_TYPE''),'||chr(10)||
'  p_bg_color => null);';

wwv_flow_api.create_flow_process(
  p_id => 62479625126092950.4004 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'p719_flashchart_preview',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/set_flow_page
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'wwv_flow_f4000_util.set_flow_page;';

wwv_flow_api.create_flow_process(
  p_id => 72694123644888753.4004 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_SUBMIT_BEFORE_COMPUTATION',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set flow page',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Errore',
  p_process_when=> '1000,460,514,516,527,273,2100,2101,2102,2103,2104,2105,2106,2107,2108,2109,2111,2115,1500,1556,1555,163,1550,56,320,176,189,351,433,437,447,448,451,454,458,494,495,496,3001,3002,3003,3004,3005,3006,3014,3015,3020,49,57',
  p_process_when_type=> 'CURRENT_PAGE_NOT_IN_CONDITION',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'Used to set env when two browsers are working on different apps in the same session.  Prevents a wizard from creating a component in the wrong application.');
end;
 
null;
 
end;
/

prompt  ...application items
--
--application/shared_components/logic/application_items/ajax_temporary_item
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 6191718445268266.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'AJAX_TEMPORARY_ITEM',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/company
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 323366420862.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'COMPANY',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'I',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'prints workspace name referenced in page templates');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4000_check
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 137222915098326064.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4000_CHECK',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Used to display system message "Check".');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4000_cur_std_tab
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 49554522682292670.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4000_CUR_STD_TAB',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4000_last_portal_view
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 201664305800188161.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4000_LAST_PORTAL_VIEW',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4000_last_view
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 46180307972.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4000_LAST_VIEW',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4000_p35_demo_flows
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 174779207867417973.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4000_P35_DEMO_FLOWS',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'an item used for demostrations');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4000_region_selected
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 60363923165055254.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4000_REGION_SELECTED',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Used to dynamically compute button postions for that region');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4000_run
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 137215819075289336.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4000_RUN',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Item used to display system message "Run".');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4000_run_edit_page
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 148405327096585472.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4000_RUN_EDIT_PAGE',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fb_flow_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 40006855470898.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FB_FLOW_ID',
  p_data_type=> 'NUMBER',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Identifies the flow.');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fb_flow_name
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 40006856470899.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FB_FLOW_NAME',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Y');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fb_flow_page_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 40006857470899.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FB_FLOW_PAGE_ID',
  p_data_type=> 'NUMBER',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Identifies the flow page.');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fb_theme_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 146658914296443870.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FB_THEME_ID',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fp_max_rows_per_page
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 76847111472614227.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FP_MAX_ROWS_PER_PAGE',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'obsolete this item when you get a chance');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fp_pref_show_information
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 76852381884625214.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FP_PREF_SHOW_INFORMATION',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'obosolete this item when you get a chance');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fsp_after_login_url
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 61573406162429920.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FSP_AFTER_LOGIN_URL',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Used by Custom2 authentication for deep linking support');
 
null;
 
end;
/

--application/shared_components/logic/application_items/g_parse_as_schema_override
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 270085717148802034.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'G_PARSE_AS_SCHEMA_OVERRIDE',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'I',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/last_step
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 22788166245.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'LAST_STEP',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Y');
 
null;
 
end;
/

--application/shared_components/logic/application_items/monitor_user
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 453606206.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'MONITOR_USER',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Used by monitoring Utility');
 
null;
 
end;
/

--application/shared_components/logic/application_items/recent_pages
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 163678415474826275.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'RECENT_PAGES',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/theme_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 52230606827064481.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'THEME_ID',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/theme_next_page
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 52224418686048921.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'THEME_NEXT_PAGE',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/ui_schema
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 60734732002851561.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'UI_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/ui_table
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 60735102005852345.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'UI_TABLE',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/ui_table_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 114948426092978491.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'UI_TABLE_ID',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/wizard_entry_page
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 106733613326936844.4004 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'WIZARD_ENTRY_PAGE',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

prompt  ...application level computations
--
 
begin
 
--application/shared_components/logic/application_computations/fb_flow_id
wwv_flow_api.create_flow_computation (
  p_id => 40006858470900.4004 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_computation_sequence => 1,
  p_computation_item => 'FB_FLOW_ID',
  p_computation_point    => 'ON_NEW_INSTANCE',
  p_computation_type => 'SET_ITEM_EQUAL_THIS_PREFERENCE',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation => 'FB_FLOW_ID',
  p_compute_when=> '',
  p_compute_when_type=> 'NEVER',
  p_computation_error_message=>'Impossibile ottenere la preferenza per l''applicazione.',
  p_computation_comment=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset);
 
--application/shared_components/logic/application_computations/fb_flow_page_id
wwv_flow_api.create_flow_computation (
  p_id => 40006860470902.4004 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_computation_sequence => 2,
  p_computation_item => 'FB_FLOW_PAGE_ID',
  p_computation_point    => 'ON_NEW_INSTANCE',
  p_computation_type => 'SET_ITEM_EQUAL_THIS_PREFERENCE',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation => 'FB_FLOW_PAGE_ID',
  p_compute_when=> 'FB_FLOW_PAGE_ID',
  p_compute_when_type=> 'ITEM_IS_NULL',
  p_computation_error_message=>'Impossibile ottenere la preferenza per l''ID pagina di Application Builder.',
  p_computation_comment=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset);
 
--application/shared_components/logic/application_computations/fb_flow_name
wwv_flow_api.create_flow_computation (
  p_id => 40006859470901.4004 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_computation_sequence => 3,
  p_computation_item => 'FB_FLOW_NAME',
  p_computation_point    => 'ON_NEW_INSTANCE',
  p_computation_type => 'PLSQL_EXPRESSION',
  p_computation_processed=> 'ON_NEW_INSTANCE',
  p_computation => 'htf.escape_sc(v(''FB_FLOW_NAME''))',
  p_compute_when=> '',
  p_compute_when_type=> '',
  p_computation_error_message=>'Impossibile determinare il nome dell''applicazione.',
  p_computation_comment=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset);
 
--application/shared_components/logic/application_computations/company
wwv_flow_api.create_flow_computation (
  p_id => 323368422455.4004 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_computation_sequence => 10,
  p_computation_item => 'COMPANY',
  p_computation_point    => 'ON_NEW_INSTANCE',
  p_computation_type => 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation => 'wwv_flow.get_company_name;',
  p_compute_when=> '',
  p_compute_when_type=> '',
  p_computation_error_message=>'Impossibile calcolare il nome dell''area di lavoro.',
  p_computation_comment=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset);
 
--application/shared_components/logic/application_computations/f4000_run
wwv_flow_api.create_flow_computation (
  p_id => 137218026825301058.4004 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_computation_sequence => 10,
  p_computation_item => 'F4000_RUN',
  p_computation_point    => 'ON_NEW_INSTANCE',
  p_computation_type => 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation => 'wwv_flow_lang.system_message(''DEMO_APPLICATION.RUN'')',
  p_compute_when=> '',
  p_compute_when_type=> '',
  p_computation_error_message=>'',
  p_computation_comment=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset);
 
--application/shared_components/logic/application_computations/f4000_check
wwv_flow_api.create_flow_computation (
  p_id => 137224006571333058.4004 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_computation_sequence => 10,
  p_computation_item => 'F4000_CHECK',
  p_computation_point    => 'ON_NEW_INSTANCE',
  p_computation_type => 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation => 'wwv_flow_lang.system_message(''F4500_CHECK'')',
  p_compute_when=> '',
  p_compute_when_type=> '',
  p_computation_error_message=>'',
  p_computation_comment=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset);
 
--application/shared_components/logic/application_computations/f4000_last_portal_view
wwv_flow_api.create_flow_computation (
  p_id => 201669928216192952.4004 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_computation_sequence => 10,
  p_computation_item => 'F4000_LAST_PORTAL_VIEW',
  p_computation_point    => 'ON_NEW_INSTANCE',
  p_computation_type => 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'ON_NEW_INSTANCE',
  p_computation => 'page_definition',
  p_compute_when=> '',
  p_compute_when_type=> '',
  p_computation_error_message=>'',
  p_computation_comment=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset);
 
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Shared Lists of values
--
--application/shared_components/user_interface/lov/4150_create_page_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 5552423159788310.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => '4150 CREATE PAGE OPTIONS',
  p_lov_query=> '.'||to_char(5552423159788310 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5552716168788316.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>5552423159788310.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Pagina vuota',
  p_lov_return_value=>'PAGE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4714:&SESSION.:::4714,4715,4716,78,81,82,79,80,83"><img src="#IMAGE_PREFIX#htmldb/builder/blank_page_xl.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5555927446799005.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>5552423159788310.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Pagina con componente',
  p_lov_return_value=>'COMPLETE_PAGE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:259:&SESSION.:::181,259,380,311,355"><img src="#IMAGE_PREFIX#htmldb/builder/page_with_component_xl.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/4150_page_view_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 157910929450338648.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => '4150 PAGE VIEW OPTIONS',
  p_lov_query=> '.'||to_char(157910929450338648 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>157911100096338649.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>157910929450338648.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Definizione',
  p_lov_return_value=>'PAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>157911305474338650.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>157910929450338648.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Eventi',
  p_lov_return_value=>'EVENT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>157913829927348298.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>157910929450338648.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Oggetti',
  p_lov_return_value=>'OBJECTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>157914403393350022.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>157910929450338648.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Cronologia',
  p_lov_return_value=>'HISTORY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>158041017038789237.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>157910929450338648.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Esporta',
  p_lov_return_value=>'EXPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>158172814399148020.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>157910929450338648.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Gruppi',
  p_lov_return_value=>'GROUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>158211008446316671.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>157910929450338648.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Di riferimento',
  p_lov_return_value=>'RELATED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/4500_alignment_l_c_r
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 200094129140149873.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => '4500 ALIGNMENT L.C.R',
  p_reference_id=> 88088927053004343,
  p_lov_query=> '.'||to_char(200094129140149873 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/4700_page_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => '4700 PAGE TYPE',
  p_lov_query=> '.'||to_char(21175516989935412 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21176006373935415.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Report SQL',
  p_lov_return_value=>'SQL_REPORT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4701:&SESSION.:::4701,99,335,4795,4796,327,16::"><img src="#IMAGE_PREFIX#menu/wiz_classic_report_140x90.gif" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'REPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>92688413217742938.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Report interattivo',
  p_lov_return_value=>'DYNAMIC_QUERY',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:759:&SESSION.:::759,767,768,769,771,772::"><img src="#IMAGE_PREFIX#menu/wiz_interactive_report_140x90.gif" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'REPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21176218444935415.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Report con form su tabella',
  p_lov_return_value=>'REPORT_WITH_FORM',
  p_lov_template=>'#DISPLAY_VALUE#<br ><a href="f?p=4000:4703:&SESSION.:::4703,4040,4041,4775,4039,4776,4777,4778,4779,4783,443:F4000_P4703_REPORT_PAGE_ID:"><img src="#IMAGE_PREFIX#htmldb/builder/report_with_form_xl.gif" title= "#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'REPORT XX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>114174512180561978.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>15,
  p_lov_disp_value=>'Report su risultato servizio Web',
  p_lov_return_value=>'REPORT_ON_WEB_SERVICE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:776:&SESSION.:::776,777,778,779,781,782,783,786::"><img src="#IMAGE_PREFIX#menu/wiz_webservices_report_140x90.gif" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'REPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21175811641935414.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>16,
  p_lov_disp_value=>'Report procedura guidata',
  p_lov_return_value=>'EASY_REPORT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:355:&SESSION.::NO:355,452,470,356,455,457,462,456:P355_PAGE:"><img src="#IMAGE_PREFIX#menu/wiz_ez_report_140x90.gif" title ="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'REPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21187613405000544.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Form su tabella o vista',
  p_lov_return_value=>'FORM_ON_A_TABLE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:453:&SESSION.::NO:4708,4709,4713,4771,4772,4773,4774,4784,442:F4000_P4708_PAGE_ID:"><img src="#IMAGE_PREFIX#menu/wiz_form_140x90.gif" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21187920677002697.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Form su procedura',
  p_lov_return_value=>'FORM_ON_A_PROCEDURE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4711:&SESSION.:::4711,192,193,4712,4705,4702,4706,4660,SP_WIZARD:F4000_P4705_PAGE_ID:"><img src="#IMAGE_PREFIX#menu/wiz_form_140x90.gif" class="htmldbGreenIcons" title="#DISPLAY_VALUE#" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21189232105005988.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Form su tabella con report',
  p_lov_return_value=>'FORM_ON_A_TABLE_WITH_REPORT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4703:&SESSION.::NO:4703,4040,4041,4775,4039,4776,4777,4778,4779,4782,4783,443:F4000_P4703_REPORT_PAGE_ID:"><img src="#IMAGE_PREFIX#menu/wiz_form_and_report_140x90.gif" class="htmldbGreenIcons" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21189807995008490.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Form tabulare',
  p_lov_return_value=>'TABULAR_FORM',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:29:&SESSION.:::29,30,31,32,33,50,51,52,53,97,326,426,475:F4000_P33_PAGE::"><img src="#IMAGE_PREFIX#menu/wiz_tab_form_140x90.gif" class="htmldbGreenIcons" title="#DISPLAY_VALUE#" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21190114574010376.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Form Master-Detail',
  p_lov_return_value=>'MASTER_DETAIL_FORM',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4:&SESSION.::NO:4,5,11,12,15,18,24,25,35,293,155,507,508,MASTER_COLUMNS,DETAIL_COLUMNS,LINK_MASTER_DETAIL,LINK_MASTER_DETAIL_TEMP,CONDITIONS,JOINS::"><img src="#IMAGE_PREFIX#menu/wiz_md_140x90.gif" class="htmldbGreenIcons" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21188626910004453.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20.1,
  p_lov_disp_value=>'Form su query SQL',
  p_lov_return_value=>'FORM_ON_A_SQL_QUERY',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4810:&SESSION.::NO:4810,4811,4812,4813,4814:F4000_P4810_PAGE_ID:"><img src="#IMAGE_PREFIX#menu/wiz_form_140x90.gif" class="htmldbGreenIcons" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21189504185007384.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20.2,
  p_lov_disp_value=>'Pagina di riepilogo',
  p_lov_return_value=>'SUMMARY_PAGE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:5100:&SESSION.::NO:5100,5105,5110,303,304,SUMMARY_ITEM:F4000_P5100_PAGE_ID:"><img src="#IMAGE_PREFIX#menu/wiz_summary_140x90.gif" class="htmldbGreenIcons" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21190519076011733.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>21,
  p_lov_disp_value=>'Form su servizio Web',
  p_lov_return_value=>'FORM_ON_WEB_SERVICE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:600:&SESSION.::NO:600,605,610,615,620,625,630,635,640::"><img src="#IMAGE_PREFIX#menu/wiz_form_onws_140x90.gif" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>30111210090697363.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>21.5,
  p_lov_disp_value=>'Form e report su servizio Web',
  p_lov_return_value=>'FORM_ON_WEB_SERVICE_RPT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:700:&SESSION.::NO:700,705,710,715,720,725,730,735,750::"><img src="#IMAGE_PREFIX#menu/wiz_form_and_report_onws_140x90.gif" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21209407489121901.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Calendario semplice',
  p_lov_return_value=>'EASY_CALENDAR',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4785:&SESSION.::NO:4785,4786,4787,4788,4789,4790,4791,4792,4793,100,393:P4700_SELECT_REPORT_TYPE:EASY_CALENDAR"><img src="#IMAGE_PREFIX#menu/wiz_ez_calendar_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'CALENDAR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>203469713384401835.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>31,
  p_lov_disp_value=>'Calendario SQL',
  p_lov_return_value=>'CALENDAR',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4785:&SESSION.::NO:4785,4786,4787,4788,4789,4790,4791,4792,4793,100,393:P4700_SELECT_REPORT_TYPE:CALENDAR"><img src="#IMAGE_PREFIX#menu/wiz_calendar_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'CALENDAR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21213125974136706.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Procedura guidata semplice',
  p_lov_return_value=>'SIMPLE_WIZARD',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:107:&SESSION.::NO:107,108,109,110,111,140,141,CREATE_WIZARD"><img src="#IMAGE_PREFIX#htmldb/builder/wizard_simple_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'WIZARD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21219222212163984.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Struttura',
  p_lov_return_value=>'TREE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:112:&SESSION.:::112,113,114,115,116,117,118,119,120,125,126,127,68,69,325"><img src="#IMAGE_PREFIX#htmldb/builder/tree_component_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" class="htmldbGreenIcons" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'TREE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21224528492194155.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1000,
  p_lov_disp_value=>'A barre (HTML)',
  p_lov_return_value=>'BAR_HTML',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=&FLOW_ID.:4710:&SESSION.::&DEBUG.:4710,4780,4781,375::"><img src="#IMAGE_PREFIX#htmldb/builder/chart_bar_html_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21224905767197118.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1000,
  p_lov_disp_value=>'Quadrante',
  p_lov_return_value=>'DIAL',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=&FLOW_ID.:311:&SESSION.::&DEBUG.:311,312,313,314,378,384,SVG_CHART_SERIES:F4000_P311_CHART_TYPE:DIAL"><img src="#IMAGE_PREFIX#htmldb/builder/chart_dial_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21225210961198553.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1000,
  p_lov_disp_value=>'A torta',
  p_lov_return_value=>'PIE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=&FLOW_ID.:311:&SESSION.::&DEBUG.:311,312,313,314,378,384,SVG_CHART_SERIES:F4000_P311_CHART_TYPE:PIE"><img src="#IMAGE_PREFIX#htmldb/builder/chart_pie_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21225517195200399.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1000,
  p_lov_disp_value=>'A barre in pila, verticale',
  p_lov_return_value=>'STACKED_BAR',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=&FLOW_ID.:311:&SESSION.::&DEBUG.:311,312,313,314,378,384,SVG_CHART_SERIES:F4000_P311_CHART_TYPE:STACKED"><img src="#IMAGE_PREFIX#htmldb/builder/chart_stacked_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" class="htmldbGreenIcons" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21226130701204312.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1000,
  p_lov_disp_value=>'A barre, orizzontale',
  p_lov_return_value=>'HBAR',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=&FLOW_ID.:311:&SESSION.::&DEBUG.:311,312,313,314,378,384,SVG_CHART_SERIES:F4000_P311_CHART_TYPE:HBAR"><img src="#IMAGE_PREFIX#htmldb/builder/chart_hbar_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21226403474205903.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1000,
  p_lov_disp_value=>'Linea',
  p_lov_return_value=>'LINE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=&FLOW_ID.:311:&SESSION.::&DEBUG.:311,312,313,314,378,384,SVG_CHART_SERIES:F4000_P311_CHART_TYPE:LINE"><img src="#IMAGE_PREFIX#htmldb/builder/chart_line_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21226711439208153.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1000,
  p_lov_disp_value=>'A barre percentuali in pila, verticale',
  p_lov_return_value=>'STACKED_PCT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=&FLOW_ID.:311:&SESSION.::&DEBUG.:311,312,313,314,378,384,SVG_CHART_SERIES:F4000_P311_CHART_TYPE:STACKED_PCT"><img src="#IMAGE_PREFIX#htmldb/builder/chart_stacked_percentage_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25681223880541447.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1000,
  p_lov_disp_value=>'Quadrante (con riempimento)',
  p_lov_return_value=>'DIALSWEEP',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=&FLOW_ID.:311:&SESSION.::&DEBUG.:311,312,313,314,378,384,SVG_CHART_SERIES:F4000_P311_CHART_TYPE:DIALSWEEP"><img src="#IMAGE_PREFIX#htmldb/builder/chart_dial_sweep_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25683002156592016.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1000,
  p_lov_disp_value=>'A barre in cluster, orizzontale',
  p_lov_return_value=>'HCLUSTER_BAR',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=&FLOW_ID.:311:&SESSION.:::311,312,313,314,378,384,SVG_CHART_SERIES:F4000_P311_CHART_TYPE:HCLUSTER"><img src="#IMAGE_PREFIX#htmldb/builder/chart_hcluster_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25683309082593968.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1000,
  p_lov_disp_value=>'A barre percentuali in pila, orizzontale',
  p_lov_return_value=>'HSTACKED_PCT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=&FLOW_ID.:311:&SESSION.::&DEBUG.:311,312,313,314,378,384,SVG_CHART_SERIES:F4000_P311_CHART_TYPE:HSTACKED_PCT"><img src="#IMAGE_PREFIX#htmldb/builder/chart_hstacked_percentage_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25690117356643717.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1000,
  p_lov_disp_value=>'A barre in cluster, verticale',
  p_lov_return_value=>'CLUSTER',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=&FLOW_ID.:311:&SESSION.:::311,312,313,314,378,384,SVG_CHART_SERIES:F4000_P311_CHART_TYPE:CLUSTER"><img src="#IMAGE_PREFIX#htmldb/builder/chart_cluster_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25691500434667166.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1000,
  p_lov_disp_value=>'A barre, verticale',
  p_lov_return_value=>'VBAR',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=&FLOW_ID.:311:&SESSION.:::311,312,313,314,378,384,SVG_CHART_SERIES:F4000_P311_CHART_TYPE:VBAR"><img src="#IMAGE_PREFIX#htmldb/builder/chart_bar_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>'||chr(10)||
'',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25696802952724705.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21175516989935412.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1000,
  p_lov_disp_value=>'A barre in pila, orizzontale',
  p_lov_return_value=>'HSTACKED',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=&FLOW_ID.:311:&SESSION.::&DEBUG.:311,312,313,314,378,384,SVG_CHART_SERIES:F4000_P311_CHART_TYPE:HSTACKED"><img src="#IMAGE_PREFIX#htmldb/builder/chart_hstacked_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>'||chr(10)||
'',
  p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_lov_disp_cond=> 'P259_CHOOSE_PAGE_TYPE',
  p_lov_disp_cond2=> 'CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/aggregate_by
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 167761011505168202.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AGGREGATE BY',
  p_lov_query=> '.'||to_char(167761011505168202 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>167761226870168212.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>167761011505168202.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'SUM',
  p_lov_return_value=>'SUM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>167761407532168218.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>167761011505168202.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'AVG',
  p_lov_return_value=>'AVG',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>167761632408168219.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>167761011505168202.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'MIN',
  p_lov_return_value=>'MIN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>167761817557168219.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>167761011505168202.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'MAX',
  p_lov_return_value=>'MAX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>167776619311284077.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>167761011505168202.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'COUNT',
  p_lov_return_value=>'COUNT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/aggregate_function
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 49455515219053317.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AGGREGATE_FUNCTION',
  p_lov_query=> '.'||to_char(49455515219053317 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>49455814570053330.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>49455515219053317.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Somma',
  p_lov_return_value=>'SUM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>49456006581053331.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>49455515219053317.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Media',
  p_lov_return_value=>'AVG',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/alignment_l_c_r
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84702113000663314.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ALIGNMENT_L_C_R',
  p_lov_query=> '.'||to_char(84702113000663314 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84702319979663314.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84702113000663314.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'a sinistra',
  p_lov_return_value=>'LEFT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84702526646663315.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84702113000663314.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'al centro',
  p_lov_return_value=>'CENTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84702722814663315.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84702113000663314.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'a destra',
  p_lov_return_value=>'RIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/allow_page_repost
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84920132510743677.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ALLOW PAGE REPOST',
  p_lov_query=> '.'||to_char(84920132510743677 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84920305972743677.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84920132510743677.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'No - Impedisci il nuovo invio della pagina',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84920515901743678.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84920132510743677.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Sì - Consenti il nuovo invio della pagina',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/allowed_operations
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86630311100418314.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ALLOWED OPERATIONS',
  p_lov_query=> '.'||to_char(86630311100418314 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88151603016962504.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86630311100418314.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Inserisci',
  p_lov_return_value=>'I',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88151802892962505.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86630311100418314.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Aggiorna',
  p_lov_return_value=>'U',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88152029384962505.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86630311100418314.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Elimina',
  p_lov_return_value=>'D',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/app_computation_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84926512995804334.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APP COMPUTATION TYPES',
  p_lov_query=> '.'||to_char(84926512995804334 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84926706354804335.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84926512995804334.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Corpo funzione PL/SQL',
  p_lov_return_value=>'FUNCTION_BODY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84926905769804335.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84926512995804334.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Valore elemento',
  p_lov_return_value=>'ITEM_VALUE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84927104623804335.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84926512995804334.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Espressione PL/SQL',
  p_lov_return_value=>'PLSQL_EXPRESSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84927328096804335.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84926512995804334.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Query SQL',
  p_lov_return_value=>'QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84927527354804336.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84926512995804334.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Imposta elemento come preferenza',
  p_lov_return_value=>'SET_ITEM_EQUAL_THIS_PREFERENCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84927909756804336.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84926512995804334.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Espressione SQL',
  p_lov_return_value=>'SQL_EXPRESSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84928121322804336.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84926512995804334.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'Assegnazione statica',
  p_lov_return_value=>'STATIC_ASSIGNMENT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/app_diff_components
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APP DIFF COMPONENTS',
  p_lov_query=> '.'||to_char(15166510896787111 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15166729440787257.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Pagine',
  p_lov_return_value=>'PAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15166920981787257.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Aree di pagina',
  p_lov_return_value=>'PAGE.REGION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15167616090788599.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Elementi pagina',
  p_lov_return_value=>'PAGE.ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15214625580576733.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Pulsanti di pagina',
  p_lov_return_value=>'PAGE.BUTTON',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15272703827450402.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Indicatori di percorso',
  p_lov_return_value=>'BREADCRUMB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15275406775489081.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Voci di indicatore di percorso',
  p_lov_return_value=>'BREADCRUMB.ENTRY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15280612335642113.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Lista di valori',
  p_lov_return_value=>'LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15282816060662069.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Voci di lista di valori',
  p_lov_return_value=>'LOV.ENTRY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15286423211730438.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Diramazioni di pagina',
  p_lov_return_value=>'PAGE.BRANCH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15289020964767588.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Processo di pagina',
  p_lov_return_value=>'PAGE.PROCESS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15405712412659795.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Elementi della barra di navigazione',
  p_lov_return_value=>'NAVBAR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15407718009765502.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Convalide di pagina',
  p_lov_return_value=>'PAGE.VALIDATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16035403732024287.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Processi di applicazione',
  p_lov_return_value=>'APPLICATION.PROCESS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16049914242661216.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Calcoli di applicazione',
  p_lov_return_value=>'APPLICATION.COMPUTATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16051425979711899.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Schede',
  p_lov_return_value=>'TAB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16053917069766164.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Schede padre',
  p_lov_return_value=>'PARENT.TAB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16055929929798216.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Application.Item',
  p_lov_return_value=>'APPLICATION.ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16057603787828581.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Opzioni di creazione',
  p_lov_return_value=>'BUILD.OPTION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16059007512848565.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Liste',
  p_lov_return_value=>'LIST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16061027392939460.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Voci di lista',
  p_lov_return_value=>'LIST.ENTRY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16063928309005945.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Scorciatoie',
  p_lov_return_value=>'SHORTCUT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16064814158030207.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Strutture',
  p_lov_return_value=>'TREE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16066121917117672.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Schemi di autenticazione',
  p_lov_return_value=>'AUTHENTICATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17120709519005837.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Attributi applicazione',
  p_lov_return_value=>'APPLICATION.ATTRIBUTES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17177423445965489.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Colonne report',
  p_lov_return_value=>'REPORT.COLUMN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17180127956042460.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Schemi di autorizzazione',
  p_lov_return_value=>'AUTHORIZATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17181701739167324.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Temi',
  p_lov_return_value=>'THEME',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17182812400265020.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modelli di pagina',
  p_lov_return_value=>'TEMPLATE.PAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23040505396709149.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modelli di area',
  p_lov_return_value=>'TEMPLATE.REGION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23059602943831450.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modelli di lista',
  p_lov_return_value=>'TEMPLATE.LIST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23060207099832682.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modelli di etichetta',
  p_lov_return_value=>'TEMPLATE.LABEL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23065614980853874.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modelli di indicatore di percorso',
  p_lov_return_value=>'TEMPLATE.BREADCRUMB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23072813388938597.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modelli report',
  p_lov_return_value=>'TEMPLATE.REPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23111731368066835.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modelli di calendario',
  p_lov_return_value=>'TEMPLATE.CALENDAR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23112607258069299.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modelli di lista di valori popup',
  p_lov_return_value=>'TEMPLATE.POPUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23114220071073019.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modelli di pulsante',
  p_lov_return_value=>'TEMPLATE.BUTTON',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>75139517313227717.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Grafici flash',
  p_lov_return_value=>'FLASH_CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>75139828741231027.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Serie di grafici flash',
  p_lov_return_value=>'FLASH_CHART.SERIES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>101938626726557494.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15166510896787111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Stampa area',
  p_lov_return_value=>'REGION PRINTING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/app_extend_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84881512912473090.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APP EXTEND OPTIONS',
  p_lov_query=> '.'||to_char(84881512912473090 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84881732492473090.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84881512912473090.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>''||chr(10)||
'Pagina vuota',
  p_lov_return_value=>'PAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84881910860473091.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84881512912473090.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>''||chr(10)||
'Pagina di login',
  p_lov_return_value=>'LOGIN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84882130890473091.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84881512912473090.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>''||chr(10)||
'Un componente di pagina o di applicazione',
  p_lov_return_value=>'WIZARD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/app_extend_options2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84884222524494810.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APP EXTEND OPTIONS2',
  p_lov_query=> '.'||to_char(84884222524494810 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84884418462494811.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84884222524494810.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>''||chr(10)||
'Pagina vuota',
  p_lov_return_value=>'PAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84884606421494811.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84884222524494810.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>''||chr(10)||
'Pagina di login',
  p_lov_return_value=>'LOGIN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84884814299494811.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84884222524494810.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>''||chr(10)||
'Un componente di pagina o di applicazione',
  p_lov_return_value=>'WIZARD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/app_groups_assigned_unassigned
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 92271115231446627.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APP GROUPS ASSIGNED UNASSIGNED',
  p_lov_query=> '.'||to_char(92271115231446627 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>92271314455446628.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>92271115231446627.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'- Tutto -',
  p_lov_return_value=>'0',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>92271714863446629.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>92271115231446627.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Assegnato',
  p_lov_return_value=>'ASSIGNED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>92271520282446629.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>92271115231446627.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Non assegnato',
  p_lov_return_value=>'UNASSIGNED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/app_wizard_page_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 149548310855791684.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APP WIZARD PAGE TYPE',
  p_lov_query=> '.'||to_char(149548310855791684 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>149548517242791690.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>149548310855791684.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Pagina vuota',
  p_lov_return_value=>'BLANK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>149548725452791693.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>149548310855791684.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Pagina di report:',
  p_lov_return_value=>'REPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>149548909667791693.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>149548310855791684.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Report con form tabulare su un''altra pagina',
  p_lov_return_value=>'REPORTANDFORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>149549130170791694.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>149548310855791684.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Form tabulare',
  p_lov_return_value=>'TABULARFORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>149549303695791694.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>149548310855791684.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Form con inserimento, aggiornamento ed eliminazione.',
  p_lov_return_value=>'FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>147022416546025322.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>149548310855791684.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Pagina Master-Detail con un form sulla tabella master e un form tabulare sulla tabella detail',
  p_lov_return_value=>'MASTERDETAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/application_difference_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 15068618503746548.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APPLICATION DIFFERENCE OPTIONS',
  p_lov_query=> '.'||to_char(15068618503746548 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15068811195746548.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15068618503746548.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Mostra solo differenze',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/application_groups_and_unassigned_groups
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 91658312614512198.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APPLICATION GROUPS AND UNASSIGNED GROUPS',
  p_lov_query=> 'select group_name, id'||chr(10)||
'  from ('||chr(10)||
'select group_name, id, 2 ob'||chr(10)||
'  from wwv_flow_application_groups '||chr(10)||
' where security_group_id = :flow_security_group_id '||chr(10)||
'union all'||chr(10)||
'select ''- ''||wwv_flow_lang.system_message(''Unassigned'')||'' -'' group_name, -1 id, 1 ob'||chr(10)||
'  from dual'||chr(10)||
')'||chr(10)||
'order by ob, group_name');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/application_logo_image_or_text
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 210991102136588089.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APPLICATION LOGO IMAGE OR TEXT',
  p_lov_query=> '.'||to_char(210991102136588089 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>210991321100588090.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>210991102136588089.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Immagine',
  p_lov_return_value=>'IMAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>210991511506588095.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>210991102136588089.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Testo (richiede &PRODUCT_NAME. 2.2 o versione successiva)',
  p_lov_return_value=>'TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/application_themes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 60317311466182536.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APPLICATION THEMES',
  p_lov_query=> 'select theme_id||''. '' ||htf.escape_sc(theme_name) d, theme_id'||chr(10)||
'from   wwv_flow_themes'||chr(10)||
'where  flow_id = :fb_flow_id'||chr(10)||
'order by theme_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/application_menus
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 149605524191093671.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APPLICATION.MENUS',
  p_lov_query=> 'select htf.escape_sc(name) name,'||chr(10)||
'       id'||chr(10)||
'from   wwv_flow_menus'||chr(10)||
'where  flow_id = :fb_flow_id'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/applications
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 15049727442569349.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APPLICATIONS',
  p_lov_query=> 'select id||''. ''||name d, id r'||chr(10)||
'from wwv_flows f'||chr(10)||
'where security_group_id = :flow_security_group_id '||chr(10)||
'and'||chr(10)||
'       not exists ('||chr(10)||
'       select null from wwv_flow_language_map'||chr(10)||
'       where translation_flow_id = f.id and '||chr(10)||
'         security_group_id = :flow_security_group_id) and'||chr(10)||
'       ('||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and '||chr(10)||
'             flow_id is null and '||chr(10)||
'             security_group_id = :flow_security_group_id)'||chr(10)||
'       or'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and '||chr(10)||
'             flow_id = f.id and '||chr(10)||
'             security_group_id = :flow_security_group_id ))'||chr(10)||
'order by 2');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/application_view_mode
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84241428998396992.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APPLICATION_VIEW_MODE',
  p_lov_query=> '.'||to_char(84241428998396992 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84241625056396993.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84241428998396992.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Dettaglio',
  p_lov_return_value=>'DETAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84241814483396993.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84241428998396992.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Lista',
  p_lov_return_value=>'LIST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/app_char_set
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86591912420238949.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APP_CHAR_SET',
  p_lov_query=> '.'||to_char(86591912420238949 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87520523148833682.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86591912420238949.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'English (US-ASCII)',
  p_lov_return_value=>'US-ASCII',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87520707773833682.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86591912420238949.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Unicode (UTF8)',
  p_lov_return_value=>'UTF8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87520910595833682.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86591912420238949.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Western (Windows-1252)',
  p_lov_return_value=>'Windows-1252',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87521104177833683.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86591912420238949.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Western (iso-8859-1)',
  p_lov_return_value=>'iso-8859-1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/app_copy_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84341526733632941.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APP_COPY_OPTIONS',
  p_lov_query=> '.'||to_char(84341526733632941 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>171495412485960439.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84341526733632941.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Temi interfaccia utente',
  p_lov_return_value=>'THEMES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84341707833632941.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84341526733632941.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Liste di valori',
  p_lov_return_value=>'LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84341922244632941.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84341526733632941.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Elementi della barra di navigazione',
  p_lov_return_value=>'NAVBAR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84342129977632942.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84341526733632941.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Schemi di autorizzazione',
  p_lov_return_value=>'AUTHORIZATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>106274302385250184.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84341526733632941.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1040,
  p_lov_disp_value=>'Schemi di autenticazione',
  p_lov_return_value=>'AUTHENTICATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/app_default_theme
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86593825579242765.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APP_DEFAULT_THEME',
  p_lov_query=> 'select d,r from'||chr(10)||
'    (select initcap(wwv_flow_lang.system_message(''ALL_THEMES'')) d,0 r,1 ob from dual'||chr(10)||
'      union'||chr(10)||
'     select name d,id r,2 ob from wwv_flow_template_themes$ t'||chr(10)||
'      where name is not null'||chr(10)||
'        and exists (select null'||chr(10)||
'                      FROM WWV_FLOW_TEMPLATES$'||chr(10)||
'                     WHERE template_type = ''List'''||chr(10)||
'                       and theme = t.id))'||chr(10)||
'order by ob');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/app_wiz_chart_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 161900516722838362.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APP_WIZ_CHART_TYPE',
  p_lov_query=> '.'||to_char(161900516722838362 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161900809488838368.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>161900516722838362.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A torta',
  p_lov_return_value=>'PIE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/wiz_flash_chart_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcon" width="140" height="90" />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161901023475838370.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>161900516722838362.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Barra verticale',
  p_lov_return_value=>'VBAR',
  p_lov_template=>'#DISPLAY_VALUE#<br /><img src="#IMAGE_PREFIX#menu/wiz_html_chart_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcon" width="140" height="90" />'||chr(10)||
'',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/app_wiz_create_mode
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 161818726905576357.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APP_WIZ_CREATE_MODE',
  p_lov_query=> '.'||to_char(161818726905576357 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161819017462576362.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>161818726905576357.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sola lettura',
  p_lov_return_value=>'R',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161819201423576364.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>161818726905576357.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Lettura e scrittura',
  p_lov_return_value=>'RW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/at_risk_items
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 265754310402651040.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AT RISK ITEMS',
  p_lov_query=> '.'||to_char(265754310402651040 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265754508659651041.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>265754310402651040.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Mostra tutti gli elementi di password',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265754700945651042.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>265754310402651040.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Mostra elementi di password a rischio',
  p_lov_return_value=>'AT_RISK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265754929707651042.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>265754310402651040.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Mostra elementi di password sicuri',
  p_lov_return_value=>'SAFE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/audit_action
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 192763415498955359.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AUDIT ACTION',
  p_lov_query=> '.'||to_char(192763415498955359 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192763609015955370.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192763415498955359.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Inserisci',
  p_lov_return_value=>'I',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192763829535955373.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192763415498955359.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Aggiorna',
  p_lov_return_value=>'U',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192764030537955373.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192763415498955359.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Elimina',
  p_lov_return_value=>'D',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/audit_naming
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AUDIT_NAMING',
  p_lov_query=> '.'||to_char(192773330531006109 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192773504494006111.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Attributi applicazione',
  p_lov_return_value=>'WWV_FLOWS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192773719028006113.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Modello di pagina',
  p_lov_return_value=>'WWV_FLOW_TEMPLATES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192773912582006113.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Barra di navigazione',
  p_lov_return_value=>'WWV_FLOW_ICON_BAR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192774132498006113.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Processo applicazione',
  p_lov_return_value=>'WWV_FLOW_PROCESSING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192774324088006113.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Elemento applicazione',
  p_lov_return_value=>'WWV_FLOW_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192774507402006114.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Calcolo applicazione',
  p_lov_return_value=>'WWV_FLOW_COMPUTATIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192774728974006114.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Schede',
  p_lov_return_value=>'WWV_FLOW_TABS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192774924389006115.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Scheda padre',
  p_lov_return_value=>'WWV_FLOW_TOPLEVEL_TABS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192775116232006115.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista di valori',
  p_lov_return_value=>'WWV_FLOW_LISTS_OF_VALUES$',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192775308893006115.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Voce di lista di valori',
  p_lov_return_value=>'WWV_FLOW_LISTS_OF_VALUES_DATA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192775506134006116.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Attributi pagina',
  p_lov_return_value=>'WWV_FLOW_STEPS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192775729209006116.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Pulsante di pagina',
  p_lov_return_value=>'WWV_FLOW_STEP_BUTTONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192775914488006116.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Diramazione di pagina',
  p_lov_return_value=>'WWV_FLOW_STEP_BRANCHES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192776105194006116.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Argomenti diramazione di pagina',
  p_lov_return_value=>'WWV_FLOW_STEP_BRANCH_ARGS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192776313341006117.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Elemento pagina',
  p_lov_return_value=>'WWV_FLOW_STEP_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192776518774006117.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Calcolo di pagina',
  p_lov_return_value=>'WWV_FLOW_STEP_COMPUTATIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192776728927006117.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Convalida pagina',
  p_lov_return_value=>'WWV_FLOW_STEP_VALIDATIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192776908821006117.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Processo di pagina',
  p_lov_return_value=>'WWV_FLOW_STEP_PROCESSING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192777132334006118.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Modello di area',
  p_lov_return_value=>'WWV_FLOW_PAGE_PLUG_TEMPLATES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192777326352006118.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Modello di riga',
  p_lov_return_value=>'WWV_FLOW_ROW_TEMPLATES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192777504961006118.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Modello di lista',
  p_lov_return_value=>'WWV_FLOW_LIST_TEMPLATES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192777704768006118.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Attributi area',
  p_lov_return_value=>'WWV_FLOW_PAGE_PLUGS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192777913070006119.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Messaggi',
  p_lov_return_value=>'WWV_FLOW_MESSAGES$',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192778131775006119.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Opzioni di creazione',
  p_lov_return_value=>'WWV_FLOW_PATCHES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192778311606006120.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sviluppatori di applicazioni (amministrazione)',
  p_lov_return_value=>'WWV_FLOW_DEVELOPERS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192778526631006120.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Liste',
  p_lov_return_value=>'WWV_FLOW_LISTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192778710948006120.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Elemento di lista',
  p_lov_return_value=>'WWV_FLOW_LIST_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192778903034006120.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'ID utente effettivo (amministrazione)',
  p_lov_return_value=>'WWV_FLOW_EFFECTIVE_USERID_MAP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192779106904006121.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Scorciatoie',
  p_lov_return_value=>'WWV_FLOW_SHORTCUTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192779305727006121.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Testo Guida dell''elemento di pagina',
  p_lov_return_value=>'WWV_FLOW_STEP_ITEM_HELP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192779523562006121.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Impostazioni di autenticazione',
  p_lov_return_value=>'WWV_FLOW_CUSTOM_AUTH_SETUPS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192779703226006121.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Punti di accesso',
  p_lov_return_value=>'WWV_FLOW_ENTRY_POINTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192779919153006122.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Argomenti punti di accesso',
  p_lov_return_value=>'WWV_FLOW_ENTRY_POINT_ARGS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192814127076119594.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Voce di indicatore di percorso',
  p_lov_return_value=>'WWV_FLOW_MENU_OPTIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192918929997948694.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>192773330531006109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Temi',
  p_lov_return_value=>'WWV_FLOW_THEMES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/auth_scheme_component_list
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AUTH SCHEME COMPONENT LIST',
  p_lov_query=> '.'||to_char(19565023708932258 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19565408576932259.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Calcolo applicazione',
  p_lov_return_value=>'WWV_FLOW_COMPUTATIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19565616823932259.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Elemento della barra di navigazione',
  p_lov_return_value=>'WWV_FLOW_ICON_BAR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19565811243932259.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Voce di lista',
  p_lov_return_value=>'WWV_FLOW_LIST_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19566018968932260.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Indicatore di percorso',
  p_lov_return_value=>'WWV_FLOW_MENU_OPTIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19566229367932260.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Processo applicazione',
  p_lov_return_value=>'WWV_FLOW_PROCESSING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19566425485932260.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Diramazione di pagina',
  p_lov_return_value=>'WWV_FLOW_STEP_BRANCHES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19566609500932260.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Pulsante di pagina',
  p_lov_return_value=>'WWV_FLOW_STEP_BUTTONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19566827943932260.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Calcolo di pagina',
  p_lov_return_value=>'WWV_FLOW_STEP_COMPUTATIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19567024556932261.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Elemento pagina',
  p_lov_return_value=>'WWV_FLOW_STEP_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19567203422932261.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Processo di pagina',
  p_lov_return_value=>'WWV_FLOW_STEP_PROCESSING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19567427523932261.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Convalida pagina',
  p_lov_return_value=>'WWV_FLOW_STEP_VALIDATIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19567631501932261.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Scheda standard',
  p_lov_return_value=>'WWV_FLOW_TABS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19567802034932262.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Scheda padre',
  p_lov_return_value=>'WWV_FLOW_TOPLEVEL_TABS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19568016566932263.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Pagina',
  p_lov_return_value=>'WWV_FLOW_STEPS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19664501543326267.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Colonna report',
  p_lov_return_value=>'WWV_FLOW_REGION_REPORT_COLUMN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>19664915179339682.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>19565023708932258.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area',
  p_lov_return_value=>'WWV_FLOW_PAGE_PLUGS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/authentication_methods2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 62983620392370890.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AUTHENTICATION_METHODS2',
  p_lov_query=> '.'||to_char(62983620392370890 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>124262609673589368.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62983620392370890.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'SCHEMA (pronto per l''esecuzione o personalizzato)',
  p_lov_return_value=>'CUSTOM2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62984185221370917.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62983620392370890.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'INTERNAL (repository degli account locali)',
  p_lov_return_value=>'COOKIE',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/authentication_schemes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 166264006489001223.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AUTHENTICATION_SCHEMES',
  p_lov_query=> 'select htf.escape_sc(decode(s.name,''HTML DB'',v(''PRODUCT_NAME''),s.name)) d, id r from wwv_flow_custom_auth_setups s'||chr(10)||
'    where flow_id = :fb_flow_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/authz_scheme_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84861720259380643.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AUTHZ_SCHEME_TYPES',
  p_lov_query=> '.'||to_char(84861720259380643 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84861902602380643.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84861720259380643.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Query SQL - Esiste',
  p_lov_return_value=>'EXISTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84862521867380644.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84861720259380643.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Query SQL - Non esiste',
  p_lov_return_value=>'NOT_EXISTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84862132654380644.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84861720259380643.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Il valore dell''elemento in Espressione 1 è NULL',
  p_lov_return_value=>'ITEM_IS_NULL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84862305726380644.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84861720259380643.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Il valore dell''elemento in Espressione 1 è NOT NULL',
  p_lov_return_value=>'ITEM_IS_NOT_NULL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84862724485380644.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84861720259380643.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Funzione PL/SQL che restituisce un risultato booleano',
  p_lov_return_value=>'FUNCTION_RETURNING_BOOLEAN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84862924429380645.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84861720259380643.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Il valore della preferenza in Espressione 1 è uguale a Espressione 2',
  p_lov_return_value=>'PREFERENCE_EQ_COND_TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84863130627380645.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84861720259380643.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Il valore della preferenza in Espressione 1 NON è uguale a Espressione 2',
  p_lov_return_value=>'PREFERENCE_NOT_EQ_COND_TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84863509444380645.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84861720259380643.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'Il valore dell''elemento in Espressione 1 è uguale a Espressione 2',
  p_lov_return_value=>'VAL_OF_ITEM_IN_COND_EQ_COND_TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84863327213380645.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84861720259380643.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'Il valore dell''elemento in Espressione 1 NON è uguale a Espressione 2',
  p_lov_return_value=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND_TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/auth_scheme_caching
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84860700520374929.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AUTH_SCHEME_CACHING',
  p_lov_query=> '.'||to_char(84860700520374929 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84860914895374930.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84860700520374929.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Una volta per visualizzazione di pagina',
  p_lov_return_value=>'BY_USER_BY_PAGE_VIEW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84861103921374931.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84860700520374929.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Una volta per sessione',
  p_lov_return_value=>'BY_USER_BY_SESSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/auth_scheme_refresh
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86574617605164667.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AUTH_SCHEME_REFRESH',
  p_lov_query=> 'select wwv_flow_lang.system_message(''INITCAP_REFRESH'')  a,''Y'' b from dual');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/auth_wiz_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84347110372647083.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AUTH_WIZ_TYPE',
  p_lov_query=> '.'||to_char(84347110372647083 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88152606479963512.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84347110372647083.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Completamente nuovo/a',
  p_lov_return_value=>'BLANK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88152800735963512.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84347110372647083.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Come copia di uno schema di autorizzazione esistente',
  p_lov_return_value=>'COPY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/axis_interval
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84866925931391695.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AXIS_INTERVAL',
  p_lov_query=> '.'||to_char(84866925931391695 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84867111432391695.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84866925931391695.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Definisci intervallo asse',
  p_lov_return_value=>'DEFINE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84867324796391696.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84866925931391695.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Visualizza intervallo asse automaticamente',
  p_lov_return_value=>'AUTO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/Begin_on_new_line
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 67832807038215585.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BEGIN ON NEW LINE',
  p_lov_query=> '.'||to_char(67832807038215585 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>67833101831215595.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>67832807038215585.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Con inizio su nuova riga',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/Begin_on_new_field
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86067527340770119.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BEGIN_ON_NEW_FIELD',
  p_lov_query=> '.'||to_char(86067527340770119 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88282922464772458.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86067527340770119.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Con inizio su nuovo campo',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/branch_points_condensed
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 185544520425574805.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BRANCH.POINTS.CONDENSED',
  p_lov_query=> '.'||to_char(185544520425574805 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>185544824823574814.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>185544520425574805.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Prima del calcolo',
  p_lov_return_value=>'BEFORE_COMPUTATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>185545021461574815.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>185544520425574805.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Prima della convalida',
  p_lov_return_value=>'BEFORE_VALIDATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>185545229692574815.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>185544520425574805.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Prima dell''elaborazione',
  p_lov_return_value=>'BEFORE_PROCESSING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>185545414740574816.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>185544520425574805.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Dopo l''elaborazione',
  p_lov_return_value=>'AFTER_PROCESSING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>185545628448574816.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>185544520425574805.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Prima dell''intestazione',
  p_lov_return_value=>'BEFORE_HEADER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/breadcrumb_entry_or_container
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 205111517140679117.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BREADCRUMB ENTRY OR CONTAINER',
  p_lov_query=> '.'||to_char(205111517140679117 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>205111902995679137.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>205111517140679117.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Indicatore di percorso',
  p_lov_return_value=>'BREADCRUMB',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:288:&SESSION.::NO:RP,288::"><img src="#IMAGE_PREFIX#htmldb/builder/menu_component_xl.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>205345212580624072.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>205111517140679117.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Voce di indicatore di percorso',
  p_lov_return_value=>'REGION',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:263:&SESSION.:CC:NO:259,181,380,4016,4017,4018,399,382,402::"><img src="#IMAGE_PREFIX#htmldb/builder/menu_entry_xl.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1 from wwv_flow_menus where flow_id = :fb_flow_id and security_group_id = :flow_security_group_id;',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/break_on_report_positions
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 83332708448288963.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BREAK.ON.REPORT.POSITIONS',
  p_lov_query=> '.'||to_char(83332708448288963 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88283729044774273.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>83332708448288963.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Prima colonna',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88283921634774274.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>83332708448288963.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Prima e seconda colonna',
  p_lov_return_value=>'1:2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88284111739774274.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>83332708448288963.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Prima, seconda e terza colonna',
  p_lov_return_value=>'1:2:3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/break_columns
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86602811774267145.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BREAK_COLUMNS',
  p_lov_query=> '.'||to_char(86602811774267145 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88287205065786323.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86602811774267145.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Colonna 1',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88287428523786324.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86602811774267145.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Colonna 1 e 2',
  p_lov_return_value=>'1:2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88287603244786324.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86602811774267145.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Colonna 1, 2 e 3',
  p_lov_return_value=>'1:2:3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/break_on_report_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84247004458418293.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BREAK_ON_REPORT_OPTIONS',
  p_lov_query=> '.'||to_char(84247004458418293 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84247211888418294.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84247004458418293.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Prima colonna',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84247432172418294.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84247004458418293.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Prima e seconda colonna',
  p_lov_return_value=>'12',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84247624024418294.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84247004458418293.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Prima, seconda e terza colonna',
  p_lov_return_value=>'123',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/break_type_flag
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84369008472684429.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BREAK_TYPE_FLAG',
  p_lov_query=> '.'||to_char(84369008472684429 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84369227840684431.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84369008472684429.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Ripeti intestazioni su interruzione',
  p_lov_return_value=>'REPEAT_HEADINGS_ON_BREAK_1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84369407631684431.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84369008472684429.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Formattazione di interruzione predefinita',
  p_lov_return_value=>'DEFAULT_BREAK_FORMATTING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/build_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84305510710571518.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BUILD_STATUS',
  p_lov_query=> '.'||to_char(84305510710571518 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84305709177571518.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84305510710571518.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Esegui applicazione',
  p_lov_return_value=>'RUN_ONLY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84305911098571518.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84305510710571518.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Esegui e costruisci applicazione',
  p_lov_return_value=>'RUN_AND_BUILD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/button_theme_class_id
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 43576623634636183.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BUTTON THEME CLASS ID',
  p_lov_query=> '.'||to_char(43576623634636183 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43576912701636189.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43576623634636183.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Pulsante',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43584317316653265.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43576623634636183.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Pulsante, alternativa 1',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43584619394653936.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43576623634636183.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Pulsante, alternativa 2',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>44139910490884391.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43576623634636183.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Pulsante, alternativa 3',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43588706496669090.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43576623634636183.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 1',
  p_lov_return_value=>'6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43592228791685003.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43576623634636183.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 2',
  p_lov_return_value=>'7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43592532254685982.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43576623634636183.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 3',
  p_lov_return_value=>'8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43592802256686769.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43576623634636183.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 4',
  p_lov_return_value=>'9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43593427883694186.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43576623634636183.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 5',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43593729961694767.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43576623634636183.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 6',
  p_lov_return_value=>'11',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43594031692695331.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43576623634636183.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 7',
  p_lov_return_value=>'12',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43594301695696066.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43576623634636183.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 8',
  p_lov_return_value=>'13',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/button_attributes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 147003111936901406.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BUTTON.ATTRIBUTES',
  p_lov_query=> 'select distinct rtrim(BUTTON_CATTRIBUTES ) ba, rtrim(BUTTON_CATTRIBUTES ) r'||chr(10)||
'from   wwv_flow_step_buttons'||chr(10)||
'where  flow_id = :fb_flow_id'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/button_is_reset
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84945521447891923.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BUTTON.IS.RESET',
  p_lov_query=> '.'||to_char(84945521447891923 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84945714043891924.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84945521447891923.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Il pulsante è Reimposta',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/button_alignment_l_r
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84754827158805413.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BUTTON_ALIGNMENT_L_R',
  p_lov_query=> '.'||to_char(84754827158805413 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84755030664805414.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84754827158805413.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'A sinistra',
  p_lov_return_value=>'LEFT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84755202951805414.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84754827158805413.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'A destra',
  p_lov_return_value=>'RIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/button_display_positions2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BUTTON_DISPLAY_POSITIONS2',
  p_lov_query=> '.'||to_char(62990572348595109 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62990815665595115.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A sinistra del titolo di pagina',
  p_lov_return_value=>'LEFT_OF_TITLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62991037953595115.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'A destra del titolo di pagina',
  p_lov_return_value=>'RIGHT_OF_TITLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62991212359595118.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Sopra l''area',
  p_lov_return_value=>'ABOVE_BOX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62991440121595118.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'In alto nell''area',
  p_lov_return_value=>'TOP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62991617521595119.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'In basso nell''area',
  p_lov_return_value=>'BOTTOM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62991820415595119.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'In alto e in basso nell''area',
  p_lov_return_value=>'TOP_AND_BOTTOM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62992017822595122.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Sotto l''area',
  p_lov_return_value=>'BELOW_BOX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62992218359595123.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Posizione del modello di area #DEFAULT#',
  p_lov_return_value=>'TEMPLATE_DEFAULT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>92320911107933644.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9.5,
  p_lov_disp_value=>'Posizione del modello di area #CHANGE#',
  p_lov_return_value=>'REGION_TEMPLATE_CHANGE',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p'||chr(10)||
' where (p.flow_id = :FB_FLOW_ID'||chr(10)||
'   and p.PLUG_TEMPLATE = t.id'||chr(10)||
'   and dbms_lob.instr(t.template,''#CHANGE#'') > 0'||chr(10)||
'   and :F4000_REGION_SELECTED = p.id) ',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62992810843595124.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Posizione del modello di area #CLOSE#',
  p_lov_return_value=>'REGION_TEMPLATE_CLOSE',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p'||chr(10)||
' where p.flow_id = :FB_FLOW_ID'||chr(10)||
'   and p.PLUG_TEMPLATE = t.id'||chr(10)||
'   and dbms_lob.instr(t.template,''#CLOSE#'') > 0'||chr(10)||
'   and :F4000_REGION_SELECTED = p.id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93091020144798464.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10.1,
  p_lov_disp_value=>'Posizione del modello di area #COPY#',
  p_lov_return_value=>'REGION_TEMPLATE_COPY',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p'||chr(10)||
' where p.flow_id = :FB_FLOW_ID'||chr(10)||
'   and p.PLUG_TEMPLATE = t.id'||chr(10)||
'   and dbms_lob.instr(t.template,''#COPY#'') > 0'||chr(10)||
'   and :F4000_REGION_SELECTED = p.id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62992615015595124.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10.2,
  p_lov_disp_value=>'Posizione del modello di area #CREATE#',
  p_lov_return_value=>'REGION_TEMPLATE_CREATE',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p'||chr(10)||
' where p.flow_id = :FB_FLOW_ID'||chr(10)||
'   and p.PLUG_TEMPLATE = t.id'||chr(10)||
'   and dbms_lob.instr(t.template,''#CREATE#'') > 0'||chr(10)||
'   and :F4000_REGION_SELECTED = p.id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94882719481696997.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10.3,
  p_lov_disp_value=>'Posizione del modello di area #CREATE2#',
  p_lov_return_value=>'REGION_TEMPLATE_CREATE2',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p'||chr(10)||
' where p.flow_id = :FB_FLOW_ID'||chr(10)||
'   and p.PLUG_TEMPLATE = t.id'||chr(10)||
'   and dbms_lob.instr(t.template,''#CREATE2#'') > 0'||chr(10)||
'   and :F4000_REGION_SELECTED = p.id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>92332909801949409.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10.5,
  p_lov_disp_value=>'Posizione del modello di area #DELETE#',
  p_lov_return_value=>'REGION_TEMPLATE_DELETE',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p'||chr(10)||
' where p.flow_id = :FB_FLOW_ID'||chr(10)||
'   and p.PLUG_TEMPLATE = t.id'||chr(10)||
'   and dbms_lob.instr(t.template,''#DELETE#'') > 0'||chr(10)||
'   and :F4000_REGION_SELECTED = p.id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62992414762595123.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'Posizione del modello di area #EDIT#',
  p_lov_return_value=>'REGION_TEMPLATE_EDIT',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p'||chr(10)||
' where p.flow_id = :FB_FLOW_ID'||chr(10)||
'   and p.PLUG_TEMPLATE = t.id'||chr(10)||
'   and dbms_lob.instr(t.template,''#EDIT#'') > 0'||chr(10)||
'   and :F4000_REGION_SELECTED = p.id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62993052778595124.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>12,
  p_lov_disp_value=>'Posizione del modello di area #EXPAND#',
  p_lov_return_value=>'REGION_TEMPLATE_EXPAND',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p'||chr(10)||
' where p.flow_id = :FB_FLOW_ID'||chr(10)||
'   and p.PLUG_TEMPLATE = t.id'||chr(10)||
'   and dbms_lob.instr(t.template,''#EXPAND#'') > 0'||chr(10)||
'   and :F4000_REGION_SELECTED = p.id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62993213440595125.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>13,
  p_lov_disp_value=>'Posizione del modello di area #HELP#',
  p_lov_return_value=>'REGION_TEMPLATE_HELP',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p'||chr(10)||
' where p.flow_id = :FB_FLOW_ID'||chr(10)||
'   and p.PLUG_TEMPLATE = t.id'||chr(10)||
'   and dbms_lob.instr(t.template,''#HELP#'') > 0'||chr(10)||
'   and :F4000_REGION_SELECTED = p.id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91088720180648151.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>14,
  p_lov_disp_value=>'Posizione del modello di area #NEXT#',
  p_lov_return_value=>'REGION_TEMPLATE_NEXT',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p'||chr(10)||
' where p.flow_id = :FB_FLOW_ID'||chr(10)||
'   and p.PLUG_TEMPLATE = t.id'||chr(10)||
'   and dbms_lob.instr(t.template,''#NEXT#'') > 0'||chr(10)||
'   and :F4000_REGION_SELECTED = p.id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91089316514649842.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>15,
  p_lov_disp_value=>'Posizione del modello di area #PREVIOUS#',
  p_lov_return_value=>'REGION_TEMPLATE_PREVIOUS',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p'||chr(10)||
' where p.flow_id = :FB_FLOW_ID'||chr(10)||
'   and p.PLUG_TEMPLATE = t.id'||chr(10)||
'   and dbms_lob.instr(t.template,''#PREVIOUS#'') > 0'||chr(10)||
'   and :F4000_REGION_SELECTED = p.id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>138976531453546871.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62990572348595109.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>16,
  p_lov_disp_value=>'A destra della barra di ricerca del report interattivo',
  p_lov_return_value=>'RIGHT_OF_IR_SEARCH_BAR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/button_style
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86073927602789091.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BUTTON_STYLE',
  p_lov_query=> '.'||to_char(86073927602789091 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88291012122797801.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86073927602789091.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Pulsante HTML',
  p_lov_return_value=>'HTML',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88291203722797802.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86073927602789091.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Pulsante basato su modello',
  p_lov_return_value=>'BUTTON_TEMPLATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88291406025797802.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86073927602789091.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Immagine',
  p_lov_return_value=>'IMAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/button_tag_attributes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 159064700887669967.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BUTTON_TAG_ATTRIBUTES',
  p_lov_query=> 'select distinct TAG_ATTRIBUTES d, tag_attributes r'||chr(10)||
'from wwv_flow_step_items'||chr(10)||
'where flow_id = :fb_flow_id and DISPLAY_AS = ''BUTTON'''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/button_template
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86577503884170242.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BUTTON_TEMPLATE',
  p_lov_query=> 'select htf.escape_sc(template_name) d, ''template:''||id r'||chr(10)||
'from   wwv_flow_button_templates'||chr(10)||
'where  flow_id = :fb_flow_id and'||chr(10)||
'       (:fb_theme_id is null or theme_id = :fb_theme_id)'||chr(10)||
'order by upper(template_name)');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/button_theme
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86576425917167143.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BUTTON_THEME',
  p_lov_query=> 'select d,r from'||chr(10)||
'    (select initcap(wwv_flow_lang.system_message(''ALL_THEMES'')) d,0 r,1 ob from dual'||chr(10)||
'      union'||chr(10)||
'     select name d,id r,2 ob from wwv_flow_template_themes$ t'||chr(10)||
'      where name is not null'||chr(10)||
'        and exists (select null'||chr(10)||
'                      FROM WWV_FLOW_TEMPLATES$'||chr(10)||
'                     WHERE template_type = ''Button'''||chr(10)||
'                       and theme = t.id))'||chr(10)||
'order by ob');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/button_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86072317559786247.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BUTTON_TYPE',
  p_lov_query=> 'select wwv_flow_lang.system_message(''HTML_BUTTON'') d,''TEXT'' r from dual '||chr(10)||
'union all'||chr(10)||
'select wwv_flow_lang.system_message(''TEMPLATE_DRIVEN'') d, ''TEMPLATE'' r from dual where exists (select 1 from wwv_flow_button_templates where flow_id = :FB_FLOW_ID) '||chr(10)||
'union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''IMAGE'')) d,''IMAGE'' r from dual order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/cal_display_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 37322928139444048.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CAL.DISPLAY_TYPES',
  p_lov_query=> '.'||to_char(37322928139444048 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>37323215840444057.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>37322928139444048.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Colonna',
  p_lov_return_value=>'COL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>37323417633444059.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>37322928139444048.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Personalizzato',
  p_lov_return_value=>'CUS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>37323623070444059.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>37322928139444048.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Nessun valore visualizzato',
  p_lov_return_value=>'NONE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/calendar_theme_class_id
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 43619531898960304.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CALENDAR THEME CLASS ID',
  p_lov_query=> '.'||to_char(43619531898960304 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43619801874960319.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43619531898960304.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Calendario',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43621609988960339.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43619531898960304.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Calendario, alternativa 1',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>52331910898784713.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43619531898960304.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Calendario piccolo',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43620000338960319.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43619531898960304.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 1',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43620205626960337.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43619531898960304.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 2',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43620400113960337.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43619531898960304.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 3',
  p_lov_return_value=>'6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43620604334960337.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43619531898960304.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 4',
  p_lov_return_value=>'7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43620830451960338.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43619531898960304.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 5',
  p_lov_return_value=>'8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43621023248960338.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43619531898960304.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 6',
  p_lov_return_value=>'9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43621201713960338.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43619531898960304.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 7',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43621428586960338.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43619531898960304.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 8',
  p_lov_return_value=>'11',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/calendar_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 113156910229994686.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CALENDAR_TYPE',
  p_lov_query=> 'select wwv_flow_lang.system_message(''CONFIRM.STANDARD_CALENDAR'') d, ''S'' r from dual union all'||chr(10)||
'select wwv_flow_lang.system_message(''CONFIRM.PARTIAL_REFRESH_CALENDAR'') d, ''A'' r from dual');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/chart_bar_color
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84324431881606062.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHART_BAR_COLOR',
  p_lov_query=> '.'||to_char(84324431881606062 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84324600310606063.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84324431881606062.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Nero',
  p_lov_return_value=>'BLACK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84324819442606063.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84324431881606062.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Blu',
  p_lov_return_value=>'BLUE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84325003884606064.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84324431881606062.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Marrone',
  p_lov_return_value=>'BROWN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84325217038606064.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84324431881606062.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Verde',
  p_lov_return_value=>'GREEN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84325407670606064.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84324431881606062.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Arancione',
  p_lov_return_value=>'ORANGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84325609277606064.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84324431881606062.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Viola',
  p_lov_return_value=>'PURPLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84325828072606065.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84324431881606062.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Rosso',
  p_lov_return_value=>'RED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84326022893606065.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84324431881606062.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'Giallo',
  p_lov_return_value=>'YELLOW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/chart_label_opts
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84785018266011049.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHART_LABEL_OPTS',
  p_lov_query=> '.'||to_char(84785018266011049 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84785213250011049.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84785018266011049.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Mostra bolla',
  p_lov_return_value=>'BUBBLE',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84785432162011050.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84785018266011049.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Mostra valore',
  p_lov_return_value=>'VALUE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/chart_query_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 2944917074050416.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHART_QUERY_OPTIONS',
  p_lov_query=> '.'||to_char(2944917074050416 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2945205253050420.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2944917074050416.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Esegui convalida query',
  p_lov_return_value=>'PARSE_CHART_QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2945401126050421.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2944917074050416.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Salva query senza convalida',
  p_lov_return_value=>'IGNORE_CHART_QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/chart_theme
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84770023535917923.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHART_THEME',
  p_lov_query=> '.'||to_char(84770023535917923 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84770217422917924.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84770023535917923.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Aspetto 1',
  p_lov_return_value=>'RED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84770421612917924.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84770023535917923.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Aspetto 2',
  p_lov_return_value=>'ARG',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84770630757917924.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84770023535917923.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Aspetto 3',
  p_lov_return_value=>'LOOK_3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/chart_wizard_dial_maxvalue
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 249428101086098299.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHART_WIZARD_DIAL_MAXVALUE',
  p_lov_query=> '.'||to_char(249428101086098299 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>249428318833098301.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>249428101086098299.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'100%',
  p_lov_return_value=>'0',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>249457015809140458.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>249428101086098299.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'MAX',
  p_lov_return_value=>'MAX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>249457621350142006.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>249428101086098299.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'SUM',
  p_lov_return_value=>'SUM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/checkbox_show_page_components
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 145937328496747754.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHECKBOX SHOW PAGE COMPONENTS',
  p_lov_query=> '.'||to_char(145937328496747754 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>145937826343747822.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>145937328496747754.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Componenti di pagina',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/checkbox_show_shared_components
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 144512500887046057.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHECKBOX SHOW SHARED COMPONENTS',
  p_lov_query=> '.'||to_char(144512500887046057 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144512826218046101.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144512500887046057.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Componenti condivisi',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/checkbox_show_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 152029513350781444.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHECKBOX SHOW TEMPLATES',
  p_lov_query=> '.'||to_char(152029513350781444 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>152029929235781496.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>152029513350781444.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Modelli',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/checkbox_yes_noprompt
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84718210763776190.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHECKBOX_YES_NOPROMPT',
  p_lov_query=> '.'||to_char(84718210763776190 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84718405875776191.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84718210763776190.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'&nbsp;',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/checkbox_y_noprompt
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84715102189754797.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHECKBOX_Y_NOPROMPT',
  p_lov_query=> '.'||to_char(84715102189754797 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84715319258754797.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84715102189754797.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'&nbsp;',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/check_all
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84334521061621823.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHECK_ALL',
  p_lov_query=> '.'||to_char(84334521061621823 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84334731772621824.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84334521061621823.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'&nbsp;',
  p_lov_return_value=>'CHECK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/choose_application_run_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 83730320399098234.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHOOSE_APPLICATION_RUN_STATUS',
  p_lov_query=> '.'||to_char(83730320399098234 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>83730508003098241.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>83730320399098234.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Esegui applicazione',
  p_lov_return_value=>'RUN_ONLY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>83730705521098245.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>83730320399098234.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Esegui e costruisci applicazione',
  p_lov_return_value=>'RUN_AND_BUILD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/choose_chart_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 4862431139794465.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHOOSE_CHART_TYPE',
  p_lov_query=> '.'||to_char(4862431139794465 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4863128625794472.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4862431139794465.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Grafico flash',
  p_lov_return_value=>'FLASH',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:616:&SESSION.:::616,634,642,647,648,701,668"><img src="#IMAGE_PREFIX#menu/wiz_flash_chart_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4862902956794472.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4862431139794465.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Grafico SVG',
  p_lov_return_value=>'SVG',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4700:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:CHART,HBAR"><img src="#IMAGE_PREFIX#menu/wiz_svg_chart_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4862712472794472.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4862431139794465.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Grafico HTML',
  p_lov_return_value=>'HTML',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4710:&SESSION.::NO:4710,4780,4781,375::"><img src="#IMAGE_PREFIX#menu/wiz_html_chart_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/choose_chart_type_r
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 5807728495302209.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHOOSE_CHART_TYPE_R',
  p_lov_query=> '.'||to_char(5807728495302209 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5808222675302210.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>5807728495302209.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Grafico flash',
  p_lov_return_value=>'FLASH',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4016:&SESSION.:::4016,719,683,692:P4016_SOURCE_TYPE:FLASH_CHART"><img src="#IMAGE_PREFIX#menu/wiz_flash_chart_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5808411478302210.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>5807728495302209.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Grafico SVG',
  p_lov_return_value=>'SVG',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:357:&SESSION.::::P4016_SOURCE_TYPE:CHART"><img src="#IMAGE_PREFIX#menu/wiz_svg_chart_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5808006503302209.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>5807728495302209.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Grafico HTML',
  p_lov_return_value=>'HTML',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:SIMPLE_CHART"><img src="#IMAGE_PREFIX#menu/wiz_html_chart_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/choose_page_type_drop_button
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 18219708612919020.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHOOSE_PAGE_TYPE_DROP_BUTTON',
  p_lov_query=> '.'||to_char(18219708612919020 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>18219904618919027.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>18219708612919020.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Pagina vuota',
  p_lov_return_value=>'ONE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4714:&SESSION.:::4714,4715,4716,78,81,82,79,80,83"><img src="#IMAGE_PREFIX#htmldb/builder/blank_page_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>18220104642919032.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>18219708612919020.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Più pagine vuote',
  p_lov_return_value=>'MANY',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:295:&SESSION.:CC:NO:295::"><img src="#IMAGE_PREFIX#htmldb/builder//blank_pages_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>18220301596919032.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>18219708612919020.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Report',
  p_lov_return_value=>'REPORT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4700:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:REPORT,SQL_REPORT"><img src="#IMAGE_PREFIX#htmldb/builder/report_component_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>18220527798919032.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>18219708612919020.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Grafico',
  p_lov_return_value=>'CHART',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4700:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:CHART,BAR_HTML"><img src="#IMAGE_PREFIX#htmldb/builder/chart_component_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>18220700181919033.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>18219708612919020.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Form',
  p_lov_return_value=>'FORM',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4700:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:FORM,FORM_ON_A_TABLE"><img src="#IMAGE_PREFIX#htmldb/builder/form_component_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>18220916589919033.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>18219708612919020.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Procedura guidata',
  p_lov_return_value=>'WIZARD',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4700:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:WIZARD,SIMPLE_WIZARD"><img src="#IMAGE_PREFIX#htmldb/builder/wizard_component_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>18221116827919033.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>18219708612919020.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Calendario',
  p_lov_return_value=>'CALENDAR',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4700:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:CALENDAR,CALENDAR"><img src="#IMAGE_PREFIX#htmldb/builder/calendar_component_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>18221316484919037.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>18219708612919020.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Struttura',
  p_lov_return_value=>'ONEPAGE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:112:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:TREE,TREE"><img src="#IMAGE_PREFIX#htmldb/builder/tree_component_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>18221508934919037.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>18219708612919020.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Pagina di login',
  p_lov_return_value=>'LOGIN',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:500:&SESSION.::NO:::"><img src="#IMAGE_PREFIX#htmldb/builder/blank_page_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/choose_page_type_p259
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 21148926321786721.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHOOSE_PAGE_TYPE_P259',
  p_lov_query=> '.'||to_char(21148926321786721 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15949709341550987.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21148926321786721.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Pagina vuota',
  p_lov_return_value=>'ONE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4714:&SESSION.:::4714,4715,4716,78,81,82,79,80,83"><img src="#IMAGE_PREFIX#menu/wiz_blank_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15950120769554270.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21148926321786721.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Più pagine vuote',
  p_lov_return_value=>'MANY',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:295:&SESSION.:CC:NO:295::"><img src="#IMAGE_PREFIX#menu/wiz_multiple_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21149204648786725.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21148926321786721.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Report',
  p_lov_return_value=>'REPORT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4700:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:REPORT,SQL_REPORT"><img src="#IMAGE_PREFIX#menu/wiz_classic_report_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21149424262786726.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21148926321786721.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Grafico',
  p_lov_return_value=>'CHART',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:709:&SESSION.:::709"><img src="#IMAGE_PREFIX#menu/wiz_flash_chart_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21149614655786727.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21148926321786721.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Form',
  p_lov_return_value=>'FORM',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4700:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:FORM,FORM_ON_A_TABLE"><img src="#IMAGE_PREFIX#menu/wiz_form_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21149822778786727.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21148926321786721.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Procedura guidata',
  p_lov_return_value=>'WIZARD',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:107:&SESSION.::NO:107,108,109,110,111,140,141,CREATE_WIZARD"><img src="#IMAGE_PREFIX#menu/wiz_wiz_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21150022003786727.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21148926321786721.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Calendario',
  p_lov_return_value=>'CALENDAR',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4700:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:CALENDAR,CALENDAR"><img src="#IMAGE_PREFIX#menu/wiz_calendar_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21150200501786727.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21148926321786721.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Struttura',
  p_lov_return_value=>'TREE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:112:&SESSION.::::P259_CHOOSE_PAGE_TYPE,P4700_SELECT_REPORT_TYPE:TREE,TREE"><img src="#IMAGE_PREFIX#menu/wiz_tree_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16040025645782722.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21148926321786721.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Pagina di login',
  p_lov_return_value=>'LOGIN',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:500:&SESSION.::NO:::"><img src="#IMAGE_PREFIX#menu/wiz_login_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8678021377313480.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21148926321786721.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Controllo dell''accesso',
  p_lov_return_value=>'ADMIN',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:572:&SESSION.::NO:572,614,624,626,629::"><img src="#IMAGE_PREFIX#menu/wiz_access_ctrl_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>3240924233313161.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>21148926321786721.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'Pagina zero',
  p_lov_return_value=>'ZERO',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:698:&SESSION.::NO:::"><img src="#IMAGE_PREFIX#menu/wiz_blank_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="90" /></a>',
  p_lov_disp_cond_type=>'NOT_EXISTS',
  p_lov_disp_cond=> 'select 1 from wwv_flow_steps where id = 0 and flow_id = :fb_flow_id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/column_heading_sort
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 113075615286820438.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'COLUMN_HEADING_SORT',
  p_lov_query=> '.'||to_char(113075615286820438 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113075923766820443.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>113075615286820438.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Utilizza ordinamento intestazioni di colonna',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/column_link_checksum_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 106733132624028207.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'COLUMN_LINK_CHECKSUM_TYPES',
  p_lov_query=> '.'||to_char(106733132624028207 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>106733331539028208.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>106733132624028207.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A livello applicazione - Collegamento riutilizzabile da qualsiasi utente',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>106733500292028209.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>106733132624028207.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'A livello di utente - Collegamento riutilizzabile dall''utente corrente',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/column_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84700223258656794.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'COLUMN_TYPES',
  p_lov_query=> '.'||to_char(84700223258656794 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84700401229656794.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84700223258656794.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Derivate da colonne di query',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84700609402656795.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84700223258656794.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Colonne generiche',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/column_width_units
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 137868513981838198.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'COLUMN_WIDTH_UNITS',
  p_lov_query=> '.'||to_char(137868513981838198 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>137868804503838258.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>137868513981838198.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Percentuale',
  p_lov_return_value=>'PERCENTAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>137869020870838259.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>137868513981838198.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Punto',
  p_lov_return_value=>'POINTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/comment_mgt
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 131122619933750813.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'COMMENT MGT',
  p_lov_query=> '.'||to_char(131122619933750813 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131122805830750820.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131122619933750813.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Elimina tutti i commenti',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131123017423750828.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131122619933750813.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Elimina i commenti creati da uno sviluppatore',
  p_lov_return_value=>'DEVELOPER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131123206286750828.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131122619933750813.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Elimina i commenti per data',
  p_lov_return_value=>'DATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/component_export_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'COMPONENT EXPORT TYPES',
  p_lov_query=> '.'||to_char(199792419544604880 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88169414308662248.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Layout report',
  p_lov_return_value=>'REPORT LAYOUT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88170320196663919.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Query report',
  p_lov_return_value=>'SHARED QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>199792605603604882.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Lista',
  p_lov_return_value=>'LIST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>199792826481604888.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Indicatore di percorso',
  p_lov_return_value=>'BREADCRUMB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>199793007435604888.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modello di pulsante',
  p_lov_return_value=>'BUTTON TEMPLATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>199793210789604889.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modello di area',
  p_lov_return_value=>'REGION TEMPLATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>199793430066604889.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modello di lista',
  p_lov_return_value=>'LIST TEMPLATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>199793602808604889.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modello di report',
  p_lov_return_value=>'REPORT TEMPLATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>199793813538604889.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modello di etichetta',
  p_lov_return_value=>'LABEL TEMPLATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>199794014487604889.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modello di indicatore di percorso',
  p_lov_return_value=>'BREADCRUMB TEMPLATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>199794210349604890.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modello di lista di valori popup',
  p_lov_return_value=>'POPUP LOV TEMPLATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>199794427619604890.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modello di calendario',
  p_lov_return_value=>'CALENDAR TEMPLATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>199794616609604894.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Scorciatoia',
  p_lov_return_value=>'SHORTCUTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200202824981524232.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modello di pagina',
  p_lov_return_value=>'PAGE TEMPLATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200233832412762910.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Pagina',
  p_lov_return_value=>'PAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200585127199677854.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Scheda',
  p_lov_return_value=>'TAB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200585432740679415.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Lista di valori',
  p_lov_return_value=>'LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200598316126750303.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Scheda padre',
  p_lov_return_value=>'PARENT TAB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200618224400150192.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Elemento della barra di navigazione',
  p_lov_return_value=>'NAVBAR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200618600982152826.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Schema di sicurezza',
  p_lov_return_value=>'SECURITY SCHEME',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200623401207219165.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Struttura',
  p_lov_return_value=>'TREE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200623806747220760.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Processo applicazione',
  p_lov_return_value=>'APP PROCESS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200624310557221801.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Elemento applicazione',
  p_lov_return_value=>'APP ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200624816098223399.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Calcolo applicazione',
  p_lov_return_value=>'APP COMPUTATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200651901796436953.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Voce di indicatore di percorso',
  p_lov_return_value=>'BREADCRUMB ENTRY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200660420384584219.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Servizio Web',
  p_lov_return_value=>'WEB SERVICE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200660825232585623.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Schema di autenticazione',
  p_lov_return_value=>'AUTH SETUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200766615739248201.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Opzione di creazione',
  p_lov_return_value=>'BUILD OPTION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201563917112922295.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Attributo applicazione',
  p_lov_return_value=>'APPLICATION ATTRIBUTES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>229079719033109099.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>199792419544604880.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Stato opzioni di creazione',
  p_lov_return_value=>'BUILD OPTION STATUS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/computation_item
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86610204202293298.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'COMPUTATION_ITEM',
  p_lov_query=> 'select wwv_flow_lang.system_message(''APPLICATION'')||'': ''||name d, name v'||chr(10)||
'from wwv_flow_items'||chr(10)||
'where flow_id = :FB_FLOW_ID'||chr(10)||
'union all'||chr(10)||
'select wwv_flow_lang.system_message(''PAGE'')||'': ''||flow_step_id||'' ''||name d, name v'||chr(10)||
'from wwv_flow_step_items'||chr(10)||
'where flow_id = :FB_FLOW_ID'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/condition_control_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 179476200494904933.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CONDITION CONTROL TYPE',
  p_lov_query=> '.'||to_char(179476200494904933 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179477608235904943.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179476200494904933.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Diramazione',
  p_lov_return_value=>'BRANCH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179492924267978066.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179476200494904933.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Pulsante',
  p_lov_return_value=>'BUTTON',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179477001828904942.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179476200494904933.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Calcolo',
  p_lov_return_value=>'COMPUTATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179476801795904940.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179476200494904933.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Elemento',
  p_lov_return_value=>'ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179477429719904942.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179476200494904933.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Processo',
  p_lov_return_value=>'PROCESS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179476625958904939.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179476200494904933.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Area',
  p_lov_return_value=>'REGION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179477227849904942.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179476200494904933.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Convalida',
  p_lov_return_value=>'VALIDATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/consolidate_template_names_returning_id
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 94009001670849130.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CONSOLIDATE_TEMPLATE_NAMES RETURNING ID',
  p_lov_query=> 'select page_plug_template_name d, id'||chr(10)||
'from wwv_flow_page_plug_templates'||chr(10)||
'where flow_id = :FB_FLOW_ID and '||chr(10)||
'THEME_ID = (select theme_id from wwv_flows where id = :FB_FLOW_ID) and'||chr(10)||
':P708_TEMPLATE_TYPE = ''REGION'''||chr(10)||
'union all'||chr(10)||
'select name d, id '||chr(10)||
'from WWV_FLOW_TEMPLATES '||chr(10)||
'where flow_id = :FB_FLOW_ID and '||chr(10)||
'THEME_ID = (select theme_id from wwv_flows where id = :FB_FLOW_ID) and'||chr(10)||
':P708_TEMPLATE_TYPE = ''PAGE'''||chr(10)||
'union all'||chr(10)||
'select template_name d, id'||chr(10)||
'from wwv_flow_field_templates f'||chr(10)||
'where '||chr(10)||
'f.flow_id = :FB_FLOW_ID and '||chr(10)||
'THEME_ID = (select theme_id from wwv_flows where id = :FB_FLOW_ID) and'||chr(10)||
':P708_TEMPLATE_TYPE = ''LABEL'''||chr(10)||
'union all'||chr(10)||
'select '||chr(10)||
'l.list_template_name d, l.id'||chr(10)||
'from '||chr(10)||
'wwv_flow_list_templates l'||chr(10)||
'where '||chr(10)||
'l.flow_id = :FB_FLOW_ID and'||chr(10)||
'THEME_ID = (select theme_id from wwv_flows where id = :FB_FLOW_ID) and'||chr(10)||
':P708_TEMPLATE_TYPE = ''LIST'''||chr(10)||
'union all'||chr(10)||
'select name d, id'||chr(10)||
'from wwv_flow_cal_templates'||chr(10)||
'where flow_id = :FB_FLOW_ID and'||chr(10)||
'THEME_ID = (select theme_id from wwv_flows where id = :FB_FLOW_ID) and'||chr(10)||
':P708_TEMPLATE_TYPE = ''CALENDAR'''||chr(10)||
'union all'||chr(10)||
'select name d, id'||chr(10)||
'from wwv_flow_menu_templates'||chr(10)||
'where flow_id = :FB_FLOW_ID and'||chr(10)||
'THEME_ID = (select theme_id from wwv_flows where id = :FB_FLOW_ID) and'||chr(10)||
':P708_TEMPLATE_TYPE = ''MENU'''||chr(10)||
'union all'||chr(10)||
'select template_name d, id'||chr(10)||
'from WWV_FLOW_BUTTON_TEMPLATES'||chr(10)||
'where flow_id = :FB_FLOW_ID and'||chr(10)||
'THEME_ID = (select theme_id from wwv_flows where id = :FB_FLOW_ID) and'||chr(10)||
':P708_TEMPLATE_TYPE = ''BUTTON'''||chr(10)||
'union all'||chr(10)||
'select ''* ''||wwv_flow_lang.system_message(''HTML_BUTTON'') d, -1 id'||chr(10)||
'from dual'||chr(10)||
'where :P708_TEMPLATE_TYPE = ''BUTTON'''||chr(10)||
'union all'||chr(10)||
'select ROW_TEMPLATE_NAME d, id'||chr(10)||
'from WWV_FLOW_ROW_TEMPLATES'||chr(10)||
'where flow_id = :FB_FLOW_ID and'||chr(10)||
'THEME_ID = (select theme_id from wwv_flows where id = :FB_FLOW_ID) and'||chr(10)||
':P708_TEMPLATE_TYPE = ''REPORT'''||chr(10)||
'union all'||chr(10)||
'select ''* ''||wwv_flow_lang.system_message(''REGION_TEMPLATES_NO_TEMPLATE'') d, -1 id'||chr(10)||
'from dual'||chr(10)||
'where :P708_TEMPLATE_TYPE in (''PAGE'',''REGION'')');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/content_disposition
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 137375920403903467.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CONTENT_DISPOSITION',
  p_lov_query=> '.'||to_char(137375920403903467 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>137376221863903468.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>137375920403903467.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Allegato',
  p_lov_return_value=>'ATTACHMENT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>137376416435903468.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>137375920403903467.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'In linea',
  p_lov_return_value=>'INLINE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/copy_list_option
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 231048823449529621.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'COPY LIST OPTION',
  p_lov_query=> '.'||to_char(231048823449529621 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>231049006115529624.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>231048823449529621.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista in questa applicazione',
  p_lov_return_value=>'SAME',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:602:&SESSION.:::::"><img src="#IMAGE_PREFIX#htmldb/builder/copy_page1.gif" height="115" width="140" title="#DISPLAY_VALUE#"  class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>231049208911529628.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>231048823449529621.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Lista in un''altra applicazione',
  p_lov_return_value=>'DIFF',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:659:&SESSION.:::::"><img src="#IMAGE_PREFIX#htmldb/builder/copy_page2.gif" height="115" width="140" title="#DISPLAY_VALUE#"  class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/copy_lists
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 10919919806296646.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'COPY LISTS',
  p_lov_query=> 'select htf.escape_sc(name) d, id '||chr(10)||
'from wwv_flow_lists where flow_id = v(''FB_FLOW_ID'') '||chr(10)||
'and id <> :P477_COPY_LIST_FROM'||chr(10)||
'order by 1'||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/copy_page_option
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 200992128346618114.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'COPY_PAGE_OPTION',
  p_lov_query=> '.'||to_char(200992128346618114 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200992325093618118.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>200992128346618114.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Pagina in questa applicazione',
  p_lov_return_value=>'SAME',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:301:&SESSION.:::301,302,305,308,309,310,315,316,317,319::"><img src="#IMAGE_PREFIX#htmldb/builder/copy_page1.gif" height="115" width="140" title="#DISPLAY_VALUE#"  class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>200992505592618121.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>200992128346618114.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Pagina in un''altra applicazione',
  p_lov_return_value=>'DIFF',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:619:&SESSION.:::619,621,622,623,625,627,628,671,672,673,676,677,678,684,COPY_PAGE_LOV,COPY_PAGE_LIST,COPY_PAGE_SECURITY,COPY_PAGE_BRANCH,COPY_PAGE_TEMPLATES::"><img src="#IMAGE_PREFIX#htmldb/builder/copy_page2.gif" height="115" width="140" title="#DISPLAY_VALUE#"  class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/copy_sc_option
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 201061511357162008.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'COPY_SC_OPTION',
  p_lov_query=> '.'||to_char(201061511357162008 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201061731765162010.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201061511357162008.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Non copiare',
  p_lov_return_value=>'NO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201061913763162012.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201061511357162008.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Copia',
  p_lov_return_value=>'COPY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201062131688162012.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201061511357162008.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Usa esistente',
  p_lov_return_value=>'EXISTING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_application_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 59753909083040661.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE APPLICATION OPTIONS',
  p_lov_query=> '.'||to_char(59753909083040661 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26241730896520403.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59753909083040661.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Crea applicazione',
  p_lov_return_value=>'MULTITABLE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:3000:&SESSION.:CC:&DEBUG.:3000,3001,3020"><img src="#IMAGE_PREFIX#htmldb/builder/application_from_scratch.gif" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a><br /><br />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>29733526462640744.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59753909083040661.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Crea da foglio di calcolo',
  p_lov_return_value=>'SPREADSHEET',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:447:&SESSION.:::448,451,454,458,189,494,495,496,176,EXCEL_IMPORT,CSV_IMPORT,CREATE_APP_COLUMN_UI_DEFAULT:F4000_P56_CREATE_OPTION:SPREADSHEET"><img src="#IMAGE_PREFIX#htmldb/builder/application_from_spreadsheet.gif" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a><br /><br />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5954219495099076.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59753909083040661.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Applicazione demo',
  p_lov_return_value=>'DEMO',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:320:&SESSION.::::F4000_P56_CREATE_OPTION:DEMO"><img src="#IMAGE_PREFIX#htmldb/builder/application_from_demo.gif" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a><br /><br />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_application_page_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 139812219112455338.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE APPLICATION PAGE TYPE',
  p_lov_query=> '.'||to_char(139812219112455338 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>139812423391455342.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>139812219112455338.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Aggiungere pagina vuota all''applicazione',
  p_lov_return_value=>'BLANK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>139813830194458580.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>139812219112455338.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Aggiungere un report',
  p_lov_return_value=>'REPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>139812618398455343.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>139812219112455338.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Aggiungere un report con un form di modifica sulla seconda pagina',
  p_lov_return_value=>'REPORTANDFORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>139812820281455343.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>139812219112455338.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Aggiungere un form tabulare',
  p_lov_return_value=>'TABULARFORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>139813027803455343.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>139812219112455338.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Aggiungere un form con inserimento, aggiornamento ed eliminazione.',
  p_lov_return_value=>'FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>111750431837325937.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>139812219112455338.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Aggiunge un form MD (Master-Detail)',
  p_lov_return_value=>'MASTERDETAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_cal_type_page_wizard
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 202761521943494724.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE CAL TYPE PAGE WIZARD',
  p_lov_query=> '.'||to_char(202761521943494724 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>202761815463494728.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>202761521943494724.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Calendario semplice',
  p_lov_return_value=>'EASY_CALENDAR',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4785:&SESSION.::::P4700_SELECT_REPORT_TYPE:EASY_CALENDAR"><img src="#IMAGE_PREFIX#htmldb/builder/calendar_easy_xl.gif" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcon" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>202762012277494728.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>202761521943494724.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Calendario SQL',
  p_lov_return_value=>'CALENDAR',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4785:&SESSION.::::P4700_SELECT_REPORT_TYPE:CALENDAR"><img src="#IMAGE_PREFIX#htmldb/builder/calendar_sql_xl.gif" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcon" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_install_script_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 4579300425024699.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE INSTALL SCRIPT OPTIONS',
  p_lov_query=> '.'||to_char(4579300425024699 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4579506061024700.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4579300425024699.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Crea completamente nuovo/a',
  p_lov_return_value=>'SCRATCH',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:855:&SESSION.:CC:&DEBUG.:855,856,857:P850_SCRIPT_SOURCE:SCRATCH"><img src="#IMAGE_PREFIX#htmldb/builder/inst_scratch.png" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a><br /><br />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4579726361024700.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4579300425024699.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Copia dal repository script SQL',
  p_lov_return_value=>'SCRIPT_REPOSITORY',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:855:&SESSION.:::855,856,857:P850_SCRIPT_SOURCE:SCRIPT_REPOSITORY"><img src="#IMAGE_PREFIX#htmldb/builder/inst_repository.png" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a><br /><br />',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4579908206024701.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4579300425024699.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Crea da file',
  p_lov_return_value=>'FILE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:855:&SESSION.:::855,856,857:P850_SCRIPT_SOURCE:FILE"><img src="#IMAGE_PREFIX#htmldb/builder/inst_file.png" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a><br /><br />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>205940123741065225.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4579300425024699.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Crea script per installazione file',
  p_lov_return_value=>'APEX_FILES',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:858:&SESSION.:::855,856,857,858:P850_SCRIPT_SOURCE:APEX_FILES"><img src="#IMAGE_PREFIX#htmldb/builder/inst_script.png" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a><br /><br />',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_multiple_items_p256
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 162048107844243840.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE MULTIPLE ITEMS P256',
  p_lov_query=> '.'||to_char(162048107844243840 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>162048426183243882.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>162048107844243840.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Testo',
  p_lov_return_value=>'TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>162048628552243882.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>162048107844243840.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Area di testo',
  p_lov_return_value=>'TEXTAREA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>162048825522243882.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>162048107844243840.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Casella di controllo',
  p_lov_return_value=>'CHECKBOX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>162049013715243883.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>162048107844243840.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Gruppo pulsanti di scelta',
  p_lov_return_value=>'RADIOGROUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>162049205581243883.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>162048107844243840.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Lista di selezione',
  p_lov_return_value=>'COMBOBOX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>162049424562243883.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>162048107844243840.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Nascosto',
  p_lov_return_value=>'HIDDEN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_page_or_component
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 157442823932912073.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE PAGE OR COMPONENT',
  p_lov_query=> '.'||to_char(157442823932912073 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>157443006139912075.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>157442823932912073.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'<b>Pagina</b>:<br />nuova pagina',
  p_lov_return_value=>'PAGE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:259:&SESSION.:::181,259,380,311,355"><img src="#IMAGE_PREFIX#htmldb/builder/blank_page_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>157443201768912077.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>157442823932912073.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'<b>Area</b>:<br />report, grafico, form...',
  p_lov_return_value=>'COMPONENT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:181:&SESSION.::NO:181,4016,4017,4018,399,382,402,259,380"><img src="#IMAGE_PREFIX#htmldb/builder/component_report_form_chart_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>157883413717173247.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>157442823932912073.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'<b>Controllo</b>:<br />elemento, pulsante, processo...',
  p_lov_return_value=>'CONTROL',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:181:&SESSION.::NO:181,4016,4017,4018,399,382,402,259,380"><img src="#IMAGE_PREFIX#htmldb/builder/component_item_button_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_region_shared_query_selector
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 20958802593769343.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE REGION SHARED QUERY SELECTOR',
  p_lov_query=> '.'||to_char(20958802593769343 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20959016868769343.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>20958802593769343.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Nuova query',
  p_lov_return_value=>'NEW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20959202151769343.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>20958802593769343.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Query condivisa',
  p_lov_return_value=>'SHARED',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'from WWV_FLOW_STORED_QUERIES'||chr(10)||
'where security_group_id = :flow_security_group_id and flow_id = :fb_flow_id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_tree_from_table_list
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 94457102341894843.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE TREE FROM TABLE LIST',
  p_lov_query=> 'select table_name||'' ''||wwv_flow_lang.system_message(''TABLE_IN_PAREN'') d, table_name v'||chr(10)||
'from sys.dba_tables a'||chr(10)||
'where owner = :F4000_P112_OWNER'||chr(10)||
'and table_name not like ''BIN$%'''||chr(10)||
'and (exists (select null'||chr(10)||
'from sys.dba_tab_privs'||chr(10)||
'where grantee = (select owner'||chr(10)||
'from wwv_flows'||chr(10)||
'where id = :FB_FLOW_ID)'||chr(10)||
'and privilege = ''SELECT'''||chr(10)||
'and table_name = a.table_name'||chr(10)||
'and owner = a.owner)'||chr(10)||
'or exists (select null'||chr(10)||
'from wwv_flows'||chr(10)||
'where owner = :F4000_P112_OWNER'||chr(10)||
'and id = :FB_FLOW_ID))'||chr(10)||
'union all'||chr(10)||
'select view_name||'' ''||wwv_flow_lang.system_message(''VIEW_IN_PAREN'') d, view_name v'||chr(10)||
'from sys.dba_views a'||chr(10)||
'where owner = :F4000_P112_OWNER'||chr(10)||
'and (exists (select null'||chr(10)||
'from sys.dba_tab_privs'||chr(10)||
'where grantee = (select owner'||chr(10)||
'from wwv_flows'||chr(10)||
'where id = :FB_FLOW_ID)'||chr(10)||
'and privilege = ''SELECT'''||chr(10)||
'and table_name = a.view_name'||chr(10)||
'and owner = a.owner)'||chr(10)||
'or exists (select null'||chr(10)||
'from wwv_flows'||chr(10)||
'where owner = :F4000_P112_OWNER'||chr(10)||
'and id = :FB_FLOW_ID))'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_app_auth_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 175155625648607577.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE.APP.AUTH.OPTIONS',
  p_lov_query=> 'select d, v from ('||chr(10)||
'select '||chr(10)||
'  :product_name||''<br />''||'||chr(10)||
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/admin_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d ,''HTML DB'' v from dual'||chr(10)||
'union all'||chr(10)||
'select '||chr(10)||
'  wwv_flow_lang.system_message(''CREATE_FLOW.NO_AUTH'')||''<br />''||'||chr(10)||
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/opendoor_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d,''DATABASE'' v from dual'||chr(10)||
'union all'||chr(10)||
'select '||chr(10)||
'  wwv_flow_lang.system_message(''CREATE_FLOW.DBACCOUNT'')||''<br />''||'||chr(10)||
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/dbauth_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d,''DBACCOUNT'' v from dual'||chr(10)||
'union all'||chr(10)||
'select '||chr(10)||
'    flow_id||'' - ''||htf.escape_sc(name)||''<br />''||'||chr(10)||
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/admin_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d, ''.''||id||''.'' v from wwv_flow_custom_auth_setups'||chr(10)||
'where name not in (''HTML DB'',''DATABASE'',''DATABASE ACCOUNT'')'||chr(10)||
'and flow_id = :P433_APPLICATION'||chr(10)||
'and instr(:P433_COPY_OPTIONS||''.'',''AUTHENTICATION'') > 0)');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_button_action
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 54540927710213482.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE.BUTTON.ACTION',
  p_lov_query=> '.'||to_char(54540927710213482 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>54541407261213483.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>54540927710213482.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sottometti pagina e reindirizza a URL',
  p_lov_return_value=>'SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>54541218594213482.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>54540927710213482.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Reindirizza a URL senza sottomissione di pagina',
  p_lov_return_value=>'URL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>116507109393870107.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>54540927710213482.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Scarica query report stampabile',
  p_lov_return_value=>'PRINT',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from WWV_FLOW_SHARED_QUERIES'||chr(10)||
' where flow_id = :fb_flow_id '||chr(10)||
'   and security_group_id = :flow_security_group_id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_cal_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 16354319751573808.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE.CAL.TYPE',
  p_lov_query=> '.'||to_char(16354319751573808 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16354610721573815.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>16354319751573808.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Calendario semplice',
  p_lov_return_value=>'EASY',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:2006:&SESSION.::::P2001_REGION_TYPE,P2006_SOURCE_TYPE:EASY,CALENDAR"><img src="#IMAGE_PREFIX#menu/wiz_ez_calendar_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16354825012573816.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>16354319751573808.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Calendario SQL',
  p_lov_return_value=>'SQL',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:2006:&SESSION.::::P2001_REGION_TYPE,P2006_SOURCE_TYPE:SQL,CALENDAR"><img src="#IMAGE_PREFIX#menu/wiz_calendar_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_flow_auth_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 52256503410339865.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE.FLOW.AUTH.OPTIONS',
  p_lov_query=> '.'||to_char(52256503410339865 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>52257006525339871.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>52256503410339865.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Autenticazione Application Express',
  p_lov_return_value=>'HTML DB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>52257200649339871.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>52256503410339865.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Nessuna autenticazione',
  p_lov_return_value=>'DATABASE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_region_chart_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 59940502744006894.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE.REGION.CHART.TYPE',
  p_lov_query=> '.'||to_char(59940502744006894 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>59940825061006894.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59940502744006894.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Grafico HTML<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:SIMPLE_CHART"><img src="#IMAGE_PREFIX#wwv_example_chart.gif" alt="Grafico HTML" height="115" width="140"></a>',
  p_lov_return_value=>'SIMPLE_CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>59941005437006895.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59940502744006894.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Grafico SVG<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:SVG_CHART"><img src="#IMAGE_PREFIX#wwv_example_chart.gif" alt="Grafico SVG" height="115" width="140"></a>',
  p_lov_return_value=>'SVG_CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_region_other_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 60045522128286895.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE.REGION.OTHER.TYPES',
  p_lov_query=> '.'||to_char(60045522128286895 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5457631911497559.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>60045522128286895.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>0,
  p_lov_disp_value=>'HTML<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:STATIC_TEXT"><img src="#IMAGE_PREFIX#menu/wiz_blank_140x90.gif" height="90" width="140" alt="Crea area HTML o contenitore di form" class="htmldbGreenIcons" /></a>',
  p_lov_return_value=>'STATIC_TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>60046014746286897.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>60045522128286895.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Testo HTML (con scorciatoie)<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:STATIC_TEXT_WITH_SHORTCUTS"><img src="#IMAGE_PREFIX#menu/wiz_html_subst_140x90.gif" height="90" width="140" alt="Crea area HTML contenente scorciatoie" class="htmldbGreenIcons" /></a>',
  p_lov_return_value=>'STATIC_TEXT_WITH_SHORTCUTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>60045811036286897.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>60045522128286895.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Testo HTML (caratteri speciali di escape)<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:STATIC_TEXT_ESCAPE_SC"><img src="#IMAGE_PREFIX#menu/wiz_html_escape_140x90.gif" height="90" width="140" alt="Crea area HTML contenente caratteri speciali" class="htmldbGreenIcons" /></a>',
  p_lov_return_value=>'STATIC_TEXT_ESCAPE_SC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>60046204410286897.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>60045522128286895.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Testo della Guida<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:HELP_TEXT"><img src="#IMAGE_PREFIX#menu/wiz_blank_140x90.gif" height="90" width="140" alt="Crea area per il testo della Guida" class="htmldbGreenIcons" /></a>',
  p_lov_return_value=>'HELP_TEXT',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_region_query_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 54592118556400146.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE.REGION.QUERY.TYPES',
  p_lov_query=> '.'||to_char(54592118556400146 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>54592606233400147.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>54592118556400146.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Utilizzo di una procedura guidata',
  p_lov_return_value=>'STRUCTURED_QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>54592409388400147.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>54592118556400146.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Immettere direttamente l''istruzione SQL',
  p_lov_return_value=>'SQL_QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_region_report_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 59918611599848626.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE.REGION.REPORT.TYPES',
  p_lov_query=> '.'||to_char(59918611599848626 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>59918906003848628.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59918611599848626.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Report SQL',
  p_lov_return_value=>'SQL_QUERY',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4016:&SESSION.:::4016:P4016_SOURCE_TYPE:SQL_QUERY"><img src="#IMAGE_PREFIX#menu/wiz_classic_report_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>76763631583167906.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59918611599848626.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'Report interattivo',
  p_lov_return_value=>'DYNAMIC_QUERY',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4016:&SESSION.:::4016:P4016_SOURCE_TYPE:DYNAMIC_QUERY"><img src="#IMAGE_PREFIX#menu/wiz_interactive_report_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>32036408472068130.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59918611599848626.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Report su collection che contiene un risultato di servizio Web',
  p_lov_return_value=>'SQL_QUERY_WS',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4016:&SESSION.:::4016:P4016_SOURCE_TYPE:SQL_QUERY_WS"><img src="#IMAGE_PREFIX#menu/wiz_webservices_report_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>59919130121848629.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59918611599848626.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Report procedura guidata',
  p_lov_return_value=>'STRUCTURED_QUERY',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4016:&SESSION.:::4016:P4016_SOURCE_TYPE:STRUCTURED_QUERY"><img src="#IMAGE_PREFIX#menu/wiz_ez_report_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>60063125123354063.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59918611599848626.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Funzione PL/SQL che restituisce una query SQL',
  p_lov_return_value=>'FUNCTION_RETURNING_SQL_QUERY',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4016:&SESSION.:::4016:P4016_SOURCE_TYPE:FUNCTION_RETURNING_SQL_QUERY"><img src="#IMAGE_PREFIX#wwv_example_report.gif" height="115" width="140" alt="Create a region based on a function returning SQL query" /></a>',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_region_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 59797407819674174.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE.REGION.TYPE',
  p_lov_query=> '.'||to_char(59797407819674174 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>59797715581674175.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59797407819674174.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'HTML',
  p_lov_return_value=>'STATIC_TEXT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:182:&SESSION.::::P4016_SOURCE_TYPE:STATIC_TEXT"><img src="#IMAGE_PREFIX#menu/wiz_blank_140x90.gif" height="90" width="140" alt="HTML" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16128700870012129.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59797407819674174.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1.2,
  p_lov_disp_value=>'Più pagine HTML',
  p_lov_return_value=>'MULTIPLE_HTML',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:254:&SESSION.:CC:NO::P4016_SOURCE_TYPE:STATIC_TEXT"><img src="#IMAGE_PREFIX#menu/wiz_multiple_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>59798114152674175.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59797407819674174.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Report',
  p_lov_return_value=>'SQL_QUERY',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:183:&SESSION.::::P4016_SOURCE_TYPE:SQL_QUERY"><img src="#IMAGE_PREFIX#menu/wiz_classic_report_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25496822963244246.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59797407819674174.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3.5,
  p_lov_disp_value=>'Form',
  p_lov_return_value=>'FORM',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:362:&SESSION."><img src="#IMAGE_PREFIX#menu/wiz_form_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>59798331043674176.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59797407819674174.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Grafico',
  p_lov_return_value=>'CHART',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:693:&SESSION.::::P4016_SOURCE_TYPE:CHART"><img src="#IMAGE_PREFIX#menu/wiz_flash_chart_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>59798531129674176.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59797407819674174.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Lista',
  p_lov_return_value=>'LIST',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:LIST"><img src="#IMAGE_PREFIX#menu/wiz_list_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1 from WWV_FLOW_LISTS where flow_id = :fb_flow_id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>59798712525674176.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59797407819674174.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Indicatore di percorso',
  p_lov_return_value=>'MENU',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:MENU"><img src="#IMAGE_PREFIX#menu/wiz_menu_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1 from WWV_FLOW_MENUS where flow_id = :fb_flow_id and 1 = 2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16132517193045207.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59797407819674174.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6.5,
  p_lov_disp_value=>'Indicatore di percorso',
  p_lov_return_value=>'MENU_REGION_AND_MENU_OPTION',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:263:&SESSION.:CC:NO:259,181,380"><img src="#IMAGE_PREFIX#menu/wiz_menu_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1 from WWV_FLOW_MENUS where flow_id = :fb_flow_id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>59798906900674177.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59797407819674174.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Contenuto dinamico PL/SQL',
  p_lov_return_value=>'PLSQL_PROCEDURE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:PLSQL_PROCEDURE"><img src="#IMAGE_PREFIX#menu/wiz_plsql_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5427307791424375.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59797407819674174.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Struttura',
  p_lov_return_value=>'TREE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:TREE"><img src="#IMAGE_PREFIX#menu/wiz_tree_140x90.gif" height="90" width="140" class="htmldbGreenIcons" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5429217488427188.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59797407819674174.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'URL',
  p_lov_return_value=>'URL',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:URL"><img src="#IMAGE_PREFIX#menu/wiz_url_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5431825453429446.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59797407819674174.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Risultato servizio Web',
  p_lov_return_value=>'WEB_SERVICE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:WEB_SERVICE"><img src="#IMAGE_PREFIX#menu/wiz_webservices_report_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcon" /></a>',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16271616260345715.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59797407819674174.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'Calendario',
  p_lov_return_value=>'CALENDAR',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:2001:&SESSION.::NO:2001,2002,2003,2004,2005,2006:P4016_SOURCE_TYPE:CALENDAR"><img src="#IMAGE_PREFIX#menu/wiz_calendar_140x90.gif" height="90" width="140" class="htmldbGreenIcons" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>38870528920787636.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59797407819674174.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>13,
  p_lov_disp_value=>'Testo Guida',
  p_lov_return_value=>'HELP_TEXT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:HELP_TEXT"><img src="#IMAGE_PREFIX#menu/wiz_help_140x90.gif" height="90" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons"/></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_tabs
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84948109242907300.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE.TABS',
  p_lov_query=> '.'||to_char(84948109242907300 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84948313600907300.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84948109242907300.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Nessuna scheda',
  p_lov_return_value=>'NO_TABS',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4013:&SESSION.::::F4000_P4012_CREATE_TABS:NO_TABS"><img src="#IMAGE_PREFIX#htmldb/icons/tab_none_preview.gif" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcon" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84948509310907301.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84948109242907300.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Un livello di schede',
  p_lov_return_value=>'SINGLE_LEVEL_TABS',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4013:&SESSION.::::F4000_P4012_CREATE_TABS:SINGLE_LEVEL_TABS"><img src="#IMAGE_PREFIX#htmldb/icons/tab_1_preview.gif" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcon" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84948706961907301.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84948109242907300.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Due livelli di schede',
  p_lov_return_value=>'TWO_LEVEL_TABS',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:104:&SESSION.::::F4000_P4012_CREATE_TABS:TWO_LEVEL_TABS"><img src="#IMAGE_PREFIX#htmldb/icons/tab_2_preview.gif" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcon"/></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_template_opts
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88108326304250090.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE.TEMPLATE.OPTS',
  p_lov_query=> '.'||to_char(88108326304250090 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88108531928250090.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>88108326304250090.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Scegliere una voce dal repository di &PRODUCT_NAME..',
  p_lov_return_value=>'DEFAULT',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_disp_cond=> '161',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88108720351250091.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>88108326304250090.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Completamente nuovo/a',
  p_lov_return_value=>'BLANK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88108928823250091.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>88108326304250090.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Come copia di un modello esistente',
  p_lov_return_value=>'COPY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_app_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 238931611476537918.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE_APP_OPTIONS',
  p_lov_query=> '.'||to_char(238931611476537918 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>238931830914537923.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>238931611476537918.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Completamente nuova',
  p_lov_return_value=>'SCRATCH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>238932009935537927.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>238931611476537918.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Basata su un modello di progettazione di applicazione esistente',
  p_lov_return_value=>'MODEL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_button_loc
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84893616038549667.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE_BUTTON_LOC',
  p_lov_query=> '.'||to_char(84893616038549667 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84894000323549667.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84893616038549667.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Crea un pulsante in una posizione dell''area',
  p_lov_return_value=>'REGION',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4731:&SESSION.::::P379_WHERE:REGION"><img src="#IMAGE_PREFIX#htmldb/icons/button_create_in_position_xl.gif" class="htmldbGreenIcon" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84893831137549667.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84893616038549667.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Crea un pulsante visualizzato tra gli elementi di questa pagina',
  p_lov_return_value=>'ITEM',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4062:&SESSION.::::P379_WHERE:ITEM"><img src="#IMAGE_PREFIX#htmldb/icons/button_create_with_items_xl.gif" class="htmldbGreenIcon" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_edit_build_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84363508688675017.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE_EDIT_BUILD_OPTIONS',
  p_lov_query=> '.'||to_char(84363508688675017 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84363715344675017.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84363508688675017.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Tutte le opzioni',
  p_lov_return_value=>'ALL_OPTIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84363903362675018.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84363508688675017.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Opzioni escluse',
  p_lov_return_value=>'EXCLUDED_OPTIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84364127083675018.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84363508688675017.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Opzioni incluse',
  p_lov_return_value=>'INCLUDED_OPTIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/css_categories
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 2672426264055159.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CSS CATEGORIES',
  p_lov_query=> '.'||to_char(2672426264055159 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2672601779055159.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2672426264055159.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Dimensioni assolute',
  p_lov_return_value=>'ABSOLUTE SIZES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2672821707055159.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2672426264055159.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Dimensioni relative',
  p_lov_return_value=>'RELATIVE SIZES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2686105588181625.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2672426264055159.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Tag di ancoraggio',
  p_lov_return_value=>'ANCHOR TAGS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/customizable_opts
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84780904844988257.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CUSTOMIZABLE_OPTS',
  p_lov_query=> '.'||to_char(84780904844988257 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84781129653988258.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84780904844988257.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzabile e non visualizzato per impostazione predefinita',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84781315535988258.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84780904844988257.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Personalizzabile e visualizzato per impostazione predefinita',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84781523668988259.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84780904844988257.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Non personalizzabile dagli utenti finali',
  p_lov_return_value=>'0',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/database_action_button_lov
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 147433904650386326.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DATABASE_ACTION BUTTON LOV',
  p_lov_query=> '.'||to_char(147433904650386326 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>147434227021386334.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>147433904650386326.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Azione SQL INSERT',
  p_lov_return_value=>'INSERT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>147434419098386340.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>147433904650386326.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Azione SQL UPDATE',
  p_lov_return_value=>'UPDATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>147434607832386340.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>147433904650386326.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Azione SQL DELETE',
  p_lov_return_value=>'DELETE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/days_of_the_week
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 185376216434149048.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DAYS OF THE WEEK',
  p_lov_query=> 'select d,r from ('||chr(10)||
'   select to_char(to_date(''19721105'',''YYYYMMDD''),''Day'') d,19721105 r from dual'||chr(10)||
'   union all'||chr(10)||
'   select to_char(to_date(''19721106'',''YYYYMMDD''),''Day''),19721106 from dual'||chr(10)||
'   union all'||chr(10)||
'   select to_char(to_date(''19721107'',''YYYYMMDD''),''Day''),19721107 from dual'||chr(10)||
'   union all'||chr(10)||
'   select to_char(to_date(''19721108'',''YYYYMMDD''),''Day''),19721108 from dual'||chr(10)||
'   union all'||chr(10)||
'   select to_char(to_date(''19721109'',''YYYYMMDD''),''Day''),19721109 from dual'||chr(10)||
'   union all'||chr(10)||
'   select to_char(to_date(''19721110'',''YYYYMMDD''),''Day''),19721110 from dual'||chr(10)||
'   union all'||chr(10)||
'   select to_char(to_date(''19721111'',''YYYYMMDD''),''Day''),19721111 from dual'||chr(10)||
')'||chr(10)||
'order by 2 ');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/db_column_items
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 156839505926131127.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DB.COLUMN.ITEMS',
  p_lov_query=> 'select name a,name b'||chr(10)||
''||chr(10)||
'from wwv_flow_step_items'||chr(10)||
''||chr(10)||
'where flow_id = :fb_flow_id'||chr(10)||
''||chr(10)||
'and flow_step_id = :FB_FLOW_PAGE_ID'||chr(10)||
''||chr(10)||
'and security_group_id = :flow_security_group_id'||chr(10)||
''||chr(10)||
'and source_type = ''DB_COLUMN''');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/default_label_template
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86599214413258437.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DEFAULT_LABEL_TEMPLATE',
  p_lov_query=> 'select d,r from'||chr(10)||
'    (select initcap(wwv_flow_lang.system_message(''ALL_THEMES'')) d,0 r,1 ob from dual'||chr(10)||
'      union'||chr(10)||
'     select name d,id r,2 ob from wwv_flow_template_themes$ t'||chr(10)||
'      where name is not null'||chr(10)||
'        and exists (select null'||chr(10)||
'                      FROM WWV_FLOW_TEMPLATES$'||chr(10)||
'                     WHERE template_type = ''Field'''||chr(10)||
'                       and theme = t.id))'||chr(10)||
'order by ob');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/deinstall_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 17717826931614902.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DEINSTALL OPTIONS',
  p_lov_query=> '.'||to_char(17717826931614902 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17718426349614906.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17717826931614902.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Nessuna azione',
  p_lov_return_value=>'NOT_ACCEPTED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>37670813248983399.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17717826931614902.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Elimina definizione di applicazione',
  p_lov_return_value=>'DROP_APP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17718232517614906.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17717826931614902.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Elimina oggetti di database',
  p_lov_return_value=>'DROP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17718011536614905.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17717826931614902.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Elimina oggetti di database e definizione di applicazione',
  p_lov_return_value=>'DROP_AND_DELETE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/delete_application_actions
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 15857613201776764.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DELETE APPLICATION ACTIONS',
  p_lov_query=> '.'||to_char(15857613201776764 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15857829844776765.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15857613201776764.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Esegui script di disinstallazione applicazione (consigliato)',
  p_lov_return_value=>'SCRIPT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15858025445776766.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15857613201776764.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Elimina definizione di applicazione',
  p_lov_return_value=>'DEL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/delete_corresponding_list_entries
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 139182915633902523.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DELETE CORRESPONDING LIST ENTRIES',
  p_lov_query=> '.'||to_char(139182915633902523 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>139183129828902528.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>139182915633902523.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Si -- Elimina voci di lista corrispondenti',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>139183303567902531.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>139182915633902523.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'No - Non eliminare voci di lista corrispondenti',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/delete_assoc_tabs
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84243720472403985.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DELETE_ASSOC_TABS',
  p_lov_query=> '.'||to_char(84243720472403985 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84243909960403986.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84243720472403985.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'No - Non eliminare schede corrispondenti',
  p_lov_return_value=>'NO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84244120450403986.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84243720472403985.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Sì - Elimina tutte le schede associate',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/deployment_build_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 19372012243626156.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DEPLOYMENT BUILD OPTIONS',
  p_lov_query=> 'select patch_name||'' (''||wwv_flow_lang.system_message(patch_status)||'')'' d, id r '||chr(10)||
'  from wwv_flow_patches '||chr(10)||
' where flow_id = :FB_FLOW_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/deployment_license_acceptance
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 110337521891120166.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DEPLOYMENT LICENSE ACCEPTANCE',
  p_lov_query=> '.'||to_char(110337521891120166 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>110337709187120166.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>110337521891120166.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Accetto',
  p_lov_return_value=>'ACCEPTED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>110337913130120172.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>110337521891120166.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Non accetto',
  p_lov_return_value=>'NOT_ACCEPTED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/developers_with_comments
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 125707019629972839.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DEVELOPERS WITH COMMENTS',
  p_lov_query=> 'select distinct created_by d, created_by r from wwv_flow_app_comments where flow_id = :fb_flow_id order by upper(created_by)');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/display_3d_graph_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88110219855257765.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DISPLAY.3D.GRAPH.Y',
  p_lov_query=> '.'||to_char(88110219855257765 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88110415537257766.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>88110219855257765.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Visualizza grafico 3D',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_assign_columns
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 90217012922049145.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_ASSIGN_COLUMNS',
  p_lov_query=> 'select display_value, return_value'||chr(10)||
'from ('||chr(10)||
'select htf.escape_sc(column_label)||'||chr(10)||
'       decode(group_id,'||chr(10)||
'       null,'||chr(10)||
'       '' (''||wwv_flow_lang.system_message(''UNASSIGNED'')||'')'','||chr(10)||
'       '' (''||(select name from wwv_flow_worksheet_col_groups where id = c.group_id)||'')'') display_value,'||chr(10)||
'       id return_value '||chr(10)||
'from wwv_flow_worksheet_columns c'||chr(10)||
'where worksheet_id = :P694_WORKSHEET_ID and'||chr(10)||
'  (nvl(:P694_SHOW,''ALL'') = ''ALL'' '||chr(10)||
'   or ((:P694_SHOW = ''UNASSIGNED'' and group_id is null) or group_id = :P694_ID))'||chr(10)||
'order by display_order, upper(column_label)'||chr(10)||
') x');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_column_default_when
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 89803912916156290.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_COLUMN_DEFAULT_WHEN',
  p_lov_query=> '.'||to_char(89803912916156290 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89804223419156291.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89803912916156290.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Se si creano o aggiornano righe e non si specifica un valore',
  p_lov_return_value=>'WHEN_NULL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89804424514156291.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89803912916156290.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Solo se si creano nuove righe',
  p_lov_return_value=>'WHEN_INSERTING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_column_display_as
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 89659302995737201.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_COLUMN_DISPLAY_AS',
  p_lov_query=> '.'||to_char(89659302995737201 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89659609963737202.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89659302995737201.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Testo',
  p_lov_return_value=>'TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89659815445737202.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89659302995737201.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Area di testo',
  p_lov_return_value=>'TEXTAREA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89660016955737202.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89659302995737201.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Lista di selezione',
  p_lov_return_value=>'SELECTLIST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89660216614737202.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89659302995737201.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Casella di controllo',
  p_lov_return_value=>'CHECKBOX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89660408817737202.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89659302995737201.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Gruppo di scelta',
  p_lov_return_value=>'RADIOGROUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89660623694737202.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89659302995737201.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Lista di valori popup',
  p_lov_return_value=>'POPUP_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89660807145737202.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89659302995737201.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Selettore data',
  p_lov_return_value=>'DATE_PICKER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91763620157675821.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89659302995737201.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Sola lettura',
  p_lov_return_value=>'READONLY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_column_formats
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 89748026188018212.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_COLUMN_FORMATS',
  p_lov_query=> 'select d, r from wwv_flow_worksheet_formats order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_column_functionality
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 135655901614273908.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_COLUMN_FUNCTIONALITY',
  p_lov_query=> '.'||to_char(135655901614273908 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>135656201051273908.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>135655901614273908.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Ordina',
  p_lov_return_value=>'SORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>135656409479273908.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>135655901614273908.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Filtra',
  p_lov_return_value=>'FILTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>135656630770273909.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>135655901614273908.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Interruzione di controllo',
  p_lov_return_value=>'BREAK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>135656816892273909.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>135655901614273908.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Aggrega',
  p_lov_return_value=>'AGGREGATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>135657009007273909.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>135655901614273908.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Calcola',
  p_lov_return_value=>'COMPUTE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>135657212463273909.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>135655901614273908.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Grafico',
  p_lov_return_value=>'CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_column_groups
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 89653630129678764.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_COLUMN_GROUPS',
  p_lov_query=> 'select sys.htf.escape_sc(name) d, id r '||chr(10)||
'from wwv_flow_worksheet_col_groups'||chr(10)||
'where worksheet_id = :P687_WORKSHEET_ID'||chr(10)||
'order by upper(name)');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_column_group_show
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 90206330144997352.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_COLUMN_GROUP_SHOW',
  p_lov_query=> '.'||to_char(90206330144997352 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>90206602571997357.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>90206330144997352.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Tutte le colonne',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>90206830794997359.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>90206330144997352.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Colonne non assegnate',
  p_lov_return_value=>'UNASSIGNED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_column_lov_from
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 89795021349092520.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_COLUMN_LOV_FROM',
  p_lov_query=> '.'||to_char(89795021349092520 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89795329939092520.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89795021349092520.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Valori delle singole colonne',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89795515067092520.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89795021349092520.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Dominio statico di valori',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_column_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 89661604165746991.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_COLUMN_TYPES',
  p_lov_query=> '.'||to_char(89661604165746991 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89661921597746991.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89661604165746991.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Stringa	',
  p_lov_return_value=>'STRING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89662130353746991.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89661604165746991.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Numero',
  p_lov_return_value=>'NUMBER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89662330603746991.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89661604165746991.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Data',
  p_lov_return_value=>'DATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89662503487746992.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89661604165746991.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Documento',
  p_lov_return_value=>'DOCUMENT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89662722742746992.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89661604165746991.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Calcolato',
  p_lov_return_value=>'COMPUTED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91733204209169832.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89661604165746991.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Collegamento Detail',
  p_lov_return_value=>'DETAIL_LINK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_detail_page_functionality
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 93896321430905901.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_DETAIL_PAGE_FUNCTIONALITY',
  p_lov_query=> '.'||to_char(93896321430905901 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93896600582905901.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93896321430905901.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Consenti l''esclusione dei valori nulli',
  p_lov_return_value=>'EXCLUDE_NULL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93896828769905901.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93896321430905901.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Consenti colonne visualizzate',
  p_lov_return_value=>'HIDE_EXTR_COL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_display_in_def_rpt
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 94105402933265699.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_DISPLAY_IN_DEF_RPT',
  p_lov_query=> '.'||to_char(94105402933265699 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94105722376265699.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94105402933265699.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Visualizza in report predefinito',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_display_text_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 113775430732356381.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_DISPLAY_TEXT_TYPES',
  p_lov_query=> '.'||to_char(113775430732356381 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113775715473356384.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>113775430732356381.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Colonna di report standard',
  p_lov_return_value=>'WITHOUT_MODIFICATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113776305444356385.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>113775430732356381.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Visualizzazione testo (caratteri speciali di escape)',
  p_lov_return_value=>'ESCAPE_SC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>135238030911430173.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>113775430732356381.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Nascosto',
  p_lov_return_value=>'HIDDEN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_download_format
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 91727320467023155.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_DOWNLOAD_FORMAT',
  p_lov_query=> '.'||to_char(91727320467023155 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91727602780023159.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>91727320467023155.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CSV',
  p_lov_return_value=>'CSV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91727810512023162.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>91727320467023155.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'XLS',
  p_lov_return_value=>'XLS',
  p_lov_disp_cond_type=>'FUNCTION_BODY',
  p_lov_disp_cond=> 'return wwv_flow_platform.get_preference( p_preference_name => ''PRINT_BIB_LICENSED'' )=''ADVANCED''',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91728030204023162.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>91727320467023155.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'PDF',
  p_lov_return_value=>'PDF',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> 'wwv_flow_platform.get_preference( p_preference_name => ''PRINT_BIB_LICENSED'' )=''STANDARD'' or'||chr(10)||
'       wwv_flow_platform.get_preference( p_preference_name => ''PRINT_BIB_LICENSED'' )=''ADVANCED''',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91728214017023162.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>91727320467023155.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'RTF',
  p_lov_return_value=>'RTF',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> 'wwv_flow_platform.get_preference( p_preference_name => ''PRINT_BIB_LICENSED'' )=''ADVANCED''',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_filter_date_range
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 113891626211903772.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_FILTER_DATE_RANGE',
  p_lov_query=> '.'||to_char(113891626211903772 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113891914381903774.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>113891626211903772.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Tutto',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113892122745903775.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>113891626211903772.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Precedente',
  p_lov_return_value=>'PAST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113892318530903775.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>113891626211903772.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Futuro',
  p_lov_return_value=>'FUTURE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_rpt_functionality
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_RPT_FUNCTIONALITY',
  p_lov_query=> '.'||to_char(93890902683872023 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93891207939872035.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Seleziona colonne',
  p_lov_return_value=>'SELECT_COLS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93891430852872035.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Filtra',
  p_lov_return_value=>'FILTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93891616940872035.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Ordina',
  p_lov_return_value=>'SORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>141674418886754015.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3.5,
  p_lov_disp_value=>'Interruzione di controllo',
  p_lov_return_value=>'BREAK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93891825853872035.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Evidenzia',
  p_lov_return_value=>'HIGHLIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93893009214872050.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4.5,
  p_lov_disp_value=>'Calcola',
  p_lov_return_value=>'COMPUTATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93892010217872035.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Aggrega',
  p_lov_return_value=>'AGGREGATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>96144107239525391.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5.5,
  p_lov_disp_value=>'Grafico',
  p_lov_return_value=>'CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93892230261872036.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Calendario',
  p_lov_return_value=>'CALENDAR',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93892430175872036.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Flashback',
  p_lov_return_value=>'FLASHBACK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93893230750872050.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7.5,
  p_lov_disp_value=>'Salva report',
  p_lov_return_value=>'RPT_SAVING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93892610127872036.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Reimposta',
  p_lov_return_value=>'RESET',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>135686220155392741.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8.5,
  p_lov_disp_value=>'Guida',
  p_lov_return_value=>'HELP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93892800927872050.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Scarica',
  p_lov_return_value=>'DOWNLOAD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93893414283872050.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93890902683872023.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>12,
  p_lov_disp_value=>'Consenti le categorie di report',
  p_lov_return_value=>'RPT_CATEGORY',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_rpt_list_mode
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 93938623554284943.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_RPT_LIST_MODE',
  p_lov_query=> '.'||to_char(93938623554284943 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93938902214284943.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93938623554284943.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sì',
  p_lov_return_value=>'TABS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131717516025931094.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93938623554284943.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'No',
  p_lov_return_value=>'NONE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_same_label_for_detail_view
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 96419205216695800.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_SAME_LABEL_FOR_DETAIL_VIEW',
  p_lov_query=> '.'||to_char(96419205216695800 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>96419521321695807.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>96419205216695800.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Usa lo stesso testo per la vista a riga singola',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_search_functionality
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 131635032236756030.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_SEARCH_FUNCTIONALITY',
  p_lov_query=> '.'||to_char(131635032236756030 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131635314260756031.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131635032236756030.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Campo di ricerca',
  p_lov_return_value=>'SEARCH_TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131635716026756031.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131635032236756030.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Elenco a discesa strumento di ricerca',
  p_lov_return_value=>'FINDER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131635520752756031.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131635032236756030.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Selettore righe per pagina',
  p_lov_return_value=>'ROW_CNT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>135033300784021288.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131635032236756030.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Menu Azioni',
  p_lov_return_value=>'ACTIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_worksheet_pagination
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 89240132490172141.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_WORKSHEET_PAGINATION',
  p_lov_query=> '.'||to_char(89240132490172141 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89240414406172201.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89240132490172141.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Intervalli di righe da X a Y di Z',
  p_lov_return_value=>'ROWS_X_TO_Y_OF_Z',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89240620434172201.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89240132490172141.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Intervalli di righe da X a Y',
  p_lov_return_value=>'ROWS_X_TO_Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dq_worksheet_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 89234523991056148.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DQ_WORKSHEET_STATUS',
  p_lov_query=> '.'||to_char(89234523991056148 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89234802427056220.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89234523991056148.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Disponibile per il proprietario',
  p_lov_return_value=>'AVAILABLE_FOR_OWNER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89235015173056220.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89234523991056148.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Non disponibile',
  p_lov_return_value=>'NOT_AVAILABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89235209196056220.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89234523991056148.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Disponibile',
  p_lov_return_value=>'AVAILABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89235410026056220.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>89234523991056148.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Lista di controllo dell''accesso',
  p_lov_return_value=>'ACL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dynamic_theme_list
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 317672930832099392.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DYNAMIC_THEME_LIST',
  p_lov_query=> ''||chr(10)||
'select wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''<br/><a href="f?p=4000:&THEME_NEXT_PAGE.:&SESSION.::::THEME_ID:''||t.theme_id||''"><img src="#IMAGE_PREFIX#themes/theme_''||t.theme_id||''/themeshot.png" alt="''||wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''" title="''||wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''" width="150" height="80" class="htmldbthemeshots" /></a>'' display_value, t.theme_id '||chr(10)||
'from ('||chr(10)||
'    select substr(object_name,16) theme_id '||chr(10)||
'    from   user_objects '||chr(10)||
'    where  object_name like ''WWV_FLOW_THEME_%'''||chr(10)||
'    and    object_type = ''PACKAGE'''||chr(10)||
'    and    substr(object_name,16) in ('||chr(10)||
'        ''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'',''9'',''10'','||chr(10)||
'        ''11'',''12'',''13'',''14'',''15'',''16'',''17'',''18'',''19'',''20'','||chr(10)||
'        ''21'',''22'',''23'',''24'',''25'',''26'',''27'',''28'',''29'',''30'','||chr(10)||
'        ''31'',''32'',''33'',''34'',''35'',''36'',''37'',''38'',''39'',''40'','||chr(10)||
'        ''41'',''42'',''43'',''44'',''45'',''46'',''47'',''48'',''49'',''50'','||chr(10)||
'        ''51'',''52'',''53'',''54'',''55'',''56'',''57'',''58'',''59'',''60'','||chr(10)||
'        ''61'',''62'',''63'',''64'',''65'',''66'',''67'',''68'',''69'',''70'','||chr(10)||
'        ''71'',''72'',''73'',''74'',''75'',''76'',''77'',''78'',''79'',''80'','||chr(10)||
'        ''81'',''82'',''83'',''84'',''85'',''86'',''87'',''88'',''89'',''90'','||chr(10)||
'        ''91'',''92'',''93'',''94'',''95'',''96'',''97'',''98'',''99'',''100'''||chr(10)||
'    )'||chr(10)||
') t'||chr(10)||
'where t.theme_id not in (select theme_id from wwv_flow_themes where flow_id = :fb_flow_id) '||chr(10)||
'order by to_number(t.theme_id)'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/enabled_disabled_returns_y_or_n
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 91439803955181562.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ENABLED_DISABLED_RETURNS_Y_OR_N',
  p_lov_query=> '.'||to_char(91439803955181562 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91440204684181564.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>91439803955181562.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Disabilitato',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91440020513181563.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>91439803955181562.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Abilitato',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/enable_csv_export
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 113206414430374390.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ENABLE_CSV_EXPORT',
  p_lov_query=> '.'||to_char(113206414430374390 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113206730666374392.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>113206414430374390.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Abilita output CSV',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/enable_disable
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84865108269386627.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ENABLE_DISABLE',
  p_lov_query=> '.'||to_char(84865108269386627 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84865322430386628.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84865108269386627.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Disabilita',
  p_lov_return_value=>'DISABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84865528406386628.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84865108269386627.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Abilita',
  p_lov_return_value=>'ENABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/error_display_location
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 175855211406623797.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ERROR_DISPLAY_LOCATION',
  p_lov_query=> '.'||to_char(175855211406623797 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>175855515052623815.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>175855211406623797.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'In linea con campo e nella notifica',
  p_lov_return_value=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>175855711259623816.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>175855211406623797.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'In linea con campo',
  p_lov_return_value=>'INLINE_WITH_FIELD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>175855923896623816.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>175855211406623797.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'In linea nella notifica',
  p_lov_return_value=>'INLINE_IN_NOTIFICATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>175856114844623817.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>175855211406623797.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'In caso di pagina di errore',
  p_lov_return_value=>'ON_ERROR_PAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/exact_match
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 165376410332055484.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'EXACT_MATCH',
  p_lov_query=> '.'||to_char(165376410332055484 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>165376716320055488.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>165376410332055484.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'corrispondenza esatta',
  p_lov_return_value=>'y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/exact_subs_y_n
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84908521896674445.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'EXACT_SUBS_Y_N',
  p_lov_query=> '.'||to_char(84908521896674445 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84908724352674446.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84908521896674445.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'No - Esegui anche sostituzioni non esatte',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84908932193674446.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84908521896674445.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Sì - Esegui solo sostituzioni esatte',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/export_component_application_attributes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'EXPORT COMPONENT APPLICATION ATTRIBUTES',
  p_lov_query=> '.'||to_char(201561021137913944 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201561202964913947.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Attributo applicazione: Modello di pagina predefinito',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201561427317913952.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Attributo applicazione: Logo',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201561612262913952.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Attributo applicazione: URL di logout',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201561802624913952.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Attributo applicazione: Notifica globale',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201562020313913952.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Attributo applicazione: Autenticazione',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201589706900307265.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Attributo applicazione: Collegamento Home',
  p_lov_return_value=>'6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201590720753311215.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Attributo applicazione: Prefisso immagine',
  p_lov_return_value=>'7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201591029064313600.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'Attributo applicazione: Log (Sì o No)',
  p_lov_return_value=>'8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201591602183315334.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'Attributo applicazione: Proprietario applicazione',
  p_lov_return_value=>'9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201592417767319814.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'Attributo applicazione: Stringhe di sostituzione statiche',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201603224693321841.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'Attributo applicazione: Stato e messaggio applicazione',
  p_lov_return_value=>'11',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>201604303007325019.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'Attributo applicazione: Abilita debug (Sì o No)',
  p_lov_return_value=>'12',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>204137731018130907.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'Attributo applicazione: Nome applicazione',
  p_lov_return_value=>'13',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>204138001713131913.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>140,
  p_lov_disp_value=>'Attributo applicazione: Alias di applicazione',
  p_lov_return_value=>'14',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>204138307946133739.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>150,
  p_lov_disp_value=>'Attributo applicazione: Modalità stringhe di sostituzione esatte',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>204139019721137188.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>160,
  p_lov_disp_value=>'Attributo applicazione: Schema di sicurezza',
  p_lov_return_value=>'16',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>204139423184138143.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>170,
  p_lov_disp_value=>'Attributo applicazione: Server proxy',
  p_lov_return_value=>'17',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>204140027339139375.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>180,
  p_lov_disp_value=>'Attributo applicazione: Protezione pagina',
  p_lov_return_value=>'18',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>204140631495140521.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>201561021137913944.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>190,
  p_lov_disp_value=>'Attributo applicazione: VPD (Virtual Private Database)',
  p_lov_return_value=>'19',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/export_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 45348605156549399.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'EXPORT.OPTIONS',
  p_lov_query=> '.'||to_char(45348605156549399 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>45349208290549436.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>45348605156549399.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>0,
  p_lov_disp_value=>'Importa',
  p_lov_return_value=>'IMPORT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:460:&SESSION.:::460"><img src="#IMAGE_PREFIX#htmldb/builder/import.gif" width="100" height="75" alt="#DISPLAY_VALUE#" class="htmldbGreenIcon" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>45349021845549425.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>45348605156549399.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Esporta',
  p_lov_return_value=>'EXPORT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4900:&SESSION."><img src="#IMAGE_PREFIX#htmldb/builder/export.gif" width="100" height="75" alt="#DISPLAY_VALUE#" class="htmldbGreenIcon" /></a>',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1 from wwv_flows where security_group_id = :flow_security_group_id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1846115445438584.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>45348605156549399.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Esporta',
  p_lov_return_value=>'EXPORT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:76:&SESSION."><img src="#IMAGE_PREFIX#htmldb/builder/export.gif" width="100" height="75" alt="#DISPLAY_VALUE#" class="htmldbGreenIcon" /></a>',
  p_lov_disp_cond_type=>'NOT_EXISTS',
  p_lov_disp_cond=> 'select 1 from wwv_flows where security_group_id = :flow_security_group_id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/export_targets_no_xml
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 43935029932609535.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'EXPORT.TARGETS.no.xml',
  p_lov_query=> '.'||to_char(43935029932609535 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43935319566609536.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43935029932609535.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'UNIX',
  p_lov_return_value=>'UNIX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43935500793609538.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43935029932609535.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'DOS',
  p_lov_return_value=>'DOS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>107236303690563927.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43935029932609535.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Database',
  p_lov_return_value=>'DB',
  p_lov_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION',
  p_lov_disp_cond=> '4900',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/export_file_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84829617133304005.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'EXPORT_FILE_TYPES',
  p_lov_query=> '.'||to_char(84829617133304005 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84829803958304006.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84829617133304005.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Esportazione applicazione, pagina o componente',
  p_lov_return_value=>'FLOW_EXPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84830010423304006.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84829617133304005.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Esportazione CSS',
  p_lov_return_value=>'CSS_EXPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84830213403304006.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84829617133304005.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Esportazione immagine',
  p_lov_return_value=>'IMAGE_EXPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84830422156304006.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84829617133304005.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Esportazione file',
  p_lov_return_value=>'FILE_EXPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84830627988304007.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84829617133304005.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Esportazione file di script',
  p_lov_return_value=>'SCRIPT_FILE_EXPORT',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>141375217080001896.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84829617133304005.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Esportazione tema',
  p_lov_return_value=>'THEME',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>158557719334534776.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84829617133304005.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Valori predefiniti interfaccia utente',
  p_lov_return_value=>'UI_DEFAULTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/export_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84313028848586180.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'EXPORT_TYPES',
  p_lov_query=> '.'||to_char(84313028848586180 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84313210243586181.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84313028848586180.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Aree di lavoro',
  p_lov_return_value=>'COMPANY_EXPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84313400691586181.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84313028848586180.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Applicazioni',
  p_lov_return_value=>'FLOW_EXPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84313629140586181.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84313028848586180.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Pagine',
  p_lov_return_value=>'PAGE_EXPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84313822161586182.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84313028848586180.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'CSS',
  p_lov_return_value=>'CSS_EXPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84314021666586182.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84313028848586180.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Immagini',
  p_lov_return_value=>'IMAGE_EXPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84314231797586182.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84313028848586180.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'File',
  p_lov_return_value=>'FILE_EXPORT',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84314413534586182.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84313028848586180.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Script',
  p_lov_return_value=>'SCRIPT_FILE_EXPORT',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>218848421565947069.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84313028848586180.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>75,
  p_lov_disp_value=>'Esportazione file statico',
  p_lov_return_value=>'FILE_EXPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>217881026720006951.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84313028848586180.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'Temi',
  p_lov_return_value=>'THEME',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>217881302263009316.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84313028848586180.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'Valori predefiniti interfaccia utente',
  p_lov_return_value=>'UI_DEFAULTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/f4000_pt0x
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 104345318793564176.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'F4000_PT0X',
  p_lov_query=> 'select :F4000_PTN1 d, 1 r from dual '||chr(10)||
'where  :F4000_PTN1 is not null'||chr(10)||
'union all'||chr(10)||
'select :F4000_PTN2 d, 2 r from dual'||chr(10)||
'where  :F4000_PTN2 is not null'||chr(10)||
'union all'||chr(10)||
'select :F4000_PTN3 d, 3 r from dual'||chr(10)||
'where  :F4000_PTN3 is not null'||chr(10)||
'union all'||chr(10)||
'select :F4000_PTN4 d, 4 r from dual'||chr(10)||
'where  :F4000_PTN4 is not null'||chr(10)||
'order by 2');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/fieldtemplate
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 93450900806779850.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FIELDTEMPLATE',
  p_lov_query=> 'select htf.escape_sc(template_name) d, id'||chr(10)||
'from   wwv_flow_field_templates'||chr(10)||
'where  flow_id = :fb_flow_id and '||chr(10)||
'       (:fb_theme_id is null or theme_id = :fb_theme_id)'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/field_alignment
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84354125395660958.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FIELD_ALIGNMENT',
  p_lov_query=> '.'||to_char(84354125395660958 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84354312984660959.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84354125395660958.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Al centro',
  p_lov_return_value=>'CENTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84354513344660959.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84354125395660958.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Centrato in basso',
  p_lov_return_value=>'CENTER-BOTTOM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84354712797660959.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84354125395660958.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Centrato al centro',
  p_lov_return_value=>'CENTER-CENTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84354917729660959.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84354125395660958.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Centrato in alto',
  p_lov_return_value=>'CENTER-TOP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84355106101660960.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84354125395660958.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'A sinistra',
  p_lov_return_value=>'LEFT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84355327264660960.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84354125395660958.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'In basso a sinistra',
  p_lov_return_value=>'LEFT-BOTTOM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84355517743660961.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84354125395660958.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Centrato a sinistra',
  p_lov_return_value=>'LEFT-CENTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84355723004660961.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84354125395660958.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'In alto a sinistra',
  p_lov_return_value=>'LEFT-TOP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84355913470660961.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84354125395660958.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'A destra',
  p_lov_return_value=>'RIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84356104865660961.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84354125395660958.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'In basso a destra',
  p_lov_return_value=>'RIGHT-BOTTOM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84356323660660962.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84354125395660958.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'Centrato a destra',
  p_lov_return_value=>'RIGHT-CENTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84356511314660962.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84354125395660958.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'In alto a destra',
  p_lov_return_value=>'RIGHT-TOP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/file_extensions
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 152392614641425297.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FILE EXTENSIONS',
  p_lov_query=> '.'||to_char(152392614641425297 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>152392917070425300.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>152392614641425297.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'gif',
  p_lov_return_value=>'gif',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>152393102499425300.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>152392614641425297.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'jpg',
  p_lov_return_value=>'jpg',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>152393306933425300.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>152392614641425297.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'png',
  p_lov_return_value=>'png',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>152393526593425301.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>152392614641425297.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'js',
  p_lov_return_value=>'js',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>152393720879425301.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>152392614641425297.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'ico',
  p_lov_return_value=>'ico',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>152393912392425301.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>152392614641425297.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'swf',
  p_lov_return_value=>'swf',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>152561112881547769.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>152392614641425297.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'css',
  p_lov_return_value=>'css',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/file_format
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84322414566600975.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FILE_FORMAT',
  p_lov_query=> '.'||to_char(84322414566600975 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84322611093600976.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84322414566600975.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'DOS',
  p_lov_return_value=>'DOS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84322801136600976.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84322414566600975.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'UNIX',
  p_lov_return_value=>'UNIX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/find_files_report_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 152121930169975580.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FIND FILES REPORT OPTIONS',
  p_lov_query=> '.'||to_char(152121930169975580 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>152122103854975582.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>152121930169975580.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Con contesto',
  p_lov_return_value=>'CONTEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>152122325945975584.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>152121930169975580.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Senza contesto',
  p_lov_return_value=>'NO_CONTEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/first_item
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88125512675662566.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FIRST.ITEM',
  p_lov_query=> '.'||to_char(88125512675662566 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88125727281662567.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>88125512675662566.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Primo elemento nella pagina',
  p_lov_return_value=>'AUTO_FIRST_ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88125912388662567.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>88125512675662566.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Non attivare il cursore',
  p_lov_return_value=>'NO_FIRST_ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/fk_col_source_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 61279713459133078.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FK_COL_SOURCE_TYPES',
  p_lov_query=> '.'||to_char(61279713459133078 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>61280232645133087.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>61279713459133078.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Elemento (nome elemento di applicazione o pagina)',
  p_lov_return_value=>'ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>137617420490097969.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>61279713459133078.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Espressione o funzione PL/SQL',
  p_lov_return_value=>'FUNCTION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flash_chart_animation
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 14301417754847127.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLASH_CHART_ANIMATION',
  p_lov_query=> '.'||to_char(14301417754847127 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14301727318847128.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14301417754847127.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Dissolvi',
  p_lov_return_value=>'alpha',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14301923774847128.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14301417754847127.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Scala',
  p_lov_return_value=>'size',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14376622976075685.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14301417754847127.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Nessuno',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flash_chart_background_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 26598922027232846.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLASH_CHART_BACKGROUND_TYPES',
  p_lov_query=> '.'||to_char(26598922027232846 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26599110787232851.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26598922027232846.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Trasparente',
  p_lov_return_value=>'TRANSPARENT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26599300693232858.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26598922027232846.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Tinta unita',
  p_lov_return_value=>'SOLID',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26599508945232858.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26598922027232846.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Gradiente',
  p_lov_return_value=>'GRADIENT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flash_chart_color_scheme
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 26662905273568684.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLASH_CHART_COLOR_SCHEME',
  p_lov_query=> '.'||to_char(26662905273568684 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26663207496568684.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26662905273568684.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Aspetto 1',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26663403268568684.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26662905273568684.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Aspetto 2',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26663619177568684.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26662905273568684.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Aspetto 3',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26663812226568684.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26662905273568684.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Aspetto 4',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26664000501568684.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26662905273568684.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Aspetto 5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26664227564568684.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26662905273568684.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Personalizzato',
  p_lov_return_value=>'0',
  p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION',
  p_lov_disp_cond=> '701,719',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flash_chart_grid
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 17641819698612188.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLASH_CHART_GRID',
  p_lov_query=> '.'||to_char(17641819698612188 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17642004424612190.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17641819698612188.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Nessuno',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17642410722612190.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17641819698612188.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Dietro',
  p_lov_return_value=>'BACK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17642213142612190.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17641819698612188.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Davanti',
  p_lov_return_value=>'FRONT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flash_chart_legend
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 73383804077079952.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLASH_CHART_LEGEND',
  p_lov_query=> '.'||to_char(73383804077079952 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>73384226151079954.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>73383804077079952.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Nessuno',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>73384020039079953.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>73383804077079952.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'A sinistra',
  p_lov_return_value=>'LEFT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>73384403858079954.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>73383804077079952.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'A destra',
  p_lov_return_value=>'RIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flash_chart_query_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6026412205740110.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLASH_CHART_QUERY_TYPE',
  p_lov_query=> '.'||to_char(6026412205740110 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6026711255740110.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>6026412205740110.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Query SQL',
  p_lov_return_value=>'SQL_QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6026911236740110.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>6026412205740110.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Funzione che restituisce una query SQL',
  p_lov_return_value=>'FUNCTION_RETURNING_SQL_QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flash_chart_text_align
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 27511522717184384.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLASH_CHART_TEXT_ALIGN',
  p_lov_query=> '.'||to_char(27511522717184384 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27511806919184386.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>27511522717184384.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A sinistra',
  p_lov_return_value=>'left',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27512005279184386.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>27511522717184384.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Al centro',
  p_lov_return_value=>'center',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27512201733184386.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>27511522717184384.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'A destra',
  p_lov_return_value=>'right',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flash_chart_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLASH_CHART_TYPES',
  p_lov_query=> '.'||to_char(4420920063154997 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4432207081189045.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D',
  p_lov_return_value=>'2DColumn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4432514353191204.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A linee di colonne 2D',
  p_lov_return_value=>'2DColumn_Line',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4432821626193231.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Ad anello 2D',
  p_lov_return_value=>'2DDoughnut',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4433127167194920.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A linee 2D',
  p_lov_return_value=>'2DLine',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4433800286196585.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A torta 2D',
  p_lov_return_value=>'2DPie',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4434404442197781.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D',
  p_lov_return_value=>'3DColumn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4434808944199084.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A torta 3D',
  p_lov_return_value=>'3DPie',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4435614138200551.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A canne d''organo',
  p_lov_return_value=>'Candlestick',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4436218640201907.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A dispersione',
  p_lov_return_value=>'dot',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4436524874203664.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D orizzontali',
  p_lov_return_value=>'Horizontal2DColumn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4436829722205105.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D orizzontali',
  p_lov_return_value=>'Horizontal3DColumn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4437104226207210.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D con intervallo orizzontale',
  p_lov_return_value=>'HorizontalRange2DColumn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4437410114208929.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D con intervallo orizzontale',
  p_lov_return_value=>'HorizontalRange3DColumn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4437714616210214.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A linee 2D invertite',
  p_lov_return_value=>'Inverse2DLine',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4438019117211457.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D con intervallo',
  p_lov_return_value=>'Range2DColumn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4438324658213089.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D con intervallo',
  p_lov_return_value=>'Range3DColumn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4438629160214354.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D in pila',
  p_lov_return_value=>'Stacked2DColumn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4438900548215613.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D in pila',
  p_lov_return_value=>'Stacked3DColumn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4439205050216884.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D orizzontali in pila',
  p_lov_return_value=>'StackedHorizontal2DColumn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4439509898218316.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D orizzontali in pila',
  p_lov_return_value=>'StackedHorizontal3DColumn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17615911434288138.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Quadrante',
  p_lov_return_value=>'GaugeChart',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>51021920892688470.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D in pila (percentuale)',
  p_lov_return_value=>'2DSTACKED_PCT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>51024603839702422.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D in pila (percentuale)',
  p_lov_return_value=>'3DSTACKED_PCT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>51025513536705271.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D orizzontali in pila (percentuale)',
  p_lov_return_value=>'2DHSTACKED_PCT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>51027423579708183.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D orizzontali in pila (percentuale)',
  p_lov_return_value=>'3DHSTACKED_PCT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94900013373619844.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4420920063154997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Quadrante (Percentuale)',
  p_lov_return_value=>'DIAL_PCT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_process_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 179311318624565491.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW.PROCESS.TYPE',
  p_lov_query=> '.'||to_char(179311318624565491 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179311622483565552.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179311318624565491.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'In caso di caricamento: Prima dell''intestazione (intestazione del modello di pagina)',
  p_lov_return_value=>'BEFORE_HEADER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179311831825565556.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179311318624565491.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'In caso di caricamento: Dopo l''intestazione (intestazione del modello di pagina)',
  p_lov_return_value=>'AFTER_HEADER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179312200871565557.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179311318624565491.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'In caso di caricamento: Prima dell''area o delle aree "Corpo"',
  p_lov_return_value=>'BEFORE_BOX_BODY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179312423113565557.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179311318624565491.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'In caso di caricamento: Dopo l''area o le aree "Corpo"',
  p_lov_return_value=>'AFTER_BOX_BODY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179312600387565558.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179311318624565491.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'In caso di caricamento: Prima del piè di pagina (piè di pagina del modello di pagina)',
  p_lov_return_value=>'BEFORE_FOOTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179312827063565558.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179311318624565491.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'In caso di caricamento: Dopo il piè di pagina (piè di pagina del modello di pagina)',
  p_lov_return_value=>'AFTER_FOOTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>3451613729145560.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179311318624565491.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'In caso di sottomissione: Dopo la sottomissione di pagina - Prima di calcoli e convalide',
  p_lov_return_value=>'ON_SUBMIT_BEFORE_COMPUTATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179313012514565558.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179311318624565491.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'In caso di sottomissione: Dopo la sottomissione di pagina - Dopo calcoli e convalide',
  p_lov_return_value=>'AFTER_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179313403662565559.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179311318624565491.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'In caso di nuova sessione: Dopo l''autenticazione',
  p_lov_return_value=>'AFTER_AUTHENTICATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>195926500168560659.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179311318624565491.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>12,
  p_lov_disp_value=>'Su richiesta: esegue questo processo di applicazione se richiesto da un processo di pagina.',
  p_lov_return_value=>'ON_DEMAND',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flowchart_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84246225797415032.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOWCHART_OPTIONS',
  p_lov_query=> '.'||to_char(84246225797415032 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88293501517804182.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84246225797415032.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Mostra tutto',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88293722687804182.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84246225797415032.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Mostra utilizzati',
  p_lov_return_value=>'USED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_page_process_point
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 842344044.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_PAGE_PROCESS_POINT',
  p_lov_query=> '.'||to_char(842344044 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88153412020965107.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>842344044.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'In caso di nuova istanza. Dopo l''autenticazione.',
  p_lov_return_value=>'AFTER_AUTHENTICATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88153630053965109.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>842344044.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>''||chr(10)||
'In caso di caricamento: Prima dell''intestazione',
  p_lov_return_value=>'BEFORE_HEADER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88153816621965110.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>842344044.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>''||chr(10)||
'In caso di caricamento: Dopo l''intestazione',
  p_lov_return_value=>'AFTER_HEADER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88154016104965110.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>842344044.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>''||chr(10)||
'In caso di caricamento: Prima delle aree',
  p_lov_return_value=>'BEFORE_BOX_BODY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88154204450965110.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>842344044.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>''||chr(10)||
'In caso di caricamento: Dopo le aree',
  p_lov_return_value=>'AFTER_BOX_BODY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88154401617965110.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>842344044.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>''||chr(10)||
'In caso di caricamento: Prima del piè di pagina',
  p_lov_return_value=>'BEFORE_FOOTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88154630856965111.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>842344044.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>''||chr(10)||
'In caso di caricamento: Dopo il piè di pagina',
  p_lov_return_value=>'AFTER_FOOTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88154821308965111.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>842344044.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>''||chr(10)||
'In caso di sottomissione: Prima di calcoli e convalide ',
  p_lov_return_value=>'ON_SUBMIT_BEFORE_COMPUTATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88155019536965111.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>842344044.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>''||chr(10)||
'In caso di sottomissione: Dopo calcoli e convalide',
  p_lov_return_value=>'AFTER_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88155215743965111.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>842344044.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'In caso di errore: Dopo l''intestazione',
  p_lov_return_value=>'AFTER_ERROR_HEADER',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88155426385965112.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>842344044.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'In caso di errore: Prima del piè di pagina',
  p_lov_return_value=>'BEFORE_ERROR_FOOTER',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88155606076965112.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>842344044.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>''||chr(10)||
'Non valido: Prima di mostrare gli elementi di pagina',
  p_lov_return_value=>'BEFORE_SHOW_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88155822559965112.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>842344044.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>''||chr(10)||
'Non valido: Dopo aver mostrato gli elementi di pagina',
  p_lov_return_value=>'AFTER_SHOW_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_page_process_types2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_PAGE_PROCESS_TYPES2',
  p_lov_query=> '.'||to_char(173924028038191229 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5385505863234534.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Richiama valore di chiave primaria successivo o precedente',
  p_lov_return_value=>'GET_NEXT_OR_PREV_PK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>24106509225424138.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Reimposta l''impaginazione per tutte le pagine',
  p_lov_return_value=>'INITIALIZE_PAGINATION_FOR_ALL_PAGES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>24106822384427913.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Reimposta impaginazione per pagina/e (PageID,PageID,PageID)',
  p_lov_return_value=>'INITIALIZE_PAGE_PAGINATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>37703005830510688.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Svuota cache per l''applicazione corrente (rimuove tutti gli stati di sessione per l''applicazione corrente)',
  p_lov_return_value=>'CLEAR_CACHE_CURRENT_FLOW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>37703320721515055.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Svuota cache per le applicazioni (rimuove tutti gli stati di sessione per le applicazioni elencate)',
  p_lov_return_value=>'CLEAR_CACHE_FOR_FLOWS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>55952701190174406.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Aggiungi righe a form tabulare',
  p_lov_return_value=>'ADD_ROWS_TO_TABULAR_FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91224603956641545.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Servizio Web',
  p_lov_return_value=>'WEB_SERVICE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108355614250314633.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Chiudi finestra popup',
  p_lov_return_value=>'CLOSE_WINDOW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>173924310985191301.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Blocco anonimo PL/SQL',
  p_lov_return_value=>'PLSQL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>173924502801191303.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Job DBMS PL/SQL (esegue il blocco anonimo in maniera asincrona)',
  p_lov_return_value=>'PLSQL_DBMS_JOB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>173924700917191304.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Reimposta impaginazione',
  p_lov_return_value=>'RESET_PAGINATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>173924903829191304.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Svuota cache per tutti gli elementi delle pagine (PageID,PageID,PageID)',
  p_lov_return_value=>'CLEAR_CACHE_FOR_PAGES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>173925127021191304.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Svuota cache per gli elementi (ITEM,ITEM,ITEM)',
  p_lov_return_value=>'CLEAR_CACHE_FOR_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>173925314775191305.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Recupero automatico delle righe',
  p_lov_return_value=>'DML_FETCH_ROW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>173925531897191305.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Elaborazione automatica delle righe (DML)',
  p_lov_return_value=>'DML_PROCESS_ROW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>173925724656191305.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Imposta preferenza su valore dell''elemento',
  p_lov_return_value=>'SET_PREFERENCE_TO_ITEM_VALUE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>173925923660191306.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Imposta preferenza su valore dell''elemento se questo è NOT NULL (PreferenceName:ITEM)',
  p_lov_return_value=>'SET_PREFERENCE_TO_ITEM_VALUE_IF_ITEM_NOT_NULL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>173926131005191309.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Aggiornamento di più righe',
  p_lov_return_value=>'MULTI_ROW_UPDATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>173926306818191309.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Svuota cache per la sessione corrente (rimuove tutti gli stati per la sessione corrente)',
  p_lov_return_value=>'RESET_SESSION_STATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>174071729595622534.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Reimposta preferenze (rimuovi tutte le preferenze per l''utente corrente)',
  p_lov_return_value=>'RESET_USER_PREFERENCES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>195164405401312743.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Inizializza tutti gli elementi di pagina',
  p_lov_return_value=>'INITIALIZE_ALL_PAGE_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>196226115576823870.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Su richiesta: esegue un processo di applicazione "su richiesta"',
  p_lov_return_value=>'ON_DEMAND',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>31585223737231743.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>173924028038191229.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Eliminazione di più righe',
  p_lov_return_value=>'MULTI_ROW_DELETE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_subscribe_from_button_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 78596914570530945.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_SUBSCRIBE_FROM_BUTTON_TEMPLATES',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||'' -'' d, 0 r from dual union all'||chr(10)||
'select flow_id||'': ''||htf.escape_sc(template_name)||decode(theme_id,null,'''','' (''||theme_id||'')'') d, id r'||chr(10)||
'from   wwv_flow_button_templates'||chr(10)||
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in ('||chr(10)||
'select f.id'||chr(10)||
'from   wwv_flows f'||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
'     build_status != ''RUN_ONLY'' and'||chr(10)||
'     exists ('||chr(10)||
'      select 1 from wwv_flow_developers'||chr(10)||
'      where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
'       or'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
')'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_subscribe_from_cal_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 38779012258862870.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_SUBSCRIBE_FROM_CAL_TEMPLATES',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||'' -'' d, 0 r from dual'||chr(10)||
'union all'||chr(10)||
'select flow_id||'': ''||htf.escape_sc(name)||decode(theme_id,null,'''','' (''||theme_id||'')'') d, id r'||chr(10)||
'from   wwv_flow_cal_templates'||chr(10)||
'where flow_id != nvl(:fb_flow_id,0) and flow_id in ('||chr(10)||
' select f.id'||chr(10)||
' from   wwv_flows f'||chr(10)||
' where  security_group_id = :flow_security_group_id'||chr(10)||
'  and  build_status != ''RUN_ONLY'''||chr(10)||
'  and  exists ('||chr(10)||
'   select 1 '||chr(10)||
'   from wwv_flow_developers'||chr(10)||
'   where userid = :flow_user '||chr(10)||
'     and flow_id is null '||chr(10)||
'     and security_group_id = :flow_security_group_id)'||chr(10)||
'   or   exists ('||chr(10)||
'   select 1 '||chr(10)||
'   from wwv_flow_developers'||chr(10)||
'   where userid = :flow_user '||chr(10)||
'   and flow_id = f.id '||chr(10)||
'   and security_group_id = :flow_security_group_id )'||chr(10)||
')');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_subscribe_from_field_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 164770817986385686.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_SUBSCRIBE_FROM_FIELD_TEMPLATES',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
'select flow_id||'': ''||htf.escape_sc(template_name)||decode(theme_id,null,'''','' (''||theme_id||'')'') d, id r'||chr(10)||
'from   wwv_flow_field_templates'||chr(10)||
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in ('||chr(10)||
'select f.id'||chr(10)||
'from   wwv_flows f'||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
'       build_status != ''RUN_ONLY'' and'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
'       or'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
')'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_subscribe_from_item_help
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 36938013073570429.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_SUBSCRIBE_FROM_ITEM_HELP',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'lower(wwv_flow_lang.system_message(''NO_ITEM''))||'||chr(10)||
''' -''  d, 0 r from dual union all'||chr(10)||
'select i.flow_id||'': ''||htf.escape_sc(i.name) d, i.id r'||chr(10)||
'from   wwv_flow_step_items i, wwv_flow_step_item_help h'||chr(10)||
'where  i.id = h.flow_item_id'||chr(10)||
'and i.flow_id = nvl(:fb_flow_id,0) and i.flow_id in ('||chr(10)||
'select f.id'||chr(10)||
'from   wwv_flows f'||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
'       build_status != ''RUN_ONLY'' and'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
'       or'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
')'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_subscribe_from_list_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 164157520028033233.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_SUBSCRIBE_FROM_LIST_TEMPLATES',
  p_lov_query=> 'select d,r from('||chr(10)||
'select ''- ''||'||chr(10)||
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||'||chr(10)||
''' -''  d, 0 r, 1 ob'||chr(10)||
'  from dual '||chr(10)||
' union all'||chr(10)||
'select flow_id||'': ''||htf.escape_sc(list_template_name)||decode(theme_id,null,'''','' (''||theme_id||'')'') d, id r,2 ob'||chr(10)||
'  from wwv_flow_list_templates'||chr(10)||
' where flow_id != nvl(:fb_flow_id,0) and flow_id in ('||chr(10)||
'    select f.id'||chr(10)||
'      from wwv_flows f'||chr(10)||
'     where security_group_id = :FLOW_SECURITY_GROUP_ID and'||chr(10)||
'           build_status != ''RUN_ONLY'' '||chr(10)||
'       and exists ('||chr(10)||
'               select 1 '||chr(10)||
'                 from wwv_flow_developers'||chr(10)||
'                where userid = :FLOW_USER '||chr(10)||
'                  and flow_id is null '||chr(10)||
'                  and security_group_id = :FLOW_SECURITY_GROUP_ID)'||chr(10)||
'        or exists ('||chr(10)||
'               select 1 '||chr(10)||
'                 from wwv_flow_developers'||chr(10)||
'                where userid = :FLOW_USER '||chr(10)||
'                  and flow_id = f.id '||chr(10)||
'                  and security_group_id = :FLOW_SECURITY_GROUP_ID )'||chr(10)||
'))'||chr(10)||
'order by ob,d');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_subscribe_from_lovs
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 202133627659471272.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_SUBSCRIBE_FROM_LOVS',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'wwv_flow_lang.system_message(''NO_LOV'')||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
''||chr(10)||
'select flow_id||'': ''||htf.escape_sc(LOV_NAME) d, id r'||chr(10)||
''||chr(10)||
'from   wwv_flow_lists_of_values$'||chr(10)||
''||chr(10)||
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in ('||chr(10)||
''||chr(10)||
'select f.id'||chr(10)||
''||chr(10)||
'from   wwv_flows f'||chr(10)||
''||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
''||chr(10)||
'       build_status != ''RUN_ONLY'' and'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
''||chr(10)||
'       or'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
''||chr(10)||
')'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_subscribe_from_menu_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 13324505967815786.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_SUBSCRIBE_FROM_MENU_TEMPLATES',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
''||chr(10)||
'select flow_id||'': ''||htf.escape_sc(name)||decode(theme_id,null,'''','' (''||theme_id||'')'') n, id r'||chr(10)||
''||chr(10)||
'from   wwv_flow_menu_templates'||chr(10)||
''||chr(10)||
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in ('||chr(10)||
''||chr(10)||
'select f.id'||chr(10)||
''||chr(10)||
'from   wwv_flows f'||chr(10)||
''||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
''||chr(10)||
'       build_status != ''RUN_ONLY'' and'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
''||chr(10)||
'       or'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
''||chr(10)||
')'||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_subscribe_from_navbars
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 200972808971926486.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_SUBSCRIBE_FROM_NAVBARS',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'lower(wwv_flow_lang.system_message(''LAYOUT.T_NO''))||'' '' ||wwv_flow_lang.system_message(''NAVBAR'')||'||chr(10)||
'''  -'' d, 0 r from dual union all'||chr(10)||
''||chr(10)||
'select flow_id||'': ''||'||chr(10)||
''||chr(10)||
'icon_image_alt d,'||chr(10)||
''||chr(10)||
'id r'||chr(10)||
''||chr(10)||
'from   wwv_flow_icon_bar'||chr(10)||
''||chr(10)||
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in ('||chr(10)||
''||chr(10)||
'select f.id'||chr(10)||
''||chr(10)||
'from   wwv_flows f'||chr(10)||
''||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
''||chr(10)||
'       build_status != ''RUN_ONLY'' and'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
''||chr(10)||
'       or'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
''||chr(10)||
')'||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_subscribe_from_page_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 162657018721377376.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_SUBSCRIBE_FROM_PAGE_TEMPLATES',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
''||chr(10)||
'select flow_id||'': ''||htf.escape_sc(name)||decode(theme_id,null,'''','' (''||theme_id||'')'') d, id r'||chr(10)||
''||chr(10)||
'from   wwv_flow_templates'||chr(10)||
''||chr(10)||
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in ('||chr(10)||
''||chr(10)||
'select f.id'||chr(10)||
''||chr(10)||
'from   wwv_flows f'||chr(10)||
''||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
''||chr(10)||
'       build_status != ''RUN_ONLY'' and'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'       or'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
')'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_subscribe_from_popuplov_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 13178025111508374.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_SUBSCRIBE_FROM_POPUPLOV_TEMPLATES',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
''||chr(10)||
'select flow_id||'': ''||'||chr(10)||
'lower(wwv_flow_lang.system_message(''POPUP_LOV''))||'' ''||'||chr(10)||
'lower(wwv_flow_lang.system_message(''TEMPLATE''))||decode(theme_id,null,'''','' (''||theme_id||'')'') d, id r'||chr(10)||
''||chr(10)||
'from   wwv_flow_popup_lov_template'||chr(10)||
''||chr(10)||
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in ('||chr(10)||
''||chr(10)||
'select f.id'||chr(10)||
''||chr(10)||
'from   wwv_flows f'||chr(10)||
''||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
''||chr(10)||
'       build_status != ''RUN_ONLY'' and'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'       or'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
')'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_subscribe_from_region_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 164027403622318790.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_SUBSCRIBE_FROM_REGION_TEMPLATES',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
''||chr(10)||
'select flow_id||'': ''||htf.escape_sc(page_plug_template_name)||decode(theme_id,null,'''','' (''||theme_id||'')'') d, id r'||chr(10)||
''||chr(10)||
'from   wwv_flow_page_plug_templates'||chr(10)||
''||chr(10)||
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in ('||chr(10)||
''||chr(10)||
'select f.id'||chr(10)||
''||chr(10)||
'from   wwv_flows f'||chr(10)||
''||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
''||chr(10)||
'       build_status != ''RUN_ONLY'' and'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
''||chr(10)||
'       or'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
''||chr(10)||
')'||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_subscribe_from_report_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 164380503095031318.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_SUBSCRIBE_FROM_REPORT_TEMPLATES',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
''||chr(10)||
'select flow_id||'': ''||htf.escape_sc(row_template_name)||decode(theme_id,null,'''','' (''||theme_id||'')'') d, id r'||chr(10)||
''||chr(10)||
'from   wwv_flow_row_templates'||chr(10)||
''||chr(10)||
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in ('||chr(10)||
''||chr(10)||
'select f.id'||chr(10)||
''||chr(10)||
'from   wwv_flows f'||chr(10)||
''||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
''||chr(10)||
'       build_status != ''RUN_ONLY'' and'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
''||chr(10)||
'       or'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
''||chr(10)||
')'||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_subscribe_from_security_schemes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 178729613950854599.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_SUBSCRIBE_FROM_SECURITY_SCHEMES',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'wwv_flow_lang.system_message(''NO_AUTHORIZATION_SCHEME'')||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
''||chr(10)||
'select flow_id||'': ''||htf.escape_sc(name) d, id r'||chr(10)||
''||chr(10)||
'from   wwv_flow_security_schemes'||chr(10)||
''||chr(10)||
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in ('||chr(10)||
''||chr(10)||
'select f.id'||chr(10)||
''||chr(10)||
'from   wwv_flows f'||chr(10)||
''||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
''||chr(10)||
'       build_status != ''RUN_ONLY'' and'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
''||chr(10)||
'       or'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
''||chr(10)||
')'||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/flow_subscribe_from_shortcuts
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 185072604868032254.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FLOW_SUBSCRIBE_FROM_SHORTCUTS',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'wwv_flow_lang.system_message(''NO_SHORTCUT'')||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
''||chr(10)||
'select flow_id||'': ''||htf.escape_sc(shortcut_name) d, id r'||chr(10)||
''||chr(10)||
'from   wwv_flow_shortcuts'||chr(10)||
''||chr(10)||
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in ('||chr(10)||
''||chr(10)||
'select f.id'||chr(10)||
''||chr(10)||
'from   wwv_flows f'||chr(10)||
''||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
''||chr(10)||
'       build_status != ''RUN_ONLY'' and'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
''||chr(10)||
'       or'||chr(10)||
''||chr(10)||
'       exists ('||chr(10)||
''||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
''||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
''||chr(10)||
')'||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/fnd_users
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 48667231497347248.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FND_USERS',
  p_lov_query=> 'select htf.escape_sc(user_name) u, user_name r'||chr(10)||
'from wwv_flow_fnd_user'||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/format_mask
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 32743907454195192.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORMAT MASK',
  p_lov_query=> '.'||to_char(32743907454195192 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>32744227838195194.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>32743907454195192.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'$5.234,10',
  p_lov_return_value=>'FML999G999G999G999G990D00',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>32744409098195194.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>32743907454195192.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'5.234,10',
  p_lov_return_value=>'FM999G999G999G999G990',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>32744605601195195.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>32743907454195192.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'5.234,1000',
  p_lov_return_value=>'FM999G999G999G999G990D0000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>32744816704195195.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>32743907454195192.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'12-GEN-04',
  p_lov_return_value=>'DD-MON-RR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>32745005542195195.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>32743907454195192.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'12-GEN-2004',
  p_lov_return_value=>'DD-MON-YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>32745228650195198.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>32743907454195192.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'12-GEN',
  p_lov_return_value=>'DD-MON',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>32745408887195198.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>32743907454195192.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Lunedì 12 gennaio 2004',
  p_lov_return_value=>'FMDay, Month DDth YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>32745602717195199.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>32743907454195192.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'12-GEN-2004 14.30',
  p_lov_return_value=>'DD-MON-YYYY HH24:MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>102480222352871523.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>32743907454195192.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'10-GEN-2004 14.22.10',
  p_lov_return_value=>'DD-MON-YYYY HH24:MI:SS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>32745830450195199.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>32743907454195192.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'12-GEN-2004 14.30',
  p_lov_return_value=>'DD-MON-YYYY HH:MIPM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>32746002562195199.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>32743907454195192.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'Gennaio',
  p_lov_return_value=>'Month',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/format_mask_for_charts
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 100170629844530853.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORMAT.MASK.FOR.CHARTS',
  p_lov_query=> '.'||to_char(100170629844530853 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>100170923893530859.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>100170629844530853.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'$5.234,10',
  p_lov_return_value=>'FML999G999G999G999G990D00',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>100171118880530862.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>100170629844530853.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'5.234,10',
  p_lov_return_value=>'FM999,999,999,999,990.00',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>100171313816530862.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>100170629844530853.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'5.234,1000',
  p_lov_return_value=>'FM999,999,999,999,990.0000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/format_mask_for_charts_dynamic
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 44804526758842632.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORMAT.MASK.FOR.CHARTS.DYNAMIC',
  p_lov_query=> 'select to_char((5234.1),''FML999G999G999G999G990D00'') d, ''FML999G999G999G999G990D00'' r from dual'||chr(10)||
'    union all'||chr(10)||
'select trim(to_char((5234.1),''999G999G999G999G990D00'')) d, ''999G999G999G999G990D00'' r from dual'||chr(10)||
'    union all'||chr(10)||
'select trim(to_char((5234.1),''999G999G999G999G990D0000'')) d, ''999G999G999G999G990D0000'' r from dual'||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/format_mask_dynamic
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 44798420131812391.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORMAT_MASK_DYNAMIC',
  p_lov_query=> 'select d, r '||chr(10)||
'  from wwv_flow_format_masks');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/format_mask_dynamic_dates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 114314002567890312.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORMAT_MASK_DYNAMIC_DATES',
  p_lov_query=> 'select d, r '||chr(10)||
'  from wwv_flow_format_masks'||chr(10)||
' where t = ''D''');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/format_mask_dynamic_w_download
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 189097425865243903.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORMAT_MASK_DYNAMIC_W_DOWNLOAD',
  p_lov_query=> 'select d, r'||chr(10)||
'  from ('||chr(10)||
'select d, r, t'||chr(10)||
'  from wwv_flow_format_masks'||chr(10)||
'union'||chr(10)||
'select wwv_flow_lang.system_message(''DOWNLOAD'') d, ''DOWNLOAD:'' r, ''A'''||chr(10)||
'  from dual'||chr(10)||
'order by 3 desc)');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/form_item_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 276983704971116375.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORM_ITEM_TYPES',
  p_lov_query=> '.'||to_char(276983704971116375 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276983927598116379.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>276983704971116375.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Elementi di immissione dati',
  p_lov_return_value=>'FORM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276984120590116380.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>276983704971116375.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Elementi di sola visualizzazione',
  p_lov_return_value=>'DISPLAY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/form_on_sp_item_display_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 161974832535033307.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORM_ON_SP.ITEM_DISPLAY_TYPES',
  p_lov_query=> '.'||to_char(161974832535033307 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161975121396033308.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>161974832535033307.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Visualizza come testo (non salva lo stato)',
  p_lov_return_value=>'DISPLAY_ONLY_HTML',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161975324655033308.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>161974832535033307.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Nascosto',
  p_lov_return_value=>'HIDDEN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161975507223033308.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>161974832535033307.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Password',
  p_lov_return_value=>'PASSWORD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161975722167033309.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>161974832535033307.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Campo di testo',
  p_lov_return_value=>'TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161975924790033309.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>161974832535033307.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Campo di testo (disabilitato, non salva lo stato)',
  p_lov_return_value=>'TEXT_DISABLED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161976121368033309.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>161974832535033307.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Area di testo',
  p_lov_return_value=>'TEXTAREA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161976312809033309.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>161974832535033307.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Area di testo (altezza automatica)',
  p_lov_return_value=>'TEXTAREA-AUTO-HEIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161976504758033310.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>161974832535033307.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Area di testo con correzione ortografica',
  p_lov_return_value=>'TEXTAREA_WITH_SPELL_CHECK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161976700263033310.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>161974832535033307.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Selettore data',
  p_lov_return_value=>'PICK_DATE_USING_FLOW_FORMAT_MASK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/form_on_table_tables_in_schema
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 148877826000531447.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORM_ON_TABLE_TABLES_IN_SCHEMA',
  p_lov_query=> 'select table_name||'' ''||wwv_flow_lang.system_message(''TABLE_IN_PAREN'') d, table_name r'||chr(10)||
'from sys.dba_tables a'||chr(10)||
'where owner = :P453_OWNER_NAME'||chr(10)||
'and table_name not like ''BIN$%'''||chr(10)||
'and (exists (select null'||chr(10)||
' from sys.dba_tab_privs'||chr(10)||
' where grantee = (select owner'||chr(10)||
' from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID)'||chr(10)||
' and privilege = ''SELECT'''||chr(10)||
' and table_name = a.table_name'||chr(10)||
' and owner = a.owner)'||chr(10)||
'or exists (select null'||chr(10)||
' from wwv_flows'||chr(10)||
' where owner = :P453_OWNER_NAME'||chr(10)||
' and id = :FB_FLOW_ID))'||chr(10)||
'union all'||chr(10)||
'select view_name||'' ''||wwv_flow_lang.system_message(''VIEW_IN_PAREN'')  d, view_name r'||chr(10)||
'from sys.dba_views a'||chr(10)||
'where owner = :P453_OWNER_NAME'||chr(10)||
'and (exists (select null'||chr(10)||
' from sys.dba_tab_privs'||chr(10)||
' where grantee = (select owner'||chr(10)||
' from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID)'||chr(10)||
' and privilege = ''SELECT'''||chr(10)||
' and table_name = a.view_name'||chr(10)||
' and owner = a.owner)'||chr(10)||
'or exists (select null'||chr(10)||
' from wwv_flows'||chr(10)||
' where owner = :P453_OWNER_NAME'||chr(10)||
' and id = :FB_FLOW_ID))'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/form_on_tbl_wiz_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 148888732673590160.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORM_ON_TBL_WIZ_COLS',
  p_lov_query=> 'select htf.escape_sc(column_name) D,column_name R'||chr(10)||
'from   sys.dba_tab_columns'||chr(10)||
'where  owner = :P453_OWNER_NAME and'||chr(10)||
'       table_name = :F4000_P4708_TABLE_NAME'||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID) )'||chr(10)||
'order by column_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/form_pagination_tables_in_schema
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 8278125741110451.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORM_PAGINATION_TABLES_IN_SCHEMA',
  p_lov_query=> 'select table_name||'' ''||wwv_flow_lang.system_message(''TABLE_IN_PAREN'') d, table_name r'||chr(10)||
'from sys.dba_tables a'||chr(10)||
'where owner = :P165_OWNER'||chr(10)||
'and table_name not like ''BIN$%'''||chr(10)||
'and (exists (select null'||chr(10)||
' from sys.dba_tab_privs'||chr(10)||
' where grantee = (select owner'||chr(10)||
' from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID)'||chr(10)||
' and privilege = ''SELECT'''||chr(10)||
' and table_name = a.table_name'||chr(10)||
' and owner = a.owner)'||chr(10)||
'or exists (select null'||chr(10)||
' from wwv_flows'||chr(10)||
' where owner = :P165_OWNER'||chr(10)||
' and id = :FB_FLOW_ID))'||chr(10)||
'union all'||chr(10)||
'select view_name||'' ''||wwv_flow_lang.system_message(''VIEW_IN_PAREN'')  d, view_name r'||chr(10)||
'from sys.dba_views a'||chr(10)||
'where owner = :P165_OWNER'||chr(10)||
'and (exists (select null'||chr(10)||
' from sys.dba_tab_privs'||chr(10)||
' where grantee = (select owner'||chr(10)||
' from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID)'||chr(10)||
' and privilege = ''SELECT'''||chr(10)||
' and table_name = a.view_name'||chr(10)||
' and owner = a.owner)'||chr(10)||
'or exists (select null'||chr(10)||
' from wwv_flows'||chr(10)||
' where owner = :P165_OWNER'||chr(10)||
' and id = :FB_FLOW_ID))'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/form_pagination_wiz_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 8350204503198450.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORM_PAGINATION_WIZ_COLS',
  p_lov_query=> 'select htf.escape_sc(column_name) D,column_name R'||chr(10)||
'from   sys.dba_tab_columns'||chr(10)||
'where  owner = :P165_OWNER and'||chr(10)||
'       table_name = :P234_TABLE_NAME'||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID) )'||chr(10)||
'order by column_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/form_tbl_wiz_cols2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 148892218736604988.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FORM_TBL_WIZ_COLS2',
  p_lov_query=> 'select htf.escape_sc(column_name)||'' (''||initcap(data_type)||'')'' D, column_name R'||chr(10)||
'from sys.dba_tab_columns'||chr(10)||
'where  owner = :p453_owner_name and table_name = :f4000_p4708_table_name'||chr(10)||
'and column_name not in (:f4000_p4708_table_pk_column, nvl(:F4000_P4708_TABLE_PK2_COLUMN,'' ''))'||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'order by COLUMN_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/generic_report_layout
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 141528024100206812.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'GENERIC_REPORT_LAYOUT',
  p_lov_query=> '.'||to_char(141528024100206812 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>141542620899224770.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>141528024100206812.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Crea layout report basato su file',
  p_lov_return_value=>'FILE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>141528328048206813.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>141528024100206812.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Usa layout di report generico',
  p_lov_return_value=>'GENERIC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/global_session_state_security
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 109607612170295323.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'GLOBAL.SESSION.STATE.SECURITY',
  p_lov_query=> '.'||to_char(109607612170295323 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>109608209132295340.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>109607612170295323.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Disabilita',
  p_lov_return_value=>'DISABLE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:9008:&SESSION.:&DEBUG.:::P525_LEVEL:DISABLE"><img src="#IMAGE_PREFIX#htmldb/builder/edit_page.gif" height="75" width="100" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>109608009604295340.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>109607612170295323.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Abilita',
  p_lov_return_value=>'ENABLE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:9007:&SESSION.::&DEBUG.:9006:P525_LEVEL:ENABLE"><img src="#IMAGE_PREFIX#htmldb/builder/edit_page.gif" height="75" width="100" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>165639226722055203.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>109607612170295323.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Configura',
  p_lov_return_value=>'ALL',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:9006:&SESSION.::&DEBUG.:9006:P525_LEVEL:ALL"><img src="#IMAGE_PREFIX#htmldb/builder/edit_page.gif" height="75" width="100" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>'||chr(10)||
'',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/global_set_session_state_security
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 114140130498629709.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'GLOBAL.SET.SESSION.STATE.SECURITY',
  p_lov_query=> '.'||to_char(114140130498629709 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>114140303209629712.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>114140130498629709.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Abilita',
  p_lov_return_value=>'APP_ONLY',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:9007:&SESSION.::&DEBUG.:9006:P526_ACTION:APP_ONLY"><img src="#IMAGE_PREFIX#htmldb/builder/edit_page.gif" height="75" width="100" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>114140503745629714.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>114140130498629709.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Abilita e imposta',
  p_lov_return_value=>'ALL',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:9006:&SESSION.::&DEBUG.:9006:P526_ACTION:ALL"><img src="#IMAGE_PREFIX#htmldb/builder/edit_page.gif" height="75" width="100" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/group_picker
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 212924308633451870.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'GROUP PICKER',
  p_lov_query=> 'select htf.escape_sc(group_name) d, id '||chr(10)||
'from wwv_flow_page_groups '||chr(10)||
'where flow_id = :fb_flow_id order by upper(group_name)');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/hidden_or_hidden_and_protected
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 131237822858809392.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'HIDDEN OR HIDDEN AND PROTECTED',
  p_lov_query=> '.'||to_char(131237822858809392 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131238012226809394.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131237822858809392.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Nascosto e protetto',
  p_lov_return_value=>'HIDDEN_PROTECTED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131238205714809394.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131237822858809392.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Nascosto',
  p_lov_return_value=>'HIDDEN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/horizontal_n_vertical_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 148121507217144506.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'HORIZONTAL_N_VERTICAL_Y',
  p_lov_query=> '.'||to_char(148121507217144506 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>148122607695144519.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>148121507217144506.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'orizzontale',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>148123400557144527.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>148121507217144506.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'verticale',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/http_response_header
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 137613906194173724.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'HTTP_RESPONSE_HEADER',
  p_lov_query=> '.'||to_char(137613906194173724 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>137614421689173725.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>137613906194173724.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Impostazioni report',
  p_lov_return_value=>'APEX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>137614228757173725.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>137613906194173724.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Server di stampa',
  p_lov_return_value=>'SERVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/i18n_iana_charset
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'I18N_IANA_CHARSET',
  p_lov_query=> '.'||to_char(144796827445692396 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144797117419692400.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabic ISO-8859-6',
  p_lov_return_value=>'iso-8859-6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144797316057692402.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Arabic Windows 1256',
  p_lov_return_value=>'windows-1256',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144797500330692402.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Chinese Big5',
  p_lov_return_value=>'big5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144797708396692402.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Chinese GBK',
  p_lov_return_value=>'gbk',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144797916474692403.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Cyrilic ISO-8859-5',
  p_lov_return_value=>'iso-8859-5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144798131344692405.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Cyrilic KOI8-R',
  p_lov_return_value=>'koi8-r',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144798312837692405.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Cyrilic KOI8-U',
  p_lov_return_value=>'koi8-u',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144798504968692405.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'Cyrilic Windows 1251',
  p_lov_return_value=>'windows-1251',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144798718838692405.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'Eastern European ISO-8859-2',
  p_lov_return_value=>'iso-8859-2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144798932645692407.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'Eastern European Windows 1250',
  p_lov_return_value=>'windows-1250',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144799110457692407.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'Greek ISO-8859-7',
  p_lov_return_value=>'iso-8859-7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144799314923692407.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'Greek Windows 1253',
  p_lov_return_value=>'windows-1253',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144799532216692407.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'Hebrew ISO-8859-8-i',
  p_lov_return_value=>'iso-8859-8-i',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144799706409692408.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>140,
  p_lov_disp_value=>'Hebrew Windows 1255',
  p_lov_return_value=>'windows-1255',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144799927372692408.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>150,
  p_lov_disp_value=>'Japanese EUC',
  p_lov_return_value=>'euc-jp',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144800108899692408.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>160,
  p_lov_disp_value=>'Japanese Shift JIS',
  p_lov_return_value=>'shift_jis',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144800330988692408.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>170,
  p_lov_disp_value=>'Korean EUC',
  p_lov_return_value=>'euc-kr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144800519069692409.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>180,
  p_lov_disp_value=>'Northern European ISO-8859-4',
  p_lov_return_value=>'iso-8859-4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144800711990692409.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>190,
  p_lov_disp_value=>'Northern European Windows 1257',
  p_lov_return_value=>'windows-1257',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144800919398692409.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>200,
  p_lov_disp_value=>'Southern European ISO-8859-3',
  p_lov_return_value=>'iso-8859-3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144801121569692409.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>210,
  p_lov_disp_value=>'Thai TIS-620',
  p_lov_return_value=>'tis-620',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144801321138692410.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>220,
  p_lov_disp_value=>'Turkish ISO-8859-9',
  p_lov_return_value=>'iso-8859-9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144801513548692410.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>230,
  p_lov_disp_value=>'Turkish Windows 1254',
  p_lov_return_value=>'windows-1254',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144801730411692410.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>240,
  p_lov_disp_value=>'Unicode UTF-8',
  p_lov_return_value=>'utf-8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70918710617387515.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>242,
  p_lov_disp_value=>'Unicode UTF-16 Big Endian',
  p_lov_return_value=>'utf-16be',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70918917544389582.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>244,
  p_lov_disp_value=>'Unicode UTF-16 Little Endian',
  p_lov_return_value=>'utf-16le',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>69601501664557233.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>248,
  p_lov_disp_value=>'US-ASCII',
  p_lov_return_value=>'us-ascii',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144801927440692410.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>250,
  p_lov_disp_value=>'Vietnamese Windows 1258',
  p_lov_return_value=>'windows-1258',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144802114623692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>260,
  p_lov_disp_value=>'Western European ISO-8859-1',
  p_lov_return_value=>'iso-8859-1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144802329838692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144796827445692396.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>270,
  p_lov_disp_value=>'Western European Windows 1252',
  p_lov_return_value=>'windows-1252',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/i18n_iana_db_charset
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'I18N_IANA_DB_CHARSET',
  p_lov_query=> '.'||to_char(144802427115692411 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144802705132692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabic ISO-8859-6',
  p_lov_return_value=>'AR8ISO8859P6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144802901122692412.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Arabic Windows 1256',
  p_lov_return_value=>'AR8MSWIN1256',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144803127029692412.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Chinese Big5',
  p_lov_return_value=>'ZHT16MSWIN950',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144803324377692412.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Chinese GBK',
  p_lov_return_value=>'ZHS16GBK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144803513705692412.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Cyrilic ISO-8859-5',
  p_lov_return_value=>'CL8ISO8859P5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144803729051692412.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Cyrilic KOI8-R',
  p_lov_return_value=>'CL8KOI8R',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144803903575692413.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Cyrilic KOI8-U',
  p_lov_return_value=>'CL8KOI8U',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144804107518692413.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'Cyrilic Windows 1251',
  p_lov_return_value=>'CL8MSWIN1251',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144804326415692413.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'Eastern European ISO-8859-2',
  p_lov_return_value=>'EE8ISO8859P2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144804519494692413.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'Eastern European Windows 1250',
  p_lov_return_value=>'EE8MSWIN1250',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144804719388692414.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'Greek ISO-8859-7',
  p_lov_return_value=>'EL8ISO8859P7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144804930073692414.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'Greek Windows 1253',
  p_lov_return_value=>'EL8MSWIN1253',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144805102017692414.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'Hebrew ISO-8859-8-i',
  p_lov_return_value=>'IW8ISO8859P8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144805316824692414.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>140,
  p_lov_disp_value=>'Hebrew Windows 1255',
  p_lov_return_value=>'IW8MSWIN1255',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144805529478692415.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>150,
  p_lov_disp_value=>'Japanese EUC',
  p_lov_return_value=>'JA16EUC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144805708758692415.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>160,
  p_lov_disp_value=>'Japanese Shift JIS',
  p_lov_return_value=>'JA16SJIS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144805930377692415.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>170,
  p_lov_disp_value=>'Korean EUC',
  p_lov_return_value=>'KO16MSWIN949',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144806119293692416.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>180,
  p_lov_disp_value=>'Northern European ISO-8859-4',
  p_lov_return_value=>'NEE8ISO8859P4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144806300284692416.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>190,
  p_lov_disp_value=>'Northern European Windows 1257',
  p_lov_return_value=>'BLT8MSWIN1257',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144806517452692416.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>200,
  p_lov_disp_value=>'Southern European ISO-8859-3',
  p_lov_return_value=>'SE8ISO8859P3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144806722982692416.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>210,
  p_lov_disp_value=>'Thai TIS-620',
  p_lov_return_value=>'TH8TISASCII',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144806902960692420.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>220,
  p_lov_disp_value=>'Turkish ISO-8859-9',
  p_lov_return_value=>'WE8ISO8859P9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144807116856692420.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>230,
  p_lov_disp_value=>'Turkish Windows 1254',
  p_lov_return_value=>'TR8MSWIN1254',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144807330588692420.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>240,
  p_lov_disp_value=>'Unicode UTF-8',
  p_lov_return_value=>'AL32UTF8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70920103822395005.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>242,
  p_lov_disp_value=>'Unicode UTF-16 Big Endian',
  p_lov_return_value=>'AL16UTF16',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70921910056396830.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>244,
  p_lov_disp_value=>'Unicode UTF-16 Little Endian',
  p_lov_return_value=>'AL16UTF16LE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>69721018333590467.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>248,
  p_lov_disp_value=>'US-ASCII',
  p_lov_return_value=>'US7ASCII',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144807508184692421.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>250,
  p_lov_disp_value=>'Vietnamese Windows 1258',
  p_lov_return_value=>'VN8MSWIN1258',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144807715067692421.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>260,
  p_lov_disp_value=>'Western European ISO-8859-1',
  p_lov_return_value=>'WE8ISO8859P1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>144807907122692421.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>144802427115692411.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>270,
  p_lov_disp_value=>'Western European Windows 1252',
  p_lov_return_value=>'WE8MSWIN1252',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/i18n_languages_locales
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'I18N_LANGUAGES_LOCALES',
  p_lov_query=> '.'||to_char(107899321117195063 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198763720924437003.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Afrikaans (af)',
  p_lov_return_value=>'af',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198763917931437003.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (ar)',
  p_lov_return_value=>'ar',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198764111074437003.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (Algeria) (ar-dz)',
  p_lov_return_value=>'ar-dz',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198764302926437004.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (Bahrein) (ar-bh)',
  p_lov_return_value=>'ar-bh',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198764518950437004.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (Egitto) (ar-eg)',
  p_lov_return_value=>'ar-eg',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198764707881437004.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (Iraq) (ar-iq)',
  p_lov_return_value=>'ar-iq',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198764920585437004.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (Giordania) (ar-jo)',
  p_lov_return_value=>'ar-jo',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198765125710437005.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (Kuwait) (ar-kw)',
  p_lov_return_value=>'ar-kw',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198765301909437005.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (Libano) (ar-lb)',
  p_lov_return_value=>'ar-lb',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198765514908437005.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (Libia) (ar-ly)',
  p_lov_return_value=>'ar-ly',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198765710657437005.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (Marocco) (ar-ma)',
  p_lov_return_value=>'ar-ma',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198765921945437006.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (Oman) (ar-om)',
  p_lov_return_value=>'ar-om',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198766127407437006.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (Qatar) (ar-qa)',
  p_lov_return_value=>'ar-qa',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198766300363437006.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (Arabia Saudita) (ar-sa)',
  p_lov_return_value=>'ar-sa',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198766505773437006.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (Siria) (ar-sy)',
  p_lov_return_value=>'ar-sy',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198766707839437007.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (Tunisia) (ar-tn)',
  p_lov_return_value=>'ar-tn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198766917417437007.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (U.A.E.) (ar-ae)',
  p_lov_return_value=>'ar-ae',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198767112053437007.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabo (Yemen) (ar-ye)',
  p_lov_return_value=>'ar-ye',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198767312340437007.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Assamese (as)',
  p_lov_return_value=>'as',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198767522099437008.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Basco (eu)',
  p_lov_return_value=>'eu',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198767726246437008.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Bielorusso (be)',
  p_lov_return_value=>'be',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198767919601437008.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Bengali (bn)',
  p_lov_return_value=>'bn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198768103556437008.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Bulgaro (bg)',
  p_lov_return_value=>'bg',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198768313681437009.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Catalano (ca)',
  p_lov_return_value=>'ca',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198768503476437009.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Cinese (zh)',
  p_lov_return_value=>'zh',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198768717157437009.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Cinese (Cina) (zh-cn)',
  p_lov_return_value=>'zh-cn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198768915177437009.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Cinese (Hong Kong) (zh-hk)',
  p_lov_return_value=>'zh-hk',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198769104560437010.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Cinese (Macau SAR) (zh-mo)',
  p_lov_return_value=>'zh-mo',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198769309316437010.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Cinese (Singapore) (zh-sg)',
  p_lov_return_value=>'zh-sg',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198769519659437010.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Cinese (Taiwan) (zh-tw)',
  p_lov_return_value=>'zh-tw',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198769707113437011.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Croato (hr)',
  p_lov_return_value=>'hr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198769930859437011.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Ceco (cs)',
  p_lov_return_value=>'cs',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198770121194437011.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Danese (da)',
  p_lov_return_value=>'da',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198770321280437011.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Olandese (Belgio) (nl-be)',
  p_lov_return_value=>'nl-be',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198770514114437012.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Olandese (Paesi Bassi) (nl)',
  p_lov_return_value=>'nl',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198770704682437012.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Inglese (en)',
  p_lov_return_value=>'en',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198770926869437012.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Inglese (Australia) (en-au)',
  p_lov_return_value=>'en-au',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198771101039437012.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Inglese (Belize) (en-bz)',
  p_lov_return_value=>'en-bz',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198771311078437013.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Inglese (Canada) (en-ca)',
  p_lov_return_value=>'en-ca',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198771515830437013.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Inglese (Irlanda) (en-ie)',
  p_lov_return_value=>'en-ie',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198771701647437013.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Inglese (Giamaica) (en-jm)',
  p_lov_return_value=>'en-jm',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198771911421437013.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Inglese (Nuova Zelanda) (en-nz)',
  p_lov_return_value=>'en-nz',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198772116247437014.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Inglese (Filippine) (en-ph)',
  p_lov_return_value=>'en-ph',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198772303293437014.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Inglese (Sudafrica) (en-za)',
  p_lov_return_value=>'en-za',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198772506232437014.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Inglese (Trinidad) (en-tt)',
  p_lov_return_value=>'en-tt',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198772709014437014.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Inglese (Regno Unito) (en-gb)',
  p_lov_return_value=>'en-gb',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198772921663437015.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Inglese (Stati Uniti) (en-us)',
  p_lov_return_value=>'en-us',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198773103842437015.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Inglese (Zimbabwe) (en-zw)',
  p_lov_return_value=>'en-zw',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198773302783437015.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Estone (et)',
  p_lov_return_value=>'et',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198773520055437015.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'FYRO Macedone (mk)',
  p_lov_return_value=>'mk',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198773712018437016.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Faeroese (fo)',
  p_lov_return_value=>'fo',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198773905928437016.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Farsi (fa)',
  p_lov_return_value=>'fa',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198774118945437016.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Francese (Svizzera) (fr-ch)',
  p_lov_return_value=>'fr-ch',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198774304989437016.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Finlandese (fi)',
  p_lov_return_value=>'fi',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198774521702437017.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Francese (Belgio) (fr-be)',
  p_lov_return_value=>'fr-be',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198774726368437017.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Francese (Canada) (fr-ca)',
  p_lov_return_value=>'fr-ca',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198774928038437017.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Francese (Francia) (fr)',
  p_lov_return_value=>'fr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198775114927437017.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Francese (Lussemburgo) (fr-lu)',
  p_lov_return_value=>'fr-lu',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198775332434437018.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Francese (Monaco) (fr-mc)',
  p_lov_return_value=>'fr-mc',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198775527857437018.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Gaelico (gd)',
  p_lov_return_value=>'gd',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198775711321437018.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Galiziano (gl)',
  p_lov_return_value=>'gl',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198775904103437018.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Tedesco (Austria) (de-at)',
  p_lov_return_value=>'de-at',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198776121734437019.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Tedesco (Germania) (de)',
  p_lov_return_value=>'de',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198776332647437019.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Tedesco (Liechtenstein) (de-li)',
  p_lov_return_value=>'de-li',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198776529287437019.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Tedesco (Lussemburgo) (de-lu)',
  p_lov_return_value=>'de-lu',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198776722310437019.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Tedesco (Svizzera) (de-ch)',
  p_lov_return_value=>'de-ch',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198776930154437020.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Greco (el)',
  p_lov_return_value=>'el',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198777117663437020.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Gujarati (gu)',
  p_lov_return_value=>'gu',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198777314234437020.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Ebraico (he)',
  p_lov_return_value=>'he',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198777520312437020.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Hindi (hi)',
  p_lov_return_value=>'hi',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198777700475437021.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Ungherese (hu)',
  p_lov_return_value=>'hu',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198777911922437021.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Islandese (is)',
  p_lov_return_value=>'is',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198778128567437021.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Indonesiano (id)',
  p_lov_return_value=>'id',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198778324997437021.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Italiano (Italia) (it)',
  p_lov_return_value=>'it',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198778510434437022.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Italiano (Svizzera) (it-ch)',
  p_lov_return_value=>'it-ch',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198778714304437022.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Giapponese (ja)',
  p_lov_return_value=>'ja',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198778912949437022.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Kannada (kn)',
  p_lov_return_value=>'kn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198779115578437022.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Cazaco (kk)',
  p_lov_return_value=>'kk',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198779329622437023.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Konkani (kok)',
  p_lov_return_value=>'kok',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198779521470437023.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Coreano (ko)',
  p_lov_return_value=>'ko',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198779730912437023.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Chirghiso (kz)',
  p_lov_return_value=>'kz',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198779928215437023.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Lettone (lv)',
  p_lov_return_value=>'lv',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198780118707437024.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Lituano (lt)',
  p_lov_return_value=>'lt',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198780313346437024.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Malese (Malaysia) (ms)',
  p_lov_return_value=>'ms',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198780501262437024.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Malayalam (ml)',
  p_lov_return_value=>'ml',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198780716986437024.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Maltese (mt)',
  p_lov_return_value=>'mt',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198780925915437025.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Marathi (mr)',
  p_lov_return_value=>'mr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198781122126437025.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Nepalese (India) (ne)',
  p_lov_return_value=>'ne',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198781323201437025.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Norvegese (Bokmal) (nb-no)',
  p_lov_return_value=>'nb-no',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198781531339437026.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Norvegese (Bokmal) (no)',
  p_lov_return_value=>'no',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198781717582437026.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Norvegese (Nynorsk) (nn-no)',
  p_lov_return_value=>'nn-no',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198781901148437026.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Oriya (or)',
  p_lov_return_value=>'or',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198782123357437026.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Polacco (pl)',
  p_lov_return_value=>'pl',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198782308585437026.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Portoghese (Brasile) (pt-br)',
  p_lov_return_value=>'pt-br',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198782515205437027.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Portoghese (Portogallo) (pt)',
  p_lov_return_value=>'pt',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198782712809437027.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Punjabi (pa)',
  p_lov_return_value=>'pa',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198782926250437027.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Romeno (ro)',
  p_lov_return_value=>'ro',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198783103701437028.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Russo (ru)',
  p_lov_return_value=>'ru',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198783313683437028.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Russo (Moldavia) (ru-md)',
  p_lov_return_value=>'ru-md',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198783525893437028.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Serbo (sr)',
  p_lov_return_value=>'sr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198783706765437028.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Slovacco (sk)',
  p_lov_return_value=>'sk',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198783923934437029.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Sloveno (sl)',
  p_lov_return_value=>'sl',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198784123775437029.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Argentina) (es-ar)',
  p_lov_return_value=>'es-ar',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198784305305437029.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Bolivia) (es-bo)',
  p_lov_return_value=>'es-bo',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198784503555437029.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Cile) (es-cl)',
  p_lov_return_value=>'es-cl',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198784728332437030.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Colombia) (es-co)',
  p_lov_return_value=>'es-co',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198784908380437030.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Costa Rica) (es-cr)',
  p_lov_return_value=>'es-cr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198785110585437030.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Repubblica Dominicana) (es-do)',
  p_lov_return_value=>'es-do',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198785309022437030.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Ecuador) (es-ec)',
  p_lov_return_value=>'es-ec',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198785513360437031.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (El Salvador) (es-sv)',
  p_lov_return_value=>'es-sv',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198785722922437031.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Guatemala) (es-gt)',
  p_lov_return_value=>'es-gt',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198785903148437031.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Honduras) (es-hn)',
  p_lov_return_value=>'es-hn',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198786119876437031.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Messico) (es-mx)',
  p_lov_return_value=>'es-mx',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198786323820437032.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Nicaragua) (es-ni)',
  p_lov_return_value=>'es-ni',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198786501745437032.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Panama) (es-pa)',
  p_lov_return_value=>'es-pa',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198786728889437032.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Paraguay) (es-py)',
  p_lov_return_value=>'es-py',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198786926053437032.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Perù) (es-pe)',
  p_lov_return_value=>'es-pe',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198787110239437033.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Porto Rico) (es-pr)',
  p_lov_return_value=>'es-pr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198787325084437033.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (tradizionale) (es)',
  p_lov_return_value=>'es',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198787517364437033.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Stati Uniti) (es-us)',
  p_lov_return_value=>'es-us',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198787727100437033.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Uruguay) (es-uy)',
  p_lov_return_value=>'es-uy',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198787927315437033.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Spagnolo (Venezuela) (es-ve)',
  p_lov_return_value=>'es-ve',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198788117011437034.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Svedese (sv)',
  p_lov_return_value=>'sv',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198788328010437034.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Svedese (Finlandia) (sv-fi)',
  p_lov_return_value=>'sv-fi',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198788517641437034.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Tamil (ta)',
  p_lov_return_value=>'ta',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198788706442437034.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Telugu (te)',
  p_lov_return_value=>'te',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198788903837437035.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Thailandese (th)',
  p_lov_return_value=>'th',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198789120777437035.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Turco (tr)',
  p_lov_return_value=>'tr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198789331021437035.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Ucraino (uk)',
  p_lov_return_value=>'uk',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198789522886437035.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Urdu (ur)',
  p_lov_return_value=>'ur',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198789714421437036.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Uzbeco (uz)',
  p_lov_return_value=>'uz',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>198789914419437036.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>107899321117195063.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Vietnamita (vi)',
  p_lov_return_value=>'vi',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/image_preview_repository
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 2545625667361279.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'IMAGE PREVIEW REPOSITORY',
  p_lov_query=> '.'||to_char(2545625667361279 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2545817600361279.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2545625667361279.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Immagini standard',
  p_lov_return_value=>'STANDARD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2546030307361279.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2545625667361279.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Immagini dell''area di lavoro',
  p_lov_return_value=>'WORKSPACE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2546221573361279.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2545625667361279.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Immagine dell''applicazione',
  p_lov_return_value=>'APPLICATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/image_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84856825191363086.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'IMAGE_TYPES',
  p_lov_query=> '.'||to_char(84856825191363086 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84857007575363086.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84856825191363086.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Tutte le immagini',
  p_lov_return_value=>'0',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84857400079363087.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84856825191363086.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Immagini dell''area di lavoro (soltanto)',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84857607859363087.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84856825191363086.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Immagini dell''applicazione (solo)',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/include_functions
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 60545525798060811.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INCLUDE FUNCTIONS',
  p_lov_query=> '.'||to_char(60545525798060811 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>60545732724060813.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>60545525798060811.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Funzioni',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/include_packages
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 60546306536064747.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INCLUDE PACKAGES',
  p_lov_query=> '.'||to_char(60546306536064747 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>60546524313064747.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>60546306536064747.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Package',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/include_procedures
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 60547120735068828.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INCLUDE PROCEDURES',
  p_lov_query=> '.'||to_char(60547120735068828 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>60547315471068829.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>60547120735068828.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Procedure',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/include_table_and_form_query_and_update
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 91319600010962461.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INCLUDE TABLE AND FORM (QUERY AND UPDATE)',
  p_lov_query=> '.'||to_char(91319600010962461 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91319803768962466.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>91319600010962461.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Solo query',
  p_lov_return_value=>'QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91320004153962467.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>91319600010962461.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Query e aggiornamento',
  p_lov_return_value=>'UPDATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/include_views
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6397115937331647.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INCLUDE VIEWS',
  p_lov_query=> '.'||to_char(6397115937331647 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6397327633331648.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>6397115937331647.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Viste',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/include_analysis_pages
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 168959914296647601.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INCLUDE_ANALYSIS_PAGES',
  p_lov_query=> '.'||to_char(168959914296647601 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>168960106462647608.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>168959914296647601.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Includi pagine analisi',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/include_exclude
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84357332667662999.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INCLUDE_EXCLUDE',
  p_lov_query=> '.'||to_char(84357332667662999 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84357508456662999.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84357332667662999.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Escludi',
  p_lov_return_value=>'EXCLUDE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84357711858663000.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84357332667662999.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Includi',
  p_lov_return_value=>'INCLUDE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/include_success_message
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84362432452672420.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INCLUDE_SUCCESS_MESSAGE',
  p_lov_query=> '.'||to_char(84362432452672420 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84362620952672421.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84362432452672420.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'includi messaggio di processo completato',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/install_flow_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 73071600194414972.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INSTALL.FLOW.OPTIONS',
  p_lov_query=> '.'||to_char(73071600194414972 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>73072113397414978.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>73071600194414972.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Assegna automaticamente nuovo ID applicazione',
  p_lov_return_value=>'AUTO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>73071919023414978.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>73071600194414972.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Riutilizza ID applicazione &P49_IMP_FLOW_ID. da file di esportazione',
  p_lov_return_value=>'REUSE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>73106501130701222.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>73071600194414972.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modifica ID applicazione',
  p_lov_return_value=>'SPECIFY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/installer_build_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 35684329623125996.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INSTALLER BUILD OPTIONS',
  p_lov_query=> 'select patch_name, id from wwv_flow_patches '||chr(10)||
'where id in (select build_opt_id from wwv_flow_install_build_opt'||chr(10)||
'              where flow_id = :fb_flow_id'||chr(10)||
'                and security_group_id = :flow_security_group_id)');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/install_condition_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INSTALL_CONDITION_TYPES',
  p_lov_query=> '.'||to_char(2610902469203915 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2611107226203916.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Esiste (la query SQL restituisce almeno una riga)',
  p_lov_return_value=>'EXISTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2611302822203917.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Non esiste (la query SQL non restituisce righe)',
  p_lov_return_value=>'NOT_EXISTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2611532142203917.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Espressione SQL',
  p_lov_return_value=>'SQL_EXPRESSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2611722452203917.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Espressione PL/SQL',
  p_lov_return_value=>'PLSQL_EXPRESSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2611903369203917.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Corpo della funzione PL/SQL che restituisce un risultato booleano',
  p_lov_return_value=>'FUNCTION_BODY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2612125323203917.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Valore della preferenza utente in Espressione 1 = Espressione 2',
  p_lov_return_value=>'USER_PREF_IN_COND_EQ_COND2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2612300618203918.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Valore della preferenza utente in Espressione 1 != Espressione 2',
  p_lov_return_value=>'USER_PREF_IN_COND_NOT_EQ_COND2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2612510467203918.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Il testo in Espressione 1 è contenuto all''interno del testo di Espressione 2',
  p_lov_return_value=>'DISPLAY_COND_IN_COND_TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2612716470203918.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Il testo in Espressione 1 NON è contenuto all''interno del testo di Espressione 2',
  p_lov_return_value=>'DISPLAY_COND_NOT_IN_COND_TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2612916275203918.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Testo in Espressione 1 = Espressione 2 (include le stringhe di sostituzione &amp;ITEM)',
  p_lov_return_value=>'DISPLAY_COND_EQUAL_COND_TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2613122730203919.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'Testo in Espressione 1 != Espressione 2 (include le stringhe di sostituzione &amp;ITEM)',
  p_lov_return_value=>'DISP_COND_NOT_EQUAL_COND_TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2613308299203919.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>12,
  p_lov_disp_value=>'Lingua corrente contenuta all''interno di Espressione 1',
  p_lov_return_value=>'CURRENT_LANG_IN_COND1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2613518327203919.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>13,
  p_lov_disp_value=>'Lingua corrente NON contenuta all''interno di Espressione 1',
  p_lov_return_value=>'CURRENT_LANG_NOT_IN_COND1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2613719056203919.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>14,
  p_lov_disp_value=>'Lingua corrente != Espressione 1',
  p_lov_return_value=>'CURRENT_LANG_NOT_EQ_COND1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2613931075203919.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>15,
  p_lov_disp_value=>'Lingua corrente = Espressione 1',
  p_lov_return_value=>'CURRENT_LANG_EQ_COND1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2614914590207416.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>16,
  p_lov_disp_value=>'Se CGI_ENV DAD_NAME = Espressione 1',
  p_lov_return_value=>'DAD_NAME_EQ_CONDITION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2615524633210304.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>17,
  p_lov_disp_value=>'Se CGI_ENV DAD_NAME != Espressione 1',
  p_lov_return_value=>'DAD_NAME_NOT_EQ_CONDITION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2615829827211851.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>18,
  p_lov_disp_value=>'Se CGI_ENV SERVER_NAME = Espressione 1',
  p_lov_return_value=>'SERVER_NAME_EQ_CONDITION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2616102946213515.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>19,
  p_lov_disp_value=>'Se CGI_ENV SERVER_NAME != Espressione 1',
  p_lov_return_value=>'SERVER_NAME_NOT_EQ_CONDITION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2616407448214867.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Se CGI_ENV HTTP_HOST = Espressione 1',
  p_lov_return_value=>'HTTP_HOST_EQ_CONDITION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2616711258215952.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>21,
  p_lov_disp_value=>'Se CGI_ENV HTTP_HOST != Espressione 1',
  p_lov_return_value=>'HTTP_HOST_NOT_EQ_CONDITION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>35854932212539564.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Lo schema di applicazione è in una lista separata da virgole in Espressione 1',
  p_lov_return_value=>'SCHEMA_IN_LIST',
  p_lov_disp_cond_type=>'SQL_EXPRESSION',
  p_lov_disp_cond=> '1=0',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>35855211911543166.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>31,
  p_lov_disp_value=>'Lo schema di applicazione NON è in una lista separata da virgole in Espressione 1',
  p_lov_return_value=>'SCHEMA_NOT_IN_LIST',
  p_lov_disp_cond_type=>'SQL_EXPRESSION',
  p_lov_disp_cond=> '1=0',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47908326353191665.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Versione software precedente < Versione specificata in Espressione 1',
  p_lov_return_value=>'PREV_VERSION_LESS_THAN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47908631893193277.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>41,
  p_lov_disp_value=>'Versione software precedente = Versione specificata in Espressione 1',
  p_lov_return_value=>'PREV_VERSION_EQUALS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47908904320194771.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>42,
  p_lov_disp_value=>'Versione software precedente > Versione specificata in Espressione 1',
  p_lov_return_value=>'PREV_VERSION_GREATER_THAN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2617015067217035.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'Mai',
  p_lov_return_value=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2617419223218210.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>2610902469203915.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>101,
  p_lov_disp_value=>'Sempre',
  p_lov_return_value=>'ALWAYS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/install_script_source
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 4626801323289842.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INSTALL_SCRIPT_SOURCE',
  p_lov_query=> '.'||to_char(4626801323289842 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4627023954289843.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4626801323289842.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Completamente nuovo/a',
  p_lov_return_value=>'SCRATCH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4627202457289843.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4626801323289842.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Dal repository script SQL',
  p_lov_return_value=>'SCRIPT_REPOSITORY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4627422435289843.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4626801323289842.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Dal file',
  p_lov_return_value=>'FILE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>206165912678213419.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>4626801323289842.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'File CSS, immagine e statici',
  p_lov_return_value=>'APEX_FILES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/irr_rowid_or_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 114719118636380285.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'IRR.ROWID_OR_COLS',
  p_lov_query=> '.'||to_char(114719118636380285 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>114719413876380287.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>114719118636380285.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'ROWID',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>114719616889380287.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>114719118636380285.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Colonna univoca',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/irr_column_filter_lov
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 147261022842307147.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'IRR_COLUMN_FILTER_LOV',
  p_lov_query=> '.'||to_char(147261022842307147 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>147261325305307148.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>147261022842307147.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Nessuno',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>147261517398307148.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>147261022842307147.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Impostazione predefinita in base al tipo di colonna',
  p_lov_return_value=>'D',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>147261708729307148.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>147261022842307147.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Usa lista di valori definita',
  p_lov_return_value=>'S',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/irr_link_column
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 134903721394714997.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'IRR_LINK_COLUMN',
  p_lov_query=> '.'||to_char(134903721394714997 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>134904030028714997.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>134903721394714997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Collega a vista a riga singola',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>134905202132718861.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>134903721394714997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>15,
  p_lov_disp_value=>'Collega a destinazione personalizzata',
  p_lov_return_value=>'C',
  p_lov_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION',
  p_lov_disp_cond=> '601',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>134904219905714998.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>134903721394714997.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Escludi colonna di collegamento',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/iscolumn_name_text
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 23469230991802389.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ISCOLUMN.NAME.TEXT',
  p_lov_query=> 'select ''<span class="instructiontext">''||'||chr(10)||
'wwv_flow_lang.system_message(''F4300_INSTRUCT_TEXT'')||''</span>'' d, ''Y'' r from dual');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/item_and_report
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 146337627678444760.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ITEM AND REPORT',
  p_lov_query=> '.'||to_char(146337627678444760 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>146337822091444773.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>146337627678444760.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Elemento pagina',
  p_lov_return_value=>'ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>146338027107444777.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>146337627678444760.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Report',
  p_lov_return_value=>'REPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/item_protection_level
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 17287012676783081.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ITEM PROTECTION LEVEL',
  p_lov_query=> '.'||to_char(17287012676783081 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17287200195783083.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17287012676783081.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Non limitato',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17287400587783083.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17287012676783081.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Checksum obbligatorio: a livello applicazione',
  p_lov_return_value=>'B',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17287603082783083.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17287012676783081.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Checksum obbligatorio: a livello di utente',
  p_lov_return_value=>'P',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17287806322783083.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17287012676783081.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Checksum obbligatorio: a livello di sessione',
  p_lov_return_value=>'S',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17304317734788157.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17287012676783081.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Limitato: non può essere impostato dal browser',
  p_lov_return_value=>'I',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/item_protection_level_d
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 109261519627066371.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ITEM PROTECTION LEVEL D',
  p_lov_query=> 'for c1 in (select nvl(PAGE_PROTECTION_ENABLED_Y_N,''N'') p from wwv_flows where id = :FB_FLOW_ID) loop'||chr(10)||
'    if c1.p = ''Y'' then'||chr(10)||
'       return  ''select wwv_flow_lang.system_message(''''UNRESTRICTED'''') d, ''''N'''' r'||chr(10)||
'                  from dual union all'||chr(10)||
'                select wwv_flow_lang.system_message(''''CHECKSUM_REQUIRED_APPLICATION'''') d, ''''B'''' r'||chr(10)||
'                  from dual union all'||chr(10)||
'                select wwv_flow_lang.system_message(''''CHECKSUM_REQUIRED_USER'''') d, ''''P'''' r'||chr(10)||
'                  from dual union all               '||chr(10)||
'                select wwv_flow_lang.system_message(''''CHECKSUM_REQUIRED_SESSION'''') d, ''''S'''' r'||chr(10)||
'                  from dual union all               '||chr(10)||
'                select wwv_flow_lang.system_message(''''RESTRICTED_NO_SET_FROM_BROWSER'''') d, ''''I'''' r'||chr(10)||
'                  from dual'';'||chr(10)||
'    else'||chr(10)||
'       return  ''select wwv_flow_lang.system_message(''''UNRESTRICTED'''') d, ''''N'''' r'||chr(10)||
'                  from dual union all '||chr(10)||
'                select wwv_flow_lang.system_message(''''RESTRICTED_NO_SET_FROM_BROWSER'''') d, ''''I'''' r'||chr(10)||
'                  from dual'';'||chr(10)||
'    end if;'||chr(10)||
'end loop;');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/item_protection_level_no_restricted
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 109314413723246310.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ITEM PROTECTION LEVEL NO RESTRICTED',
  p_lov_query=> '.'||to_char(109314413723246310 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>109314629939246312.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>109314413723246310.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Non limitato',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>109314820854246316.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>109314413723246310.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Checksum obbligatorio: a livello applicazione',
  p_lov_return_value=>'B',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>109315024526246316.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>109314413723246310.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Checksum obbligatorio: a livello di utente',
  p_lov_return_value=>'P',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>109315221763246316.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>109314413723246310.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Checksum obbligatorio: a livello di sessione',
  p_lov_return_value=>'S',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/item_caching_rule
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84930714296823567.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ITEM.CACHING.RULE',
  p_lov_query=> '.'||to_char(84930714296823567 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84930930267823568.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84930714296823567.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Sempre (sostituisci qualsiasi valore esistente nello stato di sessione)',
  p_lov_return_value=>'NO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84931103028823568.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84930714296823567.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Solo se il valore corrente dello stato di sessione è NULL',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/item_default_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 38747715987262349.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ITEM.DEFAULT.TYPE',
  p_lov_query=> '.'||to_char(38747715987262349 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>38748018541262374.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>38747715987262349.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Testo statico con stringhe di sostituzione per lo stato delle sessioni',
  p_lov_return_value=>'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>38748231848262376.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>38747715987262349.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Corpo funzione PL/SQL',
  p_lov_return_value=>'PLSQL_FUNCTION_BODY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>38748428126262376.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>38747715987262349.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Espressione PL/SQL',
  p_lov_return_value=>'PLSQL_EXPRESSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/item_help_search
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84895631752563737.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ITEM.HELP.SEARCH',
  p_lov_query=> '.'||to_char(84895631752563737 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84895800944563739.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84895631752563737.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Tutte le pagine',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84896012258563739.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84895631752563737.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Pagina corrente',
  p_lov_return_value=>'CURRENT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/item_current_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84729824360877320.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ITEM_CURRENT_TYPE',
  p_lov_query=> '.'||to_char(84729824360877320 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84730000591877321.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84729824360877320.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Sempre',
  p_lov_return_value=>'ALWAYS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84730215547877321.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84729824360877320.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Elenco pagine delimitato da due punti',
  p_lov_return_value=>'COLON_DELIMITED_PAGE_LIST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84730407325877321.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84729824360877320.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Query SQL - Esiste',
  p_lov_return_value=>'EXISTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84730612612877322.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84729824360877320.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Mai',
  p_lov_return_value=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84730804253877322.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84729824360877320.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Query SQL- Non esiste',
  p_lov_return_value=>'NOT_EXISTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84731025371877322.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84729824360877320.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Espressione PL/SQL',
  p_lov_return_value=>'PLSQL_EXPRESSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/item_display_as2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ITEM_DISPLAY_AS2',
  p_lov_query=> '.'||to_char(183325630267116750 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>4106221269273884.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista di selezione con LOV popup',
  p_lov_return_value=>'SHOW_AS_SL_WITH_POPUP',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8612421046568412.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'LOV popup (recupera tramite fetch il primo rowset e filtra)',
  p_lov_return_value=>'POPUP_FILTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15146303503151054.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore colori popup',
  p_lov_return_value=>'POPUP_COLOR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16563406961368037.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Password (sottomessa se si preme Invio)',
  p_lov_return_value=>'PASSWORD_WITH_ENTER_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16563922891372689.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Campo di testo (la pagina viene sottomessa sempre quando si preme Invio)',
  p_lov_return_value=>'TEXT_WITH_ENTER_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22498925827720946.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MM-YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22499732061722768.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MM-YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22500304141724181.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MM-YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22501013145726720.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD.MM.YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22501517993728165.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD.MM.YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22501823534729707.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD.MM.YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22502805311733923.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY-MM-DD HH24:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22503612583736009.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY-MM-DD HH:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22507923319739162.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY.DD.MM HH24:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22508229552740998.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY.DD.MM HH:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22508603711742966.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY.DD.MM)',
  p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22509011676745297.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY/MM/DD HH24:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22509717909747055.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY/MM/DD HH:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22510523796748745.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY/MM/DD)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_SLASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22511132108751137.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (RR-MON-DD HH24:MI)',
  p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22512106612753234.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (RR-MON-DD HH:MI)',
  p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>34574717490748193.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista di valori chiave popup senza recupero fetch (visualizza la descrizione, restituisce un valore chiave senza recupero fetch preventivo)',
  p_lov_return_value=>'POPUP_KEY_LOV_NOFETCH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41168614463459328.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY-MM-DD)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41169022774461722.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (RR-MON-DD)',
  p_lov_return_value=>'PICK_DATE_RR_MON_DD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41197230783126056.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Shuttle',
  p_lov_return_value=>'SHUTTLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47270803379100883.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Editor HTML minimo',
  p_lov_return_value=>'TEXTAREA_WITH_HTML_EDITOR_BASIC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47271518924103499.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Editor HTML standard',
  p_lov_return_value=>'TEXTAREA_WITH_HTML_EDITOR_STANDARD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>73663219136200168.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Visualizza come testo (basato su PL/SQL, non salva lo stato)',
  p_lov_return_value=>'DISPLAY_ONLY_PLSQL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>81636215125770304.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-RR)',
  p_lov_return_value=>'PICK_DATE_DD_MON_RR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>81638107577773787.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-RR HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>81642332581777460.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-RR HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88300821000222390.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (utilizza il formato di visualizzazione per gli elementi)',
  p_lov_return_value=>'PICK_DATE_USING_FORMAT_MASK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>105635006291390467.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista di selezione',
  p_lov_return_value=>'COMBOBOX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>106283724967775853.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area di testo con conteggio caratteri',
  p_lov_return_value=>'TEXTAREA_CHAR_COUNT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>106307103800089501.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area di testo con conteggio caratteri e controllo ortografico',
  p_lov_return_value=>'TEXTAREA_CHAR_COUNT_SPELL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>107995612612827965.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (utilizza il formato data dell''applicazione)',
  p_lov_return_value=>'PICK_DATE_USING_APP_DATE_FORMAT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>114857019047910287.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Nascosto e protetto',
  p_lov_return_value=>'HIDDEN_PROTECTED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183325921319116758.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Nascosto',
  p_lov_return_value=>'HIDDEN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183330427642120360.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Arresta e avvia tabella HTML (visualizza solo l''etichetta)',
  p_lov_return_value=>'STOP_AND_START_HTML_TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183332622682122719.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Visualizza come testo (basato su LOV, non salva lo stato)',
  p_lov_return_value=>'DISPLAY_ONLY_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183343512750142507.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Visualizza come testo (non salva lo stato)',
  p_lov_return_value=>'DISPLAY_ONLY_HTML',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183344210593143510.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Visualizza come testo (caratteri speciali di escape, non salva lo stato)',
  p_lov_return_value=>'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183347106495145358.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Visualizza come testo (salva lo stato)',
  p_lov_return_value=>'DISPLAY_AND_SAVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183347805417145878.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Casella di controllo',
  p_lov_return_value=>'CHECKBOX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183348503907146543.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'LOV popup (recupera tramite fetch il primo rowset)',
  p_lov_return_value=>'POPUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183349901320147809.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista a selezione multipla',
  p_lov_return_value=>'MULTIPLESELECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183350932362148539.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Gruppo di scelta',
  p_lov_return_value=>'RADIOGROUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183351830637149395.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Gruppo di scelta (con sottomissione)',
  p_lov_return_value=>'RADIOGROUP_WITH_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183354027618150772.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area di testo',
  p_lov_return_value=>'TEXTAREA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183355526108151507.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Campo di testo',
  p_lov_return_value=>'TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183356424598152139.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Password',
  p_lov_return_value=>'PASSWORD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183357623305152763.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Gestione lista (basata su LOV popup)',
  p_lov_return_value=>'LIST_MGR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183358322011153350.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Gestione lista (sola visualizzazione)',
  p_lov_return_value=>'LIST_MGR_VIEW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183359020717153988.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Pulsante',
  p_lov_return_value=>'BUTTON',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183359719423154609.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sfoglia file...',
  p_lov_return_value=>'FILE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183361117913155336.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'LOV popup (senza recupero fetch)',
  p_lov_return_value=>'POPUP2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183361816619155933.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Gestione lista (basata su LOV popup, senza recupero fetch)',
  p_lov_return_value=>'LIST_MGR2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183362515325156496.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Seleziona lista da sottomettere',
  p_lov_return_value=>'COMBOBOX_WITH_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183363214031157072.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Visualizza come testo (basato su LOV, salva lo stato)',
  p_lov_return_value=>'DISPLAY_AND_SAVE_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183363912737157667.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area di testo (altezza automatica)',
  p_lov_return_value=>'TEXTAREA-AUTO-HEIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183365611443158296.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Seleziona lista con reindirizzamento',
  p_lov_return_value=>'COMBOBOX_WITH_JS_REDIRECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183368109934158988.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area di testo con correzione ortografica',
  p_lov_return_value=>'TEXTAREA_WITH_SPELL_CHECK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183368808640159577.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD/MM/YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183370505620160986.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (MM/DD/YYYY)',
  p_lov_return_value=>'PICK_DATE_MM_DD_YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183371604542161501.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183372603248162137.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-YY)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183374001954162737.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD/MM/YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183374700445163421.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (MM/DD/YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183375431487164197.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183376130193164801.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-YY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183376828684165442.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD/MM/YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183377527605166017.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (MM/DD/YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183378226311166567.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183378925233167124.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-YY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183379623939167688.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Campo di testo con popup della calcolatrice',
  p_lov_return_value=>'TEXT_WITH_CALCULATOR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183380822645168282.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (utilizza il formato di visualizzazione per le applicazioni)',
  p_lov_return_value=>'PICK_DATE_USING_FLOW_FORMAT_MASK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183383219195169915.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Gruppo di scelta con reindirizzamento',
  p_lov_return_value=>'RADIOGROUP_WITH_REDIRECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183383917685170561.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Seleziona lista che restituisce un reindirizzamento URL',
  p_lov_return_value=>'COMBOBOX_WITH_URL_REDIRECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183386115960171425.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Seleziona lista con diramazione a pagina',
  p_lov_return_value=>'COMBOBOX_WITH_BRANCH_TO_PAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183387814666171986.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Gestione lista (basata su LOV popup, le maiuscole/minuscole vengono mantenute)',
  p_lov_return_value=>'LIST_MGR3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183388513587172477.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Campo di testo (disabilitato, non salva lo stato)',
  p_lov_return_value=>'TEXT_DISABLED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183389212293173088.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista di valori chiave popup (visualizza la descrizione, restituisce il valore chiave)',
  p_lov_return_value=>'POPUP_KEY_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183389911000173702.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Campo di testo (disabilitato, salva lo stato)',
  p_lov_return_value=>'TEXT_DISABLED_AND_SAVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183390609274174446.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area di testo con editor HTML',
  p_lov_return_value=>'TEXTAREA_WITH_CONTROLS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265051930940972253.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Password (sottomessa se si preme Invio, non salva lo stato)',
  p_lov_return_value=>'PASSWORD_WITH_SUBMIT_DNSS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265052105791974490.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>183325630267116750.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Password (non salva lo stato)',
  p_lov_return_value=>'PASSWORD_DNSS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/item_source_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 129889837649.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ITEM_SOURCE_TYPES',
  p_lov_query=> '.'||to_char(129889837649 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>129890840816.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>129889837649.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Sempre NULL',
  p_lov_return_value=>'ALWAYS_NULL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>129891851389.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>129889837649.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Assegnazione statica (valore uguale all''attributo origine)',
  p_lov_return_value=>'STATIC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>129892852681.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>129889837649.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Query SQL',
  p_lov_return_value=>'QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>129893855391.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>129889837649.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Elemento (nome elemento di applicazione o pagina)',
  p_lov_return_value=>'ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>129894857627.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>129889837649.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Espressione o funzione PL/SQL',
  p_lov_return_value=>'FUNCTION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>133432340478.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>129889837649.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>55,
  p_lov_disp_value=>'Corpo funzione PL/SQL',
  p_lov_return_value=>'FUNCTION_BODY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>129895858879.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>129889837649.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Colonna di database',
  p_lov_return_value=>'DB_COLUMN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>76368092101.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>129889837649.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Preferenza',
  p_lov_return_value=>'PREFERENCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>73648420658184170.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>129889837649.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'Blocco anonimo PL/SQL',
  p_lov_return_value=>'PLSQL_ANONYMOUS_BLOCK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/iud_select
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88127426312675871.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'IUD.SELECT',
  p_lov_query=> '.'||to_char(88127426312675871 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88156615137966014.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>88127426312675871.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Inserisci',
  p_lov_return_value=>'I',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88156828112966014.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>88127426312675871.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Aggiorna',
  p_lov_return_value=>'U',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88157015984966014.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>88127426312675871.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Elimina',
  p_lov_return_value=>'D',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/label_theme_class_id
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 43828319065855502.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LABEL THEME CLASS ID',
  p_lov_query=> '.'||to_char(43828319065855502 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43828604595855506.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43828319065855502.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Etichetta facoltativa con Guida',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43828821955855506.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43828319065855502.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Etichetta obbligatoria con Guida',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43829026521855506.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43828319065855502.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Etichetta facoltativa',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43829216754855507.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43828319065855502.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Etichetta obbligatoria',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>44168504088920423.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43828319065855502.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Nessuna etichetta',
  p_lov_return_value=>'13',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43829403095855507.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43828319065855502.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 1',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43829614163855507.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43828319065855502.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 2',
  p_lov_return_value=>'6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43829811310855507.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43828319065855502.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 3',
  p_lov_return_value=>'7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43830028586855508.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43828319065855502.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 4',
  p_lov_return_value=>'8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43830230461855508.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43828319065855502.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 5',
  p_lov_return_value=>'9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43830425504855508.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43828319065855502.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 6',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43830605003855508.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43828319065855502.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 7',
  p_lov_return_value=>'11',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43830820404855509.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43828319065855502.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 8',
  p_lov_return_value=>'12',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/label_alignment
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84757522618851451.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LABEL_ALIGNMENT',
  p_lov_query=> '.'||to_char(84757522618851451 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84757729764851451.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84757522618851451.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'In alto ',
  p_lov_return_value=>'ABOVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84757914076851452.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84757522618851451.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'In basso',
  p_lov_return_value=>'BELOW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84758122408851452.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84757522618851451.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Al centro',
  p_lov_return_value=>'CENTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84758309833851452.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84757522618851451.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Centrato in basso',
  p_lov_return_value=>'CENTER-BOTTOM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84758526184851452.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84757522618851451.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Centrato al centro',
  p_lov_return_value=>'CENTER-CENTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84758718640851453.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84757522618851451.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Centrato in alto',
  p_lov_return_value=>'CENTER-TOP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84758917390851453.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84757522618851451.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'A sinistra',
  p_lov_return_value=>'LEFT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84759122923851453.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84757522618851451.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'In basso a sinistra',
  p_lov_return_value=>'LEFT-BOTTOM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84759320284851453.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84757522618851451.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'Centrato a sinistra',
  p_lov_return_value=>'LEFT-CENTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84759518480851454.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84757522618851451.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'In alto a sinistra',
  p_lov_return_value=>'LEFT-TOP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84759731211851454.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84757522618851451.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'A destra',
  p_lov_return_value=>'RIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84759903007851454.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84757522618851451.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'In basso a destra',
  p_lov_return_value=>'RIGHT-BOTTOM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84760105209851455.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84757522618851451.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'Centrato a destra',
  p_lov_return_value=>'RIGHT-CENTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84760318434851455.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84757522618851451.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>140,
  p_lov_disp_value=>'In alto a destra',
  p_lov_return_value=>'RIGHT-TOP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/label_template_wiz
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86598309219256908.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LABEL_TEMPLATE_WIZ',
  p_lov_query=> '.'||to_char(86598309219256908 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88294304634805085.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86598309219256908.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Scegliere una voce dal repository di &PRODUCT_NAME..',
  p_lov_return_value=>'DEFAULT',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91902324410976802.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86598309219256908.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Completamente nuovo/a',
  p_lov_return_value=>'BLANK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>91903301685979689.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86598309219256908.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Come copia di un modello esistente',
  p_lov_return_value=>'COPY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/language_derived_from
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 73566910745435962.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LANGUAGE_DERIVED_FROM',
  p_lov_query=> '.'||to_char(73566910745435962 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88294907751806000.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>73566910745435962.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Nessun NLS (applicazione non tradotta)',
  p_lov_return_value=>'0',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88295118806806000.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>73566910745435962.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Utilizza lingua primaria dell''applicazione',
  p_lov_return_value=>'FLOW_PRIMARY_LANGUAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88295311143806000.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>73566910745435962.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Browser (utilizza preferenza lingua del browser)',
  p_lov_return_value=>'BROWSER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88295501503806001.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>73566910745435962.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>''||chr(10)||
'Preferenza applicazione (utilizza FSP_LANGUAGE_PREFERENCE)',
  p_lov_return_value=>'FLOW_PREFERENCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88295718259806001.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>73566910745435962.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Preferenza elemento (utilizza elemento contenente preferenza)',
  p_lov_return_value=>'ITEM_PREFERENCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/line_style
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84878309186453156.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LINE_STYLE',
  p_lov_query=> '.'||to_char(84878309186453156 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84878510088453156.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84878309186453156.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Linea tratteggiata 1',
  p_lov_return_value=>'DOTTED_1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84878703174453157.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84878309186453156.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Linea tratteggiata 2',
  p_lov_return_value=>'DOTTED_2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84878910394453157.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84878309186453156.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Linea tratteggiata 3',
  p_lov_return_value=>'DOTTED_3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84879114364453157.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84878309186453156.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Pieno',
  p_lov_return_value=>'STRAIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/line_weight
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 244579719911969185.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LINE_WEIGHT',
  p_lov_query=> '.'||to_char(244579719911969185 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>244580030013969188.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>244579719911969185.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'1',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>244580206494969189.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>244579719911969185.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'2',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>244580404944969189.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>244579719911969185.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'3',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>244580616739969190.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>244579719911969185.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'4',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>244580829606969190.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>244579719911969185.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>244581020219969190.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>244579719911969185.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'6',
  p_lov_return_value=>'6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>244581203664969190.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>244579719911969185.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'7',
  p_lov_return_value=>'7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>244581404612969190.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>244579719911969185.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'8',
  p_lov_return_value=>'8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>244581619284969191.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>244579719911969185.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'9',
  p_lov_return_value=>'9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/link_option
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84330300975616054.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LINK_OPTION',
  p_lov_query=> '.'||to_char(84330300975616054 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88296510521806862.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84330300975616054.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Elemento di applicazione esistente',
  p_lov_return_value=>'EXISTING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88296717080806862.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84330300975616054.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Niente',
  p_lov_return_value=>'NOTHING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/link_target
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84811707811178296.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LINK_TARGET',
  p_lov_query=> '.'||to_char(84811707811178296 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84811912899178296.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84811707811178296.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Applicazione corrente',
  p_lov_return_value=>'F',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84812101106178297.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84811707811178296.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Tutte le applicazioni',
  p_lov_return_value=>'C',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84812328270178297.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84811707811178296.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'URL remoto',
  p_lov_return_value=>'E',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_exportable_flows
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 189999522998166355.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST EXPORTABLE FLOWS',
  p_lov_query=> 'select distinct f.id||'' ''||htf.escape_sc(f.name) d, f.id r'||chr(10)||
'from   wwv_flows f'||chr(10)||
'where  security_group_id = :flow_security_group_id and       '||chr(10)||
'       not exists ('||chr(10)||
'       select null from wwv_flow_language_map'||chr(10)||
'       where translation_flow_id = f.id and '||chr(10)||
'         security_group_id = :flow_security_group_id) and'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
'       or'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
'order by 2');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_flows
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 312074852.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST FLOWS',
  p_lov_query=> 'select distinct f.id||'' ''||htf.escape_sc(f.name) d, f.id r'||chr(10)||
'from   wwv_flows f'||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
'       build_status != ''RUN_ONLY'' and'||chr(10)||
'       not exists ('||chr(10)||
'       select null from wwv_flow_language_map'||chr(10)||
'       where translation_flow_id = f.id and '||chr(10)||
'         security_group_id = :flow_security_group_id) and'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
'       or'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
'order by 2');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_items
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 918311972218937.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST ITEMS',
  p_lov_query=> 'select htf.escape_sc(list_item_link_text) d, id from ('||chr(10)||
'select lpad('' '',4*(level-1),''.'')|| list_item_link_text list_item_link_text, id'||chr(10)||
'from ( '||chr(10)||
'  select id, parent_list_item_id, list_item_display_sequence, list_item_link_text'||chr(10)||
'  from wwv_flow_list_items i'||chr(10)||
'  where flow_id = :FB_FLOW_ID'||chr(10)||
'  and list_id = :F4000_P4052_LIST_ID'||chr(10)||
'  and id not in ('||chr(10)||
'    select id from wwv_flow_list_items '||chr(10)||
'    where flow_id = :FB_FLOW_ID'||chr(10)||
'    and list_id = :F4000_P4052_LIST_ID'||chr(10)||
'    start with id = :F4000_P4052_ID '||chr(10)||
'    connect by prior id = parent_list_item_id'||chr(10)||
'  ))'||chr(10)||
'start with parent_list_item_id is null'||chr(10)||
'connect by prior id = parent_list_item_id '||chr(10)||
'order siblings by list_item_display_sequence'||chr(10)||
')');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_items_inline_edit
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 108645906791566587.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST ITEMS (INLINE EDIT)',
  p_lov_query=> 'select lpad('' '',4*(level-1),''.'')|| htf.escape_sc(list_item_link_text) list_item_link_text, id'||chr(10)||
'from wwv_flow_list_items i'||chr(10)||
'where flow_id = :FB_FLOW_ID'||chr(10)||
'and list_id = :P373_LIST_ID'||chr(10)||
'and id not in ('||chr(10)||
'    select id from wwv_flow_list_items '||chr(10)||
'    where flow_id = :FB_FLOW_ID'||chr(10)||
'    and list_id = :P373_LIST_ID'||chr(10)||
'    start with id = :P373_ID '||chr(10)||
'    connect by prior id = parent_list_item_id'||chr(10)||
')'||chr(10)||
'start with parent_list_item_id is null'||chr(10)||
'connect by prior id = parent_list_item_id '||chr(10)||
'order siblings by list_item_display_sequence'||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_other_flows
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 51319520349273399.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST OTHER FLOWS',
  p_lov_query=> 'select distinct f.id||'' ''||htf.escape_sc(f.name) d, f.id r'||chr(10)||
'from   wwv_flows f'||chr(10)||
'where  '||chr(10)||
'id != :FB_FLOW_ID and'||chr(10)||
'security_group_id = :flow_security_group_id and'||chr(10)||
'       build_status != ''RUN_ONLY'' and'||chr(10)||
'       not exists ('||chr(10)||
'       select null from wwv_flow_language_map'||chr(10)||
'       where translation_flow_id = f.id and '||chr(10)||
'         security_group_id = :flow_security_group_id) and'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)'||chr(10)||
'       or'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )'||chr(10)||
'order by 2');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_page_regions
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 246039671.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST PAGE REGIONS',
  p_lov_query=> 'select plug_name, id from ('||chr(10)||
'select htf.escape_sc(plug_name)||'||chr(10)||
'       '' (''||PLUG_DISPLAY_COLUMN||'') ''||'||chr(10)||
'       PLUG_DISPLAY_SEQUENCE plug_name, id, upper(plug_name) pn, 1 x'||chr(10)||
'from wwv_flow_page_plugs p'||chr(10)||
'where flow_id = :FB_FLOW_ID and page_id = :FB_FLOW_PAGE_ID'||chr(10)||
'union'||chr(10)||
'select wwv_flow_lang.system_message(''PAGE'')||'' 0: ''||htf.escape_sc(plug_name)||'||chr(10)||
'       '' (''||PLUG_DISPLAY_COLUMN||'') ''||'||chr(10)||
'       PLUG_DISPLAY_SEQUENCE  plug_name, id,'||chr(10)||
'       upper(plug_name) pn, 2 x'||chr(10)||
'from wwv_flow_page_plugs p'||chr(10)||
'where flow_id = :FB_FLOW_ID and page_id = 0 and :fb_flow_page_id != 0'||chr(10)||
'order by 4,3) v');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_pages
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 313088181.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST PAGES',
  p_lov_query=> 'select id||'' ''||name n, id'||chr(10)||
'from wwv_flow_steps'||chr(10)||
'where flow_id = :FB_FLOW_ID and security_group_id = :flow_security_group_id'||chr(10)||
'order by 2');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_pages_escaped
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 375967232722946469.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST PAGES ESCAPED',
  p_lov_query=> 'select id||'' ''||htf.escape_sc(name) n, id'||chr(10)||
'from wwv_flow_steps'||chr(10)||
'where flow_id = :FB_FLOW_ID and security_group_id = :flow_security_group_id'||chr(10)||
'order by 2');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_pagetemplates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 4569556776.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST PAGETEMPLATES',
  p_lov_query=> 'select htf.escape_sc(name) name, id'||chr(10)||
'from   wwv_flow_templates'||chr(10)||
'where  flow_id = :FB_FLOW_ID and'||chr(10)||
'       (:fb_theme_id is null or theme_id = :fb_theme_id)'||chr(10)||
'order  by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_theme_class_id
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST THEME CLASS ID',
  p_lov_query=> '.'||to_char(43918610013174571 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43918904551174576.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista verticale non ordinata con punti',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43919114507174577.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista verticale ordinata',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43919317508174577.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista orizzontale di collegamenti',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43919513966174577.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista orizzontale di immagini con etichetta',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43919702448174577.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista verticale di immagini',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43919925901174577.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista di pulsanti',
  p_lov_return_value=>'6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43920119551174578.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista di navigazione a schede',
  p_lov_return_value=>'7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43935130193237152.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista di avanzamento procedura guidata',
  p_lov_return_value=>'17',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>58168303369425651.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista verticale non ordinata senza punti',
  p_lov_return_value=>'18',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>111810925131441282.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Menu a discesa',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>111811229980442636.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Menu a discesa con immagine',
  p_lov_return_value=>'21',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>165320913369513737.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista verticale con barra laterale',
  p_lov_return_value=>'19',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43920508983174578.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 1',
  p_lov_return_value=>'9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43920717140174578.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 2',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43920901196174579.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 3',
  p_lov_return_value=>'11',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43921121313174579.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 4',
  p_lov_return_value=>'12',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43921328149174579.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 5',
  p_lov_return_value=>'13',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43921510615174579.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 6',
  p_lov_return_value=>'14',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43921731720174580.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 7',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43922216940176602.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 8',
  p_lov_return_value=>'16',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>172045731559260808.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Espansione gerarchica',
  p_lov_return_value=>'22',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>172048114721265462.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43918610013174571.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>22,
  p_lov_disp_value=>'Espansione gerarchica',
  p_lov_return_value=>'23',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_ldap_hosts
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 159071014187759020.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST.LDAP.HOSTS',
  p_lov_query=> 'select distinct ldap_host a, ldap_host b from wwv_flow_custom_auth_setups where ldap_host is not null and security_group_id=:flow_security_group_id order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_ldap_ports
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 159071623191761652.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST.LDAP.PORTS',
  p_lov_query=> 'select distinct ldap_port a, ldap_port b from wwv_flow_custom_auth_setups where ldap_port is not null and security_group_id=:flow_security_group_id order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_ldap_strings
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 159072229424763439.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST.LDAP.STRINGS',
  p_lov_query=> 'select distinct ldap_string a, ldap_string b from wwv_flow_custom_auth_setups where ldap_string is not null and security_group_id=:flow_security_group_id order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_ldap_username_edit
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 159073420552770275.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST.LDAP.USERNAME.EDIT',
  p_lov_query=> 'select distinct attribute_01 a, attribute_01 b from wwv_flow_custom_auth_setups where attribute_01 is not null and security_group_id=:flow_security_group_id'||chr(10)||
''||chr(10)||
'union select ''return wwv_flow_custom_auth_std.ldap_dnprep;'' a, ''return wwv_flow_custom_auth_std.ldap_dnprep;'' b from dual order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_security_schemes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 166867621769552393.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST.SECURITY.SCHEMES',
  p_lov_query=> 'select htf.escape_sc(name) name, to_char(id) id'||chr(10)||
'from wwv_flow_security_schemes'||chr(10)||
'where flow_id = :fb_flow_id'||chr(10)||
'union all'||chr(10)||
'select ''MUST_NOT_BE_PUBLIC_USER'' name,''MUST_NOT_BE_PUBLIC_USER'' id'||chr(10)||
'from dual'||chr(10)||
'order by name');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_web_services
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 156841902941139735.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST.WEB.SERVICES',
  p_lov_query=> 'select htf.escape_sc(name) d, id r from wwv_flow_shared_web_services'||chr(10)||
''||chr(10)||
'where security_group_id = :flow_security_group_id and'||chr(10)||
''||chr(10)||
'      flow_id = :fb_flow_id'||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/listallitems
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 598060166.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LISTALLITEMS',
  p_lov_query=> 'select wwv_flow_lang.system_message(''CONFIRM.APPLICATION'')||'||chr(10)||
''': ''||htf.escape_sc(name) a, name b '||chr(10)||
'from wwv_flow_items'||chr(10)||
'where flow_id = :FB_FLOW_ID'||chr(10)||
'union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''PAGE''))||'||chr(10)||
''': ''||flow_step_id||'': ''||htf.escape_sc(name) a, name b'||chr(10)||
''||chr(10)||
'from wwv_flow_step_items'||chr(10)||
''||chr(10)||
'where flow_id = :FB_FLOW_ID'||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/lists
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 158508012343182689.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LISTS',
  p_lov_query=> 'select htf.escape_sc(name) d, id from wwv_flow_lists where flow_id = :FB_FLOW_ID order by upper(name)');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_available_schemas
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 304941591413.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_AVAILABLE_SCHEMAS',
  p_lov_query=> 'select htf.escape_sc(schema) a, schema b'||chr(10)||
'from   wwv_flow_company_schemas'||chr(10)||
'where  security_group_id = :flow_security_group_id'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_available_schemas2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 64000716365052273.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_AVAILABLE_SCHEMAS2',
  p_lov_query=> 'select htf.escape_sc(c.schema) d, c.schema r'||chr(10)||
''||chr(10)||
'from   wwv_flow_company_schemas c,'||chr(10)||
''||chr(10)||
'       wwv_flow_fnd_user u'||chr(10)||
''||chr(10)||
'where  c.security_group_id = :flow_security_group_id and'||chr(10)||
''||chr(10)||
'       u.security_group_id = :flow_security_group_id and'||chr(10)||
''||chr(10)||
'       u.user_name = :flow_user and'||chr(10)||
''||chr(10)||
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or    instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0)'||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_button_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 62093031232114360.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_BUTTON_TEMPLATES',
  p_lov_query=> 'select htf.escape_sc(name) d, id r'||chr(10)||
'from   wwv_flow_templates_all'||chr(10)||
'where temp_type = ''BUTTON'''||chr(10)||
'and flow_id = :fb_flow_id and'||chr(10)||
'    (:fb_theme_id is null or theme_id = :fb_theme_id)'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_calendar_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 62098012232137239.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_CALENDAR_TEMPLATES',
  p_lov_query=> 'select htf.escape_sc(name) d, id r'||chr(10)||
'from   wwv_flow_templates_all'||chr(10)||
'where temp_type = ''CALENDAR'''||chr(10)||
'and flow_id = :fb_flow_id and'||chr(10)||
'    (:fb_theme_id is null or theme_id = :fb_theme_id)'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_flow_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 634347472712995.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_FLOW_STATUS',
  p_lov_query=> '.'||to_char(634347472712995 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88157618253966938.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>634347472712995.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Disponibile',
  p_lov_return_value=>'AVAILABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88157826171966938.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>634347472712995.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Disponibile con collegamenti di modifica',
  p_lov_return_value=>'AVAILABLE_W_EDIT_LINK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88158015347966939.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>634347472712995.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Disponibile solo per gli sviluppatori',
  p_lov_return_value=>'DEVELOPERS_ONLY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88158201893966939.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>634347472712995.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Accesso limitato',
  p_lov_return_value=>'RESTRICTED_ACCESS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88158430795966939.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>634347472712995.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Non disponibile',
  p_lov_return_value=>'UNAVAILABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88158618218966939.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>634347472712995.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Non disponibile (stato mostrato con PL/SQL)',
  p_lov_return_value=>'UNAVAILABLE_PLSQL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88158822851966939.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>634347472712995.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Non disponibile (reindirizzamento a URL)',
  p_lov_return_value=>'UNAVAILABLE_URL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_label_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 62099525391141046.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_LABEL_TEMPLATES',
  p_lov_query=> 'select htf.escape_sc(name) d, id r'||chr(10)||
'from   wwv_flow_templates_all'||chr(10)||
'where temp_type = ''LABEL'''||chr(10)||
'and flow_id = :fb_flow_id and'||chr(10)||
'    (:fb_theme_id is null or theme_id = :fb_theme_id)'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_list_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 62101404051144326.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_LIST_TEMPLATES',
  p_lov_query=> 'select htf.escape_sc(name) d, id r'||chr(10)||
'from   wwv_flow_templates_all'||chr(10)||
'where temp_type = ''LIST'''||chr(10)||
'and flow_id = :fb_flow_id and'||chr(10)||
'    (:fb_theme_id is null or theme_id = :fb_theme_id)'||chr(10)||
'order by upper(name)');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_menu_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 62102615133147515.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_MENU_TEMPLATES',
  p_lov_query=> 'select htf.escape_sc(name) d, id r'||chr(10)||
'from   wwv_flow_templates_all'||chr(10)||
'where temp_type = ''MENU'''||chr(10)||
'and flow_id = :fb_flow_id and'||chr(10)||
'    (:fb_theme_id is null or theme_id = :fb_theme_id)'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_page_items
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 5818802865968207.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_PAGE_ITEMS',
  p_lov_query=> 'select initcap(wwv_flow_lang.system_message(''APPLICATION''))||'||chr(10)||
''':''||name a, name b '||chr(10)||
'from wwv_flow_items'||chr(10)||
'where flow_id = :FB_FLOW_ID'||chr(10)||
'union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''PAGE''))||'||chr(10)||
''': ''||flow_step_id||'': ''||name a, name b'||chr(10)||
''||chr(10)||
'from wwv_flow_step_items'||chr(10)||
''||chr(10)||
'where flow_id = :FB_FLOW_ID'||chr(10)||
''||chr(10)||
'and flow_step_id = :FB_FLOW_PAGE_ID'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_page_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 62094620627120744.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_PAGE_TEMPLATES',
  p_lov_query=> 'select htf.escape_sc(name) d, id r'||chr(10)||
'from   wwv_flow_templates_all'||chr(10)||
'where temp_type = ''PAGE'''||chr(10)||
'and flow_id = :fb_flow_id and'||chr(10)||
'    (:fb_theme_id is null or theme_id = :fb_theme_id)'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_parent_tabsets
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 130412625318.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_PARENT_TABSETS',
  p_lov_query=> 'select distinct htf.escape_sc(tab_set) d, tab_set r from wwv_flow_toplevel_tabs where flow_id = :fb_flow_id order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_patches
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 198057397.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_PATCHES',
  p_lov_query=> 'select htf.escape_sc(patch_name) pn, id'||chr(10)||
'from wwv_flow_patches'||chr(10)||
'where flow_id = :FB_FLOW_ID'||chr(10)||
'union all'||chr(10)||
'select ''{''||wwv_flow_lang.system_message(''NOT_W_ARGUMENT'', htf.escape_sc(patch_name))||'||chr(10)||
'''} '' pn,0-id id'||chr(10)||
'from   wwv_flow_patches'||chr(10)||
'where flow_id = :FB_FLOW_ID'||chr(10)||
'order by pn');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_plug_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 32361488916.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_PLUG_TYPES',
  p_lov_query=> 'select D,R from('||chr(10)||
'select wwv_flow_lang.system_message(''DYNAMIC_QUERY'') D, ''DYNAMIC_QUERY'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''SQL_QUERY'') D, ''SQL_QUERY'' R,1 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''SQL_QUERY'')||'' (''||initcap(wwv_flow_lang.system_message(''STRUCTURED_QUERY''))||'')'' D, ''STRUCTURED_QUERY'' R,1 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''SQL_QUERY'')||'' (''||wwv_flow_lang.system_message(''FUNCTION_BODY_RETURNING_QUERY'')||'')'' D,''FUNCTION_RETURNING_SQL_QUERY'' R,1 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''HTML_TEXT'') D, ''STATIC_TEXT'' R,1 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''PLSQL_PROCEDURE'')||'' (''||wwv_flow_lang.system_message(''ANONYMOUS_BLOCK'')||'')'' D, ''PLSQL_PROCEDURE'' R,1 OB from dual'||chr(10)||
' union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''WEB_SERVICE_RESULT'')) D,''WEB_SERVICE'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''HELP_TEXT'')) D, ''HELP_TEXT'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''CHART''))||'' (''||wwv_flow_lang.system_message(''HTML'')||'') ''||wwv_flow_lang.system_message(''CHART'') D, ''SIMPLE_CHART'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''CHART''))||'' (SVG)'' D, ''SVG_CHART'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''HTML_TEXT'')||'' (''||wwv_flow_lang.system_message(''ESCAPE_SC'')||'')'' D, ''STATIC_TEXT_ESCAPE_SC'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''HTML_TEXT'')||'' (''||wwv_flow_lang.system_message(''WITH_SHORTCUTS'')||'')'' D, ''STATIC_TEXT_WITH_SHORTCUTS'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''SQL_QUERY'')||'' (''||wwv_flow_lang.system_message(''UPDATEABLE_REPORT'')||'')'' D, ''UPDATABLE_SQL_QUERY'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''URL'') D, ''URL'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select upper(wwv_flow_lang.system_message(''TREE'')) D, ''TREE'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''CALENDAR_TYPE'') D, ''CALENDAR'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''CALENDAR_EASY_TYPE'') D, ''EASY_CALENDAR'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select ''___________________________________________________'' D,''FLOWS_DIVIDER'' R,4 OB from dual'||chr(10)||
' union all'||chr(10)||
'select upper(wwv_flow_lang.system_message(''LIST''))||'': ''||htf.escape_sc(name) D, to_char(id) R,5 OB from wwv_flow_lists where flow_id = :FB_FLOW_ID'||chr(10)||
' union all'||chr(10)||
'select upper(wwv_flow_lang.system_message(''MENU''))||'': ''||htf.escape_sc(name) D, ''M''||id R,5 OB'||chr(10)||
'from wwv_flow_menus where flow_id = :fb_flow_id'||chr(10)||
'order by 1)'||chr(10)||
'order by OB');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_region_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 62103530370151962.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_REGION_TEMPLATES',
  p_lov_query=> 'select theme_id||''. ''||htf.escape_sc(name) d, id r'||chr(10)||
'from   wwv_flow_templates_all'||chr(10)||
'where temp_type = ''REGION'''||chr(10)||
'and flow_id = :fb_flow_id  and'||chr(10)||
'    (:fb_theme_id is null or theme_id = :fb_theme_id)'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_report_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 62104811455155975.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_REPORT_TEMPLATES',
  p_lov_query=> 'select theme_id||''. ''||htf.escape_sc(name) d, id r'||chr(10)||
'from   wwv_flow_templates_all'||chr(10)||
'where temp_type = ''REPORT'''||chr(10)||
'and flow_id = :fb_flow_id and'||chr(10)||
'    (:fb_theme_id is null or theme_id = :fb_theme_id)'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_schema
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 385522518549261442.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_SCHEMA',
  p_lov_query=> 'select htf.escape_sc(owner) d, owner v'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_schemas_have_privs
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 77465221343784725.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_SCHEMAS_HAVE_PRIVS',
  p_lov_query=> 'select htf.escape_sc(owner) d, owner v'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select distinct(htf.escape_sc(owner)) d, owner v'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID) ');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_tabsets
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 130408529381.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_TABSETS',
  p_lov_query=> 'select htf.escape_sc(d) d, r from wwv_flow_tabset_view');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_template_wiz
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86596530905253701.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_TEMPLATE_WIZ',
  p_lov_query=> '.'||to_char(86596530905253701 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88297313984807785.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86596530905253701.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Scegliere una voce dal repository di &PRODUCT_NAME..',
  p_lov_return_value=>'DEFAULT',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88297514924807786.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86596530905253701.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Completamente nuovo/a',
  p_lov_return_value=>'BLANK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88297709869807786.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86596530905253701.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Come copia di un modello esistente',
  p_lov_return_value=>'COPY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_trees
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 42828313831634427.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_TREES',
  p_lov_query=> 'select htf.escape_sc(tree_name)||'' (''||initcap(tree_type)||'')'' d,'||chr(10)||
''||chr(10)||
'       id'||chr(10)||
''||chr(10)||
'from   wwv_flow_trees'||chr(10)||
''||chr(10)||
'where  flow_id = :fb_flow_id and'||chr(10)||
''||chr(10)||
'       security_group_id = :flow_security_group_id'||chr(10)||
''||chr(10)||
'order  by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/load_option
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 23167623084310745.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LOAD.OPTION',
  p_lov_query=> '.'||to_char(23167623084310745 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23167918354310752.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>23167623084310745.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Carica file separato da virgole (*.csv) o delimitato da tabulazioni',
  p_lov_return_value=>'UPLOAD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23168101104310756.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>23167623084310745.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Copia e incolla',
  p_lov_return_value=>'PASTE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/load_data_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 23733127290776847.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LOAD_DATA_TYPES',
  p_lov_query=> '.'||to_char(23733127290776847 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23733404759776862.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>23733127290776847.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'NUMBER',
  p_lov_return_value=>'NUMBER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23733619464776862.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>23733127290776847.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'VARCHAR2',
  p_lov_return_value=>'VARCHAR2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23733832697776862.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>23733127290776847.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'DATE',
  p_lov_return_value=>'DATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23734009833776862.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>23733127290776847.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'CLOB',
  p_lov_return_value=>'CLOB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23734214688776863.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>23733127290776847.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'BINARY_FLOAT',
  p_lov_return_value=>'BINARY_FLOAT',
  p_lov_disp_cond_type=>'FUNCTION_BODY',
  p_lov_disp_cond=> 'return wwv_flow_utilities.db_version_is_at_least(''10.1'');',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23734413485776863.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>23733127290776847.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'BINARY_DOUBLE',
  p_lov_return_value=>'BINARY_DOUBLE',
  p_lov_disp_cond_type=>'FUNCTION_BODY',
  p_lov_disp_cond=> 'return wwv_flow_utilities.db_version_is_at_least(''10.1'');',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/lock_status_report_values
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 37430113453704739.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LOCK STATUS REPORT VALUES',
  p_lov_query=> '.'||to_char(37430113453704739 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>37430310670704743.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>37430113453704739.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Tutte le pagine',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>37430529682704745.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>37430113453704739.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Pagine bloccate',
  p_lov_return_value=>'LOCKED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>37430723675704745.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>37430113453704739.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Pagine sbloccate',
  p_lov_return_value=>'UNLOCKED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/login_page_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86589528912234244.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LOGIN_PAGE_TYPE',
  p_lov_query=> 'select d,r from ('||chr(10)||
'    select initcap('||chr(10)||
'wwv_flow_lang.system_message(''USE_PAGE_AS_LOGIN_PAGE'',id)) d, ''LOGIN'' r, 4 ob from wwv_flow_steps where flow_id=:FB_FLOW_ID and upper(alias) = ''LOGIN'''||chr(10)||
'  union all'||chr(10)||
'    select initcap('||chr(10)||
'wwv_flow_lang.system_message(''CREATE_NEW_LOGIN_PAGE'')) d, ''CREATE'' r,2 ob from dual where'||chr(10)||
'not exists (select 1 from wwv_flow_steps where flow_id=:FB_FLOW_ID and upper(alias) = ''LOGIN'')'||chr(10)||
'  union all'||chr(10)||
'    select initcap('||chr(10)||
'wwv_flow_lang.system_message(''USE_BUILTIN_LOGIN_PAGE''))  d,''-BUILTIN-'' r, 9 ob from dual)'||chr(10)||
'order by ob');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/lov_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84909926183685150.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LOV.TYPE',
  p_lov_query=> '.'||to_char(84909926183685150 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84910101277685150.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84909926183685150.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Dinamico',
  p_lov_return_value=>'DYNAMIC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84910313696685150.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84909926183685150.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Statico',
  p_lov_return_value=>'STATIC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/lov_translated
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86578518083174290.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LOV_TRANSLATED',
  p_lov_query=> '.'||to_char(86578518083174290 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88298317101808717.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86578518083174290.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Sì',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/lov_wiz_lov
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84344914743638898.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LOV_WIZ_LOV',
  p_lov_query=> '.'||to_char(84344914743638898 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88299120564809761.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84344914743638898.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Completamente nuovo/a',
  p_lov_return_value=>'BLANK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88299310826809761.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84344914743638898.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Come copia di una lista di valori esistente',
  p_lov_return_value=>'COPY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/lanugagecodes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 61396703881.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LanugageCodes',
  p_lov_query=> 'select translation_flow_language_code'||chr(10)||
''||chr(10)||
'from   wwv_flow_language_map'||chr(10)||
''||chr(10)||
'where  primary_language_flow_id = :FB_FLOW_ID'||chr(10)||
''||chr(10)||
'order  by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/manage_dev_pref_view_mode
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 93546719421230687.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MANAGE_DEV_PREF_VIEW_MODE',
  p_lov_query=> '.'||to_char(93546719421230687 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93546924483230689.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93546719421230687.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Icone',
  p_lov_return_value=>'ICON',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>93547106760230689.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>93546719421230687.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Dettagli',
  p_lov_return_value=>'DETAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/marker_style
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84879717151455385.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MARKER_STYLE',
  p_lov_query=> '.'||to_char(84879717151455385 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84879905128455386.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84879717151455385.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Cerchio',
  p_lov_return_value=>'CIRCLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84880123391455386.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84879717151455385.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Rombo',
  p_lov_return_value=>'DIAMOND',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84880312259455387.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84879717151455385.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Quadrato',
  p_lov_return_value=>'SQUARE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84880528001455387.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84879717151455385.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Triangolo',
  p_lov_return_value=>'TRIANGLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/maximum_rows_per_page
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84800803131139158.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAXIMUM ROWS PER PAGE',
  p_lov_query=> '.'||to_char(84800803131139158 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>180345125591578775.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84800803131139158.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84801031902139159.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84800803131139158.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84801207012139159.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84800803131139158.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84801406447139159.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84800803131139158.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84801631719139159.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84800803131139158.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'25',
  p_lov_return_value=>'25',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>239238717004567042.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84800803131139158.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>45,
  p_lov_disp_value=>'30',
  p_lov_return_value=>'30',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84801809006139160.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84800803131139158.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84802017106139160.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84800803131139158.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'75',
  p_lov_return_value=>'75',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84802230048139160.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84800803131139158.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84802410431139160.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84800803131139158.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84802619722139161.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84800803131139158.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84802809542139161.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84800803131139158.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'5000',
  p_lov_return_value=>'5000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/menu_theme_class_id
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 43945521366272493.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MENU THEME CLASS ID',
  p_lov_query=> '.'||to_char(43945521366272493 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43945822796272497.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43945521366272493.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Indicatore di percorso',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43946021659272497.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43945521366272493.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Gerarchico',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43946200038272497.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43945521366272493.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 1',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43946403201272498.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43945521366272493.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 2',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43946615168272498.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43945521366272493.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 3',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43946827418272498.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43945521366272493.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 4',
  p_lov_return_value=>'6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43947018619272498.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43945521366272493.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 5',
  p_lov_return_value=>'7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43947229068272498.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43945521366272493.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 6',
  p_lov_return_value=>'8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43947419430272499.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43945521366272493.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 7',
  p_lov_return_value=>'9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>43947619554272499.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>43945521366272493.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 8',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/menu_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 146659516889284778.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MENU.TEMPLATES',
  p_lov_query=> 'select htf.escape_sc(name) d, id'||chr(10)||
'  from wwv_flow_menu_templates'||chr(10)||
' where flow_id = :fb_flow_id and'||chr(10)||
'    (:fb_theme_id is null or theme_id = :fb_theme_id)'||chr(10)||
'order by upper(name)');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/menu_start_with
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84876111826444446.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MENU_START_WITH',
  p_lov_query=> '.'||to_char(84876111826444446 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84876328851444446.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84876111826444446.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Voci di indicatore di percorso figlio',
  p_lov_return_value=>'CHILD_MENU',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84876509333444446.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84876111826444446.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Indicatore di percorso corrente',
  p_lov_return_value=>'CURRENT_MENU',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84876719009444447.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84876111826444446.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Voci di indicatore di percorso padre',
  p_lov_return_value=>'PARENT_MENU',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84876912643444447.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84876111826444446.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Padre per foglia (stile con indicatori di percorso)',
  p_lov_return_value=>'PARENT_TO_LEAF',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/menu_template_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86077012626803751.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MENU_TEMPLATE_TYPE',
  p_lov_query=> '.'||to_char(86077012626803751 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88299923681810664.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86077012626803751.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Completamente nuovo/a',
  p_lov_return_value=>'BLANK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88300108885810665.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86077012626803751.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Come copia di un modello esistente',
  p_lov_return_value=>'COPY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/model_users
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 240554501608741323.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MODEL USERS',
  p_lov_query=> 'select distinct htf.escape_sc(m.created_by) d, m.created_by r'||chr(10)||
'from wwv_flow_models m, wwv_flow_model_pages p, wwv_flow_company_schemas s'||chr(10)||
'where m.id = p.model_id '||chr(10)||
'and   m.owner = s.schema'||chr(10)||
'and m.security_group_id = :flow_security_group_id'||chr(10)||
'and s.security_group_id = :flow_security_group_id'||chr(10)||
'and m.model_complete = ''Y'''||chr(10)||
'group by m.created_by');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/model_link_extra_column
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 148927707220116911.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MODEL_LINK_EXTRA_COLUMN',
  p_lov_query=> '.'||to_char(148927707220116911 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>148928000552116912.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>148927707220116911.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Utilizzare colonna supplementare per visualizzare il collegamento',
  p_lov_return_value=>'LINK_COLUMN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/model_link_to_page
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 152446125589862819.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MODEL_LINK_TO_PAGE',
  p_lov_query=> '.'||to_char(152446125589862819 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>152446325930862821.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>152446125589862819.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Pulsante di modifica specifico del tema',
  p_lov_return_value=>'LINK_COLUMN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>147361702073726841.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>152446125589862819.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Colonna report',
  p_lov_return_value=>'REPORT_COLUMN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>147371230863763536.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>152446125589862819.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Collegamento personalizzato',
  p_lov_return_value=>'CUSTOM_LINK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/model_page_columns
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 115831532722003349.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MODEL_PAGE_COLUMNS',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name r'||chr(10)||
'from   wwv_flow_model_page_cols'||chr(10)||
'where  model_region_id = :P483_REGION_1_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/model_parent_page_columns
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 115833306665014717.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MODEL_PARENT_PAGE_COLUMNS',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name r'||chr(10)||
'from   wwv_flow_model_page_cols  s'||chr(10)||
'where  model_region_id in ('||chr(10)||
'   select id from wwv_flow_model_page_regions'||chr(10)||
'   where model_page_id in ('||chr(10)||
'        select id '||chr(10)||
'        from   wwv_flow_model_pages '||chr(10)||
'        where  model_id = :P3000_MODEL_ID'||chr(10)||
'        and    id  = :P483_PARENT_PAGE_ID'||chr(10)||
'))'||chr(10)||
'and column_name not like ''LINK$%''');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/model_use_theme_button
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 153128814386643499.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MODEL_USE_THEME_BUTTON',
  p_lov_query=> '.'||to_char(153128814386643499 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>153129027237643499.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>153128814386643499.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Utilizzare pulsante di modifica specifico del tema.',
  p_lov_return_value=>'THEME',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/named_lov
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 5278749326.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NAMED_LOV',
  p_lov_query=> 'select htf.escape_sc(lov_name) d, lov_name r'||chr(10)||
''||chr(10)||
'from wwv_flow_lists_of_values$'||chr(10)||
''||chr(10)||
'where flow_id = :FB_FLOW_ID'||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/named_lov_returning_id
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 73045019699242595.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NAMED_LOV_RETURNING_ID',
  p_lov_query=> 'select htf.escape_sc(lov_name) d, id'||chr(10)||
''||chr(10)||
'from wwv_flow_lists_of_values$'||chr(10)||
''||chr(10)||
'where flow_id = :FB_FLOW_ID'||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/nav_bar_create_method
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84245132593407471.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NAV_BAR_CREATE_METHOD',
  p_lov_query=> '.'||to_char(84245132593407471 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88302321041819363.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84245132593407471.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Completamente nuovo/a',
  p_lov_return_value=>'BLANK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88302522891819363.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84245132593407471.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Come copia di una barra di navigazione esistente',
  p_lov_return_value=>'COPY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/new
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 41348803113175334.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NEW',
  p_lov_query=> '.'||to_char(41348803113175334 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41353729217192272.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41348803113175334.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Nuova pagina',
  p_lov_return_value=>'PAGE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:259:&SESSION.:::359"><img src="#IMAGE_PREFIX#menu/wiz_blank_140x90.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41349526190175350.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41348803113175334.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Area in questa pagina',
  p_lov_return_value=>'COMPLETE_PAGE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:181:&SESSION.:::181,259,380,311"><img src="#IMAGE_PREFIX#menu/wiz_add_region_140x90.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41349127275175345.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41348803113175334.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Controllo pagina in questa pagina',
  p_lov_return_value=>'COMPONENT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:323:&SESSION."><img src="#IMAGE_PREFIX#menu/wiz_add_comp_140x90.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41349322741175350.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41348803113175334.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Controllo condiviso',
  p_lov_return_value=>'FLOWC',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:364:&SESSION.:::4051"><img src="#IMAGE_PREFIX#menu/wiz_add_shared_140x90.gif"  class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/new_complete_component_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 41356314934207078.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NEW COMPLETE COMPONENT TYPE',
  p_lov_query=> '.'||to_char(41356314934207078 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41356624231207078.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41356314934207078.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Report',
  p_lov_return_value=>'REPORT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:340:&SESSION."><img src="#IMAGE_PREFIX#htmldb/builder/report_component_xl.gif" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcon" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41356800228207079.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41356314934207078.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Grafico',
  p_lov_return_value=>'CHART',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:376:&SESSION."><img src="#IMAGE_PREFIX#htmldb/builder/chart_component_xl.gif" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcon" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41357026339207079.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41356314934207078.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Form',
  p_lov_return_value=>'FORM',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:362:&SESSION."><img src="#IMAGE_PREFIX#htmldb/builder/form_component_xl.gif" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcon" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41357218026207079.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41356314934207078.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Procedura guidata',
  p_lov_return_value=>'WIZARD',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:107:&SESSION.:::107:P259_CHOOSE_PAGE_TYPE:WIZARD"><img src="#IMAGE_PREFIX#htmldb/builder/wizard_component_xl.gif" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcon" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41357405618207080.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41356314934207078.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Struttura',
  p_lov_return_value=>'TREE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:112:&SESSION."><img src="#IMAGE_PREFIX#htmldb/builder/tree_component_xl.gif" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcon" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5506713528615273.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41356314934207078.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Calendario',
  p_lov_return_value=>'CALENDAR',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:2001:&SESSION.::::P4016_SOURCE_TYPE:CALENDAR"><img src="#IMAGE_PREFIX#htmldb/builder/calendar_component_xl.gif" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcon" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/new_chart_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 55790009724772171.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NEW.CHART.TYPES',
  p_lov_query=> '.'||to_char(55790009724772171 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>55790324691772172.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>55790009724772171.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'SVG',
  p_lov_return_value=>'SVG',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:311:&SESSION.::NO:311,312,313,314:F4000_P311_PAGE_ID:&FB_FLOW_PAGE_ID."><img src="#IMAGE_PREFIX#htmldb/builder/chart_bar_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>55790501620772173.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>55790009724772171.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'HTML',
  p_lov_return_value=>'HTML',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4710:&SESSION.::NO:4710,4780,4781:F4000_P4710_FLOW_STEP_ID:&FB_FLOW_PAGE_ID."><img src="#IMAGE_PREFIX#htmldb/builder/chart_bar_html_xl.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/new_create_page_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 55956503181073146.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NEW.CREATE.PAGE.OPTIONS',
  p_lov_query=> '.'||to_char(55956503181073146 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>55956831130073149.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>55956503181073146.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Crea una pagina',
  p_lov_return_value=>'SINGLE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4714:&SESSION.:::4714,4715,4716,78,79,80,81,82,83"><img src="#IMAGE_PREFIX#htmldb/builder/blank_page_xl.gif" class="htmldbGreenIcon" height="115" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>55957017979073149.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>55956503181073146.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Creazione multipla',
  p_lov_return_value=>'MULTI',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:295:&SESSION.:CC::294"><img src="#IMAGE_PREFIX#htmldb/builder/blank_pages_xl.gif" class="htmldbGreenIcon" height="115" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/new_flow_component
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 56261603527740250.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NEW.FLOW.COMPONENT',
  p_lov_query=> '.'||to_char(56261603527740250 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56261902885740255.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>56261603527740250.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Icona della barra di navigazione',
  p_lov_return_value=>'NAVBAR',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:22:&SESSION.::NO:22,4023,4024,4025,134,135"><img src="#IMAGE_PREFIX#htmldb/builder/navbar_component_xl.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56262124240740258.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>56261603527740250.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Scheda padre',
  p_lov_return_value=>'PTAB',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4725:&SESSION.::NO:4725,4726,4727"><img src="#IMAGE_PREFIX#htmldb/builder/parenttab_component_xl.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56262327091740258.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>56261603527740250.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Scheda standard',
  p_lov_return_value=>'STAB',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:90:&SESSION.:::92,94,95,96,4722,4723,4724"><img src="#IMAGE_PREFIX#htmldb/builder/tab_component_xl.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56262512111740259.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>56261603527740250.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Lista di valori',
  p_lov_return_value=>'LOV',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:137:&SESSION.:::4004,4007,4014,137,138,139"><img src="#IMAGE_PREFIX#htmldb/builder/lov_component_xl.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56262729926740259.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>56261603527740250.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Lista',
  p_lov_return_value=>'LIST',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4051:&SESSION.::NO:4004,4007,4014,137,138,139"><img src="#IMAGE_PREFIX#htmldb/builder/list_component_xl.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56262910363740259.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>56261603527740250.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Indicatore di percorso',
  p_lov_return_value=>'MENU',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:288:&SESSION.::NO:288"><img src="#IMAGE_PREFIX#htmldb/builder/menu_component_xl.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/new_form_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 54502713568963394.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NEW.FORM.OPTIONS',
  p_lov_query=> '.'||to_char(54502713568963394 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>54503231398963400.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>54502713568963394.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Tabella',
  p_lov_return_value=>'TABLE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:453:&SESSION.::NO:4708,4709,4713,4771,4772,4773,4774,4784,442:F4000_P4708_PAGE_ID:&FB_FLOW_PAGE_ID."><img src="#IMAGE_PREFIX#menu/wiz_form_140x90.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcon" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>54503000905963398.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>54502713568963394.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Form tabulare',
  p_lov_return_value=>'GRID',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:29:&SESSION.:::29,30,31,32,33,50,51,52,53,97,326:F4000_P33_PAGE:&FB_FLOW_PAGE_ID.:"><img src="#IMAGE_PREFIX#menu/wiz_tab_form_140x90.gif" class="htmldbGreenIcon" alt="#DISPLAY_VALUE#" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>54503606699963400.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>54502713568963394.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Argomenti di procedura',
  p_lov_return_value=>'PROCEDURE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4711:&SESSION.:::4711,192,193,4712,4705,4702,4706,4660,SP_WIZARD:F4000_P4705_PAGE_ID:&FB_FLOW_PAGE_ID."><img src="#IMAGE_PREFIX#menu/wiz_form_140x90.gif" class="htmldbGreenIcon" alt="#DISPLAY_VALUE#" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>54504002196963401.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>54502713568963394.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Form con report',
  p_lov_return_value=>'FORM_WITH_REPORT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4703:&SESSION.::NO:4703,4040,4041,4775,4039,4776,4777,4778,4779,4782,4783,443:F4000_P4703_REPORT_PAGE_ID:&FB_FLOW_PAGE_ID."><img src="#IMAGE_PREFIX#menu/wiz_form_and_report_140x90.gif" class="htmldbGreenIcon" alt="#DISPLAY_VALUE#" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>54503811384963401.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>54502713568963394.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Query SQL (recupero riga)',
  p_lov_return_value=>'SQL',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4810:&SESSION.::NO:4810,4811,4812,4813,4814:F4000_P4810_PAGE_ID:&FB_FLOW_PAGE_ID."><img src="#IMAGE_PREFIX#menu/wiz_form_140x90.gif" class="htmldbGreenIcon" alt="#DISPLAY_VALUE#" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>54504218829963402.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>54502713568963394.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Sola visualizzazione su elementi esistenti',
  p_lov_return_value=>'SUMMARY',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:5100:&SESSION.::NO:5100,5105,5110,303,304,SUMMARY_ITEM:F4000_P5100_PAGE_ID:&FB_FLOW_PAGE_ID."><img src="#IMAGE_PREFIX#menu/wiz_summary_140x90.gif" class="htmldbGreenIcon" alt="#DISPLAY_VALUE#" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>185043227012215310.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>54502713568963394.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Master-Detail',
  p_lov_return_value=>'MASTER_DETAIL',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4:&SESSION.::NO:4,5,11,12,15,18,24,25,35,293,155,507,508,MASTER_COLUMNS,DETAIL_COLUMNS,LINK_MASTER_DETAIL,LINK_MASTER_DETAIL_TEMP,CONDITIONS,JOINS::"><img src="#IMAGE_PREFIX#menu/wiz_md_140x90.gif" class="htmldbGreenIcon" alt="#DISPLAY_VALUE#" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>202747215734446805.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>54502713568963394.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Form su servizio Web',
  p_lov_return_value=>'FORM_ON_WEB_SERVICE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:600:&SESSION.::NO:600,605,610,615,620,625,630,635,640::"><img src="#IMAGE_PREFIX#menu/wiz_form_onws_140x90.gif" class="htmldbGreenIcon" alt="#DISPLAY_VALUE#" width="140" height="90" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>202747707900454045.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>54502713568963394.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Form e report su servizio Web',
  p_lov_return_value=>'FORM_ON_WEB_SERVICE_RPT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:700:&SESSION.::NO:700,705,710,715,720,725,730,735,750::"><img src="#IMAGE_PREFIX#menu/wiz_form_and_report_onws_140x90.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/new_page_component_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 55966712494123138.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NEW.PAGE.COMPONENT.TYPES',
  p_lov_query=> '.'||to_char(55966712494123138 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>55967021604123139.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>55966712494123138.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area',
  p_lov_return_value=>'REGION',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:181:&SESSION.::NO:4016,4017,4018"><img src="#IMAGE_PREFIX#htmldb/builder/region_component_xl.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>55967204428123139.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>55966712494123138.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Elemento',
  p_lov_return_value=>'ITEM',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:366:&SESSION.::NO:4717,4718,4719,4720,4721"><img src="#IMAGE_PREFIX#htmldb/builder/label_component_xl.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>55967628285123140.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>55966712494123138.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Pulsante',
  p_lov_return_value=>'BUTTON',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:167:&SESSION.:::379,4731,190,4732,4733,4019"><img src="#IMAGE_PREFIX#htmldb/builder/button_component_xl.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>55967422140123139.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>55966712494123138.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Diramazione',
  p_lov_return_value=>'BRANCH',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4728:&SESSION.::NO:4728,4729,4730"><img src="#IMAGE_PREFIX#htmldb/builder/branch_component_xl.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>55967827403123140.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>55966712494123138.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Calcolo',
  p_lov_return_value=>'COMPUTATION',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4026:&SESSION.:::4015,4026,4021,4022"><img src="#IMAGE_PREFIX#htmldb/builder/computation_component_xl.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>55968021272123140.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>55966712494123138.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Processo',
  p_lov_return_value=>'PROCESS',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:230:&SESSION.::NO:4734,4735,4736,4020"><img src="#IMAGE_PREFIX#htmldb/builder/process_component_xl.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>55968210751123141.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>55966712494123138.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Convalida',
  p_lov_return_value=>'VALIDATION',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:248:&SESSION.::NO:91,4737,4738,4739"><img src="#IMAGE_PREFIX#htmldb/builder/validation_component_xl.gif" class="htmldbGreenIcon" width="140" height="90" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/new_report_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 55623328013247641.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NEW.REPORT.TYPES',
  p_lov_query=> '.'||to_char(55623328013247641 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>55623609165247643.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>55623328013247641.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Report procedura guidata',
  p_lov_return_value=>'WIZARD',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:355:&SESSION.::NO:355,452,470,356,455,457,462,456:P355_PAGE:&FB_FLOW_PAGE_ID."><img src="#IMAGE_PREFIX#htmldb/builder/report_easy_xl.gif" class="htmldbGreenIcon" alt="Create a Report using Query Builder" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>55623823477247644.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>55623328013247641.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Report SQL',
  p_lov_return_value=>'SQL',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4701:&SESSION.:::4701,99,335,4795,4796,327,16:F4000_P4701_FLOW_STEP_ID:&FB_FLOW_PAGE_ID."><img src="#IMAGE_PREFIX#htmldb/builder/report_sql_xl.gif" class="htmldbGreenIcon" alt="Create a Report based on a Custom SQL Query" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>55624018649247644.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>55623328013247641.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Report con form',
  p_lov_return_value=>'FORM_WITH_REPORT',
  p_lov_template=>'#DISPLAY_VALUE#<br ><a href="f?p=4000:4703:&SESSION.:::4703,4040,4041,4775,4039,4776,4777,4778,4779,4782,4783:F4000_P4703_REPORT_PAGE_ID:&FB_FLOW_PAGE_ID."><img src="#IMAGE_PREFIX#htmldb/builder/report_with_form_xl.gif" class="htmldbGreenIcon" alt= "Create a Report with a Linked Form" width="140" height="115" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/no_show_success_in_future
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84732526223887360.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NO_SHOW_SUCCESS_IN_FUTURE',
  p_lov_query=> '.'||to_char(84732526223887360 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84732711793887361.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84732526223887360.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Non mostrare la pagina di operazioni riuscite in futuro',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/object_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 277431029384153056.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'OBJECT.TYPES',
  p_lov_query=> '.'||to_char(277431029384153056 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>277431204230153061.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>277431029384153056.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Funzione',
  p_lov_return_value=>'FUNCTION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>277431400869153065.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>277431029384153056.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Indice',
  p_lov_return_value=>'INDEX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>277431613646153065.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>277431029384153056.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Package',
  p_lov_return_value=>'PACKAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>277431823408153065.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>277431029384153056.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Procedura',
  p_lov_return_value=>'PROCEDURE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>277432017860153065.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>277431029384153056.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Sequenza',
  p_lov_return_value=>'SEQUENCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>277432208891153066.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>277431029384153056.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Sinonimo',
  p_lov_return_value=>'SYNONYM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>277432406661153066.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>277431029384153056.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Tabella',
  p_lov_return_value=>'TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>277432614868153066.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>277431029384153056.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Trigger',
  p_lov_return_value=>'TRIGGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>277432808078153066.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>277431029384153056.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Vista',
  p_lov_return_value=>'VIEW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/on_demand_processes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 156837711683123346.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ON.DEMAND.PROCESSES',
  p_lov_query=> 'select htf.escape_sc(process_name) d, id r'||chr(10)||
''||chr(10)||
'  from wwv_flow_processing'||chr(10)||
''||chr(10)||
'where flow_id = :fb_flow_id and process_point = ''ON_DEMAND'''||chr(10)||
''||chr(10)||
' order by process_name'||chr(10)||
''||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/on_off
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 255691805174793587.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ON_OFF',
  p_lov_query=> '.'||to_char(255691805174793587 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>255692113018793589.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>255691805174793587.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Attivo',
  p_lov_return_value=>'ON',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>255692327712793591.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>255691805174793587.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Non attivo',
  p_lov_return_value=>'OFF',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/orphaned_lists_display
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 94838211998345101.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ORPHANED_LISTS_DISPLAY',
  p_lov_query=> '.'||to_char(94838211998345101 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94838503112345102.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94838211998345101.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Isolata',
  p_lov_return_value=>'O',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94838713034345102.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94838211998345101.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Tutto',
  p_lov_return_value=>'A',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p105_all_my_files
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 153643805218811160.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P105_ALL_MY_FILES',
  p_lov_query=> '.'||to_char(153643805218811160 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>153644123892811161.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>153643805218811160.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'File personali',
  p_lov_return_value=>'MY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>153644329503811161.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>153643805218811160.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Tutti i file',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p11_detail_avail_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 1095023376388744.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P11_DETAIL_AVAIL_COLS',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name v'||chr(10)||
'from sys.dba_tab_columns a'||chr(10)||
'where owner = :P5_DETAIL_OWNER'||chr(10)||
'and table_name = :P5_DETAIL_TABLE'||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'order by column_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p11_master_avail_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 1094412987385702.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P11_MASTER_AVAIL_COLS',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name v'||chr(10)||
'from sys.dba_tab_columns a'||chr(10)||
'where owner = :P4_MASTER_OWNER'||chr(10)||
'and table_name = :P4_MASTER_TABLE'||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'order by column_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p1556_display_selections
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 112777512483182861.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P1556_DISPLAY_SELECTIONS',
  p_lov_query=> '.'||to_char(112777512483182861 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>112777702670182866.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>112777512483182861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'- Tutto -',
  p_lov_return_value=>'All',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>112777913428182869.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>112777512483182861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Etichetta',
  p_lov_return_value=>'L',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>112778103167182870.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>112777512483182861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Visualizza come',
  p_lov_return_value=>'D',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>112778319856182870.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>112777512483182861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Formato',
  p_lov_return_value=>'F',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>112778517171182870.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>112777512483182861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Valore predefinito form',
  p_lov_return_value=>'V',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>112778711439182870.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>112777512483182861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Dimensione di visualizzazione',
  p_lov_return_value=>'S',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>112778913135182870.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>112777512483182861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Guida form',
  p_lov_return_value=>'H',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>112779121557182871.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>112777512483182861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Allineamento report',
  p_lov_return_value=>'A',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p15_master_detail_layout
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 1176702684075640.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P15_MASTER_DETAIL_LAYOUT',
  p_lov_query=> '.'||to_char(1176702684075640 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1177020854075644.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>1176702684075640.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Modifica pagina detail come form tabulare sulla stessa pagina',
  p_lov_return_value=>'2_PAGE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:24:&SESSION.:::24:P15_LAYOUT:2_PAGE"><img src="#IMAGE_PREFIX#htmldb/icons/master_detail_2pages_large.gif" class="lovimages" alt="#DISPLAY_VALUE#" width="140" height="115" alt=""/></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1177201280075645.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>1176702684075640.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Modifica pagina detail su pagina distinta',
  p_lov_return_value=>'3_PAGE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:18:&SESSION.:::18:P15_LAYOUT:3_PAGE"><img src="#IMAGE_PREFIX#htmldb/icons/master_detail_3pages_large.gif"  class="lovimages" alt="#DISPLAY_VALUE#" width="140" height="115" alt=""/></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p173_show
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 48989614083583743.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P173_SHOW',
  p_lov_query=> '.'||to_char(48989614083583743 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>48989812927583749.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>48989614083583743.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Modelli di applicazione',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>48990014681583750.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>48989614083583743.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Conteggi modelli di tema',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>205410028377606456.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>48989614083583743.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Riferimenti a file',
  p_lov_return_value=>'FILE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>205425424268633678.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>48989614083583743.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Riferimenti a classe',
  p_lov_return_value=>'CLASS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>205426329116635065.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>48989614083583743.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Stringhe di sostituzione per modelli',
  p_lov_return_value=>'TEMPLATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p2000_display_as
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 153345005351093458.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P2000_DISPLAY_AS',
  p_lov_query=> '.'||to_char(153345005351093458 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>153345213363093460.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>153345005351093458.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Mensile',
  p_lov_return_value=>'M',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>153345412537093462.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>153345005351093458.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Settimanale',
  p_lov_return_value=>'W',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>153345606055093462.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>153345005351093458.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Giornaliero',
  p_lov_return_value=>'D',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p2000_time_format
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 56791624481899538.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P2000_TIME_FORMAT',
  p_lov_query=> '.'||to_char(56791624481899538 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56791910326899538.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>56791624481899538.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'12 ore',
  p_lov_return_value=>'12HOUR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>56792105148899538.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>56791624481899538.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'24 ore',
  p_lov_return_value=>'24HOUR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p2002_tables_views
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 16465731594002180.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P2002_TABLES_VIEWS',
  p_lov_query=> 'select distinct htf.escape_sc(table_name) ||    '||chr(10)||
'       decode(o.object_type,'||chr(10)||
'              ''TABLE'', wwv_flow_lang.system_message(''TABLE_IN_PAREN''),'||chr(10)||
'              ''VIEW'',  wwv_flow_lang.system_message(''VIEW_IN_PAREN'')) d, '||chr(10)||
'   table_name v'||chr(10)||
'  from sys.dba_tab_columns c,'||chr(10)||
'       sys.dba_objects o'||chr(10)||
' where c.owner = nvl(:P2002_OWNER,:P2002_FLOW_OWNER)'||chr(10)||
'   and o.object_name = c.table_name'||chr(10)||
'   and o.owner = c.owner'||chr(10)||
'   and table_name not like ''BIN$%'''||chr(10)||
'   and (data_type = ''DATE'' or'||chr(10)||
'        data_type like ''TIMESTAMP%'')'||chr(10)||
'and c.owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'order by 1'||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p207_create_template
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 41876318884405056.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P207_CREATE_TEMPLATE',
  p_lov_query=> '.'||to_char(41876318884405056 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41876627082405062.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41876318884405056.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Dal repository',
  p_lov_return_value=>'THEME',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>59285019370204245.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41876318884405056.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Completamente nuovo/a',
  p_lov_return_value=>'NEW_THEME',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>245682104880497308.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41876318884405056.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Esportazione da',
  p_lov_return_value=>'IMPORT_THEME',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p2222_list_entries_start_with
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 63393015128868636.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P2222 LIST ENTRIES START WITH',
  p_lov_query=> 'select lpad('' '',4*(level-1),''.'')|| htf.escape_sc(list_item_link_text) list_item_link_text, id'||chr(10)||
'from wwv_flow_list_items i'||chr(10)||
'where flow_id = :FB_FLOW_ID'||chr(10)||
'and list_id = :P2222_LIST_ID'||chr(10)||
'start with parent_list_item_id is null'||chr(10)||
'connect by prior id = parent_list_item_id '||chr(10)||
'order siblings by list_item_display_sequence');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p260_report_view_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 229358215992778552.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P260.REPORT.VIEW.OPTIONS',
  p_lov_query=> '.'||to_char(229358215992778552 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>229358405044778555.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>229358215992778552.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Vista dettagliata',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>229358605815778557.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>229358215992778552.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Vista di riepilogo',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p3001_yes_no_returns_y_or_n
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 112311811438840152.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P3001_YES_NO_RETURNS_Y_OR_N',
  p_lov_query=> '.'||to_char(112311811438840152 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>112312112245840153.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>112311811438840152.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Sì',
  p_lov_return_value=>'Y',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="javascript:setItemDisplayByRelated(''Y'',''MASTER'');"></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>112312328191840154.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>112311811438840152.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'No',
  p_lov_return_value=>'N',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="javascript:setItemDisplayByRelated(''N'',''MASTER'');"></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p3012_column_list
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 170621816587107072.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P3012_COLUMN_LIST',
  p_lov_query=> 'select htf.escape_sc(t.column_name) a, t.column_name b'||chr(10)||
'from sys.dba_tab_columns t'||chr(10)||
'where t.owner = :P3012_SCHEMA'||chr(10)||
'and t.table_name = :P3012_TABLE'||chr(10)||
'and t.owner in (select schema'||chr(10)||
'from   wwv_flow_company_schemas'||chr(10)||
'where  security_group_id = :flow_security_group_id)'||chr(10)||
'and t.column_name not in (select cl.column_name'||chr(10)||
'        from sys.dba_cons_columns cl, sys.dba_constraints cn '||chr(10)||
'        where    cn.owner = cl.owner'||chr(10)||
'        and      cn.table_name = cl.table_name '||chr(10)||
'        and      cn.constraint_name = cl.constraint_name        '||chr(10)||
'        and      cn.table_name = :P3012_TABLE'||chr(10)||
'        and      cn.owner = :P3012_SCHEMA        '||chr(10)||
'        and      cn.constraint_type = ''P'')');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p3013_aggregate_by
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 171083224879658243.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P3013_AGGREGATE_BY',
  p_lov_query=> 'select htf.escape_sc(t.column_name) a, t.column_name b'||chr(10)||
'from sys.dba_tab_columns t'||chr(10)||
'where t.owner = :P3012_SCHEMA'||chr(10)||
'and t.table_name = :P3012_TABLE'||chr(10)||
'and t.data_type = ''NUMBER'''||chr(10)||
'and t.owner in (select schema'||chr(10)||
'from   wwv_flow_company_schemas'||chr(10)||
'where  security_group_id = :flow_security_group_id)'||chr(10)||
'and t.column_name not in (select cl.column_name'||chr(10)||
'        from sys.dba_cons_columns cl, sys.dba_constraints cn '||chr(10)||
'        where    cn.owner = cl.owner'||chr(10)||
'        and      cn.table_name = cl.table_name '||chr(10)||
'        and      cn.constraint_name = cl.constraint_name        '||chr(10)||
'        and      cn.table_name = :P3012_TABLE '||chr(10)||
'        and      cn.owner = :P3012_SCHEMA       '||chr(10)||
'        and      cn.constraint_type in (''P'',''R'')) '||chr(10)||
'        '||chr(10)||
'        ');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p31_columns
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 158089917773275899.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P31_COLUMNS',
  p_lov_query=> 'select COLUMN_ID||''. ''||htf.escape_sc(column_name)||'' (''||initcap(data_type)||'')'' d,'||chr(10)||
'       column_name v'||chr(10)||
'from sys.dba_tab_columns'||chr(10)||
'where  owner = :f4000_p29_owner and table_name = :f4000_p29_name'||chr(10)||
'and data_type <> ''BLOB'''||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'order by COLUMN_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p32_pk1
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 158099515873313257.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P32_PK1',
  p_lov_query=> 'select COLUMN_ID||''. ''||htf.escape_sc(column_name)||'' (''||initcap(data_type)||'')'' d, column_name v'||chr(10)||
'from sys.dba_tab_columns'||chr(10)||
'where  owner = :f4000_p29_owner and table_name = :f4000_p29_name'||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'order by COLUMN_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p32_pk2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 158100123838315488.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P32_PK2',
  p_lov_query=> 'select COLUMN_ID||''. ''||htf.escape_sc(column_name)||'' (''||initcap(data_type)||'')'' d,'||chr(10)||
'       column_name v'||chr(10)||
'from sys.dba_tab_columns'||chr(10)||
'where  owner = :f4000_p29_owner and table_name = :f4000_p29_name'||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'order by COLUMN_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p32_upd_columns
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 158098907908310888.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P32_UPD_COLUMNS',
  p_lov_query=> 'select htf.escape_sc(column_name)||'' (''||initcap(data_type)||'')'' d,'||chr(10)||
'       column_name v'||chr(10)||
'from   sys.dba_tab_columns'||chr(10)||
'where  owner = :f4000_p29_owner and table_name = :f4000_p29_name '||chr(10)||
'and    instr('':''||:f4000_p29_columns||'':'','':''||column_name||'':'') > 0'||chr(10)||
'and    column_name <> :F4000_P29_UPD_PK'||chr(10)||
'and    column_name <> nvl(:F4000_P29_UPD_PK2,'''''''')'||chr(10)||
'and    data_type <> ''BLOB'''||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'order by COLUMN_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p341_tabs
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 158428705418480516.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P341_TABS',
  p_lov_query=> 'select htf.escape_sc(TAB_NAME),tab_name'||chr(10)||
'from   wwv_flow_tabs'||chr(10)||
'where  flow_id = :fb_flow_id and'||chr(10)||
'       security_group_id = :flow_security_group_id and'||chr(10)||
'       tab_set = :F4000_P33_TAB_SET');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p352_tabs
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 162492123577109461.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P352_TABS',
  p_lov_query=> 'select htf.escape_sc(TAB_NAME),tab_name'||chr(10)||
'from   wwv_flow_tabs'||chr(10)||
'where  flow_id = :fb_flow_id and'||chr(10)||
'       security_group_id = :flow_security_group_id and'||chr(10)||
'       tab_set = :F4000_P4810_TAB_SET');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p356_avail_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 153676505798953184.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P356_AVAIL_COLS',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name v'||chr(10)||
'  from sys.dba_tab_columns a'||chr(10)||
' where owner = :P356_OWNER'||chr(10)||
'   and table_name = :P356_Q_T1'||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'   and not exists (select null from wwv_flow_collections'||chr(10)||
'                              where collection_name = ''COLUMNS'''||chr(10)||
'                                and c002 = a.table_name'||chr(10)||
'                                and c003 = a.column_name )'||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p356_selected_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 153677215841956147.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P356_SELECTED_COLS',
  p_lov_query=> 'select htf.escape_sc(c002)||''.''||htf.escape_sc(c003) d, seq_id v '||chr(10)||
'  from wwv_flow_collections'||chr(10)||
' where collection_name = ''COLUMNS'''||chr(10)||
'order by seq_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p356_tables_views
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 153674012247945609.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P356_TABLES_VIEWS',
  p_lov_query=> 'if :P356_FLOW_OWNER = :P356_OWNER and nvl(:P356_RELATED,''N'') = ''N'' then'||chr(10)||
'return ''select htf.escape_sc(table_name)||wwv_flow_lang.system_message(''''TABLE_IN_PAREN'''') d, table_name v'||chr(10)||
'from sys.dba_tables'||chr(10)||
'where owner = :P356_OWNER'||chr(10)||
'and table_name not like ''''BIN$%'''''||chr(10)||
'union all'||chr(10)||
'select htf.escape_sc(view_name)||wwv_flow_lang.system_message(''''VIEW_IN_PAREN'''') d, view_name v'||chr(10)||
'from sys.dba_views'||chr(10)||
'where owner = :P356_OWNER'||chr(10)||
'order by 1'';'||chr(10)||
'elsif :P356_FLOW_OWNER = :P356_OWNER and nvl(:P356_RELATED,''N'') = ''Y'' then'||chr(10)||
'return ''select distinct htf.escape_sc(d), v from (select c002 d, c002 v from wwv_flow_collections where collection_name = ''''COLUMNS'''' and c001 = :P356_OWNER'||chr(10)||
'union all'||chr(10)||
'select a.table_name d, a.table_name v'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.r_owner = :P356_OWNER'||chr(10)||
'   and a.owner = :P356_OWNER'||chr(10)||
'   and a.r_constraint_name = b.constraint_name'||chr(10)||
'   and a.constraint_type = ''''R'''''||chr(10)||
'   and b.owner = :P356_OWNER'||chr(10)||
'   and b.table_name in (select c002 from wwv_flow_collections where collection_name = ''''COLUMNS'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''     '||chr(10)||
'   and b.constraint_type in (''''U'''',''''P'''')'||chr(10)||
'union all'||chr(10)||
'select a.table_name d, a.table_name v'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.owner = :P356_OWNER'||chr(10)||
'   and b.r_owner = :P356_OWNER'||chr(10)||
'   and a.constraint_name = b.r_constraint_name'||chr(10)||
'   and b.owner = :P356_OWNER'||chr(10)||
'   and b.table_name in (select c002 from wwv_flow_collections where collection_name = ''''COLUMNS'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''      '||chr(10)||
'   and b.constraint_type =''''R'''') x'||chr(10)||
'order by 1'';'||chr(10)||
'elsif :P356_FLOW_OWNER != :P356_OWNER and nvl(:P356_RELATED,''N'') = ''N'' then'||chr(10)||
'return ''select htf.escape_sc(table_name) ||wwv_flow_lang.system_message(''''TABLE_IN_PAREN'''') d, table_name v'||chr(10)||
'from sys.dba_tables a'||chr(10)||
'where owner = :P356_OWNER'||chr(10)||
'and table_name not like ''''BIN$%'''''||chr(10)||
'and exists (select null '||chr(10)||
'              from sys.dba_tab_privs'||chr(10)||
'             where grantee = :P356_FLOW_OWNER'||chr(10)||
'               and privilege = ''''SELECT'''''||chr(10)||
'               and table_name = a.table_name'||chr(10)||
'               and owner = a.owner) '||chr(10)||
'union all'||chr(10)||
'select htf.escape_sc(view_name) ||wwv_flow_lang.system_message(''''VIEW_IN_PAREN'''') d, view_name v'||chr(10)||
'from sys.dba_views a'||chr(10)||
'where owner = :P356_OWNER'||chr(10)||
'and exists (select null '||chr(10)||
'              from sys.dba_tab_privs'||chr(10)||
'             where grantee = :P356_FLOW_OWNER'||chr(10)||
'               and privilege = ''''SELECT'''''||chr(10)||
'               and table_name = a.view_name'||chr(10)||
'               and owner = a.owner) '||chr(10)||
'order by 1'';'||chr(10)||
'elsif :P356_FLOW_OWNER != :P356_OWNER and nvl(:P356_RELATED,''N'') = ''Y'' then'||chr(10)||
'return ''select distinct htf.escape_sc(d), v from (select c002 d, c002 v, c001 o from wwv_flow_collections where collection_name = ''''COLUMNS'''' and c001 = :P356_OWNER'||chr(10)||
'union all'||chr(10)||
'select a.table_name d, a.table_name v, a.owner o'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.r_owner = :P356_OWNER'||chr(10)||
'   and a.owner = :P356_OWNER'||chr(10)||
'   and a.r_constraint_name = b.constraint_name'||chr(10)||
'   and a.constraint_type = ''''R'''''||chr(10)||
'   and b.owner = :P356_OWNER'||chr(10)||
'   and b.table_name in (select c002 from wwv_flow_collections where collection_name = ''''COLUMNS'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''     '||chr(10)||
'   and b.constraint_type in (''''U'''',''''P'''')'||chr(10)||
'union all'||chr(10)||
'select a.table_name d, a.table_name v, a.owner o'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.owner = :P356_OWNER'||chr(10)||
'   and b.r_owner = :P356_OWNER'||chr(10)||
'   and a.constraint_name = b.r_constraint_name'||chr(10)||
'   and b.owner = :P356_OWNER'||chr(10)||
'   and b.table_name in (select c002 from wwv_flow_collections where collection_name = ''''COLUMNS'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''      '||chr(10)||
'   and b.constraint_type =''''R'''') x '||chr(10)||
'where exists (select null '||chr(10)||
'                 from sys.dba_tab_privs'||chr(10)||
'                where grantee = :P356_FLOW_OWNER'||chr(10)||
'                  and privilege = ''''SELECT'''''||chr(10)||
'                  and table_name = x.d'||chr(10)||
'                  and owner = x.o)'||chr(10)||
'order by 1'';'||chr(10)||
'end if;');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p36_breadcrumb_start_with
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 32867404643224989.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P36 BREADCRUMB START WITH',
  p_lov_query=> 'SELECT rpad('' '',(level-1)*3,''...................................'')||'' ''||htf.Escape_Sc(short_name) sn,'||chr(10)||
'       id'||chr(10)||
'FROM wwv_flow_menu_options'||chr(10)||
'WHERE flow_id = :fb_flow_id and '||chr(10)||
'      menu_id = :P36_MENU_ID'||chr(10)||
'START WITH NVL(parent_id,0) = 0'||chr(10)||
'CONNECT BY PRIOR id = parent_id'||chr(10)||
'ORDER siblings BY short_name, OPTION_SEQUENCE');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p375_tabs
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 162120332451402350.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P375_TABS',
  p_lov_query=> 'select htf.escape_sc(TAB_NAME),tab_name'||chr(10)||
'from   wwv_flow_tabs'||chr(10)||
'where  flow_id = :fb_flow_id and'||chr(10)||
'       security_group_id = :flow_security_group_id and'||chr(10)||
'       tab_set = :F4000_P4710_TAB_SET');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p376_new_chart
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 41719408402645098.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P376_NEW_CHART',
  p_lov_query=> '.'||to_char(41719408402645098 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41719727700645195.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41719408402645098.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A barre (HTML)',
  p_lov_return_value=>'SIMPLE_CHART',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41719919282645197.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41719408402645098.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'A barre, orizzontale',
  p_lov_return_value=>'HBAR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41720106551645197.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41719408402645098.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'A barre, verticale',
  p_lov_return_value=>'VBAR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41720312256645197.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41719408402645098.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'A barre in cluster, orizzontale',
  p_lov_return_value=>'HCLUSTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41720527382645197.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41719408402645098.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'A barre in cluster, verticale',
  p_lov_return_value=>'CLUSTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41720723957645198.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41719408402645098.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Quadrante',
  p_lov_return_value=>'DIAL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41720918900645198.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41719408402645098.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Quadrante - con riempimento',
  p_lov_return_value=>'DIALSWEEP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41721102267645198.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41719408402645098.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Linea',
  p_lov_return_value=>'LINE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41721323279645198.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41719408402645098.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'A torta',
  p_lov_return_value=>'PIE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41721519830645199.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41719408402645098.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'A barre in pila, orizzontale',
  p_lov_return_value=>'HSTACKED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41721717772645206.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41719408402645098.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'A barre in pila, verticale',
  p_lov_return_value=>'STACKED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41721904067645206.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41719408402645098.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>12,
  p_lov_disp_value=>'A barre percentuali in pila, orizzontale',
  p_lov_return_value=>'HSTACKED_PCT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41722123718645206.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41719408402645098.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>13,
  p_lov_disp_value=>'A barre percentuali in pila, verticale',
  p_lov_return_value=>'STACKED_PCT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p399_cols_avail
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 153085921741582798.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P399_COLS_AVAIL',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name v'||chr(10)||
'  from sys.dba_tab_columns a'||chr(10)||
' where owner = :P399_OWNER'||chr(10)||
'   and table_name = :P399_Q_T1'||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'   and not exists (select null from wwv_flow_collections'||chr(10)||
'                              where collection_name = ''COLUMNS'''||chr(10)||
'                                and c002 = a.table_name'||chr(10)||
'                                and c003 = a.column_name )'||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p399_cols_selected
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 153086529706585093.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P399_COLS_SELECTED',
  p_lov_query=> 'select htf.escape_sc(c002)||''.''||htf.escape_sc(c003) d, seq_id v '||chr(10)||
'  from wwv_flow_collections'||chr(10)||
' where collection_name = ''COLUMNS'''||chr(10)||
'order by seq_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p399_tables_views
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 153085121956573384.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P399_TABLES_VIEWS',
  p_lov_query=> 'if :P399_FLOW_OWNER = :P399_OWNER and nvl(:P399_RELATED,''N'') = ''N'' then'||chr(10)||
'return ''select htf.escape_sc(table_name)||wwv_flow_lang.system_message(''''TABLE_IN_PAREN'''') d, table_name v'||chr(10)||
'from sys.dba_tables'||chr(10)||
'where owner = :P399_OWNER'||chr(10)||
'and table_name not like ''''BIN$%'''''||chr(10)||
'union all'||chr(10)||
'select htf.escape_sc(view_name)||wwv_flow_lang.system_message(''''VIEW_IN_PAREN'''') d, view_name v'||chr(10)||
'from sys.dba_views'||chr(10)||
'where owner = :P399_OWNER'||chr(10)||
'order by 1'';'||chr(10)||
'elsif :P399_FLOW_OWNER = :P399_OWNER and nvl(:P399_RELATED,''N'') = ''Y'' then'||chr(10)||
'return ''select distinct htf.escape_sc(d), v from (select c002 d, c002 v from wwv_flow_collections where collection_name = ''''COLUMNS'''' and c001 = :P399_OWNER'||chr(10)||
'union all'||chr(10)||
'select a.table_name d, a.table_name v'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.r_owner = :P399_OWNER'||chr(10)||
'   and a.owner = :P399_OWNER'||chr(10)||
'   and a.r_constraint_name = b.constraint_name'||chr(10)||
'   and a.constraint_type = ''''R'''''||chr(10)||
'   and b.owner = :P399_OWNER'||chr(10)||
'   and b.table_name in (select c002 from wwv_flow_collections where collection_name = ''''COLUMNS'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''     '||chr(10)||
'   and b.constraint_type in (''''U'''',''''P'''')'||chr(10)||
'union all'||chr(10)||
'select a.table_name d, a.table_name v'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.owner = :P399_OWNER'||chr(10)||
'   and b.r_owner = :P399_OWNER'||chr(10)||
'   and a.constraint_name = b.r_constraint_name'||chr(10)||
'   and b.owner = :P399_OWNER'||chr(10)||
'   and b.table_name in (select c002 from wwv_flow_collections where collection_name = ''''COLUMNS'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''      '||chr(10)||
'   and b.constraint_type =''''R'''') x'||chr(10)||
'order by 1'';'||chr(10)||
'elsif :P399_FLOW_OWNER != :P399_OWNER and nvl(:P399_RELATED,''N'') = ''N'' then'||chr(10)||
'return ''select htf.escape_sc(table_name) ||wwv_flow_lang.system_message(''''TABLE_IN_PAREN'''') d, table_name v'||chr(10)||
'from dba_tables a'||chr(10)||
'where owner = :P399_OWNER'||chr(10)||
'and table_name not like ''''BIN$%'''''||chr(10)||
'and exists (select null '||chr(10)||
'              from sys.dba_tab_privs'||chr(10)||
'             where grantee = :P399_FLOW_OWNER'||chr(10)||
'               and privilege = ''''SELECT'''''||chr(10)||
'               and table_name = a.table_name'||chr(10)||
'               and owner = a.owner) '||chr(10)||
'union all'||chr(10)||
'select htf.escape_sc(view_name) ||wwv_flow_lang.system_message(''''VIEW_IN_PAREN'''') d, view_name v'||chr(10)||
'from dba_views a'||chr(10)||
'where owner = :P399_OWNER'||chr(10)||
'and exists (select null '||chr(10)||
'              from sys.dba_tab_privs'||chr(10)||
'             where grantee = :P399_FLOW_OWNER'||chr(10)||
'               and privilege = ''''SELECT'''''||chr(10)||
'               and table_name = a.view_name'||chr(10)||
'               and owner = a.owner) '||chr(10)||
'order by 1'';'||chr(10)||
'elsif :P399_FLOW_OWNER != :P399_OWNER and nvl(:P399_RELATED,''N'') = ''Y'' then'||chr(10)||
'return ''select distinct htf.escape_sc(d), v from (select c002 d, c002 v, c001 o from wwv_flow_collections where collection_name = ''''COLUMNS'''' and c001 = :P399_OWNER'||chr(10)||
'union all'||chr(10)||
'select a.table_name d, a.table_name v, a.owner o'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.r_owner = :P399_OWNER'||chr(10)||
'   and a.owner = :P399_OWNER'||chr(10)||
'   and a.r_constraint_name = b.constraint_name'||chr(10)||
'   and a.constraint_type = ''''R'''''||chr(10)||
'   and b.owner = :P399_OWNER'||chr(10)||
'   and b.table_name in (select c002 from wwv_flow_collections where collection_name = ''''COLUMNS'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''     '||chr(10)||
'   and b.constraint_type in (''''U'''',''''P'''')'||chr(10)||
'union all'||chr(10)||
'select a.table_name d, a.table_name v, a.owner o'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.owner = :P399_OWNER'||chr(10)||
'   and b.r_owner = :P399_OWNER'||chr(10)||
'   and a.constraint_name = b.r_constraint_name'||chr(10)||
'   and b.owner = :P399_OWNER'||chr(10)||
'   and b.table_name in (select c002 from wwv_flow_collections where collection_name = ''''COLUMNS'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''      '||chr(10)||
'   and b.constraint_type =''''R'''') x '||chr(10)||
'where exists (select null '||chr(10)||
'                 from sys.dba_tab_privs'||chr(10)||
'                where grantee = :P399_FLOW_OWNER'||chr(10)||
'                  and privilege = ''''SELECT'''''||chr(10)||
'                  and table_name = x.d'||chr(10)||
'                  and owner = x.o)'||chr(10)||
'order by 1'';'||chr(10)||
'end if;');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p4015_listallitems
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 22161709183858677.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P4015_LISTALLITEMS',
  p_lov_query=> 'select initcap(wwv_flow_lang.system_message(''APPLICATION''))||'||chr(10)||
''':''||name a, name b '||chr(10)||
'  from wwv_flow_items'||chr(10)||
' where flow_id = :FB_FLOW_ID'||chr(10)||
'   and :F4000_P4026_IS = ''FLOW_ITEM'''||chr(10)||
' union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''PAGE''))||'||chr(10)||
''': ''||flow_step_id||'': ''||name a, name b'||chr(10)||
'  from wwv_flow_step_items'||chr(10)||
' where flow_id = :FB_FLOW_ID'||chr(10)||
'   and :F4000_P4026_IS != ''FLOW_ITEM'''||chr(10)||
' order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p4017_varchar_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 123878420043886379.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P4017_VARCHAR_COLS',
  p_lov_query=> 'select htf.escape_sc(c003) d, seq_id v from wwv_flow_collections'||chr(10)||
' where collection_name = ''REGION_QUERY_COLL'''||chr(10)||
'order by seq_id'||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p424_column_list
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 280504802572279872.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P424_COLUMN_LIST',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name r'||chr(10)||
'from sys.dba_tab_columns'||chr(10)||
'where owner = :p104_owner '||chr(10)||
'  and table_name = :p106_table'||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p424_numeric_column_list
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 280505618896312895.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P424_NUMERIC_COLUMN_LIST',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name r'||chr(10)||
'from sys.dba_tab_columns'||chr(10)||
'where owner = :p104_owner '||chr(10)||
'  and table_name = :p106_table '||chr(10)||
'  and upper(data_type) in ( ''NUMBER'' , ''FLOAT'')'||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'order by 1'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p426_seq
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 178172632134522245.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P426_SEQ',
  p_lov_query=> 'select htf.escape_sc(sequence_name) d, sequence_name v'||chr(10)||
'from sys.dba_sequences'||chr(10)||
'where sequence_owner = :F4000_P29_OWNER'||chr(10)||
'and sequence_owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID)) '||chr(10)||
'order by sequence_name');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p4305_tab_images
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 115182502774955301.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P4305_TAB_IMAGES',
  p_lov_query=> 'select i.image_name d,decode(i.FLOW_ID,0,''#''||''WORKSPACE_IMAGES''||''#''||i.image_name,''#''||''APP_IMAGES''||''#''||i.image_name) v '||chr(10)||
'from wwv_flow_image_repository i LEFT outer join wwv_flows f on i.FLOW_ID = f.ID'||chr(10)||
'where i.security_group_id = :flow_security_group_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p4312_in_map_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 23490921670855286.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P4312_IN_MAP_TYPE',
  p_lov_query=> '.'||to_char(23490921670855286 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23491218407855289.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>23490921670855286.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Elemento',
  p_lov_return_value=>'ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23491408926855290.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>23490921670855286.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Valore statico',
  p_lov_return_value=>'STATIC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p4312_out_map_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 23495520416864363.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P4312_OUT_MAP_TYPE',
  p_lov_query=> '.'||to_char(23495520416864363 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23495831550864364.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>23495520416864363.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Elementi',
  p_lov_return_value=>'ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23496013407864364.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>23495520416864363.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Collection',
  p_lov_return_value=>'COLLECTION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p4312_web_operations
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 23280706593687071.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P4312_WEB_OPERATIONS',
  p_lov_query=> 'select htf.escape_sc(name) d, id r'||chr(10)||
'from   wwv_flow_ws_operations'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p442_seq
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 177013926645250917.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P442_SEQ',
  p_lov_query=> 'select htf.escape_sc(sequence_name) d, sequence_name v'||chr(10)||
'from sys.dba_sequences'||chr(10)||
'where sequence_owner = :P453_OWNER_NAME'||chr(10)||
'and sequence_owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID)) '||chr(10)||
'order by sequence_name');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p443_seq
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 177015024352259775.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P443_SEQ',
  p_lov_query=> 'select htf.escape_sc(sequence_name) d, sequence_name v'||chr(10)||
'from sys.dba_sequences'||chr(10)||
'where sequence_owner = :F4000_P4703_TABLE_OWNER'||chr(10)||
'and sequence_owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))order by sequence_name');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p4651_list_plug_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 110270516023569639.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P4651_LIST_PLUG_TYPES',
  p_lov_query=> 'return wwv_flow_builder.region_source_type_lov(p_current_value => :F4000_P4651_PLUG_SOURCE_TYPE)');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p466_avail_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 155828317190371371.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P466_AVAIL_COLS',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name v'||chr(10)||
'  from sys.dba_tab_columns a'||chr(10)||
' where owner = :P466_OWNER'||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'   and table_name = :P466_Q_T1'||chr(10)||
'   and not exists (select null from wwv_flow_collections'||chr(10)||
'                              where collection_name = ''COLUMNS'''||chr(10)||
'                                and c003 = a.table_name'||chr(10)||
'                                and c005 = a.column_name'||chr(10)||
'                                and c006 != ''D'' )');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p466_selected_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 155829628964374834.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P466_SELECTED_COLS',
  p_lov_query=> 'select htf.escape_sc(c003)||''.''||htf.escape_sc(c005) d, seq_id v '||chr(10)||
'  from wwv_flow_collections'||chr(10)||
' where collection_name = ''COLUMNS'''||chr(10)||
'   and c006 != ''D'''||chr(10)||
'order by seq_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p466_tables_views
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 155827032642366405.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P466_TABLES_VIEWS',
  p_lov_query=> 'if :P466_FLOW_OWNER = :P466_OWNER and nvl(:P466_RELATED,''N'') = ''N'' then'||chr(10)||
'return ''select htf.escape_sc(table_name)||wwv_flow_lang.system_message(''''TABLE_IN_PAREN'''') d, table_name v'||chr(10)||
'from sys.dba_tables'||chr(10)||
'where owner = :P466_OWNER'||chr(10)||
'and table_name not like ''''BIN$%'''''||chr(10)||
'union all'||chr(10)||
'select htf.escape_sc(view_name)||wwv_flow_lang.system_message(''''VIEW_IN_PAREN'''') d, view_name v'||chr(10)||
'from sys.dba_views'||chr(10)||
'where owner = :P466_OWNER'||chr(10)||
'order by 1'';'||chr(10)||
'elsif :P466_FLOW_OWNER = :P466_OWNER and nvl(:P466_RELATED,''N'') = ''Y'' then'||chr(10)||
'return ''select distinct htf.escape_sc(d), v from (select c003 d, c003 v from wwv_flow_collections where collection_name = ''''COLUMNS'''' and c002 = :P466_OWNER and c006 != ''''D'''''||chr(10)||
'union all'||chr(10)||
'select a.table_name d, a.table_name v'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.r_owner = :P466_OWNER'||chr(10)||
'   and a.owner = :P466_OWNER'||chr(10)||
'   and a.r_constraint_name = b.constraint_name'||chr(10)||
'   and a.constraint_type = ''''R'''''||chr(10)||
'   and b.owner = :P466_OWNER'||chr(10)||
'   and b.table_name in (select c003 from wwv_flow_collections where collection_name = ''''COLUMNS'''' and c006 != ''''D'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''     '||chr(10)||
'   and b.constraint_type in (''''U'''',''''P'''')'||chr(10)||
'union all'||chr(10)||
'select a.table_name d, a.table_name v'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.owner = :P466_OWNER'||chr(10)||
'   and b.r_owner = :P466_OWNER'||chr(10)||
'   and a.constraint_name = b.r_constraint_name'||chr(10)||
'   and b.owner = :P466_OWNER'||chr(10)||
'   and b.table_name in (select c003 from wwv_flow_collections where collection_name = ''''COLUMNS'''' and c006 != ''''D'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''      '||chr(10)||
'   and b.constraint_type =''''R'''') x'||chr(10)||
'order by 1'';'||chr(10)||
'elsif :P466_FLOW_OWNER != :P466_OWNER and nvl(:P466_RELATED,''N'') = ''N'' then'||chr(10)||
'return ''select htf.escape_sc(table_name) ||wwv_flow_lang.system_message(''''TABLE_IN_PAREN'''') d, table_name v'||chr(10)||
'from sys.dba_tables a'||chr(10)||
'where owner = :P466_OWNER'||chr(10)||
'and table_name not like ''''BIN$%'''''||chr(10)||
'and exists (select null '||chr(10)||
'   from sys.dba_tab_privs'||chr(10)||
'   where grantee = :P466_FLOW_OWNER'||chr(10)||
'               and privilege = ''''SELECT'''''||chr(10)||
'               and table_name = a.table_name'||chr(10)||
'               and owner = a.owner) '||chr(10)||
'union all'||chr(10)||
'select htf.escape_sc(view_name) ||wwv_flow_lang.system_message(''''VIEW_IN_PAREN'''') d, view_name v'||chr(10)||
'from sys.dba_views a'||chr(10)||
'where owner = :P466_OWNER'||chr(10)||
'and exists (select null '||chr(10)||
'              from sys.dba_tab_privs'||chr(10)||
'             where grantee = :P466_FLOW_OWNER'||chr(10)||
'               and privilege = ''''SELECT'''''||chr(10)||
'               and table_name = a.view_name'||chr(10)||
'               and owner = a.owner) '||chr(10)||
'order by 1'';'||chr(10)||
'elsif :P466_FLOW_OWNER != :P466_OWNER and nvl(:P466_RELATED,''N'') = ''Y'' then'||chr(10)||
'return ''select distinct htf.escape_sc(d), v from (select c003 d, c003 v, c002 o from wwv_flow_collections where collection_name = ''''COLUMNS'''' and c002 = :P466_OWNER and c006 != ''''D'''''||chr(10)||
'union all'||chr(10)||
'select a.table_name d, a.table_name v, a.owner o'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.r_owner = :P466_OWNER'||chr(10)||
'   and a.owner = :P466_OWNER'||chr(10)||
'   and a.r_constraint_name = b.constraint_name'||chr(10)||
'   and a.constraint_type = ''''R'''''||chr(10)||
'   and b.owner = :P466_OWNER'||chr(10)||
'   and b.table_name in (select c003 from wwv_flow_collections where collection_name = ''''COLUMNS'''' and c006 != ''''D'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''     '||chr(10)||
'   and b.constraint_type in (''''U'''',''''P'''')'||chr(10)||
'union all'||chr(10)||
'select a.table_name d, a.table_name v, a.owner o'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.owner = :P466_OWNER'||chr(10)||
'   and b.r_owner = :P466_OWNER'||chr(10)||
'   and a.constraint_name = b.r_constraint_name'||chr(10)||
'   and b.owner = :P466_OWNER'||chr(10)||
'           and b.table_name in (select c003 from wwv_flow_collections where collection_name = ''''COLUMNS'''' and c006 != ''''D'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''      '||chr(10)||
'   and b.constraint_type =''''R'''') x '||chr(10)||
'where exists (select null '||chr(10)||
'from sys.dba_tab_privs'||chr(10)||
'where grantee = :P466_FLOW_OWNER'||chr(10)||
'and privilege = ''''SELECT'''''||chr(10)||
'                  and table_name = x.d'||chr(10)||
'                  and owner = x.o)'||chr(10)||
'order by 1'';'||chr(10)||
'end if;');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p4735_service_operations
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 23946805549926694.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P4735_SERVICE_OPERATIONS',
  p_lov_query=> 'select htf.escape_sc(name) d, id r'||chr(10)||
'  from wwv_flow_ws_operations'||chr(10)||
' where name != ''BASIC_AUTH'''||chr(10)||
'   and ws_id = :F4000_P4735_WEB_SERVICE');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p476_theme
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 240728016527322893.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P476_THEME',
  p_lov_query=> 'select	 htf.escape_sc(WWV_FLOW_THEMES.THEME_NAME) as "THEME_NAME",'||chr(10)||
'wwv_flow_themes.id'||chr(10)||
' from	 "WWV_FLOWS" "WWV_FLOWS",'||chr(10)||
'	 "WWV_FLOW_THEMES" "WWV_FLOW_THEMES" '||chr(10)||
' where   WWV_FLOW_THEMES.FLOW_ID=WWV_FLOWS.ID'||chr(10)||
' and wwv_flows.id = :P433_APPLICATION'||chr(10)||
' and wwv_flows.security_group_id = :flow_security_group_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p4780_chart_scale
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 162187100656572875.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P4780_CHART_SCALE',
  p_lov_query=> 'select 400 from dual union select 200 from dual union select 600 from dual order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p4790_table_list
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 203167004296717899.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P4790_TABLE_LIST',
  p_lov_query=> 'select distinct htf.escape_sc(table_name) ||    '||chr(10)||
'       decode(o.object_type,'||chr(10)||
'              ''TABLE'', wwv_flow_lang.system_message(''TABLE_IN_PAREN''),'||chr(10)||
'              ''VIEW'',  wwv_flow_lang.system_message(''VIEW_IN_PAREN'')) d, '||chr(10)||
'   table_name v'||chr(10)||
'  from sys.dba_tab_columns c,'||chr(10)||
'       sys.dba_objects o'||chr(10)||
' where c.owner = nvl(:F4000_P4785_OWNER,:P4790_FLOW_OWNER)'||chr(10)||
'   and o.object_name = c.table_name'||chr(10)||
'   and o.owner = c.owner'||chr(10)||
'   and table_name not like ''BIN$%'''||chr(10)||
'   and (data_type = ''DATE'' or'||chr(10)||
'        data_type like ''TIMESTAMP%'')'||chr(10)||
'and c.owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p4796_varchar_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 109940315866524802.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P4796_VARCHAR_COLS',
  p_lov_query=> 'select htf.escape_sc(c003) d, htf.escape_sc(c003) v from wwv_flow_collections'||chr(10)||
' where collection_name = ''LOV_COLL'''||chr(10)||
'order by seq_id'||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p494_summary_col1
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 150739316469381909.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P494_SUMMARY_COL1',
  p_lov_query=> 'select htf.escape_sc(c001) a, c001 b                '||chr(10)||
'from wwv_flow_collections '||chr(10)||
'where collection_name=''EXCEL_IMPORT'''||chr(10)||
'and c004 = ''Y'''||chr(10)||
'and c002 != ''CLOB'''||chr(10)||
'order by seq_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p494_summary_col2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 150742225173412831.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P494_SUMMARY_COL2',
  p_lov_query=> 'select htf.escape_sc(c001) a, c001 b                '||chr(10)||
'from wwv_flow_collections '||chr(10)||
'where collection_name=''CSV_IMPORT'''||chr(10)||
'and c004 = ''Y'''||chr(10)||
'and c002 != ''CLOB'''||chr(10)||
'order by seq_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p495_agg_col1
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 150843204404482597.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P495_AGG_COL1',
  p_lov_query=> 'select htf.escape_sc(c001) a, c001 b'||chr(10)||
'from wwv_flow_collections'||chr(10)||
'where collection_name=''EXCEL_IMPORT'''||chr(10)||
'and c004 = ''Y'''||chr(10)||
'and c002 = ''NUMBER''');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p495_agg_col2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 150845803496491785.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P495_AGG_COL2',
  p_lov_query=> 'select htf.escape_sc(c001) a, c001 b'||chr(10)||
'from wwv_flow_collections'||chr(10)||
'where collection_name=''CSV_IMPORT'''||chr(10)||
'and c004 = ''Y'''||chr(10)||
'and c002 = ''NUMBER''');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p4_avail_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 857524744713347.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P4_AVAIL_COLS',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name v'||chr(10)||
'  from sys.dba_tab_columns a'||chr(10)||
' where owner = :P4_MASTER_OWNER'||chr(10)||
'   and table_name = :P4_MASTER_TABLE'||chr(10)||
'   and not exists (select null from wwv_flow_collections'||chr(10)||
'                              where collection_name = ''MASTER_COLUMNS'''||chr(10)||
'                                and c002 = a.table_name'||chr(10)||
'                                and c003 = a.column_name )'||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'order by column_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p4_selected_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 897916738771486.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P4_SELECTED_COLS',
  p_lov_query=> 'select htf.escape_sc(c002)||''.''||htf.escape_sc(c003) d, seq_id v '||chr(10)||
'  from wwv_flow_collections'||chr(10)||
' where collection_name = ''MASTER_COLUMNS'''||chr(10)||
'order by seq_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p4_tables_views
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 965329368723751.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P4_TABLES_VIEWS',
  p_lov_query=> 'select htf.escape_sc(table_name)||'' ''||wwv_flow_lang.system_message(''TABLE_IN_PAREN'') d, table_name r'||chr(10)||
'from sys.dba_tables a'||chr(10)||
'where owner = :P4_MASTER_OWNER'||chr(10)||
'and table_name not like ''BIN$%'''||chr(10)||
'and (exists (select null'||chr(10)||
' from sys.dba_tab_privs'||chr(10)||
' where grantee = (select owner'||chr(10)||
' from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID)'||chr(10)||
' and privilege = ''SELECT'''||chr(10)||
' and table_name = a.table_name'||chr(10)||
' and owner = a.owner)'||chr(10)||
'or exists (select null'||chr(10)||
' from wwv_flows'||chr(10)||
' where owner = :P4_MASTER_OWNER'||chr(10)||
' and id = :FB_FLOW_ID))'||chr(10)||
'union all'||chr(10)||
'select htf.escape_sc(view_name)||'' ''||wwv_flow_lang.system_message(''VIEW_IN_PAREN'')  d, view_name r'||chr(10)||
'from sys.dba_views a'||chr(10)||
'where owner = :P4_MASTER_OWNER'||chr(10)||
'and (exists (select null'||chr(10)||
' from sys.dba_tab_privs'||chr(10)||
' where grantee = (select owner'||chr(10)||
' from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID)'||chr(10)||
' and privilege = ''SELECT'''||chr(10)||
' and table_name = a.view_name'||chr(10)||
' and owner = a.owner)'||chr(10)||
'or exists (select null'||chr(10)||
' from wwv_flows'||chr(10)||
' where owner = :P4_MASTER_OWNER'||chr(10)||
' and id = :FB_FLOW_ID))'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p507_seq
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 177151412742609513.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P507_SEQ',
  p_lov_query=> 'select htf.escape_sc(sequence_name) d, sequence_name v'||chr(10)||
'from sys.dba_sequences'||chr(10)||
'where sequence_owner = :P4_MASTER_OWNER'||chr(10)||
'and sequence_owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'order by sequence_name');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p508_seq
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 177234619565700608.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P508_SEQ',
  p_lov_query=> 'select htf.escape_sc(sequence_name) d, sequence_name v'||chr(10)||
'from sys.dba_sequences'||chr(10)||
'where sequence_owner = :P5_DETAIL_OWNER'||chr(10)||
'and sequence_owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'order by sequence_name');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p560_case_sensitive
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 13359205666146756.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P560_CASE_SENSITIVE',
  p_lov_query=> '.'||to_char(13359205666146756 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>13359510355146757.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>13359205666146756.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'con distinzione tra maiuscole e minuscole',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p560_exact_match
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 13356927698143693.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P560_EXACT_MATCH',
  p_lov_query=> '.'||to_char(13356927698143693 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>13357217040143696.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>13356927698143693.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'corrispondenza esatta',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p560_search_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 39290016198591148.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P560_SEARCH_TYPE',
  p_lov_query=> '.'||to_char(39290016198591148 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>39290330944591151.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>39290016198591148.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Nome attività aziendale',
  p_lov_return_value=>'BUS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>39290532350591153.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>39290016198591148.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Nome servizio',
  p_lov_return_value=>'SERV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p580_wsdl
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 42889632331473247.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P580_WSDL',
  p_lov_query=> '.'||to_char(42889632331473247 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42889910361473250.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42889632331473247.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Amazon Web Services 3.0',
  p_lov_return_value=>'http://soap.amazon.com/schemas3/AmazonWebServices.wsdl',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42890104744473251.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42889632331473247.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Google API Beta',
  p_lov_return_value=>'http://api.google.com/GoogleSearch.wsdl',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p5_avail_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 1054624611217411.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P5_AVAIL_COLS',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name v'||chr(10)||
'  from sys.dba_tab_columns a'||chr(10)||
' where owner = :P5_DETAIL_OWNER'||chr(10)||
'   and table_name = :P5_DETAIL_TABLE'||chr(10)||
'and owner in (select owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where id = :FB_FLOW_ID'||chr(10)||
'union'||chr(10)||
'select owner'||chr(10)||
'  from sys.dba_tab_privs'||chr(10)||
' where privilege = ''SELECT'''||chr(10)||
'   and owner not in (''SYS'',''SYSTEM'')'||chr(10)||
'   and grantee = (select owner '||chr(10)||
'                    from wwv_flows '||chr(10)||
'                   where id = :FB_FLOW_ID))'||chr(10)||
'   and not exists (select null from wwv_flow_collections'||chr(10)||
'                              where collection_name = ''DETAIL_COLUMNS'''||chr(10)||
'                                and c002 = a.table_name'||chr(10)||
'                                and c003 = a.column_name )'||chr(10)||
'order by column_id'||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p5_selected_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 1054812482217413.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P5_SELECTED_COLS',
  p_lov_query=> 'select htf.escape_sc(c002)||''.''||htf.escape_sc(c003) d, seq_id v '||chr(10)||
'  from wwv_flow_collections'||chr(10)||
' where collection_name = ''DETAIL_COLUMNS'''||chr(10)||
'order by seq_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p5_tables_views
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 941404414700155.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P5_TABLES_VIEWS',
  p_lov_query=> 'if :P4_FLOW_OWNER = :P5_DETAIL_OWNER and nvl(:P5_RELATED,''N'') = ''N'' then'||chr(10)||
'return ''select   htf.escape_sc(table_name)||wwv_flow_lang.system_message(''''TABLE_IN_PAREN'''') d, table_name v'||chr(10)||
'from sys.dba_tables'||chr(10)||
'where owner = :P5_DETAIL_OWNER'||chr(10)||
'and table_name not like ''''BIN$%'''''||chr(10)||
'union all'||chr(10)||
'select htf.escape_sc(view_name)||wwv_flow_lang.system_message(''''VIEW_IN_PAREN'''') d, view_name v'||chr(10)||
'from sys.dba_views'||chr(10)||
'where owner = :P5_DETAIL_OWNER'||chr(10)||
'order by 1'';'||chr(10)||
'elsif :P4_FLOW_OWNER = :P5_DETAIL_OWNER and nvl(:P5_RELATED,''N'') = ''Y'' then'||chr(10)||
'return ''select distinct htf.escape_sc(d), v from (select a.table_name d, a.table_name v'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.r_owner = :P5_DETAIL_OWNER'||chr(10)||
'   and a.owner = :P5_DETAIL_OWNER'||chr(10)||
'   and a.r_constraint_name = b.constraint_name'||chr(10)||
'   and a.constraint_type = ''''R'''''||chr(10)||
'   and b.owner = :P5_DETAIL_OWNER'||chr(10)||
'   and b.table_name in (select c002 from wwv_flow_collections where collection_name = ''''MASTER_COLUMNS'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''     '||chr(10)||
'   and b.constraint_type in (''''U'''',''''P'''')'||chr(10)||
'union all'||chr(10)||
'select a.table_name d, a.table_name v'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.owner = :P5_DETAIL_OWNER'||chr(10)||
'   and b.r_owner = :P5_DETAIL_OWNER'||chr(10)||
'   and a.constraint_name = b.r_constraint_name'||chr(10)||
'   and b.owner = :P5_DETAIL_OWNER'||chr(10)||
'   and b.table_name in (select c002 from wwv_flow_collections where collection_name = ''''MASTER_COLUMNS'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''      '||chr(10)||
'   and b.constraint_type =''''R'''') x'||chr(10)||
'order by 1'';'||chr(10)||
'elsif :P4_FLOW_OWNER != :P5_DETAIL_OWNER and nvl(:P5_RELATED,''N'') = ''N'' then'||chr(10)||
'return ''select htf.escape_sc(table_name) ||wwv_flow_lang.system_message(''''TABLE_IN_PAREN'''') d, table_name v'||chr(10)||
'from sys.dba_tables a'||chr(10)||
'where owner = :P5_DETAIL_OWNER'||chr(10)||
'and table_name not like ''''BIN$%'''''||chr(10)||
'and exists (select null '||chr(10)||
'              from sys.dba_tab_privs'||chr(10)||
'             where grantee = :P4_FLOW_OWNER'||chr(10)||
'               and privilege = ''''SELECT'''''||chr(10)||
'               and table_name = a.table_name'||chr(10)||
'               and owner = a.owner) '||chr(10)||
'union all'||chr(10)||
'select htf.escape_sc(view_name) ||wwv_flow_lang.system_message(''''VIEW_IN_PAREN'''') d, view_name v'||chr(10)||
'from sys.dba_views a'||chr(10)||
'where owner = :P5_DETAIL_OWNER'||chr(10)||
'and exists (select null '||chr(10)||
'              from sys.dba_tab_privs'||chr(10)||
'             where grantee = :P4_FLOW_OWNER'||chr(10)||
'               and privilege = ''''SELECT'''''||chr(10)||
'               and table_name = a.view_name'||chr(10)||
'               and owner = a.owner) '||chr(10)||
'order by 1'';'||chr(10)||
'elsif :P4_FLOW_OWNER != :P5_DETAIL_OWNER and nvl(:P5_RELATED,''N'') = ''Y'' then'||chr(10)||
'return ''select distinct htf.escape_sc(d), v from (select c002 d, c002 v, c001 o from wwv_flow_collections where collection_name = ''''MASTER_COLUMNS'''' and c001 = :P5_DETAIL_OWNER'||chr(10)||
'union all'||chr(10)||
'select a.table_name d, a.table_name v, a.owner o'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.r_owner = :P5_DETAIL_OWNER'||chr(10)||
'   and a.owner = :P5_DETAIL_OWNER'||chr(10)||
'   and a.r_constraint_name = b.constraint_name'||chr(10)||
'   and a.constraint_type = ''''R'''''||chr(10)||
'   and b.owner = :P5_DETAIL_OWNER'||chr(10)||
'   and b.table_name in (select c002 from wwv_flow_collections where collection_name = ''''MASTER_COLUMNS'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''     '||chr(10)||
'   and b.constraint_type in (''''U'''',''''P'''')'||chr(10)||
'union all'||chr(10)||
'select a.table_name d, a.table_name v, a.owner o'||chr(10)||
'  from sys.dba_constraints a, sys.dba_constraints b'||chr(10)||
' where 1=1'||chr(10)||
'   and a.owner = :P5_DETAIL_OWNER'||chr(10)||
'   and b.r_owner = :P5_DETAIL_OWNER'||chr(10)||
'   and a.constraint_name = b.r_constraint_name'||chr(10)||
'   and b.owner = :P5_DETAIL_OWNER'||chr(10)||
'   and b.table_name in (select c002 from wwv_flow_collections where collection_name = ''''MASTER_COLUMNS'''')'||chr(10)||
'   and b.table_name not like ''''BIN$%''''      '||chr(10)||
'   and b.constraint_type =''''R'''') x '||chr(10)||
'where exists (select null '||chr(10)||
'                 from sys.dba_tab_privs'||chr(10)||
'                where grantee = :P4_FLOW_OWNER'||chr(10)||
'                  and privilege = ''''SELECT'''''||chr(10)||
'                  and table_name = x.d'||chr(10)||
'                  and owner = x.o)'||chr(10)||
'order by 1'';'||chr(10)||
'end if;');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p600_service_operations
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 15589721785727739.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P600_SERVICE_OPERATIONS',
  p_lov_query=> 'select htf.escape_sc(name) d, id r'||chr(10)||
'  from wwv_flow_ws_operations'||chr(10)||
' where name != ''BASIC_AUTH'''||chr(10)||
'   and ws_id = :P600_WS_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p600_web_services
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 15587132043721216.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P600_WEB_SERVICES',
  p_lov_query=> 'select htf.escape_sc(name) d, id r'||chr(10)||
'  from wwv_flow_shared_web_services'||chr(10)||
' where action = ''NEW_SCHOOL'''||chr(10)||
'   and flow_id = :FB_FLOW_ID'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p695_flash_chart_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P695_FLASH_CHART_TYPES',
  p_lov_query=> '.'||to_char(47868213128008134 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47868512646008137.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D',
  p_lov_return_value=>'2DColumn',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in '||chr(10)||
'(''2DColumn'','||chr(10)||
'''2DLine'','||chr(10)||
'''3DColumn'','||chr(10)||
'''Horizontal2DColumn'','||chr(10)||
'''Horizontal3DColumn'','||chr(10)||
'''Stacked2DColumn'','||chr(10)||
'''Stacked3DColumn'','||chr(10)||
'''StackedHorizontal2DColumn'','||chr(10)||
'''StackedHorizontal3DColumn'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47868703003008138.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A linee di colonne 2D',
  p_lov_return_value=>'2DColumn_Line',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47868908476008138.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Ad anello 2D',
  p_lov_return_value=>'2DDoughnut',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in '||chr(10)||
'(''2DDoughnut'','||chr(10)||
' ''2DPie'','||chr(10)||
' ''3DPie'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47869115726008138.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A linee 2D',
  p_lov_return_value=>'2DLine',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in '||chr(10)||
'(''2DColumn'','||chr(10)||
'''2DLine'','||chr(10)||
'''3DColumn'','||chr(10)||
'''Horizontal2DColumn'','||chr(10)||
'''Horizontal3DColumn'','||chr(10)||
'''Stacked2DColumn'','||chr(10)||
'''Stacked3DColumn'','||chr(10)||
'''StackedHorizontal2DColumn'','||chr(10)||
'''StackedHorizontal3DColumn'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47869325893008138.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A torta 2D',
  p_lov_return_value=>'2DPie',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in '||chr(10)||
'(''2DDoughnut'','||chr(10)||
' ''2DPie'','||chr(10)||
' ''3DPie'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47869514610008138.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D',
  p_lov_return_value=>'3DColumn',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in '||chr(10)||
'(''2DColumn'','||chr(10)||
'''2DLine'','||chr(10)||
'''3DColumn'','||chr(10)||
'''Horizontal2DColumn'','||chr(10)||
'''Horizontal3DColumn'','||chr(10)||
'''Stacked2DColumn'','||chr(10)||
'''Stacked3DColumn'','||chr(10)||
'''StackedHorizontal2DColumn'','||chr(10)||
'''StackedHorizontal3DColumn'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47869711366008138.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A torta 3D',
  p_lov_return_value=>'3DPie',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in '||chr(10)||
'(''2DDoughnut'','||chr(10)||
' ''2DPie'','||chr(10)||
' ''3DPie'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47869908851008138.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A canne d''organo',
  p_lov_return_value=>'Candlestick',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE = ''Candlestick''',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47870130992008138.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A dispersione',
  p_lov_return_value=>'dot',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE = ''dot''',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47870311967008138.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D orizzontali',
  p_lov_return_value=>'Horizontal2DColumn',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in '||chr(10)||
'(''2DColumn'','||chr(10)||
'''2DLine'','||chr(10)||
'''3DColumn'','||chr(10)||
'''Horizontal2DColumn'','||chr(10)||
'''Horizontal3DColumn'','||chr(10)||
'''Stacked2DColumn'','||chr(10)||
'''Stacked3DColumn'','||chr(10)||
'''StackedHorizontal2DColumn'','||chr(10)||
'''StackedHorizontal3DColumn'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47870528228008138.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D orizzontali',
  p_lov_return_value=>'Horizontal3DColumn',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in '||chr(10)||
'(''2DColumn'','||chr(10)||
'''2DLine'','||chr(10)||
'''3DColumn'','||chr(10)||
'''Horizontal2DColumn'','||chr(10)||
'''Horizontal3DColumn'','||chr(10)||
'''Stacked2DColumn'','||chr(10)||
'''Stacked3DColumn'','||chr(10)||
'''StackedHorizontal2DColumn'','||chr(10)||
'''StackedHorizontal3DColumn'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47870727510008138.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D con intervallo orizzontale',
  p_lov_return_value=>'HorizontalRange2DColumn',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in '||chr(10)||
'(''HorizontalRange3DColumn'','||chr(10)||
'''HorizontalRange2DColumn'','||chr(10)||
'''Range2DColumn'','||chr(10)||
'''Range3DColumn'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47870905273008138.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D con intervallo orizzontale',
  p_lov_return_value=>'HorizontalRange3DColumn',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in '||chr(10)||
'(''HorizontalRange3DColumn'','||chr(10)||
'''HorizontalRange2DColumn'','||chr(10)||
'''Range2DColumn'','||chr(10)||
'''Range3DColumn'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47871116594008138.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A linee 2D invertite',
  p_lov_return_value=>'Inverse2DLine',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47871307600008139.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D con intervallo',
  p_lov_return_value=>'Range2DColumn',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in '||chr(10)||
'(''HorizontalRange3DColumn'','||chr(10)||
'''HorizontalRange2DColumn'','||chr(10)||
'''Range2DColumn'','||chr(10)||
'''Range3DColumn'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47871528365008139.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D con intervallo',
  p_lov_return_value=>'Range3DColumn',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in '||chr(10)||
'(''HorizontalRange3DColumn'','||chr(10)||
'''HorizontalRange2DColumn'','||chr(10)||
'''Range2DColumn'','||chr(10)||
'''Range3DColumn'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47871730028008139.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D in pila',
  p_lov_return_value=>'Stacked2DColumn',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in ('||chr(10)||
'  ''2DColumn'','||chr(10)||
'  ''2DLine'','||chr(10)||
'  ''3DColumn'','||chr(10)||
'  ''Horizontal2DColumn'','||chr(10)||
'  ''Horizontal3DColumn'','||chr(10)||
'  ''Stacked2DColumn'','||chr(10)||
'  ''Stacked3DColumn'','||chr(10)||
'  ''StackedHorizontal2DColumn'','||chr(10)||
'  ''StackedHorizontal3DColumn'','||chr(10)||
'  ''2DSTACKED_PCT'','||chr(10)||
'  ''3DSTACKED_PCT'','||chr(10)||
'  ''2DHSTACKED_PCT'','||chr(10)||
'  ''3DHSTACKED_PCT'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47871922089008139.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D in pila',
  p_lov_return_value=>'Stacked3DColumn',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in ('||chr(10)||
'  ''2DColumn'','||chr(10)||
'  ''2DLine'','||chr(10)||
'  ''3DColumn'','||chr(10)||
'  ''Horizontal2DColumn'','||chr(10)||
'  ''Horizontal3DColumn'','||chr(10)||
'  ''Stacked2DColumn'','||chr(10)||
'  ''Stacked3DColumn'','||chr(10)||
'  ''StackedHorizontal2DColumn'','||chr(10)||
'  ''StackedHorizontal3DColumn'','||chr(10)||
'  ''2DSTACKED_PCT'','||chr(10)||
'  ''3DSTACKED_PCT'','||chr(10)||
'  ''2DHSTACKED_PCT'','||chr(10)||
'  ''3DHSTACKED_PCT'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47872117073008139.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D orizzontali in pila',
  p_lov_return_value=>'StackedHorizontal2DColumn',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in ('||chr(10)||
'  ''2DColumn'','||chr(10)||
'  ''2DLine'','||chr(10)||
'  ''3DColumn'','||chr(10)||
'  ''Horizontal2DColumn'','||chr(10)||
'  ''Horizontal3DColumn'','||chr(10)||
'  ''Stacked2DColumn'','||chr(10)||
'  ''Stacked3DColumn'','||chr(10)||
'  ''StackedHorizontal2DColumn'','||chr(10)||
'  ''StackedHorizontal3DColumn'','||chr(10)||
'  ''2DSTACKED_PCT'','||chr(10)||
'  ''3DSTACKED_PCT'','||chr(10)||
'  ''2DHSTACKED_PCT'','||chr(10)||
'  ''3DHSTACKED_PCT'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47872319846008139.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D orizzontali in pila',
  p_lov_return_value=>'StackedHorizontal3DColumn',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in ('||chr(10)||
'  ''2DColumn'','||chr(10)||
'  ''2DLine'','||chr(10)||
'  ''3DColumn'','||chr(10)||
'  ''Horizontal2DColumn'','||chr(10)||
'  ''Horizontal3DColumn'','||chr(10)||
'  ''Stacked2DColumn'','||chr(10)||
'  ''Stacked3DColumn'','||chr(10)||
'  ''StackedHorizontal2DColumn'','||chr(10)||
'  ''StackedHorizontal3DColumn'','||chr(10)||
'  ''2DSTACKED_PCT'','||chr(10)||
'  ''3DSTACKED_PCT'','||chr(10)||
'  ''2DHSTACKED_PCT'','||chr(10)||
'  ''3DHSTACKED_PCT'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47872528474008139.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Quadrante',
  p_lov_return_value=>'GaugeChart',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in (''GaugeChart'',''DIALSWEEP'',''DIAL_PCT'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>51033304101721477.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D in pila (percentuale)',
  p_lov_return_value=>'2DSTACKED_PCT',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in ('||chr(10)||
'  ''2DColumn'','||chr(10)||
'  ''2DLine'','||chr(10)||
'  ''3DColumn'','||chr(10)||
'  ''Horizontal2DColumn'','||chr(10)||
'  ''Horizontal3DColumn'','||chr(10)||
'  ''Stacked2DColumn'','||chr(10)||
'  ''Stacked3DColumn'','||chr(10)||
'  ''StackedHorizontal2DColumn'','||chr(10)||
'  ''StackedHorizontal3DColumn'','||chr(10)||
'  ''2DSTACKED_PCT'','||chr(10)||
'  ''3DSTACKED_PCT'','||chr(10)||
'  ''2DHSTACKED_PCT'','||chr(10)||
'  ''3DHSTACKED_PCT'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>51034512759723968.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D in pila (percentuale)',
  p_lov_return_value=>'3DSTACKED_PCT',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in ('||chr(10)||
'  ''2DColumn'','||chr(10)||
'  ''2DLine'','||chr(10)||
'  ''3DColumn'','||chr(10)||
'  ''Horizontal2DColumn'','||chr(10)||
'  ''Horizontal3DColumn'','||chr(10)||
'  ''Stacked2DColumn'','||chr(10)||
'  ''Stacked3DColumn'','||chr(10)||
'  ''StackedHorizontal2DColumn'','||chr(10)||
'  ''StackedHorizontal3DColumn'','||chr(10)||
'  ''2DSTACKED_PCT'','||chr(10)||
'  ''3DSTACKED_PCT'','||chr(10)||
'  ''2DHSTACKED_PCT'','||chr(10)||
'  ''3DHSTACKED_PCT'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>51036225918727759.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 2D orizzontali in pila (percentuale)',
  p_lov_return_value=>'2DHSTACKED_PCT',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in ('||chr(10)||
'  ''2DColumn'','||chr(10)||
'  ''2DLine'','||chr(10)||
'  ''3DColumn'','||chr(10)||
'  ''Horizontal2DColumn'','||chr(10)||
'  ''Horizontal3DColumn'','||chr(10)||
'  ''Stacked2DColumn'','||chr(10)||
'  ''Stacked3DColumn'','||chr(10)||
'  ''StackedHorizontal2DColumn'','||chr(10)||
'  ''StackedHorizontal3DColumn'','||chr(10)||
'  ''2DSTACKED_PCT'','||chr(10)||
'  ''3DSTACKED_PCT'','||chr(10)||
'  ''2DHSTACKED_PCT'','||chr(10)||
'  ''3DHSTACKED_PCT'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>51037002847730566.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'A colonne 3D orizzontali in pila (percentuale)',
  p_lov_return_value=>'3DHSTACKED_PCT',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in ('||chr(10)||
'  ''2DColumn'','||chr(10)||
'  ''2DLine'','||chr(10)||
'  ''3DColumn'','||chr(10)||
'  ''Horizontal2DColumn'','||chr(10)||
'  ''Horizontal3DColumn'','||chr(10)||
'  ''Stacked2DColumn'','||chr(10)||
'  ''Stacked3DColumn'','||chr(10)||
'  ''StackedHorizontal2DColumn'','||chr(10)||
'  ''StackedHorizontal3DColumn'','||chr(10)||
'  ''2DSTACKED_PCT'','||chr(10)||
'  ''3DSTACKED_PCT'','||chr(10)||
'  ''2DHSTACKED_PCT'','||chr(10)||
'  ''3DHSTACKED_PCT'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94898407355608626.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>47868213128008134.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Quadrante (Percentuale)',
  p_lov_return_value=>'DIAL_PCT',
  p_lov_disp_cond_type=>'PLSQL_EXPRESSION',
  p_lov_disp_cond=> ':P695_CHART_TYPE in (''GaugeChart'',''DIAL_PCT'')',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p700_service_operations
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 30137708159892825.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P700_SERVICE_OPERATIONS',
  p_lov_query=> 'select htf.escape_sc(name) d, id r'||chr(10)||
'  from wwv_flow_ws_operations'||chr(10)||
' where name != ''BASIC_AUTH'''||chr(10)||
'   and ws_id = :P700_WS_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p725_arrays
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 30163920479050503.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P725_ARRAYS',
  p_lov_query=> 'select htf.escape_sc(name)||'' (''||htf.escape_sc(parm_type)||'')'' d, id r'||chr(10)||
'  from wwv_flow_ws_parameters a'||chr(10)||
' where type_is_xsd = ''N'''||chr(10)||
'   and input_or_output = ''O'''||chr(10)||
'   and exists (select 1'||chr(10)||
'                 from wwv_flow_ws_parameters'||chr(10)||
'                where parent_id = a.id'||chr(10)||
'                  and type_is_xsd = ''Y'') '||chr(10)||
'   and ws_opers_id = :P700_OPERATION_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p755_message_style
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 40231925790463373.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P755.MESSAGE.STYLE',
  p_lov_query=> '.'||to_char(40231925790463373 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>40232212679463374.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>40231925790463373.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Valore',
  p_lov_return_value=>'literal',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>40232431421463374.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>40231925790463373.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Codificato',
  p_lov_return_value=>'encoded',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p755_soap_style
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 40229315139441290.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P755.SOAP.STYLE',
  p_lov_query=> '.'||to_char(40229315139441290 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>40229627356441290.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>40229315139441290.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Documento',
  p_lov_return_value=>'document',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>40229803305441290.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>40229315139441290.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'RPC',
  p_lov_return_value=>'rpc',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p755_webreference_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 40198901222257565.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P755.WEBREFERENCE.TYPE',
  p_lov_query=> '.'||to_char(40198901222257565 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>40199230524257566.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>40198901222257565.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Creato manualmente',
  p_lov_return_value=>'775',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>40199413274257566.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>40198901222257565.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Generato da WSDL',
  p_lov_return_value=>'760',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p760_arrays
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 31993829026657722.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P760_ARRAYS',
  p_lov_query=> 'select htf.escape_sc(name)||'' (''||htf.escape_sc(parm_type)||'')'' d, id r'||chr(10)||
'  from wwv_flow_ws_parameters a'||chr(10)||
' where type_is_xsd = ''N'''||chr(10)||
'   and input_or_output = ''O'''||chr(10)||
'   and exists (select 1'||chr(10)||
'                 from wwv_flow_ws_parameters'||chr(10)||
'                where parent_id = a.id'||chr(10)||
'                  and type_is_xsd = ''Y'') '||chr(10)||
'   and ws_opers_id = :P760_OPERATION_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p760_operations
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 31988223738599389.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P760_OPERATIONS',
  p_lov_query=> 'select htf.escape_sc(name) d, id r'||chr(10)||
'  from wwv_flow_ws_operations'||chr(10)||
' where name != ''BASIC_AUTH'''||chr(10)||
'   and ws_id = :P760_WS_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p778_webref_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 114277222597792014.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P778_WEBREF_TYPE',
  p_lov_query=> '.'||to_char(114277222597792014 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>114277531767792019.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>114277222597792014.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Creato manualmente',
  p_lov_return_value=>'781',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>114277727331792020.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>114277222597792014.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Generato da WSDL',
  p_lov_return_value=>'779',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p779_arrays
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 114317921745905322.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P779_ARRAYS',
  p_lov_query=> 'select htf.escape_sc(name)||'' (''||htf.escape_sc(parm_type)||'')'' d, id r'||chr(10)||
'  from wwv_flow_ws_parameters a'||chr(10)||
' where type_is_xsd = ''N'''||chr(10)||
'   and input_or_output = ''O'''||chr(10)||
'   and exists (select 1'||chr(10)||
'                 from wwv_flow_ws_parameters'||chr(10)||
'                where parent_id = a.id'||chr(10)||
'                  and type_is_xsd = ''Y'') '||chr(10)||
'   and ws_opers_id = :P779_OPERATION_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p779_operations
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 114316827501897556.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P779_OPERATIONS',
  p_lov_query=> 'select htf.escape_sc(name) d, id r'||chr(10)||
'  from wwv_flow_ws_operations'||chr(10)||
' where name != ''BASIC_AUTH'''||chr(10)||
'   and ws_id = :P779_WS_ID');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p806_inv_session_target
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 159056930707631319.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P806_INV_SESSION_TARGET',
  p_lov_query=> 'declare xe boolean := wwv_flow_global.g_xe;'||chr(10)||
'begin'||chr(10)||
'if not xe then'||chr(10)||
'return'||chr(10)||
'''select d,r from ('||chr(10)||
'    select ''''&PRODUCT_NAME. ''''||'||chr(10)||
'    wwv_flow_lang.system_message(''''F4000_P806_BUILTIN_LOGIN_PG'''') d,'||chr(10)||
'    ''''BUILTIN'''' r, 1 ob from dual'||chr(10)||
'    union all'||chr(10)||
'    select wwv_flow_lang.system_message(''''F4000_P806_PAGE_IN_THIS_FLOW'''') d,'||chr(10)||
'    ''''PAGE'''' r, 2 ob from dual'||chr(10)||
'    union all'||chr(10)||
'    select wwv_flow_lang.system_message(''''F4000_P806_URL'''') d,'||chr(10)||
'    ''''URL'''' r,3 ob from dual'||chr(10)||
'    union all'||chr(10)||
'    select wwv_flow_lang.system_message(''''F4000_P806_SSO_SERVER'''') d,'||chr(10)||
'    ''''-PORTAL_SSO-'''' r, 4 ob'||chr(10)||
'    from dual'||chr(10)||
'    union all'||chr(10)||
'    select wwv_flow_lang.system_message(''''F4000_P806_NONE'''') d,'||chr(10)||
'    ''''NONE'''' r, 5 ob from dual)'||chr(10)||
'order by ob'';'||chr(10)||
'else'||chr(10)||
'return'||chr(10)||
'''select d,r from ('||chr(10)||
'    select ''''&PRODUCT_NAME. ''''||'||chr(10)||
'    wwv_flow_lang.system_message(''''F4000_P806_BUILTIN_LOGIN_PG'''') d,'||chr(10)||
'    ''''BUILTIN'''' r, 1 ob from dual'||chr(10)||
'    union all'||chr(10)||
'    select wwv_flow_lang.system_message(''''F4000_P806_PAGE_IN_THIS_FLOW'''') d,'||chr(10)||
'    ''''PAGE'''' r, 2 ob from dual'||chr(10)||
'    union all'||chr(10)||
'    select wwv_flow_lang.system_message(''''F4000_P806_URL'''') d,'||chr(10)||
'    ''''URL'''' r,3 ob from dual'||chr(10)||
'    union all'||chr(10)||
'    select wwv_flow_lang.system_message(''''F4000_P806_NONE'''') d,'||chr(10)||
'    ''''NONE'''' r, 5 ob from dual)'||chr(10)||
'order by ob'';'||chr(10)||
'end if;'||chr(10)||
'end;');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p808_auth_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 159070400681755094.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P808_AUTH_TYPE',
  p_lov_query=> 'select d,r from ('||chr(10)||
'    select wwv_flow_lang.system_message(''F4000_P808_AUTH_TYPE'','||chr(10)||
'      ''&PRODUCT_NAME.'') d, ''BUILTIN'' r, 1 ob from dual'||chr(10)||
'    union'||chr(10)||
'    select wwv_flow_lang.system_message(''F4000_P808_DBAUTH_TYPE'') d, '||chr(10)||
'    ''DBACCOUNT'' r, 2 ob from dual'||chr(10)||
'    union'||chr(10)||
'    select wwv_flow_lang.system_message(''F4000_P808_NO_VERIFY_CRED'') d,'||chr(10)||
'      ''ALLOW'' r, 3 ob from dual'||chr(10)||
'    union'||chr(10)||
'    select wwv_flow_lang.system_message(''F4000_P808_USE_LDAP'') d,'||chr(10)||
'      ''LDAP'' r,4 ob from dual'||chr(10)||
'    union'||chr(10)||
'    select wwv_flow_lang.system_message(''F4000_P808_USE_CUSTOM'') d,'||chr(10)||
'      ''PLUGIN'' r,5 ob from dual)'||chr(10)||
'order by ob');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p826_cust_auth_setups
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 165101109080014291.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P826_CUST_AUTH_SETUPS',
  p_lov_query=> 'select name a,wwv_flow_lang.system_message(''F4000_P826_NEW'')||''_''||name b from wwv_flow_custom_auth_setups where flow_id=:FB_FLOW_ID order by name');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p831_varchar_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 124527100556524029.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P831_VARCHAR_COLS',
  p_lov_query=> 'select htf.escape_sc(c003) d, htf.escape_sc(c003) v from wwv_flow_collections'||chr(10)||
' where collection_name = ''REGION_QUERY_COLL'''||chr(10)||
'order by seq_id'||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p856_sql_scripts
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 4671330627638944.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P856_SQL_SCRIPTS',
  p_lov_query=> 'select filename, id from wwv_flow_files'||chr(10)||
' where file_type = ''SCRIPT'''||chr(10)||
' order by filename');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_groups_with_unassigned_option
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 5085026803855916.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE GROUPS WITH UNASSIGNED OPTION',
  p_lov_query=> 'select group_name, id'||chr(10)||
'from wwv_flow_page_groups g'||chr(10)||
'where flow_id = :fb_flow_id '||chr(10)||
'union'||chr(10)||
'select wwv_flow_lang.system_message(''UNASSIGNED''), 111222333444 id'||chr(10)||
'from dual'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_mode_dynamic_or_static
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 26630118049466478.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE MODE DYNAMIC OR STATIC',
  p_lov_query=> '.'||to_char(26630118049466478 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26630403516466478.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26630118049466478.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Dinamico',
  p_lov_return_value=>'D',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26630601816466479.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26630118049466478.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Cache creata',
  p_lov_return_value=>'C',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26630824926466479.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26630118049466478.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Inserita nella cache',
  p_lov_return_value=>'R',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131011417048612773.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26630118049466478.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Elaborazione pagina',
  p_lov_return_value=>'A',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>116684427784528179.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26630118049466478.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Pagina parziale',
  p_lov_return_value=>'P',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_protection_level
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 17255429593772638.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE PROTECTION LEVEL',
  p_lov_query=> '.'||to_char(17255429593772638 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17255616290772804.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17255429593772638.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Non limitato',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17255831690772804.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17255429593772638.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Gli argomenti devono avere checksum',
  p_lov_return_value=>'C',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17256023739772805.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17255429593772638.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Nessun argomento consentito',
  p_lov_return_value=>'U',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17256209897772805.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17255429593772638.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Nessun accesso URL',
  p_lov_return_value=>'D',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_theme_class_id
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE THEME CLASS ID',
  p_lov_query=> '.'||to_char(41972431732112027 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41972715993112030.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Schede a un livello',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41972909583112031.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Schede a due livelli',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41973110092112031.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Nessuna scheda',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41973323433112031.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Popup',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41973521858112032.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Per la stampa',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41973730212112032.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Login',
  p_lov_return_value=>'6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>49461924616084412.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Schede a un livello con barra laterale',
  p_lov_return_value=>'16',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>49462610895089957.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Nessuna scheda con barra laterale',
  p_lov_return_value=>'17',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>49463017128091735.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Schede a due livelli con barra laterale',
  p_lov_return_value=>'18',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41977231648130915.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 1',
  p_lov_return_value=>'8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41977703036132119.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 2',
  p_lov_return_value=>'9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41978112040134702.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 3',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>48394414687308491.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 4',
  p_lov_return_value=>'11',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>48394916765309025.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 5',
  p_lov_return_value=>'12',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>48395619189309771.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 6',
  p_lov_return_value=>'13',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>48396021613310403.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 7',
  p_lov_return_value=>'14',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>48396424037311168.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>41972431732112027.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 8',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 26295818949995699.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE TYPE',
  p_lov_query=> '.'||to_char(26295818949995699 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26304425276054274.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26295818949995699.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Vuota',
  p_lov_return_value=>'BLANK',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="javascript:setType(''BLANK'');setAction(''BLANK'');"><img src="#IMAGE_PREFIX#menu/app_wiz_blank.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIons" width="84" height="54" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26296000771995699.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26295818949995699.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>15,
  p_lov_disp_value=>'Report',
  p_lov_return_value=>'REPORT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="javascript:setType(''REPORT'');setAction(''REPORT'');"><img src="#IMAGE_PREFIX#menu/app_wiz_report.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="84" height="54" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26339030246339510.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26295818949995699.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Form',
  p_lov_return_value=>'FORM',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="javascript:javascript:setType(''FORM'');setAction(''FORM'');"><img src="#IMAGE_PREFIX#menu/app_wiz_form.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="84" height="54" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>140621812824880060.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26295818949995699.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>35,
  p_lov_disp_value=>'Form tabulare',
  p_lov_return_value=>'TABULARFORM',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="javascript:setType(''TABULARFORM'');setAction(''TABULARFORM'');"><img src="#IMAGE_PREFIX#menu/app_wiz_tab_form.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="84" height="54" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>111746728496258706.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26295818949995699.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>45,
  p_lov_disp_value=>'Master-Detail',
  p_lov_return_value=>'MASTERDETAIL',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="javascript:setType(''MASTERDETAIL'');setAction(''MASTERDETAIL'');"><img src="#IMAGE_PREFIX#menu/app_wiz_md.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="84" height="54" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>139372121893481501.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26295818949995699.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Report e form',
  p_lov_return_value=>'REPORTANDFORM',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="javascript:setType(''REPORTANDFORM'');setAction(''REPORTANDFORM'');"><img src="#IMAGE_PREFIX#menu/app_wiz_form_report.gif" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" width="84" height="54" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>175296625545175280.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26295818949995699.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Grafico a barre',
  p_lov_return_value=>'BAR_CHART',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>175296928315176002.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>26295818949995699.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Grafico a torta',
  p_lov_return_value=>'PIE_CHART',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_view_mode
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 5035605136660409.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE VIEW MODE',
  p_lov_query=> '.'||to_char(5035605136660409 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5035918715660410.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>5035605136660409.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Icone',
  p_lov_return_value=>'ICON',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5036125439660410.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>5035605136660409.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Dettagli',
  p_lov_return_value=>'DETAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5037517603664047.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>5035605136660409.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'per gruppo',
  p_lov_return_value=>'GROUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5381110347931263.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>5035605136660409.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'per tipo',
  p_lov_return_value=>'TYPE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_branch_points
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 179397725241870240.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE.BRANCH.POINTS',
  p_lov_query=> '.'||to_char(179397725241870240 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179398028859870243.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179397725241870240.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'In caso di sottomissione: Prima del calcolo (prima di calcolo, convalida ed elaborazione)',
  p_lov_return_value=>'BEFORE_COMPUTATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179398229442870244.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179397725241870240.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'In caso di sottomissione: Prima della convalida (dopo il calcolo e prima di convalida ed elaborazione)',
  p_lov_return_value=>'BEFORE_VALIDATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179398419489870245.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179397725241870240.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'In caso di sottomissione: Prima dell''elaborazione (dopo calcolo, convalida ed elaborazione)',
  p_lov_return_value=>'BEFORE_PROCESSING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179398614240870246.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179397725241870240.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'In caso di sottomissione: Dopo l''elaborazione (dopo calcolo, convalida ed elaborazione)',
  p_lov_return_value=>'AFTER_PROCESSING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179398805923870247.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>179397725241870240.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'In caso di caricamento: Prima dell''intestazione',
  p_lov_return_value=>'BEFORE_HEADER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_branch_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 15652127549539076.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE.BRANCH.TYPES',
  p_lov_query=> '.'||to_char(15652127549539076 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15652422295539123.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15652127549539076.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Dirama a elaborazione di accettazione pagina (non comune)',
  p_lov_return_value=>'BRANCH_TO_PAGE_ACCEPT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15652604683539128.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15652127549539076.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Dirama a pagina',
  p_lov_return_value=>'BRANCH_TO_STEP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15652814858539128.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15652127549539076.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Dirama a procedura PL/SQL',
  p_lov_return_value=>'PLSQL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15653010159539128.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15652127549539076.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Dirama a pagina o a URL',
  p_lov_return_value=>'REDIRECT_URL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15653228401539129.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15652127549539076.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Dirama a pagina identificata da elemento (utilizza nome elemento)',
  p_lov_return_value=>'BRANCH_TO_PAGE_IDENT_BY_ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15653413667539129.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15652127549539076.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Dirama a URL identificato da elemento (utilizza nome elemento)',
  p_lov_return_value=>'BRANCH_TO_URL_IDENT_BY_ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15653610612539129.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15652127549539076.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Dirama a funzione che restituisce un URL',
  p_lov_return_value=>'BRANCH_TO_FUNCTION_RETURNING_URL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>24865323058688299.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>15652127549539076.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Dirama a funzione che restituisce una pagina',
  p_lov_return_value=>'BRANCH_TO_FUNCTION_RETURNING_PAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_public
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84921112902747500.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE.PUBLIC',
  p_lov_query=> '.'||to_char(84921112902747500 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84921502289747501.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84921112902747500.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'La pagina richiede l''autenticazione',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84921330545747501.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84921112902747500.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'La pagina è pubblica',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_subtitle_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84922124330750817.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE.SUBTITLE.TYPES',
  p_lov_query=> '.'||to_char(84922124330750817 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84923527403750819.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84922124330750817.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Espressione SQL',
  p_lov_return_value=>'SQL_EXPRESSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84923723303750819.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84922124330750817.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'Testo con stringhe di sostituzione',
  p_lov_return_value=>'TEXT_WITH_SUBSTITUTIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_computation_points2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 62981024179015035.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE_COMPUTATION_POINTS2',
  p_lov_query=> '.'||to_char(62981024179015035 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62981313883015043.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62981024179015035.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'In caso di nuova istanza (ad esempio, in caso di login)',
  p_lov_return_value=>'ON_NEW_INSTANCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62981519102015043.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62981024179015035.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Prima dell''intestazione',
  p_lov_return_value=>'BEFORE_HEADER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62981718705015044.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62981024179015035.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Dopo l''intestazione',
  p_lov_return_value=>'AFTER_HEADER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62981911645015044.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62981024179015035.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Prima dell''area o delle aree',
  p_lov_return_value=>'BEFORE_BOX_BODY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62982168927015047.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62981024179015035.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Dopo l''area o le aree',
  p_lov_return_value=>'AFTER_BOX_BODY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62982312758015047.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62981024179015035.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Prima del piè di pagina',
  p_lov_return_value=>'BEFORE_FOOTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62982513587015048.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62981024179015035.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Dopo il piè di pagina',
  p_lov_return_value=>'AFTER_FOOTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62982747036015048.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62981024179015035.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Dopo la sottomissione',
  p_lov_return_value=>'AFTER_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_computation_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86604122856270295.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE_COMPUTATION_TYPE',
  p_lov_query=> '.'||to_char(86604122856270295 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88303124504820277.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86604122856270295.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Elemento in questa pagina',
  p_lov_return_value=>'THIS_PAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88303320734820277.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86604122856270295.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Elemento in un''altra pagina',
  p_lov_return_value=>'PAGE_ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88303522865820278.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86604122856270295.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>''||chr(10)||
'Elemento a livello di applicazione',
  p_lov_return_value=>'FLOW_ITEM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_computation_types2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 62977815884897285.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE_COMPUTATION_TYPES2',
  p_lov_query=> '.'||to_char(62977815884897285 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62978121078897312.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62977815884897285.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Assegnazione statica',
  p_lov_return_value=>'STATIC_ASSIGNMENT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62978343008897315.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62977815884897285.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Corpo funzione PL/SQL',
  p_lov_return_value=>'FUNCTION_BODY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62978514164897316.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62977815884897285.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Query SQL',
  p_lov_return_value=>'QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62978711197897316.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62977815884897285.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Espressione SQL',
  p_lov_return_value=>'SQL_EXPRESSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>62978941617897319.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62977815884897285.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Espressione PL/SQL',
  p_lov_return_value=>'PLSQL_EXPRESSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22684624604995500.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>62977815884897285.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Valore elemento',
  p_lov_return_value=>'ITEM_VALUE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_process_button_ids
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 874104981.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE_PROCESS_BUTTON_IDS',
  p_lov_query=> 'select button_name, id'||chr(10)||
'from   wwv_flow_step_buttons'||chr(10)||
'where  flow_id = :FB_FLOW_ID and'||chr(10)||
'       (flow_step_id = :FB_FLOW_PAGE_ID or flow_step_id = 0)'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_process_dml_fetch_option
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 58946417994211799.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE_PROCESS_DML_FETCH_OPTION',
  p_lov_query=> '.'||to_char(58946417994211799 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>58946722847211810.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>58946417994211799.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Imposta cache memoria al recupero fetch',
  p_lov_return_value=>'F',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>58946901366211810.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>58946417994211799.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Imposta cache memoria solo in caso di visualizzazione',
  p_lov_return_value=>'D',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_size_units
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 11205810538925547.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE_SIZE_UNITS',
  p_lov_query=> '.'||to_char(11205810538925547 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>11206106459925548.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>11205810538925547.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Punti',
  p_lov_return_value=>'POINTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>11206318132925548.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>11205810538925547.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Pollici',
  p_lov_return_value=>'INCHES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>11206525283925548.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>11205810538925547.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Millimetri',
  p_lov_return_value=>'MILIMETERS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>11206721741925548.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>11205810538925547.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Centimetri',
  p_lov_return_value=>'CENTIMETERS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_source
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 141264908196813501.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE_SOURCE',
  p_lov_query=> '.'||to_char(141264908196813501 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>141265101710813505.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>141264908196813501.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Tabella',
  p_lov_return_value=>'TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>141265331215813507.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>141264908196813501.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Query SQL',
  p_lov_return_value=>'QUERY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>141265508498813507.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>141264908196813501.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Dati del foglio di calcolo',
  p_lov_return_value=>'SPREADSHEET',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_template_wiz
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86592719346240927.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE_TEMPLATE_WIZ',
  p_lov_query=> '.'||to_char(86592719346240927 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88304318793821260.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86592719346240927.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Completamente nuovo/a',
  p_lov_return_value=>'BLANK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88304522228821260.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86592719346240927.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Come copia di un modello esistente',
  p_lov_return_value=>'COPY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_validation_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 131915151655.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE_VALIDATION_TYPES',
  p_lov_query=> '.'||to_char(131915151655 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88159421716967927.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Esiste',
  p_lov_return_value=>'EXISTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88159624014967927.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Funzione che restituisce un risultato booleano',
  p_lov_return_value=>'FUNC_BODY_RETURNING_BOOLEAN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88159825561967927.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Funzione che restituisce il testo dell''errore',
  p_lov_return_value=>'FUNC_BODY_RETURNING_ERR_TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88160001279967928.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'L''elemento specificato è NOT NULL',
  p_lov_return_value=>'ITEM_NOT_NULL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88160205381967928.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'L''elemento in Espressione 1 contiene almeno un carattere in Espressione 2',
  p_lov_return_value=>'ITEM_IN_VALIDATION_CONTAINS_AT_LEAST_ONE_CHAR_IN_STRING2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88160405596967928.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'L''elemento in Espressione 1 contiene solo caratteri in Espressione 2',
  p_lov_return_value=>'ITEM_IN_VALIDATION_CONTAINS_ONLY_CHAR_IN_STRING2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88160629326967929.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'L''elemento in Espressione 1 NON è uguale al valore di stringa in Espressione 2',
  p_lov_return_value=>'ITEM_IN_VALIDATION_NOT_EQ_STRING2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88160803174967929.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'L''elemento in Espressione 1 NON contiene nessun carattere in Espressione 2',
  p_lov_return_value=>'ITEM_IN_VALIDATION_CONTAINS_NO_CHAR_IN_STRING2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88161023720967929.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'L''elemento in Espressione 1 è uguale al valore di stringa in Espressione 2',
  p_lov_return_value=>'ITEM_IN_VALIDATION_EQ_STRING2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88161215339967929.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'L''elemento in Espressione 1 NON è contenuto in Espressione 2',
  p_lov_return_value=>'ITEM_IN_VALIDATION_NOT_IN_STRING2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88161429567967930.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'L''elemento in Espressione 1 è contenuto in Espressione 2',
  p_lov_return_value=>'ITEM_IN_VALIDATION_IN_STRING2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88161630524967930.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'L''elemento specificato è diverso da zero',
  p_lov_return_value=>'ITEM_NOT_ZERO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88161809824967930.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'L''elemento specificato non contiene spazi',
  p_lov_return_value=>'ITEM_CONTAINS_NO_SPACES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88162030394967930.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>140,
  p_lov_disp_value=>'L''elemento specificato è NOT NULL o zero',
  p_lov_return_value=>'ITEM_NOT_NULL_OR_ZERO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88162230185967930.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>150,
  p_lov_disp_value=>'L''elemento specificato è alfanumerico',
  p_lov_return_value=>'ITEM_IS_ALPHANUMERIC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88162428823967931.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>160,
  p_lov_disp_value=>'L''elemento specificato è numerico',
  p_lov_return_value=>'ITEM_IS_NUMERIC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42663306349689860.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>165,
  p_lov_disp_value=>'L''elemento specificato è una data valida',
  p_lov_return_value=>'ITEM_IS_DATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88162620381967931.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>170,
  p_lov_disp_value=>'Non esiste',
  p_lov_return_value=>'NOT_EXISTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88162807376967931.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>180,
  p_lov_disp_value=>'Errore PL/SQL',
  p_lov_return_value=>'PLSQL_ERROR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88163214798967932.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>200,
  p_lov_disp_value=>'Espressione PL/SQL',
  p_lov_return_value=>'PLSQL_EXPRESSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88163405736967932.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>210,
  p_lov_disp_value=>'Espressione regolare',
  p_lov_return_value=>'REGULAR_EXPRESSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88163626551967932.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131915151655.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>220,
  p_lov_disp_value=>'Espressione SQL',
  p_lov_return_value=>'SQL_EXPRESSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_view_mode
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84240119994394393.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE_VIEW_MODE',
  p_lov_query=> '.'||to_char(84240119994394393 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84240330663394394.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84240119994394393.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Lista',
  p_lov_return_value=>'LIST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84240527246394394.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84240119994394393.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Dettaglio',
  p_lov_return_value=>'DETAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pagination
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 99817717480817679.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGINATION',
  p_lov_query=> '.'||to_char(99817717480817679 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>99818003503817701.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>99817717480817679.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Intervalli di righe da X a Y di Z (senza impaginazione)',
  p_lov_return_value=>'ROWS_X_TO_Y_OF_Z',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>99818224386817703.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>99817717480817679.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Intervalli di righe da X a Y (senza impaginazione)',
  p_lov_return_value=>'ROWS_X_TO_Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>99818416060817704.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>99817717480817679.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Motore di ricerca 1,2,3,4 (impaginazione in base a set)',
  p_lov_return_value=>'SEARCH_ENGINE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>99818616394817704.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>99817717480817679.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Utilizza pulsanti di impaginazione creati esternamente',
  p_lov_return_value=>'COMPUTED_BUT_NOT_DISPLAYED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>99818822634817704.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>99817717480817679.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Intervalli di righe 1-15 16-30 (con impaginazione)',
  p_lov_return_value=>'ROW_RANGES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>99819028134817704.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>99817717480817679.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Intervalli di righe 1-15 16-30 nella lista di selezione (con impaginazione)',
  p_lov_return_value=>'ROW_RANGES_IN_SELECT_LIST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>99819821574817706.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>99817717480817679.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Intervalli di righe da X a Y di Z (con impaginazione)',
  p_lov_return_value=>'ROW_RANGES_WITH_LINKS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>39002816961800537.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>99817717480817679.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Intervalli di righe da X a Y (con collegamenti Successivo e Precedente)',
  p_lov_return_value=>'NEXT_PREVIOUS_LINKS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pagination_display_position
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 3941822825486065.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGINATION.DISPLAY.POSITION',
  p_lov_query=> '.'||to_char(3941822825486065 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88164425179968925.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>3941822825486065.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'In basso - A sinistra',
  p_lov_return_value=>'BOTTOM_LEFT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88164621858968925.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>3941822825486065.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'In basso - A destra',
  p_lov_return_value=>'BOTTOM_RIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88164803008968926.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>3941822825486065.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'In alto - A sinistra',
  p_lov_return_value=>'TOP_LEFT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88165000666968926.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>3941822825486065.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'In alto - A destra',
  p_lov_return_value=>'TOP_RIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88165212735968926.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>3941822825486065.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'In alto e in basso - A sinistra',
  p_lov_return_value=>'TOP_AND_BOTTOM_LEFT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88165425741968928.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>3941822825486065.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'In alto e in basso - A destra',
  p_lov_return_value=>'TOP_AND_BOTTOM_RIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/parent_list_list_items
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6467729263888343.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PARENT_LIST.LIST_ITEMS',
  p_lov_query=> 'select lpad('' '',4*(level-1),''.'')|| htf.escape_sc(list_item_link_text) list_item_link_text, id'||chr(10)||
'from wwv_flow_list_items i'||chr(10)||
'where flow_id = :FB_FLOW_ID'||chr(10)||
'and list_id = :P4053_LIST_ID'||chr(10)||
'and id not in ('||chr(10)||
'    select id from wwv_flow_list_items '||chr(10)||
'    where flow_id = :FB_FLOW_ID'||chr(10)||
'    and list_id = :P4053_LIST_ID'||chr(10)||
'    start with id = :P4053_ID '||chr(10)||
'    connect by prior id = parent_list_item_id'||chr(10)||
')'||chr(10)||
'start with parent_list_item_id is null'||chr(10)||
'connect by prior id = parent_list_item_id '||chr(10)||
'order siblings by list_item_display_sequence');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/parent_tab_set
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 83376300088038016.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PARENT_TAB_SET',
  p_lov_query=> 'select distinct htf.escape_sc(tab_set) d, tab_set r'||chr(10)||
''||chr(10)||
'from wwv_flow_toplevel_tabs'||chr(10)||
''||chr(10)||
'where flow_id = nv(''FB_FLOW_ID'') and'||chr(10)||
''||chr(10)||
'      security_group_id = :flow_security_group_id'||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/persistence_opts
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84831517957313758.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PERSISTENCE_OPTS',
  p_lov_query=> '.'||to_char(84831517957313758 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84831715807313758.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84831517957313758.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Per sessione',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84831914478313759.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84831517957313758.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Per utente',
  p_lov_return_value=>'U',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_custom_css_link
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 353335506996711467.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK CUSTOM CSS LINK',
  p_lov_query=> 'select ''#IMAGE''||''_PREFIX#themes/theme_''||theme_id||''/svg.css'' d,'||chr(10)||
'''#IMAGE''||''_PREFIX#themes/theme_''||theme_id||''/svg.css'' r'||chr(10)||
'from   wwv_flows where id = :fb_flow_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_date_control
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK.DATE.CONTROL',
  p_lov_query=> '.'||to_char(8939518277555292 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8939806936555294.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-RR HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8940005040555294.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-RR HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8940218608555295.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-RR)',
  p_lov_return_value=>'PICK_DATE_DD_MON_RR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8940417253555295.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-YY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH24_MI',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8940616028555295.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-YY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH_MI',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8940802200555295.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-YY)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YY',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8941030833555296.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8941218319555297.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8941432608555297.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MON-YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8941612270555297.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD/MM/YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8941815079555297.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD/MM/YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8942011007555297.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD/MM/YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8942221293555298.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (MM/DD/YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8942424972555298.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (MM/DD/YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8942616012555298.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (MM/DD/YYYY)',
  p_lov_return_value=>'PICK_DATE_MM_DD_YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8943303863560518.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (utilizza il formato di visualizzazione per le applicazioni)',
  p_lov_return_value=>'PICK_DATE_USING_FLOW_FORMAT_MASK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21407415180830392.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (RR-MON-DD HH:MI)',
  p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21409217735840569.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (RR-MON-DD HH24:MI)',
  p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21410204014846015.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MM-YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21410514057848914.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MM-YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21411120983850992.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD-MM-YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21412314881858604.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD.MM.YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21412821807860681.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD.MM.YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21413531850863545.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (DD.MM.YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21415526786871500.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY-MM-DD HH:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21416200252873316.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY-MM-DD HH24:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21418117220878211.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY.DD.MM)',
  p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21418826571880927.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY.DD.MM HH24:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21419104192883936.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY.DD.MM HH:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21420219776888407.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY/MM/DD)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_SLASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21420726355890309.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY/MM/DD HH24:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21421200514892330.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY/MM/DD HH:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41116914941768690.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (YYYY-MM-DD)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41118126715772067.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (RR-MON-DD)',
  p_lov_return_value=>'PICK_DATE_RR_MON_DD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88326810395228745.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (utilizza il formato di visualizzazione per gli elementi)',
  p_lov_return_value=>'PICK_DATE_USING_FORMAT_MASK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108022202700834601.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8939518277555292.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data (utilizza il formato data dell''applicazione)',
  p_lov_return_value=>'PICK_DATE_USING_APP_DATE_FORMAT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_display_only_control
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 9312620039750048.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK.DISPLAY.ONLY.CONTROL',
  p_lov_query=> '.'||to_char(9312620039750048 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9312920528750052.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9312620039750048.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Visualizza come testo (non salva lo stato)',
  p_lov_return_value=>'DISPLAY_ONLY_HTML',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9313104767750054.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9312620039750048.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Visualizza come testo (caratteri speciali di escape, non salva lo stato)',
  p_lov_return_value=>'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9313305110750054.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9312620039750048.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Visualizza come testo (salva lo stato)',
  p_lov_return_value=>'DISPLAY_AND_SAVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9313518955750054.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9312620039750048.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Visualizza come testo (basato su LOV, salva lo stato)',
  p_lov_return_value=>'DISPLAY_AND_SAVE_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9313730738750055.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9312620039750048.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Visualizza come testo (basato su LOV, non salva lo stato)',
  p_lov_return_value=>'DISPLAY_ONLY_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_item_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK.ITEM.TYPE',
  p_lov_query=> '.'||to_char(8907709900373021 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8908418989373024.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista di selezione',
  p_lov_return_value=>'SELECT_LIST',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:367:&SESSION."><img src="#IMAGE_PREFIX#htmldb/icons/text_pulldwn.gif" height="60" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8908601172373024.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Pulsante di scelta',
  p_lov_return_value=>'RADIO',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:86:&SESSION."><img src="#IMAGE_PREFIX#htmldb/icons/text_radio.gif" height="60" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8908828638373027.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Nascosto',
  p_lov_return_value=>'HIDDEN',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:732:&SESSION.::::F4000_P4717_DISPLAY_AS:HIDDEN"><img src="#IMAGE_PREFIX#htmldb/icons/text_hidden.gif"  height="60" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8909015142373027.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Casella di controllo',
  p_lov_return_value=>'CHECKBOX',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4717:&SESSION.::::F4000_P4717_DISPLAY_AS:CHECKBOX"><img src="#IMAGE_PREFIX#htmldb/icons/text_check.gif" height="60" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8909219514373028.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selettore data',
  p_lov_return_value=>'DATE_PICKER',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:370:&SESSION."><img src="#IMAGE_PREFIX#htmldb/icons/text_cal.gif"  height="60" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8909408222373028.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Password',
  p_lov_return_value=>'PASSWORD',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:89:&SESSION."><img src="#IMAGE_PREFIX#htmldb/icons/text_pswd.gif" height="60" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8909609752373028.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sola visualizzazione',
  p_lov_return_value=>'DISPLAY_ONLY',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:75:&SESSION."><img src="#IMAGE_PREFIX#htmldb/icons/text_html2.gif" height="60" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8909813534373028.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista di valori popup',
  p_lov_return_value=>'POPUP',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:377:&SESSION."><img src="#IMAGE_PREFIX#htmldb/icons/text_popup.gif" height="60" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8910020508373028.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Selezione multipla',
  p_lov_return_value=>'MULTIPLE_SELECT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4717:&SESSION.::::F4000_P4717_DISPLAY_AS:MULTIPLESELECT"><img src="#IMAGE_PREFIX#htmldb/icons/text_list.gif" height="60" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8910208834373029.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Gestione lista',
  p_lov_return_value=>'LIST_MANAGER',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:84:&SESSION."><img src="#IMAGE_PREFIX#htmldb/icons/text_listmgr.gif" height="60" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9404502489953110.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Sfoglia file',
  p_lov_return_value=>'FILE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4717:&SESSION.::::F4000_P4717_DISPLAY_AS:FILE" alt="File Browse Control Type"><img src="#IMAGE_PREFIX#htmldb/icons/text_fileupload.gif" height="60" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41159810857656724.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Shuttle',
  p_lov_return_value=>'SHUTTLE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4717:&SESSION.::::F4000_P4717_DISPLAY_AS:SHUTTLE"><img src="#IMAGE_PREFIX#htmldb/icons/shuttle.gif" height="60" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8908006653373023.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Testo',
  p_lov_return_value=>'TEXT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:87:&SESSION."><img src="#IMAGE_PREFIX#htmldb/icons/text_text.gif" height="60" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8908224799373024.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Area di testo',
  p_lov_return_value=>'TEXTAREA',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:383:&SESSION.::::"><img src="#IMAGE_PREFIX#htmldb/icons/text_area.gif" height="60" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>28057322773126767.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8907709900373021.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arresta e avvia tabella',
  p_lov_return_value=>'STOP_AND_START_HTML_TABLE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:690:&SESSION.::NO::F4000_P690_DISPLAY_AS:STOP_AND_START_HTML_TABLE"><img src="#IMAGE_PREFIX#htmldb/icons/text_start_stop_html.gif" height="60" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_list_manager_control_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 9331900608791712.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK.LIST.MANAGER.CONTROL.TYPE',
  p_lov_query=> '.'||to_char(9331900608791712 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9332228901791715.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9331900608791712.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Gestione lista (sola visualizzazione)',
  p_lov_return_value=>'LIST_MGR_VIEW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9332408015791716.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9331900608791712.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Gestione lista (basata su LOV popup)',
  p_lov_return_value=>'LIST_MGR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9332609015791716.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9331900608791712.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Gestione lista (basata su LOV popup, senza recupero fetch)',
  p_lov_return_value=>'LIST_MGR2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9332801216791716.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9331900608791712.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Gestione lista (basata su LOV popup, le maiuscole/minuscole vengono mantenute)',
  p_lov_return_value=>'LIST_MGR3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_password_control_display_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 9421929417979900.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK.PASSWORD.CONTROL.DISPLAY.TYPE',
  p_lov_query=> '.'||to_char(9421929417979900 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9422216461979902.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9421929417979900.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Password',
  p_lov_return_value=>'PASSWORD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9422405924979902.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9421929417979900.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Password (sottomessa se si preme Invio)',
  p_lov_return_value=>'PASSWORD_WITH_ENTER_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>273627315372899705.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9421929417979900.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Password (non salva lo stato)',
  p_lov_return_value=>'PASSWORD_DNSS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>273627525415902552.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9421929417979900.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Password (sottomessa se si preme Invio, non salva lo stato)',
  p_lov_return_value=>'PASSWORD_WITH_SUBMIT_DNSS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_plsql_validation_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 9572322050621169.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK.PLSQL.VALIDATION.TYPE',
  p_lov_query=> '.'||to_char(9572322050621169 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9572609687621171.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9572322050621169.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Espressione PL/SQL',
  p_lov_return_value=>'PLSQL_EXPRESSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9572832523621172.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9572322050621169.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Errore PL/SQL',
  p_lov_return_value=>'PLSQL_ERROR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9573017854621172.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9572322050621169.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Funzione che restituisce un risultato booleano',
  p_lov_return_value=>'FUNC_BODY_RETURNING_BOOLEAN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9573212373621172.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9572322050621169.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Funzione che restituisce il testo dell''errore',
  p_lov_return_value=>'FUNC_BODY_RETURNING_ERR_TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_popup_lov_control
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 8961400194644667.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK.POPUP.LOV.CONTROL',
  p_lov_query=> '.'||to_char(8961400194644667 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8961710744644668.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8961400194644667.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista di valori chiave popup (visualizza la descrizione, restituisce il valore chiave)',
  p_lov_return_value=>'POPUP_KEY_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8961907287644669.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8961400194644667.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista di valori chiave popup senza recupero fetch (visualizza la descrizione, restituisce un valore chiave senza recupero fetch preventivo)',
  p_lov_return_value=>'POPUP_KEY_LOV_NOFETCH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8962122737644669.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8961400194644667.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'LOV popup (recupera tramite fetch il primo rowset e filtra)',
  p_lov_return_value=>'POPUP_FILTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8962325899644669.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8961400194644667.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'LOV popup (recupera tramite fetch il primo rowset)',
  p_lov_return_value=>'POPUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8962521351644670.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8961400194644667.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'LOV popup (senza recupero fetch)',
  p_lov_return_value=>'POPUP2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>15826115948684173.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8961400194644667.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Selettore colori popup',
  p_lov_return_value=>'POPUP_COLOR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_radio_group_control_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 9370221611864019.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK.RADIO.GROUP.CONTROL.TYPE',
  p_lov_query=> '.'||to_char(9370221611864019 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9370504051864022.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9370221611864019.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Gruppo di scelta',
  p_lov_return_value=>'RADIOGROUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9370722367864023.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9370221611864019.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Gruppo di scelta (con sottomissione)',
  p_lov_return_value=>'RADIOGROUP_WITH_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9370900699864023.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9370221611864019.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Gruppo di scelta con reindirizzamento',
  p_lov_return_value=>'RADIOGROUP_WITH_REDIRECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_select_list_control
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 8927530997502113.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK.SELECT.LIST.CONTROL',
  p_lov_query=> '.'||to_char(8927530997502113 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8927823148502114.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8927530997502113.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Lista di selezione',
  p_lov_return_value=>'COMBOBOX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8928009864502114.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8927530997502113.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Seleziona lista che restituisce un reindirizzamento URL',
  p_lov_return_value=>'COMBOBOX_WITH_URL_REDIRECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8928228251502115.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8927530997502113.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Seleziona lista con diramazione a pagina',
  p_lov_return_value=>'COMBOBOX_WITH_BRANCH_TO_PAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8928601430502115.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8927530997502113.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Seleziona lista con reindirizzamento',
  p_lov_return_value=>'COMBOBOX_WITH_JS_REDIRECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8928808975502115.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>8927530997502113.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Seleziona lista da sottomettere',
  p_lov_return_value=>'COMBOBOX_WITH_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_sql_validation_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 9550628667575751.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK.SQL.VALIDATION.TYPE',
  p_lov_query=> '.'||to_char(9550628667575751 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9550909293575752.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9550628667575751.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Esiste',
  p_lov_return_value=>'EXISTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9551319496575752.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9550628667575751.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Non esiste',
  p_lov_return_value=>'NOT_EXISTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9551120973575752.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9550628667575751.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Espressione SQL',
  p_lov_return_value=>'SQL_EXPRESSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_string_validation_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 9731101954239883.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK.STRING.VALIDATION.TYPE',
  p_lov_query=> '.'||to_char(9731101954239883 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9731418885239887.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9731101954239883.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'L''elemento in Espressione 1 contiene almeno un carattere in Espressione 2',
  p_lov_return_value=>'ITEM_IN_VALIDATION_CONTAINS_AT_LEAST_ONE_CHAR_IN_STRING2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9731631431239888.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9731101954239883.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'L''elemento in Espressione 1 contiene solo caratteri in Espressione 2',
  p_lov_return_value=>'ITEM_IN_VALIDATION_CONTAINS_ONLY_CHAR_IN_STRING2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9731828177239889.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9731101954239883.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'L''elemento in Espressione 1 NON è uguale al valore di stringa in Espressione 2',
  p_lov_return_value=>'ITEM_IN_VALIDATION_NOT_EQ_STRING2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9732010850239889.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9731101954239883.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'L''elemento in Espressione 1 NON contiene nessun carattere in Espressione 2',
  p_lov_return_value=>'ITEM_IN_VALIDATION_CONTAINS_NO_CHAR_IN_STRING2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9732208382239889.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9731101954239883.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'L''elemento in Espressione 1 è uguale al valore di stringa in Espressione 2',
  p_lov_return_value=>'ITEM_IN_VALIDATION_EQ_STRING2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9732431782239889.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9731101954239883.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'L''elemento in Espressione 1 NON è contenuto in Espressione 2',
  p_lov_return_value=>'ITEM_IN_VALIDATION_NOT_IN_STRING2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9732607301239890.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9731101954239883.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'L''elemento in Espressione 1 è contenuto in Espressione 2',
  p_lov_return_value=>'ITEM_IN_VALIDATION_IN_STRING2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9732825711239890.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9731101954239883.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'L''elemento specificato è diverso da zero',
  p_lov_return_value=>'ITEM_NOT_ZERO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9733015339239890.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9731101954239883.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'L''elemento specificato non contiene spazi',
  p_lov_return_value=>'ITEM_CONTAINS_NO_SPACES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9733201104239890.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9731101954239883.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'L''elemento specificato è NOT NULL o zero',
  p_lov_return_value=>'ITEM_NOT_NULL_OR_ZERO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9733408618239891.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9731101954239883.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'L''elemento specificato è alfanumerico',
  p_lov_return_value=>'ITEM_IS_ALPHANUMERIC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9733604294239891.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9731101954239883.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>12,
  p_lov_disp_value=>'L''elemento specificato è numerico',
  p_lov_return_value=>'ITEM_IS_NUMERIC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42690531283697125.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9731101954239883.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>13,
  p_lov_disp_value=>'L''elemento specificato è una data valida',
  p_lov_return_value=>'ITEM_IS_DATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_text_control_display_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 9386810707898727.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK.TEXT.CONTROL.DISPLAY.TYPE',
  p_lov_query=> '.'||to_char(9386810707898727 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9387127521898729.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9386810707898727.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Campo di testo',
  p_lov_return_value=>'TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9387319647898729.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9386810707898727.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Campo di testo (disabilitato, non salva lo stato)',
  p_lov_return_value=>'TEXT_DISABLED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9387508899898730.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9386810707898727.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Campo di testo (disabilitato, salva lo stato)',
  p_lov_return_value=>'TEXT_DISABLED_AND_SAVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9387701668898730.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9386810707898727.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Campo di testo (la pagina viene sottomessa sempre quando si preme Invio)',
  p_lov_return_value=>'TEXT_WITH_ENTER_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9387931382898730.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9386810707898727.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Campo di testo con popup della calcolatrice',
  p_lov_return_value=>'TEXT_WITH_CALCULATOR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_textarea_control
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 9002004846806891.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK.TEXTAREA.CONTROL',
  p_lov_query=> '.'||to_char(9002004846806891 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9002321391806894.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9002004846806891.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area di testo',
  p_lov_return_value=>'TEXTAREA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9002512609806894.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9002004846806891.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Area di testo (altezza automatica)',
  p_lov_return_value=>'TEXTAREA-AUTO-HEIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9002701859806894.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9002004846806891.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Area di testo con conteggio caratteri',
  p_lov_return_value=>'TEXTAREA_CHAR_COUNT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9002925971806895.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9002004846806891.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Area di testo con conteggio caratteri e controllo ortografico',
  p_lov_return_value=>'TEXTAREA_CHAR_COUNT_SPELL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9003319219806895.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9002004846806891.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Area di testo con correzione ortografica',
  p_lov_return_value=>'TEXTAREA_WITH_SPELL_CHECK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47271424712102995.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9002004846806891.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Editor HTML minimo',
  p_lov_return_value=>'TEXTAREA_WITH_HTML_EDITOR_BASIC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>47271926575104432.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9002004846806891.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Editor HTML standard',
  p_lov_return_value=>'TEXTAREA_WITH_HTML_EDITOR_STANDARD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9003131815806895.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9002004846806891.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>99,
  p_lov_disp_value=>'Area di testo con editor HTML (non valida)',
  p_lov_return_value=>'TEXTAREA_WITH_CONTROLS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_validation_category
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 11226805981881336.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK.VALIDATION.CATEGORY',
  p_lov_query=> '.'||to_char(11226805981881336 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>11227126312881337.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>11226805981881336.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'SQL<br /><img src="#IMAGE_PREFIX#htmldb/icons/validation_sql.gif" height="75" width="100" alt="Segnaposto" />',
  p_lov_return_value=>'SQL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>11227327505881337.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>11226805981881336.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'PL/SQL<br /><img src="#IMAGE_PREFIX#htmldb/icons/validation_plsql.gif" height="75" width="100" alt="Segnaposto" />',
  p_lov_return_value=>'PLSQL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>11227532202881337.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>11226805981881336.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Elemento NOT NULL<br /><img src="#IMAGE_PREFIX#htmldb/icons/validation_notnull.gif" height="75" width="100" alt="Segnaposto" />',
  p_lov_return_value=>'NOT_NULL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>11227705592881338.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>11226805981881336.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Confronto stringhe elemento<br /><img src="#IMAGE_PREFIX#htmldb/icons/validation_stringcompare.gif" height="75" width="100" alt="Segnaposto" />',
  p_lov_return_value=>'STRING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>11227907063881338.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>11226805981881336.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Espressione regolare<br /><img src="#IMAGE_PREFIX#htmldb/icons/validation_regexp.gif" height="75" width="100" alt="Segnaposto" />',
  p_lov_return_value=>'REGEX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_validation_category_with_images
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 9536028012528261.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK.VALIDATION.CATEGORY (WITH IMAGES)',
  p_lov_query=> '.'||to_char(9536028012528261 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9536313428528264.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9536028012528261.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'SQL',
  p_lov_return_value=>'SQL',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:98:&SESSION.::::P91_VALIDATION,F4000_P4737_NAME:SQL,&P252_ITEM."><img src="#IMAGE_PREFIX#htmldb/icons/validation_sql.gif" height="115" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9536510909528264.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9536028012528261.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'PL/SQL',
  p_lov_return_value=>'PLSQL',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:237:&SESSION.::::P91_VALIDATION,F4000_P4737_NAME:PLSQL,&P252_ITEM."><img src="#IMAGE_PREFIX#htmldb/icons/validation_plsql.gif" height="115" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9536732257528264.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9536028012528261.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Elemento NOT NULL',
  p_lov_return_value=>'ITEM_NOT_NULL',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4737:&SESSION.::::F4000_P4737_VALIDATION_TYPE,F4000_P4737_NAME,F4000_P4738_ITEM_VALIDATION:ITEM_NOT_NULL,&P252_ITEM.,&P252_ITEM."><img src="#IMAGE_PREFIX#htmldb/icons/validation_notnull.gif" height="115" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9536927140528265.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9536028012528261.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Confronto stringhe elemento',
  p_lov_return_value=>'STRING',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:244:&SESSION.::::P91_VALIDATION,F4000_P4737_NAME:STRING,&P252_ITEM."><img src="#IMAGE_PREFIX#htmldb/icons/validation_stringcompare.gif" height="115" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9537131769528265.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>9536028012528261.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Espressione regolare',
  p_lov_return_value=>'REGULAR_EXPRESSION',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:4737:&SESSION.::::F4000_P4737_NAME,F4000_P4737_VALIDATION_TYPE,F4000_P4738_ITEM_VALIDATION:&P91_ITEM.,REGULAR_EXPRESSION,&P91_ITEM."><img src="#IMAGE_PREFIX#htmldb/icons/validation_regexp.gif" height="115" width="140" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_disp_cond_type=>'FUNCTION_BODY',
  p_lov_disp_cond=> 'return wwv_flow_utilities.db_version_is_at_least(''10.1'');',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_export_flowid_user_has_priv_on
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 361587217232122032.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK_EXPORT_FLOWID_USER_HAS_PRIV_ON',
  p_lov_query=> 'select distinct f.id||'' ''||htf.escape_sc(f.name) d, f.id r'||chr(10)||
'from   wwv_flows f'||chr(10)||
'where  '||chr(10)||
'       security_group_id = :flow_security_group_id and'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id )'||chr(10)||
'       or'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id) '||chr(10)||
'order by 2');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_flowid_user_has_priv_on
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 138126827261.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK_FLOWID_USER_HAS_PRIV_ON',
  p_lov_query=> 'select distinct f.id||'' ''||htf.escape_sc(f.name) d, f.id r'||chr(10)||
'from   wwv_flows f'||chr(10)||
'where  security_group_id = :flow_security_group_id and'||chr(10)||
'       (exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id )'||chr(10)||
'       or'||chr(10)||
'       exists ('||chr(10)||
'       select 1 from wwv_flow_developers'||chr(10)||
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id)) and'||chr(10)||
'       not exists ('||chr(10)||
'       select null from wwv_flow_language_map'||chr(10)||
'       where translation_flow_id = f.id and '||chr(10)||
'         security_group_id = :flow_security_group_id)'||chr(10)||
'order by 2');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pick_image_name
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 136371109397.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PICK_IMAGE_NAME',
  p_lov_query=> 'select htf.escape_sc(image_name) ||'||chr(10)||
'  decode(substr(image_tag,2,1),'||chr(10)||
'         ''I'','||chr(10)||
'  '' (''||wwv_flow_lang.system_message(''CORE'')||'' ''||'||chr(10)||
'  wwv_flow_lang.system_message(''IMAGE'')||'')'','||chr(10)||
'         ''C'','||chr(10)||
'  '' (''||wwv_flow_lang.system_message(''WORKSPACE'')||'' ''||'||chr(10)||
'  wwv_flow_lang.system_message(''IMAGE'')||'')'','||chr(10)||
'         ''F'','||chr(10)||
'  '' (''||wwv_flow_lang.system_message(''APPLICATION'')||'' ''||'||chr(10)||
'  wwv_flow_lang.system_message(''IMAGE'')||'')'')  image_tag_display,'||chr(10)||
'  decode(substr(image_tag,2,1),''I'',image_name,image_tag) image_tag_value'||chr(10)||
'  from wwv_flow_image_repository'||chr(10)||
'  where security_group_id in (10, :flow_security_group_id)'||chr(10)||
'   and flow_id in (0,:fb_flow_id)'||chr(10)||
'  order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pk_col_source_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 61980328547580148.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PK_COL_SOURCE_TYPES',
  p_lov_query=> '.'||to_char(61980328547580148 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>140599112551723132.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>61980328547580148.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Trigger esistente',
  p_lov_return_value=>'T',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:507:&SESSION.::::P507_MASTER_PK1_SOURCE_TYPE:T"><img src="#IMAGE_PREFIX#htmldb/builder/pk_md1_tgr.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>137620517158106424.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>61980328547580148.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Funzione PL/SQL personalizzata',
  p_lov_return_value=>'F',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:507:&SESSION.::::P507_MASTER_PK1_SOURCE_TYPE:F"><img src="#IMAGE_PREFIX#htmldb/builder/pk_md1_fkt.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>170961208319891869.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>61980328547580148.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Sequenza esistente',
  p_lov_return_value=>'S',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:507:&SESSION.::::P507_MASTER_PK1_SOURCE_TYPE:S"><img src="#IMAGE_PREFIX#htmldb/builder/pk_md1_seq.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>61980804982580156.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>61980328547580148.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Espressione PL/SQL',
  p_lov_return_value=>'P',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pk_col_source_types_appontab
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 353752011984848325.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PK_COL_SOURCE_TYPES.APPONTAB',
  p_lov_query=> '.'||to_char(353752011984848325 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>353752432436848347.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>353752011984848325.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Trigger esistente',
  p_lov_return_value=>'T',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:322:&SESSION.::::P322_PK1_SOURCE_TYPE:T"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_tgr.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>353752608027848348.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>353752011984848325.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Funzione PL/SQL personalizzata',
  p_lov_return_value=>'F',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:322:&SESSION.::::P322_PK1_SOURCE_TYPE:F"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_fkt.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>353752801284848348.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>353752011984848325.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Sequenza esistente',
  p_lov_return_value=>'S',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:322:&SESSION.::::P322_PK1_SOURCE_TYPE:S"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_seq.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pk_col_source_types_appontab_pk2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 354663504966529830.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PK_COL_SOURCE_TYPES.APPONTAB.PK2',
  p_lov_query=> '.'||to_char(354663504966529830 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>354663817551529832.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>354663504966529830.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Trigger esistente',
  p_lov_return_value=>'T',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:322:&SESSION.::::P322_PK2_SOURCE_TYPE:T"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_tgr.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>354664018203529833.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>354663504966529830.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Funzione PL/SQL personalizzata',
  p_lov_return_value=>'F',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:322:&SESSION.::::P322_PK2_SOURCE_TYPE:F"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_fkt.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>354664228766529833.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>354663504966529830.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Sequenza esistente',
  p_lov_return_value=>'S',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:322:&SESSION.::::P322_PK2_SOURCE_TYPE:S"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_seq.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pk_col_source_types_detail_table
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 352799013917119271.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PK_COL_SOURCE_TYPES.DETAIL_TABLE',
  p_lov_query=> '.'||to_char(352799013917119271 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>352799326578119281.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>352799013917119271.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Trigger esistente',
  p_lov_return_value=>'T',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:508:&SESSION.::::P508_DETAIL_PK1_SOURCE_TYPE:T"><img src="#IMAGE_PREFIX#htmldb/builder/pk_md2_tgr.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>352799504982119287.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>352799013917119271.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Funzione PL/SQL personalizzata',
  p_lov_return_value=>'F',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:508:&SESSION.::::P508_DETAIL_PK1_SOURCE_TYPE:F"><img src="#IMAGE_PREFIX#htmldb/builder/pk_md2_fkt.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>352799732085119287.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>352799013917119271.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Sequenza esistente',
  p_lov_return_value=>'S',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:508:&SESSION.::::P508_DETAIL_PK1_SOURCE_TYPE:S"><img src="#IMAGE_PREFIX#htmldb/builder/pk_md2_seq.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pk_col_source_types_detail_table_pk2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 354857822180853056.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PK_COL_SOURCE_TYPES.DETAIL_TABLE.pk2',
  p_lov_query=> '.'||to_char(354857822180853056 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>354858126082853060.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>354857822180853056.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Trigger esistente',
  p_lov_return_value=>'T',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:508:&SESSION.::::P508_DETAIL_PK2_SOURCE_TYPE:T"><img src="#IMAGE_PREFIX#htmldb/builder/pk_md2_tgr.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>354858324350853060.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>354857822180853056.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Funzione PL/SQL personalizzata',
  p_lov_return_value=>'F',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:508:&SESSION.::::P508_DETAIL_PK2_SOURCE_TYPE:F"><img src="#IMAGE_PREFIX#htmldb/builder/pk_md2_fkt.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>354858518105853060.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>354857822180853056.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Sequenza esistente',
  p_lov_return_value=>'S',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:508:&SESSION.::::P508_DETAIL_PK2_SOURCE_TYPE:S"><img src="#IMAGE_PREFIX#htmldb/builder/pk_md2_seq.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pk_col_source_types_form_and_rpt
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 353086022864435670.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PK_COL_SOURCE_TYPES.FORM_AND_RPT',
  p_lov_query=> '.'||to_char(353086022864435670 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>353086319474435683.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>353086022864435670.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Trigger esistente',
  p_lov_return_value=>'T',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:443:&SESSION.::::P443_PK1_SOURCE_TYPE:T"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_tgr.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>353086510084435684.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>353086022864435670.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Funzione PL/SQL personalizzata',
  p_lov_return_value=>'F',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:443:&SESSION.::::P443_PK1_SOURCE_TYPE:F"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_fkt.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>353086701342435684.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>353086022864435670.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Sequenza esistente',
  p_lov_return_value=>'S',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:443:&SESSION.::::P443_PK1_SOURCE_TYPE:S"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_seq.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pk_col_source_types_form_and_rpt_pk2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 353531720082576530.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PK_COL_SOURCE_TYPES.FORM_AND_RPT.PK2',
  p_lov_query=> '.'||to_char(353531720082576530 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>353532022777576538.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>353531720082576530.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Trigger esistente',
  p_lov_return_value=>'T',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:443:&SESSION.::::P443_PK2_SOURCE_TYPE:T"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_tgr.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>353532228693576540.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>353531720082576530.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Funzione PL/SQL personalizzata',
  p_lov_return_value=>'F',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:443:&SESSION.::::P443_PK2_SOURCE_TYPE:F"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_fkt.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>353532421265576540.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>353531720082576530.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Sequenza esistente',
  p_lov_return_value=>'S',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:443:&SESSION.::::P443_PK2_SOURCE_TYPE:S"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_seq.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pk_col_source_types_form_on_table
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 352937431933900311.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PK_COL_SOURCE_TYPES.FORM_ON_TABLE',
  p_lov_query=> '.'||to_char(352937431933900311 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>352937713224900316.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>352937431933900311.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Trigger esistente',
  p_lov_return_value=>'T',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:442:&SESSION.::::P442_PK1_SOURCE_TYPE:T"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_tgr.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>352937930916900317.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>352937431933900311.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Funzione PL/SQL personalizzata',
  p_lov_return_value=>'F',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:442:&SESSION.::::P442_PK1_SOURCE_TYPE:F"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_fkt.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>352938101747900317.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>352937431933900311.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Sequenza esistente',
  p_lov_return_value=>'S',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:442:&SESSION.::::P442_PK1_SOURCE_TYPE:S"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_seq.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pk_col_source_types_form_on_table_pk2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 353234920560769172.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PK_COL_SOURCE_TYPES.FORM_ON_TABLE_PK2',
  p_lov_query=> '.'||to_char(353234920560769172 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>353235227228769175.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>353234920560769172.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Trigger esistente',
  p_lov_return_value=>'T',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:442:&SESSION.::::P442_PK2_SOURCE_TYPE:T"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_tgr.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>353235416326769176.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>353234920560769172.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Funzione PL/SQL personalizzata',
  p_lov_return_value=>'F',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:442:&SESSION.::::P442_PK2_SOURCE_TYPE:F"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_fkt.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>353235618729769176.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>353234920560769172.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Sequenza esistente',
  p_lov_return_value=>'S',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:442:&SESSION.::::P442_PK2_SOURCE_TYPE:S"><img src="#IMAGE_PREFIX#htmldb/builder/pk_frm_seq.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pk_col_source_types_master_table
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 109748910763779674.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PK_COL_SOURCE_TYPES.MASTER_TABLE',
  p_lov_query=> '.'||to_char(109748910763779674 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>109749110982779676.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>109748910763779674.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Trigger esistente',
  p_lov_return_value=>'T',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:507:&SESSION.::::P507_MASTER_PK1_SOURCE_TYPE:T"><img src="#IMAGE_PREFIX#htmldb/builder/pk_md2_tgr.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>109749305139779677.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>109748910763779674.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Funzione PL/SQL personalizzata',
  p_lov_return_value=>'F',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:507:&SESSION.::::P507_MASTER_PK1_SOURCE_TYPE:F"><img src="#IMAGE_PREFIX#htmldb/builder/pk_md2_fkt.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>109749520411779678.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>109748910763779674.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Sequenza esistente',
  p_lov_return_value=>'S',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:507:&SESSION.::::P507_MASTER_PK1_SOURCE_TYPE:S"><img src="#IMAGE_PREFIX#htmldb/builder/pk_md2_seq.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pk_col_source_types_pk2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 354777930196648711.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PK_COL_SOURCE_TYPES.PK2',
  p_lov_query=> '.'||to_char(354777930196648711 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>354778214608648715.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>354777930196648711.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Trigger esistente',
  p_lov_return_value=>'T',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:507:&SESSION.::::P507_MASTER_PK2_SOURCE_TYPE:T"><img src="#IMAGE_PREFIX#htmldb/builder/pk_md1_tgr.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>354778400953648715.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>354777930196648711.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Funzione PL/SQL personalizzata',
  p_lov_return_value=>'F',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:507:&SESSION.::::P507_MASTER_PK2_SOURCE_TYPE:F"><img src="#IMAGE_PREFIX#htmldb/builder/pk_md1_fkt.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>354778619727648715.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>354777930196648711.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Sequenza esistente',
  p_lov_return_value=>'S',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:507:&SESSION.::::P507_MASTER_PK2_SOURCE_TYPE:S"><img src="#IMAGE_PREFIX#htmldb/builder/pk_md1_seq.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pk_col_source_types_tabular_form
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 352924107252836399.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PK_COL_SOURCE_TYPES.TABULAR_FORM',
  p_lov_query=> '.'||to_char(352924107252836399 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>352924419959836410.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>352924107252836399.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Trigger esistente',
  p_lov_return_value=>'T',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:426:&SESSION.::::P426_PK1_SOURCE_TYPE:T"><img src="#IMAGE_PREFIX#htmldb/builder/pk_tabf_tgr.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>352924610617836410.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>352924107252836399.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Funzione PL/SQL personalizzata',
  p_lov_return_value=>'F',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:426:&SESSION.::::P426_PK1_SOURCE_TYPE:F"><img src="#IMAGE_PREFIX#htmldb/builder/pk_tabf_fkt.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>352924831123836410.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>352924107252836399.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Sequenza esistente',
  p_lov_return_value=>'S',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:426:&SESSION.::::P426_PK1_SOURCE_TYPE:S"><img src="#IMAGE_PREFIX#htmldb/builder/pk_tabf_seq.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pk_col_source_types_tabular_form_pk2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 354918920831899336.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PK_COL_SOURCE_TYPES.TABULAR_FORM.pk2',
  p_lov_query=> '.'||to_char(354918920831899336 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>354919209780899342.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>354918920831899336.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Trigger esistente',
  p_lov_return_value=>'T',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:426:&SESSION.::::P426_PK2_SOURCE_TYPE:T"><img src="#IMAGE_PREFIX#htmldb/builder/pk_tabf_tgr.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>354919401744899342.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>354918920831899336.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Funzione PL/SQL personalizzata',
  p_lov_return_value=>'F',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:426:&SESSION.::::P426_PK2_SOURCE_TYPE:F"><img src="#IMAGE_PREFIX#htmldb/builder/pk_tabf_fkt.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>354919621470899342.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>354918920831899336.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Sequenza esistente',
  p_lov_return_value=>'S',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:426:&SESSION.::::P426_PK2_SOURCE_TYPE:S"><img src="#IMAGE_PREFIX#htmldb/builder/pk_tabf_seq.gif" width="140" height="115" alt="#DISPLAY_VALUE#" title="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/plsql_anonymous_block
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84783318827001758.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PLSQL_ANONYMOUS_BLOCK',
  p_lov_query=> '.'||to_char(84783318827001758 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84783500539001759.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84783318827001758.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Blocco anonimo PL/SQL',
  p_lov_return_value=>'PLSQL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/plsql_validation
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 111144330433082822.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PLSQL_VALIDATION',
  p_lov_query=> '.'||to_char(111144330433082822 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>111144523380082823.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>111144330433082822.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Non convalidare codice PL/SQL (analizzare il codice PL/SQL solo in fase di esecuzione).',
  p_lov_return_value=>'NO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/plug_chart_axis
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84913307529708111.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PLUG.CHART.AXIS',
  p_lov_query=> '.'||to_char(84913307529708111 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84913517211708112.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84913307529708111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Valore medio nella serie',
  p_lov_return_value=>'AVG',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84913719258708112.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84913307529708111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Primo valore nella serie',
  p_lov_return_value=>'FIRST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84913917773708112.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84913307529708111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Ultimo valore nella serie',
  p_lov_return_value=>'LAST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84914531578708113.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84913307529708111.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Zero',
  p_lov_return_value=>'ZERO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/plug_chart_axis
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84331708594618216.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PLUG_CHART_AXIS',
  p_lov_query=> '.'||to_char(84331708594618216 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84331906767618217.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84331708594618216.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Valore medio nella serie',
  p_lov_return_value=>'AVG',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84332132650618217.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84331708594618216.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Primo valore nella serie',
  p_lov_return_value=>'FIRST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84332309505618218.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84331708594618216.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Ultimo valore nella serie',
  p_lov_return_value=>'LAST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84332528115618218.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84331708594618216.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Valore massimo nella serie',
  p_lov_return_value=>'MAX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84332710962618218.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84331708594618216.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Valore minimo nella serie',
  p_lov_return_value=>'MIN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84332909633618218.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84331708594618216.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Zero',
  p_lov_return_value=>'ZERO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/plug_chart_font_size
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84691009705624527.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PLUG_CHART_FONT_SIZE',
  p_lov_query=> '.'||to_char(84691009705624527 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84691205352624528.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84691009705624527.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'-3',
  p_lov_return_value=>'-3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84691410423624528.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84691009705624527.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'-2',
  p_lov_return_value=>'-2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84691626959624528.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84691009705624527.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'-1',
  p_lov_return_value=>'-1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84691800905624529.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84691009705624527.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'+0',
  p_lov_return_value=>'+0',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84692006310624529.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84691009705624527.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'+1',
  p_lov_return_value=>'+1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84692221772624529.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84691009705624527.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'+2',
  p_lov_return_value=>'+2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84692428366624529.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84691009705624527.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'+3',
  p_lov_return_value=>'+3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84692607861624530.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84691009705624527.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'+4',
  p_lov_return_value=>'+4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84692824991624530.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84691009705624527.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'+5',
  p_lov_return_value=>'+5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84693026747624530.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84691009705624527.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'+6',
  p_lov_return_value=>'+6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84693202667624530.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84691009705624527.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'+7',
  p_lov_return_value=>'+7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/popup_lov_template_theme_class_id
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 59418530750879398.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'POPUP LOV TEMPLATE THEME CLASS ID',
  p_lov_query=> '.'||to_char(59418530750879398 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>59418812008879404.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>59418530750879398.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Standard',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/preserve_case_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 215454417816546080.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRESERVE.CASE.Y',
  p_lov_query=> '.'||to_char(215454417816546080 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>215454707655546082.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>215454417816546080.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Conserva maiuscole/minuscole',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/prez
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84371212244732793.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PREZ',
  p_lov_query=> '.'||to_char(84371212244732793 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84371421765732793.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84371212244732793.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'George W. Bush',
  p_lov_return_value=>'gwbush.jpg',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84371617057732794.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84371212244732793.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Bill Clinton',
  p_lov_return_value=>'clinton.jpg',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84371811280732794.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84371212244732793.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'George Washington',
  p_lov_return_value=>'washington.gif',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/printer_friendly
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 148325219515185885.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRINTER_FRIENDLY)',
  p_lov_query=> '.'||to_char(148325219515185885 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>148325416715185890.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>148325219515185885.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Per la stampa',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/print_att_include_link
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 57998911830398981.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRINT_ATT_INCLUDE_LINK',
  p_lov_query=> '.'||to_char(57998911830398981 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>57999115213398981.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>57998911830398981.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Sì',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>57999327144398981.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>57998911830398981.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'No (collegamento manuale)',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/print_items
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 29642100479782966.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRINT_ITEMS',
  p_lov_query=> 'select name || '' ('' || t || '') '' d,name r from ('||chr(10)||
'select name ,  j.t t, null prompt, to_number(NULL) p'||chr(10)||
'from wwv_flow_items, (select wwv_flow_lang.system_message(''F4000.APPLICATION_ITEM'') t from dual) j'||chr(10)||
'where  flow_id = :fb_flow_id'||chr(10)||
'union all'||chr(10)||
'select name , j.t t, prompt , flow_step_id p'||chr(10)||
'from wwv_flow_step_items, (select wwv_flow_lang.system_message(''F4000.PAGE_ITEM'') t from dual) j'||chr(10)||
'where flow_id = :fb_flow_id'||chr(10)||
'order by 4 asc nulls first, 1 asc'||chr(10)||
')');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/prn_conditional_y_n
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 66513426858953865.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRN_CONDITIONAL_Y_N',
  p_lov_query=> '.'||to_char(66513426858953865 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>66513706760953868.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>66513426858953865.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Sì',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>66513908212953868.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>66513426858953865.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'No',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/prn_fonts
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 14413827328266173.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRN_FONTS',
  p_lov_query=> '.'||to_char(14413827328266173 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14414108222266173.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14413827328266173.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Helvetica',
  p_lov_return_value=>'Helvetica',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14414321991266173.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14413827328266173.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Times',
  p_lov_return_value=>'Times',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14414502041266173.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14413827328266173.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Courier',
  p_lov_return_value=>'Courier',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/prn_font_weight
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 16555331301241275.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRN_FONT_WEIGHT',
  p_lov_query=> '.'||to_char(16555331301241275 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16555620164241278.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>16555331301241275.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Normale',
  p_lov_return_value=>'normal',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16555806266241278.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>16555331301241275.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Grassetto',
  p_lov_return_value=>'bold',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/prn_format
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 16950902829395371.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRN_FORMAT',
  p_lov_query=> '.'||to_char(16950902829395371 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16951202412395371.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>16950902829395371.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'PDF',
  p_lov_return_value=>'PDF',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16951406045395371.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>16950902829395371.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Word',
  p_lov_return_value=>'RTF',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16951613265395371.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>16950902829395371.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Excel',
  p_lov_return_value=>'XLS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16951828641395371.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>16950902829395371.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'HTML',
  p_lov_return_value=>'HTM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131706624505895733.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>16950902829395371.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'XML',
  p_lov_return_value=>'XML',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/prn_page_orientation
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 14317429014888204.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRN_PAGE_ORIENTATION',
  p_lov_query=> '.'||to_char(14317429014888204 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14317704218888204.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14317429014888204.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Verticale',
  p_lov_return_value=>'VERTICAL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14317927446888204.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14317429014888204.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Orizzontale',
  p_lov_return_value=>'HORIZONTAL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/prn_page_units
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 14280128827774584.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRN_PAGE_UNITS',
  p_lov_query=> '.'||to_char(14280128827774584 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14280419832774585.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14280128827774584.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Punti',
  p_lov_return_value=>'POINTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14280620486774585.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14280128827774584.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Pollici',
  p_lov_return_value=>'INCHES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14280802207774585.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14280128827774584.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Millimetri',
  p_lov_return_value=>'MILLIMETERS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14281015797774585.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14280128827774584.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Centimetri',
  p_lov_return_value=>'CENTIMETERS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/prn_paper_size
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 14283929435793739.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRN_PAPER_SIZE',
  p_lov_query=> '.'||to_char(14283929435793739 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14284211408793739.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14283929435793739.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Personalizzato',
  p_lov_return_value=>'CUSTOM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14284428810793739.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14283929435793739.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Lettera',
  p_lov_return_value=>'LETTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14284613426793739.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14283929435793739.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Legale',
  p_lov_return_value=>'LEGAL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14284802250793739.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14283929435793739.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Tabloid',
  p_lov_return_value=>'TABLOID',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14285022720793739.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14283929435793739.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'A4',
  p_lov_return_value=>'A4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14285218818793739.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>14283929435793739.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'A3',
  p_lov_return_value=>'A3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/public_personal
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84916217834730025.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PUBLIC.PERSONAL',
  p_lov_query=> '.'||to_char(84916217834730025 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84916402749730026.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84916217834730025.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personale',
  p_lov_return_value=>'PERSONAL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84916603755730026.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84916217834730025.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Pubblico',
  p_lov_return_value=>'PUBLIC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/query_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84937920230853735.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'QUERY.OPTIONS',
  p_lov_query=> '.'||to_char(84937920230853735 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84938130889853736.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84937920230853735.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Utilizza nomi di colonne specifiche e convalida query',
  p_lov_return_value=>'DERIVED_REPORT_COLUMNS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84938325410853736.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84937920230853735.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Utilizza nomi di colonne generiche (analizza query solo in fase di esecuzione)',
  p_lov_return_value=>'GENERIC_REPORT_COLUMNS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/query_headings_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84301323392565701.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'QUERY_HEADINGS_TYPE',
  p_lov_query=> '.'||to_char(84301323392565701 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84301521685565702.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84301323392565701.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>''||chr(10)||
'Nomi colonna',
  p_lov_return_value=>'QUERY_COLUMNS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84301704281565702.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84301323392565701.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>''||chr(10)||
'Nomi colonna (InitCap)',
  p_lov_return_value=>'QUERY_COLUMNS_INITCAP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84301925334565702.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84301323392565701.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>''||chr(10)||
'Personalizzato',
  p_lov_return_value=>'COLON_DELMITED_LIST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84302118859565703.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84301323392565701.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>''||chr(10)||
'PL/SQL',
  p_lov_return_value=>'FUNCTION_BODY_RETURNING_COLON_DELIMITED_LIST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84302301898565703.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84301323392565701.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>''||chr(10)||
'Nessuno',
  p_lov_return_value=>'NO_HEADINGS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/recent_time_static
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'RECENT TIME STATIC',
  p_lov_query=> '.'||to_char(94747000503182513 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94747313637182517.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'10 secondi',
  p_lov_return_value=>'.000115740740740740740740740740740740741',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94747518394182517.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'1 minuto',
  p_lov_return_value=>'.000694444444444444444444444444444444444',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94747729794182517.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'5 minuti',
  p_lov_return_value=>'.003472222222222222222222222222222222222',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94747926598182517.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'10 minuti',
  p_lov_return_value=>'.0069444444444444444444444444',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94748115620182518.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'15 minuti',
  p_lov_return_value=>'.010416666666666666666666666666666666667',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94748310633182518.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'30 minuti',
  p_lov_return_value=>'.020833333333333333333333333333333333333',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94748508572182518.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'1 ora',
  p_lov_return_value=>'.041666666666666666666666666666666666667',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94748724431182518.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'2 ore',
  p_lov_return_value=>'.083333333333333333333333333333333333333',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94748910187182518.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'3 ore',
  p_lov_return_value=>'.125',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94749125599182518.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'4 ore',
  p_lov_return_value=>'.166666666666666666666666666666666666667',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94749323491182518.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'5 ore',
  p_lov_return_value=>'.208333333333333333333333333333333333333',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94749508725182518.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>12,
  p_lov_disp_value=>'6 ore',
  p_lov_return_value=>'.25',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94749718151182518.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>13,
  p_lov_disp_value=>'8 ore',
  p_lov_return_value=>'.333333333333333333333333333333333333333',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94749910023182518.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>14,
  p_lov_disp_value=>'10 ore',
  p_lov_return_value=>'.416666666666666666666666666666666666667',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94750119132182518.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>15,
  p_lov_disp_value=>'12 ore',
  p_lov_return_value=>'.5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>104466705973961841.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>15.5,
  p_lov_disp_value=>'1 giorno',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94750607429184466.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>16,
  p_lov_disp_value=>'2 giorni',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94750911239185592.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>17,
  p_lov_disp_value=>'3 giorni',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94751214355186496.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>18,
  p_lov_disp_value=>'4 giorni',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94751517818187469.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>19,
  p_lov_disp_value=>'5 giorni',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94751822667188850.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'6 giorni',
  p_lov_return_value=>'6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94752125783189729.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>21,
  p_lov_disp_value=>'1 settimana',
  p_lov_return_value=>'7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94752428900190721.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>22,
  p_lov_disp_value=>'2 settimane',
  p_lov_return_value=>'14',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94752702366192454.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>23,
  p_lov_disp_value=>'4 settimane',
  p_lov_return_value=>'28',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>94753006521193682.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>94747000503182513.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>26,
  p_lov_disp_value=>'1 anno',
  p_lov_return_value=>'365',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/redirect_branch
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84944714521889885.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'REDIRECT.BRANCH',
  p_lov_query=> '.'||to_char(84944714521889885 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>84944918356889886.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84944714521889885.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'dirama a pagina mediante reindirizzamento )',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/refresh_label_template
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 84317322746593889.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'REFRESH_LABEL_TEMPLATE',
  p_lov_query=> '.'||to_char(84317322746593889 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88305802126823296.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>84317322746593889.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Aggiorna',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/refresh_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86078519684815185.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'REFRESH_Y',
  p_lov_query=> '.'||to_char(86078519684815185 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88306405589824278.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86078519684815185.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Aggiorna',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/region_caching_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 22602312173782467.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'REGION CACHING OPTIONS',
  p_lov_query=> '.'||to_char(22602312173782467 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22602526326782467.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>22602312173782467.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Non inserito nella cache',
  p_lov_return_value=>'NOT_CACHED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22602720414782468.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>22602312173782467.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Inserita nella cache',
  p_lov_return_value=>'CACHED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22602908361782468.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>22602312173782467.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Inserito nella cache dall''utente',
  p_lov_return_value=>'CACHED_BY_USER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/region_theme_class_id
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'REGION THEME CLASS ID',
  p_lov_query=> '.'||to_char(42003622222572861 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42003905055572869.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Nascondi e mostra area',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42004121899572869.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area barra laterale',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42004332039572870.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area barra laterale, alternativa 1',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42004527982572870.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area pulsante con titolo',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42004707368572870.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area di navigazione',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42004922993572870.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area con indicatori di percorso',
  p_lov_return_value=>'6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42005318792572871.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area di form',
  p_lov_return_value=>'8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42005510332572871.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area di report',
  p_lov_return_value=>'9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42005908156572871.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area senza titolo',
  p_lov_return_value=>'11',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42006130670572872.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Creazione guidata area',
  p_lov_return_value=>'12',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42006320789572872.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Larghezza 100% area di report',
  p_lov_return_value=>'13',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42009203091586314.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area di navigazione, alternativa 1',
  p_lov_return_value=>'16',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42011722484591850.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area pulsante senza titolo',
  p_lov_return_value=>'17',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42016007687644405.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area in parentesi',
  p_lov_return_value=>'18',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>42017128465650351.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area senza pulsanti e titolo',
  p_lov_return_value=>'19',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>44193631287041740.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Creazione guidata area con icona',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>52367908380077344.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area senza bordo',
  p_lov_return_value=>'7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>52369713490097781.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area di report, alternativa 1',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>75207904105349056.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area di lista con icona',
  p_lov_return_value=>'29',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>76147331941126624.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Filtro report - Riga singola',
  p_lov_return_value=>'31',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>76177513165215809.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Filtro report - Più righe',
  p_lov_return_value=>'32',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>225619930801333589.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Area di grafico',
  p_lov_return_value=>'30',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>44237530397202360.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 1',
  p_lov_return_value=>'21',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>44237832475202975.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 2',
  p_lov_return_value=>'22',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>44238101439203525.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 3',
  p_lov_return_value=>'23',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>44238403516204084.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 4',
  p_lov_return_value=>'24',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>44238705594204669.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 5',
  p_lov_return_value=>'25',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>44239007326205203.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 6',
  p_lov_return_value=>'26',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>44239309404205768.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 7',
  p_lov_return_value=>'27',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>44239611135206317.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>42003622222572861.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Personalizzato 8',
  p_lov_return_value=>'28',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/region_title_translation
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 17378610268487082.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'REGION TITLE TRANSLATION',
  p_lov_query=> '.'||to_char(17378610268487082 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>17378825153487082.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>17378610268487082.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'escludi titolo dalla traduzione',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/region_templates
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 663424044.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'REGION.TEMPLATES',
  p_lov_query=> 'select wwv_flow_lang.system_message(''NO_TEMPLATE'') d, 0 r from dual union all'||chr(10)||
'select t.d, t.r from ('||chr(10)||
'select htf.escape_sc(page_plug_template_name) d, id r'||chr(10)||
'from   wwv_flow_page_plug_templates'||chr(10)||
'where  flow_id = :FB_FLOW_ID and'||chr(10)||
'       (:fb_theme_id is null or theme_id = :fb_theme_id)'||chr(10)||
'order  by upper(page_plug_template_name) ) t');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/region_comment
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 86070721237777807.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'REGION_COMMENT',
  p_lov_query=> '.'||to_char(86070721237777807 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88309409052825302.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>86070721237777807.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Torna alla pagina',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/region_display_point
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 131723061838.4004 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'REGION_DISPLAY_POINT',
  p_lov_query=> '.'||to_char(131723061838 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131724061840.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131723061838.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Dopo l''intestazione',
  p_lov_return_value=>'AFTER_HEADER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131725061840.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131723061838.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Corpo modello di pagina (1. elementi sotto il contenuto di area)',
  p_lov_return_value=>'BEFORE_BOX_BODY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131726061840.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131723061838.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Corpo modello di pagina (2. elementi sotto il contenuto di area)',
  p_lov_return_value=>'BEFORE_SHOW_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131727061840.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131723061838.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Corpo modello di pagina (3. elementi sopra il contenuto di area)',
  p_lov_return_value=>'AFTER_SHOW_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131728061841.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131723061838.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Prima del piè di pagina',
  p_lov_return_value=>'BEFORE_FOOTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131729061841.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131723061838.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Posizione 1 area del modello di pagina',
  p_lov_return_value=>'REGION_POSITION_01',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from wwv_flow_templates'||chr(10)||
' where id = (select nvl(step_template,default_page_template) template_id'||chr(10)||
'                   from wwv_flow_steps s,wwv_flows f'||chr(10)||
'                  where s.flow_id = :FB_FLOW_ID '||chr(10)||
'                    and s.id = :FB_FLOW_PAGE_ID '||chr(10)||
'                    and s.flow_id = f.id'||chr(10)||
'                    and rownum = 1)'||chr(10)||
'   and (dbms_lob.instr(header_template,''#REGION_POSITION_01#'') > 0'||chr(10)||
'        or'||chr(10)||
'        dbms_lob.instr(box,''#REGION_POSITION_01#'') > 0'||chr(10)||
'        or'||chr(10)||
'        dbms_lob.instr(footer_template,''#REGION_POSITION_01#'') > 0)',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>133442865269.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131723061838.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Posizione 2 area del modello di pagina',
  p_lov_return_value=>'REGION_POSITION_02',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from wwv_flow_templates'||chr(10)||
' where id = (select nvl(step_template,default_page_template) template_id'||chr(10)||
'                   from wwv_flow_steps s,wwv_flows f'||chr(10)||
'                  where s.flow_id = :FB_FLOW_ID '||chr(10)||
'                    and s.id = :FB_FLOW_PAGE_ID '||chr(10)||
'                    and s.flow_id = f.id'||chr(10)||
'                    and rownum = 1)'||chr(10)||
'   and (dbms_lob.instr(header_template,''#REGION_POSITION_02#'') > 0'||chr(10)||
'        or'||chr(10)||
'        dbms_lob.instr(box,''#REGION_POSITION_02#'') > 0'||chr(10)||
'        or'||chr(10)||
'        dbms_lob.instr(footer_template,''#REGION_POSITION_02#'') > 0)',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>133443866653.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131723061838.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Posizione 3 area del modello di pagina',
  p_lov_return_value=>'REGION_POSITION_03',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from wwv_flow_templates'||chr(10)||
' where id = (select nvl(step_template,default_page_template) template_id'||chr(10)||
'                   from wwv_flow_steps s,wwv_flows f'||chr(10)||
'                  where s.flow_id = :FB_FLOW_ID '||chr(10)||
'                    and s.id = :FB_FLOW_PAGE_ID '||chr(10)||
'                    and s.flow_id = f.id'||chr(10)||
'                    and rownum = 1)'||chr(10)||
'   and (dbms_lob.instr(header_template,''#REGION_POSITION_03#'') > 0'||chr(10)||
'        or'||chr(10)||
'        dbms_lob.instr(box,''#REGION_POSITION_03#'') > 0'||chr(10)||
'        or'||chr(10)||
'        dbms_lob.instr(footer_template,''#REGION_POSITION_03#'') > 0)',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>133444870206.4004 + wwv_flow_api.g_id_offset,
  p_lov_id=>131723061838.4004 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Posizione 4 area del modello di pagina',
  p_lov_return_value=>'REGION_POSITION_04',
  p_lov_disp_cond_type=>'EXISTS',
  p_lov_disp_cond=> 'select 1'||chr(10)||
'  from wwv_flow_templates'||chr(10)||
' where id = (select nvl(step_template,default_page_template) template_id'||chr(10)||
'                   from wwv_flow_steps s,wwv_flows f'||chr(10)||
'                  where s.flow_id = :FB_FLOW_ID '||chr(10)||
'                    and s.id = :FB_FLOW_PAGE_ID '||chr(10)||
'                    and s.flow_id = f.id'||chr(10)||
'                    and rownum = 1)'||chr(10)||
'   and (dbms_lob.instr(header_template,''#REGION_POSITION_04#'') > 0'||chr(10)||
'        or'||chr(10)||
'        dbms_lob.instr(box,''#REGION_POSITION_04#'') > 0'||chr(10)||
'        or'||chr(10)||
'        dbms_lob.instr(footer_template,''#REGION_POSITION_04#'') > 0)',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_ap