' Copyright (c) 2003, 2004, Oracle.  All rights reserved.
'
' NAME
'    nmeo.vbs - Collect WMI information on WinNT/Win2K/XP
'
' DESCRIPTION
'    Collects various WMI values for nmeo.exe that are typically
'    unavailable in either the Windows registry or in a C API.
'
' MODIFIED     (MM/DD/YY)
'    mgoodric   10/06/04 - Add finding serial number using VBScript
'    mgoodric   08/14/04 - Add finding model and vendor using VBScript
'
Option Explicit
On Error Resume Next
' Variables
Dim intCount, objItem, strArg
' Constants
Dim HEADER, PAD, KB, MB, GB
Set PAD = "                                                   "
Set KB = 1024
Set MB = (KB * KB)
Set GB = (MB * KB)

' Functions
Function alignLeft (strValue, intCols)
    If Len(strValue) < intCols Then
        strValue = Left(strValue & PAD, intCols)
    End If
    alignLeft = strValue
End Function

Function alignRight (strValue, intCols)
    If Len(strValue) < cols Then
        strValue = Right(PAD & strValue, intCols)
    End If
    alignRight = strValue
End Function

Function inUnits (strValue, intDivisor, strUnits)
    If IsNumeric(strValue) And strValue > 0 Then
        inUnits = Round(strValue / intDivisor, 2) & strUnits
    Else
        inUnits = ""
    End If
End Function

Function quote (strValue)
    If VarType(strValue) = vbString Then
        quote = """" & strValue & """"
    Else
        quote = strValue
    End If
End Function

Function nonNull (strValue)
    If IsNull(strValue) Then
        nonNull = "n/a"
    Else
        nonNull = strValue
    End If
End Function

Function displayComputerSystemProduct (objItem)
On Error Resume Next
    displayComputerSystemProduct = vbCrlf _
                & "Caption: " & objItem.Caption & vbCrLf _
                & "IdentifyingNumber: " & objItem.IdentifyingNumber & vbCrlf _
                & "Name: " & objItem.Name & vbCrLf _
                & "SKUNumber: " & objItem.SKUNumber & vbCrlf _
                & "UUID: " & objItem.UUID & vbCrLf _
                & "Vendor: " & objItem.Vendor & vbCrlf _
                & "Version: " & objItem.Version
End Function

Function displayProcessor (objItem)
On Error Resume Next
    displayProcessor = vbCrlf _
                & "Caption: " & objItem.Caption & vbCrlf _
                & "Architecture: " & objItem.Architecture & vbCrLf _
                & "ExtClock: " & objItem.ExtClock & vbCrLf _
                & "Family: " & objItem.Family & vbCrLf _
                & "L2CacheSize: " & objItem.L2CacheSize & vbCrLf _
                & "Manufacturer: " & objItem.Manufacturer & vbCrLf _
                & "Name: " & objItem.Name & vbCrLf _
                & "ProcessorId: " & objItem.ProcessorId & vbCrLf _
                & "ProcessorType: " & objItem.ProcessorType & vbCrLf _
                & "Revision: " & objItem.Revision & vbCrLf _
                & "Version: " & objItem.Version
End Function

Function displayBIOS (objItem)
On Error Resume Next
    displayBIOS = vbCrlf _
                & "Caption: " & objItem.Caption & vbCrLf _
                & "IdentificationCode: " & objItem.IdentificationCode & vbCrLf _
                & "Manufacturer: " & objItem.Manufacturer & vbCrLf _
                & "SerialNumber: " & objItem.SerialNumber & vbCrLf _
                & "SMBIOSBIOSVersion: " & objItem.SMBIOSBIOSVersion & vbCrLf _
                & "Version: " & objItem.Version
End Function

Function displaySystemEnclosure (objItem)
On Error Resume Next
    displaySystemEnclosure = vbCrlf _
                & "Caption: " & objItem.Caption & vbCrLf _
                & "Manufacturer: " & objItem.Manufacturer & vbCrLf _
                & "Model: " & objItem.Model & vbCrLf _
                & "PartNumber: " & objItem.PartNumber & vbCrlf _
                & "SerialNumber: " & objItem.SerialNumber & vbCrlf _
                & "Tag: " & objItem.Tag & vbCrlf _
                & "Version: " & objItem.Version
End Function

' Main Loop
strArg = UCase(WScript.Arguments.UnNamed.Item(0))

If strArg = "ALL" Or strArg = "HARDWARE" Then
    intCount = 0
    HEADER = "class Win32_ComputerSystemProduct : CIM_Product"
    For Each objItem in GetObject("winmgmts:").InstancesOf("Win32_ComputerSystemProduct")
        intCount = intCount + 1
        If intCount = 1 Then
            WScript.Echo vbCrLf & HEADER
        End If
        WScript.Echo displayComputerSystemProduct(objItem)
    Next
    intCount = 0
    HEADER = "class Win32_Processor : CIM_Processor"
    For Each objItem in GetObject("winmgmts:").InstancesOf("Win32_Processor")
        intCount = intCount + 1
        If intCount = 1 Then
            WScript.Echo vbCrLf & HEADER
        End If
        WScript.Echo displayProcessor(objItem)
    Next
    intCount = 0
    HEADER = "class Win32_BIOS : CIM_BIOSElement"
    For Each objItem in GetObject("winmgmts:").InstancesOf("Win32_BIOS")
        intCount = intCount + 1
        If intCount = 1 Then
            WScript.Echo vbCrLf & HEADER
        End If
        WScript.Echo displayBIOS(objItem)
    Next
    intCount = 0
    HEADER = "class Win32_SystemEnclosure : CIM_Chassis"
    For Each objItem in GetObject("winmgmts:").InstancesOf("Win32_SystemEnclosure")
        intCount = intCount + 1
        If intCount = 1 Then
            WScript.Echo vbCrLf & HEADER
        End If
        WScript.Echo displaySystemEnclosure(objItem)
    Next
End If

' Done
If Err <> 0 Then
    Set lasterr = CreateObject("WbemScripting.SWbemLastError")
    Wscript.Echo lasterr.Operation
End If
