set define off
set verify off
set serveroutput on size 1000000
set feedback off
begin wwv_flow.g_import_in_progress := true; end; 
/
 
 
--application/set_environment
prompt  APPLICATION 4419 - APEX  - System Messages
--
-- Application Export:
--   Application:     4419
--   Name:            APEX  - System Messages
--   Date and Time:   08:05 Tuesday May 19, 2009
--   Exported By:     
--   Flashback:       0
--   Export Type:     Application Export
--   Version: 3.2.1.00.08
 
-- Import:
--   Using application builder
--   or
--   Using SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
 
-- Application Statistics:
--   Pages:                 1
--     Items:               0
--     Computations:        0
--     Validations:         0
--     Processes:           0
--     Regions:             1
--     Buttons:             0
--   Shared Components
--     Breadcrumbs:         0
--        Entries           0
--     Items:               0
--     Computations:        0
--     Processes:           0
--     Parent Tabs:         0
--     Tab Sets:            0
--        Tabs:             0
--     NavBars:             0
--     Lists:               0
--     Shortcuts:           0
--     Themes:              0
--     Templates:
--        Page:             9
--        List:            14
--        Report:           7
--        Label:            5
--        Region:          21
--     Messages:        3,702
--     Build Options:       0
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>10);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en-us'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2009.01.12');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := 4419;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(4419);
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(4419);
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => 4419,
  p_display_id=> 4419,
  p_owner => 'APEX_030200',
  p_name  => 'APEX  - System Messages',
  p_alias => 'A198392118100443080',
  p_page_view_logging => 'YES',
  p_default_page_template=> 91626406749381989.4419 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=> 91626529080381989.4419 + wwv_flow_api.g_id_offset,
  p_default_region_template=> 91632832228382001.4419 + wwv_flow_api.g_id_offset,
  p_error_template    => 91626406749381989.4419 + wwv_flow_api.g_id_offset,
  p_charset           => 'utf-8',
  p_checksum_salt_last_reset => '20090519073429',
  p_max_session_length_sec=> 28800,
  p_home_link         => 'f?p=4411:1:&SESSION.',
  p_flow_language     => 'ko',
  p_flow_language_derived_from=> 'BROWSER',
  p_flow_image_prefix => '/i/',
  p_documentation_banner=> '',
  p_authentication    => 'CUSTOM2',
  p_login_url         => '',
  p_logout_url        => '',
  p_application_tab_set=> 1,
  p_public_url_prefix => '',
  p_public_user       => 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server      => '',
  p_cust_authentication_process=> '.'||to_char(91645213681389498 + wwv_flow_api.g_id_offset)||'.',
  p_cust_authentication_page=> '',
  p_custom_auth_login_url=> '',
  p_flow_version      => '&PRODUCT_NAME. 3.2.1.00.08',
  p_flow_status       => 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'This application is currently unavailable.',
  p_build_status      => 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'Y',
  p_vpd               => '',
  p_rejoin_existing_sessions   => 'N',
  p_theme_id => 1,
  p_default_label_template => 91641225667382016.4419 + wwv_flow_api.g_id_offset,
  p_default_report_template => 91638400927382012.4419 + wwv_flow_api.g_id_offset,
  p_default_list_template => 91636711305382010.4419 + wwv_flow_api.g_id_offset,
  p_default_menu_template => 91641814330382017.4419 + wwv_flow_api.g_id_offset,
  p_default_button_template => 91626823864381990.4419 + wwv_flow_api.g_id_offset,
  p_default_chart_template => 91631622717381999.4419 + wwv_flow_api.g_id_offset,
  p_default_form_template => 91630725782381998.4419 + wwv_flow_api.g_id_offset,
  p_default_wizard_template => 91632204784382001.4419 + wwv_flow_api.g_id_offset,
  p_default_tabform_template => 91632832228382001.4419 + wwv_flow_api.g_id_offset,
  p_default_reportr_template   =>91632832228382001.4419 + wwv_flow_api.g_id_offset,
  p_default_menur_template => 91633105066382001.4419 + wwv_flow_api.g_id_offset,
  p_default_listr_template => 91627727983381992.4419 + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss=> '20090518142155',
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
null;
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
null;
 
end;
/

prompt  ...application processes
--
prompt  ...application items
--
prompt  ...application level computations
--
 
begin
 
null;
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Shared Lists of values
--
prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

 
--application/pages/page_1.441
prompt  ...PAGE 1.4419: 메시지
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 1.4419,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '메시지',
  p_step_title=> '메시지',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 91626406749381989.4419+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409163631',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<h1>APEX Development</h1>'||chr(10)||
'<p>'||chr(10)||
'이 애플리케이션은 APEX 시스템 메시지를 관리하는 데 사용됩니다. 공유 구성 요소를 누른 다음 메시지를 누르십시오.'||chr(10)||
'</p>';

wwv_flow_api.create_page_plug (
  p_id=> 91624704892377483.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4419,
  p_plug_name=> 'System Messages',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 1.4419
--
 
begin
 
null;
end;
null;
 
end;
/

prompt  ...lists
--
--application/shared_components/navigation/breadcrumbs
prompt  ...breadcrumbs
--
prompt  ...page templates for application: 4419
--
--application/shared_components/user_interface/templates/page/login_ko
prompt  ......Page template 91625820476381987.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><br /></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO#</td>'||chr(10)||
'    <td align="right" valign="top"><br /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle"><br /></td>'||chr(10)||
' ';

c3:=c3||'   <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table class="t1PageBody" cellpadding="0" cellspacing="0" border="0" summary="" width="100%" height="70%">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1PageCenter" valign="top"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">';

c3:=c3||'#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_03##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##REGION_POSITION_07##REGION_POSITION_08#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 91625820476381987.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Login.ko',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0"',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_translate_this_template => 'N',
  p_template_comment => '18');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/no_tabs_ko
prompt  ......Page template 91625930032381988.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src=';

c3:=c3||'"#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle"><br />#REGION_POSITION_01#</td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table class="t1PageBody" cellpadding="0" cellspacing="0" border="0" summary="" width="100%" height="70%">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1PageCenter" valign="top"><table summary="" cellpadd';

c3:=c3||'ing="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 91625930032381988.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'No Tabs.ko',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1Notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/two_level_tabs_ko
prompt  ......Page template 91626019499381988.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#PARENT_TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td align="right" class="t1topbarLeft"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left2.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="top"><table border="0" cellpadding="0" cellspacing="0" su';

c3:=c3||'mmary=""><tr><td height="20">#TAB_CELLS#</td></tr><tr><td height="20">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign';

c3:=c3||'="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626019499381988.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Two Level Tabs.ko',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<span class="t1ChildTab">[&nbsp;#TAB_LABEL#&nbsp;]</span>#TAB_INLINE_EDIT#',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<a href="#TAB_LINK#" class="t1ChildTab">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/two_level_tabs_with_side_bar_ko
prompt  ......Page template 91626101050381989.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#PARENT_TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/';

c3:=c3||'top_barleft2_1.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20">#TAB_CELLS#</td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td v';

c3:=c3||'align="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REGION_POSITION_02#</td>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1Pag';

c3:=c3||'eBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626101050381989.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Two Level Tabs with Side Bar.ko',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<span class="t1ChildTab">[&nbsp;#TAB_LABEL#&nbsp;]</span>#TAB_INLINE_EDIT#',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<a href="#TAB_LINK#" class="t1ChildTab">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/one_level_tabs_with_side_bar_ko
prompt  ......Page template 91626232237381989.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/t';

c3:=c3||'heme_1/top_barleft2_1.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20"><br /></td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table';

c3:=c3||'></td>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REGION_POSITION_02#</td>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="t';

c3:=c3||'op" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626232237381989.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'One Level Tabs with Side Bar.ko',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>'||chr(10)||
'',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>'||chr(10)||
'',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t2notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 16,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/no_tabs_with_side_bar_ko
prompt  ......Page template 91626321000381989.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_1.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||chr(10)||
'    <td class';

c3:=c3||'="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20"><br /></td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REG';

c3:=c3||'ION_POSITION_02#</td>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03';

c3:=c3||'#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626321000381989.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'No Tabs with Side Bar.ko',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/one_level_tabs_ko
prompt  ......Page template 91626406749381989.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50';

c3:=c3||'%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'<tr>'||chr(10)||
'<td><br /></td>'||chr(10)||
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody">';

c3:=c3||'<div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626406749381989.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'One Level Tabs.ko',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>'||chr(10)||
''||chr(10)||
'',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>'||chr(10)||
'',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_template_comment => '12');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/printer_friendly_ko
prompt  ......Page template 91626529080381989.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'#FORM_CLOSE#</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top">'||chr(10)||
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>'||chr(10)||
'#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626529080381989.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Printer Friendly.ko',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '',
  p_navigation_bar=> '',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_template_comment => '3');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/popup_ko
prompt  ......Page template 91626623032381989.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'#FORM_CLOSE#</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top"><div class="t1messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_01##REGION_POSITION_02##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##REGION_POSITION_07##REGION_POSITION_08#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626623032381989.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Popup.ko',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

prompt  ...button templates
--
--application/shared_components/user_interface/templates/button/button
prompt  ......Button Template 91626823864381990.4419
declare
  t varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
t:=t||'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>'||chr(10)||
'<td class="t1C"><a href="#LINK#">#LABEL#</a></td>'||chr(10)||
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>'||chr(10)||
'</tr';

t:=t||'>'||chr(10)||
'</table>';

wwv_flow_api.create_button_templates (
  p_id=>91626823864381990.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_template=>t,
  p_template_name=> 'Button',
  p_translate_this_template => 'N',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_template_comment       => '');
end;
/
---------------------------------------
prompt  ...region templates
--
--application/shared_components/user_interface/templates/region/report_list
prompt  ......region template 91627404948381991.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ListRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" ><tr>'||chr(10)||
'<td valign="top"><img src="#';

t:=t||'IMAGE_PREFIX#themes/theme_1/report.gif" alt=""/></td>'||chr(10)||
'<td>#BODY#</td></tr></table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91627404948381991.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Report List',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 29,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91627404948381991.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/chart_list
prompt  ......region template 91627727983381992.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ListRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" ><tr><td valign="top"><img src="#I';

t:=t||'MAGE_PREFIX#themes/theme_1/chart.gif" alt=""/></td>'||chr(10)||
'<td>#BODY#</td></tr></table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91627727983381992.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Chart List',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 29,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91627727983381992.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/region_without_title
prompt  ......region template 91628005149381992.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1RegionwithoutTitle" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628005149381992.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Region without Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 11,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628005149381992.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/hide_and_show_region
prompt  ......region template 91628313436381993.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1HideandShowRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#<a style="margin-left:5px;" href="javascript:hideShow(''region#REGION_SEQUENCE_ID#'',''shIMG#REGION_SEQUENCE_ID#'',''#IMAGE_PREFIX#themes/theme_1/rollup_plus_dgray.gif'',''#IMAG';

t:=t||'E_PREFIX#themes/theme_1/rollup_minus_dgray.gif'');" class="t1HideandShowRegionLink"><img src="#IMAGE_PREFIX#themes/theme_1/rollup_plus_dgray.gif" '||chr(10)||
'  id="shIMG#REGION_SEQUENCE_ID#" alt="" /></a></td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body"><div class="t1Hide" id="region#REGION_SEQU';

t:=t||'ENCE_ID#">#BODY#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628313436381993.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Hide and Show Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Gray Head, white body');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628313436381993.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/button_region_without_title
prompt  ......region template 91628622914381993.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ButtonRegionwithoutTitle" id="#REGION_ID#">'||chr(10)||
'<tr><td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /></td></tr>'||chr(10)||
'</table>'||chr(10)||
'#BODY#';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628622914381993.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Button Region without Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628622914381993.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/region_without_buttons_and_titles
prompt  ......region template 91628912641381993.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table summary="" cellpadding="0" cellspacing="0" border="0" class="t1RegionwithoutButtonsandTitles" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
''||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628912641381993.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Region without Buttons and Titles',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 19,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628912641381993.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region_alternative_1
prompt  ......region template 91629226514381996.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegionAlternative1" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91629226514381996.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region, Alternative 1',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 10,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91629226514381996.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/borderless_region
prompt  ......region template 91629526498381997.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1BorderlessRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##COPY##CREATE##CREATE2##EXPAND##HELP#</td>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91629526498381997.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Borderless Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Use this region template when you want to contain content without a border.'||chr(10)||
''||chr(10)||
'TITLE=YES'||chr(10)||
'BUTTONS=YES'||chr(10)||
'100% WIDTH=NO');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91629526498381997.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/button_region_with_title
prompt  ......region template 91629802954381997.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ButtonRegionwithTitle" id="#REGION_ID#">'||chr(10)||
'<tr><td class="t1RegionHeader">#TITLE#</td></tr>'||chr(10)||
'<tr><td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##COPY##EXPAND##HELP#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /';

t:=t||'></td></tr>'||chr(10)||
'</table>#BODY#'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91629802954381997.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Button Region with Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91629802954381997.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/sidebar_region_alternative_1
prompt  ......region template 91630115446381997.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="t1SidebarRegionAlternative1" summary="" id="#REGION_ID#" align="right">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/left_curve.gif" width="10" height="20" alt="" /></td>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/right_curve.gif" width="';

t:=t||'10" height="20" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="3" class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table><br />';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91630115446381997.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Sidebar Region, Alternative 1',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91630115446381997.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/sidebar_region
prompt  ......region template 91630411450381997.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="t1SidebarRegion" summary="" id="#REGION_ID#" align="right">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/left_curve.gif" width="10" height="20" alt="" /></td>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/right_curve.gif" width="10" height="';

t:=t||'20" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="3" class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table><br />';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91630411450381997.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Sidebar Region',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '<table border="0" cellpadding="0" cellspacing="0">'||chr(10)||
'        <tr>'||chr(10)||
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tl_img.gif" border="0" width="4" height="18" alt="" /></td>'||chr(10)||
'          <td bgcolor="#000000" height="1"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tr_img.gif" border="0" width="4" height="18" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#FF0000" height="16">'||chr(10)||
'            <table border="0" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'              <tr>'||chr(10)||
'                <td align=middle valign="top">'||chr(10)||
'                  <div align="center">'||chr(10)||
'                     <font color="#ffffff" face="Arial, Helvetica, sans-serif" size="1">'||chr(10)||
'                      <b>#TITLE# </b></font></div>'||chr(10)||
'                </td>'||chr(10)||
'              </tr>'||chr(10)||
'            </table>'||chr(10)||
'          </td>'||chr(10)||
'        </tr>'||chr(10)||
'</table>'||chr(10)||
'<table border="0" cellpadding="0" cellspacing="0">'||chr(10)||
'   <tr>'||chr(10)||
'   <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'   <td valign="top" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="146" height="1" border="0" alt="" /><br />'||chr(10)||
'            <table border="0" cellpadding="1" cellspacing="0" width="146" summary="">'||chr(10)||
'              <tr>'||chr(10)||
'                <td colspan="2">'||chr(10)||
'                  <table border="0" cellpadding="2" cellspacing="0" width="124" summary="">'||chr(10)||
'                    <tr>'||chr(10)||
'                      <td>&nbsp;</td>'||chr(10)||
'                      <td valign="top" width="106">'||chr(10)||
'                        <P><FONT face="arial, helvetica" size="1">'||chr(10)||
'                            #BODY#'||chr(10)||
'                           </font>'||chr(10)||
'                        </P>'||chr(10)||
'                      </td>'||chr(10)||
'                    </tr>'||chr(10)||
'                  </table>'||chr(10)||
'            </table>'||chr(10)||
'          </td>'||chr(10)||
'          <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td bgcolor="#9a9c9a" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td bgcolor="#b3b4b3" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'      </table>'||chr(10)||
'      <table border="0" cellpadding="0" cellspacing="0">'||chr(10)||
'        <tr>'||chr(10)||
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#bl_img.gif" border="0" width="4" height="6" alt="" /></td>'||chr(10)||
'          <td bgcolor="#ffffff" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#br_img.gif" border="0" width="4" height="6" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#000000" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#9a9c9a" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#b3b4b3" width="1" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'</table>'||chr(10)||
'');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91630411450381997.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/form_region
prompt  ......region template 91630725782381998.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1FormRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" height="1" width="400" alt="" /><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CH';

t:=t||'ANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91630725782381998.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Form Region',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 1,
  p_theme_class_id => 8,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91630725782381998.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/navigation_region_alternative_1
prompt  ......region template 91631001900381998.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1NavigationRegionAlternative1" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631001900381998.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Navigation Region, Alternative 1',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 16,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631001900381998.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_region_with_icon
prompt  ......region template 91631304733381999.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1WizardRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2"><table summary="" cellpadding="0" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td valign="top"><img src=';

t:=t||'"#IMAGE_PREFIX#themes/theme_1/wizard_icon.gif" alt=""/></td>'||chr(10)||
'<td width="100%" valign="top">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631304733381999.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Region with Icon',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 20,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631304733381999.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/chart_region
prompt  ......region template 91631622717381999.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ChartRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td';

t:=t||'>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631622717381999.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Chart Region',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 30,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631622717381999.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/bracketed_region
prompt  ......region template 91631925531382001.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1BracketedRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##COPY##CREATE##CREATE2##EXPAND##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td class=';

t:=t||'"t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'<td rowspan="3" class="t1Body">#BODY#</td>'||chr(10)||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" height="1" width="1" alt="" /></td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/the';

t:=t||'me_1/1px_trans.gif" height="1" width="1" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631925531382001.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Bracketed Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Use this region template when you want to contain content with a bracket UI.'||chr(10)||
''||chr(10)||
'TITLE=YES'||chr(10)||
'BUTTONS=YES'||chr(10)||
'100% WIDTH=NO');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631925531382001.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_region
prompt  ......region template 91632204784382001.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1WizardRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91632204784382001.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 12,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91632204784382001.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region_100_width
prompt  ......region template 91632529189382001.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion100Width" width="100%" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91632529189382001.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region 100% Width',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 13,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91632529189382001.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region
prompt  ......region template 91632832228382001.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91632832228382001.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 9,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91632832228382001.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/breadcrumb_region
prompt  ......region template 91633105066382001.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div class="t1BreadcrumbRegion" id="#REGION_ID#">#BODY#</div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91633105066382001.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Breadcrumb Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Use this region template to contain breadcrumb menus.  Breadcrumb menus are implemented using breadcrumbs.  Breadcrumb menus are designed to displayed in #REGION_POSITION_01#');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91633105066382001.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/navigation_region
prompt  ......region template 91633419116382002.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div class="t1NavigationRegion" id="#REGION_ID#">#BODY#</div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91633419116382002.4419 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Navigation Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91633419116382002.4419 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

prompt  ...List Templates
--
--application/shared_components/user_interface/templates/list/dhtml_list_image_with_sublist
prompt  ......list template 91633715033382002.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# / alt=""></a><img src="#IMAGE_PREFIX#themes/generic_nochild.gif" width="22" height="75" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t2:=t2||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# alt="" / ></a><img src="#IMAGE_PREFIX#themes/generic_nochild.gif" width="22" height="75" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t3:=t3||'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>';

t5:=t5||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# alt="" / ></a><img src="#IMAGE_PREFIX#themes/generic_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t6:=t6||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# alt="" / ></a><img src="#IMAGE_PREFIX#themes/generic_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif"  alt="" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>';

wwv_flow_api.create_list_template (
  p_id=>91633715033382002.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML List (Image) with Sublist',
  p_theme_id  => 1,
  p_theme_class_id => 21,
  p_list_template_before_rows=>'<div class="dhtmlMenuLG">',
  p_list_template_after_rows=>'</div><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;"><li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/dhtml_menu_with_sublist
prompt  ......list template 91634003460382007.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li class="dhtmlMenuSep2"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep2" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>';

t5:=t5||'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>';

t6:=t6||'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>';

t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>';

wwv_flow_api.create_list_template (
  p_id=>91634003460382007.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML Menu with Sublist',
  p_theme_id  => 1,
  p_theme_class_id => 20,
  p_list_template_before_rows=>'<ul class="dhtmlMenuLG2">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/dhtml_tree
prompt  ......list template 91634310642382007.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>';

t4:=t4||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif"  align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t5:=t5||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t6:=t6||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t7:=t7||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t8:=t8||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

wwv_flow_api.create_list_template (
  p_id=>91634310642382007.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML Tree',
  p_theme_id  => 1,
  p_theme_class_id => 22,
  p_list_template_before_rows=>'<ul class="dhtmlTree">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" style="display:none;" class="dhtmlTree">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/wizard_progress_list
prompt  ......list template 91634602833382007.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td><div class="t1current">#TEXT#</div><img src="#IMAGE_PREFIX#themes/theme_1/arrow_down.gif" alt="Down" /></td></tr>';

t2:=t2||'<tr><td><div>#TEXT#</div><img src="#IMAGE_PREFIX#themes/theme_1/arrow_down.gif" alt="Down" /></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91634602833382007.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Wizard Progress List',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_list_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="" class="t1WizardProgressList">',
  p_list_template_after_rows=>'<tr><td>&DONE.</td></tr>'||chr(10)||
'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_ordered_list
prompt  ......list template 91634920736382008.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91634920736382008.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Ordered List',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_list_template_before_rows=>'<ol class="t1VerticalOrderedList">',
  p_list_template_after_rows=>'</ol>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/button_list
prompt  ......list template 91635207728382008.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<table class="t1ButtonList" cellspacing="0" cellpadding="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1L"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_left_hl.gif" alt="" /></td>'||chr(10)||
'<td class="t1C"><a href="#LINK#" style="color:#FFFFFF;">#TEXT#</a></td>'||chr(10)||
'<td class="t1R"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_right_hl.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2:=t2||'<table class="t1ButtonList" cellspacing="0" cellpadding="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1L"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_left.gif" alt="" /></td>'||chr(10)||
'<td class="t1NC"><a href="#LINK#">#TEXT#</a></td>'||chr(10)||
'<td class="t1R"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_right.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91635207728382008.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Button List',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_list_template_before_rows=>'<div class="t1ButtonList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/horizontal_links_list
prompt  ......list template 91635520047382008.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="t1current">#TEXT#</a>';

t2:=t2||'<a href="#LINK#">#TEXT#</a>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91635520047382008.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Horizontal Links List',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_list_template_before_rows=>'<div class="t1HorizontalLinksList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_images_list
prompt  ......list template 91635830396382009.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td class="t1current"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / >#TEXT#</td></tr>';

t2:=t2||'<tr><td><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / >#TEXT#</a></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91635830396382009.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Images List',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_list_template_before_rows=>'<table cellpadding="0" cellspacing="0" border="0" summary="0" class="t1VerticalImagesList">',
  p_list_template_after_rows=>'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_sidebar_list
prompt  ......list template 91636106164382009.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="t1navcurrent">#TEXT#</a>';

t2:=t2||'<a href="#LINK#" class="t1nav">#TEXT#</a>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91636106164382009.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Sidebar List',
  p_theme_id  => 1,
  p_theme_class_id => 19,
  p_list_template_before_rows=>'<div class="t1VerticalSidebarList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_unordered_list_without_bullet
prompt  ......list template 91636400543382009.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91636400543382009.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Unordered List without Bullet',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithoutBullet">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
prompt  ......list template 91636711305382010.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91636711305382010.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Unordered List with Bullets',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/tabbed_navigation_list
prompt  ......list template 91637003772382010.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a class="t1current" href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91637003772382010.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Tabbed Navigation List',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_list_template_before_rows=>'<ul class="t1TabbedNavigationList">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/hierarchical_expanded
prompt  ......list template 91637324450382010.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li><a href="#LINK#">#TEXT#</a></li>';

t4:=t4||'<li><a href="#LINK#">#TEXT#</a></li>';

t5:=t5||'<li><a href="#LINK#">#TEXT#</a></li>';

t6:=t6||'<li><a href="#LINK#">#TEXT#</a></li>';

t7:=t7||'<li><a href="#LINK#">#TEXT#</a></li>';

t8:=t8||'<li><a href="#LINK#">#TEXT#</a></li>';

wwv_flow_api.create_list_template (
  p_id=>91637324450382010.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Hierarchical Expanded',
  p_theme_id  => 1,
  p_theme_class_id => 23,
  p_list_template_before_rows=>'<ul class="dhtmlTree">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/horizontal_images_with_label_list
prompt  ......list template 91637614810382010.4419
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<td class="t1current"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ><br />#TEXT#</td>';

t2:=t2||'<td><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></a><br /><a href="#LINK#">#TEXT#</a></td>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91637614810382010.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Horizontal Images with Label List',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_list_template_before_rows=>'<table cellspacing="0" cellpadding="0" border="0" class="t1HorizontalImageswithLabelList" summary=""><tr>',
  p_list_template_after_rows=>'</tr></table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

prompt  ...report templates
--
--application/shared_components/user_interface/templates/report/one_column_unordered_list
prompt  ......report template 91637905071382010.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<li>#COLUMN_VALUE#</li>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91637905071382010.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'One Column Unordered List',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><ul class="t1OneColumnUnorderedList">',
  p_row_template_after_rows =>'</ul><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td></tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'NOT_CONDITIONAL',
  p_row_template_display_cond2=>'NOT_CONDITIONAL',
  p_row_template_display_cond3=>'NOT_CONDITIONAL',
  p_row_template_display_cond4=>'NOT_CONDITIONAL',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91637905071382010.4419 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'OMIT',
  p_row_template_after_last =>'OMIT');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard
prompt  ......report template 91638400927382012.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91638400927382012.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91638400927382012.4419 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard_alternating_row_colors
prompt  ......report template 91638924547382013.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="t1data"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c2:=c2||'<td class="t1dataalt"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91638924547382013.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard, Alternating Row Colors',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><table border="0" cellpadding="0" cellspacing="0" summary="" class="t1standardalternatingrowcolors">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t1header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'ODD_ROW_NUMBERS',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'ODD_ROW_NUMBERS',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'||chr(10)||
'',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard_ppr
prompt  ......report template 91639203883382013.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91639203883382013.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard (PPR)',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>'||chr(10)||
'<script language=JavaScript type=text/javascript>'||chr(10)||
'<!--'||chr(10)||
'init_htmlPPRReport(''#REGION_ID#'');'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>'||chr(10)||
'</htmldb:#REGION_ID#>'||chr(10)||
'</div>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91639203883382013.4419 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/horizontal_border
prompt  ......report template 91639730548382014.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91639730548382014.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Horizontal Border',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" cellspacing="0" border="0" class="t1HorizontalBorder" summary="">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'||chr(10)||
'',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91639730548382014.4419 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/value_attribute_pairs
prompt  ......report template 91640211522382014.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<tr><th class="t1header">#COLUMN_HEADER#</th><td class="t1data">#COLUMN_VALUE#</td></tr>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91640211522382014.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Value Attribute Pairs',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ValueAttributePairs">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td></tr>#PAGINATION#</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91640211522382014.4419 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'OMIT',
  p_row_template_after_last =>'<tr><td colspan="2" class="t1seperate"><hr /></td></tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/borderless
prompt  ......report template 91640708921382015.4419
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91640708921382015.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Borderless',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table class="t1borderless" cellpadding="0" border="0" cellspacing="0" summary="">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t1header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91640708921382015.4419 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

prompt  ...label templates
--
--application/shared_components/user_interface/templates/label/optional_with_help
prompt  ......label template 91641225667382016.4419
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641225667382016.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optional with help',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/no_label
prompt  ......label template 91641313897382017.4419
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641313897382017.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'No Label',
  p_template_body1=>'<span class="t1NoLabel">',
  p_template_body2=>'</span>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 13,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/optional
prompt  ......label template 91641421336382017.4419
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641421336382017.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optional',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><span class="t1Optional">',
  p_template_body2=>'</span></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/required_with_help
prompt  ......label template 91641529261382017.4419
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641529261382017.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Required with help',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/required.gif" alt="Required Field Icon" tabindex="999" /><a class="t1RequiredwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/required
prompt  ......label template 91641600810382017.4419
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641600810382017.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Required',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/required.gif" alt="Required Field Icon" tabindex="999" /><span class="t1Required">',
  p_template_body2=>'</span></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

prompt  ...breadcrumb templates
--
--application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
prompt  ......template 91641730492382017.4419
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 91641730492382017.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Hierarchical Menu',
  p_before_first=>'<ul class="t1HierarchicalMenu">',
  p_current_page_option=>'<li class="t1current">#NAME#</li>',
  p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>',
  p_menu_link_attributes=>'',
  p_between_levels=>'',
  p_after_last=>'</ul>',
  p_max_levels=>11,
  p_start_with_node=>'CHILD_MENU',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
prompt  ......template 91641814330382017.4419
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 91641814330382017.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Breadcrumb Menu',
  p_before_first=>'<div class="t1BreadcrumbMenu">',
  p_current_page_option=>'<span class="t1current">#NAME#</span>',
  p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>',
  p_menu_link_attributes=>'',
  p_between_levels=>'&nbsp;&gt;&nbsp;',
  p_after_last=>'</div>',
  p_max_levels=>12,
  p_start_with_node=>'PARENT_TO_LEAF',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/popuplov
prompt  ...popup list of values templates
--
prompt  ......template 91642503902382024.4419
 
begin
 
begin
wwv_flow_api.create_popup_lov_template (
  p_id=> 91642503902382024.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif',
  p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"',
  p_popup_icon2=>'',
  p_popup_icon_attr2=>'',
  p_page_name=>'winlov',
  p_page_title=>'검색 대화상자',
  p_page_html_head=>'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">'||chr(10)||
'',
  p_page_body_attr=>'onload="first_field()" style="margin:0;"',
  p_before_field_text=>'<div class="t1PopupHead">',
  p_page_heading_text=>'',
  p_page_footer_text =>'',
  p_filter_width     =>'20',
  p_filter_max_width =>'100',
  p_filter_text_attr =>'',
  p_find_button_text =>'검색',
  p_find_button_image=>'',
  p_find_button_attr =>'',
  p_close_button_text=>'닫기',
  p_close_button_image=>'',
  p_close_button_attr=>'',
  p_next_button_text =>'다음 >',
  p_next_button_image=>'',
  p_next_button_attr =>'',
  p_prev_button_text =>'< 이전',
  p_prev_button_image=>'',
  p_prev_button_attr =>'',
  p_after_field_text=>'</div>',
  p_scrollbars=>'1',
  p_resizable=>'1',
  p_width =>'400',
  p_height=>'450',
  p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">#FIRST_ROW# - #LAST_ROW# 행</div>',
  p_result_rows_per_pg=>500,
  p_before_result_set=>'<div class="t1PopupBody">',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_after_result_set   =>'</div>');
end;
null;
 
end;
/

prompt  ...calendar templates
--
--application/shared_components/user_interface/templates/calendar/small_calendar
prompt  ......template 91641910982382018.4419
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 91641910982382018.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Small Calendar',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th class="t1DayOfWeek">#DY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallCalendarHolder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="1" summary="" class="t1SmallCalendar">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallWeekCalendarHolder">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="1" summary="0" class="t1SmallWeekCalendar">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>'||chr(10)||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="1" summary="0" class="t1SmallDayCalendar">',
  p_daily_month_close_format => '</table></td></tr></table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/calendar
prompt  ......template 91642102481382020.4419
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 91642102481382020.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th class="t1DayOfWeek">#IDAY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1CalendarHolder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1WeekCalendarHolder">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1WeekCalendar">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'||chr(10)||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="0" summary="0" class="t1DayCalendar">',
  p_daily_month_close_format => '</table></td> </tr> </table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/calendar_alternative_1
prompt  ......template 91642303533382020.4419
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 91642303533382020.4419 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar, Alternative 1',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th valign="bottom" class="t1DayOfWeek">#IDAY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1CalendarAlternative1Holder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top" height="100" height="100">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1WeekCalendarAlternative1Holder">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1WeekCalendarAlternative1">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>'||chr(10)||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="2" summary="0" class="t1DayCalendarAlternative1">',
  p_daily_month_close_format => '</table></td> </tr> </table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_reference_id=> null);
end;
null;
 
end;
/

prompt  ...application themes
--
prompt  ...build options used by application 4419
--
 
begin
 
null;
 
end;
/

--application/shared_components/globalization/messages
prompt  ...messages used by application: 4419
--
prompt  ......Message master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'마스터 디테일';

wwv_flow_api.create_message (
  p_id=>197641317524155511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MASTER_DETAIL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message master_detail_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 편집';

wwv_flow_api.create_message (
  p_id=>197641400946155511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MASTER_DETAIL_EDIT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message master_detail_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 세부 정보';

wwv_flow_api.create_message (
  p_id=>197641509915155512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MASTER_DETAIL_DETAIL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sw_empty_script
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'빈 SQL 스크립트는 편집할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197641629513155512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SW_EMPTY_SCRIPT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sw_greater_than_30k
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'30KB가 넘는 스크립트는 편집할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197641705859155512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SW_GREATER_THAN_30K',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 마스터 디테일 페이지를 작성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197641824565155512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_MASTER_DETAIL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_3_page_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 마스터 디테일 3';

wwv_flow_api.create_message (
  p_id=>197641914972155512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_2_page_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 마스터 디테일 2';

wwv_flow_api.create_message (
  p_id=>197642012652155512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'마스터 테이블';

wwv_flow_api.create_message (
  p_id=>197642129983155512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_TABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_display_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'마스터 표시 열';

wwv_flow_api.create_message (
  p_id=>197642206780155513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'디테일 테이블';

wwv_flow_api.create_message (
  p_id=>197642322894155513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_TABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_display_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'디테일 표시 열';

wwv_flow_api.create_message (
  p_id=>197642403364155513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_sort
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'마스터 레코드 이동 기준';

wwv_flow_api.create_message (
  p_id=>197642523480155513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_SORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_include_master_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'마스터 보고서를 포함시키겠습니까?';

wwv_flow_api.create_message (
  p_id=>197642603036155513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INCLUDE_MASTER_REPORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_detail_layout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'마스터 디테일 레이아웃';

wwv_flow_api.create_message (
  p_id=>197642719485155513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'마스터 디테일 페이지를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197642824001155514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_MASTER_DETAIL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p42_sql_valid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'적합';

wwv_flow_api.create_message (
  p_id=>197642922334155514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P42_SQL_VALID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p42_code_compiled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'코드가 성공적으로 컴파일되었습니다.';

wwv_flow_api.create_message (
  p_id=>197643001429155514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P42_CODE_COMPILED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message static_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정적 참조';

wwv_flow_api.create_message (
  p_id=>197643131720155514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STATIC_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dynamic_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'동적 참조';

wwv_flow_api.create_message (
  p_id=>197643209169155514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DYNAMIC_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_invalid_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 질의 구문 분석 실패:'||chr(10)||
'<p>%0</p>'||chr(10)||
'<p>%1</p>'||chr(10)||
'특정 질의는 애플리케이션을 실행할 때만 실행될 수 있습니다. 질의 구문이 정확한 경우 검증 없이 질의를 저장할 수 있습니다(질의 소스 아래의 옵션 참조).';

wwv_flow_api.create_message (
  p_id=>197643322840155514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.INVALID_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_chart_query_syntax_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 차트 질의: %0<br><br>'||chr(10)||
'다음 구문을 사용하십시오.'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>막대에 표시할 텍스트</td></tr>'||chr(10)||
'<tr><td>VALUE</td><td>막대 크기를 정의하는 숫자 열</td></tr>'||chr(10)||
'</table>'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197643412866155514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_flash_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'플래시 차트';

wwv_flow_api.create_message (
  p_id=>197643517439155515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.FLASH_CHART',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_zero
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'0 페이지 구성 요소는 애플리케이션 내의 모든 페이지에서 공유됩니다.';

wwv_flow_api.create_message (
  p_id=>197643623528155515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ZERO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message builder
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'생성기';

wwv_flow_api.create_message (
  p_id=>197643701122155515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUILDER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'홈';

wwv_flow_api.create_message (
  p_id=>197643809734155515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message nav_app_builder_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 생성기 홈 페이지로 이동';

wwv_flow_api.create_message (
  p_id=>197643916476155515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NAV_APP_BUILDER_HOME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message home_nav
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Express 홈';

wwv_flow_api.create_message (
  p_id=>197644016303155515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOME_NAV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이름';

wwv_flow_api.create_message (
  p_id=>197644119500155516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_flash_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 플래시 차트 페이지를 작성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197644211059155516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FLASH_CHART',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 그룹';

wwv_flow_api.create_message (
  p_id=>197644305151155516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_GROUP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'폼';

wwv_flow_api.create_message (
  p_id=>197644408495155516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FORM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_xe_config_set_sga_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새 SGA 대상을 설정하는 중 오류가 발생했습니다. %0';

wwv_flow_api.create_message (
  p_id=>197644500879155516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_XE_CONFIG.SET_SGA_TARGET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_xe_config_set_pga_agg_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새 PGA 집계 대상을 설정하는 중 오류가 발생했습니다. %0';

wwv_flow_api.create_message (
  p_id=>197644605947155516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_XE_CONFIG.SET_PGA_AGG_TARGET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_all_page_groups
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모든 페이지 그룹 보기';

wwv_flow_api.create_message (
  p_id=>197644726541155516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW ALL PAGE GROUPS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_all_page_types
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모든 페이지 유형 보기';

wwv_flow_api.create_message (
  p_id=>197644819552155517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW ALL PAGE TYPES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_pages_of_this_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'해당 유형의 페이지 보기';

wwv_flow_api.create_message (
  p_id=>197644913938155517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_PAGES_OF_THIS_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_zero
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'0페이지';

wwv_flow_api.create_message (
  p_id=>197645013276155517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_ZERO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reset_4000
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'재설정';

wwv_flow_api.create_message (
  p_id=>197645105675155517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RESET_4000',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message blank
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'공백';

wwv_flow_api.create_message (
  p_id=>197645206893155517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BLANK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit_page_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 그룹 편집';

wwv_flow_api.create_message (
  p_id=>197645327677155517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT PAGE GROUP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 - 레이아웃';

wwv_flow_api.create_message (
  p_id=>197645402183155518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message processing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'요청을 처리하는 중입니다. 기다리십시오.';

wwv_flow_api.create_message (
  p_id=>197645518678155518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROCESSING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message shared_pool
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'공유 풀';

wwv_flow_api.create_message (
  p_id=>197645609802155518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SHARED POOL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message buffer_cache
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'버퍼 캐시';

wwv_flow_api.create_message (
  p_id=>197645710876155518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUFFER CACHE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message other
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기타';

wwv_flow_api.create_message (
  p_id=>197645804114155518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OTHER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message navigation_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탐색 페이지';

wwv_flow_api.create_message (
  p_id=>197645931813155518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NAVIGATION_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_menus
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리';

wwv_flow_api.create_message (
  p_id=>197646017401155518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_MENUS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_lists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록';

wwv_flow_api.create_message (
  p_id=>197646123159155519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_LISTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message manage_page_groups
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 그룹 관리';

wwv_flow_api.create_message (
  p_id=>197646209887155519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MANAGE PAGE GROUPS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_lists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용된 목록이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197646310497155519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_LISTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_menus
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용된 연결 고리가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197646414360155519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_MENUS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p374_pos_5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'위치 5';

wwv_flow_api.create_message (
  p_id=>197646526320155519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P374.POS.5',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reassign_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 재지정';

wwv_flow_api.create_message (
  p_id=>197646615308155519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REASSIGN_PAGES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message static_html
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정적 HTML';

wwv_flow_api.create_message (
  p_id=>197646704068155520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STATIC_HTML',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_must_be_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 계정에 대한 암호를 변경해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197646818991155520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_MUST_BE_CHANGED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dynamic_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'동적 폼';

wwv_flow_api.create_message (
  p_id=>197646912894155520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DYNAMIC_FORM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apex_wizard_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탐색 폼';

wwv_flow_api.create_message (
  p_id=>197647005405155520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEX_WIZARD_FORM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_htmldb_user_guide
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Builder User''s Guide';

wwv_flow_api.create_message (
  p_id=>197647125042155520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.HTMLDB_USER_GUIDE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_2_day_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'2 Day Developer';

wwv_flow_api.create_message (
  p_id=>197647210296155520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.2_DAY_DEV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_2_day_dba
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'2 Day DBA';

wwv_flow_api.create_message (
  p_id=>197647316776155521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.2_DAY_DBA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_referential
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'참조';

wwv_flow_api.create_message (
  p_id=>197647411430155521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_REFERENTIAL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message inactive
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'비활성';

wwv_flow_api.create_message (
  p_id=>197647516756155521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INACTIVE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1220_script_result
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%1에 실행된 %0의 결과 ';

wwv_flow_api.create_message (
  p_id=>197647617392155521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1220_SCRIPT_RESULT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dml_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DML 폼';

wwv_flow_api.create_message (
  p_id=>197647713060155521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DML_FORM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 항목은 다음 또는 이전 기본 키 값 가져오기 프로세스에 필요합니다.';

wwv_flow_api.create_message (
  p_id=>197647830717155521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_ITEM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 단추는 다음 또는 이전 기본 키 값 가져오기 프로세스에 필요합니다.';

wwv_flow_api.create_message (
  p_id=>197647923067155522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_BUTTON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 또는 이전 기본 키 값 가져오기';

wwv_flow_api.create_message (
  p_id=>197648005725155522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_show_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열 표시/숨기기';

wwv_flow_api.create_message (
  p_id=>197648125553155522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_SHOW_COLS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_remove_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제거';

wwv_flow_api.create_message (
  p_id=>197648209055155522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_REMOVE_TABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_join_hint
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'조인할 열을 선택하려면 여기를 누르십시오.';

wwv_flow_api.create_message (
  p_id=>197648302004155522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_JOIN_HINT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 또는 이전 기본 키 값 가져오기 프로세스를 실행할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197648430112155522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_PROCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_form_control_get_next_or_prev_pk_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 또는 이전 기본 키 값을 가져올 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197648523155155522 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORM_CONTROL.GET_NEXT_OR_PREV_PK_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_form_control_check_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로세스 정의를 다시 검사하십시오. %0';

wwv_flow_api.create_message (
  p_id=>197648603361155523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORM_CONTROL.CHECK_PROCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_stmt_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'명령문이 처리되었습니다.';

wwv_flow_api.create_message (
  p_id=>197648719655155523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.STMT_PROCESSED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_deinstall
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설치 해제 스크립트';

wwv_flow_api.create_message (
  p_id=>197648826877155523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.DEINSTALL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열';

wwv_flow_api.create_message (
  p_id=>197648921871155523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_COLUMN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'별칭';

wwv_flow_api.create_message (
  p_id=>197649003417155523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_ALIAS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_object
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'객체';

wwv_flow_api.create_message (
  p_id=>197649104053155523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_OBJECT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'조건';

wwv_flow_api.create_message (
  p_id=>197649210024155524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_CONDITION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_sort
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정렬 유형';

wwv_flow_api.create_message (
  p_id=>197649306406155524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_SORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_sort_order
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정렬 순서';

wwv_flow_api.create_message (
  p_id=>197649421966155524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_SORT_ORDER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_output
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시';

wwv_flow_api.create_message (
  p_id=>197649524690155524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_OUTPUT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'함수';

wwv_flow_api.create_message (
  p_id=>197649610962155524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_FUNCTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'그룹 기준';

wwv_flow_api.create_message (
  p_id=>197649722581155524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_GROUP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message file_too_big
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 텍스트 파일은 너무 커서 편집할 수 없습니다. 내용을 변경하려면 로컬 시스템에서 파일을 편집하고 다시 업로드해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197649830237155524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FILE_TOO_BIG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_total_sessions2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'총 세션: %0';

wwv_flow_api.create_message (
  p_id=>197649915295155525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350_TOTAL_SESSIONS2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_prefs_exists_for2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%1명의 사용자에 대한 기호사항이 %0개 존재합니다.';

wwv_flow_api.create_message (
  p_id=>197650002420155525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350_PREFS_EXISTS_FOR2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_to_create_tablespace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'지금 테이블스페이스를 생성할 수 없습니다. 나중에 다시 시도하십시오.';

wwv_flow_api.create_message (
  p_id=>197650121741155525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_TO_CREATE_TABLESPACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_query_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 질의입니다. Select 문을 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197650220526155525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_QUERY_REQUIRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_join
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'조인';

wwv_flow_api.create_message (
  p_id=>197650303820155525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_JOIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'대상';

wwv_flow_api.create_message (
  p_id=>197650430811155525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_TO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_max_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'최대 60개의 열을 선택할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197650505007155526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_MAX_COLS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message application_x
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 애플리케이션';

wwv_flow_api.create_message (
  p_id=>197650602263155526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APPLICATION_X',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_executing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'실행 중';

wwv_flow_api.create_message (
  p_id=>197650729390155526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.EXECUTING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message clear_command
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'명령 지우기';

wwv_flow_api.create_message (
  p_id=>197650811253155526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CLEAR_COMMAND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message find_tables
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블 찾기';

wwv_flow_api.create_message (
  p_id=>197650915787155526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FIND_TABLES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 페이지를 저장하지 않은 채 종료하겠습니까?';

wwv_flow_api.create_message (
  p_id=>197651016590155526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_SHORTCUT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message download
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다운로드';

wwv_flow_api.create_message (
  p_id=>197651123740155527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DOWNLOAD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_for_printing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인쇄 화면 보기';

wwv_flow_api.create_message (
  p_id=>197651232090155527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_FOR_PRINTING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_developer_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'개발자 권한이 없음';

wwv_flow_api.create_message (
  p_id=>197651304090155527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_DEVELOPER_PRIV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_valid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호가 적합함';

wwv_flow_api.create_message (
  p_id=>197651408660155527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_VALID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호가 만기됨';

wwv_flow_api.create_message (
  p_id=>197651516559155527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_EXPIRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_completed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'완료됨';

wwv_flow_api.create_message (
  p_id=>197651600542155527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.COMPLETED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_in_progress
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'진행 중';

wwv_flow_api.create_message (
  p_id=>197651728569155528 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.IN_PROGRESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_result_row
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0개의 행';

wwv_flow_api.create_message (
  p_id=>197651803104155528 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RESULT_ROW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_result_rows
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0개의 행';

wwv_flow_api.create_message (
  p_id=>197651924729155528 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RESULT_ROWS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_elapsed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0초';

wwv_flow_api.create_message (
  p_id=>197652000598155528 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.ELAPSED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'개발자가 정의됨';

wwv_flow_api.create_message (
  p_id=>197652100648155528 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SCHEME_DESC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정상, 인증 성공';

wwv_flow_api.create_message (
  p_id=>197652228681155528 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_SUCCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_unknown_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'알 수 없는 사용자 이름';

wwv_flow_api.create_message (
  p_id=>197652317670155529 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_UNKNOWN_USER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_account_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'계정이 잠김';

wwv_flow_api.create_message (
  p_id=>197652430952155529 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_ACCOUNT_LOCKED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_account_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'계정이 만기됨';

wwv_flow_api.create_message (
  p_id=>197652526467155529 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_ACCOUNT_EXPIRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_password_incorrect
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부정확한 암호';

wwv_flow_api.create_message (
  p_id=>197652608184155529 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_PASSWORD_INCORRECT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_password_first_use
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호 처음 사용';

wwv_flow_api.create_message (
  p_id=>197652706897155529 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_PASSWORD_FIRST_USE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_attempts_exceeded
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'최대 로그인 시도 횟수가 초과됨';

wwv_flow_api.create_message (
  p_id=>197652802584155529 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_ATTEMPTS_EXCEEDED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_internal_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'알 수 없는 내부 오류';

wwv_flow_api.create_message (
  p_id=>197652926719155529 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_INTERNAL_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사이트 관리';

wwv_flow_api.create_message (
  p_id=>197653009870155530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_LOGIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message workspace_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역 로그인';

wwv_flow_api.create_message (
  p_id=>197653129417155530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WORKSPACE_LOGIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_admin_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'액세스 제어 관리 페이지';

wwv_flow_api.create_message (
  p_id=>197653207248155530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_ADMIN_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_confirm_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블 생성';

wwv_flow_api.create_message (
  p_id=>197653317799155530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CONFIRM_TABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 관리';

wwv_flow_api.create_message (
  p_id=>197653427921155530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_ADMIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모두에게 전체 액세스. 액세스 제어 목록이 사용되지 않습니다.';

wwv_flow_api.create_message (
  p_id=>197653507525155530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제한된 액세스. 액세스 제어 목록에서 정의된 사용자만 허용됩니다.';

wwv_flow_api.create_message (
  p_id=>197653632560155531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'공용 읽기 전용. 액세스 제어 목록에 의해 편집 및 관리 권한이 제어됩니다.';

wwv_flow_api.create_message (
  p_id=>197653729241155531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE3',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'관리 액세스 전용.';

wwv_flow_api.create_message (
  p_id=>197653815900155531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE4',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션에 대한 액세스 제어 방식을 지정하십시오.';

wwv_flow_api.create_message (
  p_id=>197653908292155531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE_HELP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 모드';

wwv_flow_api.create_message (
  p_id=>197654019670155531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_set_app_mode
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 모드 설정';

wwv_flow_api.create_message (
  p_id=>197654125052155531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_SET_APP_MODE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dbaccount_auth_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 계정';

wwv_flow_api.create_message (
  p_id=>197654228807155532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DBACCOUNT_AUTH_SCHEME_DESC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'액세스 제어 목록';

wwv_flow_api.create_message (
  p_id=>197654300584155532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_LIST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ldap_auth_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP';

wwv_flow_api.create_message (
  p_id=>197654429039155532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LDAP_AUTH_SCHEME_DESC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_username
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자 이름';

wwv_flow_api.create_message (
  p_id=>197654516355155532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_USERNAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'권한';

wwv_flow_api.create_message (
  p_id=>197654618069155532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_PRIV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'관리자';

wwv_flow_api.create_message (
  p_id=>197654726100155532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_ADMIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_last_changed_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'마지막으로 변경한 사람';

wwv_flow_api.create_message (
  p_id=>197654801278155532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_find_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'질의 조건(대소문자 구분 안함)을 입력한 다음 <b>실행</b> 단추를 누르십시오.';

wwv_flow_api.create_message (
  p_id=>197654912039155533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_FIND_HELP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_get_app_mode_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 관리 모드를 가져올 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197655019805155533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_no_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시도한 작업에 대한 권한이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197655113349155533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_NO_PRIV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode_set_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 모드 설정 요청을 처리할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197655225452155533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode_set_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 모드 설정';

wwv_flow_api.create_message (
  p_id=>197655327584155533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_print_util_invalid_proxy_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'지정한 URL이 부정확하거나 프록시 URL을 지정해야 하기 때문에 인쇄 엔진에 도달할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197655418554155533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PRINT_UTIL.INVALID_PROXY_URL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_object_browser_only_n_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'처음 %0개의 열이 표시됩니다.';

wwv_flow_api.create_message (
  p_id=>197655519983155534 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_run_script
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 스크립트를 실행하도록 요청했습니다. 요청 내용을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197655611985155534 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RUN_SCRIPT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_script_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스크립트 이름';

wwv_flow_api.create_message (
  p_id=>197655728165155534 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_SCRIPT_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_num_stmts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'명령문 수';

wwv_flow_api.create_message (
  p_id=>197655830199155534 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_NUM_STMTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_details
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세부 정보 보기';

wwv_flow_api.create_message (
  p_id=>197655901336155534 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_DETAILS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_deinstall
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제거';

wwv_flow_api.create_message (
  p_id=>197656010242155534 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.DEINSTALL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4050_31_log_count
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그인 액세스 로그 항목';

wwv_flow_api.create_message (
  p_id=>197656126181155535 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4050_31_LOG_COUNT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ob_compile_errors
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0개의 오류';

wwv_flow_api.create_message (
  p_id=>197656213941155535 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OB_COMPILE_ERRORS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'색상 팔레트';

wwv_flow_api.create_message (
  p_id=>197656321657155535 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_run_file_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스크립트를 실행할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197656402395155535 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RUN_FILE_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_run_stmt_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'run_statement에서 오류가 발생했습니다. %0';

wwv_flow_api.create_message (
  p_id=>197656512710155536 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RUN_STMT_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_run_sql_arr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'run_sql_arr에서 오류가 발생했습니다. %0';

wwv_flow_api.create_message (
  p_id=>197656626014155536 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.RUN_SQL_ARR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_script_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'성공';

wwv_flow_api.create_message (
  p_id=>197656705874155536 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SCRIPT.SUCCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_script_fail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류';

wwv_flow_api.create_message (
  p_id=>197656820430155536 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SCRIPT.FAIL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모두 편집';

wwv_flow_api.create_message (
  p_id=>197656908573155536 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT_ALL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_query_limit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SELECT 문은 32KB를 초과할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197657028367155537 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.QUERY_LIMIT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message administator
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역 관리자';

wwv_flow_api.create_message (
  p_id=>197657113934155537 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ADMINISTATOR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message developer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'개발자';

wwv_flow_api.create_message (
  p_id=>197657207724155537 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEVELOPER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message end_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'일반 사용자';

wwv_flow_api.create_message (
  p_id=>197657312814155537 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'END_USER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_nosgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보안 그룹 ID가 널입니다.';

wwv_flow_api.create_message (
  p_id=>197657427137155537 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_NOSGID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_rows_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0개의 행이 선택되었습니다.';

wwv_flow_api.create_message (
  p_id=>197657504472155537 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.ROWS_SELECTED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_welcome
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시작';

wwv_flow_api.create_message (
  p_id=>197657609907155537 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.WELCOME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_existence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'존재 확인 실패';

wwv_flow_api.create_message (
  p_id=>197657703205155538 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.EXISTENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_configuration
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 대체';

wwv_flow_api.create_message (
  p_id=>197657819704155538 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIGURATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_build_options
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'빌드 옵션';

wwv_flow_api.create_message (
  p_id=>197657904316155538 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.BUILD_OPTIONS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증';

wwv_flow_api.create_message (
  p_id=>197658018137155538 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.VALIDATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_confirmation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설치 확인';

wwv_flow_api.create_message (
  p_id=>197658128724155538 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIRMATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사후 설치 성공';

wwv_flow_api.create_message (
  p_id=>197658231920155538 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SUCCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_failure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사후 설치 실패';

wwv_flow_api.create_message (
  p_id=>197658311042155539 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.FAILURE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_license
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'라이센스';

wwv_flow_api.create_message (
  p_id=>197658416728155539 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.LICENSE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_confirm_deinstall
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설치 해제 확인';

wwv_flow_api.create_message (
  p_id=>197658524335155539 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIRM_DEINSTALL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_deinstall_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설치 해제 성공';

wwv_flow_api.create_message (
  p_id=>197658619205155539 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.DEINSTALL_SUCCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2613_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호가 만기됨';

wwv_flow_api.create_message (
  p_id=>197658720776155539 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2613_EXPIRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message manual
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'수동';

wwv_flow_api.create_message (
  p_id=>197658817018155539 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MANUAL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_flow_dbaccount
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 계정';

wwv_flow_api.create_message (
  p_id=>197658910597155540 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_FLOW.DBACCOUNT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_auth_scheme_desc_dbaccount
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 계정 증명서를 사용하십시오.';

wwv_flow_api.create_message (
  p_id=>197659011425155540 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.AUTH_SCHEME_DESC_DBACCOUNT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_use_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기존 테이블 사용';

wwv_flow_api.create_message (
  p_id=>197659132766155540 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_USE_TABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_create_auth_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'권한 체계 생성';

wwv_flow_api.create_message (
  p_id=>197659206823155540 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_script_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 스크립트를 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197659313537155540 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.SCRIPT_NOT_FOUND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_max_nest_level
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1004 스크립트를 %0 레벨 이상으로 중첩할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197659413099155540 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.MAX_NEST_LEVEL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_cannot_run_cmd
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'차단된 %0 명령입니다. SQL 워크숍에서 실행할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197659529703155540 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CANNOT_RUN_CMD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_dbaccount_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 함수를 -DBACCOUNT-로 채우려면 누르십시오.'||chr(10)||
''||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197659623340155541 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P802.DBACCOUNT_TITLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_dbauth_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 계정 사용자 이름 및 암호를 사용하여 인증하십시오.';

wwv_flow_api.create_message (
  p_id=>197659706849155541 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_DBAUTH_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parsing_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'실행 스키마';

wwv_flow_api.create_message (
  p_id=>197659806061155541 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARSING_SCHEMA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_use_auth_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기존 권한 체계 사용';

wwv_flow_api.create_message (
  p_id=>197659914669155541 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_rpt_region_header
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션의 인증 체계에 해당하는 사용자 이름을 지정하십시오.';

wwv_flow_api.create_message (
  p_id=>197660016718155541 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action15a
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle 데이터베이스 계정에 대해 로그인 폼에 입력된 사용자 이름 및 암호를 확인하십시오. 이 기술은 애플리케이션 사용자가 데이터베이스에 계정을 가지고 있는 경우에 유용합니다.';

wwv_flow_api.create_message (
  p_id=>197660131061155541 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION15A',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message account_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'계정이 잠겼습니다.';

wwv_flow_api.create_message (
  p_id=>197660224903155542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCOUNT_LOCKED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message unknown_authentication_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'알 수 없는 인증 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197660305412155542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UNKNOWN_AUTHENTICATION_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_before_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'본문 앞';

wwv_flow_api.create_message (
  p_id=>197660407055155542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BEFORE_BODY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_after_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'본문 뒤';

wwv_flow_api.create_message (
  p_id=>197660505306155542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.AFTER_BODY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_max_script_output_reached
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1005 스크립트 결과가 최대 크기 제한에 도달했습니다. 결과가 이보다 적게 생성되도록 스크립트를 변경하거나 관리자에게 요청하여 최대 스크립트 결과 크기를 늘리십시오.';

wwv_flow_api.create_message (
  p_id=>197660629714155542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.MAX_SCRIPT_OUTPUT_REACHED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_max_workspace_output_reached
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1005 스크립트 결과가 최대 작업 영역 결과 크기 제한에 도달했습니다. 기존 결과를 삭제하거나 관리자에게 요청하여 최대 작업 영역 결과 크기를 늘리십시오.';

wwv_flow_api.create_message (
  p_id=>197660701283155542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.MAX_WORKSPACE_OUTPUT_REACHED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hr_account_unlocked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HR 계정의 잠금이 해제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197660805439155543 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HR_ACCOUNT_UNLOCKED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_htmldb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Express 2 Day Plus Developer Guide';

wwv_flow_api.create_message (
  p_id=>197660908920155543 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD HTMLDB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_dba
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day DBA';

wwv_flow_api.create_message (
  p_id=>197661005207155543 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD DBA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Developer Guide';

wwv_flow_api.create_message (
  p_id=>197661120127155543 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD DEV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_java
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Plus Java Developer Guide';

wwv_flow_api.create_message (
  p_id=>197661205191155543 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD JAVA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_net
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Plus .NET Developer Guide';

wwv_flow_api.create_message (
  p_id=>197661324218155543 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD NET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_php
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Plus PHP Developer';

wwv_flow_api.create_message (
  p_id=>197661410737155544 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD PHP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_dba
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'일반적인 일일 관리 작업에 대해 설명합니다.';

wwv_flow_api.create_message (
  p_id=>197661523881155544 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG DBA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 개발 환경을 활용하는 방법에 대해 설명합니다.';

wwv_flow_api.create_message (
  p_id=>197661605426155544 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG DEV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_htmldb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 중심의 웹 애플리케이션을 생성하는 방법에 대해 설명하는 자습서 시리즈를 제공합니다.';

wwv_flow_api.create_message (
  p_id=>197661715981155544 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG HTMLDB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_php
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 문서는 Apache 및 Zend Core PHP 드라이버를 다운로드하고 설치하는 방법, 설치한 PHP를 사용하여 Oracle Database XE에 접속하는 방법, PHP로 간단한 응용 프로그램을 개발하여 데이터에 액세스하고 수정하는 방법을 보여주는 자습서를 제공합니다.';

wwv_flow_api.create_message (
  p_id=>197661820480155544 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG PHP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_java
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 문서는 Java 및 JDBC를 사용하여 Oracle Database XE에 접속하는 방법, 간단한 Java 응용 프로그램을 개발하여 데이터에 액세스하고 수정하는  방법을 보여주는 자습서를 제공합니다.';

wwv_flow_api.create_message (
  p_id=>197661926761155545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG JAVA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_net
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 문서는 Oracle Data Provider for .NET 및 Oracle Developer Tools for Visual Studio .NET의 주요 기능을 설명합니다. 단계별로 설치 및 구성 과정을 안내하고, Oracle Data Provider for .NET 및 Oracle Developer Tools for Visual Studio .NET을 사용하여 기본 응용 프로그램을 생성하는 방법, PL/SQL 및 .NET 내장 프로시저를 작성하고 사용하는 방법을 보여줍니다.';

wwv_flow_api.create_message (
  p_id=>197662012668155545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG NET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message account_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'계정이 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197662127131155545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCOUNT_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_invalid_context
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 프로시저는 애플리케이션 세션 내에서 호출해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197662231952155545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.INVALID_CONTEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_foreign
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'외래';

wwv_flow_api.create_message (
  p_id=>197662308188155545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_FOREIGN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_requires_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 WSDL은 증명서를 필요로 합니다. 아래에 사용자 이름 및 암호를 제공하십시오.';

wwv_flow_api.create_message (
  p_id=>197662415391155546 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_REQUIRES_AUTH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_save_item_show
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시 프로세싱 중 %0 항목을 세션 상태에 저장하려고 했습니다. 항목 보호 레벨은 "%1"입니다. 전달된 체크섬이 없거나 전달된 체크섬이 보호 레벨 "%2"의 항목에 적합합니다.';

wwv_flow_api.create_message (
  p_id=>197662519241155546 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SAVE_ITEM_SHOW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_unprotected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목에 설정된 보호가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197662619976155546 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.UNPROTECTED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_public_bookmark
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"애플리케이션 레벨 책갈피" 체크섬과 함께 사용될 경우 항목을 설정할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197662722635155546 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.PUBLIC_BOOKMARK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_private_bookmark
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"사용자 레벨 책갈피" 체크섬과 함께 사용될 경우 항목을 설정할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197662808284155546 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.PRIVATE_BOOKMARK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"세션" 체크섬과 함께 사용될 경우 항목을 설정할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197662922095155547 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SESSION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_internal_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인수를 애플리케이션에 전달하면 항목을 설정하지 못할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197663017687155547 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.INTERNAL_ONLY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_unprotected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지에 설정된 보호가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197663130253155547 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.UNPROTECTED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_checksum_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'체크섬이 표시 프로시저에 전달될 경우 인수를 사용하여 페이지를 요청할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197663228359155547 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.CHECKSUM_REQUIRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_no_args_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인수를 사용하지 않고 페이지에 액세스할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197663326039155547 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.NO_ARGS_ALLOWED ',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_direct_branch_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"페이지 분기" 유형 분기를 사용할 경우에만 다른 페이지에서 해당 페이지로 액세스할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197663432731155548 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.DIRECT_BRANCH_ONLY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_checksum_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'하나 이상의 요청, 캐시 비우기 또는 인수 값이 매개변수로 전달될 때 체크섬이 필요한 페이지에 대한 표시 프로세싱에 체크섬이 제공되지 않았습니다.';

wwv_flow_api.create_message (
  p_id=>197663504287155548 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_CHECKSUM_MISSING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_checksum_mismatch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'요청, 캐시 비우기, 인수 이름 및 인수 값(%0)에 대해 계산된 체크섬이 표시 프로시저(%1)에 전달된 체크섬과 일치하지 않습니다.';

wwv_flow_api.create_message (
  p_id=>197663617558155548 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_CHECKSUM_MISMATCH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_no_args_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인수(요청, 캐시 비우기, 항목 값)를 허용하지 않는 페이지에 인수가 전달되었습니다.';

wwv_flow_api.create_message (
  p_id=>197663717496155548 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_NO_ARGS_ALLOWED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_no_url_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 페이지는 URL 또는 표시 프로시저에 대한 GET/POST를 사용하여 호출할 수 없습니다. "페이지 분기" 분기 유형을 사용하여 호출해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197663814740155548 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_NO_URL_ALLOWED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_save_item_internal_only_accept
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'허용 프로세싱 중 세션 상태에 %0 항목을 저장하려고 했습니다. 항목에 내부 전용 보호가 설정되어 있거나 항목이 게시될 수 있는 폼 항목이 아닙니다.';

wwv_flow_api.create_message (
  p_id=>197663902977155548 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SAVE_ITEM_INTERNAL_ONLY_ACCEPT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_no_checksum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(제공된 체크섬이 없습니다.)';

wwv_flow_api.create_message (
  p_id=>197664031018155549 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.NO_CHECKSUM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_invalid_date
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 날짜 값이 발견되었습니다. 날짜 형식을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197664117364155549 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.INVALID_DATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_ui_def_hint_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 생성기에서 사용자 인터페이스 기본값을 사용하여 단일 애플리케이션이나 다중 애플리케이션의 다중 페이지 간에 일관성을 제공하는 영역 및 항목 속성에 대한 초기값을 채웁니다.';

wwv_flow_api.create_message (
  p_id=>197664208201155549 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_UI_DEF_HINT_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열기';

wwv_flow_api.create_message (
  p_id=>197664308307155549 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_OPEN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'잠김';

wwv_flow_api.create_message (
  p_id=>197664415839155549 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_LOCKED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'만기됨';

wwv_flow_api.create_message (
  p_id=>197664531151155549 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_EXPIRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_expired_and_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'만기 후 잠김';

wwv_flow_api.create_message (
  p_id=>197664618681155550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_EXPIRED_AND_LOCKED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message delete_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 삭제 작업을 수행하겠습니까?';

wwv_flow_api.create_message (
  p_id=>197664705713155550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DELETE_MSG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'크기';

wwv_flow_api.create_message (
  p_id=>197664807185155550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SIZE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message length
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'길이';

wwv_flow_api.create_message (
  p_id=>197664932721155550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LENGTH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message lines
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'행';

wwv_flow_api.create_message (
  p_id=>197665021444155550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LINES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'달력';

wwv_flow_api.create_message (
  p_id=>197665108811155550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_easy_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'간단한 달력';

wwv_flow_api.create_message (
  p_id=>197665232111155551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR_EASY_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_email_click_on_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'승인 프로세스를 완료하고 증명서를 받으려면'||chr(10)||
''||chr(10)||
'%0 '||chr(10)||
''||chr(10)||
'링크를 누르십시오.';

wwv_flow_api.create_message (
  p_id=>197665321567155551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.EMAIL_CLICK_ON_LINK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_accepted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DELETE';

wwv_flow_api.create_message (
  p_id=>197665400858155551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.ACCEPTED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_ws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 웹 서비스 참조 페이지에 폼을 생성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197665511753155551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_WS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_web_service_ref
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'웹 서비스 참조, 작업';

wwv_flow_api.create_message (
  p_id=>197665610884155551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.WEB_SERVICE_REF',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_input_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'폼 항목';

wwv_flow_api.create_message (
  p_id=>197665713334155551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INPUT_ITEMS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_output_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'출력 항목';

wwv_flow_api.create_message (
  p_id=>197665823652155551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.OUTPUT_ITEMS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p30_no_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Microsoft Access 질의에 해당하는 Oracle 뷰를 찾을 수 없습니다. Microsoft Access 질의 구문이 편집 창에 로드되었습니다. Oracle 뷰를 생성하려면 이 구문을 수정하십시오.';

wwv_flow_api.create_message (
  p_id=>197665931998155552 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P30_NO_VIEW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p30_view_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'뷰의 상태가 VALID여야 이전 프로세스 동안 해당 뷰를 사용할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197666027522155552 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P30_VIEW_HELP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message storage
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'저장 영역:';

wwv_flow_api.create_message (
  p_id=>197666103529155552 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STORAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message memory
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'메모리:';

wwv_flow_api.create_message (
  p_id=>197666205042155552 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MEMORY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message home_page_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자:';

wwv_flow_api.create_message (
  p_id=>197666329514155552 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOME_PAGE_USERS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sessions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세션:';

wwv_flow_api.create_message (
  p_id=>197666414162155552 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SESSIONS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message active
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'활성:';

wwv_flow_api.create_message (
  p_id=>197666526268155553 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACTIVE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p3_find_file
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'엑스포터 툴에 의해 생성된 파일 찾기';

wwv_flow_api.create_message (
  p_id=>197666622757155553 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P3_FIND_FILE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>1. Microsoft Access 메타 데이터를 익스포트합니다.</b><br />'||chr(10)||
'Microsoft Access용 익스포터를 실행하고 .mdb 파일에서 메타 데이터를 추출합니다. 그러면 데이터베이스(.xml) 및 애플리케이션(.sql) 출력 파일이 생성됩니다.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>197666729046155553 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>2. Microsoft Access 데이터베이스를 Oracle로 이전합니다.</b><br />'||chr(10)||
'Oracle Migration Workbench를 실행하고 단계 1에서 얻은 데이터베이스 메타 데이터를 로드합니다. 그러면 스키마 및 데이터가 Oracle로 이전됩니다.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>197666807386155553 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>3. Oracle Application Express 작업 영역을 생성합니다.</b><br />'||chr(10)||
'Oracle Application Express를 실행하고 작업 영역을 생성합니다. 작업 영역을 단계 2에서 새로 생성된 스키마와 연관시킵니다.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>197666920320155553 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP3',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>4. 이전 프로젝트를 생성합니다.</b><br />'||chr(10)||
'단계 3에서 생성된 작업 영역에 로그인하고 Application Migration Workshop을 실행합니다. 이전 프로젝트를 생성하고 단계 1에서 얻은 애플리케이션 메타 데이터를 로드합니다.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>197667018782155553 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP4',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>5. Microsoft Access 애플리케이션을 분석합니다.</b><br />'||chr(10)||
'Application Migration Workshop에서 Access 애플리케이션 메타 데이터를 확인 및 조정합니다. 이전 범위를 세분화하고 부적합한 객체가 있으면 수정합니다. '||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>197667102058155554 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP5',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>6. Oracle Application Express 애플리케이션을 생성합니다.</b><br />'||chr(10)||
'적합한 폼 또는 보고서에 준한 애플리케이션을 생성하거나 적합한 테이블 및 뷰에 준한 유지 관리 애플리케이션을 생성합니다.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>197667221133155554 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP6',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>7. Application Express 애플리케이션을 사용자 정의합니다.</b><br />'||chr(10)||
'Application Express의 애플리케이션 생성기 부분에서 애플리케이션을 열고 이전된 애플리케이션을 사용자 정의합니다. 애플리케이션 속성을 변경하거나 애플리케이션에 새 페이지를 추가할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197667317520155554 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP7',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message internal_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내부';

wwv_flow_api.create_message (
  p_id=>197667405990155554 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INTERNAL_USERS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message database_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스';

wwv_flow_api.create_message (
  p_id=>197667531634155554 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DATABASE_USERS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p22_obj_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0"이(가) 성공적으로 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197667606201155554 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P22_OBJ_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p10_queries_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'맨 왼쪽 열을 사용하여 이전에 포함시키고자 하는 질의를 선택하십시오. '||chr(10)||
'<br><br>'||chr(10)||
'질의를 포함시키려면 해당 질의의 상태가 <b>적합</b>이어야 합니다. 기본적으로 <b>적합</b> 상태의 모든 질의가 선택되어 있습니다.'||chr(10)||
'<br><br>'||chr(10)||
'포함시킬 질의를 선택하지 않은 경우 이 질의에 준한 모든 폼과 보고서가 이전에 포함되지 않습니다.'||chr(10)||
'<br><br>'||chr(10)||
'모든 질의 컴파일을 시도하는 대량 프로세스를 실행하려면 <b>부적합한 질의 컴파일 시도</b> 링크를 누르십시오.'||chr(10)||
'<br><br>'||chr(10)||
'선택 사항 또는 갱신 사항을 저장하려면 <b>변경 사항 적용</b>을 누르십시오.';

wwv_flow_api.create_message (
  p_id=>197667705356155554 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P10_QUERIES_HELP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p9_tables_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'맨 왼쪽 열을 사용하여 이전에 포함시키고자 하는 테이블을 선택하십시오.'||chr(10)||
'<br><br>'||chr(10)||
'테이블을 포함시키려면 해당 테이블의 상태가 <b>적합</b>이어야 합니다. 기본적으로 <b>적합</b> 상태의 모든 테이블이 선택되어 있습니다.'||chr(10)||
'<br><br>'||chr(10)||
'포함시킬 테이블을 선택하지 않은 경우 이 테이블에 준한 모든 폼과 보고서가 이전에서 제외됩니다.'||chr(10)||
'<br><br>선택 사항 또는 갱신 사항을 저장하려면 <b>변경 사항 적용</b>을 누르십시오.';

wwv_flow_api.create_message (
  p_id=>197667812702155555 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P9_TABLES_HELP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p22_table_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블에 기본 키가 없으면 <b>기본 키 생성</b> 링크를 눌러 하나를 추가하십시오. 기본 키가 있어야 모든 테이블이 이전됩니다.';

wwv_flow_api.create_message (
  p_id=>197667922002155555 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P22_TABLE_INFO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p8_forms_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'1. 맨 왼쪽 열을 사용하여 이전에 포함시키고자 하는 폼을 선택하십시오.'||chr(10)||
'<br /><br />'||chr(10)||
'폼을 포함시키려면 해당 폼 소스의 상태가 <b>적합</b>이어야 합니다. 기본적으로 적합한 소스 객체에 준한 모든 폼이 선택되어 있습니다.'||chr(10)||
'<br /><br />'||chr(10)||
'2. 모든 부적합한 SQL 질의 컴파일을 시도하는 대량 프로세스를 실행하려면 <b>부적합한 SQL 질의 컴파일 시도</b> 링크를 누르십시오.'||chr(10)||
'<br /><br />'||chr(10)||
'3. <b>이전 대상</b> 열에서 Microsoft Access 폼을 이전하고자 하는 Oracle Application Express 객체 유형을 선택하십시오.  '||chr(10)||
'<li>폼(기본 옵션)</li>'||chr(10)||
'<li>표 형식 폼</li>'||chr(10)||
'<li>보고서 및 폼</li>'||chr(10)||
'<br><br>'||chr(10)||
'이러한 옵션은 적';

h:=h||'합한 테이블 및 질의에 대해 나타납니다.'||chr(10)||
'<br><br>'||chr(10)||
'4. 선택 사항 또는 갱신 사항을 저장하려면 <b>변경 사항 적용</b>을 누르십시오. '||chr(10)||
'<p />'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197668022285155555 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P8_FORMS_HELP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p20_reports_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'맨 왼쪽 열을 사용하여 이전에 포함시키고자 하는 보고서를 선택하십시오.'||chr(10)||
'<br><br>'||chr(10)||
'보고서를 포함시키려면 해당 보고서 소스의 상태가 <b>적합</b>이어야 합니다. 기본적으로 적합한 소스 객체에 준한 모든 보고서가 선택되어 있습니다.'||chr(10)||
'<br><br>'||chr(10)||
'모든 부적합한 SQL 질의 컴파일을 시도하는 대량 프로세스를 실행하려면 <b>부적합한 SQL 질의 컴파일 시도</b> 링크를 누르십시오.'||chr(10)||
'<br><br>선택 사항 또는 갱신 사항을 저장하려면 <b>변경 사항 적용</b>을 누르십시오.';

wwv_flow_api.create_message (
  p_id=>197668111573155555 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P20_REPORTS_HELP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p49_defs_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새 애플리케이션을 생성할 때 이러한 기본값이 사용됩니다.';

wwv_flow_api.create_message (
  p_id=>197668230378155555 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P49_DEFS_HELP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_save_item_internal_only_show
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시 프로세싱 중 세션 상태에 %0 항목을 저장하려고 했습니다. 항목에 내부 전용 보호가 설정되어 있습니다.';

wwv_flow_api.create_message (
  p_id=>197668300262155555 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SAVE_ITEM_INTERNAL_ONLY_SHOW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_parser_line_exceeds_32k
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스크립트 행이 32767바이트를 초과했습니다.';

wwv_flow_api.create_message (
  p_id=>197668411242155556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_PARSER.LINE_EXCEEDS_32K',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_check_priv_obj
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 스키마에 테이블 또는 뷰 %1에 대한 선택 권한이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197668524745155556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CHECK_PRIV_OBJ',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_approved_account_req_display
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역에 대한 요청이 승인되고 증명서가 전자 메일을 통해 %0(으)로 전송됩니다.';

wwv_flow_api.create_message (
  p_id=>197668616665155556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.APPROVED_ACCOUNT_REQ_DISPLAY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message archivelog
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그 아카이브: 설정';

wwv_flow_api.create_message (
  p_id=>197668709853155556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ARCHIVELOG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message noarchivelog
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그 아카이브: 해제';

wwv_flow_api.create_message (
  p_id=>197668818411155556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOARCHIVELOG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_search
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검색';

wwv_flow_api.create_message (
  p_id=>197668903744155556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SEARCH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_show_chart_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'차트 표시 기준';

wwv_flow_api.create_message (
  p_id=>197669022424155557 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SHOW_CHART_BY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_choose_a_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열 선택';

wwv_flow_api.create_message (
  p_id=>197669120727155557 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CHOOSE_A_COLUMN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_analysis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 분석';

wwv_flow_api.create_message (
  p_id=>197669221303155557 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.ANALYSIS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 차트';

wwv_flow_api.create_message (
  p_id=>197669316039155557 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CHART',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'폼 삽입';

wwv_flow_api.create_message (
  p_id=>197669403416155557 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT FORM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새 %0 생성';

wwv_flow_api.create_message (
  p_id=>197669502653155557 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_NEW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_update_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'폼 갱신';

wwv_flow_api.create_message (
  p_id=>197669615878155558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.UPDATE_FORM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 갱신';

wwv_flow_api.create_message (
  p_id=>197669704092155558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.UPDATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 값을 입력해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197669807868155558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.NOT_NULL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_is_num
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0은(는) 숫자여야 합니다.';

wwv_flow_api.create_message (
  p_id=>197669929569155558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.IS_NUM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_success_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'성공 페이지';

wwv_flow_api.create_message (
  p_id=>197670011250155558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SUCCESS_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터가 성공적으로 삽입되었습니다.';

wwv_flow_api.create_message (
  p_id=>197670106218155558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT_SUCCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_another
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다른 항목 삽입';

wwv_flow_api.create_message (
  p_id=>197670205703155558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT_ANOTHER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_view_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 보기';

wwv_flow_api.create_message (
  p_id=>197670304343155559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.VIEW_REPORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_return_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'홈으로 돌아가기';

wwv_flow_api.create_message (
  p_id=>197670425984155559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.RETURN_HOME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'성공';

wwv_flow_api.create_message (
  p_id=>197670503493155559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SUCCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_help_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 페이지에는 페이지에 대한 도움말이 표시됩니다.';

wwv_flow_api.create_message (
  p_id=>197670617862155559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.HELP_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_return_prev_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이전 페이지로 돌아가기';

wwv_flow_api.create_message (
  p_id=>197670718739155559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.RETURN_PREV_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 연결 고리';

wwv_flow_api.create_message (
  p_id=>197670831726155559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.MENU',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 삽입';

wwv_flow_api.create_message (
  p_id=>197670922473155560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_report_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서를 표시할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197671008122155560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.REPORT_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_csv_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스프레드시트';

wwv_flow_api.create_message (
  p_id=>197671120452155560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CSV_LINK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_clear_cache_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'캐시를 비울 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197671202879155560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CLEAR_CACHE_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_reset_pagination_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 번호 매김을 재설정할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197671325743155560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.RESET_PAGINATION_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0에 행을 삽입할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197671432008155560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_analyze
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'분석';

wwv_flow_api.create_message (
  p_id=>197671531376155560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.ANALYZE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_report_and_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고 및 편집';

wwv_flow_api.create_message (
  p_id=>197671618053155561 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.REPORT_AND_EDIT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_new2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새로 만들기';

wwv_flow_api.create_message (
  p_id=>197671723473155561 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_NEW2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p22_no_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연관된 Microsoft Access 테이블이 Oracle로 이전되지 않았습니다. 자세한 내용은 Oracle Migration Workbench 로그 파일을 참조하십시오.';

wwv_flow_api.create_message (
  p_id=>197671806884155561 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P22_NO_TABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_p74_provision
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터 파일 %2을(를) 사용하고 기본 테이블스페이스 %1(으)로 할당된 데이터베이스 사용자 %0이(가) 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197671914960155561 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_P74_PROVISION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p42_validate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 질의 구문을 검증하려면 <b>검증</b>을 누르십시오. 표시된 구문은 Microsoft Access 데이터베이스에서 추출되었습니다.'||chr(10)||
'<br><br>'||chr(10)||
'질의가 적합한 Oracle 구문을 사용하는지 확인하십시오. <b>적합</b> 상태의 SQL 질의만 이전 프로세스에 포함될 수 있습니다. ';

wwv_flow_api.create_message (
  p_id=>197672014959155561 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P42_VALIDATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_show_menu_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리를 표시할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197672103519155561 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SHOW_MENU_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_display_region_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 영역을 표시할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197672223802155562 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.DISPLAY_REGION_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_ws_entire_response_doc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'전체 응답 문서';

wwv_flow_api.create_message (
  p_id=>197672314222155562 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_WS_ENTIRE_RESPONSE_DOC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_invalid_wsdl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제공된 URL이 적합한 WSDL 문서를 반환하지 않았습니다.';

wwv_flow_api.create_message (
  p_id=>197672429202155562 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.INVALID_WSDL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_min_len_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호는 %0자 이상이어야 합니다.';

wwv_flow_api.create_message (
  p_id=>197672514945155562 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_MIN_LEN_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_differs_by_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새 암호는 이전 암호와 %0자 이상 달라야 합니다.';

wwv_flow_api.create_message (
  p_id=>197672608159155562 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_DIFFERS_BY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_alpha_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호에는 하나 이상의 영문자(%0)가 포함되어야 합니다.';

wwv_flow_api.create_message (
  p_id=>197672718717155562 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_ALPHA_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_numeric_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호에는 하나 이상의 숫자(0123456789)가 포함되어야 합니다.';

wwv_flow_api.create_message (
  p_id=>197672827132155563 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_NUMERIC_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_punctuation_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호에는 하나 이상의 구두점 문자(%0)가 포함되어야 합니다.';

wwv_flow_api.create_message (
  p_id=>197672902510155563 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_PUNCTUATION_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_upper_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호에는 하나 이상의 대문자(영문자)가 포함되어야 합니다.';

wwv_flow_api.create_message (
  p_id=>197673010168155563 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_UPPER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_lower_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호에는 하나 이상의 소문자(영문자)가 포함되어야 합니다.';

wwv_flow_api.create_message (
  p_id=>197673118201155563 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_LOWER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_like_username_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호에는 사용자 이름이 포함되지 않아야 합니다.';

wwv_flow_api.create_message (
  p_id=>197673232119155563 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_LIKE_USERNAME_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_like_workspace_name_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호에는 작업 영역 이름이 포함되지 않아야 합니다.';

wwv_flow_api.create_message (
  p_id=>197673321901155563 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_LIKE_WORKSPACE_NAME_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_like_words_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호에 허용되지 않는 단순한 단어가 포함되어 있습니다.';

wwv_flow_api.create_message (
  p_id=>197673430505155564 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_LIKE_WORDS_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message exists_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'EXISTS SQL 질의';

wwv_flow_api.create_message (
  p_id=>197673528959155564 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EXISTS_SQL_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not_exists_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'NOT EXISTS SQL 질의';

wwv_flow_api.create_message (
  p_id=>197673614874155564 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT_EXISTS_SQL_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_in_exp1_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표현식 1에 있는 항목은 널임';

wwv_flow_api.create_message (
  p_id=>197673707275155564 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_IN_EXP1_NULL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_in_exp1_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표현식 1에 있는 항목은 널이 아님';

wwv_flow_api.create_message (
  p_id=>197673806785155564 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_IN_EXP1_NOT_NULL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message func_ret_boolean
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부울 반환 PL/SQL 함수';

wwv_flow_api.create_message (
  p_id=>197673926255155564 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNC_RET_BOOLEAN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pref_eq_exp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표현식에 있는 기호사항의 값';

wwv_flow_api.create_message (
  p_id=>197674017814155565 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREF_EQ_EXP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pref_ne_exp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표현식 1에 있는 기호사항의 값은 표현식 2와 같지 않음';

wwv_flow_api.create_message (
  p_id=>197674115805155565 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREF_NE_EXP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_exp1_eq_exp2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표현식 1의 항목 값은 표현식 2와 같음';

wwv_flow_api.create_message (
  p_id=>197674213091155565 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_EXP1_EQ_EXP2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_exp1_ne_exp2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표현식 1의 항목 값은 표현식 2와 같지 않음';

wwv_flow_api.create_message (
  p_id=>197674327616155565 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_EXP1_NE_EXP2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authz_cache_per_page_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 보기마다 평가';

wwv_flow_api.create_message (
  p_id=>197674416831155565 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authz_cache_per_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세션당 한 번 평가';

wwv_flow_api.create_message (
  p_id=>197674522488155565 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHZ_CACHE_PER_SESSION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_complexity_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호가 이 사이트의 암호 복잡성 규칙을 준수하지 않습니다.';

wwv_flow_api.create_message (
  p_id=>197674620279155566 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_COMPLEXITY_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_export
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'익스포트';

wwv_flow_api.create_message (
  p_id=>197674731043155566 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.EXPORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_app_export_curr_ws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션은 현재 작업 영역에서 익스포트되었습니다.';

wwv_flow_api.create_message (
  p_id=>197674823257155566 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.APP_EXPORT_CURR_WS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_app_export_non_curr_ws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션은 다른 작업 영역에서 익스포트되었습니다.';

wwv_flow_api.create_message (
  p_id=>197674926062155566 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.APP_EXPORT_NON_CURR_WS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_ws_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역이 존재하므로 생성되지 않습니다.';

wwv_flow_api.create_message (
  p_id=>197675022931155566 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WS_EXISTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_ws_tobe_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역이 생성됩니다.';

wwv_flow_api.create_message (
  p_id=>197675120091155566 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WS_TOBE_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message back
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'뒤로';

wwv_flow_api.create_message (
  p_id=>197675227685155566 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BACK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message today
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오늘';

wwv_flow_api.create_message (
  p_id=>197675330826155567 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TODAY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message forward
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'앞으로';

wwv_flow_api.create_message (
  p_id=>197675411748155567 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FORWARD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_auth_scheme_desc_dad
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 인증 사용(DAD로 식별된 사용자).';

wwv_flow_api.create_message (
  p_id=>197675502044155567 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.AUTH_SCHEME_DESC_DAD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_auth_scheme_desc_internal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션에 내부 %0 계정 증명서 및 로그인 페이지를 사용하십시오.';

wwv_flow_api.create_message (
  p_id=>197675626284155567 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.AUTH_SCHEME_DESC_INTERNAL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_sample_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'샘플 애플리케이션';

wwv_flow_api.create_message (
  p_id=>197675709838155567 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO.SAMPLE.APP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_sample_app_descr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'공통 디자인 개념을 강조하는 샘플 애플리케이션입니다.';

wwv_flow_api.create_message (
  p_id=>197675807457155567 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO.SAMPLE.APP.DESCR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_collect_descr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'쇼핑 카트 개념을 익히십시오.';

wwv_flow_api.create_message (
  p_id=>197675928995155568 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO.COLLECT.DESCR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message bytes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'바이트';

wwv_flow_api.create_message (
  p_id=>197676026188155568 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BYTES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message rows_returned_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'행 반환 위치';

wwv_flow_api.create_message (
  p_id=>197676104108155568 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ROWS_RETURNED_IN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message invalid_object
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 객체가 부적합합니다.';

wwv_flow_api.create_message (
  p_id=>197676228209155568 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INVALID_OBJECT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message query_builder
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Query Builder';

wwv_flow_api.create_message (
  p_id=>197676304213155568 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUERY BUILDER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'값 목록 없음';

wwv_flow_api.create_message (
  p_id=>197676408448155568 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_LOV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단축키 없음';

wwv_flow_api.create_message (
  p_id=>197676504514155569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_SHORTCUT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_authorization_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 체계 없음';

wwv_flow_api.create_message (
  p_id=>197676609947155569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_AUTHORIZATION_SCHEME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_reset_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자가 사전 설정된 값 없이 애플리케이션을 실행하고자 하는 경우 세션 상태를 재설정합니다.';

wwv_flow_api.create_message (
  p_id=>197676710043155569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350_RESET_SESSION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_cancel_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'취소 단추 표시 텍스트';

wwv_flow_api.create_message (
  p_id=>197676807284155569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.CANCEL_BUTTON_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_finish_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'완료 단추 표시 텍스트';

wwv_flow_api.create_message (
  p_id=>197676900442155569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.FINISH_BUTTON_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_previous_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이전 단추 표시 텍스트';

wwv_flow_api.create_message (
  p_id=>197677010479155569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.PREVIOUS_BUTTON_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_next_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 단추 표시 텍스트';

wwv_flow_api.create_message (
  p_id=>197677109437155569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.NEXT_BUTTON_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_cancel_button_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'취소 단추 분기';

wwv_flow_api.create_message (
  p_id=>197677221960155570 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.CANCEL_BUTTON_BRANCH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_finish_button_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'완료 단추 분기';

wwv_flow_api.create_message (
  p_id=>197677305698155570 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.FINISH_BUTTON_BRANCH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message form_of
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0/%1';

wwv_flow_api.create_message (
  p_id=>197677428595155570 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FORM_OF',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML 단추';

wwv_flow_api.create_message (
  p_id=>197677517821155570 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_BUTTON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message one
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'1';

wwv_flow_api.create_message (
  p_id=>197677618340155570 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ONE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message my_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내 페이지';

wwv_flow_api.create_message (
  p_id=>197677719720155570 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MY_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message copyright
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copyright &copy; %0, All rights reserved.';

wwv_flow_api.create_message (
  p_id=>197677831120155571 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COPYRIGHT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message regions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역';

wwv_flow_api.create_message (
  p_id=>197677923382155571 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGIONS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message processes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로세스';

wwv_flow_api.create_message (
  p_id=>197678031358155571 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROCESSES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message computations
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'계산';

wwv_flow_api.create_message (
  p_id=>197678129561155571 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COMPUTATIONS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message validations
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증';

wwv_flow_api.create_message (
  p_id=>197678210749155571 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VALIDATIONS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message branches
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'분기';

wwv_flow_api.create_message (
  p_id=>197678331573155571 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BRANCHES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목';

wwv_flow_api.create_message (
  p_id=>197678402856155572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEMS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message buttons
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추';

wwv_flow_api.create_message (
  p_id=>197678510651155572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUTTONS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_x_y_of_z_2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0-%1/%2';

wwv_flow_api.create_message (
  p_id=>197678612204155572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.X_Y_OF_Z_2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_p74_provision1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%1 관리자로 등록된 %0 작업 영역입니다.';

wwv_flow_api.create_message (
  p_id=>197678703448155572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_P74_PROVISION1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_unretrievable
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제공한 URL이 부적합하거나 사용자 환경에 HTTP 요청에 적합한 프록시 서버 주소가 필요하지만 이 애플리케이션에 대한 프록시 서버 주소가 정의되지 않았거나, HTTPS 요청에 대해 이 &PRODUCT_NAME. 인스턴스용 전자 지갑이 구성되지 않아 WSDL 문서를 검색할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197678821405155572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_UNRETRIEVABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_no_soap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'WSDL 문서에 참조를 추가하는 데 필요한 SOAP 바인딩이 포함되지 않았습니다.';

wwv_flow_api.create_message (
  p_id=>197678931815155572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_NO_SOAP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message drillup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'드릴 업';

wwv_flow_api.create_message (
  p_id=>197679015092155572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRILLUP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message drilldown
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'드릴 다운';

wwv_flow_api.create_message (
  p_id=>197679130853155573 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRILLDOWN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'편집';

wwv_flow_api.create_message (
  p_id=>197679208717155573 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message generated_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 테이블은 테이블 마법사를 사용하여 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197679329356155573 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'GENERATED_TABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message series
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 시리즈';

wwv_flow_api.create_message (
  p_id=>197679404223155573 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERIES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_unable_to_fetch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'행을 인출할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197679526573155573 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.UNABLE_TO_FETCH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_unable_to_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 테이블의 행을 처리할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197679610790155573 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.UNABLE_TO_PROCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_action_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업이 처리되었습니다.';

wwv_flow_api.create_message (
  p_id=>197679711009155574 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.ACTION_PROCESSED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message to_many_columns_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'최대 %0개의 열을 선택할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197679817461155574 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TO_MANY_COLUMNS_SELECTED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4550_javascript_enabled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션을 사용하려면 JavaScript가 사용으로 설정되어 있어야 합니다.';

wwv_flow_api.create_message (
  p_id=>197679926114155574 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4550_JAVASCRIPT_ENABLED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4550_cookies_enabled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션을 사용하려면 쿠키가 사용으로 설정되어 있어야 합니다.';

wwv_flow_api.create_message (
  p_id=>197680007333155574 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4550_COOKIES_ENABLED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_unauthorized
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증되지 않은 액세스입니다.';

wwv_flow_api.create_message (
  p_id=>197680125226155574 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.UNAUTHORIZED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_no_datatype
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0에 대해 지정된 데이터 유형이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197680210344155574 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P602_NO_DATATYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_multiple_soap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'WSDL 문서에 여러 SOAP 바인딩이 포함되어 있습니다. &PRODUCT_NAME.에서는 SOAP 바인딩이 하나인 WSDL만 지원합니다. 이 서비스에 대한 참조 생성을 계속하려면 <b>수동으로 웹 서비스 참조 생성</b>을 누르십시오.';

wwv_flow_api.create_message (
  p_id=>197680318773155575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.MULTIPLE_SOAP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_html_email_click_on_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'승인 프로세스를 완료하고 증명서를 받으려면 <a href=''%0''>여기</a>를 누르십시오.';

wwv_flow_api.create_message (
  p_id=>197680404381155575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.HTML_EMAIL_CLICK_ON_LINK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p1023_parsing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스크립트 구문 분석 중 - 기다리십시오.';

wwv_flow_api.create_message (
  p_id=>197680501230155575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P1023_PARSING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_line_number
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'행 번호';

wwv_flow_api.create_message (
  p_id=>197680615681155575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.LINE_NUMBER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_invalid_stmt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'알 수 없는 명령문이 포함된 스크립트를 실행하도록 요청했습니다. 다음 명령문을 제거하십시오.';

wwv_flow_api.create_message (
  p_id=>197680711475155575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.INVALID_STMT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f400_p107_step
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 단계';

wwv_flow_api.create_message (
  p_id=>197680811783155575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F400_P107_STEP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4719_yn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'예/아니오 표시, Y 및 N 반환';

wwv_flow_api.create_message (
  p_id=>197680907703155575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4719.YN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_array
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 결과 트리';

wwv_flow_api.create_message (
  p_id=>197681011370155576 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ARRAY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_array_parms
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 결과 매개변수';

wwv_flow_api.create_message (
  p_id=>197681129441155576 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ARRAY_PARMS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_collection
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'임시 결과 집합 이름';

wwv_flow_api.create_message (
  p_id=>197681215115155576 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COLLECTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_input_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'폼 영역 제목';

wwv_flow_api.create_message (
  p_id=>197681319754155576 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INPUT_REGION_TITLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_input_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'폼 영역 템플리트';

wwv_flow_api.create_message (
  p_id=>197681407420155576 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INPUT_REGION_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 영역 제목';

wwv_flow_api.create_message (
  p_id=>197681503511155576 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_REGION_TITLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 영역 템플리트';

wwv_flow_api.create_message (
  p_id=>197681602446155577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_REGION_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_dml_insert_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'삽입 작업을 수행할 수 없습니다.  %0  %1';

wwv_flow_api.create_message (
  p_id=>197681704168155577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.DML_INSERT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name15
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본값: 모양 5';

wwv_flow_api.create_message (
  p_id=>197681827564155577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME15',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_display_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- 표시 없음 -';

wwv_flow_api.create_message (
  p_id=>197681901850155577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_DISPLAY_VALUE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message xml_load_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'XML 로드 오류입니다.';

wwv_flow_api.create_message (
  p_id=>197682024444155577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'XML_LOAD_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message shared_component
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'공유 구성 요소';

wwv_flow_api.create_message (
  p_id=>197682102405155577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SHARED_COMPONENT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4731_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'삭제';

wwv_flow_api.create_message (
  p_id=>197682204914155578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4731.DELETE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message unexpired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'만기되지 않음';

wwv_flow_api.create_message (
  p_id=>197682302205155578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UNEXPIRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML 차트';

wwv_flow_api.create_message (
  p_id=>197682420567155578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_CHART',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_slash_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML/텍스트';

wwv_flow_api.create_message (
  p_id=>197682505543155578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_SLASH_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_text_with_shortcuts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML 텍스트(단축키 사용)';

wwv_flow_api.create_message (
  p_id=>197682620730155578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_TEXT_WITH_SHORTCUTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_save_ddl_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DDL을 스크립트 파일로 저장할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197682722874155578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.SAVE_DDL_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목 이름';

wwv_flow_api.create_message (
  p_id=>197682812417155578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message display_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시 유형';

wwv_flow_api.create_message (
  p_id=>197682921538155579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DISPLAY_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_data_quick_flow_analyze_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 분석';

wwv_flow_api.create_message (
  p_id=>197683021007155579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DATA_QUICK_FLOW.ANALYZE_COLUMN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_data_quick_flow_view_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보기 기준';

wwv_flow_api.create_message (
  p_id=>197683105164155579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DATA_QUICK_FLOW.VIEW_BY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_analyze_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'분석 페이지를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197683203782155579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_ANALYZE_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message icon
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 아이콘';

wwv_flow_api.create_message (
  p_id=>197683330675155579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ICON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message check
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'행 선택기';

wwv_flow_api.create_message (
  p_id=>197683429764155579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHECK$',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열 링크';

wwv_flow_api.create_message (
  p_id=>197683503375155580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LINK$',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message derived
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'파생된 열';

wwv_flow_api.create_message (
  p_id=>197683624621155580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DERIVED$',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_layout_about
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정보';

wwv_flow_api.create_message (
  p_id=>197683700218155580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_LAYOUT.ABOUT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_layout_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'분기';

wwv_flow_api.create_message (
  p_id=>197683826532155580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_LAYOUT.BRANCHING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4731_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'행 추가';

wwv_flow_api.create_message (
  p_id=>197683909531155580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4731.ADD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'편집';

wwv_flow_api.create_message (
  p_id=>197684018944155580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.EDIT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_page_must_be_numeric
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지는 숫자여야 합니다.';

wwv_flow_api.create_message (
  p_id=>197684114588155580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P295_PAGE_MUST_BE_NUMERIC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_page_must_be_positive
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지는 양수여야 합니다.';

wwv_flow_api.create_message (
  p_id=>197684215388155581 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P295_PAGE_MUST_BE_POSITIVE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_page_must_be_whole_number
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지는 정수여야 합니다.';

wwv_flow_api.create_message (
  p_id=>197684301661155581 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P295_PAGE_MUST_BE_WHOLE_NUMBER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_not_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 콜렉션 %0이(가) 존재하지 않음';

wwv_flow_api.create_message (
  p_id=>197684413849155581 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_NOT_EXIST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_member_not_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 콜렉션 %1에 멤버 시퀀스 %0이(가) 존재하지 않음'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197684503929155581 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.MEMBER_NOT_EXIST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_attribute_number_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'지정된 멤버 속성 번호 %0은(는) 부적합합니다.';

wwv_flow_api.create_message (
  p_id=>197684610087155581 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.ATTRIBUTE_NUMBER_INVALID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_attribute_number_outside_range
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'지정된 멤버 속성 번호 %0은(는) 부적합합니다. 속성 번호는 1과 %1 사이여야 합니다.';

wwv_flow_api.create_message (
  p_id=>197684701624155581 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.ATTRIBUTE_NUMBER_OUTSIDE_RANGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_member_sequence_number_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 콜렉션 "%1"에 멤버 시퀀스 %0이(가) 존재하지 않습니다.';

wwv_flow_api.create_message (
  p_id=>197684807535155582 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.MEMBER_SEQUENCE_NUMBER_INVALID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_array_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 콜렉션 배열은 널이면 안됩니다.';

wwv_flow_api.create_message (
  p_id=>197684912138155582 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.ARRAY_NOT_NULL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_name_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'콜렉션 이름은 널일 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197685003899155582 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_NAME_NOT_NULL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_name_too_large
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'콜렉션 이름은 255자를 초과할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197685110363155582 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_NAME_TOO_LARGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 콜렉션이 존재함';

wwv_flow_api.create_message (
  p_id=>197685213538155582 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_EXISTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_cursor_not_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'커서가 아직 열려 있지 않습니다.';

wwv_flow_api.create_message (
  p_id=>197685328478155582 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.CURSOR_NOT_OPEN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_seed_translations_translation_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%1 애플리케이션의 %0 번역을 찾을 수 없음';

wwv_flow_api.create_message (
  p_id=>197685409138155583 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SEED_TRANSLATIONS.TRANSLATION_NOT_FOUND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_seed_translations_seed_insert_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시드 삽입 오류: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>197685532579155583 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SEED_TRANSLATIONS.SEED_INSERT_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_seed_translations_seed_delete_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시드 삭제 오류: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>197685626691155583 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SEED_TRANSLATIONS.SEED_DELETE_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_translations_seed_update_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시드 갱신 오류: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>197685728917155583 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TRANSLATIONS.SEED_UPDATE_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sync_translations_sync_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'동기화 오류: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>197685805627155583 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SYNC_TRANSLATIONS.SYNC_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message trigger_sgid_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보안 그룹 ID 20은 ''ORACLE'' 작업 영역용으로 예약되어 있음';

wwv_flow_api.create_message (
  p_id=>197685925939155583 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TRIGGER.SGID_RESERVED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message trigger_button_tab_names_not_equal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추 이름은 기존 탭과 동일한 이름이면 안됩니다.';

wwv_flow_api.create_message (
  p_id=>197686020392155584 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TRIGGER.BUTTON_TAB_NAMES_NOT_EQUAL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_error_writing_to_directory
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'물리적 파일 디렉토리 "%0"에 쓰는 중 오류가 발생했습니다. (%1: %2)';

wwv_flow_api.create_message (
  p_id=>197686104989155584 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.ERROR_WRITING_TO_DIRECTORY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_no_file_to_write
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ID %0에 대해 쓸 파일이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197686214145155584 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.NO_FILE_TO_WRITE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_error_removing_file
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 파일 제거를 시도하는 중 서버에 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197686319569155584 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.ERROR_REMOVING_FILE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_error_removing_file2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 파일을 제거할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197686402798155584 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.ERROR_REMOVING_FILE2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_version_of_data_changed_with_checksum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자가 갱신 프로세스를 시작했으므로 데이터베이스에 있는 데이터의 현재 버전이 변경되었습니다. 현재 체크섬 = "%0" 애플리케이션 체크섬 = "%1"'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197686503724155584 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.VERSION_OF_DATA_CHANGED_WITH_CHECKSUM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_version_of_data_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자가 갱신 프로세스를 시작했으므로 데이터베이스에 있는 데이터의 현재 버전이 변경되었습니다.';

wwv_flow_api.create_message (
  p_id=>197686603035155585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.VERSION_OF_DATA_CHANGED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_invalid_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 객체에 부적합한 작업 %0이(가) 있습니다. (%1)';

wwv_flow_api.create_message (
  p_id=>197686707588155585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.INVALID_ACTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'복사할 템플리트(%0)를 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197686812175155585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.TEMPLATE_NOT_FOUND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_field_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%1" 애플리케이션의 "%2" 작업 영역에서 복사할 필드 템플리트(%0)를 찾을 수 없음';

wwv_flow_api.create_message (
  p_id=>197686921982155585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.FIELD_TEMPLATE_NOT_FOUND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_check_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증되지 않은 액세스입니다.';

wwv_flow_api.create_message (
  p_id=>197687007862155585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CHECK_USER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_menu_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%1" 애플리케이션의 "%2" 작업 영역에서 복사할 연결 고리 템플리트(%0)를 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197687126252155585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.MENU_TEMPLATE_NOT_FOUND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_button_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%1" 애플리케이션의 "%2" 작업 영역에서 복사할 단추 템플리트(%0)를 찾을 수 없음';

wwv_flow_api.create_message (
  p_id=>197687213478155585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.BUTTON_TEMPLATE_NOT_FOUND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 템플리트를 바꿀 수 없습니다. %1';

wwv_flow_api.create_message (
  p_id=>197687308112155586 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.TEMPLATE_REPLACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_page_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 템플리트를 바꿀 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197687408448155586 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.PAGE_TEMPLATE_REPLACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_region_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 템플리트를 바꿀 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197687520481155586 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.REGION_TEMPLATE_REPLACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_report_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 템플리트를 바꿀 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197687602367155586 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.REPORT_TEMPLATE_REPLACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_list_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록 템플리트를 바꿀 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197687710877155586 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.LIST_TEMPLATE_REPLACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_field_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'필드 템플리트를 바꿀 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197687808727155587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.FIELD_TEMPLATE_REPLACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_menu_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리 템플리트를 바꿀 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197687906640155587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.MENU_TEMPLATE_REPLACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_popup_lov_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'팝업 값 목록 템플리트를 바꿀 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197688016613155587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.POPUP_LOV_TEMPLATE_REPLACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_button_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추 템플리트를 바꿀 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197688107672155587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.BUTTON_TEMPLATE_REPLACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p122_cal_templ
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트를 참조하는 달력 템플리트';

wwv_flow_api.create_message (
  p_id=>197688227569155587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P122_CAL_TEMPL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_page_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 참조 ID를 제거할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197688306258155587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_PAGE_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_region_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 참조 ID를 제거할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197688400614155587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_REGION_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_list_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록 참조 ID를 제거할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197688509034155588 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_LIST_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_report_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 참조 ID를 제거할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197688620044155588 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_REPORT_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_field_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'필드 참조 ID를 제거할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197688728205155588 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_FIELD_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_security_scheme_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보안 체계 참조 ID를 제거할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197688809449155588 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_SECURITY_SCHEME_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_shortcut_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단축키 참조 ID를 제거할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197688904238155588 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_SHORTCUT_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_navbar_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탐색 도구 모음 참조 ID를 제거할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197689027096155588 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_NAVBAR_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_lov_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'값 목록 참조 ID를 제거할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197689132752155589 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_LOV_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_popup_lov_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'팝업 값 목록 템플리트 참조 ID를 제거할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197689210035155589 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_POPUP_LOV_TEMPLATE_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_menu_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리 템플리트 참조 ID를 제거할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197689317289155589 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_MENU_TEMPLATE_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_button_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추 템플리트 참조 ID를 제거할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197689416035155589 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_BUTTON_TEMPLATE_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_ws_rpt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 폼을 생성하고 웹 서비스 참조 페이지에 대해 보고하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197689523946155589 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_auth_setup_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 체계 참조 ID를 제거할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197689627958155589 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_AUTH_SETUP_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_item_help_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목 도움말 참조 ID를 제거할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197689701966155589 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_ITEM_HELP_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 템플리트에 적용할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197689804742155590 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_PAGE_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 템플리트에 적용할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197689907147155590 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_REGION_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록 템플리트에 적용할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197690028635155590 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_LIST_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 템플리트에 적용할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197690109042155590 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_REPORT_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_field_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'필드 템플리트에 적용할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197690230286155590 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_FIELD_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_popup_lov_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'팝업 값 목록 템플리트에 적용할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197690323678155590 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_POPUP_LOV_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리 템플리트에 적용할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197690419217155591 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_MENU_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_button_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추 템플리트에 적용할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197690526668155591 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_BUTTON_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_security_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보안 체계에 적용할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197690630573155591 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_SECURITY_SCHEME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단축키에 적용할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197690732198155591 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_SHORTCUT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_navbar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탐색 도구 모음에 적용할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197690822038155591 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_NAVBAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'값 목록에 적용할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197690925360155591 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_LOV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_auth_setup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 체계에 적용할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197691018914155592 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_AUTH_SETUP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_item_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목 도움말에 적용할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197691112599155592 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_ITEM_HELP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 템플리트를 게시할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197691212805155592 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_PAGE_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 템플리트를 게시할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197691301772155592 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_REGION_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록 템플리트를 게시할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197691430309155592 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_LIST_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 템플리트를 게시할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197691529271155592 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_REPORT_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_field_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'필드 템플리트를 게시할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197691631393155593 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_FIELD_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_popup_lov_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'팝업 값 목록 템플리트를 게시할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197691728419155593 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_POPUP_LOV_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_button_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추 템플리트를 게시할 수 없습니다. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197691822744155593 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_BUTTON_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리 템플리트를 게시할 수 없습니다. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197691906933155593 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_MENU_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_security_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보안 체계를 게시할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197692001377155593 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_SECURITY_SCHEME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단축키를 게시할 수 없습니다. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197692105225155593 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_SHORTCUT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_navbar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탐색 도구 모음을 게시할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197692231466155594 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_NAVBAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'값 목록을 게시할 수 없습니다. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197692304457155594 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_LOV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_auth_setup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 체계를 게시할 수 없습니다. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197692423227155594 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_AUTH_SETUP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_item_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목 도움말을 게시할 수 없습니다. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197692504800155594 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_ITEM_HELP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_user_no_privileges
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 사용자에게 %1 스키마에 대한 권한이 없습니다.'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197692605901155594 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.USER_NO_PRIVILEGES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_no_company
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 작업 영역 ID를 사용하는 작업 영역을 찾을 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197692718990155594 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.NO_COMPANY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_no_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 작업 영역 ID에 대해 지정된 스키마 없음: %0';

wwv_flow_api.create_message (
  p_id=>197692821941155595 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.NO_SCHEMA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_auto_provision_failure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"MAKE_REQUEST" 단계를 수행하는 중 자동 등록을 실패했습니다.';

wwv_flow_api.create_message (
  p_id=>197692922577155595 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.AUTO_PROVISION_FAILURE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_company_user_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 작업 영역에 사용자를 추가하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197693020379155595 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.COMPANY_USER_ADD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_request_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 요청이 처리되었거나 처리 중입니다. 상태는 "%0"이어야 합니다.';

wwv_flow_api.create_message (
  p_id=>197693107484155595 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REQUEST_PROCESSED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_company_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 작업 영역은 예약된 이름이므로 요청이 거부됨';

wwv_flow_api.create_message (
  p_id=>197693205546155595 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.COMPANY_RESERVED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_schema_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스키마 이름 %0은(는) 예약된 스키마이므로 등록할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197693323725155595 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.SCHEMA_RESERVED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_request_not_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 요청을 처리할 수 없습니다.  %1';

wwv_flow_api.create_message (
  p_id=>197693426180155596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REQUEST_NOT_PROCESSED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_schema_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%1 스키마가 %2 테이블에 존재하므로 %0 요청을 처리할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197693509930155596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.SCHEMA_EXISTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_request_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 요청을 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197693611866155596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REQUEST_NOT_FOUND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_generate_ddl_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rem %0에 대해 DDL을 생성할 수 없습니다. %1';

wwv_flow_api.create_message (
  p_id=>197693715461155596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.GENERATE_DDL_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_save_ddl_parse_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DDL 스크립트의 구문을 분석하는 중 오류가 발생했습니다. %0';

wwv_flow_api.create_message (
  p_id=>197693832699155596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.SAVE_DDL_PARSE_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_save_ddl_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Save_ddl 오류 %0';

wwv_flow_api.create_message (
  p_id=>197693912802155596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.SAVE_DDL ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_install_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 객체 설치 속성 ID="%0"을(를) 임포트할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197694016950155597 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_INSTALL_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_install_script_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설치 스크립트 ID "%0"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197694120872155597 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_INSTALL_SCRIPT_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_next_prev_pk_process_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 또는 이전 기본 키 값 가져오기 프로세스를 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197694216289155597 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.NEXT_PREV_PK_PROCESS_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_create_table_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'액세스 제어 테이블을 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197694326854155597 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_create_page_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'액세스 제어 페이지를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197694429418155597 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message out_of_range
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 행 집합이 요청되었습니다. 보고서의 소스 데이터가 수정되었습니다.';

wwv_flow_api.create_message (
  p_id=>197694510556155597 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OUT_OF_RANGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 번호 매김 재설정';

wwv_flow_api.create_message (
  p_id=>197694618609155597 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RESET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_welcome_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 설치 프로그램은 데이터베이스 객체 및 시드 데이터의 생성 프로세스를 안내합니다.';

wwv_flow_api.create_message (
  p_id=>197694717762155598 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.WELCOME_MESSAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_configuration_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션의 다음 속성을 구성할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197694821546155598 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIGURATION_MESSAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_build_options_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 빌드 옵션을 포함하도록 선택할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197694928639155598 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.BUILD_OPTIONS_MESSAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_validation_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시스템이 이 애플리케이션과 호환되는지 확인하기 위해 다음 검증이 수행됩니다.';

wwv_flow_api.create_message (
  p_id=>197695027950155598 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.VALIDATION_MESSAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_confirmation_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션의 지원 객체를 설치할 것인지 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197695132691155598 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIRMATION_MESSAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_success_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션의 지원 객체가 설치되었습니다.';

wwv_flow_api.create_message (
  p_id=>197695219649155598 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SUCCESS_MESSAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_failure_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 객체 및 시드 데이터의 설치를 실패했습니다.';

wwv_flow_api.create_message (
  p_id=>197695312415155599 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.FAILURE_MESSAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_deinstall_success_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설치 해제가 완료되었습니다.';

wwv_flow_api.create_message (
  p_id=>197695407050155599 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.DEINSTALL_SUCCESS_MESSAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'메소드';

wwv_flow_api.create_message (
  p_id=>197695530199155599 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_METHOD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세부 정보';

wwv_flow_api.create_message (
  p_id=>197695604568155599 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_bi1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내부 "쿠키 사용자" 계정 저장소에 대한 내장 세션 관리 논리, 내장 로그인 페이지 및 사용자 인증입니다.'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197695700920155599 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_BI1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_bi2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내장 세션 관리 논리입니다. 사용자 인증은 modplsql DAD 구성을 통해 이뤄집니다.'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197695821335155599 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_BI2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_obs1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 방식은 "체계" 인증으로 교체되었습니다.';

wwv_flow_api.create_message (
  p_id=>197695918709155600 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_OBS1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_obs2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용되지 않는 방식입니다.';

wwv_flow_api.create_message (
  p_id=>197696010372155600 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_OBS2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_public_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'공용 페이지';

wwv_flow_api.create_message (
  p_id=>197696102317155600 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PUBLIC_PAGES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업';

wwv_flow_api.create_message (
  p_id=>197696211891155600 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_ACTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검토 또는 편집';

wwv_flow_api.create_message (
  p_id=>197696310960155600 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'속성';

wwv_flow_api.create_message (
  p_id=>197696406548155600 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지에서 이 플로우의';

wwv_flow_api.create_message (
  p_id=>197696518793155601 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW3',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 속성 페이지의 이 애플리케이션 또는 위 보고서를 사용하여 인증 방식을 %0(으)로 변경할 때 사용할 수 있는 인증 체계를 생성 및 관리하십시오.';

wwv_flow_api.create_message (
  p_id=>197696619056155601 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW4',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_paren_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(없음)';

wwv_flow_api.create_message (
  p_id=>197696706439155601 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PAREN_NONE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_manage
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'위 보고서를 사용하여 인증 체계를 관리하십시오.';

wwv_flow_api.create_message (
  p_id=>197696817305155601 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_MANAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_deactivate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'비활성 상태로 변경';

wwv_flow_api.create_message (
  p_id=>197696923126155601 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DEACTIVATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_paren_current
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(현재)';

wwv_flow_api.create_message (
  p_id=>197697007746155601 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PAREN_CURRENT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_activate1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 체계를 현재로 설정';

wwv_flow_api.create_message (
  p_id=>197697100751155601 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_ACTIVATE1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_activate2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'현재로 설정';

wwv_flow_api.create_message (
  p_id=>197697230518155602 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_ACTIVATE2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_copy_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션에서 복사됨';

wwv_flow_api.create_message (
  p_id=>197697325182155602 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_COPY_FROM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 인증 체계의 "마스터" 복사본입니다.';

wwv_flow_api.create_message (
  p_id=>197697402092155602 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_MASTER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_subscribers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 인증 체계를 참조하는 체계';

wwv_flow_api.create_message (
  p_id=>197697504532155602 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_SUBSCRIBERS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_no_subscribers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 인증 체계에 대한 가입자가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197697618857155602 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_NO_SUBSCRIBERS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_paren_builtin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(내장)';

wwv_flow_api.create_message (
  p_id=>197697722497155602 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PAREN_BUILTIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이름';

wwv_flow_api.create_message (
  p_id=>197697808172155603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_pg_sentry
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 감시 함수';

wwv_flow_api.create_message (
  p_id=>197697905324155603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PG_SENTRY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_sess_verify
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세션 확인 함수';

wwv_flow_api.create_message (
  p_id=>197698018842155603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_SESS_VERIFY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_inv_sess_tgt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 세션 대상';

wwv_flow_api.create_message (
  p_id=>197698105976155603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_INV_SESS_TGT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_pre_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사전 인증 프로세스';

wwv_flow_api.create_message (
  p_id=>197698206438155603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PRE_AUTH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 함수'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197698318877155603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_AUTH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_host
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 호스트';

wwv_flow_api.create_message (
  p_id=>197698400548155603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_HOST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_port
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 포트';

wwv_flow_api.create_message (
  p_id=>197698511465155604 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_PORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_dn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 검색 기준';

wwv_flow_api.create_message (
  p_id=>197698616910155604 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_DN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 사용자 이름 편집';

wwv_flow_api.create_message (
  p_id=>197698732210155604 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_EDIT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_post_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사후 인증 프로세스';

wwv_flow_api.create_message (
  p_id=>197698830754155604 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_POST_AUTH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_c_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'쿠키 이름';

wwv_flow_api.create_message (
  p_id=>197698927786155604 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_C_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_c_path
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'쿠키 경로';

wwv_flow_api.create_message (
  p_id=>197699027226155604 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_C_PATH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_c_domain
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'쿠키 도메인';

wwv_flow_api.create_message (
  p_id=>197699117656155605 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_C_DOMAIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_logout_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그아웃 URL';

wwv_flow_api.create_message (
  p_id=>197699203515155605 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LOGOUT_URL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_paren_dbauth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(데이터베이스 인증)';

wwv_flow_api.create_message (
  p_id=>197699314137155605 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PAREN_DBAUTH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_flow_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 ID';

wwv_flow_api.create_message (
  p_id=>197699415975155605 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_FLOW_ID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_auth_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 방식';

wwv_flow_api.create_message (
  p_id=>197699516862155605 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_AUTH_METHOD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_scheme_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'체계 이름';

wwv_flow_api.create_message (
  p_id=>197699630768155605 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_SCHEME_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설명';

wwv_flow_api.create_message (
  p_id=>197699701276155606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_DESCRIPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p822_curr_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'현재 인증 방식';

wwv_flow_api.create_message (
  p_id=>197699825258155606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P822_CURR_METHOD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록 템플리트를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197699915181155606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LIST_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_flow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션을 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197700013285155606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_FLOW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 템플리트를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197700105110155606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_PAGE_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_label_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'레이블 템플리트를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197700223386155606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LABEL_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 템플리트를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197700331429155606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_REPORT_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 템플리트를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197700408878155607 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_REGION_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리 템플리트를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197700522026155607 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_MENU_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_button_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추 템플리트를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197700603163155607 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_BUTTON_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_popup_lov_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'팝업 값 목록 템플리트를 작성할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197700712377155607 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.POPUP_LOV_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표준 탭을 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197700816477155607 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_TAB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_navbar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탐색 도구 모음을 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197700931187155607 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_NAVBAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리를 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197701023918155608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_MENU',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 페이지를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197701122476155608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_REPORT_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_insert_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'삽입 폼을 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197701206537155608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_INSERT_FORM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_update_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'갱신 폼을 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197701310980155608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_UPDATE_FORM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_chart_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'차트 페이지를 작성할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197701420120155608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_CHART_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_user_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 사용자 이름을 편집하기 위해 설정하는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197701523277155608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_USER_EDIT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_user_fn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 사용자 함수 편집을 실행할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197701628832155609 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_USER_FN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SYS.DBMS_LDAP 패키지가 존재하지 않거나 부적합합니다.';

wwv_flow_api.create_message (
  p_id=>197701725917155609 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_MISSING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_fix
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DBA에게 $OH/rdbms/admin/catldap.sql 실행을 요청하십시오.';

wwv_flow_api.create_message (
  p_id=>197701802256155609 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_FIX',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_ldap_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_custom_auth_ldap.authenticate를 실행하는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197701927952155609 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_LDAP_AUTH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_pre_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자 정의 사전 인증 프로세스를 실행할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197702015663155609 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_PRE_AUTH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_setup_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'증명서 확인 함수를 실행하기 위해 설정하는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197702130733155609 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_SETUP_CRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'증명서 확인 함수를 실행할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197702214060155610 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_CRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_post_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자 정의 사후 인증 프로세스를 실행할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197702323694155610 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_POST_AUTH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_malformed_login_args
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2에 대한 인수 형식이 잘못되었습니다.';

wwv_flow_api.create_message (
  p_id=>197702429041155610 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_MALFORMED_LOGIN_ARGS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_null_login_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_custom_auth_std.login--p_flow_page:%0에 대한 p_session_id 인수가 널입니다.';

wwv_flow_api.create_message (
  p_id=>197702505039155610 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_NULL_LOGIN_ARG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_contact_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'관리자에게 문의하십시오.';

wwv_flow_api.create_message (
  p_id=>197702613005155610 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_CONTACT_ADMIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_illegal_login_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_custom_auth_std.login--p_flow_page:%0 p_session_id:%1의 p_session이 부적합합니다.';

wwv_flow_api.create_message (
  p_id=>197702721406155610 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_ILLEGAL_LOGIN_ARG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_invalid_login_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_custom_auth_std.login--p_flow_page:%0 p_session_id:%1의 p_session이 부적합합니다.';

wwv_flow_api.create_message (
  p_id=>197702812823155610 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_INVALID_LOGIN_ARG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_malformed_login_args2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2에 대한 시작점 인수가 잘못되었습니다.  ';

wwv_flow_api.create_message (
  p_id=>197702932479155611 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_MALFORMED_LOGIN_ARGS2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_login_null_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그인 프로시저에 널 사용자 이름이 전달되었습니다.';

wwv_flow_api.create_message (
  p_id=>197703021194155611 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LOGIN_NULL_USER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_partner_app_unreg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 체계에서 등록된 협력 애플리케이션 이름을 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197703118676155611 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_PARTNER_APP_UNREG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_fix_partner_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 체계를 편집하고 애플리케이션 이름을 추가하십시오.';

wwv_flow_api.create_message (
  p_id=>197703227735155611 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_FIX_PARTNER_APP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_wwsec_pkg_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'WWSEC_SSO_ENABLER_PRIVATE 패키지가 존재하지 않거나 부적합합니다.';

wwv_flow_api.create_message (
  p_id=>197703320284155611 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_WWSEC_PKG_MISSING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_fix_wwsec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'관리자에게 Oracle AS Single Sign-On 엔진 구성을 요청하십시오.';

wwv_flow_api.create_message (
  p_id=>197703425435155611 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_FIX_WWSEC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_sso_redir
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_custom_auth_sso.portal_sso_redirect를 실행하는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197703506074155612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_SSO_REDIR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_illegal_login_pg_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'login_page 프로시저에 대한 p_flow_page 인수에 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197703630264155612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_ILLEGAL_LOGIN_PG_ARG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_home_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'홈 페이지를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197703716643155612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_HOME_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록을 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197703806407155612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LIST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_list_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록 항목을 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197703932142155612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LIST_ITEM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_success_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'성공 페이지를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197704009500155612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_SUCCESS_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_define_default_templates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본 템플리트를 정의하여 애플리케이션을 생성하십시오.';

wwv_flow_api.create_message (
  p_id=>197704102570155612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.DEFINE_DEFAULT_TEMPLATES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_use_one_level_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'한 레벨의 탭을 사용하면 애플리케이션을 생성만 할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197704201679155613 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.USE_ONE_LEVEL_TAB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_modules
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모듈을 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197704331131155613 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_MODULES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_parse_error2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'구문 분석 오류2: %0';

wwv_flow_api.create_message (
  p_id=>197704401678155613 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.PARSE_ERROR2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_parse_error1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'구문 분석 오류: %0';

wwv_flow_api.create_message (
  p_id=>197704517404155613 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.PARSE_ERROR1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_updateable_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'갱신 가능한 보고서를 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197704625436155613 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_UPDATEABLE_REPORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_form_on_sp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SP에 폼을 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197704718682155613 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FORM_ON_SP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_form_on_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블에 폼을 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197704810061155614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FORM_ON_TABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_insert_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'삽입 폼을 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197704918899155614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_INSERT_FORM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_query_and_update_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'질의 및 갱신 페이지를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197705011814155614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_QUERY_AND_UPDATE_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_chart_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'차트 페이지를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197705131819155614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_CHART_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_invalid_report_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 보고서 유형입니다.';

wwv_flow_api.create_message (
  p_id=>197705205274155614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.INVALID_REPORT_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 페이지를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197705309371155614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_REPORT_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_calendar_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'달력 페이지를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197705430695155615 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_CALENDAR_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_form_on_equijoin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'등가 조인에 폼을 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197705525231155615 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FORM_ON_EQUIJOIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_wizard
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'마법사를 생성하는 마법사를 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197705600959155615 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_WIZARD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_tree
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'트리를 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197705725445155615 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_TREE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_excel_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Excel 차트를 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197705825343155615 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_EXCEL_CHART',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_summary_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'요약 페이지를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197705917737155615 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_SUMMARY_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_svg_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SVG 차트 페이지를 작성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197706019424155616 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_SVG_CHART',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_updateable_query_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'갱신 가능한 SQL 질의가 존재합니다. 갱신 가능한 SQL 질의는 페이지당 한 개만 추가할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197706131369155616 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.UPDATEABLE_QUERY_EXISTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_login_pg_handling
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그인 페이지 처리';

wwv_flow_api.create_message (
  p_id=>197706208872155616 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PG_HANDLING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_login_pg1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션(%0)은 %1 페이지를 로그인 페이지로 사용합니다.';

wwv_flow_api.create_message (
  p_id=>197706312757155616 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PG1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_login_pg2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 페이지가 요청될 때마다 추가 인증 검사를 수행하지 않고 페이지가 표시되거나 허용됩니다. 이렇게 하면 인증되기 전에 로그인 페이지를 표시할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197706407686155616 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PG2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_dbauth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 인증';

wwv_flow_api.create_message (
  p_id=>197706501569155616 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.DBAUTH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_dbauth2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션은 인증에 DAD 구성을 사용합니다. DAD 구성에 계정 정보가 저장되어 있는 경우, APP_USER 변수는 DAD와 연관된 사용자로 설정됩니다. PUBLIC_USER 애플리케이션 속성이 DAD에 저장된 사용자 이름과 동일한 값으로 설정되어 있는 경우, 애플리케이션 조건, 보안 체계 평가 및 다른 내장 논리에서 APP_USER 변수와 PUBLIC_USER 속성을 유용하게 비교할 수 있습니다. DAD에 사용자 계정 정보가 저장되어 있지 않은 경우, 사용자는 브라우저에 표시되는 대화상자를 통해 기본적인 인증 과정을 통과해야 합니다. 이 인증 후 엔진은 APP_USER를 이 과정이 캡처한 이름으로 설정합니다.';

wwv_flow_api.create_message (
  p_id=>197706601693155617 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.DBAUTH2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_dbauth3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'엔진에 의해 사용자에게 표시되는 로그인 페이지가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197706719464155617 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.DBAUTH3',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_page_sentry_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 감시 함수';

wwv_flow_api.create_message (
  p_id=>197706810089155617 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.PAGE_SENTRY_FUNCTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_pg_sentry1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내장 논리를 사용하여 페이지 감시 작업을 수행합니다. 각 페이지 요청에 대해 페이지 감시 함수는 세션 확인을 수행하고 반환값을 계산합니다.';

wwv_flow_api.create_message (
  p_id=>197706903011155617 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.PG_SENTRY1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_sess_verify_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세션 확인 함수';

wwv_flow_api.create_message (
  p_id=>197707024326155617 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.SESS_VERIFY_FUNCTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chk_cookie1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내장 논리를 사용하여 [%0](이)라는 쿠키를 검사합니다. 해당 쿠키가 존재하고 디코드된 값이 내부 세션 테이블에서 행을 찾아내면 세션은 적합한 것으로 간주됩니다.';

wwv_flow_api.create_message (
  p_id=>197707126122155617 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHK_COOKIE1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_sess_verify1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'추가 사용자 제공 코드를 사용하여 세션이 적합한지 확인합니다. 위의 내장 세션 확인 검사 결과가 TRUE이면 다음 코드를 실행하고 해당 부울 반환값을 기억해 두십시오.';

wwv_flow_api.create_message (
  p_id=>197707202558155618 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.SESS_VERIFY1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_compute_return_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'반환값 계산';

wwv_flow_api.create_message (
  p_id=>197707306014155618 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.COMPUTE_RETURN_VALUE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 감시 함수는 내장 세션 확인 검사에 대한 부울 결과를 엔진에 반환합니다. 결과가 True이면 엔진은 계속 페이지를 표시하거나 허용합니다. 결과가 False이면 엔진은 이 인증 체계에 지정된 부적합한 세션 페이지 또는 URL로 재지정됩니다. (아래 참조)';

wwv_flow_api.create_message (
  p_id=>197707417575155618 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 감시 함수는 내장 세션 확인 검사에 대한 부울 결과와 사용자 제공 세션 확인 검사 결과를 엔진에 반환합니다. 결과가 True이면 엔진은 계속 페이지를 표시하거나 허용합니다. 결과가 False이면 엔진은 이 인증 체계에 지정된 부적합한 세션 대상으로 재지정됩니다. (아래 참조)';

wwv_flow_api.create_message (
  p_id=>197707522896155618 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자 정의 논리를 사용하여 페이지 감시 작업을 수행합니다. 각 페이지 요청에 대해 엔진은 다음 코드를 실행합니다.';

wwv_flow_api.create_message (
  p_id=>197707622337155618 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION3',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'위 블록에 대한 부울 결과가 엔진에 반환됩니다. 결과가 True이면 엔진은 계속 페이지를 표시하거나 허용합니다. 결과가 False이면 엔진은 이 인증 체계에 지정된 부적합한 세션 대상으로 재지정됩니다. (아래 참조)';

wwv_flow_api.create_message (
  p_id=>197707720503155618 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION4',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세션 확인을 위한 내장 메소드는 API 호출을 사용하는 %0 개발자에게 제공됩니다.';

wwv_flow_api.create_message (
  p_id=>197707804426155618 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION5',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 부울 함수 결과는 인증 체계에 지정된 사용자 제공 페이지 감시 함수에서 다른 검사와 조합될 수 있습니다. 이 API는 호출되면 %0(이)라는 쿠키를 검사합니다.';

wwv_flow_api.create_message (
  p_id=>197707923965155619 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION6',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'쿠키가 존재하고 디코드된 값이 내부 세션 테이블에서 행을 찾아내면 세션은 적합한 것으로 간주되고, TRUE 값이 호출한 페이지 감시 함수에 반환됩니다.';

wwv_flow_api.create_message (
  p_id=>197708031045155619 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION7',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_invalid_sess_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 세션 대상';

wwv_flow_api.create_message (
  p_id=>197708124197155619 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.INVALID_SESS_TARGET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 감시 함수가 TRUE를 반환하면 페이지 렌더링 또는 프로세싱이 계속됩니다. 결과가 FALSE이면 엔진은 %0 페이지를 표시합니다. 이 페이지는 이 인증 체계에 지정된 사항을 기반으로 하는 이 애플리케이션의 로그인 페이지를 부적합한 세션 페이지로 간주합니다.';

wwv_flow_api.create_message (
  p_id=>197708205226155619 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION8',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_builtin_login_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내장 로그인 페이지';

wwv_flow_api.create_message (
  p_id=>197708322362155619 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.BUILTIN_LOGIN_PG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_sso_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On 서버';

wwv_flow_api.create_message (
  p_id=>197708413817155619 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.SSO_SERVER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_the_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL';

wwv_flow_api.create_message (
  p_id=>197708517578155620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.THE_URL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action9
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 감시 함수는 부울 결과를 엔진에 반환합니다. 결과가 TRUE이면 페이지 렌더링 또는 프로세싱이 계속됩니다. 결과가 FALSE이면 엔진은 %0(으)로 재지정됩니다.';

wwv_flow_api.create_message (
  p_id=>197708620513155620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION9',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action10
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 감시 함수가 TRUE를 반환하면 페이지 렌더링 또는 프로세싱이 계속됩니다. 결과가 FALSE이면 인증 체계에 부적합한 세션 대상이 지정되지 않았으므로 엔진을 종료해야 합니다. 이 경우, 사용자 제공 페이지 감시 함수는 %0 환경 외부의 로그인 페이지(외부 인증 포탈일 수도 있음)에 재지정된 것으로 간주합니다. 해당 함수는 또한 전역 변수 g_unrecoverable_error를 true로 설정하여 엔진이 오류 페이지를 표시하지 않은 채 종료하도록 지시합니다.';

wwv_flow_api.create_message (
  p_id=>197708723988155620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION10',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action11
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'엔진은 이 인증 체계의 사전 인증 프로세스로 지정되는 다음 코드를 실행합니다.';

wwv_flow_api.create_message (
  p_id=>197708814524155620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION11',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action12
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'값을 반환하지 않는 익명 블록으로 실행됩니다.';

wwv_flow_api.create_message (
  p_id=>197708932596155620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION12',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action13
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 체계에 지정된 사용자 정의 사전 인증 코드가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197709019028155620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION13',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_credentials_verification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'증명서 확인(인증)';

wwv_flow_api.create_message (
  p_id=>197709128694155621 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CREDENTIALS_VERIFICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action14
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그인 폼에 입력된 모든 사용자 이름/암호 조합은 적합한 것으로 간주됩니다. 입력된 사용자 이름은 세션 수명 동안 로그인 사용자 이름으로 사용됩니다. 이 기술은 실제 사용자 계정이 설정되기 전에 애플리케이션을 개발하는 동안 유용할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197709220004155621 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION14',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action15
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그인 폼에 입력된 사용자 이름과 암호를 애플리케이션 생성기(쿠키 사용자) 계정과 비교하십시오. 이러한 계정은 %0에 로그인하기 위해 작업 영역에 사용되는 계정과 동일합니다. 이 기술은 애플리케이션 사용자가 개발자로서 동일한 데이터베이스와 작업 영역에 %0 계정을 가지고 있는 경우에 유용할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197709303956155621 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION15',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action16
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 인증 체계에 지정된 LDAP 디렉토리를 사용하여 로그인 폼에 입력된 사용자 이름 및 암호를 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197709415900155621 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION16',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action17
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음으로 LDAP 매개변수 설정:';

wwv_flow_api.create_message (
  p_id=>197709506567155621 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION17',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_host
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 호스트:';

wwv_flow_api.create_message (
  p_id=>197709615883155621 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_HOST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_port
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 포트:';

wwv_flow_api.create_message (
  p_id=>197709718077155622 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_PORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_dn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 검색 기준:';

wwv_flow_api.create_message (
  p_id=>197709814712155622 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_DN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_edit_fn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 블록은 DBMS_LDAP.SIMPLE_BIND_S를 호출하기 전에 함수를 호출하는 데 사용됩니다. 로그인 폼에서 캡처된 사용자 이름은 LDAP 검색 기준에서 %LDAP_USER%를 바꾸는 데 사용되는 값을 반환하는 함수에 전달됩니다. (위 참조)';

wwv_flow_api.create_message (
  p_id=>197709932231155622 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_EDIT_FN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_edit_fn2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 코드 블록에는 다음 서명이 있어야 함:';

wwv_flow_api.create_message (
  p_id=>197710028636155622 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_EDIT_FN2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_edit_fn3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 기능을 사용하여 로그인 폼에 입력된 사용자 이름을 LDAP 디렉토리 항목과 일치하는 형식으로 변환할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197710129376155622 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_EDIT_FN3',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action18
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 사용자 정의 코드를 실행하여 증명서 확인:';

wwv_flow_api.create_message (
  p_id=>197710229490155622 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION18',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_post_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사후 인증 프로세스';

wwv_flow_api.create_message (
  p_id=>197710302693155623 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.POST_AUTH_PROC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action19
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내장 세션 테이블에 내장 로그인 페이지에 사용되는 세션이 있는지 확인하십시오. 해당 세션이 존재하고 다른 사용자가 소유하지 않은 경우, 로그인 폼의 사용자 이름을 사용하여 인증된 사용자가 이제 해당 세션을 소유하는 것으로 표시하십시오.';

wwv_flow_api.create_message (
  p_id=>197710417692155623 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION19',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action20
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0(이)라는 쿠키를 내부 세션 테이블에서 행을 찾는 값으로 설정하십시오.';

wwv_flow_api.create_message (
  p_id=>197710517702155623 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION20',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action22
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 페이지로 재지정될 URL을 결정하십시오. 렌더링 엔진에 의해 "딥 링크"가 세션 상태에 기록된 경우 해당 링크를 이동할 URL로 사용하십시오. 그렇지 않으면 애플리케이션의 홈 링크 속성으로 지정된 URL로 이동하십시오.';

wwv_flow_api.create_message (
  p_id=>197710625871155623 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION22',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_cust_post_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자 정의 사후 인증 프로세스';

wwv_flow_api.create_message (
  p_id=>197710719075155623 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CUST_POST_AUTH_PROC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action23
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'증명서 확인 후 엔진은 이 인증 체계의 사후 인증 프로세스로 지정되는 다음 코드를 실행합니다.';

wwv_flow_api.create_message (
  p_id=>197710822076155623 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION23',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action24
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'값을 반환하지 않는 익명 블록으로 실행됩니다.';

wwv_flow_api.create_message (
  p_id=>197710904271155624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION24',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action25
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 체계에 지정된 사용자 정의 사후 인증 코드가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197711030266155624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION25',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action26
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'위에서 결정한 URL로 재지정하십시오. URL이 호출하는 내장 로그인 페이지 및 API를 사용하여 로그인 프로세싱 끝을 표시합니다.';

wwv_flow_api.create_message (
  p_id=>197711105773155624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION26',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'일반적인 접근 방법은 페이지에 사용자 증명서를 캡처하는 로그인 폼이 포함되도록 하는 것입니다. 그러면 페이지의 제출 후 프로세스가 증명서를 확인하는 인증 모듈을 호출합니다. 인증 후에는 페이지에서 세션 등록 및 쿠키 설정 작업이 수행됩니다. 최종적으로 해당 페이지가 애플리케이션의 시작 페이지로 재지정됩니다.';

wwv_flow_api.create_message (
  p_id=>197711232157155624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 API: wwv_flow_custom_auth_std는 제출 후 프로세스에 의해 호출되어 방금 설명한 해당 단계 중 하나를 수행할 수 있습니다. 다음 두 개의 시작점이 사용 가능합니다.';

wwv_flow_api.create_message (
  p_id=>197711315177155624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'엔진이 모든 단계를 수행하도록 로그인 프로시저를 호출하십시오. 엔진은 내장 세션 테이블을 사용하며, 세션 등록 및 쿠키 설정 작업을 수행합니다. 사용자가 이 인증 체계에 제공하는 사용자 정의 코드는 인증 전, 인증 시 또는 인증 후에 실행됩니다.';

wwv_flow_api.create_message (
  p_id=>197711416883155624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON3',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자가 자신을 인증하되, %0이(가) 모든 사후 인증 작업을 처리하도록 하려는 경우, post_login 프로시저를 호출하십시오. 이러한 두 개의 시작점을 사용하는 경우, 내장 로그인 프로세싱 단계를 고유 로그인 페이지 및 이 페이지에서 실행되는 임의의 프로세스와 결합하여 사용할 수 있습니다. 내장 사후 인증 프로세싱을 사용하는 경우, 내장 페이지 감시와 세션 확인 프로세싱도 활용할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197711507829155625 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON4',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'외부 로그인 프로세싱';

wwv_flow_api.create_message (
  p_id=>197711623781155625 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 인증 체계는 부적합한 세션 대상에 사용되는 로그인 페이지 또는 URL을 지정하지 않습니다. 이는 페이지 감시 함수를 통해 이러한 경우가 처리된다는 것을 의미합니다. 로그인 페이지 또는 URL은 Single Sign-On 포탈 또는 일부 다른 로그인 서버로 재지정될 수도 있습니다. 또한 인증 체계에 로그인 프로세싱 값이 없습니다. 이러한 상황을 원하지 않는 경우 이 인증 체계를 편집하고 부적합한 세션 페이지 또는 URL을 제공한 다음 이 차트 보기를 다시 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197711732435155625 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 인증 체계는 부적합한 세션 대상에 사용되는 로그인 페이지 또는 URL을 지정하지 않습니다. 이는 페이지 감시 함수를 통해 이러한 경우가 처리된다는 것을 의미합니다. 로그인 페이지 또는 URL은 Single Sign-On 포탈 또는 일부 다른 로그인 서버로 재지정될 수도 있습니다. 하지만 아래에 표시된 것과 같이 인증 체계에는 로그인 프로세싱 값 집합이 있습니다.';

wwv_flow_api.create_message (
  p_id=>197711818036155625 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN3',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그인 URL %0은(는) %1 애플리케이션 페이지를 부적합한 세션 대상으로 지정합니다. 하지만 인증 체계에 로그인 프로세싱 값이 없습니다. 이 페이지에서는 다음 단계를 수행해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197711902228155625 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN4',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 엔진이 애플리케이션에 로그인 페이지를 표시하거나 허용할 수 있도록 하려면 애플리케이션 생성기의 <b>페이지 속성</b> 페이지에서 페이지 속성 ''예 - 공용 페이지''를 선택해야 합니다. 이렇게 하지 않으면 엔진은 페이지가 표시되기 전에 페이지 감시 함수 실행을 시도합니다. 아직 로그인하지 않은 경우 동일한 URL로의 재지정이 시도됩니다. 이로 인해 가장 부적합한 루프가 발생하게 됩니다. 고유의 페이지 감시 함수를 코드화하는 경우, 현재 페이지가 이 로그인 페이지가 되는 시기를 파악하여 이를 다른 페이지와 다르게 처리해야 합니다. 페이지 번호로 페이지를 식별할 수 있는 경우에는 괜찮습니다. 보다 일반적인 기술은 부울 함수 wwv_flow_custom_auth.current_page_is_public을 사';

h:=h||'용하여 애플리케이션에서 로그인 페이지 또는 다른 페이지의 이 공용 속성을 파악하는 것입니다.';

wwv_flow_api.create_message (
  p_id=>197712018561155626 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN6',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그인 URL %0은(는) %1 애플리케이션 페이지를 부적합한 세션 대상으로 지정합니다. 이 페이지에서는 다음 단계를 수행해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197712121620155626 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN7',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 체계의 로그인 프로세싱에 대해 설정된 값이 아래에 표시됩니다.';

wwv_flow_api.create_message (
  p_id=>197712202083155626 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN8',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login9
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On 서버는 사용자 인증 후 이 애플리케이션으로 재지정됩니다. 시작점은 %0 스키마에 있는 wwv_flow_custom_auth_sso.process_success 프로시저입니다. %0은(는) Oracle Application Server Single Sign-On 협력 애플리케이션으로 등록되며 로그인 서버에 대한 모든 인터페이스를 관리합니다. 하지만 원하는 경우 고유 스키마에 고유 애플리케이션을 등록할 수 있습니다. 고유 페이지 감시를 작성하거나, 인증 체계 갤러리에서 Portal-SSO 체계(내 애플리케이션을 협력 애플리케이션으로)를 기반으로 인증 체계를 간단하게 생성할 수 있습니다. 그 결과로 생성된 체계는 내장 SSO 페이지 감시 w';

h:=h||'wv_flow_custom_auth_std.portal_sso_sentry_v1을 호출합니다. 이 함수에서는 현재 인증 체계가 Oracle Application Server Single Sign-On에 등록된 협력 애플리케이션 이름을 알고 있어야 합니다. 인증 체계 생성 마법사가 협력 애플리케이션 이름을 요구합니다. 또는 인증 체계 생성 후 해당 체계를 편집하여 이름을 추가하거나 변경할 수 있습니다. 이름은 등록된 대로 대소문자를 구분하여 정확하게 입력해야 합니다. 또한 고유 URLC 수신자 프로시저를 작성하고 wwv_flow_custom_auth_sso.process_success API를 해당 프로시저에서 호출하여 Oracle Application Server Single Sign-On에 등록된 대로 애';

h:=h||'플리케이션 이름을 전달해야 할 수도 있습니다. 이렇게 하면 인증 후 %0에 세션이 등록됩니다. 고유 페이지 감시를 작성하는 경우, 인증이 필요하다고 결정되면 로그인 서버로의 재지정을 수행하기 위해 페이지 감시에 의해 wwv_flow_custom_auth_sso.portal_sso_redirect API가 호출될 수 있습니다. 협력 애플리케이션의 등록된 이름을 이 프로시저에 전달해야 합니다. 자세한 내용은 %0 설명서 및 %1 설명서를 참조하십시오.';

wwv_flow_api.create_message (
  p_id=>197712308509155626 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN9',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login12
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그인 URL %0은(는) %1 애플리케이션 페이지를 부적합한 세션 대상으로 지정한 것으로 나타나지 않았습니다. 또한 인증 체계에 로그인 프로세싱 값이 없습니다. 이 페이지에서는 다음 단계를 수행해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197712417787155626 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN12',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login13
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 URL에서 호출된 서비스가 %0 wwv_custom_auth_std API를 사용하여 세션 등록 작업을 지원하지 않으면 애플리케이션은 내장 페이지 감시 또는 세션 확인 프로세스를 사용할 수 없습니다. 따라서 이 작업은 각자가 방법을 고안하여 수행해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197712510518155627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN13',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_pre_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사전 인증 프로세스';

wwv_flow_api.create_message (
  p_id=>197712629951155627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_PRE_AUTH_PROC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_post_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사후 인증 프로세스';

wwv_flow_api.create_message (
  p_id=>197712722563155627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_POST_AUTH_PROC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login14
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그인 URL %0은(는) %1 애플리케이션 페이지를 부적합한 세션 대상으로 지정한 것으로 나타나지 않았습니다. 이 페이지에서는 다음 단계를 수행해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197712801406155627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN14',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login15
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 체계의 로그인 프로세싱에 대해 설정된 값이 아래에 표시됩니다.';

wwv_flow_api.create_message (
  p_id=>197712912968155627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN15',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login16
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 체계에 지정된 로그인 페이지는 이 애플리케이션의 [%0] 페이지입니다. 이 페이지에서는 다음 단계를 수행해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197713005188155627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN16',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login17
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'하지만 인증 체계에 로그인 프로세싱 값이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197713101933155627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN17',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login18
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 페이지는 애플리케이션에 대해 지정된 로그인 페이지이므로, 처음 표시될 때 해당 페이지에서 특정 작업을 수행할 수 없습니다. 사용자 인증이 아직 수행되지 않았기 때문입니다. 또한 특정 세션 상태 및 세션 식별 변수는 인증 후 처리되는 일반 페이지에 있기 때문에 페이지 계산 또는 프로세스에 사용할 수 없습니다. 이러한 이유로 인해 인증 체계에서 로그인 페이지를 페이지 번호별로 지정하는 것은 로그인 폼 프로세싱 이외의 기능이 전혀 없거나 거의 없는 페이지에만 적합합니다. 로그인 페이지를 보다 동적으로 만들면 인증 체계 마법사 또는 편집 페이지에서 로그인 URL 지정을 사용하십시오. 생성기의 페이지 속성 폼을 사용하여 공용 페이지 속성을 ''예 - 공용 페이지''로 설정하면'||chr(10)||
'로그인 페이지는 애플리케이션에서 로그인 ';

h:=h||'페이지 역할을 수행할 뿐만 아니라 %0의 모든 기능을 사용할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197713203367155628 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN18',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p817_refresh_auth_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 체계를 새로 고치는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197713301651155628 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P817_REFRESH_AUTH_SCHEME_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Single Sign-On(Oracle 사용 전용)';

wwv_flow_api.create_message (
  p_id=>197713420065155628 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On(%0을(를) 협력 애플리케이션으로)';

wwv_flow_api.create_message (
  p_id=>197713516311155628 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On(내 애플리케이션을 협력 애플리케이션으로)';

wwv_flow_api.create_message (
  p_id=>197713628814155628 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE3',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내장 로그인 페이지: %0 계정 증명서 사용';

wwv_flow_api.create_message (
  p_id=>197713718940155628 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE4',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내장 로그인 페이지: 공개 증명서';

wwv_flow_api.create_message (
  p_id=>197713822813155629 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE5',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내장 로그인 페이지: LDAP 디렉토리 증명서 사용';

wwv_flow_api.create_message (
  p_id=>197713905132155629 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE6',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'갤러리의 인증 체계를 기준으로 함';

wwv_flow_api.create_message (
  p_id=>197714021012155629 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE7',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_util_obj_not_found_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'복사할 %0(%1)을(를) 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197714106970155629 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_UTIL.OBJ_NOT_FOUND_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_cannot_find_sgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'지정된 작업 영역 ID "%0"에 대한 보안 그룹 ID를 확인할 수 없음'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197714205125155629 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.CANNOT_FIND_SGID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_remove_last_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 기능을 사용하여 작업 영역의 마지막 스키마를 제거할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197714309602155629 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REMOVE_LAST_SCHEMA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_reset_password_reserved_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 스키마에 대한 암호를 재설정할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197714403952155630 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.RESET_PASSWORD_RESERVED_SCHEMA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_reset_password_not_in_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역과 연관되지 않은 스키마에 대해서는 암호 재설정이 허용되지 않습니다.  %0';

wwv_flow_api.create_message (
  p_id=>197714503096155630 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.RESET_PASSWORD_NOT_IN_SCHEMA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_reset_password_not_in_company
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%1 작업 영역에 사용자 이름 %0이(가) 존재하지 않습니다.';

wwv_flow_api.create_message (
  p_id=>197714624856155630 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.RESET_PASSWORD_NOT_IN_COMPANY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_page_dev_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'개발자에게 이 페이지에 구성 요소를 생성할 수 있는 권한이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197714726165155630 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_PAGE_DEV_PRIV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_layout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'선택된 보고서 레이아웃이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197714818677155630 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_LAYOUT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_unknown_workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'알 수 없는 작업 영역 이름';

wwv_flow_api.create_message (
  p_id=>197714919758155630 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_UNKNOWN_WORKSPACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_unhandled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'렌더링 엔진에서 WSDL 문서를 인식하지 못했습니다. 이 서비스에 대한 참조 생성을 계속하려면 <b>수동으로 웹 서비스 참조 생성</b>을 누르십시오.';

wwv_flow_api.create_message (
  p_id=>197715017846155631 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_UNHANDLED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flows_api_last_extended
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'최종으로 확장된 API:';

wwv_flow_api.create_message (
  p_id=>197715121063155631 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOWS_API_LAST_EXTENDED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_current_flows_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'현재 버전:';

wwv_flow_api.create_message (
  p_id=>197715212069155631 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.CURRENT_FLOWS_VERSION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_import_compatible_with_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 임포트와 호환되는 버전:';

wwv_flow_api.create_message (
  p_id=>197715325532155631 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.IMPORT_COMPATIBLE_WITH_VERSION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_missing_export_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 임포트가 익스포트 버전을 제공하지 않았습니다.';

wwv_flow_api.create_message (
  p_id=>197715424518155631 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.MISSING_EXPORT_VERSION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_unkown_engine_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'엔진 버전을 설정할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197715506647155631 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.UNKOWN_ENGINE_VERSION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_unkown_api_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'엔진의 최종 API 버전을 설정할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197715617020155631 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.UNKOWN_API_VERSION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_upgrade_needed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션 익스포트를 임포트하려면 업그레이드해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197715701769155632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.UPGRADE_NEEDED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_invalid_credentials
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 사용자 이름, 암호 또는 작업 영역 조합';

wwv_flow_api.create_message (
  p_id=>197715831527155632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.INVALID_CREDENTIALS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_user_not_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 사용자가 이 작업을 수행하려면 관리자 권한이 필요합니다.';

wwv_flow_api.create_message (
  p_id=>197715930976155632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.USER_NOT_ADMIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_sgid_not_set_import
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션을 임포트하려면 패키지 변수 g_security_group_id를 설정해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197716029046155632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.SGID_NOT_SET_IMPORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flow_id_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 프로시저가 p_id 값 없이 호출되었습니다. 애플리케이션 ID를 제공해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197716100058155632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOW_ID_MISSING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flow_not_deleted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 애플리케이션이 삭제되지 않았습니다. 임포트가 시도되지 않습니다.';

wwv_flow_api.create_message (
  p_id=>197716221338155632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOW_NOT_DELETED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_templ_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트 %0을(를) 작성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197716314132155633 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_TEMPL_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_build_option_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'빌드 옵션 이름 %0을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197716416610155633 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUILD_OPTION_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_build_option_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'빌드 옵션 ID "%0"을(를) 설정하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197716511092155633 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUILD_OPTION_SET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_nav_bar_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탐색 도구 모음 ID "%0"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197716619821155633 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_NAV_BAR_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_nav_bar_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탐색 도구 모음 항목 ID "%0"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197716703673155633 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_NAV_BAR_ITEM_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_flow_process_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 프로세스 ID "%0"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197716827243155633 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FLOW_PROCESS_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_process_sql_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로세스 SQL ID "%0"을(를) 설정하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197716928918155634 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PROCESS_SQL_SET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_flow_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 항목 ID "%0"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197717013866155634 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FLOW_ITEM_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_flow_computation_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 계산 항목 "%0"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197717128996155634 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FLOW_COMPUTATION_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_std_tab_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표준 테이블 ID "%0"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197717207524155634 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_STD_TAB_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_tabset_rename
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탭 집합 %1의 이름을 %0(으)로 바꾸는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197717322833155634 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_TABSET_RENAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_parent_tab_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상위 탭 ID "%0"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197717420609155634 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PARENT_TAB_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_lov_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'값 목록 ID "%0"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197717528724155635 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_LOV_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 이름 "%0", ID "%1"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197717619923155635 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_help_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 %0 도움말 텍스트를 작성하는 중 오류 발생:';

wwv_flow_api.create_message (
  p_id=>197717704330155635 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_HELP_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_name_upd
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 이름 "%0", ID %1을(를) 갱신하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197717816435155635 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_NAME_UPD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_button_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추 이름 "%0", ID "%1"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197717913937155635 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUTTON_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_branch_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'분기 ID "%0"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197718015809155635 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BRANCH_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_branch_args_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'분기 인수 ID "%0"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197718132403155635 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BRANCH_ARGS_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류 페이지: %0, 항목: "%1", ID: "%2"';

wwv_flow_api.create_message (
  p_id=>197718207361155636 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_ITEM_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_computation_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 계산 페이지 %0, 항목 %1, ID "%2"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197718323845155636 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_COMPUTATION_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_validation_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 검증 페이지 %0, 이름 %1을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197718411457155636 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_VALIDATION_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_process_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 프로세스 페이지 %0, 이름 %1을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197718516934155636 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_PROCESS_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_lang_map_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 번역 맵을 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197718614484155636 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_LANG_MAP_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_on_table_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 테이블에 페이지를 작성할 수 없음';

wwv_flow_api.create_message (
  p_id=>197718703963155636 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_ON_TABLE_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_invalid_report_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 보고서 유형';

wwv_flow_api.create_message (
  p_id=>197718822975155637 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_INVALID_REPORT_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_report_page_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 페이지 %0이(가) 존재합니다. 보고서 영역이 추가되었습니다.';

wwv_flow_api.create_message (
  p_id=>197718915459155637 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_REPORT_PAGE_EXISTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_has_buttons
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 페이지에는 단추가 있습니다.';

wwv_flow_api.create_message (
  p_id=>197719026734155637 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_HAS_BUTTONS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_form_added_to_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'폼이 기존 페이지 %0에 추가되었습니다.';

wwv_flow_api.create_message (
  p_id=>197719115350155637 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FORM_ADDED_TO_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_report_page_exists2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 페이지는 존재하므로 작성되지 않았습니다.';

wwv_flow_api.create_message (
  p_id=>197719217163155637 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_REPORT_PAGE_EXISTS2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_bug_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'버그 ID "%0"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197719331050155637 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUG_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_shortcut_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단축키 ID "%0"을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197719422288155638 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_SHORTCUT_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_auth_scheme_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 체계 %0을(를) 생성하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197719520243155638 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_AUTH_SCHEME_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_sgid_not_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'패키지 변수 g_security_group_id를 설정해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197719620646155638 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.SGID_NOT_SET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flow_id_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 ID %0은(는) 오라클용으로 예약되어 있음 ';

wwv_flow_api.create_message (
  p_id=>197719706619155638 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOW_ID_RESERVED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flows_api_runtime_incompatible
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'API 작업은 현재 런타임과 호환되지 않는 호출을 포함합니다.';

wwv_flow_api.create_message (
  p_id=>197719812589155638 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOWS_API_RUNTIME_INCOMPATIBLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_compatible
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'호환(이 임포트를 문제 없이 실행할 수 있어야 합니다.)';

wwv_flow_api.create_message (
  p_id=>197719913090155638 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.COMPATIBLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_not_compatible
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'호환되지 않음(익스포트에 %0 버전에서 지원하지 않는 호출이 포함되어 있을 수 있습니다.)';

wwv_flow_api.create_message (
  p_id=>197720021708155638 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.NOT_COMPATIBLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_inline_plus_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인라인+통지';

wwv_flow_api.create_message (
  p_id=>197720106412155639 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_INLINE_PLUS_NOTIFICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_inline
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인라인';

wwv_flow_api.create_message (
  p_id=>197720213711155639 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_INLINE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'통지';

wwv_flow_api.create_message (
  p_id=>197720304450155639 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NOTIFICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_error_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류 페이지';

wwv_flow_api.create_message (
  p_id=>197720403778155639 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ERROR_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_location
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'위치';

wwv_flow_api.create_message (
  p_id=>197720502060155639 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_LOCATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_above_box
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상자 위';

wwv_flow_api.create_message (
  p_id=>197720630088155640 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.ABOVE_BOX',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_below_box
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상자 아래';

wwv_flow_api.create_message (
  p_id=>197720704188155640 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.BELOW_BOX',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_bottom
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'아래쪽';

wwv_flow_api.create_message (
  p_id=>197720807137155640 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.BOTTOM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_change
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트 변경';

wwv_flow_api.create_message (
  p_id=>197720907607155640 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_CHANGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트 닫기';

wwv_flow_api.create_message (
  p_id=>197721020891155640 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_CLOSE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트 복사';

wwv_flow_api.create_message (
  p_id=>197721102945155640 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_COPY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트 생성';

wwv_flow_api.create_message (
  p_id=>197721200739155641 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트 삭제';

wwv_flow_api.create_message (
  p_id=>197721313658155641 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_DELETE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트 편집';

wwv_flow_api.create_message (
  p_id=>197721432364155641 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_EDIT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_expand
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트 확장';

wwv_flow_api.create_message (
  p_id=>197721500007155641 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_EXPAND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 템플리트';

wwv_flow_api.create_message (
  p_id=>197721617773155641 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_NEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이전 템플리트';

wwv_flow_api.create_message (
  p_id=>197721706312155641 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_PREVIOUS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_top
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'최상위';

wwv_flow_api.create_message (
  p_id=>197721807653155641 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.TOP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_page_accept
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 분기 허용';

wwv_flow_api.create_message (
  p_id=>197721911009155642 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PAGE_ACCEPT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_page_identified_by_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목으로 분기할 페이지 지정';

wwv_flow_api.create_message (
  p_id=>197722009182155642 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PAGE_IDENTIFIED_BY_ITEM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_url_identified_by_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목으로 분기할 URL 지정';

wwv_flow_api.create_message (
  p_id=>197722112540155642 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_URL_IDENTIFIED_BY_ITEM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_function_returning_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지를 반환하는 함수 분기';

wwv_flow_api.create_message (
  p_id=>197722214506155642 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_FUNCTION_RETURNING_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_function_returning_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL을 반환하는 함수 분기';

wwv_flow_api.create_message (
  p_id=>197722305309155642 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_FUNCTION_RETURNING_URL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_plsql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL 프로시저 분기';

wwv_flow_api.create_message (
  p_id=>197722432599155642 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PLSQL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'없음';

wwv_flow_api.create_message (
  p_id=>197722531697155643 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NONE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_unconditional
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'무조건';

wwv_flow_api.create_message (
  p_id=>197722609152155643 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_UNCONDITIONAL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_standard_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표준 조건';

wwv_flow_api.create_message (
  p_id=>197722701379155643 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_STANDARD_CONDITION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_never
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'무조건 부정';

wwv_flow_api.create_message (
  p_id=>197722801547155643 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NEVER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4656_default_calendar_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본 달력 템플리트';

wwv_flow_api.create_message (
  p_id=>197722924191155643 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4656.DEFAULT_CALENDAR_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'달력';

wwv_flow_api.create_message (
  p_id=>197723007800155643 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.CALENDAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_no_ddl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DDL 생성에 필요한 %0을(를) 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197723107883155644 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.NO_DDL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_edit_report_err_updating_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 열을 갱신하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197723205576155644 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_EDIT_REPORT.ERR_UPDATING_COLS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_unknown_workspace_colon
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'알 수 없는 작업 영역 이름: %0';

wwv_flow_api.create_message (
  p_id=>197723313624155644 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_migrate_svg_to_flash_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SVG 차트를 플래시 차트로 이전하는 중 오류가 발생했습니다. %0';

wwv_flow_api.create_message (
  p_id=>197723413474155644 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.MIGRATE_SVG_TO_FLASH_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_migrate_svg_to_flash
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SVG 차트를 플래시 차트로 이전하도록 요청했습니다. 요청을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197723506046155644 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MIGRATE_SVG_TO_FLASH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_run_stmt_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'명령문 실행을 실패했습니다. %0'||chr(10)||
'<pre>%1</pre>';

wwv_flow_api.create_message (
  p_id=>197723600198155644 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.RUN_STMT_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_get_stmt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'GET_STMT 오류입니다. %0';

wwv_flow_api.create_message (
  p_id=>197723714659155645 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.GET_STMT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_get_block
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'GET_BLOCK 오류입니다. %0';

wwv_flow_api.create_message (
  p_id=>197723812528155645 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.GET_BLOCK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_no_file_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'파일을 찾을 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197723921425155645 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.NO_FILE_FOUND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_date_picker
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'날짜 선택기';

wwv_flow_api.create_message (
  p_id=>197724008368155645 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.DATE_PICKER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_hidden
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'숨김';

wwv_flow_api.create_message (
  p_id=>197724106775155645 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.HIDDEN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_file_browse
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'파일 찾아보기';

wwv_flow_api.create_message (
  p_id=>197724211176155645 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.FILE_BROWSE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_stop_and_start_html_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정지 및 시작 테이블';

wwv_flow_api.create_message (
  p_id=>197724321918155646 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.STOP_AND_START_HTML_TABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_list_manager
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록 관리자';

wwv_flow_api.create_message (
  p_id=>197724425585155646 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.LIST_MANAGER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_check_box
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'체크 박스';

wwv_flow_api.create_message (
  p_id=>197724526618155646 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.CHECK_BOX',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_display_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시 전용';

wwv_flow_api.create_message (
  p_id=>197724600398155646 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.DISPLAY_ONLY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_multiple_select
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다중 선택';

wwv_flow_api.create_message (
  p_id=>197724717828155646 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.MULTIPLE_SELECT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_popup_list_of_values
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'팝업 값 목록';

wwv_flow_api.create_message (
  p_id=>197724816704155646 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.POPUP_LIST_OF_VALUES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_radio
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'라디오';

wwv_flow_api.create_message (
  p_id=>197724909275155647 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.RADIO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_select_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'선택 목록';

wwv_flow_api.create_message (
  p_id=>197725016145155647 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.SELECT_LIST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'텍스트';

wwv_flow_api.create_message (
  p_id=>197725102497155647 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_text_area
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'텍스트 영역';

wwv_flow_api.create_message (
  p_id=>197725215726155647 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.TEXT_AREA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_shuttle
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'셔틀';

wwv_flow_api.create_message (
  p_id=>197725308238155647 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.SHUTTLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message copy_list_entry
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록 항목 복사';

wwv_flow_api.create_message (
  p_id=>197725419381155647 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COPY_LIST_ENTRY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_no_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 스키마에 대한 권한이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197725511022155647 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.NO_PRIV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_images_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이미지를 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197725628527155648 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_IMAGES_FOUND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_check_sgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증되지 않은 액세스(보안 그룹 패키지 변수가 설정되지 않음)입니다.';

wwv_flow_api.create_message (
  p_id=>197725731175155648 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CHECK_SGID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_create_user_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'존재하는 사용자 그룹이므로 생성되지 않았습니다.';

wwv_flow_api.create_message (
  p_id=>197725825024155648 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CREATE_USER_GROUP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_create_company
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'존재하는 작업 영역이므로 생성되지 않았습니다.';

wwv_flow_api.create_message (
  p_id=>197725901115155648 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CREATE_COMPANY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_create_fnd_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자가 생성되지 않은 이유: %0';

wwv_flow_api.create_message (
  p_id=>197726011944155648 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CREATE_FND_USER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_no_user_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 사용자는 존재하지 않습니다.';

wwv_flow_api.create_message (
  p_id=>197726122970155648 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.NO_USER_EXIST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_no_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 사용자가 전자 메일 주소를 제공하지 않았습니다.';

wwv_flow_api.create_message (
  p_id=>197726207720155649 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.NO_EMAIL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_fetch_fnd_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'FND 사용자 정보를 인출할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197726330219155649 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.FETCH_FND_USER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_notification_msg_checksum_format_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'통지 메시지 체크섬 형식 오류: %0';

wwv_flow_api.create_message (
  p_id=>197726422392155649 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NOTIFICATION_MSG_CHECKSUM_FORMAT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_notification_msg_checksum_content_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'통지 메시지 체크섬 내용 오류: %0 : %1';

wwv_flow_api.create_message (
  p_id=>197726519569155649 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NOTIFICATION_MSG_CHECKSUM_CONTENT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_print_success_msg_checksum_format_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인쇄 성공 메시지 체크섬 형식 오류: %0';

wwv_flow_api.create_message (
  p_id=>197726613501155649 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PRINT_SUCCESS_MSG_CHECKSUM_FORMAT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_print_success_msg_checksum_content_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인쇄 성공 메시지 체크섬 내용 오류: %0 : %1';

wwv_flow_api.create_message (
  p_id=>197726706961155649 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PRINT_SUCCESS_MSG_CHECKSUM_CONTENT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_flow_created_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 데모 애플리케이션이 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197726821001155650 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_FLOW.CREATED_SUCCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_flow_created_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 데모를 생성하기 위한 공간이 부족합니다. 관리 페이지로 이동하여 "현재 서비스에 대한 변경 요청" 링크를 눌러 추가 저장 영역을 요청하십시오.';

wwv_flow_api.create_message (
  p_id=>197726921069155650 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_FLOW.CREATED_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4150_column_number
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 열';

wwv_flow_api.create_message (
  p_id=>197727005267155650 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4150_COLUMN_NUMBER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message cached
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'캐시에 저장됨';

wwv_flow_api.create_message (
  p_id=>197727115339155650 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CACHED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message valid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'적합';

wwv_flow_api.create_message (
  p_id=>197727218264155650 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VALID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'만기됨';

wwv_flow_api.create_message (
  p_id=>197727300801155650 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EXPIRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_enabled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용으로 설정됨';

wwv_flow_api.create_message (
  p_id=>197727402226155651 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ENABLED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_highlight_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'강조 표시 유형';

wwv_flow_api.create_message (
  p_id=>197727530975155651 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HIGHLIGHT_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_cell
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'셀';

wwv_flow_api.create_message (
  p_id=>197727612419155651 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CELL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_bgcolor
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'배경색';

wwv_flow_api.create_message (
  p_id=>197727724812155651 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_BGCOLOR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_yellow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'노란색';

wwv_flow_api.create_message (
  p_id=>197727808449155651 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_YELLOW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_green
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'녹색';

wwv_flow_api.create_message (
  p_id=>197727927829155651 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_GREEN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_orange
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'주황색';

wwv_flow_api.create_message (
  p_id=>197728011347155651 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ORANGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_text_color
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'텍스트 색상';

wwv_flow_api.create_message (
  p_id=>197728113783155652 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TEXT_COLOR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_highlight_when
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'강조 표시 시점';

wwv_flow_api.create_message (
  p_id=>197728228528155652 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HIGHLIGHT_WHEN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_like
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음과 유사';

wwv_flow_api.create_message (
  p_id=>197728315604155652 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_LIKE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_not_like
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음과 유사하지 않음';

wwv_flow_api.create_message (
  p_id=>197728418186155652 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_NOT_LIKE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음이 널임';

wwv_flow_api.create_message (
  p_id=>197728506511155652 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_NULL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음이 널이 아님';

wwv_flow_api.create_message (
  p_id=>197728625957155653 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_NOT_NULL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음에 속함';

wwv_flow_api.create_message (
  p_id=>197728723200155653 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_not_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음에 속하지 않음';

wwv_flow_api.create_message (
  p_id=>197728808302155653 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_NOT_IN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_save
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'저장';

wwv_flow_api.create_message (
  p_id=>197728931012155653 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SAVE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_ascending
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오름차순';

wwv_flow_api.create_message (
  p_id=>197729023914155653 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ASCENDING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_descending
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내림차순';

wwv_flow_api.create_message (
  p_id=>197729127187155653 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DESCENDING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_category
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- 범주 선택 -';

wwv_flow_api.create_message (
  p_id=>197729207189155654 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_CATEGORY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이름';

wwv_flow_api.create_message (
  p_id=>197729316386155654 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시퀀스';

wwv_flow_api.create_message (
  p_id=>197729407444155654 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SEQUENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'예';

wwv_flow_api.create_message (
  p_id=>197729504506155654 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_YES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'아니오';

wwv_flow_api.create_message (
  p_id=>197729602035155654 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'행';

wwv_flow_api.create_message (
  p_id=>197729731150155654 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_blue
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'파란색';

wwv_flow_api.create_message (
  p_id=>197729823350155655 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_BLUE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_red
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'빨간색';

wwv_flow_api.create_message (
  p_id=>197729910066155655 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_RED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_displayed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시';

wwv_flow_api.create_message (
  p_id=>197730025891155655 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DISPLAYED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_other
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기타';

wwv_flow_api.create_message (
  p_id=>197730103236155655 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_OTHER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'값';

wwv_flow_api.create_message (
  p_id=>197730205703155655 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_VALUE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열';

wwv_flow_api.create_message (
  p_id=>197730332451155656 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COLUMN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_cancel
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'취소';

wwv_flow_api.create_message (
  p_id=>197730416114155656 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CANCEL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'삭제';

wwv_flow_api.create_message (
  p_id=>197730526543155656 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DELETE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- 열 선택 -';

wwv_flow_api.create_message (
  p_id=>197730618193155656 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_COLUMN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이전에 이 애플리케이션의 지원 객체가 설치되었습니다. 이 마법사는 이러한 지원 객체의 업그레이드 과정을 안내합니다.';

wwv_flow_api.create_message (
  p_id=>197730719932155656 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_MESSAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message caching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'캐싱';

wwv_flow_api.create_message (
  p_id=>197730815410155656 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CACHING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4045_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'분기=';

wwv_flow_api.create_message (
  p_id=>197730916041155657 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4045.BRANCH=',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4045_menu_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리 항목=';

wwv_flow_api.create_message (
  p_id=>197731015260155657 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4045.MENU_OPTION=',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_success_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션의 지원 객체가 업그레이드되었습니다.';

wwv_flow_api.create_message (
  p_id=>197731126609155657 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_SUCCESS_MESSAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_failure_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션의 지원 객체 업그레이드를 실패했습니다.';

wwv_flow_api.create_message (
  p_id=>197731222205155657 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_FAILURE_MESSAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_confirm_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션의 지원 객체를 업그레이드할 것인지 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197731312916155657 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_CONFIRM_MESSAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message yes_by_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'예, 사용자별';

wwv_flow_api.create_message (
  p_id=>197731409818155658 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'YES_BY_USER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message set_binds
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'질의를 테스트할 때는 모든 바인드 변수의 값을 설정해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197731518897155658 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SET_BINDS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create6a
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새로 작성된 로그인 페이지: LDAP 디렉토리 증명서 사용';

wwv_flow_api.create_message (
  p_id=>197731625927155658 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE6A',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create6b
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기존 로그인 페이지: LDAP 디렉토리 증명서 사용';

wwv_flow_api.create_message (
  p_id=>197731700057155658 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE6B',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create4a
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새로 작성된 로그인 페이지: %0 계정 증명서 사용';

wwv_flow_api.create_message (
  p_id=>197731811668155658 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE4A',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create4b
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기존 로그인 페이지: %0 계정 증명서 사용';

wwv_flow_api.create_message (
  p_id=>197731913099155658 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE4B',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_flash_chart_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'플래시 차트 오류: %0';

wwv_flow_api.create_message (
  p_id=>197732025449155659 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.FLASH_CHART_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message report_queries_valid_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'쿼리가 적합합니다. 바인드 변수의 구문이 분석되었습니다.';

wwv_flow_api.create_message (
  p_id=>197732105088155659 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REPORT_QUERIES.VALID_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'선택된 페이지가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197732201812155659 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지';

wwv_flow_api.create_message (
  p_id=>197732318723155659 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_create_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'생성';

wwv_flow_api.create_message (
  p_id=>197732409196155659 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_CREATE_BUTTON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_edit_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'편집';

wwv_flow_api.create_message (
  p_id=>197732506608155660 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_EDIT_BUTTON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_copy_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'복사';

wwv_flow_api.create_message (
  p_id=>197732627668155660 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COPY_BUTTON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_view_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보기';

wwv_flow_api.create_message (
  p_id=>197732732304155660 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_VIEW_BUTTON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지를 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197732822866155660 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_NOT_FOUND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이름';

wwv_flow_api.create_message (
  p_id=>197732927624155660 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제목';

wwv_flow_api.create_message (
  p_id=>197733029031155660 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TITLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'별칭';

wwv_flow_api.create_message (
  p_id=>197733115161155661 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_ALIAS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트';

wwv_flow_api.create_message (
  p_id=>197733208363155661 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_invalid_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 템플리트';

wwv_flow_api.create_message (
  p_id=>197733330142155661 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_INVALID_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표준 탭 집합';

wwv_flow_api.create_message (
  p_id=>197733404070155661 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TABSET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_authorization
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'권한';

wwv_flow_api.create_message (
  p_id=>197733501520155661 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_AUTHORIZATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_build_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'빌드 옵션';

wwv_flow_api.create_message (
  p_id=>197733631382155661 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_BUILD_OPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_authentication
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증';

wwv_flow_api.create_message (
  p_id=>197733727671155662 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_AUTHENTICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_public
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'공용';

wwv_flow_api.create_message (
  p_id=>197733826909155662 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_PUBLIC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'필수';

wwv_flow_api.create_message (
  p_id=>197733908302155662 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_REQUIRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역';

wwv_flow_api.create_message (
  p_id=>197734024213155662 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_display_pt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시&nbsp;지점:&nbsp;';

wwv_flow_api.create_message (
  p_id=>197734129606155662 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_DISPLAY_PT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 페이지에 영역이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197734205175155663 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_REGION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추';

wwv_flow_api.create_message (
  p_id=>197734324080155663 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BUTTON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목';

wwv_flow_api.create_message (
  p_id=>197734421655155663 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ITEM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'계산';

wwv_flow_api.create_message (
  p_id=>197734504873155663 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COMPUTATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_computation_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'0페이지는 계산을 지원하지 않습니다. 모든 페이지에서 발생해야 하는 계산은 애플리케이션 레벨 계산에 의해 처리되어야 합니다.';

wwv_flow_api.create_message (
  p_id=>197734632551155663 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COMPUTATION_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_process_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'0페이지는 프로세스를 지원하지 않습니다. 모든 페이지에서 발생해야 하는 프로세스는 애플리케이션 레벨 프로세스에 의해 처리되어야 합니다.';

wwv_flow_api.create_message (
  p_id=>197734710641155663 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PROCESS_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onload_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 페이지에 onLoad 계산이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197734816576155664 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONLOAD_COMPUTATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로세스';

wwv_flow_api.create_message (
  p_id=>197734903074155664 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PROCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onload_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 페이지에 onLoad 프로세스가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197735012313155664 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONLOAD_PROCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_zero_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'0페이지는 분기, 계산, 프로세스 또는 검증을 지원하지 않습니다. 모든 페이지에서 발생해야 하는 계산 및 프로세스는 애플리케이션 레벨 계산 및 프로세스에 의해 처리되어야 합니다.';

wwv_flow_api.create_message (
  p_id=>197735130824155664 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_ZERO_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onsubmit_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 페이지에 onSubmit 계산이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197735219835155664 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONSUBMIT_COMPUTATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증';

wwv_flow_api.create_message (
  p_id=>197735330706155664 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_VALIDATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 페이지에 검증이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197735429464155665 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_VALIDATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onsubmit_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 페이지에 onSubmit 프로세스가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197735510084155665 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONSUBMIT_PROCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'분기';

wwv_flow_api.create_message (
  p_id=>197735608130155665 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCHING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 페이지에 분기가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197735717308155665 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_BRANCHING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_parent_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상위 탭';

wwv_flow_api.create_message (
  p_id=>197735816384155665 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PARENT_TAB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_parent_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상위 레벨 탭 없음';

wwv_flow_api.create_message (
  p_id=>197735931878155665 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_PARENT_TAB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_std_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표준&nbsp;탭';

wwv_flow_api.create_message (
  p_id=>197736016813155666 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_STD_TAB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탭 집합';

wwv_flow_api.create_message (
  p_id=>197736126135155666 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TAB_SET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 페이지에 탭 집합이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197736225767155666 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_TAB_SET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탐색&nbsp;도구 모음';

wwv_flow_api.create_message (
  p_id=>197736318975155666 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NAV_BAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 애플리케이션에 탐색 도구 모음이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197736428473155666 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_NAV_BAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message region_templates_no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트 없음';

wwv_flow_api.create_message (
  p_id=>197736528436155666 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGION_TEMPLATES_NO_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'선택된 페이지가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197736616199155667 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 없음';

wwv_flow_api.create_message (
  p_id=>197736728458155667 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_REGION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'계산 없음';

wwv_flow_api.create_message (
  p_id=>197736812635155667 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_COMPUTATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로세스 없음';

wwv_flow_api.create_message (
  p_id=>197736918514155667 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_PROCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 없음';

wwv_flow_api.create_message (
  p_id=>197737005423155667 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_VALIDATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'분기 없음';

wwv_flow_api.create_message (
  p_id=>197737112524155667 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_BRANCHING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_warning
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'경고';

wwv_flow_api.create_message (
  p_id=>197737229509155668 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_WARNING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 생성';

wwv_flow_api.create_message (
  p_id=>197737318014155668 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로세스 생성';

wwv_flow_api.create_message (
  p_id=>197737420906155668 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_PROCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'계산 생성';

wwv_flow_api.create_message (
  p_id=>197737510698155668 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_COMPUTATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 생성';

wwv_flow_api.create_message (
  p_id=>197737632248155668 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_VALIDATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'분기 생성';

wwv_flow_api.create_message (
  p_id=>197737725744155668 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_BRANCH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 생성';

wwv_flow_api.create_message (
  p_id=>197737814640155669 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_REGION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'계산 생성';

wwv_flow_api.create_message (
  p_id=>197737918794155669 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_COMPUTATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로세스 생성';

wwv_flow_api.create_message (
  p_id=>197738001547155669 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_PROCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 생성';

wwv_flow_api.create_message (
  p_id=>197738118499155669 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_VALIDATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'분기 생성';

wwv_flow_api.create_message (
  p_id=>197738223755155669 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_BRANCH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0에 대한 암호가 변경되었습니다.';

wwv_flow_api.create_message (
  p_id=>197738308718155669 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_CHANGED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message email_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'전자 메일 주소 "%0"을(를) 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197738414266155670 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EMAIL_NOT_FOUND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message change_pw_request
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 요청';

wwv_flow_api.create_message (
  p_id=>197738526452155670 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHANGE_PW_REQUEST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_arrow_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'하향';

wwv_flow_api.create_message (
  p_id=>197738622989155670 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_ARROW_DOWN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추 생성';

wwv_flow_api.create_message (
  p_id=>197738732557155670 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_BUTTON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목 생성';

wwv_flow_api.create_message (
  p_id=>197738827954155670 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_ITEM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 제목';

wwv_flow_api.create_message (
  p_id=>197738928125155670 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_REGION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추 생성';

wwv_flow_api.create_message (
  p_id=>197739012720155671 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_BUTTON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_edit_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추 편집';

wwv_flow_api.create_message (
  p_id=>197739100339155671 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_EDIT_BUTTON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목 생성';

wwv_flow_api.create_message (
  p_id=>197739231515155671 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_ITEM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_edit_button_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추 항목 편집';

wwv_flow_api.create_message (
  p_id=>197739316179155671 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_EDIT_BUTTON_ITEM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_edit_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목 편집';

wwv_flow_api.create_message (
  p_id=>197739417997155671 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_EDIT_ITEM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_priv_on_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 작업 영역에는 %1 스키마를 실행할 수 있는 권한이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197739515163155671 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PRIV_ON_SCHEMA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_button_w_no_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역이 없는 단추';

wwv_flow_api.create_message (
  p_id=>197739616231155672 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BUTTON_W_NO_REGION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 페이지에 단추가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197739711805155672 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_BUTTON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 페이지에 항목이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197739817986155672 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ITEM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_item_exceeds_max
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목 수가 최대값인 100개를 초과합니다.';

wwv_flow_api.create_message (
  p_id=>197739903114155672 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ITEM_EXCEEDS_MAX',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 제목';

wwv_flow_api.create_message (
  p_id=>197740024154155672 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION_TITLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'편집';

wwv_flow_api.create_message (
  p_id=>197740118519155672 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_EDIT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_reset_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호 재설정 통지';

wwv_flow_api.create_message (
  p_id=>197740205533155673 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_RESET_NOTIFICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_expand
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'확장';

wwv_flow_api.create_message (
  p_id=>197740313198155673 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_EXPAND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message account_has_been_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 계정이 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197740423002155673 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCOUNT_HAS_BEEN_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_account_login_instructions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음으로 이동하여 %0에 로그인할 수 있음:';

wwv_flow_api.create_message (
  p_id=>197740520808155673 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_ACCOUNT_LOGIN_INSTRUCTIONS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'생성';

wwv_flow_api.create_message (
  p_id=>197740632461155673 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_account_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새 %0 계정 통지';

wwv_flow_api.create_message (
  p_id=>197740723000155674 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_ACCOUNT_NOTIFICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_create2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'생성';

wwv_flow_api.create_message (
  p_id=>197740828409155674 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CREATE2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'닫기';

wwv_flow_api.create_message (
  p_id=>197740918431155674 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CLOSE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 본문';

wwv_flow_api.create_message (
  p_id=>197741014283155674 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION_BODY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_form_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'폼 열기';

wwv_flow_api.create_message (
  p_id=>197741102710155674 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_FORM_OPEN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_form_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'폼 닫기';

wwv_flow_api.create_message (
  p_id=>197741226048155674 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_FORM_CLOSE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'도움말';

wwv_flow_api.create_message (
  p_id=>197741305235155675 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_HELP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'삭제';

wwv_flow_api.create_message (
  p_id=>197741401924155675 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_DELETE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'복사';

wwv_flow_api.create_message (
  p_id=>197741523509155675 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_COPY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음';

wwv_flow_api.create_message (
  p_id=>197741616190155675 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_NEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이전';

wwv_flow_api.create_message (
  p_id=>197741714332155675 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_PREVIOUS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_change
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'변경';

wwv_flow_api.create_message (
  p_id=>197741806026155675 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CHANGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트';

wwv_flow_api.create_message (
  p_id=>197741916054155675 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message themes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테마';

wwv_flow_api.create_message (
  p_id=>197742028114155676 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'THEMES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탐색 도구 모음';

wwv_flow_api.create_message (
  p_id=>197742107436155676 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_NAV_BAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'통지';

wwv_flow_api.create_message (
  p_id=>197742215868155676 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_NOTIFICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_global_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'전체 통지';

wwv_flow_api.create_message (
  p_id=>197742313647155676 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_GLOBAL_NOTIFICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_template_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트 본문';

wwv_flow_api.create_message (
  p_id=>197742400949155676 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_TEMPLATE_BODY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_success_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'성공 메시지';

wwv_flow_api.create_message (
  p_id=>197742525139155677 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_SUCCESS_MSG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제목';

wwv_flow_api.create_message (
  p_id=>197742619379155677 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_TITLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_body_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'본문 제목';

wwv_flow_api.create_message (
  p_id=>197742727077155677 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_BODY_TITLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region_position
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 위치';

wwv_flow_api.create_message (
  p_id=>197742800971155677 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION_POSITION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_std_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탭';

wwv_flow_api.create_message (
  p_id=>197742915443155677 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_STD_TAB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_parent_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상위 탭';

wwv_flow_api.create_message (
  p_id=>197743010927155677 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_PARENT_TAB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_application_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 탭';

wwv_flow_api.create_message (
  p_id=>197743125255155677 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_APPLICATION_TAB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_company_img
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역 이미지';

wwv_flow_api.create_message (
  p_id=>197743216554155678 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_COMPANY_IMG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'예';

wwv_flow_api.create_message (
  p_id=>197743319488155678 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_YES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'아니오';

wwv_flow_api.create_message (
  p_id=>197743422720155678 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_header_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'머리글 템플리트';

wwv_flow_api.create_message (
  p_id=>197743520621155678 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_HEADER_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'본문';

wwv_flow_api.create_message (
  p_id=>197743630187155678 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BODY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_footer_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'바닥글 템플리트';

wwv_flow_api.create_message (
  p_id=>197743700731155678 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FOOTER_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_substitution
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'대체';

wwv_flow_api.create_message (
  p_id=>197743802680155679 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_SUBSTITUTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_referenced
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'참조됨';

wwv_flow_api.create_message (
  p_id=>197743912529155679 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REFERENCED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'출처';

wwv_flow_api.create_message (
  p_id=>197744001969155679 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FROM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설명';

wwv_flow_api.create_message (
  p_id=>197744129263155679 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_DESCRIPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_onload
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Onload 페이지';

wwv_flow_api.create_message (
  p_id=>197744200593155680 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_ONLOAD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_title2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 제목';

wwv_flow_api.create_message (
  p_id=>197744316973155680 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TITLE2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_head
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 머리글';

wwv_flow_api.create_message (
  p_id=>197744405240155680 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_HEAD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_form_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML 폼 열기';

wwv_flow_api.create_message (
  p_id=>197744509228155680 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FORM_OPEN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_notification_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'통지 메시지';

wwv_flow_api.create_message (
  p_id=>197744626651155680 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NOTIFICATION_MSG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_success_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'성공 메시지';

wwv_flow_api.create_message (
  p_id=>197744701398155680 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_SUCCESS_MSG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 본문';

wwv_flow_api.create_message (
  p_id=>197744817697155680 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_BODY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_body_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 본문 제목';

wwv_flow_api.create_message (
  p_id=>197744921475155681 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_BODY_TITLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_form_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML 폼 닫기';

wwv_flow_api.create_message (
  p_id=>197745011433155681 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FORM_CLOSE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 위치 1';

wwv_flow_api.create_message (
  p_id=>197745118488155681 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 위치 2';

wwv_flow_api.create_message (
  p_id=>197745201850155681 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 위치 3';

wwv_flow_api.create_message (
  p_id=>197745310658155681 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS3',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 위치 4';

wwv_flow_api.create_message (
  p_id=>197745417852155681 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS4',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 위치 5';

wwv_flow_api.create_message (
  p_id=>197745530003155682 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS5',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 위치 6';

wwv_flow_api.create_message (
  p_id=>197745607570155682 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS6',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 위치 7';

wwv_flow_api.create_message (
  p_id=>197745719985155682 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS7',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 위치 8';

wwv_flow_api.create_message (
  p_id=>197745820016155682 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS8',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_detail_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세부 정보 보기';

wwv_flow_api.create_message (
  p_id=>197745909461155682 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_DETAIL_VIEW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업';

wwv_flow_api.create_message (
  p_id=>197746013053155682 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ACTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'조건';

wwv_flow_api.create_message (
  p_id=>197746130508155683 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_CONDITION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_exp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표현식';

wwv_flow_api.create_message (
  p_id=>197746222117155683 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_EXP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_display
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시';

wwv_flow_api.create_message (
  p_id=>197746311353155683 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_DISPLAY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_button2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추';

wwv_flow_api.create_message (
  p_id=>197746423396155683 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BUTTON2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지로 이동';

wwv_flow_api.create_message (
  p_id=>197746518339155683 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_redirect_to_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지로 이동';

wwv_flow_api.create_message (
  p_id=>197746628913155683 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REDIRECT_TO_PG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_navigate_to_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 페이지로 이동';

wwv_flow_api.create_message (
  p_id=>197746709248155683 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NAVIGATE_TO_PG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message views2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보기';

wwv_flow_api.create_message (
  p_id=>197746812049155684 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEWS2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_validation2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증';

wwv_flow_api.create_message (
  p_id=>197746907568155684 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_VALIDATION2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_process2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로세스';

wwv_flow_api.create_message (
  p_id=>197747018308155684 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PROCESS2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_computation2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'계산';

wwv_flow_api.create_message (
  p_id=>197747109677155684 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COMPUTATION2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_chart_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0별 차트';

wwv_flow_api.create_message (
  p_id=>197747227705155684 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_CHART_BY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0별';

wwv_flow_api.create_message (
  p_id=>197747311384155684 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_BY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역';

wwv_flow_api.create_message (
  p_id=>197747417435155685 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테마';

wwv_flow_api.create_message (
  p_id=>197747514790155685 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'THEME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_flow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션';

wwv_flow_api.create_message (
  p_id=>197747619147155685 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_FLOW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_paren_deprecated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(사용되지 않음)';

wwv_flow_api.create_message (
  p_id=>197747732388155685 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PAREN_DEPRECATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_scheme_convert
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 인증은 사용되지 않는 방식입니다. 이 애플리케이션의 인증 체계 중 하나에서 "현재로 설정" 링크(위에 표시됨)를 누르거나, 새 인증 체계를 생성하여 현재로 설정할 것을 권장합니다. INTERNAL-SETUP 인증 체계는 기능면에서 %0 방식과 같습니다.';

wwv_flow_api.create_message (
  p_id=>197747806760155685 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_SCHEME_CONVERT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용되지 않는 인증 속성 편집';

wwv_flow_api.create_message (
  p_id=>197747912968155685 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용되지 않는 속성';

wwv_flow_api.create_message (
  p_id=>197748028280155686 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'또는 인증 방식을 %0(으)로 변경할 준비가 될 때까지 그대로 두십시오.';

wwv_flow_api.create_message (
  p_id=>197748114592155686 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED3',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세션 관리 속성 검토 또는 편집'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197748215745155686 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW5',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 체계를 사용하여 애플리케이션에 대한 사용자 인증 및 다른 모든 세션 관리 요소를 제어합니다.';

wwv_flow_api.create_message (
  p_id=>197748329162155686 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_SCHEME_DESC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'하나 이상의 사용되지 않는 인증 속성을 지정합니다.';

wwv_flow_api.create_message (
  p_id=>197748408963155686 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED4',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'해당 항목 검토 또는 편집';

wwv_flow_api.create_message (
  p_id=>197748516405155686 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW6',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'또는 인증 체계로 이전하십시오.';

wwv_flow_api.create_message (
  p_id=>197748603529155687 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED5',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message month
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'월';

wwv_flow_api.create_message (
  p_id=>197748720918155687 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MONTH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p13_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'버전';

wwv_flow_api.create_message (
  p_id=>197748820171155687 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P13_VERSION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p13_dbname
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 이름';

wwv_flow_api.create_message (
  p_id=>197748905571155687 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P13_DBNAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p13_linked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'링크됨';

wwv_flow_api.create_message (
  p_id=>197749019228155687 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P13_LINKED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_as_app_on_exist_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 테이블의 애플리케이션으로';

wwv_flow_api.create_message (
  p_id=>197749112292155687 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_AS_APP_ON_EXIST_TABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_show_xml
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'XML 표시';

wwv_flow_api.create_message (
  p_id=>197749218326155688 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.SHOW_XML',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_determine_query_headings
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'질의 머리글을 확인할 수 없음:'||chr(10)||
'%0';

wwv_flow_api.create_message (
  p_id=>197749304130155688 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_DETERMINE_QUERY_HEADINGS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_determine_pagination
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 번호 매김 문자열을 확인하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197749405951155688 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_DETERMINE_PAGINATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_report_footer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 바닥글을 바꾸는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197749522265155688 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_REPORT_FOOTER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_proc_function_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'질의를 반환하는 함수 본문을 처리할 수 없음:'||chr(10)||
'%0';

wwv_flow_api.create_message (
  p_id=>197749630112155688 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_PROC_FUNCTION_BODY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_failed_parsing_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 질의 구문 분석 실패:'||chr(10)||
'%0'||chr(10)||
'%1';

wwv_flow_api.create_message (
  p_id=>197749717113155688 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.FAILED_PARSING_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_report_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 오류:'||chr(10)||
'%0';

wwv_flow_api.create_message (
  p_id=>197749805254155689 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.REPORT_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_invalid_lov_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'팝업 값 목록 질의가 부적합합니다. 표시 값과 반환 값이 필요하며 열 이름이 달라야 합니다.';

wwv_flow_api.create_message (
  p_id=>197749915999155689 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.INVALID_LOV_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_new_category
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- 새 범주 -';

wwv_flow_api.create_message (
  p_id=>197750028899155689 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NEW_CATEGORY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_no_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(편집할 수 없음)';

wwv_flow_api.create_message (
  p_id=>197750114303155689 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_NO_EDIT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_current
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'현재';

wwv_flow_api.create_message (
  p_id=>197750227847155689 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_CURRENT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_flash_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'플래시 차트를 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197750325381155689 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FLASH_CHART',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p2_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합';

wwv_flow_api.create_message (
  p_id=>197750401193155690 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P2_INVALID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p2_included
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'포함됨';

wwv_flow_api.create_message (
  p_id=>197750521361155690 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P2_INCLUDED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p2_databases
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스';

wwv_flow_api.create_message (
  p_id=>197750619583155690 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P2_DATABASES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_lov_no_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- 체계 없음 -';

wwv_flow_api.create_message (
  p_id=>197750711833155690 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_LOV_NO_SCHEME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message initcap_refresh
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새로 고침';

wwv_flow_api.create_message (
  p_id=>197750817744155690 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INITCAP_REFRESH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message y
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Y';

wwv_flow_api.create_message (
  p_id=>197750932596155690 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'Y',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_schema_not_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션의 구문 분석 스키마 "%0"이(가) 데이터베이스에 존재하지 않습니다.';

wwv_flow_api.create_message (
  p_id=>197751007747155691 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SCHEMA_NOT_EXISTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열기:';

wwv_flow_api.create_message (
  p_id=>197751111043155691 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.OPEN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4790_date_timestamp_note
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(날짜 또는 시간 스탬프 열 포함)';

wwv_flow_api.create_message (
  p_id=>197751209309155691 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P4790_DATE_TIMESTAMP_NOTE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_bipub_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인쇄 지원은 STANDARD 또는 ADVANCED여야 합니다.';

wwv_flow_api.create_message (
  p_id=>197751331053155691 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_BIPUB_OPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_first_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'등록된 첫번째 스키마를 제거할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197751404714155691 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_FIRST_SCHEMA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_invalid_port
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 포트 번호';

wwv_flow_api.create_message (
  p_id=>197751501540155691 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_INVALID_PORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_invalid_wallet
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'전자 지갑 경로는 file:<filesystempath> 형식이어야 합니다.';

wwv_flow_api.create_message (
  p_id=>197751611973155692 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_INVALID_WALLET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_parm_notfound
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인스턴스 매개변수를 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197751724798155692 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_PARM_NOTFOUND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_builtin_login_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내장 로그인 페이지';

wwv_flow_api.create_message (
  p_id=>197751816121155692 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_BUILTIN_LOGIN_PG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_page_in_this_flow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션의 페이지';

wwv_flow_api.create_message (
  p_id=>197751903984155692 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_PAGE_IN_THIS_FLOW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL';

wwv_flow_api.create_message (
  p_id=>197752024951155692 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_URL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_sso_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On';

wwv_flow_api.create_message (
  p_id=>197752124642155692 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_SSO_SERVER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'없음';

wwv_flow_api.create_message (
  p_id=>197752225551155693 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_NONE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_auth_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 계정 사용자 이름 및 암호를 사용하여 인증하십시오.';

wwv_flow_api.create_message (
  p_id=>197752316937155693 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_AUTH_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_no_verify_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'증명서 확인 안함';

wwv_flow_api.create_message (
  p_id=>197752416429155693 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_NO_VERIFY_CRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_use_ldap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 서버를 사용하여 인증합니다.';

wwv_flow_api.create_message (
  p_id=>197752503243155693 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_USE_LDAP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_use_custom
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내 사용자 정의 함수를 사용하여 인증합니다.';

wwv_flow_api.create_message (
  p_id=>197752607954155693 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_USE_CUSTOM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p815_scratch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새로 만들기';

wwv_flow_api.create_message (
  p_id=>197752701086155693 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P815_SCRATCH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p815_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기존 인증 체계의 복사본으로';

wwv_flow_api.create_message (
  p_id=>197752806773155694 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P815_COPY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p815_gallery
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'갤러리의 미리 구성된 체계를 기준으로 함';

wwv_flow_api.create_message (
  p_id=>197752922970155694 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P815_GALLERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_use_dad
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 없음(DAD 사용)';

wwv_flow_api.create_message (
  p_id=>197753007641155694 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_USE_DAD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_moc_sso
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SSO 쿠키(my.oracle.com -- Oracle 전용)';

wwv_flow_api.create_message (
  p_id=>197753109186155694 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_MOC_SSO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_show_account_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그인 페이지 표시 및 %0 계정 증명서 사용';

wwv_flow_api.create_message (
  p_id=>197753211002155694 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SHOW_ACCOUNT_CRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_show_builtin_pg_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내장 로그인 페이지 표시 및 공개 증명서 사용';

wwv_flow_api.create_message (
  p_id=>197753315424155694 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SHOW_BUILTIN_PG_OPEN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_show_use_ldap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그인 페이지 표시 및 LDAP 디렉토리 증명서 사용';

wwv_flow_api.create_message (
  p_id=>197753405402155694 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SHOW_USE_LDAP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_sso_htmldb_partner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On(%0 엔진을 협력 애플리케이션으로)';

wwv_flow_api.create_message (
  p_id=>197753518352155695 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SSO_HTMLDB_PARTNER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_my_partner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On(내 애플리케이션을 협력 애플리케이션으로)';

wwv_flow_api.create_message (
  p_id=>197753632024155695 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_MY_PARTNER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새로 만들기';

wwv_flow_api.create_message (
  p_id=>197753722580155695 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_NEW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_printsvr_protocol
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인쇄 서버 프로토콜은 http 또는 https여야 합니다.';

wwv_flow_api.create_message (
  p_id=>197753803799155695 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_PRINTSVR_PROTOCOL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_schema_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스키마가 존재하지 않습니다.';

wwv_flow_api.create_message (
  p_id=>197753920702155695 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_SCHEMA_EXISTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_schema_restricted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제한된 스키마입니다.';

wwv_flow_api.create_message (
  p_id=>197754017568155695 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_SCHEMA_RESTRICTED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_admin_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'액세스 제어 - 관리자';

wwv_flow_api.create_message (
  p_id=>197754122004155696 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_ADMIN_AUTH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_edit_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'액세스 제어 - 편집';

wwv_flow_api.create_message (
  p_id=>197754222404155696 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_EDIT_AUTH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_view_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'액세스 제어 - 보기';

wwv_flow_api.create_message (
  p_id=>197754327296155696 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_VIEW_AUTH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_service_admin_link_p1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'INTERNAL 작업 영역의 계정은 다음 용도로만 사용될 수 있음';

wwv_flow_api.create_message (
  p_id=>197754405096155696 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SERVICE_ADMIN_LINK_P1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_service_admin_link_p2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 서비스 관리';

wwv_flow_api.create_message (
  p_id=>197754515040155696 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SERVICE_ADMIN_LINK_P2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_domain_index_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'선택된 %0에 도메인 인덱스가 있습니다. DDL 생성은 도메인 인덱스에 대한 DDL을 생성할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197754606076155696 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.DOMAIN_INDEX_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_unsupported_data_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'지원되지 않는 데이터 유형';

wwv_flow_api.create_message (
  p_id=>197754717087155697 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_UNSUPPORTED_DATA_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_exclude_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'널 값 제외';

wwv_flow_api.create_message (
  p_id=>197754807191155697 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_EXCLUDE_NULL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_displayed_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시된 열';

wwv_flow_api.create_message (
  p_id=>197754924692155697 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DISPLAYED_COLUMNS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_all_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모든 열';

wwv_flow_api.create_message (
  p_id=>197755026149155697 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ALL_COLUMNS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_cannot_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'본인은 스스로 삭제할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197755110106155697 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CANNOT_DELETE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_cannot_remove_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스스로 관리자 권한을 제거할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197755225519155697 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_chart_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'차트 유형';

wwv_flow_api.create_message (
  p_id=>197755326758155698 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CHART_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_hcolumn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'수평 막대';

wwv_flow_api.create_message (
  p_id=>197755423969155698 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HCOLUMN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_vcolumn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'수직 막대';

wwv_flow_api.create_message (
  p_id=>197755501693155698 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_VCOLUMN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_pie
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'파이';

wwv_flow_api.create_message (
  p_id=>197755608027155698 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_PIE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_line
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'행';

wwv_flow_api.create_message (
  p_id=>197755717984155698 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LINE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_3d
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'3D';

wwv_flow_api.create_message (
  p_id=>197755800951155698 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_3D',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'레이블';

wwv_flow_api.create_message (
  p_id=>197755902528155699 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LABEL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_aggregate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'집계';

wwv_flow_api.create_message (
  p_id=>197756006395155699 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGGREGATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_do_not_aggregate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- 집계 안함 -';

wwv_flow_api.create_message (
  p_id=>197756115422155699 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DO_NOT_AGGREGATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_date
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'날짜';

wwv_flow_api.create_message (
  p_id=>197756202880155699 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_display
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시';

wwv_flow_api.create_message (
  p_id=>197756319586155699 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DISPLAY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- 함수 선택 -';

wwv_flow_api.create_message (
  p_id=>197756420718155699 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_FUNCTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_public
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'공용';

wwv_flow_api.create_message (
  p_id=>197756526922155700 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_PUBLIC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_delete_confirm
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 보고서 설정을 삭제하겠습니까?';

wwv_flow_api.create_message (
  p_id=>197756616214155700 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DELETE_CONFIRM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_reset_confirm
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서를 기본 설정으로 복원합니다.';

wwv_flow_api.create_message (
  p_id=>197756726150155700 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_RESET_CONFIRM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_dup_username
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'중복된 사용자 이름을 입력할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197756817823155700 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_DUP_USERNAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 세션 동안 사용자 식별자로 사용할 문자열을 입력하십시오.';

wwv_flow_api.create_message (
  p_id=>197756916311155700 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 사용자 이름 및 암호를 입력하십시오.';

wwv_flow_api.create_message (
  p_id=>197757008825155700 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP 호스트에서 확인을 위한 사용자 이름 및 암호 입력: %0.';

wwv_flow_api.create_message (
  p_id=>197757118157155701 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_3',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 스키마 사용자 이름 및 암호를 입력하십시오.';

wwv_flow_api.create_message (
  p_id=>197757203410155701 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_4',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_dial_chart_query_syntax_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 차트 질의: %0<br /><br /> 다음 구문을 사용하십시오. <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr>'||chr(10)||
'<td>VALUE</td>'||chr(10)||
'<td>다이얼 값을 정의하는 숫자 열입니다.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>MAX</td>'||chr(10)||
'<td>최대 다이얼 값을 정의하는 숫자 열입니다.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>LOW(선택 사항)</td>'||chr(10)||
'<td>이전 최소 다이얼 값을 정의하는 숫자 열입니다.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>HIGH(선택 사항)</td>'||chr(10)||
'<td>이전 최대 다이얼 값을 정의하는 숫자 열입니다.</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>197757301500155701 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_dup_page_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류 페이지=%0, 항목="%1", ID="%2"에 기존 애플리케이션 레벨 항목과 동일한 이름이 있습니다.';

wwv_flow_api.create_message (
  p_id=>197757403588155701 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_DUP_PAGE_ITEM_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_between
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 사이';

wwv_flow_api.create_message (
  p_id=>197757508405155701 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_BETWEEN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_cursor_not_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'질의 구문을 분석할 수 없습니다. 커서가 아직 열리지 않았거나, SQL 질의를 반환하는 함수가 값 없이 반환되었습니다.';

wwv_flow_api.create_message (
  p_id=>197757611825155701 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.CURSOR_NOT_OPEN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_query_cannot_be_parsed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 질의를 반환하는 함수: 작성기 내에서 질의 구문을 분석할 수 없습니다. 질의 구문이 정확한 경우 영역 소스 아래의 <b>일반 열</b> 체크 박스를 선택하여 구문 분석 없이 계속하십시오.'||chr(10)||
'<br />'||chr(10)||
'(%0)';

wwv_flow_api.create_message (
  p_id=>197757714162155702 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.QUERY_CANNOT_BE_PARSED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_use_column_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'질의 열 #%0(%1)이(가) 부적합합니다. 열 별칭을 사용하십시오.';

wwv_flow_api.create_message (
  p_id=>197757824015155702 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.USE_COLUMN_ALIAS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_html_use_column_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'질의 열 #%0(%1)이(가) 부적합합니다. HTML을 사용하는 열에는 별칭 이름이 필요합니다.';

wwv_flow_api.create_message (
  p_id=>197757923122155702 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.HTML_USE_COLUMN_ALIAS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_syntax_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>질의 구문을 분석할 수 없습니다. 질의 구문을 확인하십시오.'||chr(10)||
'(%0)'||chr(10)||
'</p>';

wwv_flow_api.create_message (
  p_id=>197758024722155702 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.SYNTAX_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_syntax_error2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>작성기 내에서 질의 구문을 분석할 수 없습니다. 질의 구문이 정확한 경우 영역 소스 아래에 있는 "일반 열" 확인란을 선택하여 구문 분석 없이 계속하십시오.'||chr(10)||
'%0</p>';

wwv_flow_api.create_message (
  p_id=>197758126449155702 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.SYNTAX_ERROR2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_apply
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'적용';

wwv_flow_api.create_message (
  p_id=>197758229734155702 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_APPLY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_migrate_svg_restriction
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SVG 차트를 이전할 때는 다음과 같은 제한 사항이 있습니다.  '||chr(10)||
'<ul>'||chr(10)||
'<li>'||chr(10)||
'축 형식 문자열에 정의된 숫자 형식만 이전됩니다. 날짜 및 시간 형식은 무시됩니다.'||chr(10)||
'</li>'||chr(10)||
'<li>'||chr(10)||
'다음을 포함하는 숫자 형식 요소만 이전됩니다.'||chr(10)||
'<br />'||chr(10)||
'0,9,D,G,, (콤마),. (마침표),$,C,L,FM'||chr(10)||
'</li>'||chr(10)||
'<li>'||chr(10)||
'플래시 차트의 각 시리즈에 대한 레이블은 각 시리즈의 열 별칭에서 파생됩니다.  '||chr(10)||
'이는 각 시리즈의 레이블이 시리즈 이름 속성에서 파생되는 SVG 차트와 다릅니다.'||chr(10)||
'</li>'||chr(10)||
'<li>'||chr(10)||
'플래시 다이얼 차트는 백분율 대신 실제 값을 표시합니다.'||chr(10)||
'</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_message (
  p_id=>197758317963155703 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MIGRATE_SVG_RESTRICTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'닫기:';

wwv_flow_api.create_message (
  p_id=>197758410123155703 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.CLOSE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_high
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'높음:';

wwv_flow_api.create_message (
  p_id=>197758532134155703 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.HIGH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_low
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'낮음';

wwv_flow_api.create_message (
  p_id=>197758608682155703 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.LOW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message monthly
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'월별';

wwv_flow_api.create_message (
  p_id=>197758707319155703 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MONTHLY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message weekly
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'주별';

wwv_flow_api.create_message (
  p_id=>197758827576155703 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEEKLY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message daily
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'일별';

wwv_flow_api.create_message (
  p_id=>197758927224155704 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DAILY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'< 이전';

wwv_flow_api.create_message (
  p_id=>197759016134155704 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR.PREVIOUS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 >';

wwv_flow_api.create_message (
  p_id=>197759129079155704 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR.NEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message p4111_used_on_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 값 목록은 %0 페이지에서 사용됩니다. 삭제하겠습니까? ';

wwv_flow_api.create_message (
  p_id=>197759201099155704 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'P4111_USED_ON_PAGES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_create_ws_sec_violation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역을 설치하는 중 두번째 create_company 호출이 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197759311869155704 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.CREATE_WS_SEC_VIOLATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_to_is_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'메일을 전송하려면 메시지 받는 사람을 입력해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197759432533155704 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.TO_IS_REQUIRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message must_be_xsl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 레이아웃 파일의 파일 유형이 ''.xsl''을 파일 확장자로 사용하는 XSL-FO인지 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197759509366155705 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MUST_BE_XSL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message your_email_iuws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'전자 메일 주소가 다음 작업 영역에 사용자로 등록되어 있음:';

wwv_flow_api.create_message (
  p_id=>197759623126155705 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'YOUR_EMAIL_IUWS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_workspace_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역 홈';

wwv_flow_api.create_message (
  p_id=>197759720759155705 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WORKSPACE_HOME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_workspace_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역 로그인';

wwv_flow_api.create_message (
  p_id=>197759820049155705 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WORKSPACE_LOGIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dynamic_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'대화식 보고서';

wwv_flow_api.create_message (
  p_id=>197759901344155705 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DYNAMIC_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_templates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트';

wwv_flow_api.create_message (
  p_id=>197760004693155705 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TEMPLATES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'값 목록';

wwv_flow_api.create_message (
  p_id=>197760108947155706 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_LOV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용된 공유 값 목록이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197760217087155706 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_LOV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용된 템플리트가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197760310655155706 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message button_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추 숫자 식별자';

wwv_flow_api.create_message (
  p_id=>197760426623155706 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUTTON_ID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 차트 질의: %0<br /><br />'||chr(10)||
'다음 구문을 사용하십시오.'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'또는 다중 시리즈를 반환하는 질의에는 다음 구문을 사용하십시오.'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE1 [, VALUE2 [, VALUE3...]]'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>차트 축에 표시되는 텍스트입니다.</td></tr>'||chr(10)||
'<tr><td>VALUE1, VALUE2, VALUE3...</td><td>데이터 값을 정의하는 숫자 열입니다.</td></tr>'||chr(10)||
'</tab';

h:=h||'le>'||chr(10)||
'참고: 막대 차트 및 선 차트의 시리즈 이름은 질의에 사용되는 열 별칭에서 파생됩니다.';

wwv_flow_api.create_message (
  p_id=>197760526243155706 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_CHART_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_scatter_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 산포 차트 질의: %0<br><br>'||chr(10)||
'다음 구문을 사용하십시오.'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, X_VALUE, Y_VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>힌트에 표시되는 텍스트입니다.</td></tr>'||chr(10)||
'<tr><td>X_VALUE</td><td>X 좌표 값을 지정하는 숫자 열입니다.</td></tr>'||chr(10)||
'<tr><td>Y_VALUE</td><td>Y 좌표 값을 지정하는 숫자 열입니다.</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>197760628057155707 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_SCATTER_CHART_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_range_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 범위 차트 질의: %0<br><br>'||chr(10)||
'다음 구문을 사용하십시오.'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, OPEN_VALUE, CLOSE_VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>차트 축에 표시되는 텍스트입니다.</td></tr>'||chr(10)||
'<tr><td>OPEN_VALUE</td><td>범위 시작을 지정하는 숫자 열입니다.</td></tr>'||chr(10)||
'<tr><td>CLOSE_VALUE</td><td>범위 끝을 지정하는 숫자 열입니다.</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>197760712669155707 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_RANGE_CHART_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_candlestick_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 촛대 차트 질의: %0<br /><br />'||chr(10)||
'다음 구문을 사용하십시오.'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, OPEN, HIGH, LOW, CLOSE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>차트 축에 표시되는 텍스트입니다.</td></tr>'||chr(10)||
'<tr><td>OPEN</td><td>촛대의 시작을 지정하는 숫자 열입니다.</td></tr>'||chr(10)||
'<tr><td>HIGH</td><td>촛대의 최대값을 지정하는 숫자 열입니다.</td></tr>'||chr(10)||
'<tr><td>LOW</td><td>촛대의 최소값을 지정하는 숫자 열입니다.</td></tr>'||chr(10)||
'<tr><td>CL';

h:=h||'OSE</td><td>촛대의 끝을 지정하는 숫자 열입니다.</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>197760810318155707 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_CANDLESTICK_CHART_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_dial_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 다이얼 차트 질의: %0<br /><br /> 다음 구문을 사용하십시오.'||chr(10)||
'<pre> SELECT VALUE, MAX [, LOW, HIGH] VALUE FROM ... </pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr>'||chr(10)||
'<td>VALUE</td>'||chr(10)||
'<td>다이얼 값을 정의하는 숫자 열입니다.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>MAX</td>'||chr(10)||
'<td>최대 다이얼 값을 정의하는 숫자 열입니다.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>LOW(선택 사항)</td>'||chr(10)||
'<td>다이얼에 표시되는 범위의 최소값을 정의하는 숫자 열입니다.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>HIGH(선택 사항)</td>'||chr(10)||
'<td>다이얼에 표시되는 범위의 최대값을 정의하는 숫자 열입니다. 이 값이 정의되면 LOW';

h:=h||' 값도 반드시 지정해야 합니다.</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'이 질의는 한 행만 반환해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197760915611155707 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_DIAL_CHART_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_pie_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 차트 질의: %0<br><br>'||chr(10)||
'다음 구문을 사용하십시오.'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>범례 텍스트, 힌트 텍스트 및 파이 조각 레이블에 표시되는 텍스트입니다.</td></tr>'||chr(10)||
'<tr><td>VALUE</td><td>데이터 값을 정의하는 숫자 열입니다.</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>197761006396155707 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_PIE_CHART_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message drag_and_drop
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'끌어 놓기';

wwv_flow_api.create_message (
  p_id=>197761129429155707 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRAG_AND_DROP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_add_attachment_parameter_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 매개변수에 대해 널 값이 제공되었습니다.';

wwv_flow_api.create_message (
  p_id=>197761230157155708 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.ADD_ATTACHMENT.PARAMETER_NULL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_add_attachment_invalid_mail_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'p_mail_id 매개변수에 부적합한 값: %0';

wwv_flow_api.create_message (
  p_id=>197761329163155708 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.ADD_ATTACHMENT.INVALID_MAIL_ID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_category
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'범주';

wwv_flow_api.create_message (
  p_id=>197761415826155708 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CATEGORY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설명';

wwv_flow_api.create_message (
  p_id=>197761519547155708 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DESCRIPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_sec_violation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'익스포트 파일의 대형 블록 내에서 remove_page 프로시저에 대한 API 호출이 감지되었습니다.';

wwv_flow_api.create_message (
  p_id=>197761617186155708 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.SEC_VIOLATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_fmb_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Forms 이전 프로젝트에 업로드하려고 시도한 파일이 적합한 Forms 모듈(_fmb.XML) 파일이 아닙니다. Oracle Forms에 포함된 Forms2XML 변환 툴로 생성된 Forms 모듈 XML 파일만 업로드할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197761700572155708 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_FMB_CONTENT_INVALID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_rpt_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Forms 이전 프로젝트에 업로드하려고 시도한 파일이 적합한 보고서(.XML) 파일이 아닙니다. Oracle Reports Builder에 포함된 파일 변환 유틸리티로 생성된 보고서 XML 파일만 업로드할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197761815874155709 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_RPT_CONTENT_INVALID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL: http(s)://domain/path/doc.(pdf)(html)(등...)';

wwv_flow_api.create_message (
  p_id=>197761905967155709 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_URL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_ip
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'IP 주소';

wwv_flow_api.create_message (
  p_id=>197762012251155709 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_IP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'전화 번호, 미국: %0';

wwv_flow_api.create_message (
  p_id=>197762131341155709 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'전화 번호, 미국(자유 형식): 999.999.9999, (999)-999-9999, 999 999 9999, 등...';

wwv_flow_api.create_message (
  p_id=>197762211991155709 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_zip
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'우편 번호: 99999';

wwv_flow_api.create_message (
  p_id=>197762331004155710 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_ZIP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_zip2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ZIP + 4: 99999-9999';

wwv_flow_api.create_message (
  p_id=>197762413181155710 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_ZIP2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'날짜: %0';

wwv_flow_api.create_message (
  p_id=>197762502062155710 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'변동 가능한 날짜: %0(임의의 구분 기호 사용)';

wwv_flow_api.create_message (
  p_id=>197762616303155710 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_url_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 URL';

wwv_flow_api.create_message (
  p_id=>197762703159155710 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_URL_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_ip_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 IP 주소';

wwv_flow_api.create_message (
  p_id=>197762817098155710 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_IP_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'전화 번호는 %0 형식이어야 합니다.';

wwv_flow_api.create_message (
  p_id=>197762923165155710 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone2_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'전화 번호 형식을 인식할 수 없음';

wwv_flow_api.create_message (
  p_id=>197763002277155711 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE2_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_zip_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'우편 번호는 %0 형식이어야 함';

wwv_flow_api.create_message (
  p_id=>197763108116155711 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_ZIP_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'날짜는 %0 형식이어야 함';

wwv_flow_api.create_message (
  p_id=>197763223379155711 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date2_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'날짜 형식을 인식할 수 없음';

wwv_flow_api.create_message (
  p_id=>197763312000155711 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE2_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_curr_warn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'경고: 이 애플리케이션에 대한 현재 인증 체계를 삭제하려고 합니다!';

wwv_flow_api.create_message (
  p_id=>197763420224155711 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_CURR_WARN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_custom_auth_func_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 애플리케이션에서 사용자 정의 인증 함수를 실행할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197763501580155711 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.CUSTOM_AUTH_FUNC_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_custom_auth_fetch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 애플리케이션에서 사용자 정의 인증 함수 본문을 인출할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197763608511155712 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.CUSTOM_AUTH_FETCH_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_auth_scheme_fetch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 애플리케이션에서 authentication_scheme을 인출할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197763709059155712 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.AUTH_SCHEME_FETCH_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_auth_pg_sentry_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 애플리케이션에서 페이지 감시를 실행할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197763801564155712 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.AUTH_PG_SENTRY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_auth_sess_verify_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'플러그인 세션을 실행할 수 없습니다. %0 애플리케이션의 인증 체계에서 함수를 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197763913389155712 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.AUTH_SESS_VERIFY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_sso_pkg_missing1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'WWSEC_SSO_ENABLER_PRIVATE 패키지가 존재하지 않거나 부적합합니다.';

wwv_flow_api.create_message (
  p_id=>197764031578155712 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.SSO_PKG_MISSING1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_sso_pkg_missing2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 관리자에게 Oracle Application Server Single Sign-On 엔진 구성을 요청하십시오.';

wwv_flow_api.create_message (
  p_id=>197764111699155712 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.SSO_PKG_MISSING2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_sso_pkg_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_custom_auth_sso.portal_sso_redirect를 실행하는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197764208601155713 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.SSO_PKG_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_api_deep_link_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 세션에 대한 remember_deep_link에 예상치 않은 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197764309953155713 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_API.DEEP_LINK_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_dup_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0에 대해 중복된 사용자 이름이 발견되었습니다.';

wwv_flow_api.create_message (
  p_id=>197764422881155713 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.DUP_USER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_load_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자를 로드하는 중 오류가 발생했습니다. %0 사용자에 대해 실패했습니다.';

wwv_flow_api.create_message (
  p_id=>197764520667155713 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.LOAD_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_mmb_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Forms 이전 프로젝트에 업로드하려고 시도한 파일이 적합한 Forms 메뉴(_mmb.XML) 파일이 아닙니다. Oracle Forms에 포함된 Forms2XML 변환 툴로 생성된 Forms 메뉴 XML 파일만 업로드할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197764631747155713 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_MMB_CONTENT_INVALID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_x_y_of_z
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0-%1/%2 행';

wwv_flow_api.create_message (
  p_id=>197764720163155713 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.X_Y_OF_Z',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_found_but_not_displayed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'요청된 최소 행: %0, 검색되었지만 표시되지 않은 행: %1';

wwv_flow_api.create_message (
  p_id=>197764804236155714 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.FOUND_BUT_NOT_DISPLAYED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_x_y_of_more_than_z
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0-%1/ %2행 초과';

wwv_flow_api.create_message (
  p_id=>197764928062155714 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.X_Y_OF_MORE_THAN_Z',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션';

wwv_flow_api.create_message (
  p_id=>197765025410155714 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지';

wwv_flow_api.create_message (
  p_id=>197765132253155714 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 이름';

wwv_flow_api.create_message (
  p_id=>197765231325155714 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGE_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 제목';

wwv_flow_api.create_message (
  p_id=>197765319445155714 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REGION_TITLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탭 집합';

wwv_flow_api.create_message (
  p_id=>197765405379155715 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TAB_SET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탭 레이블';

wwv_flow_api.create_message (
  p_id=>197765504646155715 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TAB_LABEL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_table_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블 소유자';

wwv_flow_api.create_message (
  p_id=>197765616808155715 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABLE_OWNER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블 이름';

wwv_flow_api.create_message (
  p_id=>197765713642155715 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABLE_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열';

wwv_flow_api.create_message (
  p_id=>197765814181155715 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COLUMNS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_updateable_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'갱신 가능한 열';

wwv_flow_api.create_message (
  p_id=>197765922523155715 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UPDATEABLE_COLUMNS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_primary_key
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본 키 %0';

wwv_flow_api.create_message (
  p_id=>197766002532155715 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PRIMARY_KEY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_page_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 제목';

wwv_flow_api.create_message (
  p_id=>197766116341155716 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGE_TITLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_no_tabset_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 페이지에 대해 선택된 탭 집합이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197766206632155716 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NO.TABSET.SELECTED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_new_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새 탭 집합 "%0"이(가) 생성되어 이 페이지에 의해 사용됩니다.';

wwv_flow_api.create_message (
  p_id=>197766325661155716 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE.NEW.TABSET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_use_existing_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 페이지는 기존 탭 집합 "%0"을(를) 사용합니다.';

wwv_flow_api.create_message (
  p_id=>197766423728155716 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.USE.EXISTING.TABSET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tabset_incomplete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'경고: 탭 집합 정보가 불완전합니다.';

wwv_flow_api.create_message (
  p_id=>197766509333155716 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABSET.INCOMPLETE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상위 탭 집합';

wwv_flow_api.create_message (
  p_id=>197766619091155716 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_TAB_SET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상위 탭 레이블';

wwv_flow_api.create_message (
  p_id=>197766724010155717 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_TAB_LABEL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트 없음';

wwv_flow_api.create_message (
  p_id=>197766802473155717 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NO_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목';

wwv_flow_api.create_message (
  p_id=>197766915346155717 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ITEMS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 템플리트';

wwv_flow_api.create_message (
  p_id=>197767019302155717 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REGION_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_information_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정보 템플리트';

wwv_flow_api.create_message (
  p_id=>197767129951155717 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INFORMATION_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_information_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정보 기본 텍스트';

wwv_flow_api.create_message (
  p_id=>197767225707155717 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INFORMATION_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 단추 표시 텍스트';

wwv_flow_api.create_message (
  p_id=>197767332626155718 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.BUTTON_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_button_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 단추 분기';

wwv_flow_api.create_message (
  p_id=>197767429695155718 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.BUTTON_BRANCH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_suggested_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'권장 이름';

wwv_flow_api.create_message (
  p_id=>197767501101155718 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SUGGESTED_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_actual_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'실제 이름';

wwv_flow_api.create_message (
  p_id=>197767603301155718 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ACTUAL_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_new_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새 템플리트';

wwv_flow_api.create_message (
  p_id=>197767710297155718 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NEW_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_display_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시 열';

wwv_flow_api.create_message (
  p_id=>197767819344155718 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DISPLAY_COLUMNS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_process_options
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로세스 옵션';

wwv_flow_api.create_message (
  p_id=>197767905658155719 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PROCESS_OPTIONS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'소유자';

wwv_flow_api.create_message (
  p_id=>197768011746155719 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.OWNER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_stored_procedure_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내장 프로시저 이름';

wwv_flow_api.create_message (
  p_id=>197768119109155719 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.STORED_PROCEDURE_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 질의';

wwv_flow_api.create_message (
  p_id=>197768226368155719 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SQL_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'차트 질의';

wwv_flow_api.create_message (
  p_id=>197768319418155719 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_axis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'차트 축';

wwv_flow_api.create_message (
  p_id=>197768424021155719 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_AXIS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_scale
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'소수점 이하 자릿수';

wwv_flow_api.create_message (
  p_id=>197768502153155720 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_SCALE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_number_mask
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'숫자 마스크';

wwv_flow_api.create_message (
  p_id=>197768605984155720 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_NUMBER_MASK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'차트 유형';

wwv_flow_api.create_message (
  p_id=>197768725198155720 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'차트 제목';

wwv_flow_api.create_message (
  p_id=>197768803557155720 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_TITLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'차트 크기';

wwv_flow_api.create_message (
  p_id=>197768913833155720 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_SIZE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_vertical_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'수직 막대';

wwv_flow_api.create_message (
  p_id=>197769029841155720 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_VERTICAL_BAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_horizontal_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'수평 막대';

wwv_flow_api.create_message (
  p_id=>197769120412155721 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_HORIZONTAL_BAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_pie
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'파이';

wwv_flow_api.create_message (
  p_id=>197769213113155721 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_PIE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_line
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'행';

wwv_flow_api.create_message (
  p_id=>197769303991155721 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_LINE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_scatter
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'산포';

wwv_flow_api.create_message (
  p_id=>197769404148155721 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_SCATTER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_insert_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'삽입';

wwv_flow_api.create_message (
  p_id=>197769513712155721 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INSERT_PROCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_update_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'갱신';

wwv_flow_api.create_message (
  p_id=>197769605765155721 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UPDATE_PROCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_delete_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'삭제';

wwv_flow_api.create_message (
  p_id=>197769722700155722 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DELETE_PROCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_tabular_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 표 형식 폼 페이지를 작성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197769823762155722 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_TABULAR_FORM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 페이지를 작성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197769909651155722 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_wizard
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 마법사를 생성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197770030165155722 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_WIZARD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 테이블 페이지에 폼을 생성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197770100937155722 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_TABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_sp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 내장 프로시저에 폼을 생성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197770205453155722 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_SP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 SQL 질의에 폼을 생성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197770329514155723 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_simple_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 HTML 막대 차트 페이지를 작성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197770425754155723 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_SIMPLE_CHART',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_svg_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 SVG 차트 페이지를 작성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197770515407155723 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_SVG_CHART',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 달력 페이지를 작성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197770612423155723 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_CALENDAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_date_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'날짜 열';

wwv_flow_api.create_message (
  p_id=>197770703441155723 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DATE_COLUMN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_label_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'레이블 열';

wwv_flow_api.create_message (
  p_id=>197770805618155723 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.LABEL_COLUMN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_tree
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 트리 페이지를 작성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197770928893155724 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_TREE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'트리 이름';

wwv_flow_api.create_message (
  p_id=>197771011600155724 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'트리 유형';

wwv_flow_api.create_message (
  p_id=>197771107960155724 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_max_level
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'최대 레벨';

wwv_flow_api.create_message (
  p_id=>197771232060155724 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_MAX_LEVEL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_start
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'트리 시작';

wwv_flow_api.create_message (
  p_id=>197771314409155724 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_START',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'트리 질의';

wwv_flow_api.create_message (
  p_id=>197771417045155724 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'팝업 값 목록을 사용하는 새 항목을 기준으로 함';

wwv_flow_api.create_message (
  p_id=>197771528701155724 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_LOV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_sql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 질의를 기준으로 함';

wwv_flow_api.create_message (
  p_id=>197771628892155725 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_SQL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_static
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정적 값';

wwv_flow_api.create_message (
  p_id=>197771711585155725 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_STATIC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 연결 고리 영역 및 연결 고리 옵션을 생성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197771816327155725 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_MENU',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_region_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 유형';

wwv_flow_api.create_message (
  p_id=>197771917322155725 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REGION_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_display_point
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시 지점';

wwv_flow_api.create_message (
  p_id=>197772015180155725 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DISPLAY_POINT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리 템플리트';

wwv_flow_api.create_message (
  p_id=>197772107747155725 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시퀀스';

wwv_flow_api.create_message (
  p_id=>197772210634155726 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SEQUENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리 링크';

wwv_flow_api.create_message (
  p_id=>197772312242155726 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_LINK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리 텍스트';

wwv_flow_api.create_message (
  p_id=>197772418020155726 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상위 연결 고리';

wwv_flow_api.create_message (
  p_id=>197772511322155726 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_MENU',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_query_and_update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 폼 및 보고서 페이지를 작성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197772624224155726 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 페이지';

wwv_flow_api.create_message (
  p_id=>197772710855155726 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 페이지 이름';

wwv_flow_api.create_message (
  p_id=>197772819690155727 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 페이지 탭 집합';

wwv_flow_api.create_message (
  p_id=>197772913435155727 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE_TAB_SET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 페이지 탭 레이블';

wwv_flow_api.create_message (
  p_id=>197773020756155727 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE_TAB_LABEL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'폼 페이지';

wwv_flow_api.create_message (
  p_id=>197773118206155727 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'폼 페이지 이름';

wwv_flow_api.create_message (
  p_id=>197773215965155727 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'폼 페이지 탭 집합';

wwv_flow_api.create_message (
  p_id=>197773308704155727 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE_TAB_SET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'폼 페이지 탭 레이블';

wwv_flow_api.create_message (
  p_id=>197773408106155728 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_primary_key_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본 키 열';

wwv_flow_api.create_message (
  p_id=>197773525318155728 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PRIMARY_KEY_COLUMN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 열';

wwv_flow_api.create_message (
  p_id=>197773616638155728 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_COLUMNS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_where_clause
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Where 절';

wwv_flow_api.create_message (
  p_id=>197773700483155728 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.WHERE_CLAUSE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_drill_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 드릴 다운 보고서 페이지를 작성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197773807047155728 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_DRILL_DOWN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상위 페이지';

wwv_flow_api.create_message (
  p_id=>197773914470155728 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세부 정보 페이지 %0';

wwv_flow_api.create_message (
  p_id=>197774032288155729 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세부 탭 레이블 %0';

wwv_flow_api.create_message (
  p_id=>197774130494155729 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_TAB_LABEL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상위 테이블 이름';

wwv_flow_api.create_message (
  p_id=>197774201565155729 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_TABLE_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세부 정보 테이블 이름 %0';

wwv_flow_api.create_message (
  p_id=>197774306773155729 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_TABLE_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_display_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상위 표시 열';

wwv_flow_api.create_message (
  p_id=>197774409394155729 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_DISPLAY_COLS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_display_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세부 %0 표시 열';

wwv_flow_api.create_message (
  p_id=>197774527010155729 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_DISPLAY_COLS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_order_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상위 테이블 정렬 기준';

wwv_flow_api.create_message (
  p_id=>197774604954155730 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_ORDER_BY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_order_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세부 정보 테이블 %0 정렬 기준';

wwv_flow_api.create_message (
  p_id=>197774719966155730 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_ORDER_BY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_inc_bread_crumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리 포함';

wwv_flow_api.create_message (
  p_id=>197774819978155730 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INC_BREAD_CRUMB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_root
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리 루트';

wwv_flow_api.create_message (
  p_id=>197774903061155730 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_ROOT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_menu_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상위 연결 고리 열';

wwv_flow_api.create_message (
  p_id=>197775031761155730 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_MENU_COL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_menu_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세부 연결 고리 열';

wwv_flow_api.create_message (
  p_id=>197775117301155730 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_MENU_COL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_summary_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 요약 페이지를 작성하도록 요청했습니다. 다른 페이지 및/또는 영역에서 추가 항목을 추가하려면 "추가" 단추를 누르고, 요약 항목을 생성하려면 "완료"를 누르십시오.';

wwv_flow_api.create_message (
  p_id=>197775212531155731 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_SUMMARY_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_copy_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 페이지를 복사하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197775305616155731 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COPY_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 보고서 페이지를 작성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197775411432155731 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_REPORT_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tab_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탭 이름';

wwv_flow_api.create_message (
  p_id=>197775510355155731 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TAB_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_easy_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 보고서 페이지를 작성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197775620218155731 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_EASY_REPORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 템플리트';

wwv_flow_api.create_message (
  p_id=>197775719512155731 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_sort_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정렬 옵션';

wwv_flow_api.create_message (
  p_id=>197775823555155732 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SORT_OPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본값: HTML(표준)';

wwv_flow_api.create_message (
  p_id=>197775903449155732 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본값: 세로형 보고서, 모양 1(널 열 제외)';

wwv_flow_api.create_message (
  p_id=>197776002038155732 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본값: 세로형 보고서, 모양 1(널 열 포함)';

wwv_flow_api.create_message (
  p_id=>197776113531155732 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME3',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name11
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본값: 모양 1';

wwv_flow_api.create_message (
  p_id=>197776205809155732 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME11',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name12
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본값: 모양 2';

wwv_flow_api.create_message (
  p_id=>197776308004155732 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME12',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name21
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'익스포트: CSV';

wwv_flow_api.create_message (
  p_id=>197776416342155733 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME21',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name22
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'익스포트: XML';

wwv_flow_api.create_message (
  p_id=>197776504719155733 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME22',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트:';

wwv_flow_api.create_message (
  p_id=>197776602646155733 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_col_head_sorting
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열 머리글 정렬 사용';

wwv_flow_api.create_message (
  p_id=>197776711148155733 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COL_HEAD_SORTING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 애플리케이션을 생성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197776800688155733 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_APPLICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이름';

wwv_flow_api.create_message (
  p_id=>197776900646155733 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'별칭';

wwv_flow_api.create_message (
  p_id=>197777007513155733 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION_ALIAS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application_default_lang
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본 언어';

wwv_flow_api.create_message (
  p_id=>197777128610155734 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_authentication
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증';

wwv_flow_api.create_message (
  p_id=>197777221254155734 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.AUTHENTICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지';

wwv_flow_api.create_message (
  p_id=>197777323413155734 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tabs
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탭';

wwv_flow_api.create_message (
  p_id=>197777407886155734 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탐색 도구 모음';

wwv_flow_api.create_message (
  p_id=>197777527882155734 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NAV_BAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'UI 테마';

wwv_flow_api.create_message (
  p_id=>197777603674155734 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'청갈색';

wwv_flow_api.create_message (
  p_id=>197777709543155735 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'빨간색';

wwv_flow_api.create_message (
  p_id=>197777806821155735 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'남회색';

wwv_flow_api.create_message (
  p_id=>197777915542155735 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME4',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'올리브색';

wwv_flow_api.create_message (
  p_id=>197778005110155735 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME5',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'적갈색';

wwv_flow_api.create_message (
  p_id=>197778118940155735 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME6',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단순 청갈색';

wwv_flow_api.create_message (
  p_id=>197778207701155735 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME7',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'파란색';

wwv_flow_api.create_message (
  p_id=>197778309188155736 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME8',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'없음';

wwv_flow_api.create_message (
  p_id=>197778406645155736 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME_NONE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_copied
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션에서 복사됨';

wwv_flow_api.create_message (
  p_id=>197778522791155736 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.COPIED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트의 "마스터" 복사본입니다.';

wwv_flow_api.create_message (
  p_id=>197778630787155736 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.MASTER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트를 참조하는 레이블 템플리트';

wwv_flow_api.create_message (
  p_id=>197778724025155736 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트에 적용되는 템플리트가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197778823702155736 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.NO_SUBSCRIPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_current_auth_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'현재 인증 방식';

wwv_flow_api.create_message (
  p_id=>197778931239155737 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.CURRENT_AUTH_METHOD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그인 페이지';

wwv_flow_api.create_message (
  p_id=>197779017207155737 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.LOGIN_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'없음';

wwv_flow_api.create_message (
  p_id=>197779123935155737 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.NONE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_login_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그인 URL';

wwv_flow_api.create_message (
  p_id=>197779205058155737 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.LOGIN_URL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_custom_auth_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자 정의 인증 함수';

wwv_flow_api.create_message (
  p_id=>197779327332155737 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.CUSTOM_AUTH_FUNCTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_confirm_migrate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션의 사용자 정의 인증 옵션을 인증 체계로 이전하려고 합니다.';

wwv_flow_api.create_message (
  p_id=>197779416641155737 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.CONFIRM_MIGRATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_value_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'값을 지정해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197779532604155738 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.VALUE_REQUIRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_plsql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL';

wwv_flow_api.create_message (
  p_id=>197779623259155738 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_PLSQL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_item_e_val
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목=값';

wwv_flow_api.create_message (
  p_id=>197779709325155738 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_item_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'널이 아닌 항목';

wwv_flow_api.create_message (
  p_id=>197779822824155738 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_req_e_e1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'요청=e1';

wwv_flow_api.create_message (
  p_id=>197779926867155738 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_page_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음에 존재하는 페이지';

wwv_flow_api.create_message (
  p_id=>197780030407155738 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_PAGE_IN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_page_not_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음에 존재하지 않는 페이지';

wwv_flow_api.create_message (
  p_id=>197780101040155738 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'존재';

wwv_flow_api.create_message (
  p_id=>197780216979155739 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_EXISTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_never
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'무조건 부정';

wwv_flow_api.create_message (
  p_id=>197780304447155739 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_NEVER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'없음';

wwv_flow_api.create_message (
  p_id=>197780409789155739 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_NONE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message p688_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'익스포트할 애플리케이션의 구성 요소를 지정하십시오. 이는 백업용으로 사용되거나 다른 인스턴스에서 이러한 구성 요소를 로드할 때 사용될 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197780504699155739 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'P688_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'존재';

wwv_flow_api.create_message (
  p_id=>197780609275155739 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_EXISTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_not_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'존재하지 않음';

wwv_flow_api.create_message (
  p_id=>197780712078155740 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_NOT_EXISTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_web_services
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'웹 서비스를 시연할 예제 애플리케이션을 생성하십시오.';

wwv_flow_api.create_message (
  p_id=>197780826703155740 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_WEB_SERVICES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_business_look
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'업무 보기 데모 애플리케이션을 (재)생성하려고 합니다.';

wwv_flow_api.create_message (
  p_id=>197780918065155740 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_BUSINESS_LOOK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_worldcup_mania
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'월드컵 매니아 데모 애플리케이션을 생성하려고 합니다.';

wwv_flow_api.create_message (
  p_id=>197781015824155740 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_WORLDCUP_MANIA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_recreate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 데이터베이스 객체가 존재하는 경우 재생성됩니다.';

wwv_flow_api.create_message (
  p_id=>197781101916155740 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_RECREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스키마';

wwv_flow_api.create_message (
  p_id=>197781225912155740 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.SCHEMA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'객체 유형';

wwv_flow_api.create_message (
  p_id=>197781324784155740 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이름';

wwv_flow_api.create_message (
  p_id=>197781423466155741 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'존재';

wwv_flow_api.create_message (
  p_id=>197781523121155741 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_EXIST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블';

wwv_flow_api.create_message (
  p_id=>197781625960155741 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.TABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_application_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'3000-8999의 애플리케이션 ID가 예약되어 있습니다.';

wwv_flow_api.create_message (
  p_id=>197781714209155741 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.APPLICATION_RESERVED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시퀀스';

wwv_flow_api.create_message (
  p_id=>197781810931155741 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.SEQUENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_trigger
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'트리거';

wwv_flow_api.create_message (
  p_id=>197781926684155741 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.TRIGGER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_package
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'패키지';

wwv_flow_api.create_message (
  p_id=>197782000718155742 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PACKAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_basic
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본 예제 데모 애플리케이션을 생성하려고 합니다.';

wwv_flow_api.create_message (
  p_id=>197782105152155742 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_BASIC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_collection_showcase
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'콜렉션 전시 데모 애플리케이션을 생성하려고 합니다.';

wwv_flow_api.create_message (
  p_id=>197782213075155742 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_COLLECTION_SHOWCASE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_or_recreate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 스키마에서 (재)생성';

wwv_flow_api.create_message (
  p_id=>197782319759155742 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_OR_RECREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p19_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'널이 아닌 검증을 생성하려면 항목을 한 개 이상 지정해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197782400101155742 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P19.VALIDATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_name2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'객체 이름';

wwv_flow_api.create_message (
  p_id=>197782531534155743 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_NAME2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_basic_lexer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'BASIC_LEXER';

wwv_flow_api.create_message (
  p_id=>197782601884155743 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.BASIC_LEXER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_context_index
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'컨텍스트 인덱스';

wwv_flow_api.create_message (
  p_id=>197782711422155743 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CONTEXT_INDEX',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_header_validation1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'머리글은 <b>&lt;head&gt;</b> 및 <b>&lt;/head&gt;</b> 태그를 포함해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197782829697155743 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.HEADER_VALIDATION1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션';

wwv_flow_api.create_message (
  p_id=>197782931603155743 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.APPLICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_need_7m
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'대통령 취임 연설 데모는 7MB 정도의 사용 가능한 디스크 공간을 필요로 하며 스키마에 설치하는 데 최대 2분이 걸릴 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197783029687155743 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.NEED_7M',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_header_validation2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>#HEAD#</b> 대체 문자열은 <b>&lt;head&gt;</b> 태그와 <b>&lt;/head&gt;</b> 태그 사이에 나타나야 합니다.';

wwv_flow_api.create_message (
  p_id=>197783127347155743 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.HEADER_VALIDATION2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_free_space
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용 가능한 공간은 약 %0MB입니다.';

wwv_flow_api.create_message (
  p_id=>197783211868155744 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.FREE_SPACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_will_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 데모를 재생성하지 않으면 오류가 발생할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197783324697155744 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.WILL_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p818_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'복사될 체계를 한 개 이상 선택해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197783415055155744 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P818.VALIDATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_template_name_mand
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트 이름을 지정해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197783528565155744 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.TEMPLATE_NAME_MAND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션에서 복사됨';

wwv_flow_api.create_message (
  p_id=>197783603420155744 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.COPIED_FROM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_popup_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'팝업 값 목록 템플리트';

wwv_flow_api.create_message (
  p_id=>197783725670155744 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.POPUP_LOV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트의 "마스터" 복사본입니다.';

wwv_flow_api.create_message (
  p_id=>197783810044155745 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.MASTER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_popup_lov_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트를 참조하는 팝업 값 목록 템플리트';

wwv_flow_api.create_message (
  p_id=>197783911770155745 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.POPUP_LOV_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트에 적용되는 템플리트가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197784009383155745 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.NO_SUBSCRIPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message current_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'현재 애플리케이션';

wwv_flow_api.create_message (
  p_id=>197784115449155745 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CURRENT_APPLICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'별칭';

wwv_flow_api.create_message (
  p_id=>197784201586155745 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALIAS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message updated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'갱신 날짜';

wwv_flow_api.create_message (
  p_id=>197784328040155745 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_report_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트를 참조하는 보고서 템플리트';

wwv_flow_api.create_message (
  p_id=>197784426729155746 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.REPORT_TEMPLATE_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'소유자';

wwv_flow_api.create_message (
  p_id=>197784507655155746 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OWNER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증';

wwv_flow_api.create_message (
  p_id=>197784620138155746 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p1_edit_this_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트 편집';

wwv_flow_api.create_message (
  p_id=>197784704243155746 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P1_EDIT_THIS_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p1_authentication_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증 홈';

wwv_flow_api.create_message (
  p_id=>197784818021155746 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P1_AUTHENTICATION_HOME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트';

wwv_flow_api.create_message (
  p_id=>197784905462155746 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_menu_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트를 참조하는 연결 고리 템플리트';

wwv_flow_api.create_message (
  p_id=>197785001616155747 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.MENU_TEMPLATE_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_table_summary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데모 애플리케이션 설치 상태 보고서';

wwv_flow_api.create_message (
  p_id=>197785121458155747 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.TABLE_SUMMARY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_demo_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데모 애플리케이션';

wwv_flow_api.create_message (
  p_id=>197785222842155747 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.DEMO_APP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_status
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상태';

wwv_flow_api.create_message (
  p_id=>197785319707155747 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.STATUS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업';

wwv_flow_api.create_message (
  p_id=>197785411887155747 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ACTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_collection_showcase
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'콜렉션 전시';

wwv_flow_api.create_message (
  p_id=>197785517220155747 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.COLLECTION_SHOWCASE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_learn_about
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 쇼핑 카트 개념을 익히십시오.';

wwv_flow_api.create_message (
  p_id=>197785608696155748 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.LEARN_ABOUT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_installed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설치됨';

wwv_flow_api.create_message (
  p_id=>197785707952155748 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.INSTALLED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_run
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'실행';

wwv_flow_api.create_message (
  p_id=>197785817691155748 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.RUN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_not_installed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설치되지 않음';

wwv_flow_api.create_message (
  p_id=>197785924642155748 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.NOT_INSTALLED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_install
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설치';

wwv_flow_api.create_message (
  p_id=>197786029667155748 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.INSTALL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지';

wwv_flow_api.create_message (
  p_id=>197786103833155748 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제목';

wwv_flow_api.create_message (
  p_id=>197786209885155749 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TITLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message security
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보안';

wwv_flow_api.create_message (
  p_id=>197786313541155749 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SECURITY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message standard_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표준 탭 집합';

wwv_flow_api.create_message (
  p_id=>197786432390155749 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STANDARD_TAB_SET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_petstore
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Petstore';

wwv_flow_api.create_message (
  p_id=>197786501464155749 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PETSTORE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_petstore
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0을(를) 사용하여 생성된 온라인 저장소에 대한 예입니다.';

wwv_flow_api.create_message (
  p_id=>197786623331155749 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_PETSTORE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_install_now
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'지금 설치';

wwv_flow_api.create_message (
  p_id=>197786720635155749 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.INSTALL_NOW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_business_look
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'업무 보기';

wwv_flow_api.create_message (
  p_id=>197786808700155750 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.BUSINESS_LOOK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_business_look
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'강력한 기능을 제공하는 보고서 및 페이지 번호 매기기 개념에 대한 예입니다.';

wwv_flow_api.create_message (
  p_id=>197786928078155750 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_BUSINESS_LOOK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_web_services
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'웹 서비스';

wwv_flow_api.create_message (
  p_id=>197787007337155750 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.WEB_SERVICES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_webservices
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0을(를) 사용하여 웹 서비스 사용 방법을 익히십시오.';

wwv_flow_api.create_message (
  p_id=>197787127140155750 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_WEBSERVICES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_presidential
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'대통령 취임 연설';

wwv_flow_api.create_message (
  p_id=>197787231098155750 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PRESIDENTIAL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_presidential
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0을 사용하여 Oracle Text를 사용하는 방법을 익히십시오.';

wwv_flow_api.create_message (
  p_id=>197787302452155751 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_PRESIDENTIAL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p88_select_time
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'돌아가려는 시간을 선택한 다음 소스를 눌러 원하는 항목을 입력하고 이 페이지를 닫으십시오.';

wwv_flow_api.create_message (
  p_id=>197787408482155751 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P88_SELECT_TIME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_project_tracking
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로젝트 추적';

wwv_flow_api.create_message (
  p_id=>197787508723155751 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PROJECT_TRACKING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p88_flashback_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0의 실행 취소 기능은 "플래시백 질의"라는 내장 데이터베이스 기능을 사용하므로, 특정 시간의 데이터를 질의할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197787618465155751 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P88_FLASHBACK_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_proj_tracking
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0을(를) 사용하여 생성된 프로젝트 상태 추적 애플리케이션에 대한 예입니다.';

wwv_flow_api.create_message (
  p_id=>197787708890155751 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_PROJ_TRACKING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p88_undo_retention
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 매개변수 "UNDO_RETENTION"에 준하여 최근 %0시간 내에 발생한 변경 사항만 취소할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197787829932155751 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P88_UNDO_RETENTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션에서 복사됨';

wwv_flow_api.create_message (
  p_id=>197787909314155751 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.COPIED_FROM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 항목 도움말의 "마스터" 복사본입니다.';

wwv_flow_api.create_message (
  p_id=>197788013315155752 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.MASTER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 항목 도움말 텍스트를 참조하는 항목';

wwv_flow_api.create_message (
  p_id=>197788127262155752 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 항목 도움말 텍스트에 적용되는 항목이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197788229043155752 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.NO_SUBSCRIPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_confirm_create_std_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 애플리케이션에 표준 탭 생성 확인:';

wwv_flow_api.create_message (
  p_id=>197788308405155752 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_CONFIRM_CREATE_STD_TAB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_tabset_info_incomplete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'경고: 탭 집합 정보가 불완전합니다.';

wwv_flow_api.create_message (
  p_id=>197788431603155752 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_TABSET_INFO_INCOMPLETE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션에서 복사됨';

wwv_flow_api.create_message (
  p_id=>197788511023155752 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.COPIED_FROM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_page_will_use_existng_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 페이지는 기존 탭 집합 "%1"을(를) 사용합니다.';

wwv_flow_api.create_message (
  p_id=>197788607203155753 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_PAGE_WILL_USE_EXISTNG_TABSET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_new_tabset_will_be_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새 탭 집합 %0이(가) 생성됩니다.';

wwv_flow_api.create_message (
  p_id=>197788723155155753 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_NEW_TABSET_WILL_BE_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 권한 체계의 "마스터" 복사본입니다.';

wwv_flow_api.create_message (
  p_id=>197788804242155753 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.MASTER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 권한 체계를 참조하는 권한 체계';

wwv_flow_api.create_message (
  p_id=>197788909060155753 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 권한 체계에 적용되는 권한 체계가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197789031124155753 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.NO_SUBSCRIPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_not_supplied
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호 및 확인용 암호는 반드시 입력해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197789118305155754 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_NOT_SUPPLIED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_no_match
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호가 일치하지 않습니다. 다시 시도하십시오.';

wwv_flow_api.create_message (
  p_id=>197789218199155754 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_NO_MATCH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션에서 복사됨';

wwv_flow_api.create_message (
  p_id=>197789310871155754 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.COPIED_FROM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_chg_only_yours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'자신의 암호만 변경할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197789408433155754 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_CHG_ONLY_YOURS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 단축키의 "마스터" 복사본입니다.';

wwv_flow_api.create_message (
  p_id=>197789532480155754 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.MASTER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호 변경 요청을 처리하는 중 예상치 않은 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197789600094155754 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 단축키를 참조하는 단축키';

wwv_flow_api.create_message (
  p_id=>197789730151155755 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 단축키에 적용되는 단축키가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197789807081155755 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.NO_SUBSCRIPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_check_err_proc_plsql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1025 PLSQL 표현식을 처리하는 중 오류가 발생했습니다.  %0';

wwv_flow_api.create_message (
  p_id=>197789928329155755 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHECK.ERR_PROC_PLSQL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_check_err_proc_sql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1026 SQL 표현식을 처리하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197790000436155755 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHECK.ERR_PROC_SQL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탭 집합';

wwv_flow_api.create_message (
  p_id=>197790107949155755 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_SET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_check_err_orcl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle 오류: %0';

wwv_flow_api.create_message (
  p_id=>197790223898155755 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHECK.ERR_ORCL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탭 텍스트';

wwv_flow_api.create_message (
  p_id=>197790306150155756 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message current_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'선택된 페이지';

wwv_flow_api.create_message (
  p_id=>197790424801155756 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CURRENT_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션에서 복사됨';

wwv_flow_api.create_message (
  p_id=>197790517725155756 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.COPIED_FROM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 값 목록의 "마스터" 복사본입니다.';

wwv_flow_api.create_message (
  p_id=>197790624570155756 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.MASTER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 값 목록을 참조하는 값 목록';

wwv_flow_api.create_message (
  p_id=>197790719540155756 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 값 목록에 적용되는 값 목록이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197790813047155756 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.NO_SUBSCRIPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parent_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상위 탭 집합';

wwv_flow_api.create_message (
  p_id=>197790925793155757 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARENT_TAB_SET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parent_tab_set_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새 상위 탭 집합';

wwv_flow_api.create_message (
  p_id=>197791012360155757 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARENT_TAB_SET_NEW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parent_tab_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상위 탭 텍스트';

wwv_flow_api.create_message (
  p_id=>197791110103155757 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARENT_TAB_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탭 순서';

wwv_flow_api.create_message (
  p_id=>197791226971155757 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_SEQUENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message current_image
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'선택된 이미지';

wwv_flow_api.create_message (
  p_id=>197791317137155757 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CURRENT_IMAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_page_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트를 참조하는 페이지 템플리트';

wwv_flow_api.create_message (
  p_id=>197791430322155757 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.PAGE_TEMPLATE_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message non_current_image
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'선택되지 않은 이미지';

wwv_flow_api.create_message (
  p_id=>197791517276155758 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NON_CURRENT_IMAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message image_attributes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이미지 속성';

wwv_flow_api.create_message (
  p_id=>197791602321155758 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IMAGE_ATTRIBUTES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message display_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시 조건';

wwv_flow_api.create_message (
  p_id=>197791702262155758 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DISPLAY_CONDITION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message condition_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'조건 유형';

wwv_flow_api.create_message (
  p_id=>197791818183155758 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITION_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message display_condition_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시 조건 텍스트';

wwv_flow_api.create_message (
  p_id=>197791924950155758 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DISPLAY_CONDITION_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션에서 복사됨';

wwv_flow_api.create_message (
  p_id=>197792010316155758 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.COPIED_FROM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_f4500_table_already_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블 이름이 존재합니다.';

wwv_flow_api.create_message (
  p_id=>197792126912155759 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.F4500.TABLE_ALREADY_EXISTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message build_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'빌드 옵션';

wwv_flow_api.create_message (
  p_id=>197792218464155759 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUILD_OPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 탐색 도구 모음의 "마스터" 복사본입니다.';

wwv_flow_api.create_message (
  p_id=>197792300914155759 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.MASTER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_length_not_zero
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열 길이는 0이 될 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197792424117155759 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_LENGTH_NOT_ZERO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_length_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열 길이는 널일 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197792528005155759 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_LENGTH_NOT_NULL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 탐색 도구 모음을 참조하는 탐색 도구 모음';

wwv_flow_api.create_message (
  p_id=>197792630411155759 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_names_not_longer_than_30
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열 이름은 30자를 초과할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197792713436155760 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_NAMES_NOT_LONGER_THAN_30',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_names_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열 이름은 널일 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197792804348155760 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_NAMES_NOT_NULL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 탐색 도구 모음에 적용되는 탐색 도구 모음이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197792918076155760 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.NO_SUBSCRIPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_table_names_not_longer_than_30
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블 이름은 30자 미만이어야 합니다.';

wwv_flow_api.create_message (
  p_id=>197793006328155760 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.TABLE_NAMES_NOT_LONGER_THAN_30',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_not_valid_pk_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b>은(는) 적합한 기본 키 이름이 아닙니다.';

wwv_flow_api.create_message (
  p_id=>197793130711155762 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.NOT_VALID_PK_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p173_no_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 항목에 대한 도움말 없음';

wwv_flow_api.create_message (
  p_id=>197793219997155762 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P173_NO_HELP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_f4500_name_already_used
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b>은(는) 기존 객체에 의해 이미 사용되었습니다.';

wwv_flow_api.create_message (
  p_id=>197793315577155762 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.F4500.NAME_ALREADY_USED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_err_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1000 "declare function x return varchar2 is begin %0 return null; end; begin wwv_flow_utilities.g_query := x; end;"에서 LOV를 확인할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197793409767155762 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.ERR_LOV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_f4500_not_valid_seq_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b>은(는) 적합한 시퀀스 이름이 아닙니다.';

wwv_flow_api.create_message (
  p_id=>197793508376155762 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.F4500.NOT_VALID_SEQ_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'추가';

wwv_flow_api.create_message (
  p_id=>197793606388155763 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.ADD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_not_valid_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b>은(는) 적합한 테이블 이름이 아닙니다.';

wwv_flow_api.create_message (
  p_id=>197793706731155763 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.NOT_VALID_TABLE_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_remove
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제거';

wwv_flow_api.create_message (
  p_id=>197793814353155763 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.REMOVE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_not_valid_object_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b>은(는) 적합한 객체 이름이 아닙니다.';

wwv_flow_api.create_message (
  p_id=>197793901923155763 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.NOT_VALID_OBJECT_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_table_not_found_in_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%1</b> 스키마에서 <b>%0</b> 테이블을 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197794023428155763 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.TABLE_NOT_FOUND_IN_SCHEMA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_no_matches
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'일치하는 항목이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197794111635155764 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.NO_MATCHES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_prev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이전';

wwv_flow_api.create_message (
  p_id=>197794218069155764 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.PREV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_need_unique_execution_order
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'고유 실행 순서 번호를 입력하십시오.';

wwv_flow_api.create_message (
  p_id=>197794324457155764 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.NEED_UNIQUE_EXECUTION_ORDER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_copied_from_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션에서 복사됨';

wwv_flow_api.create_message (
  p_id=>197794425988155764 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_COPIED_FROM_APP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음';

wwv_flow_api.create_message (
  p_id=>197794516038155764 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.NEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_cal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'달력';

wwv_flow_api.create_message (
  p_id=>197794617318155765 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.CAL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'닫기';

wwv_flow_api.create_message (
  p_id=>197794709216155765 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.CLOSE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_ok
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'확인';

wwv_flow_api.create_message (
  p_id=>197794809643155765 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.OK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_search_dialog
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검색 대화상자';

wwv_flow_api.create_message (
  p_id=>197794905318155765 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SEARCH_DIALOG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_find
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 찾기';

wwv_flow_api.create_message (
  p_id=>197795024052155765 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.FIND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_region_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트를 참조하는 영역 템플리트';

wwv_flow_api.create_message (
  p_id=>197795123300155765 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.REGION_TEMPLATE_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_js_no_support
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'JavaScript가 지원되지 않음';

wwv_flow_api.create_message (
  p_id=>197795202365155766 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.JS_NO_SUPPORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_master_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트의 "마스터" 복사본입니다.';

wwv_flow_api.create_message (
  p_id=>197795325917155766 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_MASTER_COPY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록';

wwv_flow_api.create_message (
  p_id=>197795430743155766 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.LIST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_list_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트를 참조하는 템플리트 나열';

wwv_flow_api.create_message (
  p_id=>197795510669155766 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.LIST_TEMPLATE_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_button_templ
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트를 참조하는 단추 템플리트';

wwv_flow_api.create_message (
  p_id=>197795611734155766 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_BUTTON_TEMPL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_no_subscirbers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 템플리트에 적용되는 템플리트가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197795719258155766 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_NO_SUBSCIRBERS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_lov2_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'값 목록 질의 "%1"을(를) 수행하는 중 %0 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197795808195155767 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.LOV2_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_region_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테마';

wwv_flow_api.create_message (
  p_id=>197795930066155767 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_REGION_TEMPLATE.THEME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_page_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테마';

wwv_flow_api.create_message (
  p_id=>197796020855155767 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_PAGE_TEMPLATE.THEME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_list_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테마';

wwv_flow_api.create_message (
  p_id=>197796108752155767 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_LIST_TEMPLATE.THEME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_label_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테마';

wwv_flow_api.create_message (
  p_id=>197796204776155767 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_LABEL_TEMPLATE.THEME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_report_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테마';

wwv_flow_api.create_message (
  p_id=>197796303774155767 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_REPORT_TEMPLATE.THEME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_process_page_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 항목';

wwv_flow_api.create_message (
  p_id=>197796411470155768 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PROCESS.PAGE_ITEMS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_process_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역';

wwv_flow_api.create_message (
  p_id=>197796524460155768 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PROCESS.REGION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_default_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 기본 템플리트로 참조되었습니다.';

wwv_flow_api.create_message (
  p_id=>197796606120155768 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.DEFAULT_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_printer_friendly_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인쇄용 화면 템플리트로 참조되었습니다.';

wwv_flow_api.create_message (
  p_id=>197796708400155768 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.PRINTER_FRIENDLY_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_error_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류 템플리트로 참조되었습니다.';

wwv_flow_api.create_message (
  p_id=>197796809162155768 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.ERROR_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_page_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지에서 참조됨';

wwv_flow_api.create_message (
  p_id=>197796918357155769 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.PAGE_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_not_referenced
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 페이지 템플리트는 참조되지 않았습니다.';

wwv_flow_api.create_message (
  p_id=>197797017087155769 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.NOT_REFERENCED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 페이지 템플리트는';

wwv_flow_api.create_message (
  p_id=>197797125304155769 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'트리 이름';

wwv_flow_api.create_message (
  p_id=>197797230815155769 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'유형';

wwv_flow_api.create_message (
  p_id=>197797306730155769 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목';

wwv_flow_api.create_message (
  p_id=>197797425005155769 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_ITEM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'트리 질의';

wwv_flow_api.create_message (
  p_id=>197797518000155769 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_query_show_source
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'소스 표시';

wwv_flow_api.create_message (
  p_id=>197797627543155770 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.QUERY_SHOW_SOURCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_query_hide_source
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'소스 숨기기';

wwv_flow_api.create_message (
  p_id=>197797704503155770 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.QUERY_HIDE_SOURCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이름';

wwv_flow_api.create_message (
  p_id=>197797811112155770 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록 템플리트';

wwv_flow_api.create_message (
  p_id=>197797907832155770 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_item_seq
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시퀀스';

wwv_flow_api.create_message (
  p_id=>197798030938155770 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_ITEM_SEQ',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_item_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'텍스트';

wwv_flow_api.create_message (
  p_id=>197798120824155771 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_ITEM_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_item_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'대상';

wwv_flow_api.create_message (
  p_id=>197798229632155771 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_ITEM_TARGET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_page_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 항목';

wwv_flow_api.create_message (
  p_id=>197798332213155771 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.PAGE_ITEMS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역';

wwv_flow_api.create_message (
  p_id=>197798406014155771 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.REGION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_set_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역을 설정하려면 누르십시오.';

wwv_flow_api.create_message (
  p_id=>197798508371155771 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.SET_REGION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_prompt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프롬프트';

wwv_flow_api.create_message (
  p_id=>197798629906155771 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.PROMPT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_no_item_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목을 찾을 수 없음';

wwv_flow_api.create_message (
  p_id=>197798717163155772 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.NO_ITEM_FOUND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message prefs_apply_permissions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'권한 적용';

wwv_flow_api.create_message (
  p_id=>197798811922155772 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREFS_APPLY_PERMISSIONS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_display_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시 값';

wwv_flow_api.create_message (
  p_id=>197798902928155772 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.DISPLAY_VALUE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_return_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'반환 값';

wwv_flow_api.create_message (
  p_id=>197799030833155772 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.RETURN_VALUE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message prefs_revoke_permissions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'권한 취소';

wwv_flow_api.create_message (
  p_id=>197799105497155772 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREFS_REVOKE_PERMISSIONS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_default
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본값';

wwv_flow_api.create_message (
  p_id=>197799209959155772 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.DEFAULT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_primary_sort_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본 정렬 열';

wwv_flow_api.create_message (
  p_id=>197799318043155773 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.PRIMARY_SORT_COL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message prefs_noaction_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'필요한 작업 없음';

wwv_flow_api.create_message (
  p_id=>197799428113155773 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREFS_NOACTION_REQUIRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_secondary_sort_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보조 정렬 열';

wwv_flow_api.create_message (
  p_id=>197799518741155773 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.SECONDARY_SORT_COL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_select_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열 선택';

wwv_flow_api.create_message (
  p_id=>197799618273155773 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.SELECT_COL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_disable_sort_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정렬 열을 사용 안함으로 설정';

wwv_flow_api.create_message (
  p_id=>197799729596155773 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.DISABLE_SORT_COL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_manager_warning
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'경고: 상위 탭 대상 "%0"은(는) 존재하지 않는 페이지를 참조합니다.';

wwv_flow_api.create_message (
  p_id=>197799814197155773 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_MANAGER.WARNING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message publish_item_help_confirm
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 항목 도움말을 새로 고치도록 요청했습니다.';

wwv_flow_api.create_message (
  p_id=>197799926888155774 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PUBLISH_ITEM_HELP.CONFIRM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message publish_item_help_confirm2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정확하면 <b>모두 새로 고침</b>을 누르고, 그렇지 않으면 <b>취소</b>를 누르십시오.';

wwv_flow_api.create_message (
  p_id=>197800018300155774 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PUBLISH_ITEM_HELP.CONFIRM2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication_confirm_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 애플리케이션에서 인증 체계를 삭제하려고 합니다. 애플리케이션이 현재 "체계" 인증을 사용하고 있지 않거나 해당 체계가 현재 인증 체계가 아닌 경우, 체계를 삭제해도 애플리케이션 작업이 영향을 받지 않습니다. 애플리케이션이 "체계" 인증을 사용하고 있고 이 체계가 현재 인증 체계인 경우, 애플리케이션은 "체계" 인증을 사용하여 계속 실행되지만 기본 인증 체계도 사용합니다. 따라서 "공개" 증명서 확인을 사용하는 내장 로그인 페이지를 사용합니다. 즉, 누구든지 애플리케이션을 실행할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197800108308155774 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION.CONFIRM_DELETE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_dup_col_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 테이블에서 열 이름 <b>%0</b>이(가) 두 번 이상 사용되었습니다.';

wwv_flow_api.create_message (
  p_id=>197800215708155774 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.DUP_COL_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_precision_nbr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> 열의 전체 자릿수가 부적합합니다. (1-38)<br />';

wwv_flow_api.create_message (
  p_id=>197800324972155774 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_PRECISION_NBR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_scale
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> 열의 소수점 이하 자릿수가 부적합합니다. (-84-127)<br />';

wwv_flow_api.create_message (
  p_id=>197800417441155775 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_SCALE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_precision_char
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> 열의 전체 자릿수가 부적합합니다(%1 - %2).<br />';

wwv_flow_api.create_message (
  p_id=>197800507356155775 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_PRECISION_CHAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_col_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열 이름 <b>%0</b>이(가) 부적합합니다.<br />';

wwv_flow_api.create_message (
  p_id=>197800603943155775 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_COL_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_enter_at_least_one_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'적어도 한 개의 열 이름을 입력해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197800702436155775 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.ENTER_AT_LEAST_ONE_COL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_dup_arg_names
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 함수에서 인수 이름 <b>%0</b>이(가) 두 번 이상 사용되었습니다.<br />';

wwv_flow_api.create_message (
  p_id=>197800800683155775 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.DUP_ARG_NAMES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p232_reset_css
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'CSS 재설정';

wwv_flow_api.create_message (
  p_id=>197800900954155776 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P232_RESET_CSS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_native
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'고유 파일 형식';

wwv_flow_api.create_message (
  p_id=>197801009230155776 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_NATIVE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_text_file_format
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'텍스트로 문서 보기';

wwv_flow_api.create_message (
  p_id=>197801100892155776 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_TEXT_FILE_FORMAT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_parse
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스크립트 구문 분석';

wwv_flow_api.create_message (
  p_id=>197801211829155786 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_PARSE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_show_all_workspaces
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모든 작업 영역 표시';

wwv_flow_api.create_message (
  p_id=>197801305380155786 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_SHOW_ALL_WORKSPACES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열';

wwv_flow_api.create_message (
  p_id=>197801432580155786 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.COLUMNS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_conditions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'조건';

wwv_flow_api.create_message (
  p_id=>197801513474155787 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.CONDITIONS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_arrow_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'아래쪽 화살표';

wwv_flow_api.create_message (
  p_id=>197801631527155787 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.ARROW_DOWN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_arrow_right
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오른쪽 화살표';

wwv_flow_api.create_message (
  p_id=>197801714457155787 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.ARROW_RIGHT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_and
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'AND';

wwv_flow_api.create_message (
  p_id=>197801819879155787 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.AND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_or
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'OR';

wwv_flow_api.create_message (
  p_id=>197801919683155787 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.OR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_preview
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'조건 미리보기';

wwv_flow_api.create_message (
  p_id=>197802023808155787 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.PREVIEW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication_refresh
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 인증 체계를 새로 고치도록 요청했습니다.';

wwv_flow_api.create_message (
  p_id=>197802118813155788 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION.REFRESH',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication_make_current
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션이 이 인증 체계를 사용하도록 하려면 <b>현재로 설정</b> 단추를 누르십시오.';

wwv_flow_api.create_message (
  p_id=>197802216365155788 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION.MAKE_CURRENT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_script_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 테이블에 대한 테이블 생성 스크립트가 SQL 스크립트 저장소에 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197802307241155788 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SCRIPT_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_script_repository
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스크립트 저장소로 이동';

wwv_flow_api.create_message (
  p_id=>197802414950155788 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SCRIPT_REPOSITORY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_sql_workshop_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 워크숍 홈';

wwv_flow_api.create_message (
  p_id=>197802501396155788 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SQL_WORKSHOP_HOME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_run_script
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스크립트 실행';

wwv_flow_api.create_message (
  p_id=>197802612939155788 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.RUN_SCRIPT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_return_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'돌아가기';

wwv_flow_api.create_message (
  p_id=>197802712692155789 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.RETURN_TO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_sql_workshop
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL&nbsp;워크숍';

wwv_flow_api.create_message (
  p_id=>197802819307155789 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SQL_WORKSHOP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'홈';

wwv_flow_api.create_message (
  p_id=>197802914721155789 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.HOME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%1" 스키마에 "%0" 패키지가 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197803028071155789 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_browse
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'패키지 찾아보기';

wwv_flow_api.create_message (
  p_id=>197803132280155789 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.BROWSE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_sql_workshop_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 워크숍 홈';

wwv_flow_api.create_message (
  p_id=>197803203618155789 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.SQL_WORKSHOP_HOME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_return_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'돌아가기';

wwv_flow_api.create_message (
  p_id=>197803302944155790 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.RETURN_TO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_sql_workshop
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL&nbsp;워크숍';

wwv_flow_api.create_message (
  p_id=>197803402368155790 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.SQL_WORKSHOP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'홈';

wwv_flow_api.create_message (
  p_id=>197803531446155790 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.HOME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_back
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블 생성 마법사로 돌아가기';

wwv_flow_api.create_message (
  p_id=>197803632098155790 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.BACK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_failed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 테이블 생성을 실패했습니다.';

wwv_flow_api.create_message (
  p_id=>197803731298155790 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.FAILED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message null_in_paren
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(널)';

wwv_flow_api.create_message (
  p_id=>197803816796155790 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NULL_IN_PAREN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_instruct_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'첫번째 행은 열 이름 포함';

wwv_flow_api.create_message (
  p_id=>197803902782155791 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300_INSTRUCT_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message table_in_paren
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(테이블)';

wwv_flow_api.create_message (
  p_id=>197804030169155791 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TABLE_IN_PAREN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_in_paren
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(뷰)';

wwv_flow_api.create_message (
  p_id=>197804128936155791 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_IN_PAREN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_applications
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모든 애플리케이션';

wwv_flow_api.create_message (
  p_id=>197804218418155791 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_APPLICATIONS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message seconds
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'초';

wwv_flow_api.create_message (
  p_id=>197804305860155791 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SECONDS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message minute
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'분';

wwv_flow_api.create_message (
  p_id=>197804430037155791 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MINUTE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message minutes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'분';

wwv_flow_api.create_message (
  p_id=>197804502626155792 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MINUTES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hour
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시간';

wwv_flow_api.create_message (
  p_id=>197804623384155792 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOUR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시간';

wwv_flow_api.create_message (
  p_id=>197804707714155792 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOURS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message day
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'일';

wwv_flow_api.create_message (
  p_id=>197804808271155792 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DAY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message days
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'일';

wwv_flow_api.create_message (
  p_id=>197804923945155792 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DAYS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message week
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'주';

wwv_flow_api.create_message (
  p_id=>197805013808155792 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEEK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message weeks
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'주';

wwv_flow_api.create_message (
  p_id=>197805114445155793 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEEKS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message year
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'년';

wwv_flow_api.create_message (
  p_id=>197805214777155793 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'YEAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모든 사용자';

wwv_flow_api.create_message (
  p_id=>197805329914155793 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_USERS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'마지막';

wwv_flow_api.create_message (
  p_id=>197805406735155793 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'함수';

wwv_flow_api.create_message (
  p_id=>197805517819155793 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNCTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message index
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인덱스';

wwv_flow_api.create_message (
  p_id=>197805630985155793 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INDEX',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message package
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'패키지';

wwv_flow_api.create_message (
  p_id=>197805717684155794 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PACKAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message procedure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로시저';

wwv_flow_api.create_message (
  p_id=>197805803374155794 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROCEDURE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시퀀스';

wwv_flow_api.create_message (
  p_id=>197805917940155794 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SEQUENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message synonym
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'동의어';

wwv_flow_api.create_message (
  p_id=>197806027270155794 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SYNONYM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블';

wwv_flow_api.create_message (
  p_id=>197806117845155794 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message trigger
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'트리거';

wwv_flow_api.create_message (
  p_id=>197806201876155795 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TRIGGER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'뷰';

wwv_flow_api.create_message (
  p_id=>197806306326155795 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message insert
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'삽입';

wwv_flow_api.create_message (
  p_id=>197806417875155795 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSERT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'갱신';

wwv_flow_api.create_message (
  p_id=>197806500977155795 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'삭제';

wwv_flow_api.create_message (
  p_id=>197806611203155795 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DELETE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not_in_data_dict
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터 딕셔너리에 없음';

wwv_flow_api.create_message (
  p_id=>197806706639155795 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT_IN_DATA_DICT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새 탭 집합';

wwv_flow_api.create_message (
  p_id=>197806826297155796 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_TABSET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부정';

wwv_flow_api.create_message (
  p_id=>197806919540155796 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리';

wwv_flow_api.create_message (
  p_id=>197807020002155796 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MENU',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 질의';

wwv_flow_api.create_message (
  p_id=>197807124597155796 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message structured_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'구조화된 질의';

wwv_flow_api.create_message (
  p_id=>197807221561155796 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STRUCTURED_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message function_body_returning_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 질의를 반환하는 PL/SQL 함수 본문';

wwv_flow_api.create_message (
  p_id=>197807318809155797 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNCTION_BODY_RETURNING_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML 텍스트';

wwv_flow_api.create_message (
  p_id=>197807421866155797 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message plsql_procedure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL';

wwv_flow_api.create_message (
  p_id=>197807504361155797 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PLSQL_PROCEDURE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message anonymous_block
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'익명 블록';

wwv_flow_api.create_message (
  p_id=>197807600466155797 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ANONYMOUS_BLOCK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message help_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'도움말 텍스트';

wwv_flow_api.create_message (
  p_id=>197807712170155797 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HELP_TEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message web_service_result
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'웹 서비스 결과';

wwv_flow_api.create_message (
  p_id=>197807818133155797 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEB_SERVICE_RESULT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'차트';

wwv_flow_api.create_message (
  p_id=>197807903341155798 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message simple
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단순';

wwv_flow_api.create_message (
  p_id=>197808014095155798 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SIMPLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message escape_sc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이스케이프 특수 문자';

wwv_flow_api.create_message (
  p_id=>197808121721155798 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ESCAPE_SC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message with_shortcuts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단축키 사용';

wwv_flow_api.create_message (
  p_id=>197808201284155798 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WITH_SHORTCUTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message updateable_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'갱신 가능한 보고서';

wwv_flow_api.create_message (
  p_id=>197808327362155798 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATEABLE_REPORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL';

wwv_flow_api.create_message (
  p_id=>197808418773155798 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'URL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tree
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'트리';

wwv_flow_api.create_message (
  p_id=>197808520734155799 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TREE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록';

wwv_flow_api.create_message (
  p_id=>197808603951155799 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LIST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_themes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모든 테마';

wwv_flow_api.create_message (
  p_id=>197808700294155799 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_THEMES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML';

wwv_flow_api.create_message (
  p_id=>197808805099155799 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message driven
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'구동';

wwv_flow_api.create_message (
  p_id=>197808932596155799 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRIVEN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message image
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이미지';

wwv_flow_api.create_message (
  p_id=>197809019986155799 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IMAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트 없음';

wwv_flow_api.create_message (
  p_id=>197809130956155800 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목 없음';

wwv_flow_api.create_message (
  p_id=>197809223114155800 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_ITEM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message popup_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'팝업 값 목록';

wwv_flow_api.create_message (
  p_id=>197809300174155800 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'POPUP_LOV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message schemes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'체계';

wwv_flow_api.create_message (
  p_id=>197809413654155800 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SCHEMES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단축키';

wwv_flow_api.create_message (
  p_id=>197809509628155800 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SHORTCUT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message use_page_as_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 페이지를 로그인 페이지로 사용하십시오.';

wwv_flow_api.create_message (
  p_id=>197809600167155800 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'USE_PAGE_AS_LOGIN_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_new_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새 로그인 페이지 생성';

wwv_flow_api.create_message (
  p_id=>197809706239155801 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_NEW_LOGIN_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message use_builtin_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내장 로그인 페이지 사용';

wwv_flow_api.create_message (
  p_id=>197809820029155801 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'USE_BUILTIN_LOGIN_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역';

wwv_flow_api.create_message (
  p_id=>197809907694155801 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WORKSPACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message core
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'코어';

wwv_flow_api.create_message (
  p_id=>197810018111155801 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CORE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_static_files
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모든 정적 파일';

wwv_flow_api.create_message (
  p_id=>197810100105155801 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_STATIC_FILES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message associated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연관됨';

wwv_flow_api.create_message (
  p_id=>197810228370155802 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ASSOCIATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_alias_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1816 애플리케이션 별칭 p_flow_alias_or_id(%0)를 변환하는 중 예상치 않은 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197810321218155802 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ALIAS_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_not_logged_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그인되지 않았습니다. 인증에 필요한 쿠키가 누락되었거나 부적합합니다.';

wwv_flow_api.create_message (
  p_id=>197810428898155802 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NOT_LOGGED_IN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_click_to_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>로그인하려면 <a href="%0">여기</a>를 누르십시오.</a>';

wwv_flow_api.create_message (
  p_id=>197810504356155802 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CLICK_TO_LOGIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_session_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-99900 고유 세션 ID를 생성할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197810611984155802 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CREATE_SESSION_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_session_info_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1029 세션 정보를 저장할 수 없습니다. 세션=%0 항목=%1';

wwv_flow_api.create_message (
  p_id=>197810707714155802 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SESSION_INFO_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_save_routine_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 저장 루틴에 예상치 않은 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197810802883155803 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SAVE_ROUTINE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_deeplinking_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 make_deeplinking_item 세션 %0에 예상치 않은 오류 발생';

wwv_flow_api.create_message (
  p_id=>197810922355155803 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DEEPLINKING_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_id_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1002 "%1" 애플리케이션에서 "%0" 항목에 대한 항목 ID를 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197811025745155803 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ID_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_id_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'예상치 않은 오류입니다. 애플리케이션 또는 페이지 레벨에서 항목 이름을 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197811102075155803 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ID_ERR2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1902 find_item_name 루틴에서 항목 ID가 널입니다.';

wwv_flow_api.create_message (
  p_id=>197811213182155803 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unexpected_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'예상치 않은 오류';

wwv_flow_api.create_message (
  p_id=>197811330562155803 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNEXPECTED_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1802 항목 ID "%0"을(를) 찾을 수 없음';

wwv_flow_api.create_message (
  p_id=>197811413882155804 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ERR2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_auth_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1082 권한 체계 코드를 실행하는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197811515737155804 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.AUTH_SCHEME_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_access_denied
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 보안 검사에 의해 액세스가 거부됨';

wwv_flow_api.create_message (
  p_id=>197811605226155804 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ACCESS_DENIED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_first_page_data_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이미 데이터의 첫번째 페이지입니다.';

wwv_flow_api.create_message (
  p_id=>197811730051155804 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIRST_PAGE_DATA_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 다음 항목을 생성하는 중 예상치 않은 오류 발생: FSP_PROCESS_STATE_%0';

wwv_flow_api.create_message (
  p_id=>197811802853155804 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CREATE_ITEM_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1003 계산 질의를 실행하는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197811929346155804 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_QUERY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_exp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1030 계산 표현식을 실행하는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197812000034155805 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_EXP_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_function_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1004 함수를 계산할 수 없습니다. computation_point=%0 computation_type=%1';

wwv_flow_api.create_message (
  p_id=>197812116938155805 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_FUNCTION_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_unknown_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1005 알 수 없는 계산 유형입니다.';

wwv_flow_api.create_message (
  p_id=>197812227023155805 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_UNKNOWN_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_validation_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1006 검증 루틴에 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197812312372155805 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.VALIDATION_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_func_body_ret_text_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1024 "텍스트를 반환하는 함수 본문" 검증을 실행할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197812421582155805 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FUNC_BODY_RET_TEXT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_func_body_ret_bool_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1021 "부울을 반환하는 함수 본문" 검증을 실행할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197812509958155805 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FUNC_BODY_RET_BOOL_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_point_null_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1007 분기 지점은 널일 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197812603203155806 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_POINT_NULL_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_to_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1008 %0 페이지로의 분기를 수행하는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197812717794155806 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_TO_PAGE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_accept_recur_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1010 페이지 허용 프로세싱으로 분기 순환 한계를 초과했습니다. %0';

wwv_flow_api.create_message (
  p_id=>197812805303155806 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_ACCEPT_RECUR_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_to_funct_ret_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7744 페이지를 반환하는 함수로의 분기를 처리할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197812927681155806 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_TO_FUNCT_RET_PAGE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_func_returning_url_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7744 URL을 반환하는 함수로의 분기를 처리할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197813015878155806 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_FUNC_RETURNING_URL_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1009 분기를 처리하는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197813123147155806 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sql_exp_heading_text_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1910 머리글 텍스트에서 SQL 표현식을 평가하는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197813226635155807 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SQL_EXP_HEADING_TEXT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_eval_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1011 부적합한 평가 유형: %0';

wwv_flow_api.create_message (
  p_id=>197813322523155807 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.EVAL_TYPE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류';

wwv_flow_api.create_message (
  p_id=>197813416772155807 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_g_flow_id_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1812 G_FLOW_ID(%0)를 지정하는 중 예상치 않은 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197813524828155807 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.G_FLOW_ID_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_alias_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1412 페이지 별칭(%0)을 분석할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197813625325155807 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_ALIAS_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_call_to_show_from_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1430 페이지 프로세스에서 표시하기 위한 호출이 지원되지 않음: G_FLOW_STEP_ID (%0).';

wwv_flow_api.create_message (
  p_id=>197813724483155808 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CALL_TO_SHOW_FROM_PROC_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_company_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7620 애플리케이션(%0)에 대한 작업 영역을 확인할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197813823163155808 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMPANY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_company_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 소유자의 보안 그룹 ID를 포함할 p_company 또는 wwv_flow_company 쿠키가 필요합니다.';

wwv_flow_api.create_message (
  p_id=>197813924168155808 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMPANY_FOOTER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_found_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1014 애플리케이션을 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197814019776155808 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FOUND_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_workspace_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역 정보';

wwv_flow_api.create_message (
  p_id=>197814110262155808 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.WORKSPACE_INFO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_found_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션=%0  작업 영역=%1';

wwv_flow_api.create_message (
  p_id=>197814215206155808 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FOUND_FOOTER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이름';

wwv_flow_api.create_message (
  p_id=>197814318949155809 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_justification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'맞춤';

wwv_flow_api.create_message (
  p_id=>197814419893155809 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.JUSTIFICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_login_server_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1555 Oracle Login Server에 로그인되지 않았습니다. 지정된 공개 사용자가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197814512828155809 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.LOGIN_SERVER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설명';

wwv_flow_api.create_message (
  p_id=>197814626860155809 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.DESCRIPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_admin_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'관리자 정보';

wwv_flow_api.create_message (
  p_id=>197814732106155809 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.ADMIN_INFO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_first_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이름';

wwv_flow_api.create_message (
  p_id=>197814810131155809 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.FIRST_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_last_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'성';

wwv_flow_api.create_message (
  p_id=>197814919839155810 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.LAST_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'전자 메일';

wwv_flow_api.create_message (
  p_id=>197815023882155810 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.EMAIL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_phone
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'전화 번호';

wwv_flow_api.create_message (
  p_id=>197815129127155810 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.PHONE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_schema_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스키마 정보';

wwv_flow_api.create_message (
  p_id=>197815230406155810 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.SCHEMA_INFO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_reuse_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기존 스키마 재사용';

wwv_flow_api.create_message (
  p_id=>197815312174155810 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.REUSE_SCHEMA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'예';

wwv_flow_api.create_message (
  p_id=>197815430717155810 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.YES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'아니오';

wwv_flow_api.create_message (
  p_id=>197815518053155811 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.NO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_schema_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스키마 이름';

wwv_flow_api.create_message (
  p_id=>197815605675155811 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.SCHEMA_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_afscookie_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1333 ASFCOOKIE를 인출할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197815718643155811 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.AFSCOOKIE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_db_size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 크기';

wwv_flow_api.create_message (
  p_id=>197815801461155811 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.DB_SIZE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_session_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1201 사용자 정의 인증에서 세션 ID가 설정되지 않았습니다.';

wwv_flow_api.create_message (
  p_id=>197815919742155811 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CUSTOM_AUTH_SESSION_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_session_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지=%0';

wwv_flow_api.create_message (
  p_id=>197816007195155811 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CUSTOM_AUTH_SESSION_FOOTER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_accept
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'확인 코드를 대소문자를 구분하여 입력하고 <b>요청 제출</b>을 누르십시오.';

wwv_flow_api.create_message (
  p_id=>197816113840155812 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.ACCEPT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unsupp_auth_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1444 지원되지 않는 인증 체계입니다.';

wwv_flow_api.create_message (
  p_id=>197816227766155812 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNSUPP_AUTH_SCHEME_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새 %0을(를) 등록하도록 요청했습니다.';

wwv_flow_api.create_message (
  p_id=>197816305694155812 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.NEW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_workspace_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역 정보';

wwv_flow_api.create_message (
  p_id=>197816406454155812 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.WORKSPACE_INFO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이름';

wwv_flow_api.create_message (
  p_id=>197816526752155812 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_sgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보안 그룹 ID';

wwv_flow_api.create_message (
  p_id=>197816618448155812 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SGID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_system_assigned
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시스템이 지정함';

wwv_flow_api.create_message (
  p_id=>197816715387155813 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SYSTEM_ASSIGNED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설명';

wwv_flow_api.create_message (
  p_id=>197816801393155813 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.DESCRIPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_fnd_inv_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1014 애플리케이션을 찾을 수 없습니다. 작업 영역이 부적합합니다.';

wwv_flow_api.create_message (
  p_id=>197816924908155813 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FND_INV_COMP_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_admin_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'관리자 정보';

wwv_flow_api.create_message (
  p_id=>197817000706155813 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.ADMIN_INFO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_user_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자 이름';

wwv_flow_api.create_message (
  p_id=>197817126130155813 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.USER_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'전자 메일';

wwv_flow_api.create_message (
  p_id=>197817201890155814 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.EMAIL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제목';

wwv_flow_api.create_message (
  p_id=>197817307243155814 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.TITLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_fnd_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션=%0 현재 작업 영역=%1 요청된 작업 영역=%2';

wwv_flow_api.create_message (
  p_id=>197817413866155814 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FND_FOOTER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_restricted_to_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 개발자만 이 애플리케이션에 액세스할 수 있습니다. 나중에 다시 시도하십시오.';

wwv_flow_api.create_message (
  p_id=>197817516771155814 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_RESTRICTED_TO_DEV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_schema_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스키마 정보';

wwv_flow_api.create_message (
  p_id=>197817600459155814 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SCHEMA_INFO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_restricted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 애플리케이션에 대한 액세스가 제한됩니다. 나중에 다시 시도하십시오.';

wwv_flow_api.create_message (
  p_id=>197817701534155814 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_RESTRICTED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_reuse_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기존 스키마 재사용';

wwv_flow_api.create_message (
  p_id=>197817824689155815 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.REUSE_SCHEMA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_set_vpd_context_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1181 나타나는 페이지에 VPD 보안 컨텍스트를 설정할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197817927630155815 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SET_VPD_CONTEXT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'예';

wwv_flow_api.create_message (
  p_id=>197818004966155815 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.YES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_afscookie_null_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1111 asfcookie는 널이면 안됩니다.';

wwv_flow_api.create_message (
  p_id=>197818106348155815 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.AFSCOOKIE_NULL_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'아니오';

wwv_flow_api.create_message (
  p_id=>197818214772155815 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.NO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_schema_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스키마 이름';

wwv_flow_api.create_message (
  p_id=>197818302638155816 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SCHEMA_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_create_tblspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블스페이스가 생성됨';

wwv_flow_api.create_message (
  p_id=>197818429936155816 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.CREATE_TBLSPACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_page_not_fnd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1016 "%0" 애플리케이션의 "%1"페이지를 찾을 수 없음(요청 언어="%2")';

wwv_flow_api.create_message (
  p_id=>197818532122155816 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_PAGE_NOT_FND_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_flow_xxx
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'FLOW_XXX';

wwv_flow_api.create_message (
  p_id=>197818613749155816 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.FLOW_XXX',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_contact_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 관리자에게 문의하십시오.';

wwv_flow_api.create_message (
  p_id=>197818702486155816 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CONTACT_ADMIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_datafile
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블스페이스에 대한 데이터 파일';

wwv_flow_api.create_message (
  p_id=>197818824953155816 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.DATAFILE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_required_role_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'필수 롤이 사용으로 설정되지 않았습니다.';

wwv_flow_api.create_message (
  p_id=>197818919182155817 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.REQUIRED_ROLE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_logout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로그아웃';

wwv_flow_api.create_message (
  p_id=>197819032194155817 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.LOGOUT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_priv_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1013 %0 사용자가 시도한 작업에 대한 권한이 없습니다. %1 롤이 필요합니다. 애플리케이션 관리자에게 문의하십시오.';

wwv_flow_api.create_message (
  p_id=>197819117706155817 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PRIV_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_clear_step_cache_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1018 단계 캐시를 지우는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197819229930155817 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CLEAR_STEP_CACHE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_resolve_alias_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1512 페이지 별칭(%0)을 분석할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197819316676155817 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_RESOLVE_ALIAS_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_company_on_accept_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7621 애플리케이션 허용 시 애플리케이션(%0)에 대한 작업 영역을 확인할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197819428390155817 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMPANY_ON_ACCEPT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_comp_for_flow_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 소유자의 보안 그룹 ID를 포함할 p_company 또는 wwv_flow_company 쿠키가 필요합니다.';

wwv_flow_api.create_message (
  p_id=>197819503264155818 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMP_FOR_FLOW_FOOTER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_set_vpd_context_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1182 페이지 허용 시 VPD 보안 컨텍스트를 설정할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197819611479155818 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SET_VPD_CONTEXT_ERR2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_insufficent_info_on_req_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-9988 이 요청에 제공된 정보가 불충분함: 이전 페이지가 완전히 로드될 때까지 기다리지 않았을 수 있습니다. 브라우저의 <b>뒤로</b> 또는 <b>재로드</b> 단추를 누르거나, 애플리케이션 홈 페이지로 이동하여 계속하십시오.';

wwv_flow_api.create_message (
  p_id=>197819707025155818 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.INSUFFICENT_INFO_ON_REQ_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_page_request_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션=%0 페이지=%1 요청=%2';

wwv_flow_api.create_message (
  p_id=>197819826703155818 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_PAGE_REQUEST_FOOTER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_save_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1022 속성을 저장할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197819918935155818 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_SAVE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_perf_valid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1023 검증을 수행할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197820030599155818 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_PERF_VALID_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_perf_processing_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1024 프로세싱을 수행할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197820122008155819 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_PERF_PROCESSING_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_page_to_branch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1777: %0 페이지가 분기할 페이지를 제공하지 않았습니다. 애플리케이션 관리자에게 이 오류를 보고하십시오.';

wwv_flow_api.create_message (
  p_id=>197820230207155819 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PAGE_TO_BRANCH_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_restart_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<a href="f?p=%0">애플리케이션 재시작</a>';

wwv_flow_api.create_message (
  p_id=>197820315704155819 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.RESTART_APP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_page_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 도움말이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197820432065155819 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PAGE_HELP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_default_val_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1019 항목 기본값을 계산하는 중 오류 발생: 페이지=%0 이름=%1.';

wwv_flow_api.create_message (
  p_id=>197820500618155819 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_DEFAULT_VAL_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_plsql_item_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1020 PLSQL 항목(함수)을 처리하는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197820609143155819 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.PLSQL_ITEM_PROC_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_default_func_body_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1904 항목 기본값을 계산할 수 없음: 유형 = 함수 본문 computation_type= %0.';

wwv_flow_api.create_message (
  p_id=>197820704427155820 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_DEFAULT_FUNC_BODY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_post_calc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1079 항목 사후 계산에 오류가 있습니다.';

wwv_flow_api.create_message (
  p_id=>197820804057155820 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_POST_CALC_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_spell_chk
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'철자법 검사';

wwv_flow_api.create_message (
  p_id=>197820902050155820 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.SPELL_CHK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_plsql_exp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1025 PLSQL 표현식을 처리하는 중 오류가 발생했습니다.  %0';

wwv_flow_api.create_message (
  p_id=>197821001057155820 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PLSQL_EXP_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_plsql_exp_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션=%0 페이지=%1 SQLERRM=%2';

wwv_flow_api.create_message (
  p_id=>197821115932155820 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PLSQL_EXP_FOOTER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_func_return_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1101 질의를 반환하는 함수 본문을 처리할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197821227772155820 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.FUNC_RETURN_QUERY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_proc_curr_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1108 항목 현재 조건을 처리할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197821327328155821 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PROC_CURR_COND_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_render_shortcut_unable_set_short_val_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-2904 단축키 값을 설정할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197821414396155821 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_RENDER_SHORTCUT.UNABLE_SET_SHORT_VAL_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_trees_root_not_fnd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'경고: 트리 루트 ID "%0"을(를) 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197821531726155821 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_TREES.ROOT_NOT_FND_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message v_alias_conversion_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1812 애플리케이션 별칭(%0)을 변환하는 중 예상치 않은 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197821615288155821 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'V.ALIAS_CONVERSION_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션:';

wwv_flow_api.create_message (
  p_id=>197821730180155821 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.APPLICATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지:';

wwv_flow_api.create_message (
  p_id=>197821800781155822 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_plsql_lines_source
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL %0 %1이(가) 소스 코드의 %2개 행을 포함합니다.';

wwv_flow_api.create_message (
  p_id=>197821915391155822 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.PLSQL_LINES_SOURCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_no_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<span class="tiny">페이지를 찾을 수 없습니다.</font>';

wwv_flow_api.create_message (
  p_id=>197822031695155822 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.NO_PAGES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 <font size=-2>페이지</span>';

wwv_flow_api.create_message (
  p_id=>197822126030155822 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.PAGES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_unable_det_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1000 "declare function x return varchar2 is begin %0  return null; end; begin wwv_flow_utilities.g_query := x; end;"에서 값 목록을 확인할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197822213700155822 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.UNABLE_DET_LOV_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_js_not_supported
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'JavaScript가 지원되지 않습니다.';

wwv_flow_api.create_message (
  p_id=>197822327229155822 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.JS_NOT_SUPPORTED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록';

wwv_flow_api.create_message (
  p_id=>197822416701155823 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.LIST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message manage_unassigned
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'지정되지 않은 항목 관리';

wwv_flow_api.create_message (
  p_id=>197822527733155823 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MANAGE_UNASSIGNED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_complementary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보조';

wwv_flow_api.create_message (
  p_id=>197822632428155823 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_COMPLEMENTARY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_split_complementary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보조 분할';

wwv_flow_api.create_message (
  p_id=>197822727944155823 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_triade
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'3중';

wwv_flow_api.create_message (
  p_id=>197822831111155823 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_TRIADE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_tetrade
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'4중';

wwv_flow_api.create_message (
  p_id=>197822911846155824 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_TETRADE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_analogic
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'아날로그';

wwv_flow_api.create_message (
  p_id=>197823027671155824 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_ANALOGIC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_monotone
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모노톤';

wwv_flow_api.create_message (
  p_id=>197823109289155824 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_MONOTONE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_complementary_colors
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보색';

wwv_flow_api.create_message (
  p_id=>197823207238155824 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fetch_value_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'fetch_value에 애플리케이션 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197823304511155824 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FETCH_VALUE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_button_temp_fetch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단추 템플리트 ID %0을(를) 인출하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197823409865155824 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BUTTON_TEMP_FETCH_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_trace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'추적할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197823524690155824 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_TRACE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_set_timed_stat_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'timed_statistics를 설정할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197823630324155825 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_SET_TIMED_STAT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_available
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션을 사용할 수 없음';

wwv_flow_api.create_message (
  p_id=>197823731978155825 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_AVAILABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_stop_trace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'추적을 정지할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197823814052155825 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_STOP_TRACE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_view_help_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'도움말을 보려면 애플리케이션 및 페이지를 제공해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197823904119155825 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.VIEW_HELP_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_not_disp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류: HTML 폼이 아직 열리지 않았기 때문에 "%0" 항목이 표시되지 않았습니다.';

wwv_flow_api.create_message (
  p_id=>197824031735155825 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_NOT_DISP_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_unable_cast_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 값의 데이터형을 날짜 형식 마스크 %1(으)로 변환할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197824124862155825 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.UNABLE_CAST_VALUE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_edit_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 - %1 항목 편집, 시퀀스: %2';

wwv_flow_api.create_message (
  p_id=>197824224404155826 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.EDIT ITEM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_reset_pag_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 페이지 번호 매김을 재설정할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197824307564155826 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.RESET_PAG_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_print_shortcut_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단축키를 인쇄할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197824419308155826 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PRINT_SHORTCUT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_render_chart_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'차트를 렌더링하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197824510963155826 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.RENDER_CHART_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_debug
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'디버그:';

wwv_flow_api.create_message (
  p_id=>197824621691155826 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.DEBUG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_feature_not_supported
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 버전에서 지원하지 않는 기능입니다.';

wwv_flow_api.create_message (
  p_id=>197824714943155827 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.FEATURE_NOT_SUPPORTED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_request_for_help_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERROR 4322- 도움말 요청에 적절한 구문을 사용하지 않았습니다. 적합한 페이지 번호가 필요하지만 요청이 널이었습니다.';

wwv_flow_api.create_message (
  p_id=>197824820533155827 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.REQUEST_FOR_HELP_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_help_request_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERROR 4323- 도움말 요청 시 도움말을 표시할 숫자 페이지 ID를 제공하지 않았습니다.';

wwv_flow_api.create_message (
  p_id=>197824930406155827 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.HELP_REQUEST_ERR2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_unable_init_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'질의를 초기화할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197825025695155827 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.UNABLE_INIT_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_company_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역이 필요합니다.';

wwv_flow_api.create_message (
  p_id=>197825105112155827 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.COMPANY_REQUIRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_flow_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션이 필요합니다.';

wwv_flow_api.create_message (
  p_id=>197825211973155827 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.FLOW_REQUIRED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_invalid_user_pass
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자 이름 "%0" 또는 암호가 부적합합니다.';

wwv_flow_api.create_message (
  p_id=>197825309613155828 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.INVALID_USER_PASS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_rows
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'행';

wwv_flow_api.create_message (
  p_id=>197825420946155828 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_ROWS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_axis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'축';

wwv_flow_api.create_message (
  p_id=>197825511632155828 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_AXIS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_average
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'평균';

wwv_flow_api.create_message (
  p_id=>197825626411155828 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_AVERAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_sum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'합계';

wwv_flow_api.create_message (
  p_id=>197825710907155828 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_SUM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_maximum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'최대값';

wwv_flow_api.create_message (
  p_id=>197825831010155828 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_MAXIMUM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_minimum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'최소값';

wwv_flow_api.create_message (
  p_id=>197825923214155829 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_MINIMUM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'마지막';

wwv_flow_api.create_message (
  p_id=>197826023005155829 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_LAST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_first
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'첫번째';

wwv_flow_api.create_message (
  p_id=>197826112919155829 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_FIRST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_go
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'실행';

wwv_flow_api.create_message (
  p_id=>197826200322155829 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_GO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_invalid_chart_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 차트 유형입니다.';

wwv_flow_api.create_message (
  p_id=>197826306344155829 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.INVALID_CHART_TYPE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_sso_redirect_to_login_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증을 위해 로그인 서버로 재지정 중...';

wwv_flow_api.create_message (
  p_id=>197826406855155830 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_SSO.REDIRECT_TO_LOGIN_SERVER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_line_too_long
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%2 행에서 행 길이 %0이(가) 최대값 %1을(를) 초과합니다.';

wwv_flow_api.create_message (
  p_id=>197826531800155830 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.LINE_TOO_LONG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_message1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 페이지에 포함시키려는 영역을 선택하십시오. 적절한 애플리케이션 컨텍스트에 있지 않거나 적절한 권한이 없는 경우 선택된 영역이 표시되지 않을 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197826610936155830 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_MESSAGE1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_message2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 페이지에 대해 사용자가 정의할 수 있는 영역을 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197826716281155830 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_MESSAGE2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'닫기';

wwv_flow_api.create_message (
  p_id=>197826816020155830 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_CLOSE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_apply
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'변경 사항 적용';

wwv_flow_api.create_message (
  p_id=>197826900581155830 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_APPLY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_cust_opt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 사용자 정의 옵션';

wwv_flow_api.create_message (
  p_id=>197827001673155831 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_CUST_OPT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_default
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본값';

wwv_flow_api.create_message (
  p_id=>197827118590155831 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_DEFAULT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_disp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시';

wwv_flow_api.create_message (
  p_id=>197827203644155831 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_DISP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_hidden
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'숨김';

wwv_flow_api.create_message (
  p_id=>197827320043155831 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_HIDDEN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_func_body_null_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'구문 분석 오류: 함수 본문은 널이면 안됩니다.';

wwv_flow_api.create_message (
  p_id=>197827408546155831 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.FUNC_BODY_NULL_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'구문 분석 오류: %0';

wwv_flow_api.create_message (
  p_id=>197827510006155831 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.PARSE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_administration_deprecated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용되지 않음';

wwv_flow_api.create_message (
  p_id=>197827619662155831 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ADMINISTRATION.DEPRECATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cache_purge_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0개의 세션이 비워졌습니다.';

wwv_flow_api.create_message (
  p_id=>197827705247155832 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CACHE.PURGE_SESSION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cache_purge_dup_sessions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0개의 중복된 세션이 비워졌습니다.';

wwv_flow_api.create_message (
  p_id=>197827828423155832 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CACHE.PURGE_DUP_SESSIONS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cache_obsolete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용되지 않음';

wwv_flow_api.create_message (
  p_id=>197827927994155832 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CACHE.OBSOLETE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_plsql_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 PL/SQL 표현식 조건: %0';

wwv_flow_api.create_message (
  p_id=>197828031616155832 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_PLSQL_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_func_body_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 함수 본문 조건: %0';

wwv_flow_api.create_message (
  p_id=>197828129206155832 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_FUNC_BODY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_sql_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 SQL 표현식 조건: %0';

wwv_flow_api.create_message (
  p_id=>197828200513155833 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_SQL_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_exists_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 조건이 존재하거나 조건이 존재하지 않음: %0';

wwv_flow_api.create_message (
  p_id=>197828315226155833 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_EXISTS_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_filter_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'필터를 사용하여 팝업 값 목록을 생성할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197828418420155833 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_FILTER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_generate_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'질의를 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197828527393155833 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.GENERATE_QUERY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_init_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'값 목록을 초기화하는 중 오류 발생: %0 ';

wwv_flow_api.create_message (
  p_id=>197828623428155833 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.INIT_LOV_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_unable_to_bind_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0"을(를) 바인드할 수 없음';

wwv_flow_api.create_message (
  p_id=>197828713081155833 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.UNABLE_TO_BIND_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_disp_only_list_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류: 표시 전용 값 목록은 두 개의 열을 선택해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197828804301155834 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.DISP_ONLY_LIST_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_lov_auth_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'팝업 값 목록 인증을 실패했습니다.';

wwv_flow_api.create_message (
  p_id=>197828900750155834 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_LOV_AUTH_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_lov_check_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'팝업 값 목록 체크섬 확인을 실패했습니다.';

wwv_flow_api.create_message (
  p_id=>197829024478155834 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_LOV_CHECK_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_init_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'질의를 초기화할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197829127787155834 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.INIT_QUERY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_checkbox_query_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'체크박스 질의를 평가하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197829211378155834 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.CHECKBOX_QUERY_LOV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_contains
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음을 포함';

wwv_flow_api.create_message (
  p_id=>197829303451155835 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_CONTAINS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_regexp_like
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정규 표현식 일치';

wwv_flow_api.create_message (
  p_id=>197829414758155835 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_REGEXP_LIKE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_bold
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'굵은체';

wwv_flow_api.create_message (
  p_id=>197829510541155835 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_BOLD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_italics
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기울임꼴';

wwv_flow_api.create_message (
  p_id=>197829624098155835 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_ITALICS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_underline
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'밑줄';

wwv_flow_api.create_message (
  p_id=>197829704541155836 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_UNDERLINE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_no_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'번호가 매겨진 목록';

wwv_flow_api.create_message (
  p_id=>197829815588155836 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_NO_LIST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_bull_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'글머리 기호 목록';

wwv_flow_api.create_message (
  p_id=>197829916132155836 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_BULL_LIST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_just_left
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'왼쪽 맞춤';

wwv_flow_api.create_message (
  p_id=>197830009529155836 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_JUST_LEFT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_just_cen
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'가운데 맞춤';

wwv_flow_api.create_message (
  p_id=>197830123793155836 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_JUST_CEN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_just_rt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오른쪽 맞춤';

wwv_flow_api.create_message (
  p_id=>197830203453155836 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_JUST_RT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_ind_left
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'왼쪽 들여쓰기';

wwv_flow_api.create_message (
  p_id=>197830331129155837 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_IND_LEFT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_ind_right
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오른쪽 들여쓰기';

wwv_flow_api.create_message (
  p_id=>197830421185155837 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_IND_RIGHT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_email_address
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Express 계정에 대한 새 전자 메일 주소입니다.';

wwv_flow_api.create_message (
  p_id=>197830508321155837 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_EMAIL_ADDRESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_worksheet_show_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서를 렌더링하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197830607587155837 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WORKSHEET.SHOW_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 프로시저를 사용하여 PL/SQL 패키지 %0 생성:'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197830727667155837 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_CREATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_show_spec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사양 표시';

wwv_flow_api.create_message (
  p_id=>197830804412155838 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_SHOW_SPEC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_hide_spec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사양 숨기기';

wwv_flow_api.create_message (
  p_id=>197830914139155838 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_HIDE_SPEC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_show_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'본문 표시';

wwv_flow_api.create_message (
  p_id=>197831019194155838 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_SHOW_BODY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_hide_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'본문 숨기기';

wwv_flow_api.create_message (
  p_id=>197831128822155838 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_HIDE_BODY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_down_spec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사양 다운로드';

wwv_flow_api.create_message (
  p_id=>197831219120155838 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DOWN_SPEC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_down_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'본문 다운로드';

wwv_flow_api.create_message (
  p_id=>197831328108155838 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DOWN_BODY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_subprogram
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'하위 프로그램';

wwv_flow_api.create_message (
  p_id=>197831410317155839 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_SUBPROGRAM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설명';

wwv_flow_api.create_message (
  p_id=>197831520700155839 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESCRIPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터를 %0에 삽입하는 데 사용하며, 기본 키를 제공해야 함';

wwv_flow_api.create_message (
  p_id=>197831606388155839 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0에서 기본 키로 식별된 데이터를 갱신하는 데 사용';

wwv_flow_api.create_message (
  p_id=>197831727267155839 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본 키에 준하여 %0에서 데이터를 삭제하는 데 사용';

wwv_flow_api.create_message (
  p_id=>197831816241155839 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC3',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본 키에 준하여 %0에서 데이터를 검색하는 데 사용';

wwv_flow_api.create_message (
  p_id=>197831921523155839 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC4',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'--%0 애플리케이션에 대한 테이블 API가 %1을(를) 생성함';

wwv_flow_api.create_message (
  p_id=>197832011322155840 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_COMMENT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_no_column_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용할 수 있는 열 정보가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197832104165155840 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NO_COLUMN_INFO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message url_prohibited
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'요청한 URL은 금지되었습니다. 관리자에게 문의하십시오.';

wwv_flow_api.create_message (
  p_id=>197832222394155840 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'URL_PROHIBITED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML 본문';

wwv_flow_api.create_message (
  p_id=>197832311766155840 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_BODY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_help_invalid_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 항목 ID: %0 ';

wwv_flow_api.create_message (
  p_id=>197832421470155840 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM_HELP.INVALID_ITEM_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message p_valid_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'적합한 페이지 번호를 지정해야 합니다. (예: p?n=1234)';

wwv_flow_api.create_message (
  p_id=>197832530924155840 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'P.VALID_PAGE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_template_name_already_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'템플리트 이름 %0이(가) 존재합니다. 새 이름을 입력하십시오.';

wwv_flow_api.create_message (
  p_id=>197832602845155841 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.TEMPLATE_NAME_ALREADY_EXISTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_dynamic_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 속성을 사용하여 대화식 보고서 페이지를 생성하도록 요청했습니다. 선택 사항을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197832702862155841 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message htmlwithshortcuts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML(단축키 사용)';

wwv_flow_api.create_message (
  p_id=>197832805486155841 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTMLWITHSHORTCUTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message print_server_not_configured
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인쇄 서버가 구성되어 있지 않으므로 현재 보고서 인쇄를 사용할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197832925124155841 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PRINT SERVER NOT CONFIGURED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message list_templates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록 템플리트';

wwv_flow_api.create_message (
  p_id=>197833015205155841 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LIST_TEMPLATES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message regions_list_template_override
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 목록 템플리트 우선 적용';

wwv_flow_api.create_message (
  p_id=>197833114059155842 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGIONS_LIST_TEMPLATE_OVERRIDE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message regioin_references
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'영역 참조';

wwv_flow_api.create_message (
  p_id=>197833232250155842 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGIOIN_REFERENCES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_max_row_cnt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이 질의는 %0개보다 많은 행을 반환합니다. 전체 결과가 나타나도록 데이터를 필터링하십시오.';

wwv_flow_api.create_message (
  p_id=>197833311111155842 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_MAX_ROW_CNT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_doesnot_contain
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음을 포함하지 않음';

wwv_flow_api.create_message (
  p_id=>197833410906155842 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_DOESNOT_CONTAIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_in_last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음이 마지막임';

wwv_flow_api.create_message (
  p_id=>197833505566155842 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_IN_LAST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_isnot_in_last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음이 마지막이 아님';

wwv_flow_api.create_message (
  p_id=>197833606557155842 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_ISNOT_IN_LAST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_mins
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'분';

wwv_flow_api.create_message (
  p_id=>197833715544155843 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_MINS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_hours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시간';

wwv_flow_api.create_message (
  p_id=>197833819311155843 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_HOURS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_days
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'일';

wwv_flow_api.create_message (
  p_id=>197833929114155843 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_DAYS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_weeks
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'주';

wwv_flow_api.create_message (
  p_id=>197834015692155843 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_WEEKS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_months
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'월';

wwv_flow_api.create_message (
  p_id=>197834130334155843 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_MONTHS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_years
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'년';

wwv_flow_api.create_message (
  p_id=>197834204203155844 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_YEARS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message interactive_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'대화식 보고서';

wwv_flow_api.create_message (
  p_id=>197834321452155844 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INTERACTIVE_REPORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_and
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'~';

wwv_flow_api.create_message (
  p_id=>197834403806155844 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p33_breadcrumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'유지 관리 애플리케이션 생성';

wwv_flow_api.create_message (
  p_id=>197834500994155844 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P33_BREADCRUMB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_breadcrumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 생성';

wwv_flow_api.create_message (
  p_id=>197834618329155844 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_BREADCRUMB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message add_constraint
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제약 조건 추가';

wwv_flow_api.create_message (
  p_id=>197834726199155844 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ADD_CONSTRAINT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_index
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인덱스 생성';

wwv_flow_api.create_message (
  p_id=>197834830556155845 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_INDEX',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p49_app_defs
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 기본값';

wwv_flow_api.create_message (
  p_id=>197834911403155845 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P49_APP_DEFS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p24_save_to_worksheet
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'워크시트에 저장';

wwv_flow_api.create_message (
  p_id=>197835020083155845 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P24_SAVE_TO_WORKSHEET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_invalid_wksp_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 작업 영역 ID';

wwv_flow_api.create_message (
  p_id=>197835107443155845 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_INVALID_WKSP_ID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_wkspc_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역을 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197835227531155845 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_WKSPC_NOT_FOUND',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_loading_data
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터 로드 중...';

wwv_flow_api.create_message (
  p_id=>197835300409155845 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.LOADING_DATA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_waiting
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터를 로드하는 중입니다. 기다리십시오.';

wwv_flow_api.create_message (
  p_id=>197835410764155846 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.WAITING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_check_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자 %0에게 %1 스키마에 대한 권한이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197835507719155846 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CHECK_PRIV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_create_plan_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'실행 계획 설명문을 쉽게 사용할 수 있도록 하는 계획 테이블이 생성됨';

wwv_flow_api.create_message (
  p_id=>197835614008155846 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CREATE_PLAN_TABLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_error_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 행에 오류 발생: %1';

wwv_flow_api.create_message (
  p_id=>197835700480155846 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.ERROR_MSG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_run_sql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스에 "%0" 스키마가 존재하지 않습니다. 작업 영역 관리자에게 문의하여 정확한 기본 스키마를 설정하십시오.';

wwv_flow_api.create_message (
  p_id=>197835820350155846 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.RUN_SQL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_insert_script_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'파일 테이블에 스크립트를 삽입하는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197835910373155847 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.INSERT_SCRIPT_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_parse_script_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스크립트 구문을 분석하는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197836013251155847 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.PARSE_SCRIPT_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_create_script_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스크립트 파일 생성 오류입니다.';

wwv_flow_api.create_message (
  p_id=>197836104454155847 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CREATE_SCRIPT_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_not_implemented
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'구현되지 않았습니다.';

wwv_flow_api.create_message (
  p_id=>197836210387155847 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.NOT_IMPLEMENTED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_product_build
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제품 빌드:';

wwv_flow_api.create_message (
  p_id=>197836329575155847 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.PRODUCT_BUILD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_schema_compatibility
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스키마 호환성:';

wwv_flow_api.create_message (
  p_id=>197836408303155847 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.SCHEMA_COMPATIBILITY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_last_ddl_time
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'최종 DDL 시간';

wwv_flow_api.create_message (
  p_id=>197836524607155848 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.LAST_DDL_TIME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_host_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'호스트 스키마:';

wwv_flow_api.create_message (
  p_id=>197836608375155848 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.HOST_SCHEMA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_application_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 소유자:';

wwv_flow_api.create_message (
  p_id=>197836717351155848 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.APPLICATION_OWNER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_workspace_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역 ID:';

wwv_flow_api.create_message (
  p_id=>197836830441155848 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.WORKSPACE_ID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_workspace_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역 이름:';

wwv_flow_api.create_message (
  p_id=>197836907143155848 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.WORKSPACE_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_current_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'현재 사용자:';

wwv_flow_api.create_message (
  p_id=>197837017950155848 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.CURRENT_USER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_language_preference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'언어 기호사항:';

wwv_flow_api.create_message (
  p_id=>197837112612155849 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.LANGUAGE_PREFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_current_time_on_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'현재 시간(서버):';

wwv_flow_api.create_message (
  p_id=>197837231126155849 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.CURRENT_TIME_ON_SERVER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_add_member_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'멤버 추가 오류입니다.';

wwv_flow_api.create_message (
  p_id=>197837302497155849 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.ADD_MEMBER_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_update_member_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'멤버 갱신 오류입니다.';

wwv_flow_api.create_message (
  p_id=>197837419249155849 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.UPDATE_MEMBER_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_create_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스크립트를 작성하는 중 오류가 발생했습니다.';

wwv_flow_api.create_message (
  p_id=>197837523218155849 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CREATE_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_missing_app_reg1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'portal_sso_redirect에 오류 발생: 애플리케이션 등록 정보 누락:';

wwv_flow_api.create_message (
  p_id=>197837623841155849 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.MISSING_APP_REG1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_missing_app_reg2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'설치 설명서에 설명된 대로 이 애플리케이션을 등록하십시오.';

wwv_flow_api.create_message (
  p_id=>197837725167155850 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.MISSING_APP_REG2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_redir_err1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'협력 애플리케이션 이름 %1을(를) 사용하여 portal_sso_redirect 프로시저를 %0 스키마로 실행할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197837829759155850 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.REDIR_ERR1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_process_success_err1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 프로시저의 잘못된 호출자:';

wwv_flow_api.create_message (
  p_id=>197837900545155850 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.PROCESS_SUCCESS_ERR1',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message please_contact_administrator
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'관리자에게 문의하십시오.';

wwv_flow_api.create_message (
  p_id=>197838015557155850 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PLEASE_CONTACT_ADMINISTRATOR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_process_success_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0의 호출자를 확인하는 중 오류 발생';

wwv_flow_api.create_message (
  p_id=>197838103473155850 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.PROCESS_SUCCESS_ERR2',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_invalid_app_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URLC 토큰에 부적합한 애플리케이션 세션이 있음: %0';

wwv_flow_api.create_message (
  p_id=>197838215713155851 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.INVALID_APP_SESSION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_generic_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0에 오류 발생';

wwv_flow_api.create_message (
  p_id=>197838320179155851 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO_GENERIC_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_bad_urlc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%1 토큰의 잘못된 %0이(가) SSO에 의해 반환되었습니다.';

wwv_flow_api.create_message (
  p_id=>197838417624155851 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.BAD_URLC',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'협력 애플리케이션 이름 %2을(를) 사용하여 %0 프로시저를 %1 스키마로 실행할 수 없음';

wwv_flow_api.create_message (
  p_id=>197838506626155851 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.PARSE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_render_shortcut_unknown_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류: 알 수 없는 단축키 유형입니다.';

wwv_flow_api.create_message (
  p_id=>197838617582155851 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_RENDER_SHORTCUT.UNKNOWN_TYPE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_add_word
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단어 추가';

wwv_flow_api.create_message (
  p_id=>197838712375155851 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.ADD_WORD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_word_added
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'딕셔너리에 %0이(가) 추가되었습니다.';

wwv_flow_api.create_message (
  p_id=>197838816281155852 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.WORD_ADDED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_dup_word_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'딕셔너리에 %0이(가) 있습니다.';

wwv_flow_api.create_message (
  p_id=>197838902608155852 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.DUP_WORD_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_done
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'완료';

wwv_flow_api.create_message (
  p_id=>197839017569155852 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_DONE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_cancel
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'취소';

wwv_flow_api.create_message (
  p_id=>197839107914155852 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_CANCEL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_apply_changes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'변경 사항 적용';

wwv_flow_api.create_message (
  p_id=>197839228731155852 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_APPLY_CHANGES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_add_to_dictionary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'딕셔너리에 추가';

wwv_flow_api.create_message (
  p_id=>197839322395155853 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_ADD_TO_DICTIONARY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_pick_a_word
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'단어 선택';

wwv_flow_api.create_message (
  p_id=>197839410951155853 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.PICK_A_WORD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_enter_new_word
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새 단어를 입력하십시오.';

wwv_flow_api.create_message (
  p_id=>197839513582155853 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.ENTER_NEW_WORD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_tree_unexpected_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'예상치 않은 오류 %0';

wwv_flow_api.create_message (
  p_id=>197839626673155853 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_TREE.UNEXPECTED_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_calculator_window_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'계산기';

wwv_flow_api.create_message (
  p_id=>197839716785155853 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CALCULATOR.WINDOW_TITLE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_calculator_cancel
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'취소';

wwv_flow_api.create_message (
  p_id=>197839805804155853 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CALCULATOR.CANCEL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_calculator_done
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'완료';

wwv_flow_api.create_message (
  p_id=>197839924172155854 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CALCULATOR.DONE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_no_flow_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'선택된 애플리케이션이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197840017084155854 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.NO_FLOW_SELECTED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message vertical
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'수직';

wwv_flow_api.create_message (
  p_id=>197840119208155854 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VERTICAL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message horizontal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'수평';

wwv_flow_api.create_message (
  p_id=>197840219720155854 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HORIZONTAL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_username
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자 이름';

wwv_flow_api.create_message (
  p_id=>197840306119155854 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_USERNAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_user_api_t_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'전자 메일';

wwv_flow_api.create_message (
  p_id=>197840429363155854 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_USER_API.T_EMAIL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_password
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'암호';

wwv_flow_api.create_message (
  p_id=>197840531868155855 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_PASSWORD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_privilege
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'권한';

wwv_flow_api.create_message (
  p_id=>197840627430155855 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_PRIVILEGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0명의 사용자를 로드했습니다.';

wwv_flow_api.create_message (
  p_id=>197840732002155855 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_MESSAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리';

wwv_flow_api.create_message (
  p_id=>197840803730155855 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류';

wwv_flow_api.create_message (
  p_id=>197840919210155855 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_max_rows_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 실패: 표시할 최대 행은 0보다 커야 합니다.';

wwv_flow_api.create_message (
  p_id=>197841026262155855 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.MAX_ROWS_GT_ZERO_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_invalid_col_num
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'질의에 정의된 열 수가 부적합합니다. 이 영역 유형에 대해 %0개의 열이 필요합니다.';

wwv_flow_api.create_message (
  p_id=>197841107797155856 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.INVALID_COL_NUM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_max_gt_min_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 실패: 축 최대값은 축 최소값보다 커야 합니다.';

wwv_flow_api.create_message (
  p_id=>197841218118155856 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_MAX_GT_MIN_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_bar_width_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 실패: 막대 너비는 0보다 커야 합니다.';

wwv_flow_api.create_message (
  p_id=>197841315885155856 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.BAR_WIDTH_GT_ZERO_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_int_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 실패: 축 간격은 0보다 커야 합니다.';

wwv_flow_api.create_message (
  p_id=>197841409491155856 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_INT_GT_ZERO_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_min_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 실패: 축 최소값은 0보다 크거나 같아야 합니다.';

wwv_flow_api.create_message (
  p_id=>197841524074155856 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_MIN_GT_ZERO_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_max_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 실패: 축 최대값은 0보다 커야 합니다.';

wwv_flow_api.create_message (
  p_id=>197841629240155857 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_MAX_GT_ZERO_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message query_invalid_no_select
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 질의입니다. Select 문을 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197841712312155857 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUERY.INVALID_NO_SELECT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_gaps_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 실패: 막대 사이의 간격은 0보다 크거나 같아야 합니다.';

wwv_flow_api.create_message (
  p_id=>197841814519155857 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.GAPS_GT_ZERO_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_max_gt_min_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 실패: Y축 최대값은 축 최소값보다 커야 합니다.';

wwv_flow_api.create_message (
  p_id=>197841919389155857 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_MAX_GT_MIN_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_x_axis_int_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 실패: X축 간격은 0보다 커야 합니다.';

wwv_flow_api.create_message (
  p_id=>197842023832155857 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.X_AXIS_INT_GT_ZERO_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_int_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 실패: Y축 간격은 0보다 커야 합니다.';

wwv_flow_api.create_message (
  p_id=>197842118228155857 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_INT_GT_ZERO_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_x_axis_min_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 실패: X축 최소값은 0보다 크거나 같아야 합니다.';

wwv_flow_api.create_message (
  p_id=>197842203165155858 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.X_AXIS_MIN_GT_ZERO_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_min_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 실패: Y축 최소값은 0보다 크거나 같아야 합니다.';

wwv_flow_api.create_message (
  p_id=>197842316403155858 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_MIN_GT_ZERO_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_x_axis_max_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 실패: X축 최대값은 0보다 커야 합니다.';

wwv_flow_api.create_message (
  p_id=>197842417899155858 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.X_AXIS_MAX_GT_ZERO_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_max_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'검증 실패: Y축은 0보다 커야 합니다.';

wwv_flow_api.create_message (
  p_id=>197842500091155858 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_MAX_GT_ZERO_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_unable_get_color_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'색상을 가져올 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197842603159155858 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.UNABLE_GET_COLOR_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_func_ret_sql_qry_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 질의를 반환하는 함수: 애플리케이션 생성기 내에서 질의 구문을 분석할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197842712219155858 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.FUNC_RET_SQL_QRY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_parse_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'구문 분석 오류: %0 ';

wwv_flow_api.create_message (
  p_id=>197842813528155859 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.PARSE_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_fetch_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인출 오류: %0';

wwv_flow_api.create_message (
  p_id=>197842927188155859 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.FETCH_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_unable_calc_graph_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'그래프 홀더 위치를 계산할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197843005970155859 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.UNABLE_CALC_GRAPH_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_svg_chart_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SVG 차트 오류: %0';

wwv_flow_api.create_message (
  p_id=>197843129796155859 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.SVG_CHART_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_more_data_fnd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'더 많은 데이터를 찾았지만 최대 31개의 값만 표시할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197843206447155859 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.MORE_DATA_FND_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_top
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'최상위';

wwv_flow_api.create_message (
  p_id=>197843327409155859 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_TOP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_bottom
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'아래쪽';

wwv_flow_api.create_message (
  p_id=>197843417285155860 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_BOTTOM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_up
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작동 중';

wwv_flow_api.create_message (
  p_id=>197843501757155860 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_UP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'아래로';

wwv_flow_api.create_message (
  p_id=>197843622842155860 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_DOWN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_move
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이동';

wwv_flow_api.create_message (
  p_id=>197843711814155860 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_MOVE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_move_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모두 이동';

wwv_flow_api.create_message (
  p_id=>197843817441155860 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_MOVE_ALL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_remove
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제거';

wwv_flow_api.create_message (
  p_id=>197843926228155860 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_REMOVE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_remove_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모두 제거';

wwv_flow_api.create_message (
  p_id=>197844016457155861 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_REMOVE_ALL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_reset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'재설정';

wwv_flow_api.create_message (
  p_id=>197844105132155861 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_RESET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_unable_fnd_userid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'쿠키에서 USERID를 찾을 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197844231478155861 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.UNABLE_FND_USERID_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_exception
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'예외 사항';

wwv_flow_api.create_message (
  p_id=>197844310632155861 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.EXCEPTION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류: %0';

wwv_flow_api.create_message (
  p_id=>197844430456155861 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_invalid_cookie_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 ASFCOOKIE입니다. 다시 애플리케이션에 로그인하십시오.';

wwv_flow_api.create_message (
  p_id=>197844517014155862 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.INVALID_COOKIE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_creating_workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역 생성 중';

wwv_flow_api.create_message (
  p_id=>197844600610155862 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.CREATING_WORKSPACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음';

wwv_flow_api.create_message (
  p_id=>197844729552155862 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.NEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_next_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음 집합';

wwv_flow_api.create_message (
  p_id=>197844829124155862 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.NEXT_SET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이전';

wwv_flow_api.create_message (
  p_id=>197844912082155862 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.PREVIOUS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_previous_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'이전 집합';

wwv_flow_api.create_message (
  p_id=>197845015231155862 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.PREVIOUS_SET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_invalid_user_pass_cookie_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자 이름 또는 암호가 부적합하거나, 쿠키가 만기되었습니다. 다시 로그인하십시오.';

wwv_flow_api.create_message (
  p_id=>197845119345155863 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.INVALID_USER_PASS_COOKIE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_calendar2_from_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%1 질의의 %0';

wwv_flow_api.create_message (
  p_id=>197845200462155863 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CALENDAR2.FROM_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_calendar2_in_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%1 질의의 %0';

wwv_flow_api.create_message (
  p_id=>197845316995155863 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CALENDAR2.IN_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_calendar2_fetch_cal_cursor_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'달력 커서에서 인출하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197845411404155863 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CALENDAR2.FETCH_CAL_CURSOR_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_no_sgid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보안 그룹 ID(작업 영역 ID)가 설정되지 않았습니다.';

wwv_flow_api.create_message (
  p_id=>197845504538155863 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY.NO_SGID_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_copy를 실행하는 중 오류 발생: %0 >> %1';

wwv_flow_api.create_message (
  p_id=>197845629678155863 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY.EXECUTION_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_button_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_copy_button을 실행하는 중 오류 발생: %0 >> %1';

wwv_flow_api.create_message (
  p_id=>197845727645155864 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_BUTTON.EXECUTION_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_page_item_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_copy_page_item을 실행하는 중 오류 발생: %0 >> %1';

wwv_flow_api.create_message (
  p_id=>197845815260155864 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_PAGE_ITEM.EXECUTION_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_lov_numeric_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'값 목록 ID "%0"은(는) 숫자가 아닙니다.';

wwv_flow_api.create_message (
  p_id=>197845903011155864 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_LOV.NUMERIC_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_lov_not_found_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'값 목록 ID "%0"을(를) 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197846027131155864 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_LOV.NOT_FOUND_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_lov_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_copy_lov를 실행하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197846118561155864 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_LOV.EXECUTION_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_util_unable_to_find_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'복사할 단축키(%0)를 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197846204479155864 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_UTIL.UNABLE_TO_FIND_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_ws_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 작업 영역이 생성되어 확인 전자 메일이 %2에 %1(으)로 전송되었습니다.';

wwv_flow_api.create_message (
  p_id=>197846318535155865 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WS_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message return_to_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 로그인 페이지로 돌아가기';

wwv_flow_api.create_message (
  p_id=>197846423129155865 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RETURN_TO_LOGIN_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_disable_work_prov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 영역 생성이 일시적으로 사용 안함으로 설정되었습니다.';

wwv_flow_api.create_message (
  p_id=>197846512539155865 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.DISABLE.WORK.PROV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_add_constraint
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 제약 조건 추가';

wwv_flow_api.create_message (
  p_id=>197846612526155865 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ADD_CONSTRAINT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message created_on
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'생성 날짜';

wwv_flow_api.create_message (
  p_id=>197846721342155865 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATED_ON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message updated_on
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'갱신 날짜';

wwv_flow_api.create_message (
  p_id=>197846825029155866 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATED_ON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row_order
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'행 순서';

wwv_flow_api.create_message (
  p_id=>197846921049155866 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW_ORDER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_as_of
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시점: %0';

wwv_flow_api.create_message (
  p_id=>197847003578155866 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AS_OF',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_min_ago
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0분 전';

wwv_flow_api.create_message (
  p_id=>197847130398155866 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_MIN_AGO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_format_mask
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'형식 마스크';

wwv_flow_api.create_message (
  p_id=>197847221341155866 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_FORMAT_MASK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'계산';

wwv_flow_api.create_message (
  p_id=>197847310061155866 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPUTATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_choose_download_format
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 다운로드 형식을 선택하십시오.';

wwv_flow_api.create_message (
  p_id=>197847412726155867 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CHOOSE_DOWNLOAD_FORMAT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ir_frm_nav_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'폼 탐색을 계산할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197847501428155867 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IR_FRM_NAV_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_report_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'&lt; 보고서 보기';

wwv_flow_api.create_message (
  p_id=>197847613043155867 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_REPORT_VIEW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row_of
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'행 %0/%1';

wwv_flow_api.create_message (
  p_id=>197847729509155867 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW_OF',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ir_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 오류. %1';

wwv_flow_api.create_message (
  p_id=>197847813860155867 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IR_ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_verify_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 확인 오류: %1';

wwv_flow_api.create_message (
  p_id=>197847927582155867 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.VERIFY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(페이지 생성)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197848001427155868 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_PAGE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_pg_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(페이지 템플리트 작성)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197848105674155868 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_PG_TEMPLATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_field_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(필드 템플리트 작성)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197848209822155868 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_FIELD_TEMPLATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_create_rpt_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(보고서 템플리트 작성)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197848332523155868 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW.CREATE_RPT_TEMPLATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_region_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(영역 템플리트 작성)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197848409298155868 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_REGION_TEMPLATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_list_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(목록 템플리트 작성)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197848522839155868 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_LIST_TEMPLATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_menu_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(연결 고리 템플리트 작성)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197848603845155869 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_MENU_TEMPLATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_popup_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(팝업 값 목록 템플리트 작성)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197848719862155869 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_POPUP_TEMPLATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_standard_tabs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(표준 탭 생성)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197848832090155869 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_STANDARD_TABS_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_compute_tab_target_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(탭 대상 수 계산)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197848903674155869 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COMPUTE_TAB_TARGET_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_parent_tabs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(상위 탭 생성)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197849019183155869 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_PARENT_TABS_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_page_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(페이지 템플리트 복사)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197849125952155869 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_PAGE_TEMPLATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_field_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(필드 템플리트 복사)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197849228467155870 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_FIELD_TEMPLATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_report_templates_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(보고서 템플리트 복사)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197849307921155870 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_REPORT_TEMPLATES_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_region_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(영역 템플리트 복사)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197849422540155870 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_REGION_TEMPLATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_list_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(목록 템플리트 복사)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197849520781155870 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_LIST_TEMPLATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_menu_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(연결 고리 템플리트 복사)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197849610835155870 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_MENU_TEMPLATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_button_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(단추 템플리트 복사)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197849726046155870 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_BUTTON_TEMPLATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_navbar_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(탐색 도구 모음 복사)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197849816537155871 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_NAVBAR_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(값 목록 복사)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197849918081155871 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_LOV_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_security_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(보안 체계 복사)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197850017641155871 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_SECURITY_SCHEME_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_crypt_key_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'키는 8바이트, 16바이트 또는 24바이트여야 합니다.';

wwv_flow_api.create_message (
  p_id=>197850128715155871 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CRYPT.KEY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_css_api_unable_to_remove_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'CSS를 제거할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197850225737155871 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CSS_API.UNABLE_TO_REMOVE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_debugtab_biu_fer_invalid_date_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 날짜 형식입니다.';

wwv_flow_api.create_message (
  p_id=>197850316794155871 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DEBUGTAB_BIU_FER.INVALID_DATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_unable_to_bind_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0을(를) 바인드할 수 없습니다. 항목의 길이가 30바이트 이하인지 확인하십시오. 30바이트보다 긴 항목을 참조하려면 v() 구문을 사용하십시오. %1';

wwv_flow_api.create_message (
  p_id=>197850427879155872 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.UNABLE_TO_BIND_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message run_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'실행만';

wwv_flow_api.create_message (
  p_id=>197850500709155872 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RUN_ONLY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wizapi_delete_checked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'선택된 항목 삭제';

wwv_flow_api.create_message (
  p_id=>197850612080155872 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WIZAPI_DELETE_CHECKED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p18_script_olb_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Forms 객체 라이브러리 XML 파일 이름';

wwv_flow_api.create_message (
  p_id=>197850702256155872 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P18_SCRIPT_OLB_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_authorization_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(권한 체계 복사)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197850825678155872 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_AUTHORIZATION_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_authentication_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션(인증 체계 복사)을 생성하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197850931986155872 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_AUTHENTICATION_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cannot_determine_flow_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류입니다. 애플리케이션의 제공된 보안 그룹 ID 및 애플리케이션 별칭을 확인할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197851001330155873 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CANNOT_DETERMINE_FLOW_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_alias_convert_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 별칭 "%0"을(를) 고유 애플리케이션 ID로 변환할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197851122443155873 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ALIAS_CONVERT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_alias_exist_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 별칭이 존재하지 않습니다.';

wwv_flow_api.create_message (
  p_id=>197851213246155873 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ALIAS_EXIST_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_home_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'홈 페이지로 이동할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197851330710155873 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_HOME_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_update_sub_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'update_substitution_cache에 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197851430380155873 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UPDATE_SUB_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_dml_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DML에 오류 발생: p_rowid=%0, p_alt_rowid=%1, p_rowid2=%2, p_alt_rowid2=%3. %4';

wwv_flow_api.create_message (
  p_id=>197851510596155873 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.DML_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_unable_proc_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_conditions에서 조건 유형 "%0"을(를) 처리할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197851616189155874 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.UNABLE_PROC_COND_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_unexpected_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_conditions에 예상치 않은 오류가 발생했습니다. 함수가 몇 개의 값을 반환해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197851715654155874 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.UNEXPECTED_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_no_rows_to_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'처리할 행 없음';

wwv_flow_api.create_message (
  p_id=>197851800416155874 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.NO_ROWS_TO_PROCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_table_owner_not_specified
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블 소유자가 지정되지 않음';

wwv_flow_api.create_message (
  p_id=>197851924928155874 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.TABLE_OWNER_NOT_SPECIFIED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_table_name_not_specified
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블 이름이 지정되지 않음';

wwv_flow_api.create_message (
  p_id=>197852010567155874 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.TABLE_NAME_NOT_SPECIFIED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_prim_key_col_not_specified
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본 키 열이 지정되지 않음';

wwv_flow_api.create_message (
  p_id=>197852128523155874 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.PRIM_KEY_COL_NOT_SPECIFIED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_fcs_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'체크섬 열("FCS")이 필요한데 제공되지 않음';

wwv_flow_api.create_message (
  p_id=>197852228838155875 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.FCS_MISSING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_invalid_prim_key_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'질의 선택 목록에서 지정된 기본 키 열을 찾을 수 없음';

wwv_flow_api.create_message (
  p_id=>197852319657155875 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.INVALID_PRIM_KEY_COL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_no_prim_key_vals
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제공된 기본 키 값이 없습니다. 갱신을 수행하려면 적어도 한 개의 행을 제공해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197852412311155875 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.NO_PRIM_KEY_VALS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_cal_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'달력 템플리트에 적용할 수 없습니다. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197852501018155875 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_CAL_TEMPLATE_REFERENCE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_cal_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'달력 템플리트를 게시할 수 없습니다. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>197852608657155875 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_CAL_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message autocommit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'커밋 명령문을 적용할 수 없습니다. 모든 명령문이 자동으로 커밋되었습니다.';

wwv_flow_api.create_message (
  p_id=>197852714703155875 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTOCOMMIT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message rollback
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'롤백 명령문을 적용할 수 없습니다. 모든 명령문이 자동으로 커밋되었습니다.';

wwv_flow_api.create_message (
  p_id=>197852828981155876 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ROLLBACK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p254_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'생성할 영역을 한 개 이상 지정해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197852926193155876 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P254.VALIDATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작성할 페이지를 한 개 이상 지정해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197853016864155876 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P295.VALIDATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_sec_key_col_not_in_select_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'질의 선택 목록에서 지정된 보조 키 열을 찾을 수 없음';

wwv_flow_api.create_message (
  p_id=>197853107646155876 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_no_sec_key_vals
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'식별된 보조 키 열에 대해 제공된 보조 값 없음';

wwv_flow_api.create_message (
  p_id=>197853216192155876 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.NO_SEC_KEY_VALS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_calendar_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'달력 열입니다.';

wwv_flow_api.create_message (
  p_id=>197853325461155876 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.CALENDAR_COLUMN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p108_menu_file_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'메뉴';

wwv_flow_api.create_message (
  p_id=>197853418342155877 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P108_MENU_FILE_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_error_in_mru
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'MRU에 오류 발생: 행= %0, %1, %2';

wwv_flow_api.create_message (
  p_id=>197853503775155877 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.ERROR_IN_MRU',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_lost_update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자가 갱신 프로세스를 시작했으므로 데이터베이스에 있는 데이터의 현재 버전이 변경되었습니다. 현재 체크섬 = "%0", 항목 체크섬 = "%1".';

wwv_flow_api.create_message (
  p_id=>197853630206155877 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.LOST_UPDATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_job_unauthorized_attempt_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%2 애플리케이션에서 %1 스키마가 %0 작업을 무단으로 실행하려고 했습니다.';

wwv_flow_api.create_message (
  p_id=>197853714443155877 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_JOB.UNAUTHORIZED_ATTEMPT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_bg_select_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'팝업 값 목록은 "select"로 시작해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197853815291155877 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_BG_SELECT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_init_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'팝업 값 목록을 초기화하는 중 오류 발생: %0 %1';

wwv_flow_api.create_message (
  p_id=>197853932116155877 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_INIT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_filter_init_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'필터를 사용하여 팝업 값 목록을 초기화하는 중 오류 발생: %0 %1';

wwv_flow_api.create_message (
  p_id=>197854030881155878 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_FILTER_INIT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_generate_popup_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'팝업 값 목록을 생성하는 중 오류 발생: %0 %1';

wwv_flow_api.create_message (
  p_id=>197854124565155878 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.GENERATE_POPUP_LOV_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_no_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'콤보 상자 유형의 %0 항목에 질의가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197854206244155878 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_NO_QUERY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_js_no_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'js 재지정을 사용하는 콤보 상자 유형의 %0 항목에 질의가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197854331727155878 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_JS_NO_QUERY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_url_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL 재지정을 사용하는 콤보 상자 유형의 %0 항목에 질의가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197854418012155878 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_URL_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_url_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 URL 재지정을 사용하는 콤보 상자 유형의 %0 항목에 질의가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197854531631155878 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_URL_PAGE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_package_invalid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류입니다. 패키지 이름 %0이(가) 부적합하거나 이미 사용 중입니다.';

wwv_flow_api.create_message (
  p_id=>197854619905155879 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.PACKAGE_INVALID_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p108_prog_file_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로그램 단위';

wwv_flow_api.create_message (
  p_id=>197854700467155879 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P108_PROG_FILE_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generic_attr_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류';

wwv_flow_api.create_message (
  p_id=>197854820775155879 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERIC_ATTR.ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_olb_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Forms 이전 프로젝트에 업로드하려고 시도한 파일이 적합한 객체 라이브러리(_olb.XML) 파일이 아닙니다. Oracle Forms에 포함된 Forms2XML 변환 툴로 생성된 객체 라이브러리 XML 파일만 업로드할 수 있습니다.';

wwv_flow_api.create_message (
  p_id=>197854929609155879 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_OLB_CONTENT_INVALID',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_layout_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류';

wwv_flow_api.create_message (
  p_id=>197855013877155879 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_LAYOUT.ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_navbar_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탐색 도구 모음 표시 조건 유형을 갱신할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197855128367155879 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_NAVBAR_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_flow_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'조건 유형이 다음과 같을 때 애플리케이션 프로세스를 갱신할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197855200718155880 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_FLOW_PROC_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_flow_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 계산 유형을 갱신할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197855311046155880 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_FLOW_COMP_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_subtitle_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 하위 제목 유형을 갱신할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197855401819155880 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_SUBTITLE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_button_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 단추 조건 유형을 갱신할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197855517975155880 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_BUTTON_COND_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_branch_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 분기 조건 유형을 갱신할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197855607232155880 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.BRANCH_COND_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 계산 유형을 갱신할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197855725108155880 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_COMP_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_valid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 검증 유형을 갱신할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197855802471155881 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_VALID_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 프로세스 유형을 갱신할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197855924547155881 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_PROC_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_misspell_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'철자가 잘못된 단어를 갱신하는 중 오류가 발생했습니다. %0';

wwv_flow_api.create_message (
  p_id=>197856023318155881 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_MISSPELL_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_unable_to_bind_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0을(를) 바인드할 수 없습니다. 항목의 길이가 30바이트 이하인지 확인하십시오. 30바이트보다 긴 항목을 참조하려면 v() 구문을 사용하십시오. %1';

wwv_flow_api.create_message (
  p_id=>197856109134155881 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.UNABLE_TO_BIND_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_popup_lov_convert_id_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1711 요청에 있는 팝업 LOV ID를 변환할 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197856210265155881 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_POPUP_LOV.CONVERT_ID_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_popup_lov_find_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1721 요청에서 팝업 LOV ID에 대한 항목을 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197856302637155881 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_POPUP_LOV.FIND_ITEM_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_drop_tablespace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'drop_tablespace에 오류가 발생했습니다. p_name이 널입니다.';

wwv_flow_api.create_message (
  p_id=>197856404450155882 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.DROP_TABLESPACE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_drop_tablespace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블스페이스를 삭제할 수 없습니다. 오류: %0 \nSQL:\n %1';

wwv_flow_api.create_message (
  p_id=>197856523439155882 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_DROP_TABLESPACE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_drop_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'drop_user에 오류가 발생했습니다. l_username이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197856606953155882 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.DROP_USER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_drop_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자를 삭제할 수 없습니다. 오류: %0 \nSQL:\n %1';

wwv_flow_api.create_message (
  p_id=>197856723014155882 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_DROP_USER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_with_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류 발생: %0 %1';

wwv_flow_api.create_message (
  p_id=>197856807099155882 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.WITH_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_create_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자를 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197856928217155882 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_CREATE_USER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_create_tablespace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블스페이스를 생성할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197857017327155883 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_CREATE_TABLESPACE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_grant_privs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'초기 권한을 부여할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197857108633155883 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_GRANT_PRIVS_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_remove_company_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'remove_provisioned_company.에 오류가 있습니다. 작업 영역이 널입니다.';

wwv_flow_api.create_message (
  p_id=>197857224966155883 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.REMOVE_COMPANY_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블이 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197857328870155883 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_view_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'뷰가 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197857431891155883 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.VIEW_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류';

wwv_flow_api.create_message (
  p_id=>197857520803155883 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_trigger_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'트리거가 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197857619334155884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TRIGGER_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_function_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'함수가 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197857723533155884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.FUNCTION_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_procedure_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로시저가 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197857828917155884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PROCEDURE_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_pkg_body_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'패키지 본문이 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197857913201155884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PKG_BODY_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_pkg_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'패키지가 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197858023719155884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PKG_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_index_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인덱스가 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197858122072155884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEX_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_type_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'유형이 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197858217053155885 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TYPE_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_user_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자가 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197858319355155885 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.USER_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_materialized_view_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'구체화된 뷰가 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197858422791155885 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.MATERIALIZED_VIEW_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_role_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'롤이 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197858529059155885 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROLE_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_seq_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시퀀스가 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197858603236155885 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SEQ_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_synonym_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'동의어가 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197858718913155885 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SYNONYM_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_cmd_executed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'명령이 실행되었습니다.';

wwv_flow_api.create_message (
  p_id=>197858810053155886 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.CMD_EXECUTED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_util_table_create_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 SQL 구문으로 인해 테이블 생성을 실패했습니다.';

wwv_flow_api.create_message (
  p_id=>197858930649155886 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_UTIL.TABLE_CREATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_rows_updated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0개의 행이 갱신되었습니다.';

wwv_flow_api.create_message (
  p_id=>197859003684155886 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROWS_UPDATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_rows_inserted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0개의 행이 삽입되었습니다.';

wwv_flow_api.create_message (
  p_id=>197859122340155886 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROWS_INSERTED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_util_package_create_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부적합한 SQL 구문으로 인해 패키지 생성을 실패했습니다.';

wwv_flow_api.create_message (
  p_id=>197859222543155886 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_UTIL.PACKAGE_CREATE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_rows_deleted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0개의 행이 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197859308907155886 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROWS_DELETED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류';

wwv_flow_api.create_message (
  p_id=>197859402718155887 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_admin_api_fetch_fnd_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'FND 사용자 정보를 인출할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197859512582155887 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ADMIN_API.FETCH_FND_USER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_admin_api_delete_dev_role_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'개발자 롤을 삭제하는 중 오류가 발생했습니다. %0';

wwv_flow_api.create_message (
  p_id=>197859632743155887 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ADMIN_API.DELETE_DEV_ROLE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_user_no_priv_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 사용자에게 %1 스키마에 대한 권한이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197859723537155887 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.USER_NO_PRIV_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_updatable_report_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'갱신 가능한 보고서 구문 분석 오류: %0';

wwv_flow_api.create_message (
  p_id=>197859809962155887 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.UPDATABLE_REPORT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블이 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197859921190155888 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_pkg_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'패키지가 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197860020277155888 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PKG_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_user_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자가 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197860124101155888 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.USER_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_view_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'뷰가 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197860222373155888 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.VIEW_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_page_execution_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wwv_flow_copy_page를 실행하는 중 오류 발생: %0 >> %1';

wwv_flow_api.create_message (
  p_id=>197860310198155888 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_PAGE.EXECUTION_PAGE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_seq_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시퀀스가 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197860405266155888 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SEQ_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블이 변경되었습니다.';

wwv_flow_api.create_message (
  p_id=>197860522492155889 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_ALTERED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dataload_xml_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류';

wwv_flow_api.create_message (
  p_id=>197860608853155889 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DATALOAD_XML.ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_function_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'함수가 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197860701118155889 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.FUNCTION_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_procedure_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로시저가 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197860805460155889 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PROCEDURE_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_developer_api_credentials_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인증되지 않은 액세스입니다. (wwv_flow_api.set_credentials가 설정되지 않음)';

wwv_flow_api.create_message (
  p_id=>197860926631155889 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_DEVELOPER_API.CREDENTIALS_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_developer_api_dev_role_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'개발자 롤을 삭제하는 중 오류가 발생했습니다. %0';

wwv_flow_api.create_message (
  p_id=>197861018848155889 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_DEVELOPER_API.DEV_ROLE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_index_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인덱스가 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197861124021155890 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEX_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_materialized_view_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'구체화된 뷰가 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197861226709155890 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.MATERIALIZED_VIEW_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_role_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'롤이 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197861304682155890 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROLE_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_synonym_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'동의어가 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197861408366155890 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SYNONYM_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_trigger_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'트리거가 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197861500381155890 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TRIGGER_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_type_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'유형이 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197861616137155890 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TYPE_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_indextype_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인덱스 유형이 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197861701660155891 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEXTYPE_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_context_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'컨텍스트가 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197861809115155891 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.CONTEXT_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_database_link_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 링크가 삭제되었습니다.';

wwv_flow_api.create_message (
  p_id=>197861917407155891 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.DATABASE_LINK_DROPPED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_database_link_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 링크가 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197862018623155891 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.DATABASE_LINK_CREATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_renamed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블 이름이 변경되었습니다.';

wwv_flow_api.create_message (
  p_id=>197862122367155891 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_RENAMED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_view_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'뷰가 변경되었습니다.';

wwv_flow_api.create_message (
  p_id=>197862204833155891 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.VIEW_ALTERED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_type_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'유형이 변경되었습니다.';

wwv_flow_api.create_message (
  p_id=>197862326183155892 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TYPE_ALTERED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_trigger_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'트리거가 변경되었습니다.';

wwv_flow_api.create_message (
  p_id=>197862407223155892 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TRIGGER_ALTERED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_indextype_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인덱스 유형이 변경되었습니다.';

wwv_flow_api.create_message (
  p_id=>197862531905155892 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEXTYPE_ALTERED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_truncated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블이 잘렸습니다.';

wwv_flow_api.create_message (
  p_id=>197862609413155892 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_TRUNCATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_cluster_truncated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'클러스터가 잘렸습니다.';

wwv_flow_api.create_message (
  p_id=>197862711170155892 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.CLUSTER_TRUNCATED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_package_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'패키지가 변경되었습니다.';

wwv_flow_api.create_message (
  p_id=>197862821350155892 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PACKAGE_ALTERED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_function_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'함수가 변경되었습니다.';

wwv_flow_api.create_message (
  p_id=>197862915379155893 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.FUNCTION_ALTERED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_procedure_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로시저가 변경되었습니다.';

wwv_flow_api.create_message (
  p_id=>197863005826155893 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PROCEDURE_ALTERED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_seq_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시퀀스가 변경되었습니다.';

wwv_flow_api.create_message (
  p_id=>197863123831155893 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SEQ_ALTERED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_user_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'사용자가 변경되었습니다.';

wwv_flow_api.create_message (
  p_id=>197863217797155893 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.USER_ALTERED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message test
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테스트';

wwv_flow_api.create_message (
  p_id=>197863322056155893 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEST',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message up
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작동 중';

wwv_flow_api.create_message (
  p_id=>197863411059155894 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_query_heading_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'질의 머리글을 가져오는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197863513827155894 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.QUERY_HEADING_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_column_value_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열 값을 인출하는 중 오류 발생: %0';

wwv_flow_api.create_message (
  p_id=>197863602912155894 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.COLUMN_VALUE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_hint_remove_table_hint_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'remove_table_hint가 p_table_id 없이 호출되었습니다. 테이블을 제공해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197863704529155894 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HINT.REMOVE_TABLE_HINT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_hint_create_normalize_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정규화 생성 오류: %0';

wwv_flow_api.create_message (
  p_id=>197863824388155894 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HINT.CREATE_NORMALIZE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류';

wwv_flow_api.create_message (
  p_id=>197863930200155894 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_find_file_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'파일을 찾을 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197864014813155895 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.FIND_FILE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_find_data_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터 유형 찾기 오류: %0';

wwv_flow_api.create_message (
  p_id=>197864100727155895 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.FIND_DATA_TYPE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_get_max_col_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'최대 열 길이 가져오기 오류 1: %0';

wwv_flow_api.create_message (
  p_id=>197864225882155895 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.GET_MAX_COL_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_get_datatype_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터 유형 가져오기 오류: %0';

wwv_flow_api.create_message (
  p_id=>197864305079155895 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.GET_DATATYPE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_collection_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'콜렉션을 생성할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197864432458155895 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.COLLECTION_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_load_csv_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'CSV 데이터 로드 오류:';

wwv_flow_api.create_message (
  p_id=>197864510585155895 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.LOAD_CSV_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_excel_data_run_ddl_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Excel 로드 DDL 실행 오류: %0 %1';

wwv_flow_api.create_message (
  p_id=>197864611841155896 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_EXCEL_DATA.RUN_DDL_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_excel_data_table_info_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블 정보를 가져올 수 없습니다. l_line=%0 %1';

wwv_flow_api.create_message (
  p_id=>197864720011155896 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_EXCEL_DATA.TABLE_INFO_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_excel_data_load_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Excel 데이터 로드 오류: %0';

wwv_flow_api.create_message (
  p_id=>197864803052155896 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_EXCEL_DATA.LOAD_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_lookup_tables_privs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 사용자에게 %1 스키마에 대한 권한이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197864916903155896 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOOKUP_TABLES.PRIVS_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_find_file_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'파일을 찾을 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197865004695155896 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.FIND_FILE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_unable_get_code_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'코드 블록을 가져올 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197865105321155897 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.UNABLE_GET_CODE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_get_statement_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'명령문을 가져올 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197865231814155897 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.GET_STATEMENT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_save_parameter_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스에 매개변수를 저장할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197865326495155897 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.SAVE_PARAMETER_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_validate_file_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" 파일을 검증할 수 없습니다. %1';

wwv_flow_api.create_message (
  p_id=>197865424055155897 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.VALIDATE_FILE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_check_code_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'코드 구문이 분석되었는지 여부를 확인할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197865501958155897 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.CHECK_CODE_PARSE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_control_file_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제어 파일을 실행할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197865608103155897 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.CONTROL_FILE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_run_code_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'코드를 실행할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197865724104155897 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.RUN_CODE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_bulk_collect_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'대량으로 수집할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197865821992155898 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.BULK_COLLECT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_run_statement_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'명령문을 실행할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197865901785155898 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.RUN_STATEMENT_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_package_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'경고: 컴파일 오류와 함께 패키지 본문이 생성되었습니다.';

wwv_flow_api.create_message (
  p_id=>197866022647155898 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.PACKAGE_COMP_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'명령문 실행 실패: %0';

wwv_flow_api.create_message (
  p_id=>197866110092155898 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.EXECUTION_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_delete_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'구문 분석된 정보를 삭제할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197866231367155898 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.DELETE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_control_file_stats_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제어 파일 통계를 검사할 수 없음: %0';

wwv_flow_api.create_message (
  p_id=>197866304241155899 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.CONTROL_FILE_STATS_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_public_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'파일 구문을 분석할 수 없습니다. %0';

wwv_flow_api.create_message (
  p_id=>197866430658155899 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER_PUBLIC.PARSE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_series_attr_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'오류';

wwv_flow_api.create_message (
  p_id=>197866514394155899 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SERIES_ATTR.ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_tab_mgr_sgid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보안 그룹 ID를 설정해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197866606002155899 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TAB_MGR.SGID_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_tab_mgr_old_tabset_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탭 ID %0에 대한 이전 탭 집합을 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197866726232155899 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TAB_MGR.OLD_TABSET_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_tab_mgr_new_tabset_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'상위 탭 ID %0에 대한 새 탭 집합을 찾을 수 없습니다.';

wwv_flow_api.create_message (
  p_id=>197866817286155899 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TAB_MGR.NEW_TABSET_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_tab_mgr_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 ID %0은(는) 숫자가 아닙니다.';

wwv_flow_api.create_message (
  p_id=>197866928347155900 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TAB_MGR.PAGE_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_tab_mgr_spec_new_tabset_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탭 ID %0에 대한 새 탭 집합을 지정해야 합니다.';

wwv_flow_api.create_message (
  p_id=>197867027510155900 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TAB_MGR.SPEC_NEW_TABSET_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_update_not_supported_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 갱신은 지원되지 않습니다.';

wwv_flow_api.create_message (
  p_id=>197867115049155900 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.UPDATE_NOT_SUPPORTED_ERR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message easy_report_invalid_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'추가 중인 조건으로 인해 질의가 부적합해졌습니다.';

wwv_flow_api.create_message (
  p_id=>197867204921155900 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EASY_REPORT.INVALID_CONDITION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본값: 세로형 보고서, 모양 2(널 열 제외)';

wwv_flow_api.create_message (
  p_id=>197867309043155900 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME4',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본값: 세로형 보고서, 모양 2(널 열 포함)';

wwv_flow_api.create_message (
  p_id=>197867429883155900 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME5',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name13
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본값: 모양 3';

wwv_flow_api.create_message (
  p_id=>197867523759155901 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME13',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name14
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본값: 모양 4';

wwv_flow_api.create_message (
  p_id=>197867611934155901 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME14',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parsing_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'실행 스키마';

wwv_flow_api.create_message (
  p_id=>197867728891155901 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARSING_SCHEMA',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_change_interactive_rpt_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'대화식 보고서 질의를 변경하도록 요청했습니다. 질의에 열을 추가한 경우 해당 열은 보고서 실행 시 표시되지 않습니다. 작업 메뉴를 사용하여 열을 선택하거나 <b>재설정</b>을 눌러야 합니다. 질의에서 열을 제거한 경우 해당 열을 참조하는 기존 필터, 강조 표시 규칙 및 기타 보고서 설정이 비활성화됩니다. 요청을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197867811566155901 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHANGE_INTERACTIVE_RPT_REGION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_removed_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제거된 열';

wwv_flow_api.create_message (
  p_id=>197867909056155901 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REMOVED_COLUMNS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_new_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'새 열';

wwv_flow_api.create_message (
  p_id=>197868023242155901 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NEW_COLUMNS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_table_view_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블/뷰 소유자';

wwv_flow_api.create_message (
  p_id=>197868104125155902 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABLE_VIEW_OWNER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_table_view_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블/뷰 이름';

wwv_flow_api.create_message (
  p_id=>197868217199155902 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABLE_VIEW_NAME',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message close_window
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'창 닫기';

wwv_flow_api.create_message (
  p_id=>197868304216155902 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CLOSE_WINDOW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit_all_page_definition_attributes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모든 페이지 정의 속성 편집';

wwv_flow_api.create_message (
  p_id=>197868416753155902 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT_ALL_PAGE_DEFINITION_ATTRIBUTES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message header
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'머리글 텍스트';

wwv_flow_api.create_message (
  p_id=>197868525233155902 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HEADER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message footer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'바닥글 텍스트';

wwv_flow_api.create_message (
  p_id=>197868606781155903 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FOOTER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message on_load
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'로드 시';

wwv_flow_api.create_message (
  p_id=>197868727160155903 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ON_LOAD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_header
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML 머리글';

wwv_flow_api.create_message (
  p_id=>197868807798155903 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_HEADER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message define_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'값 목록 정의';

wwv_flow_api.create_message (
  p_id=>197868902135155903 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEFINE_LOV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_dynamic_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'동적 값 목록 생성';

wwv_flow_api.create_message (
  p_id=>197869008542155903 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_DYNAMIC_LOV',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_updated_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'갱신자';

wwv_flow_api.create_message (
  p_id=>197869117505155903 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_UPDATED_BY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_created_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'생성자';

wwv_flow_api.create_message (
  p_id=>197869224499155903 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_CREATED_BY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_stored_procedure_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'내장 프로시저 소유자';

wwv_flow_api.create_message (
  p_id=>197869307541155904 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.STORED_PROCEDURE_OWNER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message compile_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL 코드가 성공적으로 컴파일되었습니다(%0). ';

wwv_flow_api.create_message (
  p_id=>197869417938155904 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COMPILE_SUCCESS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message compile_failure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'컴파일 실패, <a href="javascript:goToLine(''%0'')">%0</a> 행(%2)<br />%1';

wwv_flow_api.create_message (
  p_id=>197869514573155904 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COMPILE_FAILURE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_run_warning
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 워크숍에서 무시할 명령문이 포함된 스크립트를 실행하도록 요청했습니다. 요청 내용을 확인하십시오.';

wwv_flow_api.create_message (
  p_id=>197869608965155904 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RUN_WARNING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_block
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'블록';

wwv_flow_api.create_message (
  p_id=>197869731314155904 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_BLOCK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_canvas
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'캔버스';

wwv_flow_api.create_message (
  p_id=>197869806266155904 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_CANVAS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_objectlibrarytab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'객체 라이브러리 탭';

wwv_flow_api.create_message (
  p_id=>197869918286155905 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_OBJECTLIBRARYTAB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_programunit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로그램 단위';

wwv_flow_api.create_message (
  p_id=>197870016028155905 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_PROGRAMUNIT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_propertyclass
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'속성 클래스';

wwv_flow_api.create_message (
  p_id=>197870104979155905 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_PROPERTYCLASS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_visualattribute
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시각적 속성';

wwv_flow_api.create_message (
  p_id=>197870225605155905 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_VISUALATTRIBUTE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_window
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'창';

wwv_flow_api.create_message (
  p_id=>197870307050155905 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_WINDOW',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목';

wwv_flow_api.create_message (
  p_id=>197870416257155906 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_ITEM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_objectgroup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'객체 그룹';

wwv_flow_api.create_message (
  p_id=>197870521620155906 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_OBJECTGROUP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_graphics
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'그래픽';

wwv_flow_api.create_message (
  p_id=>197870619932155906 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_GRAPHICS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_run_empty
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'실행 가능한 명령문이 포함되지 않은 스크립트를 실행하도록 요청했습니다.';

wwv_flow_api.create_message (
  p_id=>197870713302155906 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RUN_EMPTY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reset_pagination
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 번호 매김 재설정';

wwv_flow_api.create_message (
  p_id=>197870802664155906 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RESET_PAGINATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message redirect_to_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 페이지로 재지정';

wwv_flow_api.create_message (
  p_id=>197870904681155906 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REDIRECT_TO_PAGE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message redirect_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0(으)로 재지정';

wwv_flow_api.create_message (
  p_id=>197871017230155906 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REDIRECT_TO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditional
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'조건부';

wwv_flow_api.create_message (
  p_id=>197871109937155907 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONAL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_never
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'무조건 부정';

wwv_flow_api.create_message (
  p_id=>197871202745155907 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT_NEVER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message static_assignment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정적 지정';

wwv_flow_api.create_message (
  p_id=>197871328854155907 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STATIC_ASSIGNMENT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message function_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL 함수 본문';

wwv_flow_api.create_message (
  p_id=>197871417533155907 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNCTION_BODY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_expression
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL 표현식';

wwv_flow_api.create_message (
  p_id=>197871532579155907 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_EXPRESSION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message plsql_expression
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PLSQL 표현식';

wwv_flow_api.create_message (
  p_id=>197871607129155908 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PLSQL_EXPRESSION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'항목 값';

wwv_flow_api.create_message (
  p_id=>197871722285155908 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_VALUE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_session_state_protection_violation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'세션 상태 보호 위반: 체크섬이 포함된 URL을 수동으로 변경하거나, 체크섬이 잘못되었거나 누락된 링크를 사용했기 때문일 수 있습니다. 이 오류의 원인을 알 수 없는 경우에는 애플리케이션 관리자에게 도움을 요청하십시오.';

wwv_flow_api.create_message (
  p_id=>197871822346155908 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SESSION_STATE_PROTECTION_VIOLATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_blocks
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'블록';

wwv_flow_api.create_message (
  p_id=>197871928758155908 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_BLOCKS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_coordinates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'좌표';

wwv_flow_api.create_message (
  p_id=>197872006333155908 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_COORDINATES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_programunits
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'프로그램 단위';

wwv_flow_api.create_message (
  p_id=>197872120520155908 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_PROGRAMUNITS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_recgrps
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'레코드 그룹';

wwv_flow_api.create_message (
  p_id=>197872211903155909 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_RECGRPS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_windows
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'창';

wwv_flow_api.create_message (
  p_id=>197872322804155909 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_WINDOWS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_visualattributes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'시각적 속성';

wwv_flow_api.create_message (
  p_id=>197872415794155909 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_VISUALATTRIBUTES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_triggers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'트리거';

wwv_flow_api.create_message (
  p_id=>197872529094155909 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_TRIGGERS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_alerts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'경보';

wwv_flow_api.create_message (
  p_id=>197872620796155909 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_ALERTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_editor
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'편집기';

wwv_flow_api.create_message (
  p_id=>197872721986155909 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_EDITOR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit_page_attributes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지 속성 편집';

wwv_flow_api.create_message (
  p_id=>197872818534155910 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT_PAGE_ATTRIBUTES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message must_not_be_public_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'공개 사용자가 아니어야 함';

wwv_flow_api.create_message (
  p_id=>197872909834155910 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MUST_NOT_BE_PUBLIC_USER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4050_110_drop_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터베이스 사용자 삭제: %0';

wwv_flow_api.create_message (
  p_id=>197873020132155910 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4050_110_DROP_USERS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4050_110_drop_tablespaces
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'테이블스페이스 및 연관된 데이터 파일 삭제: %0';

wwv_flow_api.create_message (
  p_id=>197873123324155910 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4050_110_DROP_TABLESPACES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message qb_create_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'결과를 확인하려면 적합한 질의를 입력하십시오.';

wwv_flow_api.create_message (
  p_id=>197873200571155910 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QB_CREATE_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_46_ret_to_qry
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'원래 질의로 돌아가기';

wwv_flow_api.create_message (
  p_id=>197873330800155910 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_46_RET_TO_QRY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message list_utilization
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'목록 활용도';

wwv_flow_api.create_message (
  p_id=>197873418888155911 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LIST_UTILIZATION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not_w_argument
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0이(가) 아님';

wwv_flow_api.create_message (
  p_id=>197873505362155911 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT_W_ARGUMENT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_script_size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'스크립트 크기(바이트)';

wwv_flow_api.create_message (
  p_id=>197873608397155911 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_SCRIPT_SIZE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_on_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%1에 의해 %0';

wwv_flow_api.create_message (
  p_id=>197873713618155911 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_ON_BY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message unsupported_data_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'지원되지 않는 데이터 유형';

wwv_flow_api.create_message (
  p_id=>197873827091155911 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UNSUPPORTED_DATA_TYPE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_use_app_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 기본값';

wwv_flow_api.create_message (
  p_id=>197873902179155911 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.USE_APP_TEMPLATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_analysis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'분석';

wwv_flow_api.create_message (
  p_id=>197874010433155912 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_ANALYSIS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'추가';

wwv_flow_api.create_message (
  p_id=>197874102843155912 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ADD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_remove_aggregate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'집계 제거';

wwv_flow_api.create_message (
  p_id=>197874231351155912 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_REMOVE_AGGREGATE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_reports
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서';

wwv_flow_api.create_message (
  p_id=>197874312856155912 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_REPORTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_charts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'차트';

wwv_flow_api.create_message (
  p_id=>197874416081155912 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_CHARTS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_agg_sum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'합계';

wwv_flow_api.create_message (
  p_id=>197874530666155912 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGG_SUM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_agg_avg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'평균';

wwv_flow_api.create_message (
  p_id=>197874618584155913 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGG_AVG',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_agg_max
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'최대값';

wwv_flow_api.create_message (
  p_id=>197874707522155913 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGG_MAX',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_agg_min
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'최소값';

wwv_flow_api.create_message (
  p_id=>197874804885155913 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGG_MIN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_agg_median
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'중간값';

wwv_flow_api.create_message (
  p_id=>197874910091155913 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGG_MEDIAN',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_agg_mode
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모드';

wwv_flow_api.create_message (
  p_id=>197875001848155913 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGG_MODE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'&gt;';

wwv_flow_api.create_message (
  p_id=>197875112567155913 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'&lt;';

wwv_flow_api.create_message (
  p_id=>197875221140155914 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_PREVIOUS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_error_in_mrd
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다중 행 삭제 작업 중 오류 발생: 행= %0, %1, %2';

wwv_flow_api.create_message (
  p_id=>197875307825155914 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.ERROR_IN_MRD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다중 행 작업 실패';

wwv_flow_api.create_message (
  p_id=>197875418595155914 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.ERROR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_attached_library
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'첨부된 라이브러리';

wwv_flow_api.create_message (
  p_id=>197875511849155914 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_ATTACHED_LIBRARY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'메뉴';

wwv_flow_api.create_message (
  p_id=>197875619211155914 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_MENU',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_attribute_object_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'객체 그룹';

wwv_flow_api.create_message (
  p_id=>197875719319155915 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ATTRIBUTE_OBJECT_GROUP',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_used
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0%이(가) 사용됨';

wwv_flow_api.create_message (
  p_id=>197875822491155915 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.USED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_working_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'작업 보고서';

wwv_flow_api.create_message (
  p_id=>197875906953155915 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_WORKING_REPORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서';

wwv_flow_api.create_message (
  p_id=>197876011516155915 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_REPORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'차트';

wwv_flow_api.create_message (
  p_id=>197876123160155915 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CHART',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'달력';

wwv_flow_api.create_message (
  p_id=>197876232326155915 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CALENDAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_unknown_statement
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'알 수 없는 명령문';

wwv_flow_api.create_message (
  p_id=>197876306075155916 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.UNKNOWN_STATEMENT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message breadcrumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리';

wwv_flow_api.create_message (
  p_id=>197876406139155916 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BREADCRUMB',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message breadcrumbs
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'연결 고리';

wwv_flow_api.create_message (
  p_id=>197876527084155916 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BREADCRUMBS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'모두';

wwv_flow_api.create_message (
  p_id=>197876600406155916 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ALL',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_go
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'실행';

wwv_flow_api.create_message (
  p_id=>197876722458155916 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_GO',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'열 선택';

wwv_flow_api.create_message (
  p_id=>197876823860155916 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_COLUMNS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_filter
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'필터';

wwv_flow_api.create_message (
  p_id=>197876930852155917 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_FILTER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_sort
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정렬';

wwv_flow_api.create_message (
  p_id=>197877026105155917 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_highlight
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'강조 표시';

wwv_flow_api.create_message (
  p_id=>197877115790155917 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HIGHLIGHT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_flashback
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'플래시백';

wwv_flow_api.create_message (
  p_id=>197877209281155917 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_FLASHBACK',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_compute
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'계산';

wwv_flow_api.create_message (
  p_id=>197877311465155917 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPUTE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_download
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다운로드';

wwv_flow_api.create_message (
  p_id=>197877416515155917 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DOWNLOAD',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_save_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'보고서 저장';

wwv_flow_api.create_message (
  p_id=>197877521324155918 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SAVE_REPORT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_reset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'재설정';

wwv_flow_api.create_message (
  p_id=>197877624107155918 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_RESET',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_standard_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표준';

wwv_flow_api.create_message (
  p_id=>197877719793155918 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.STANDARD_CALENDAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_partial_refresh_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'부분 페이지 새로 고침';

wwv_flow_api.create_message (
  p_id=>197877809688155918 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARTIAL_REFRESH_CALENDAR',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_canceling
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'취소 중';

wwv_flow_api.create_message (
  p_id=>197877906926155918 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.CANCELING',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_save_as_default
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'기본값으로 저장';

wwv_flow_api.create_message (
  p_id=>197878012990155918 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SAVE_AS_DEFAULT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_enhanced_qry_note
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'향상된 질의 통합 중';

wwv_flow_api.create_message (
  p_id=>197878102594155919 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ENHANCED_QRY_NOTE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_delete_checked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'선택된 항목 삭제';

wwv_flow_api.create_message (
  p_id=>197878200286155919 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DELETE_CHECKED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_no_aggregation_defined
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정의된 집계가 없습니다.';

wwv_flow_api.create_message (
  p_id=>197878330483155919 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NO_AGGREGATION_DEFINED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_no_computation_defined
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'정의된 계산이 없습니다.';

wwv_flow_api.create_message (
  p_id=>197878421522155919 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NO_COMPUTATION_DEFINED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_table_create_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- "%0" 테이블에 대한 생성 프로시저';

wwv_flow_api.create_message (
  p_id=>197878528811155919 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_TABLE_CREATE_COMMENT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_table_update_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- "%0" 테이블에 대한 갱신 프로시저';

wwv_flow_api.create_message (
  p_id=>197878624354155919 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_TABLE_UPDATE_COMMENT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_table_delete_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- "%0" 테이블에 대한 삭제 프로시저';

wwv_flow_api.create_message (
  p_id=>197878708505155920 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_TABLE_DELETE_COMMENT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_table_get_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- "%0" 테이블에 대한 가져오기 프로시저';

wwv_flow_api.create_message (
  p_id=>197878825687155920 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_TABLE_GET_COMMENT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_table_md5_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- "%0" 테이블에 대한 MD5 함수 작성';

wwv_flow_api.create_message (
  p_id=>197878909824155920 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_TABLE_MD5_COMMENT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_pkg_body_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- 패키지 본문';

wwv_flow_api.create_message (
  p_id=>197879031177155920 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_PKG_BODY_COMMENT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_pkg_spec_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- 패키지 사양';

wwv_flow_api.create_message (
  p_id=>197879128792155920 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_PKG_SPEC_COMMENT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p77_original_qry
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'원래 질의';

wwv_flow_api.create_message (
  p_id=>197879223008155920 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P77_ORIGINAL_QRY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message qb_new_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>새 질의를 생성하도록 선택했습니다. 이 경우 현재 질의에 대해 저장하지 않은 변경 사항은 손실됩니다.</p><b>계속하겠습니까?</b>';

wwv_flow_api.create_message (
  p_id=>197879318549155921 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QB_NEW_QUERY',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row_text_contains
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'행 텍스트가 다음을 포함';

wwv_flow_api.create_message (
  p_id=>197879404026155921 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW_TEXT_CONTAINS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_in_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음이 차기임';

wwv_flow_api.create_message (
  p_id=>197879526498155921 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_IN_NEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_isnot_in_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'다음이 차기가 아님';

wwv_flow_api.create_message (
  p_id=>197879603443155921 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_ISNOT_IN_NEXT',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_navigation_bar_icon
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'탐색&nbsp;도구 모음&nbsp;아이콘';

wwv_flow_api.create_message (
  p_id=>197879702141155921 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.NAVIGATION_BAR_ICON',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message restricted_no_set_from_browser
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제한됨 - 브라우저에서 설정할 수 없음';

wwv_flow_api.create_message (
  p_id=>197879821577155921 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RESTRICTED_NO_SET_FROM_BROWSER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message unrestricted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'제한 없음';

wwv_flow_api.create_message (
  p_id=>197879918585155922 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UNRESTRICTED',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message checksum_required_workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'체크섬 필요 - 애플리케이션 레벨';

wwv_flow_api.create_message (
  p_id=>197880024271155922 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHECKSUM_REQUIRED_WORKSPACE',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message checksum_required_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'체크섬 필요 - 사용자 레벨';

wwv_flow_api.create_message (
  p_id=>197880125956155922 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHECKSUM_REQUIRED_USER',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message checksum_required_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'체크섬 필요 - 세션 레벨';

wwv_flow_api.create_message (
  p_id=>197880200935155922 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHECKSUM_REQUIRED_SESSION',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message do_not_update_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'페이지를 갱신하지 않음';

wwv_flow_api.create_message (
  p_id=>197880310928155922 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DO_NOT_UPDATE_PAGES',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message do_not_update_application_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'애플리케이션 항목을 갱신하지 않음';

wwv_flow_api.create_message (
  p_id=>197880407039155923 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DO_NOT_UPDATE_APPLICATION_ITEMS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message do_not_update_data_entry_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'데이터 입력 항목을 갱신하지 않음';

wwv_flow_api.create_message (
  p_id=>197880507370155923 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DO_NOT_UPDATE_DATA_ENTRY_ITEMS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message do_not_update_display_only_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'표시 전용 항목을 갱신하지 않음';

wwv_flow_api.create_message (
  p_id=>197880626440155923 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DO_NOT_UPDATE_DISPLAY_ONLY_ITEMS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message do_not_update_page_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DO_NOT_UPDATE_PAGE_ITEMS';

wwv_flow_api.create_message (
  p_id=>197880719397155923 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DO NOT UPDATE PAGE ITEMS',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message arguments_must_have_checksum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'인수에 체크섬이 있어야 함';

wwv_flow_api.create_message (
  p_id=>197880805086155923 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ARGUMENTS_MUST_HAVE_CHECKSUM',
  p_message_language=>'ko',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_arguments_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'허용된 인수 없음';

wwv_flow_api.create_message (
  p_id=>197880911586155923 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_ARGUMENTS_ALLOWED',
  p_message_language=>'ko',
 