set define off
set verify off
set serveroutput on size 1000000
set feedback off
begin wwv_flow.g_import_in_progress := true; end; 
/
 
 
--application/set_environment
prompt  APPLICATION 4508 - APEX - SQL Workshop
--
-- Application Export:
--   Application:     4508
--   Name:            APEX - SQL Workshop
--   Date and Time:   11:48 Wednesday June 10, 2009
--   Exported By:     
--   Flashback:       0
--   Export Type:     Application Export
--   Version: 3.2.1.00.09
 
-- Import:
--   Using application builder
--   or
--   Using SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
 
-- Application Statistics:
--   Pages:               275
--     Items:             980
--     Computations:      192
--     Validations:       157
--     Processes:         356
--     Regions:           911
--     Buttons:           359
--   Shared Components
--     Breadcrumbs:         2
--        Entries          95
--     Items:              19
--     Computations:        1
--     Processes:          32
--     Parent Tabs:         0
--     Tab Sets:            0
--        Tabs:             0
--     NavBars:             2
--     Lists:             116
--     Shortcuts:           8
--     Themes:              0
--     Templates:
--        Page:            21
--        List:            27
--        Report:          14
--        Label:            4
--        Region:          32
--     Messages:            0
--     Build Options:       2
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>10);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en-us'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2009.01.12');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := 4508;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(4508);
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(4508);
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => 4508,
  p_display_id=> 4508,
  p_owner => 'APEX_030200',
  p_name  => 'APEX - SQL Workshop',
  p_alias => 'A198393900150465839',
  p_page_view_logging => 'YES',
  p_default_page_template=> 7493627476185560.4508 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=> 7493627476185560.4508 + wwv_flow_api.g_id_offset,
  p_default_region_template=> 140310301493602560.4508 + wwv_flow_api.g_id_offset,
  p_error_template    => 269981319593175625.4508 + wwv_flow_api.g_id_offset,
  p_charset           => 'utf-8',
  p_page_protection_enabled_y_n=> 'Y',
  p_checksum_salt_last_reset => '20090610114415',
  p_max_session_length_sec=> 28800,
  p_home_link         => 'f?p=4500:1000:&SESSION.',
  p_flow_language     => 'ko',
  p_flow_language_derived_from=> 'BROWSER',
  p_flow_image_prefix => '/i/',
  p_documentation_banner=> '',
  p_authentication    => 'CUSTOM2',
  p_login_url         => 'development_service_home_login',
  p_logout_url        => 'wwv_flow_custom_auth_std.logout?p_this_flow=&FLOW_ID.&p_next_flow_page_sess=4550:8:&SESSION.',
  p_application_tab_set=> 1,
  p_logo_image => '#IMAGE_PREFIX#htmldb/apex_logo.gif',
  p_logo_image_attributes => 'width="300" height="30" alt="&PRODUCT_NAME."',
  p_public_url_prefix => '',
  p_public_user       => 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server      => '',
  p_cust_authentication_process=> '.'||to_char(60875208405273732 + wwv_flow_api.g_id_offset)||'.',
  p_cust_authentication_page=> '',
  p_custom_auth_login_url=> '',
  p_flow_version      => '&PRODUCT_NAME. 3.2.1.00.09',
  p_flow_status       => 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'This application is currently unavailable.',
  p_build_status      => 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'Y',
  p_vpd               => '',
  p_security_scheme=>'FLOW: SQL',
  p_csv_encoding    => 'Y',
  p_theme_id => 3,
  p_default_label_template => 3301520602864636.4508 + wwv_flow_api.g_id_offset,
  p_default_report_template => 11028007180514315.4508 + wwv_flow_api.g_id_offset,
  p_default_list_template => 20507805987268923.4508 + wwv_flow_api.g_id_offset,
  p_default_menu_template => 6698104029693013.4508 + wwv_flow_api.g_id_offset,
  p_substitution_string_01 => 'PRODUCT_NAME',
  p_substitution_value_01  => 'Application Express',
  p_substitution_string_02 => 'LOGOUT',
  p_substitution_value_02  => '로그아웃',
  p_substitution_string_03 => 'MSG_COMPANY',
  p_substitution_value_03  => '작업 영역: &COMPANY.',
  p_substitution_string_04 => 'MSG_LANGUAGE',
  p_substitution_value_04  => '언어',
  p_substitution_string_05 => 'MSG_COPYRIGHT',
  p_substitution_value_05  => 'Copyright &copy; 1999, 2009, Oracle. All rights reserved.',
  p_substitution_string_06 => 'MSG_USER',
  p_substitution_value_06  => '사용자',
  p_substitution_string_07 => 'MSG_JSCRIPT',
  p_substitution_value_07  => '이 제품은 JavaScript가 사용으로 설정된 상태에서 실행해야 합니다.',
  p_substitution_string_08 => 'MSG_TBL_SUMMARY',
  p_substitution_value_08  => '페이지 레이아웃 테이블',
  p_substitution_string_09 => 'EDIT',
  p_substitution_value_09  => '편집',
  p_substitution_string_10 => 'DONE',
  p_substitution_value_10  => '완료',
  p_substitution_string_11 => 'TOP',
  p_substitution_value_11  => '최상위',
  p_substitution_string_12 => 'CLOSE',
  p_substitution_value_12  => '닫기',
  p_substitution_string_13 => 'DATE_FORMAT',
  p_substitution_value_13  => 'rr/mm/dd',
  p_substitution_string_14 => 'LONG_DATE_FORMAT',
  p_substitution_value_14  => 'fmDay yyyy"년"mm"월"dd"일"',
  p_substitution_string_15 => 'TIME_FORMAT',
  p_substitution_value_15  => 'AM hh:mi:ss',
  p_substitution_string_16 => 'DATE_TIME_FORMAT',
  p_substitution_value_16  => 'rr/mm/dd AM hh:mi:ss',
  p_substitution_string_17 => 'RETURN_TO_APPLICATION',
  p_substitution_value_17  => '애플리케이션으로 돌아가기',
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss=> '20090610114415',
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
null;
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
wwv_flow_api.create_icon_bar_item(
  p_id             => 39881611323138222.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_icon_sequence  => 1,
  p_icon_image     => '',
  p_icon_subtext   => '도움말',
  p_icon_target    => 'javascript:popupURL(''wwv_flow_help.show_help?p_lang=&BROWSER_LANGUAGE.&p_session=&APP_SESSION.&p_flow_id=&APP_TRANSLATION_ID.&p_step_id=&APP_TRANSLATION_PAGE_ID.'');',
  p_icon_image_alt => '도움말',
  p_icon_height    => null,
  p_icon_width     => null,
  p_icon_height2   => null,
  p_icon_width2    => null,
  p_icon_bar_disp_cond      => '',
  p_icon_bar_disp_cond_type => '',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> '');
 
wwv_flow_api.create_icon_bar_item(
  p_id             => 39959227833635056.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_icon_sequence  => 10,
  p_icon_image     => '',
  p_icon_subtext   => '로그아웃',
  p_icon_target    => 'wwv_flow_custom_auth_std.logout?p_this_flow=&APP_ID.&p_next_flow_page_sess=4550:8:&SESSION.',
  p_icon_image_alt => '로그아웃',
  p_icon_height    => null,
  p_icon_width     => null,
  p_icon_height2   => null,
  p_icon_width2    => null,
  p_icon_bar_disp_cond      => '',
  p_icon_bar_disp_cond_type => '',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> '');
 
 
end;
/

prompt  ...application processes
--
--application/shared_components/logic/application_processes/qb_poststate
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||':P1002_OWNER := :APP_USER;';

wwv_flow_api.create_flow_process(
  p_id => 1504518033640244.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'qb_postState',
  p_process_sql_clob=> p,
  p_process_error_message=> 'DO_NOT_TRANSLATE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 10-JAN-2005 17:03:31');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/qb_rendertable
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'wwv_flow_query_builder.renderTableV2(:P1002_ID,:P1002_COUNT);';

wwv_flow_api.create_flow_process(
  p_id => 1916013849479713.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'qb_renderTable',
  p_process_sql_clob=> p,
  p_process_error_message=> 'DO_NOT_TRANSLATE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 11-JAN-2005 09:16:46');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/qb_get_object_feed
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'wwv_flow_sw_object_feed.getmoreObjects('||chr(10)||
'p_type    =>'';TABLE;VIEW'','||chr(10)||
'p_owner   =>:P1002_SCHEMA,'||chr(10)||
'p_display =>''DIV'','||chr(10)||
'p_session   =>:SESSION,'||chr(10)||
'p_onclick =>:P1002_ONCLICK,'||chr(10)||
'p_Start   =>1,'||chr(10)||
'p_stop    =>50000,'||chr(10)||
'p_class   =>''ob_Object'');'||chr(10)||
'wwv_flow.debug(''End'');';

wwv_flow_api.create_flow_process(
  p_id => 3934212967688584.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'QB_GET_OBJECT_FEED',
  p_process_sql_clob=> p,
  p_process_error_message=> 'DO_NOT_TRANSLATE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 13-JAN-2005 19:11:46');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/sc_posthistory
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_buffer varchar2(32767) := null;'||chr(10)||
'  l_amount number;'||chr(10)||
'  l_offset number;'||chr(10)||
'begin'||chr(10)||
'  for c1 in (select command'||chr(10)||
'             from wwv_flow_sw_sql_cmds'||chr(10)||
'             where id = :P1201_HISTORY_ID'||chr(10)||
'             and security_group_id = :flow_security_group_id)'||chr(10)||
'  loop'||chr(10)||
'      if c1.command is not null and dbms_lob.getlength( c1.command ) > 0 then'||chr(10)||
'          l_amount := 8000;'||chr(10)||
'          l_offset := 1;'||chr(10)||
'   ';

p:=p||'       begin'||chr(10)||
'              loop'||chr(10)||
'                  dbms_lob.read( c1.command, l_amount, l_offset, l_buffer );'||chr(10)||
'                  htp.prn( l_buffer );'||chr(10)||
'                  l_offset := l_offset + l_amount;'||chr(10)||
'                  l_amount := 8000;'||chr(10)||
'              end loop;'||chr(10)||
'          exception'||chr(10)||
'              when others then'||chr(10)||
'                  null;'||chr(10)||
'          end;'||chr(10)||
'      end if;    '||chr(10)||
'      exit;'||chr(10)||
'  end loop;'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 6231903825594156.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sc_posthistory',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to get history.',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 18-JAN-2005 12:49:22');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/sc_postsavedsql
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_buffer varchar2(32767) := null;'||chr(10)||
'  l_amount number;'||chr(10)||
'  l_offset number;'||chr(10)||
'begin'||chr(10)||
'  for c1 in (select qb_sql, id, title, description'||chr(10)||
'               from wwv_flow_qb_saved_query'||chr(10)||
'              where id = :P1003_QUERY_ID'||chr(10)||
'                and security_group_id = :flow_security_group_id)'||chr(10)||
''||chr(10)||
'  loop'||chr(10)||
'      :P1003_QUERY_ID := c1.id;'||chr(10)||
'      :P1003_SAVE_NAME := c1.title;'||chr(10)||
'      :P1003_SAVE_DESC := c1.descri';

p:=p||'ption;'||chr(10)||
'      if c1.qb_sql is not null and dbms_lob.getlength( c1.qb_sql ) > 0 then'||chr(10)||
'          l_amount := 8000;'||chr(10)||
'          l_offset := 1;'||chr(10)||
'          begin'||chr(10)||
'              loop'||chr(10)||
'                  dbms_lob.read( c1.qb_sql, l_amount, l_offset, l_buffer );'||chr(10)||
'                  htp.prn( l_buffer );'||chr(10)||
'                  l_offset := l_offset + l_amount;'||chr(10)||
'                  l_amount := 8000;'||chr(10)||
'              end loop;'||chr(10)||
'   ';

p:=p||'       exception'||chr(10)||
'              when others then'||chr(10)||
'                  null;'||chr(10)||
'          end;'||chr(10)||
'      end if;    '||chr(10)||
'      exit;'||chr(10)||
'  end loop;'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 7139200190149482.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sc_postSavedSQL',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to get saved SQL.',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 19-JAN-2005 12:35:15');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/qb_get_saved_query
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'owa_util.mime_header(''text/javascript'', FALSE );'||chr(10)||
'htp.p(''Cache-Control: no-cache'');'||chr(10)||
'htp.p(''Pragma: no-cache'');'||chr(10)||
'owa_util.http_header_close;'||chr(10)||
'htp.p(''var fUser ="''||:APP_USER||''";'');'||chr(10)||
'wwv_flow_query_builder.loadQuery;';

wwv_flow_api.create_flow_process(
  p_id => 7276531262852173.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'qb_get_saved_query',
  p_process_sql_clob=> p,
  p_process_error_message=> '#SQLERRM#',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 19-JAN-2005 17:19:02');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/ob_get_object_feed
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'wwv_flow_sw_object_feed.getmoreObjects('||chr(10)||
'p_type    =>:P2001_FEED_TYPE,'||chr(10)||
'p_owner   =>:P2001_FEED_OWNER,'||chr(10)||
'p_Start   =>:P2001_FEED_START,'||chr(10)||
'p_stop    =>:P2001_FEED_STOP,'||chr(10)||
'p_display =>:P2001_FEED_DISPLAY,'||chr(10)||
'p_session   =>:SESSION,'||chr(10)||
'p_include =>:P2001_FEED_INCLUDE,'||chr(10)||
'p_onclick =>:P2001_FEED_ONCLICK,'||chr(10)||
'p_class  =>:P2001_FEED_CLASS);';

wwv_flow_api.create_flow_process(
  p_id => 11551302098165190.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'OB_GET_OBJECT_FEED',
  p_process_sql_clob=> p,
  p_process_error_message=> 'DO_NOT_TRANSLATE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'This is for the Object Browser please do not change');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/compile_plsql_code
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'   l_status varchar2(32767);'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'   for c1 in ('||chr(10)||
'       select clob001 from htmldb_collections'||chr(10)||
'       where collection_name = ''PLSQL_OBJECT_SOURCE'''||chr(10)||
'   ) loop'||chr(10)||
'       l_status := wwv_flow_plsql_editor.compile('||chr(10)||
'           wwv_flow_sw_api.valid_workspace_schema(:OBJECT_OWNER),'||chr(10)||
'           :OBJECT_NAME, '||chr(10)||
'           :OBJECT_TYPE, '||chr(10)||
'           c1.clob001'||chr(10)||
'       );'||chr(10)||
'       htp.p(l_status);'||chr(10)||
'   end ';

p:=p||'loop;'||chr(10)||
''||chr(10)||
'   htmldb_collection.truncate_collection('||chr(10)||
'      p_collection_name => ''PLSQL_OBJECT_SOURCE'' '||chr(10)||
'   );'||chr(10)||
''||chr(10)||
'exception'||chr(10)||
'   when others then'||chr(10)||
'      htp.p(sqlerrm);'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 12649800434223403.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'compile_plsql_code',
  p_process_sql_clob=> p,
  p_process_error_message=> '#SQLERRM#',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 31-JAN-2005 16:01:43');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/sc_getbind
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'l_new_binds varchar2(32700);'||chr(10)||
'l_old_binds varchar2(32700);'||chr(10)||
'begin'||chr(10)||
'  l_new_binds := wwv_flow_sw_api.get_binds(:P1003_SQL_COMMAND2);'||chr(10)||
'  l_old_binds := v(''P1200_BINDS''); '||chr(10)||
''||chr(10)||
'  if (l_new_binds is null) then'||chr(10)||
'    return;'||chr(10)||
'  else'||chr(10)||
'    htp.p(''l_new_binds ''||l_new_binds);'||chr(10)||
'  end if;'||chr(10)||
'  if l_new_binds = l_old_binds then '||chr(10)||
'    return;'||chr(10)||
'  else'||chr(10)||
'    wwv_flow.update_cache_with_write ('||chr(10)||
'      p_name   => ''P1200_BINDS';

p:=p||''','||chr(10)||
'      p_value  => l_new_binds );'||chr(10)||
'    wwv_flow.update_cache_with_write ('||chr(10)||
'      p_name   => ''P1200_BIND_VALS'','||chr(10)||
'      p_value  => '''');'||chr(10)||
'  end if;'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 21627908860597925.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sc_getBind',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to get binds',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 14-FEB-2005 19:57:28');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/sc_buildsql
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'--SR:JAS 01/23/09 may be obsolete'||chr(10)||
'declare '||chr(10)||
'i number := 0;'||chr(10)||
'l_owner varchar2(30) := wwv_flow_sw_api.valid_workspace_schema(v(''P139_OBJECT''));'||chr(10)||
'begin'||chr(10)||
'  htp.p(v(''P139_OWNER'')||''.''||l_owner||''( '');'||chr(10)||
'  for c in ( SELECT sequence#,owner, object_name, object_type, procedure$,last_ddl_time, argument, '||chr(10)||
'                c.type# argtype, '||chr(10)||
'                in_out,'||chr(10)||
'                decode(in_out,1,''OUT'',''IN'') inout'||chr(10)||
'';

p:=p||'FROM sys.argument$ c, sys.dba_objects o'||chr(10)||
'WHERE c.obj# = o.object_id'||chr(10)||
'and argument is not null'||chr(10)||
'AND (o.object_name||''.''||procedure$ = upper(v(''P139_OBJECT'')) or'||chr(10)||
'     o.object_name = upper(v(''P139_OBJECT'')) )'||chr(10)||
'and o.owner = upper(l_owner)'||chr(10)||
'order by procedure$,sequence# ) loop'||chr(10)||
'if (i < 1) then'||chr(10)||
'  htp.p(c.argument ||'' => '');'||chr(10)||
'  i := i+1;'||chr(10)||
'else'||chr(10)||
'  htp.p('',''||c.argument ||'' => '');'||chr(10)||
'end if;'||chr(10)||
'end loop;'||chr(10)||
'htp.p('')'');'||chr(10)||
'en';

p:=p||'d';

wwv_flow_api.create_flow_process(
  p_id => 22896611795429544.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sc_buildSql',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Error',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 15-FEB-2005 20:29:24');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/sr_parsing
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_status varchar2(255) := null;'||chr(10)||
'begin'||chr(10)||
'  wwv_flow_sw_parser.parse_file(p_file_id => :P1023_FILE_ID);'||chr(10)||
'  if wwv_flow_sw_script.invalid_script(p_file_id => :P1023_FILE_ID) = 1 then'||chr(10)||
'    l_status := ''FAILURE'';'||chr(10)||
'  else'||chr(10)||
'    l_status := ''SUCCESS'';'||chr(10)||
'  end if;'||chr(10)||
'  htp.p(l_status);'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 28056921387126354.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sr_parsing',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to parse the script.',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 21-FEB-2005 15:36:28');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/ob_fk_get_columns
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
' l_cols varchar(2000) := null;'||chr(10)||
' counter number := 0;'||chr(10)||
' l_upper varchar2(2000) := null;'||chr(10)||
' l_owner varchar2(30) := wwv_flow_sw_api.valid_workspace_schema(:OB_SCHEMA);'||chr(10)||
'begin'||chr(10)||
'  '||chr(10)||
'  select count(column_name) into counter'||chr(10)||
'           from sys.dba_tab_columns'||chr(10)||
'           where owner = upper(l_owner)'||chr(10)||
'           and table_name  = :P145_FK_REF_TABLE;'||chr(10)||
'  if (counter = 0)  then '||chr(10)||
'     :P145_FK_REF_TABLE := u';

p:=p||'pper(:P145_FK_REF_TABLE);'||chr(10)||
'     select count(column_name) into counter'||chr(10)||
'     from sys.dba_tab_columns'||chr(10)||
'     where owner = upper(l_owner)'||chr(10)||
'     and table_name  = :P145_FK_REF_TABLE;'||chr(10)||
'  end if;'||chr(10)||
'     l_upper := :P145_FK_REF_TABLE;'||chr(10)||
''||chr(10)||
'     for c1 in (select column_name  '||chr(10)||
'           from sys.dba_tab_columns'||chr(10)||
'           where owner = upper(l_owner)'||chr(10)||
'           and table_name  = :P145_FK_REF_TABLE) loop'||chr(10)||
'        l';

p:=p||'_cols := l_cols||c1.column_name;'||chr(10)||
'        l_cols := l_cols||'';'';'||chr(10)||
'     end loop;'||chr(10)||
''||chr(10)||
'if (counter = 0) then'||chr(10)||
'  htp.prn(''NONE'');'||chr(10)||
'else'||chr(10)||
'  htp.prn(l_upper||'';''||l_cols);'||chr(10)||
'end if;'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 29884608907915599.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ob_fk_get_columns',
  p_process_sql_clob=> p,
  p_process_error_message=> 'DO_NOT_TRANSLATE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 22-FEB-2005 16:01:20');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/returnnothing
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'null;';

wwv_flow_api.create_flow_process(
  p_id => 77984007292719402.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ReturnNothing',
  p_process_sql_clob=> p,
  p_process_error_message=> '',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/sr_save_script
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'for c1 in (select clob001 script, c001 file_id, c002 name                   '||chr(10)||
'           from htmldb_collections'||chr(10)||
'           where collection_name = ''SR_SCRIPT_SOURCE'') loop'||chr(10)||
'    wwv_flow_sw_script.update_script_file ('||chr(10)||
'     p_file_id     => c1.file_id,'||chr(10)||
'     p_script_name => c1.name,'||chr(10)||
'     p_script      => c1.script);'||chr(10)||
'end loop;';

wwv_flow_api.create_flow_process(
  p_id => 106683007949808585.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sr_save_script',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to update script.',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 23-FEB-2005 15:37:51');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/sr_create_script
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'for c1 in (select clob001 script, c001 file_id, c002 name                   '||chr(10)||
'             from htmldb_collections'||chr(10)||
'             where collection_name = ''SR_SCRIPT_SOURCE'') loop'||chr(10)||
'    wwv_flow_sw_script.create_script_from_clob (        '||chr(10)||
'     p_script_name => c1.name,'||chr(10)||
'     p_script      => c1.script);   '||chr(10)||
'end loop;';

wwv_flow_api.create_flow_process(
  p_id => 108492501270666096.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sr_create_script',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to create script.',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 25-FEB-2005 10:54:13');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/sr_dup_name
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_cnt          number := 0;  '||chr(10)||
'  l_current_id   number := null;'||chr(10)||
'  l_new_filename varchar2(4000) := null;'||chr(10)||
'  l_old_filename varchar2(4000) := null;'||chr(10)||
'  l_existing_id  number := null;'||chr(10)||
'  l_created_by   varchar2(255) := null;'||chr(10)||
'  '||chr(10)||
'  l_flag         varchar2(255) := null;'||chr(10)||
'begin'||chr(10)||
'  l_new_filename := lower(v(''P60_SCRIPT_NAME''));'||chr(10)||
'  l_old_filename := lower(v(''P60_OLD_SCRIPT_NAME''));'||chr(10)||
'  l_current_id := v(''';

p:=p||'P60_FILE_ID'');'||chr(10)||
'	'||chr(10)||
'  if l_new_filename = nvl(l_old_filename,'''') then'||chr(10)||
'     l_flag := ''SUCCESS'';	   '||chr(10)||
'  else'||chr(10)||
'     for c1 in (select id, created_by'||chr(10)||
'                from wwv_flow_files'||chr(10)||
'                where lower(filename) = l_new_filename)'||chr(10)||
'     loop'||chr(10)||
'       l_cnt := l_cnt + 1;    '||chr(10)||
'       l_existing_id := c1.id;'||chr(10)||
'       l_created_by := c1.created_by;'||chr(10)||
'       exit;    '||chr(10)||
'     end loop;'||chr(10)||
'     if l_cnt > 0 then'||chr(10)||
' ';

p:=p||'      if l_existing_id = nvl(l_current_id,0) then'||chr(10)||
'         l_flag := ''SAVE_NEW'';'||chr(10)||
'       else       	 '||chr(10)||
'         l_flag := ''FAIL'';'||chr(10)||
'       end if;'||chr(10)||
'       if upper(l_created_by) != upper(v(''APP_USER'')) then    	 '||chr(10)||
'           l_flag := ''FAIL_RENAME'';         '||chr(10)||
'       end if;       '||chr(10)||
'     else'||chr(10)||
'     	l_flag := ''SAVE_NEW'';'||chr(10)||
'     end if;'||chr(10)||
'  end if;'||chr(10)||
'  htp.p(l_flag);'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 112585108113201529.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sr_dup_name',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to get duplicate script name.',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 03-MAR-2005 22:12:36');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/sc_create_job
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
' job number;'||chr(10)||
'begin'||chr(10)||
'dbms_job.submit(job,''wwv_flow_sc_transactions.sc_job(''||:SESSION||'',''''''||:FLOW_USER||'''''');'');'||chr(10)||
' :P1003_JOBID := job;'||chr(10)||
' :P1003_AUTOCOMMIT := ''Y'';'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 136604317027747819.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sc_create_job',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to create job ',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 15-MAR-2005 19:03:39');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/sc_remove_job
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'l_tid number ;'||chr(10)||
'begin'||chr(10)||
'  l_tid := wwv_flow_sc_transactions.add_trans(:SESSION, :FLOW_USER, '||chr(10)||
'                :P1003_SCHEMA,''STOP'', 0, '''', ''exit'');'||chr(10)||
'  :P1003_JOBID := '''';'||chr(10)||
' :P1003_AUTOCOMMIT := '''';'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 136605514734756665.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sc_remove_job',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to remove job',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 15-MAR-2005 19:05:07');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/sc_read_out
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_out   clob;'||chr(10)||
'  l_tid   number;'||chr(10)||
'  lob_length     integer;'||chr(10)||
'  read_amount    integer;'||chr(10)||
'  read_offset    integer := 1;'||chr(10)||
'  buffer         varchar2(32700);'||chr(10)||
'begin'||chr(10)||
'   l_tid := v(''P1200_STMT'');'||chr(10)||
'   select transaction_result into l_out '||chr(10)||
'    from wwv_flow_sc_trans '||chr(10)||
'    where session_id = (select nv(''SESSION'') x from dual)'||chr(10)||
'    and transaction_id = l_tid;'||chr(10)||
'   if (length(l_out) > 0) then'||chr(10)||
'     lob_length ';

p:=p||':= length(l_out);'||chr(10)||
'     while (lob_length > 0) loop'||chr(10)||
'       if (lob_length > 32000) then'||chr(10)||
'         read_amount := 32000;'||chr(10)||
'       else '||chr(10)||
'         read_amount := lob_length;'||chr(10)||
'       end if;'||chr(10)||
'       dbms_lob.read(l_out,read_amount,read_offset,buffer);'||chr(10)||
'       sys.htp.p(buffer);'||chr(10)||
'       read_offset := read_offset+read_amount;'||chr(10)||
'       lob_length := lob_length-read_amount;'||chr(10)||
'     end loop;'||chr(10)||
'   else'||chr(10)||
'     htp.p(''HTMLD';

p:=p||'B:NONE'');'||chr(10)||
'   end if;'||chr(10)||
''||chr(10)||
'exception when others then'||chr(10)||
' sys.htp.p(''HTMLDB:NONE ERROR ''||SQLERRM);'||chr(10)||
' htp.p(''HTMLDB:NONE ERROR ''||SQLERRM);'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 137030824141880927.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sc_read_out',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to read output',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 16-MAR-2005 09:19:10');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/sr_replace_script
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_file_id number := null;'||chr(10)||
'begin'||chr(10)||
'  for c1 in (select clob001 script, c001 file_id, c002 name                   '||chr(10)||
'             from htmldb_collections'||chr(10)||
'             where collection_name = ''SR_SCRIPT_SOURCE'') loop'||chr(10)||
'      for c2 in (select id'||chr(10)||
'                 from wwv_flow_files'||chr(10)||
'                 where lower(filename) = lower(c1.name)'||chr(10)||
'                 and file_type = ''SCRIPT'')'||chr(10)||
'      loop'||chr(10)||
'      ';

p:=p||'    l_file_id := c2.id;'||chr(10)||
'          exit;'||chr(10)||
'      end loop; '||chr(10)||
'      if l_file_id is not null then          	'||chr(10)||
'        wwv_flow_sw_script.update_script_file ('||chr(10)||
'         p_file_id     => l_file_id,'||chr(10)||
'         p_script_name => c1.name,'||chr(10)||
'         p_script      => c1.script);'||chr(10)||
'      end if;'||chr(10)||
'  end loop;'||chr(10)||
'end;  ';

wwv_flow_api.create_flow_process(
  p_id => 138449522524133557.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sr_replace_script',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to replace script.',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 17-MAR-2005 16:34:36');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/sc_read_dbms
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_out   clob;'||chr(10)||
'  l_tid   number;'||chr(10)||
'begin'||chr(10)||
'   l_tid := v(''P1200_STMT'');'||chr(10)||
'   select transaction_output into l_out from wwv_flow_sc_trans '||chr(10)||
'   where session_id = :SESSION and transaction_id = l_tid;'||chr(10)||
'   if length(l_out) > 0 then'||chr(10)||
'     htp.p(l_out);'||chr(10)||
'   else'||chr(10)||
'     htp.p(''HTMLDB:NONE'');'||chr(10)||
'   end if;'||chr(10)||
'exception when others then'||chr(10)||
' htp.p(''HTMLDB:NONE'');'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 140873708217846868.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sc_read_dbms',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to read output',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 21-MAR-2005 17:00:09');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/sc_sql_trans
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_tid number;'||chr(10)||
'begin'||chr(10)||
'l_tid := wwv_flow_sc_transactions.add_trans(:SESSION, :FLOW_USER, wwv_flow_sw_api.valid_workspace_schema(:P1003_SCHEMA), :P1200_TYPE, :P1003_ROWS, :P1200_BIND_VALS, :P1003_SQL_COMMAND2);'||chr(10)||
'htp.prn(l_tid);'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 141051327945527301.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sc_sql_trans',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to load SQL trans',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 21-MAR-2005 21:40:14');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/sc_savequery
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_counter number;'||chr(10)||
'  l_id      number;'||chr(10)||
'  l_error   number := 0;'||chr(10)||
'  l_err_txt varchar2(2000) := ''<!-- HTMLDB:ERROR --><div class="htmldbNotification"><ul>'';'||chr(10)||
'  l_id2     number;'||chr(10)||
'  l_o_name  varchar2(2000);'||chr(10)||
'  l_sql_command2 varchar2(32767) := v(''P1003_SQL_COMMAND2'');'||chr(10)||
'begin'||chr(10)||
'  '||chr(10)||
'  if v(''P1003_SAVE_NAME'') is null or v(''P1003_SAVE_NAME'') = '''' then'||chr(10)||
'    l_err_txt := l_err_txt||''<li>'';'||chr(10)||
'    l_err_txt ';

p:=p||':= l_err_txt||wwv_flow_lang.system_message(''SC_NAME_NN'');'||chr(10)||
'    l_err_txt := l_err_txt||''</li>'';'||chr(10)||
'    l_error := 1;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'  if v(''P1003_SQL_COMMAND2'') is null or v(''P1003_SQL_COMMAND2'') = '''' then'||chr(10)||
'    l_err_txt := l_err_txt||''<li>'';'||chr(10)||
'    l_err_txt := l_err_txt||wwv_flow_lang.system_message(''QB_NOTHING_TO_SAVE'');'||chr(10)||
'    l_err_txt := l_err_txt||''</li>'';'||chr(10)||
'    l_error := 1;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'  if nvl(v(''P1003_QU';

p:=p||'ERY_ID''),''-99'') = -99 then'||chr(10)||
'    begin'||chr(10)||
'      select count(*) into l_counter '||chr(10)||
'      from wwv_flow_qb_saved_query '||chr(10)||
'      where title = v(''P1003_SAVE_NAME'') '||chr(10)||
'       and created_by = v(''FLOW_USER'')'||chr(10)||
'       and security_group_id = wwv_flow_security.g_security_group_id;'||chr(10)||
'      if l_counter > 0 then '||chr(10)||
'        l_err_txt := l_err_txt||''<li>'';'||chr(10)||
'        l_err_txt := l_err_txt||wwv_flow_lang.system_message(''QB_DUPL';

p:=p||'ICATE_QUERY'');'||chr(10)||
'        l_err_txt := l_err_txt||''</li>'';'||chr(10)||
'        l_error := 1;'||chr(10)||
'      end if;'||chr(10)||
'    end;'||chr(10)||
'  end if;'||chr(10)||
'  '||chr(10)||
'  l_err_txt := l_err_txt||''</ul></div>'';'||chr(10)||
'  if l_error = 1 then '||chr(10)||
'      htp.p(l_err_txt);'||chr(10)||
'  else'||chr(10)||
'      l_id2 := nvl(v(''P1003_QUERY_ID''),''-99'');'||chr(10)||
'      if l_id2 = ''-99'' then'||chr(10)||
'          l_id := wwv_flow_id.next_val;'||chr(10)||
'          insert into wwv_flow_qb_saved_query(id,title,query_type,descriptio';

p:=p||'n,qb_sql,query_owner,created_by) '||chr(10)||
'          values (l_id,v(''P1003_SAVE_NAME''),''R'',v(''P1003_SAVE_DESC''), l_sql_command2,'||chr(10)||
'                  v(''P1003_SCHEMA''),v(''FLOW_USER''));'||chr(10)||
'          htp.prn(l_id);'||chr(10)||
'      else'||chr(10)||
'        begin'||chr(10)||
'          select title into l_o_name from wwv_flow_qb_saved_query where id = l_id2;'||chr(10)||
'        exception when no_data_found then '||chr(10)||
'          l_o_name := '''';'||chr(10)||
'        end;'||chr(10)||
'          i';

p:=p||'f l_o_name = v(''P1003_SAVE_NAME'') then'||chr(10)||
'              for c1 in (select * from wwv_flow_qb_saved_query where id = v(''P1003_QUERY_ID'')) loop'||chr(10)||
'                  delete from wwv_flow_qb_saved_query where id = l_id2;'||chr(10)||
'                  insert into wwv_flow_qb_saved_query '||chr(10)||
'                   (id, title, query_type, description, qb_sql, query_owner, created_by, created_on, last_updated_by) '||chr(10)||
'               ';

p:=p||'    values '||chr(10)||
'                   (l_id2, v(''P1003_SAVE_NAME'') , ''R'', v(''P1003_SAVE_DESC'') , l_sql_command2, c1.query_owner, c1.created_by, c1.created_on, c1.last_updated_by);'||chr(10)||
'                   l_id := v(''P1003_QUERY_ID'');'||chr(10)||
'              end loop;'||chr(10)||
'              htp.prn(l_id2);'||chr(10)||
'          else'||chr(10)||
'              l_id := wwv_flow_id.next_val;'||chr(10)||
'              insert into wwv_flow_qb_saved_query(id,title,query_t';

p:=p||'ype,description,qb_sql,query_owner,created_by) '||chr(10)||
'              values (l_id,v(''P1003_SAVE_NAME''),''R'',v(''P1003_SAVE_DESC''), l_sql_command2,'||chr(10)||
'                      v(''P1003_SCHEMA''),v(''FLOW_USER''));'||chr(10)||
'              htp.prn(l_id);'||chr(10)||
'         end if;'||chr(10)||
'      end if;   '||chr(10)||
'  end if;'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 158194723674245313.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'sc_saveQuery',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to save Query',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 04-APR-2005 16:26:34');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/ob_postid
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_num number;'||chr(10)||
'  l_hash boolean := false;'||chr(10)||
'begin'||chr(10)||
'wwv_flow_sw_api.check_priv(:OB_SCHEMA);'||chr(10)||
':OBJECT_ID :=  :OB_OBJECT_ID;'||chr(10)||
':OB_OBJECT_NAME := :OBJECT_ID;'||chr(10)||
''||chr(10)||
'  begin'||chr(10)||
'   l_num := :OBJECT_ID;'||chr(10)||
'        wwv_flow.debug(''ID value:''||:OBJECT_ID);'||chr(10)||
'   exception when others then'||chr(10)||
'     l_hash := true;'||chr(10)||
'     wwv_flow.debug(''Hashed value:''||:OBJECT_ID);'||chr(10)||
'  end;'||chr(10)||
''||chr(10)||
'if ( l_hash ) then'||chr(10)||
'   for r in ( select object_name';

p:=p||',owner,object_type'||chr(10)||
'               from  sys.dba_objects '||chr(10)||
'               where object_id is null'||chr(10)||
'               and  ''DBASE''||ltrim( to_char( sys.dbms_utility.get_hash_value( upper(owner || ''.'' || object_name),1000000000, power(2,30) ), rpad( ''X'',29,''X'')||''X'' )) '||chr(10)||
'                = :OBJECT_ID and owner = :OB_SCHEMA) loop'||chr(10)||
'      :OBJECT_NAME  := r.object_name;'||chr(10)||
'      :OBJECT_OWNER := r.owner;'||chr(10)||
'      :OB';

p:=p||'JECT_TYPE  := ''DATABASE_LINK'';'||chr(10)||
'   end loop;'||chr(10)||
'else'||chr(10)||
'   for r2 in ( select object_name,owner,object_type'||chr(10)||
'               from  sys.dba_objects '||chr(10)||
'               where object_id = :OBJECT_ID and owner = :OB_SCHEMA ) loop'||chr(10)||
'      :OBJECT_NAME  := r2.object_name;'||chr(10)||
'      :OBJECT_OWNER := r2.owner;'||chr(10)||
'      if r2.object_type = ''MATERIALIZED VIEW'' then'||chr(10)||
'      :OBJECT_TYPE  := ''MATERIALIZED_VIEW'';'||chr(10)||
'      elsif(r2.objec';

p:=p||'t_type = ''PACKAGE BODY'') then '||chr(10)||
'        :OBJECT_TYPE  := ''PACKAGE'';'||chr(10)||
'      else'||chr(10)||
'        :OBJECT_TYPE  := r2.object_type;'||chr(10)||
'      end if;'||chr(10)||
'   end loop;'||chr(10)||
'   if ( :REQUEST = ''GETOBJECT_SPEC'' ) then'||chr(10)||
'       for r2 in ( select object_name,owner,object_type'||chr(10)||
'                   from  sys.dba_objects '||chr(10)||
'                   where object_NAME =  :OBJECT_NAME'||chr(10)||
'                   and   OWNER = :OBJECT_OWNER'||chr(10)||
'             ';

p:=p||'      and   OBJECT_TYPE = ''PACKAGE'' ) loop'||chr(10)||
'          :OBJECT_NAME  := r2.object_name;'||chr(10)||
'          :OBJECT_OWNER := r2.owner;'||chr(10)||
'          :OBJECT_TYPE  := r2.object_type;'||chr(10)||
'       end loop;'||chr(10)||
''||chr(10)||
'    elsif ( :REQUEST = ''GETOBJECT_BODY'' ) then'||chr(10)||
''||chr(10)||
'       for r2 in ( select object_name,owner,object_type'||chr(10)||
'                   from  sys.dba_objects '||chr(10)||
'                   where object_name = :OBJECT_NAME'||chr(10)||
'                  ';

p:=p||' and   OWNER = :OBJECT_OWNER'||chr(10)||
'                   and   OBJECT_TYPE = ''PACKAGE BODY'' ) loop'||chr(10)||
'          :OBJECT_NAME  := r2.object_NAME;'||chr(10)||
'          :OBJECT_OWNER := r2.owner;'||chr(10)||
'          :OBJECT_TYPE  := r2.object_type;'||chr(10)||
'       end loop;'||chr(10)||
'    end if;'||chr(10)||
'end if;'||chr(10)||
'/* print for JS to change schema select list */'||chr(10)||
''||chr(10)||
''||chr(10)||
'    '||chr(10)||
'if ( :APP_PAGE_ID  not in  ( 0 ) ) then '||chr(10)||
'/* if the page is not zero refresh/highlight the left ';

p:=p||'bar */'||chr(10)||
'htp.prn('''||chr(10)||
'<script type="text/javascript">'||chr(10)||
'gTempType="''||:OBJECT_TYPE||''";'||chr(10)||
'gTempId="''||:OBJECT_ID||''";'||chr(10)||
'setTimeout(refocusTemp,1);'||chr(10)||
''||chr(10)||
'function refocusTemp(){'||chr(10)||
'top.gSideBar.reload(gTempType,gTempId,false,false);'||chr(10)||
'}'||chr(10)||
'</script>'');'||chr(10)||
'else'||chr(10)||
'/* else return the owner to change the selector */'||chr(10)||
'htp.prn(:OBJECT_OWNER); '||chr(10)||
'end if;'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 171513520394208759.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ob_postId',
  p_process_sql_clob=> p,
  p_process_error_message=> 'DO_NOT_TRANSLATE',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> '');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/ob_add_fk
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_counter number;'||chr(10)||
'  l_id      number;'||chr(10)||
'  l_error   number := 0;'||chr(10)||
'  l_err_txt varchar2(2000) := ''<!-- HTMLDB:ERROR --><div class="htmldbNotification"><ul>'';'||chr(10)||
'begin'||chr(10)||
' if v(''P145_FK_NAME'') is null then'||chr(10)||
'  l_err_txt := l_err_txt||''<li>'';'||chr(10)||
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_FK_NAME_NOT_NULL'');'||chr(10)||
'  l_err_txt := l_err_txt||''</li>'';'||chr(10)||
'  l_error := 1;'||chr(10)||
' end if;'||chr(10)||
' if v(''P145_FROM_COLS''';

p:=p||') is null then'||chr(10)||
'  l_err_txt := l_err_txt||''<li>'';'||chr(10)||
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_FK_SEL_COLS'');'||chr(10)||
'  l_err_txt := l_err_txt||''</li>'';'||chr(10)||
'  l_error := 1;'||chr(10)||
' end if;'||chr(10)||
' if v(''P145_FK_REF_TABLE'') is null then'||chr(10)||
'  l_err_txt := l_err_txt||''<li>'';'||chr(10)||
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_FK_REF_TAB'');'||chr(10)||
'  l_err_txt := l_err_txt||''</li>'';'||chr(10)||
'  l_error := 1;'||chr(10)||
' end if;'||chr(10)||
' if v(''P14';

p:=p||'5_TO_COLS'') is null then'||chr(10)||
'  l_err_txt := l_err_txt||''<li>'';'||chr(10)||
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_FK_REF_COLS'');'||chr(10)||
'  l_err_txt := l_err_txt||''</li>'';'||chr(10)||
'  l_error := 1;'||chr(10)||
' end if;'||chr(10)||
''||chr(10)||
' select count(*) into l_counter    '||chr(10)||
' from wwv_flow_collections        '||chr(10)||
' where collection_name = ''TBL_WIZ_FKS'''||chr(10)||
'  and c001 = upper(v(''P145_FK_NAME''));'||chr(10)||
' if l_counter > 0 then'||chr(10)||
'  l_err_txt := l_err_txt||''<li>'';'||chr(10)||
'';

p:=p||'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_FK_NAME_USED'');'||chr(10)||
'  l_err_txt := l_err_txt||''</li>'';'||chr(10)||
'  l_error := 1;'||chr(10)||
' end if;'||chr(10)||
' '||chr(10)||
' select count(*) into l_counter    '||chr(10)||
' from sys.dba_objects'||chr(10)||
' where object_name = upper(v(''P145_FK_NAME''));'||chr(10)||
' if l_counter > 0 then'||chr(10)||
'  l_err_txt := l_err_txt||''<li>'';'||chr(10)||
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_FK_NAME_USED'');'||chr(10)||
'  l_err_txt := l_err_txt||';

p:=p||'''</li>'';'||chr(10)||
'  l_error := 1;'||chr(10)||
' end if;'||chr(10)||
''||chr(10)||
' l_err_txt := l_err_txt||''</ul></div>'';'||chr(10)||
''||chr(10)||
' if l_error = 1 then '||chr(10)||
'   htp.p(l_err_txt);'||chr(10)||
' else'||chr(10)||
'   begin'||chr(10)||
'     wwv_flow_collection.create_collection(''TBL_WIZ_FKS'');'||chr(10)||
'   exception '||chr(10)||
'     when others then null;'||chr(10)||
'   end;'||chr(10)||
'   l_id := wwv_flow_collection.add_member('||chr(10)||
'            p_collection_name => ''TBL_WIZ_FKS'','||chr(10)||
'            p_c001          => upper(v(''P145_FK_NAME'')),'||chr(10)||
'         ';

p:=p||'   p_c002          => v(''P145_FROM_COLS''),'||chr(10)||
'            p_c003          => v(''P145_FK_REF_TABLE''),'||chr(10)||
'            p_c004          => v(''P145_TO_COLS''),'||chr(10)||
'            p_c005          => v(''P145_FK_ACTION''));'||chr(10)||
''||chr(10)||
'    htp.prn(''<table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" summary="" id="htmldbNewTable"><tbody>'');'||chr(10)||
'    htp.prn(''<tr><th class="tableheader2">''||    '||chr(10)||
'     wwv_flow_lang';

p:=p||'.system_message(''OB_FK_NAME'')||''</th>'');'||chr(10)||
'    htp.prn(''<th class="tableheader2">''||'||chr(10)||
'     wwv_flow_lang.system_message(''CREATE_CONDITION.COLUMNS'')||''</th>'');'||chr(10)||
'    htp.prn(''<th class="tableheader2">''||'||chr(10)||
'     wwv_flow_lang.system_message(''OB_FK_REFERENCED'')||''</th>'');'||chr(10)||
'    htp.prn(''<th class="tableheader2">''||'||chr(10)||
'     wwv_flow_lang.system_message(''OB_FK_REFERENCED_TAB'')||''</th>'');'||chr(10)||
'    htp.prn(''<th class="ta';

p:=p||'bleheader2">''||'||chr(10)||
'     wwv_flow_lang.system_message(''DEMO_APPLICATION.ACTION'')||''</th>'');'||chr(10)||
'    htp.prn(''<th class="tableheader2">''||''&nbsp;''||''</th>'');'||chr(10)||
'    htp.p(''</tr>'');'||chr(10)||
''||chr(10)||
'for c1 in (select seq_id,c001, c002, c003,c004,c005'||chr(10)||
'                 from wwv_flow_collections        '||chr(10)||
'                where collection_name = ''TBL_WIZ_FKS'''||chr(10)||
'                order by seq_id) loop'||chr(10)||
'    htp.prn(''<tr id="fkTab_''||c1.se';

p:=p||'q_id||''">'');'||chr(10)||
'    htp.prn(''<td>''||c1.c001||''</td>'');'||chr(10)||
'    htp.prn(''<td>''||c1.c002||''</td>'');'||chr(10)||
'    htp.prn(''<td>''||c1.c003||''</td>'');'||chr(10)||
'    htp.prn(''<td>''||c1.c004||''</td>'');'||chr(10)||
'    htp.prn(''<td>'');'||chr(10)||
'    if c1.c005 = ''C'' then'||chr(10)||
'      htp.prn(wwv_flow_lang.system_message(''OB_CASCADE_DELETE'')||''</td>'');'||chr(10)||
'    elsif c1.c005 = ''N'' then'||chr(10)||
'      htp.prn(wwv_flow_lang.system_message(''OB_SET_NULL'')||''</td>'');'||chr(10)||
'    else'||chr(10)||
'  ';

p:=p||'    htp.prn(wwv_flow_lang.system_message(''SQL_REPORT_WIZ.DEFAULT'')||''</td>'');'||chr(10)||
'    end if;'||chr(10)||
'    htp.prn(''<td style="text-align: center;" class="htmldbPseudoButton">'');'||chr(10)||
'    htp.prn(''<img src="#IMAGE_PREFIX#delete.gif" onclick="ob_rmFkRow('');'||chr(10)||
'    htp.prn(c1.seq_id||'')" /></td>'');'||chr(10)||
'    htp.p(''</tr>'');'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'    htp.p(''</tbody></table>'');'||chr(10)||
'end if;'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 172369000165936003.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ob_add_fk',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to Process',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 21-APR-2005 15:55:00');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/ob_rm_fk_row
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'  HTMLDB_COLLECTION.DELETE_MEMBER('||chr(10)||
'    p_collection_name => ''TBL_WIZ_FKS'' ,'||chr(10)||
'    p_seq             => :P145_FK_SEQ );'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 172867829404455433.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ob_rm_fk_row',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to process',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 21-APR-2005 17:21:35');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/ob_add_cons
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_counter number;'||chr(10)||
'  l_id      number;'||chr(10)||
'  l_error   number := 0;'||chr(10)||
'  l_err_txt varchar2(2000) := ''<!-- HTMLDB:ERROR --><div class="htmldbNotification"><ul>'';'||chr(10)||
'begin'||chr(10)||
' if v(''P149_NAME'') is null then'||chr(10)||
'  l_err_txt := l_err_txt||''<li>'';'||chr(10)||
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_CONS_NAME_NN'');'||chr(10)||
'  l_err_txt := l_err_txt||''</li>'';'||chr(10)||
'  l_error := 1;'||chr(10)||
' end if;'||chr(10)||
' if (v(''P149_CONST_TYPE'') = ''';

p:=p||'U'' and v(''P149_SEL_COLS'') is null) then'||chr(10)||
'  l_err_txt := l_err_txt||''<li>'';'||chr(10)||
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_UK_COLS'');'||chr(10)||
'  l_err_txt := l_err_txt||''</li>'';'||chr(10)||
'  l_error := 1;'||chr(10)||
' end if;'||chr(10)||
' if (v(''P149_CONST_TYPE'') = ''C'' and v(''P149_CHECK'') is null) then'||chr(10)||
'  l_err_txt := l_err_txt||''<li>'';'||chr(10)||
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_CHECK_CON_NN'');'||chr(10)||
'  l_err_txt := l_err_';

p:=p||'txt||''</li>'';'||chr(10)||
'  l_error := 1;'||chr(10)||
' end if;'||chr(10)||
''||chr(10)||
' select count(*) into l_counter    '||chr(10)||
' from wwv_flow_collections        '||chr(10)||
' where collection_name = ''TBL_WIZ_CONS'''||chr(10)||
'  and c001 = upper(v(''P149_NAME''));'||chr(10)||
' if l_counter > 0 then'||chr(10)||
'  l_err_txt := l_err_txt||''<li>'';'||chr(10)||
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_CONS_NAME_USED'');'||chr(10)||
'  l_err_txt := l_err_txt||''</li>'';'||chr(10)||
'  l_error := 1;'||chr(10)||
' end if;'||chr(10)||
''||chr(10)||
' select count(*) i';

p:=p||'nto l_counter    '||chr(10)||
' from sys.dba_objects'||chr(10)||
' where object_name = upper(v(''P149_NAME''));'||chr(10)||
' if l_counter > 0 then'||chr(10)||
'  l_err_txt := l_err_txt||''<li>'';'||chr(10)||
'  l_err_txt := l_err_txt||wwv_flow_lang.system_message(''OB_CONS_NAME_USED'');'||chr(10)||
'  l_err_txt := l_err_txt||''</li>'';'||chr(10)||
'  l_error := 1;'||chr(10)||
' end if;'||chr(10)||
''||chr(10)||
' l_err_txt := l_err_txt||''</ul></div>'';'||chr(10)||
''||chr(10)||
' if l_error = 1 then '||chr(10)||
'   htp.p(l_err_txt);'||chr(10)||
' else'||chr(10)||
'   begin'||chr(10)||
'     wwv_flow_collecti';

p:=p||'on.create_collection(''TBL_WIZ_CONS'');'||chr(10)||
'   exception '||chr(10)||
'     when others then null;'||chr(10)||
'   end;'||chr(10)||
'   l_id := wwv_flow_collection.add_member('||chr(10)||
'                    p_collection_name => ''TBL_WIZ_CONS'','||chr(10)||
'                    p_c001          => upper(v(''P149_NAME'')),'||chr(10)||
'                    p_c002          => v(''P149_CONST_TYPE''),'||chr(10)||
'                    p_c003          => v(''P149_SEL_COLS''),'||chr(10)||
'                    p_c004    ';

p:=p||'      => v(''P149_CHECK'') );'||chr(10)||
''||chr(10)||
''||chr(10)||
'    htp.prn(''<table cellpadding="0" cellspacing="0" class="htmldbStandard3"                '||chr(10)||
'      border="0" summary="" id="htmldbNewTable"><tbody>'');'||chr(10)||
'    htp.prn(''<tr><th class="tableheader2">''||'||chr(10)||
'     wwv_flow_lang.system_message(''OB_CONSTRAINT_NAME'')||''</th>'');'||chr(10)||
'    htp.prn(''<th class="tableheader2">''||'||chr(10)||
'     wwv_flow_lang.system_message(''PAGE_REGION.TREE_TYPE'')||''</t';

p:=p||'h>'');'||chr(10)||
'    htp.prn(''<th class="tableheader2">''||'||chr(10)||
'     wwv_flow_lang.system_message(''OB_CONS_INFO'')||''</th>'');'||chr(10)||
'    htp.prn(''<th class="tableheader2">''||''&nbsp;''||''</th>'');'||chr(10)||
'    htp.p(''</tr>'');'||chr(10)||
''||chr(10)||
'  for c1 in (select seq_id,c001, c002, c003, c004'||chr(10)||
'                 from wwv_flow_collections        '||chr(10)||
'                where collection_name = ''TBL_WIZ_CONS'''||chr(10)||
'                and c001 is not null'||chr(10)||
'                ';

p:=p||'order by seq_id ) loop'||chr(10)||
'    htp.prn(''<tr id="consTab_''||c1.seq_id||''">'');'||chr(10)||
'    htp.prn(''<td>''||c1.c001||''</td>'');'||chr(10)||
'    if c1.c002 = ''C'' then'||chr(10)||
'      htp.prn(''<td>''||wwv_flow_lang.system_message(''F4500_CHECK'')||''</td>'');'||chr(10)||
'      htp.prn(''<td>''||c1.c004||''</td>'');'||chr(10)||
'    else'||chr(10)||
'      htp.prn(''<td>''||wwv_flow_lang.system_message(''F4500_UNIQUE'')||''</td>'');'||chr(10)||
'      htp.prn(''<td>''||c1.c003||''</td>'');'||chr(10)||
'    end if;'||chr(10)||
'    ';

p:=p||'htp.prn(''<td style="text-align: center;" class="htmldbPseudoButton">'');'||chr(10)||
'    htp.prn(''<img src="#IMAGE_PREFIX#delete.gif" onclick="ob_rmConsRow('');'||chr(10)||
'    htp.prn(c1.seq_id||'')" /></td>'');'||chr(10)||
'    htp.p(''</tr>'');'||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'    htp.p(''</table>'');'||chr(10)||
' end if;'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 176127519858657209.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ob_add_cons',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to process',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 26-APR-2005 14:35:13');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/ob_rm_cons_row
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'begin'||chr(10)||
'  HTMLDB_COLLECTION.DELETE_MEMBER('||chr(10)||
'    p_collection_name => ''TBL_WIZ_CONS'' ,'||chr(10)||
'    p_seq             => :P149_CONS_SEQ'||chr(10)||
'  );'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 176138206577719675.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'ob_rm_cons_row',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to process',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 26-APR-2005 14:45:37');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/check_avail_jobs
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_jobs number;'||chr(10)||
'begin'||chr(10)||
'  select value-(select count(*) from sys.dba_jobs) into l_jobs  '||chr(10)||
'  from v$parameter '||chr(10)||
'  where name = ''job_queue_processes'';'||chr(10)||
'  htp.prn(l_jobs);'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 192446004690296352.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'check_avail_jobs',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to get job status',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 10-MAY-2005 16:28:24');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/check_job_queue
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_jobs number;'||chr(10)||
'begin'||chr(10)||
'  select value into l_jobs  '||chr(10)||
'  from v$parameter '||chr(10)||
'  where name = ''job_queue_processes'';'||chr(10)||
'  htp.prn(l_jobs);'||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 251183224917806135.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'check_job_queue',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to check jobs',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 23-MAY-2005 11:26:42');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/get_message
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'htp.p(wwv_flow_lang.system_message(:SYSTEM_MESSAGE));';

wwv_flow_api.create_flow_process(
  p_id => 251509908846066406.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'get_message',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to get message.',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 23-MAY-2005 12:10:05');
end;
 
null;
 
end;
/

--application/shared_components/logic/application_processes/qb_check_unique
 
begin
 
declare
    p varchar2(32767) := null;
    l_clob clob;
    l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_counter number;'||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  select count(*) into l_counter '||chr(10)||
'  from wwv_flow_qb_saved_query '||chr(10)||
'  where title = v(''P1002_QUERY_NAME'') '||chr(10)||
'   and created_by = v(''FLOW_USER'')'||chr(10)||
'   and security_group_id = wwv_flow_security.g_security_group_id;'||chr(10)||
''||chr(10)||
'  if (l_counter > 0) then'||chr(10)||
'   htp.p(''<div class="htmldbNotification"><ul><li>'');'||chr(10)||
'   htp.p(wwv_flow_lang.system_message(''QB_DUPLICATE_QUERY''));'||chr(10)||
'   htp.p(''</li><';

p:=p||'/ul></div>'');'||chr(10)||
'  else'||chr(10)||
'    htp.prn(''0'');'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_flow_process(
  p_id => 266120031373725934.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_process_sequence=> 1,
  p_process_point => 'ON_DEMAND',
  p_process_type=> 'PLSQL',
  p_process_name=> 'qb_check_unique',
  p_process_sql_clob=> p,
  p_process_error_message=> 'Unable to validate save',
  p_process_when=> '',
  p_process_when_type=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_process_comment=> 'created 20-JUN-2005 14:13:20');
end;
 
null;
 
end;
/

prompt  ...application items
--
--application/shared_components/logic/application_items/company
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 5086354147.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'COMPANY',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/current_object_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 63888631031213062.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'CURRENT_OBJECT_ID',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/dba_username
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 25966015567654518.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'DBA_USERNAME',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'I',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4500_dba_login
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 206052124417257915.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4500_DBA_LOGIN',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'I',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4500_last_view
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 48602367732370754.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4500_LAST_VIEW',
  p_data_type=> 'NUMBER',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/f4500_p502_object_type
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 240551529397730482.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4500_P502_OBJECT_TYPE',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fsp_after_login_url
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 22437001853024837.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FSP_AFTER_LOGIN_URL',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Used by Custom2 authentication for deep linking support');
 
null;
 
end;
/

--application/shared_components/logic/application_items/g_ctrl_file_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 34319320571482284.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'G_CTRL_FILE_ID',
  p_data_type=> 'NUMBER',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/g_parse_as_schema_override
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 270085717148798034.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'G_PARSE_AS_SCHEMA_OVERRIDE',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'I',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/last_selected_parse_as
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 101416805412462518.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'LAST_SELECTED_PARSE_AS',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'This is used to support public synonyms.  Supporting public synonym is on hold until R2.');
 
null;
 
end;
/

--application/shared_components/logic/application_items/last_step
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 48607820040821755.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'LAST_STEP',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/object_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 12255104688621266.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'OBJECT_ID',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/object_locker
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 12255530314628639.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'OBJECT_LOCKER',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/object_name
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 12255902395630078.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'OBJECT_NAME',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/object_owner
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 12256308628631835.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'OBJECT_OWNER',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/object_type
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 12258200626676850.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'OBJECT_TYPE',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/ob_object_id
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 171514813299244598.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'OB_OBJECT_ID',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/success_msg
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 106656207167489750.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'SUCCESS_MSG',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'This application item is used to display success message for certain SQL Workshop regions. (Used from SQL Command Processor page 3 and page 1)');
 
null;
 
end;
/

--application/shared_components/logic/application_items/system_message
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 251508117719059591.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'SYSTEM_MESSAGE',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

prompt  ...application level computations
--
 
begin
 
--application/shared_components/logic/application_computations/company
wwv_flow_api.create_flow_computation (
  p_id => 5088358914.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_computation_sequence => 10,
  p_computation_item => 'COMPANY',
  p_computation_point    => 'ON_NEW_INSTANCE',
  p_computation_type => 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation => 'return wwv_flow.get_company_name;',
  p_compute_when=> '',
  p_compute_when_type=> '',
  p_computation_error_message=>'작업 영역 이름을 계산할 수 없습니다.',
  p_computation_comment=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset);
 
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Shared Lists of values
--
--application/shared_components/user_interface/lov/access_restrictions
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 21837016666086569.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ACCESS_RESTRICTIONS',
  p_lov_query=> '.'||to_char(21837016666086569 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21837217288086572.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>21837016666086569.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'로컬 서버에서만 사용할 수 있음',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21837410790086575.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>21837016666086569.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'로컬 서버와 원격 클라이언트에서 사용할 수 있음',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/active_inactive
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 133833120564560201.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ACTIVE INACTIVE',
  p_lov_query=> '.'||to_char(133833120564560201 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>133833301814560204.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>133833120564560201.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'활성',
  p_lov_return_value=>'ACTIVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>133833501889560209.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>133833120564560201.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'비활성',
  p_lov_return_value=>'INACTIVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/all_or_varchar2_column_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88068725864843110.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ALL.OR.VARCHAR2.COLUMN.TYPES',
  p_lov_query=> '.'||to_char(88068725864843110 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88068924929843115.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88068725864843110.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'모든 열 유형',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88069124491843115.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88068725864843110.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'VARCHAR 열 유형',
  p_lov_return_value=>'0',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/all_selected_cols
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88062000322816814.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ALL.SELECTED.COLS',
  p_lov_query=> '.'||to_char(88062000322816814 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88062216112816814.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88062000322816814.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'모든 열',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88062421264816815.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88062000322816814.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'선택한 열',
  p_lov_return_value=>'SELECTED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/analyze_opts
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88060821315813411.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ANALYZE.OPTS',
  p_lov_query=> '.'||to_char(88060821315813411 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88061023444813411.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88060821315813411.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'통계 계산',
  p_lov_return_value=>'COMPUTE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88061212749813412.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88060821315813411.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'통계 예측',
  p_lov_return_value=>'ESTIMATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88061405135813412.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88060821315813411.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'구조 검증',
  p_lov_return_value=>'VALIDATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/apex_dictionary_query_conditions
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 14480503854514923.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APEX DICTIONARY QUERY CONDITIONS',
  p_lov_query=> '.'||to_char(14480503854514923 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14480728931514923.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14480503854514923.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'=',
  p_lov_return_value=>'=',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14480909767514923.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14480503854514923.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'!=',
  p_lov_return_value=>'!=',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14481110010514923.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14480503854514923.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'LIKE',
  p_lov_return_value=>'LIKE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14493818099547338.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14480503854514923.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'NOT LIKE',
  p_lov_return_value=>'NOT LIKE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14482210780516882.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14480503854514923.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'>',
  p_lov_return_value=>'>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14482613551517732.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14480503854514923.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'<',
  p_lov_return_value=>'<',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14608723770258677.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14480503854514923.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'BETWEEN',
  p_lov_return_value=>'BETWEEN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14609025848259268.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14480503854514923.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'IS',
  p_lov_return_value=>'IS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/apex_dictionary_view_modes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 14392800214125907.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APEX DICTIONARY VIEW MODES',
  p_lov_query=> '.'||to_char(14392800214125907 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14393015881125907.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14392800214125907.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'아이콘',
  p_lov_return_value=>'ICONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14393201164125907.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14392800214125907.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'트리',
  p_lov_return_value=>'TREE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14393419313125907.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14392800214125907.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'보고서',
  p_lov_return_value=>'REPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/apex_view_names
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 14454808001440421.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APEX VIEW NAMES',
  p_lov_query=> 'select distinct apex_view_name d,'||chr(10)||
'       apex_view_name r'||chr(10)||
' from apex_dictionary '||chr(10)||
'where column_id=0'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/asc_desc_returns_asc_desc
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88023114905423598.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ASC.DESC.RETURNS.ASC.DESC',
  p_lov_query=> '.'||to_char(88023114905423598 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88023312120423599.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88023114905423598.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'오름차순',
  p_lov_return_value=>'ASC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88023515635423599.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88023114905423598.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'내림차순',
  p_lov_return_value=>'DESC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/ascdesc
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 23484408692637977.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ASCDESC',
  p_lov_query=> '.'||to_char(23484408692637977 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23484707046637977.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>23484408692637977.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'오름차순',
  p_lov_return_value=>'A',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23484911662637978.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>23484408692637977.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'내림차순',
  p_lov_return_value=>'D',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/autocommit
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 136789232141518670.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AUTOCOMMIT',
  p_lov_query=> '.'||to_char(136789232141518670 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>136789414003518672.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>136789232141518670.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'자동 커밋',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/cascade_checkbox
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6527926084636289.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CASCADE CHECKBOX',
  p_lov_query=> '.'||to_char(6527926084636289 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6528129949636292.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>6527926084636289.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'&nbsp',
  p_lov_return_value=>'CASCADE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/cascade_constraints
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88063516252821367.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CASCADE.CONSTRAINTS',
  p_lov_query=> '.'||to_char(88063516252821367 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88063706191821368.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88063516252821367.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'계단식 제약 조건?',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/case_sensitive_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88013722767293437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CASE.SENSITIVE.Y',
  p_lov_query=> '.'||to_char(88013722767293437 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88013930765293438.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88013722767293437.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'대소문자 구분',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/checkbox_for_views
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 12319218872723617.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CHECKBOX FOR VIEWS',
  p_lov_query=> '.'||to_char(12319218872723617 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>12319426920723618.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>12319218872723617.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'뷰',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/constraint_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 8657002398372817.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CONSTRAINT TYPES',
  p_lov_query=> '.'||to_char(8657002398372817 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8657206568372817.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>8657002398372817.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'검사',
  p_lov_return_value=>'C',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8657415834372818.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>8657002398372817.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'기본 키',
  p_lov_return_value=>'P',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8657606976372818.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>8657002398372817.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'고유',
  p_lov_return_value=>'U',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8657818917372818.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>8657002398372817.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'참조',
  p_lov_return_value=>'R',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/constraint_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 11518010813871302.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CONSTRAINT.STATUS',
  p_lov_query=> '.'||to_char(11518010813871302 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>11518205871871344.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>11518010813871302.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'사용으로 설정됨',
  p_lov_return_value=>'ENABLED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>11518415817871364.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>11518010813871302.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'사용 안함으로 설정됨',
  p_lov_return_value=>'DISABLED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>11518621543871364.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>11518010813871302.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'모두',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/constraint_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88046920202557653.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CONSTRAINT.TYPES',
  p_lov_query=> '.'||to_char(88046920202557653 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88047118047557654.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88046920202557653.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'검사',
  p_lov_return_value=>'CHECK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88047308153557654.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88046920202557653.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'외래 키',
  p_lov_return_value=>'FK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88047511353557655.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88046920202557653.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'기본 키',
  p_lov_return_value=>'PK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88047724693557655.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88046920202557653.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'고유',
  p_lov_return_value=>'UNIQUE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/contraint_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 270341627024745223.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CONTRAINT TYPES',
  p_lov_query=> '.'||to_char(270341627024745223 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>270341802062745225.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>270341627024745223.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'검사',
  p_lov_return_value=>'C',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>270342021056745226.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>270341627024745223.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'고유',
  p_lov_return_value=>'U',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_index_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 16028009107759017.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE INDEX TYPES',
  p_lov_query=> '.'||to_char(16028009107759017 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16028212649759018.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16028009107759017.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'일반',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16028407362759020.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16028009107759017.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'텍스트',
  p_lov_return_value=>'T',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_package_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 14616623348446893.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE PACKAGE OPTIONS',
  p_lov_query=> '.'||to_char(14616623348446893 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14616819122446896.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14616623348446893.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'사양',
  p_lov_return_value=>'SPEC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14617002053446897.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14616623348446893.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'본문',
  p_lov_return_value=>'BODY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16842100401146005.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14616623348446893.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'데이터베이스 테이블의 메소드를 사용하는 패키지',
  p_lov_return_value=>'TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_sample_tables
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 6103920279571913.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE SAMPLE TABLES',
  p_lov_query=> '.'||to_char(6103920279571913 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6104328246571918.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>6103920279571913.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'데모 주문 테이블 생성',
  p_lov_return_value=>'DEMO_ORDER',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4500:3110:&SESSION.:CC:&DEBUG.:3110:P3110_CREATE_OPTION:DEMO_ORDER"><img src="#IMAGE_PREFIX#htmldb/builder/create_demo_tables.gif" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a><br /><br />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>6104128939571916.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>6103920279571913.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'사원 및 부서 테이블 생성',
  p_lov_return_value=>'EMP_DEPT',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4500:3110:&SESSION.:CC:&DEBUG.:3110:P3110_CREATE_OPTION:EMP_DEPT"><img src="#IMAGE_PREFIX#htmldb/builder/create_std_tables.gif" height="115" width="140" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a><br /><br />',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_user_privileges
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 164684400772980444.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE USER PRIVILEGES',
  p_lov_query=> '.'||to_char(164684400772980444 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>164684601746980447.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>164684400772980444.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'CONNECT',
  p_lov_return_value=>'CONNECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>164684816646980450.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>164684400772980444.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'RESOURCE',
  p_lov_return_value=>'RESOURCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>164685019181980451.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>164684400772980444.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'DBA',
  p_lov_return_value=>'DBA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_package_how
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88084232331986937.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE.PACKAGE.HOW',
  p_lov_query=> '.'||to_char(88084232331986937 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88084409721986937.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88084232331986937.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'새 패키지 작성',
  p_lov_return_value=>'SCRATCH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88084631917986937.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88084232331986937.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'데이터베이스 테이블의 메소드를 사용하여 패키지 작성',
  p_lov_return_value=>'TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_table_how
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88092414548047979.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE.TABLE.HOW',
  p_lov_query=> '.'||to_char(88092414548047979 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88092609025047979.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88092414548047979.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'새로 만들기',
  p_lov_return_value=>'SCRATCH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88092810507047980.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88092414548047979.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'스프레드시트에서 복사하여 붙여넣기(데이터 워크숍으로 이동)',
  p_lov_return_value=>'SPREADSHEET',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_table_now_script
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88093424937050988.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE.TABLE.NOW.SCRIPT',
  p_lov_query=> '.'||to_char(88093424937050988 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88093602555050989.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88093424937050988.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'지금 테이블 생성',
  p_lov_return_value=>'RUN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88093808384050989.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88093424937050988.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'SQL 편집을 위한 스크립트 작성',
  p_lov_return_value=>'EDIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/create_table_fk_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 111182618715174982.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CREATE_TABLE_FK_TYPE',
  p_lov_query=> '.'||to_char(111182618715174982 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>245703827624645868.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>111182618715174982.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'삭제 허용 안함',
  p_lov_return_value=>'D',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>111183005880174986.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>111182618715174982.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'계단식 삭제',
  p_lov_return_value=>'C',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>111182804604174985.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>111182618715174982.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'삭제 시 널 설정',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/data_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 21015224563508746.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DATA_TYPES',
  p_lov_query=> '.'||to_char(21015224563508746 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21015508059508749.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>21015224563508746.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'NUMBER',
  p_lov_return_value=>'NUMBER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21015722350508750.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>21015224563508746.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'VARCHAR2',
  p_lov_return_value=>'VARCHAR2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21015902475508751.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>21015224563508746.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'DATE',
  p_lov_return_value=>'DATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21016106513508751.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>21015224563508746.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'TIMESTAMP',
  p_lov_return_value=>'TIMESTAMP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21016327140508751.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>21015224563508746.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'CHAR',
  p_lov_return_value=>'CHAR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21016525754508751.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>21015224563508746.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'CLOB',
  p_lov_return_value=>'CLOB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21016725005508751.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>21015224563508746.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'BLOB',
  p_lov_return_value=>'BLOB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21016914224508752.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>21015224563508746.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'NVARCHAR2',
  p_lov_return_value=>'NVARCHAR2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21019413051524343.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>21015224563508746.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'BINARY_FLOAT',
  p_lov_return_value=>'BINARY_FLOAT',
  p_lov_disp_cond_type=>'FUNCTION_BODY',
  p_lov_disp_cond=> 'return wwv_flow_utilities.db_version_is_at_least(''10.1'');',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21019722401527136.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>21015224563508746.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'BINARY_DOUBLE',
  p_lov_return_value=>'BINARY_DOUBLE',
  p_lov_disp_cond_type=>'FUNCTION_BODY',
  p_lov_disp_cond=> 'return wwv_flow_utilities.db_version_is_at_least(''10.1'');',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/db_parm_non_default
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 244335514951659559.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DB_PARM_NON_DEFAULT',
  p_lov_query=> '.'||to_char(244335514951659559 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>244335715591659561.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>244335514951659559.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'모두',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>244335932066659565.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>244335514951659559.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'비기본값',
  p_lov_return_value=>'CUSTOM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/ddl_actions
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DDL.ACTIONS',
  p_lov_query=> '.'||to_char(88039608166535203 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88039800819535204.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'열 추가',
  p_lov_return_value=>'ADD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88040002165535204.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'제약 조건 추가',
  p_lov_return_value=>'ADD_CONSTRAINT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88040231651535205.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'분석',
  p_lov_return_value=>'ANALYZE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88040417249535205.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'복사',
  p_lov_return_value=>'COPY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88040624827535205.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'인덱스 생성',
  p_lov_return_value=>'INDEX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88040822124535205.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'텍스트 인덱스 생성',
  p_lov_return_value=>'TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88041012331535206.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'트리거 생성',
  p_lov_return_value=>'CREATE_TRIGGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88041229308535206.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'제약 조건을 사용 안함으로 설정',
  p_lov_return_value=>'DISABLE_CONSTRAINT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88041400926535206.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'트리거를 사용 안함으로 설정',
  p_lov_return_value=>'DISABLE_TRIGGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88041603607535208.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'열 삭제',
  p_lov_return_value=>'REMOVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88041815176535208.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'제약 조건 삭제',
  p_lov_return_value=>'DROP_CONSTRAINT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88042009088535208.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'인덱스 삭제',
  p_lov_return_value=>'DROP_INDEX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88042226760535209.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'테이블 삭제',
  p_lov_return_value=>'DROP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88042406323535209.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>140,
  p_lov_disp_value=>'트리거 삭제',
  p_lov_return_value=>'DROP_TRIGGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88042607701535209.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>150,
  p_lov_disp_value=>'제약 조건을 사용으로 설정',
  p_lov_return_value=>'ENABLE_CONSTRAINT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88042803313535209.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>160,
  p_lov_disp_value=>'트리거를 사용으로 설정',
  p_lov_return_value=>'ENABLE_TRIGGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88043019072535210.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>170,
  p_lov_disp_value=>'열 수정',
  p_lov_return_value=>'MODIFY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88043204776535210.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>180,
  p_lov_disp_value=>'열 이름 바꾸기',
  p_lov_return_value=>'RENAME_COLUMN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88043422512535210.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>190,
  p_lov_disp_value=>'테이블 이름 바꾸기',
  p_lov_return_value=>'RENAME',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88043603529535211.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88039608166535203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>200,
  p_lov_disp_value=>'자르기',
  p_lov_return_value=>'TRUNCATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/describe_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 22153924949556802.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DESCRIBE_TYPES',
  p_lov_query=> '.'||to_char(22153924949556802 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22154111837556805.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>22153924949556802.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'TABLE',
  p_lov_return_value=>'TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22517827091787523.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>22153924949556802.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'VIEW',
  p_lov_return_value=>'VIEW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22518130554788590.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>22153924949556802.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'PROCEDURE',
  p_lov_return_value=>'PROCEDURE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22518404019790369.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>22153924949556802.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'FUNCTION',
  p_lov_return_value=>'FUNCTION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22518909907792079.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>22153924949556802.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'PACKAGE',
  p_lov_return_value=>'PACKAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/display_inline
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88029914736461415.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DISPLAY.INLINE',
  p_lov_query=> '.'||to_char(88029914736461415 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88030128904461415.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88029914736461415.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'인라인으로 표시',
  p_lov_return_value=>'DISPLAY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/display_as_reports
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 285136607862263925.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DISPLAY_AS_REPORTS',
  p_reference_id=> 285506029323635827,
  p_lov_query=> '.'||to_char(285136607862263925 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108084526445030643.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>285136607862263925.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'표준 보고서 열(표시 전용, 상태를 저장하지 않음)',
  p_lov_return_value=>'WITHOUT_MODIFICATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108084705562030643.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>285136607862263925.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'텍스트로 표시(LOV 기반, 상태를 저장하지 않음)',
  p_lov_return_value=>'TEXT_FROM_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108084932477030643.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>285136607862263925.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'텍스트로 표시(상태 저장)',
  p_lov_return_value=>'DISPLAY_AND_SAVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108085112395030643.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>285136607862263925.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'텍스트로 표시(이스케이프 특수 문자, 상태를 저장하지 않음)',
  p_lov_return_value=>'ESCAPE_SC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108085330405030643.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>285136607862263925.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'숨김 ',
  p_lov_return_value=>'HIDDEN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/display_as_tabular_forms
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DISPLAY_AS_TABULAR_FORMS',
  p_lov_query=> '.'||to_char(173321532130152965 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108070909691016343.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'표준 보고서 열(표시 전용, 상태를 저장하지 않음)',
  p_lov_return_value=>'WITHOUT_MODIFICATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108071103633016343.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트로 표시(LOV 기반, 상태를 저장하지 않음)',
  p_lov_return_value=>'TEXT_FROM_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108071320755016343.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트로 표시(상태 저장)',
  p_lov_return_value=>'DISPLAY_AND_SAVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108071517893016343.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트로 표시(이스케이프 특수 문자, 상태를 저장하지 않음)',
  p_lov_return_value=>'ESCAPE_SC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108071726823016343.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트 필드',
  p_lov_return_value=>'TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108071926389016343.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트 영역',
  p_lov_return_value=>'TEXTAREA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108072101156016343.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'선택 목록',
  p_lov_return_value=>'SELECT_LIST_FROM_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108072319348016343.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'숨김 ',
  p_lov_return_value=>'HIDDEN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108072523666016343.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'팝업 LOV',
  p_lov_return_value=>'POPUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108072726301016343.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기',
  p_lov_return_value=>'DATE_POPUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108072902041016343.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(애플리케이션 형식 마스크 사용)',
  p_lov_return_value=>'PICK_DATE_USING_APP_FORMAT_MASK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108073114807016343.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-RR)',
  p_lov_return_value=>'PICK_DATE_DD_MON_RR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108073320317016344.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-RR HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108073505124016344.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-RR HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108073706032016344.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-YY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH24_MI',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108073911349016344.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-YY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH_MI',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108074115783016344.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108074322493016344.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108074521430016344.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108074730419016344.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-YY)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YY',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108074911008016344.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD/MM/YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108075100812016344.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD/MM/YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108075332696016345.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD/MM/YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108075516430016345.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(MM/DD/YYYY)',
  p_lov_return_value=>'PICK_DATE_MM_DD_YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108075700209016345.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(MM/DD/YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108075913799016345.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(MM/DD/YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108076125223016345.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(RR-MON-DD)',
  p_lov_return_value=>'PICK_DATE_RR_MON_DD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108076313464016345.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(RR-MON-DD HH24:MI)',
  p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108076515529016345.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(RR-MON-DD HH:MI)',
  p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108076725453016345.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(YYYY-MM-DD)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108076913772016345.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY-MM-DD HH24:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108077111031016345.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY-MM-DD HH:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108077331467016345.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(DD-MM-YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108077528710016345.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(DD-MM-YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108077720268016346.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(DD-MM-YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108077923098016346.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(DD.MM.YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108078110678016346.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(DD.MM.YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108078309308016346.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(DD.MM.YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108078528637016346.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY.DD.MM)',
  p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108078730750016346.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY.DD.MM HH24:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108078928693016346.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY.DD.MM HH:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108079128762016346.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY/MM/DD)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_SLASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108079326218016346.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY/MM/DD HH24:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108079524994016346.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY/MM/DD HH:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>108079705480016346.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>173321532130152965.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(애플리케이션 날짜 형식 사용)',
  p_lov_return_value=>'PICK_DATE_USING_APP_DATE_FORMAT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/display_or_save
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88028228457455927.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DISPLAY_OR_SAVE',
  p_lov_query=> '.'||to_char(88028228457455927 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88028407997455927.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88028228457455927.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'인라인으로 표시',
  p_lov_return_value=>'DISPLAY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88028614614455928.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88028228457455927.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'스크립트 파일로 저장',
  p_lov_return_value=>'SCRIPT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/distinct_columns
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 102422424410025075.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DISTINCT_COLUMNS',
  p_lov_query=> 'select distinct :column_name'||chr(10)||
''||chr(10)||
'from   :table_name'||chr(10)||
''||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/dynamic_object_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 167453708814513863.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DYNAMIC OBJECT TYPES',
  p_lov_query=> 'select distinct'||chr(10)||
'       object_type d,'||chr(10)||
'       object_type r'||chr(10)||
' from sys.dba_objects where owner = :F4500_P500_SCHEMA'||chr(10)||
'union  select ''DATABASE LINK'' d,''DATABASE LINK'' r from dual'||chr(10)||
'union  select ''TABLE'' d,''TABLE'' r from dual'||chr(10)||
'union  select ''TRIGGER'' d,''TRIGGER'' r from dual'||chr(10)||
'union  select ''JAVA CLASS'' d,''JAVA CLASS'' r from dual'||chr(10)||
'union  select ''JAVA SOURCE'' d,''JAVA SOURCE'' r from dual'||chr(10)||
'union  select ''INDEX'' d,''INDEX'' r from dual'||chr(10)||
'union  select ''SEQUENCE'' d,''SEQUENCE'' r from dual'||chr(10)||
'union  select ''FUNCTION'' d,''FUNCTION'' r from dual'||chr(10)||
'union  select ''PROCEDURE'' d,''PROCEDURE'' r from dual'||chr(10)||
'union  select ''PACKAGE'' d,''PACKAGE'' r from dual'||chr(10)||
'union  select ''PACKAGE BODY'' d,''PACKAGE BODY'' r from dual'||chr(10)||
'union  select ''XML SCHEMA'' d,''XML SCHEMA'' r from dual'||chr(10)||
'union  select ''TYPE'' d,''TYPE'' r from dual'||chr(10)||
'union  select ''VIEW'' d,''VIEW'' r from dual'||chr(10)||
'union  select ''MATERIALIZED VIEW'' d,''MATERIALIZED VIEW'' r from dual'||chr(10)||
'union  select ''SYNONYM'' d,''SYNONYM'' r from dual'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/expire_password
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 7461015136055036.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'EXPIRE PASSWORD',
  p_lov_query=> '.'||to_char(7461015136055036 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>7461210075055051.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>7461015136055036.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'&nbsp;',
  p_lov_return_value=>'EXPIRE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/f4500_p93_columns
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 166001030922348323.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'F4500_P93_COLUMNS',
  p_lov_query=> 'select htf.escape_sc(COLUMN_NAME)||'' (''||data_type||'')'' d,  column_name r'||chr(10)||
'from sys.dba_tab_columns'||chr(10)||
'where owner =  upper(:OB_SCHEMA) and'||chr(10)||
'table_name= :OBJECT_NAME'||chr(10)||
'order by column_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/for_each_row
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88058923955804681.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FOR.EACH.ROW',
  p_lov_query=> '.'||to_char(88058923955804681 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88059109438804682.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88058923955804681.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'각 행에 대해',
  p_lov_return_value=>'for each row',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/grant_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 270678820518416779.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'GRANT_TYPES',
  p_lov_query=> '.'||to_char(270678820518416779 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>270679015580416783.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>270678820518416779.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'모두',
  p_lov_return_value=>'All',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>270679225991416783.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>270678820518416779.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'특정 권한',
  p_lov_return_value=>'Specific',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/i18n_iana_charset
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'I18N_IANA_CHARSET',
  p_reference_id=> 144796827445692396,
  p_lov_query=> '.'||to_char(143356515285702408 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70943922316399262.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'아랍어 ISO-8859-6',
  p_lov_return_value=>'iso-8859-6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70944123961399262.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'아랍어 Windows 1256',
  p_lov_return_value=>'windows-1256',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70944301772399262.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'중국어 Big5',
  p_lov_return_value=>'big5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70944520480399262.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'중국어 GBK',
  p_lov_return_value=>'gbk',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70944716216399262.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'키릴어 ISO-8859-5',
  p_lov_return_value=>'iso-8859-5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70944913278399262.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'키릴어 KOI8-R',
  p_lov_return_value=>'koi8-r',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70945123594399263.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'키릴어 KOI8-U',
  p_lov_return_value=>'koi8-u',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70945312931399263.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'키릴어 Windows 1251',
  p_lov_return_value=>'windows-1251',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70945514541399263.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'동유럽어 ISO-8859-2',
  p_lov_return_value=>'iso-8859-2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70945704341399263.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'동유럽어 Windows 1250',
  p_lov_return_value=>'windows-1250',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70945917493399263.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'그리스어 ISO-8859-7',
  p_lov_return_value=>'iso-8859-7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70946107215399263.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'그리스어 Windows 1253',
  p_lov_return_value=>'windows-1253',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70946332124399263.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'히브리어 ISO-8859-8-i',
  p_lov_return_value=>'iso-8859-8-i',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70946501963399263.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>140,
  p_lov_disp_value=>'히브리어 Windows 1255',
  p_lov_return_value=>'windows-1255',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70946714623399263.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>150,
  p_lov_disp_value=>'일본어 EUC',
  p_lov_return_value=>'euc-jp',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70946927275399263.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>160,
  p_lov_disp_value=>'일본어 Shift JIS',
  p_lov_return_value=>'shift_jis',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70947127311399263.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>170,
  p_lov_disp_value=>'한국어 EUC-KR',
  p_lov_return_value=>'euc-kr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70947311716399264.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>180,
  p_lov_disp_value=>'북유럽어 ISO-8859-4',
  p_lov_return_value=>'iso-8859-4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70947504489399264.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>190,
  p_lov_disp_value=>'북유럽어 Windows 1257',
  p_lov_return_value=>'windows-1257',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70947729191399264.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>200,
  p_lov_disp_value=>'남유럽어 ISO-8859-3',
  p_lov_return_value=>'iso-8859-3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70947916195399264.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>210,
  p_lov_disp_value=>'태국어 TIS-620',
  p_lov_return_value=>'tis-620',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70948118028399264.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>220,
  p_lov_disp_value=>'터키어 ISO-8859-9',
  p_lov_return_value=>'iso-8859-9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70948312863399264.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>230,
  p_lov_disp_value=>'터키어 Windows 1254',
  p_lov_return_value=>'windows-1254',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70948502309399265.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>240,
  p_lov_disp_value=>'유니코드 UTF-8',
  p_lov_return_value=>'utf-8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70948703369399265.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>242,
  p_lov_disp_value=>'유니코드 UTF-16 빅 엔디언',
  p_lov_return_value=>'utf-16be',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70948902272399266.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>244,
  p_lov_disp_value=>'유니코드 UTF-16 리틀 엔디언',
  p_lov_return_value=>'utf-16le',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70949105940399266.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>248,
  p_lov_disp_value=>'US-ASCII',
  p_lov_return_value=>'us-ascii',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70949303368399266.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>250,
  p_lov_disp_value=>'베트남어 Windows 1258',
  p_lov_return_value=>'windows-1258',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70949531264399266.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>260,
  p_lov_disp_value=>'서유럽어 ISO-8859-1',
  p_lov_return_value=>'iso-8859-1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70949720317399266.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143356515285702408.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>270,
  p_lov_disp_value=>'서유럽어 Windows 1252',
  p_lov_return_value=>'windows-1252',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/i18n_iana_db_charset
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'I18N_IANA_DB_CHARSET',
  p_reference_id=> 144802427115692411,
  p_lov_query=> '.'||to_char(143362112016702427 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70925614558398099.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'아랍어 ISO-8859-6',
  p_lov_return_value=>'AR8ISO8859P6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70925824352398099.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'아랍어 Windows 1256',
  p_lov_return_value=>'AR8MSWIN1256',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70926018115398099.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'중국어 Big5',
  p_lov_return_value=>'ZHT16MSWIN950',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70926226771398099.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'중국어 GBK',
  p_lov_return_value=>'ZHS16GBK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70926402040398099.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'키릴어 ISO-8859-5',
  p_lov_return_value=>'CL8ISO8859P5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70926609127398100.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'키릴어 KOI8-R',
  p_lov_return_value=>'CL8KOI8R',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70926808888398100.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'키릴어 KOI8-U',
  p_lov_return_value=>'CL8KOI8U',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70927031649398100.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'키릴어 Windows 1251',
  p_lov_return_value=>'CL8MSWIN1251',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70927213227398100.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'동유럽어 ISO-8859-2',
  p_lov_return_value=>'EE8ISO8859P2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70927410363398100.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'동유럽어 Windows 1250',
  p_lov_return_value=>'EE8MSWIN1250',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70927622443398100.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'그리스어 ISO-8859-7',
  p_lov_return_value=>'EL8ISO8859P7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70927830711398100.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'그리스어 Windows 1253',
  p_lov_return_value=>'EL8MSWIN1253',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70928000609398100.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'히브리어 ISO-8859-8-i',
  p_lov_return_value=>'IW8ISO8859P8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70928211237398100.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>140,
  p_lov_disp_value=>'히브리어 Windows 1255',
  p_lov_return_value=>'IW8MSWIN1255',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70928416939398100.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>150,
  p_lov_disp_value=>'일본어 EUC',
  p_lov_return_value=>'JA16EUC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70928613980398100.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>160,
  p_lov_disp_value=>'일본어 Shift JIS',
  p_lov_return_value=>'JA16SJIS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70928822013398100.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>170,
  p_lov_disp_value=>'한국어 EUC-KR',
  p_lov_return_value=>'KO16MSWIN949',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70929016275398101.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>180,
  p_lov_disp_value=>'북유럽어 ISO-8859-4',
  p_lov_return_value=>'NEE8ISO8859P4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70929223616398102.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>190,
  p_lov_disp_value=>'북유럽어 Windows 1257',
  p_lov_return_value=>'BLT8MSWIN1257',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70929412692398102.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>200,
  p_lov_disp_value=>'남유럽어 ISO-8859-3',
  p_lov_return_value=>'SE8ISO8859P3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70929629156398102.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>210,
  p_lov_disp_value=>'태국어 TIS-620',
  p_lov_return_value=>'TH8TISASCII',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70929828946398102.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>220,
  p_lov_disp_value=>'터키어 ISO-8859-9',
  p_lov_return_value=>'WE8ISO8859P9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70930026386398102.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>230,
  p_lov_disp_value=>'터키어 Windows 1254',
  p_lov_return_value=>'TR8MSWIN1254',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70930203193398102.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>240,
  p_lov_disp_value=>'유니코드 UTF-8',
  p_lov_return_value=>'AL32UTF8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70930419276398103.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>242,
  p_lov_disp_value=>'유니코드 UTF-16 빅 엔디언',
  p_lov_return_value=>'AL16UTF16',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70930604497398103.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>244,
  p_lov_disp_value=>'유니코드 UTF-16 리틀 엔디언',
  p_lov_return_value=>'AL16UTF16LE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70930803288398103.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>248,
  p_lov_disp_value=>'US-ASCII',
  p_lov_return_value=>'US7ASCII',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70931000600398103.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>250,
  p_lov_disp_value=>'베트남어 Windows 1258',
  p_lov_return_value=>'VN8MSWIN1258',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70931220425398103.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>260,
  p_lov_disp_value=>'서유럽어 ISO-8859-1',
  p_lov_return_value=>'WE8ISO8859P1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70931430933398103.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>143362112016702427.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>270,
  p_lov_disp_value=>'서유럽어 Windows 1252',
  p_lov_return_value=>'WE8MSWIN1252',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/icon_detail_view_modes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 144167830179232748.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ICON DETAIL VIEW MODES',
  p_reference_id=> 116048926655714272,
  p_lov_query=> '.'||to_char(144167830179232748 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>240823626953628604.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>144167830179232748.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'아이콘',
  p_lov_return_value=>'ICON',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>240823804523628605.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>144167830179232748.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'세부 정보',
  p_lov_return_value=>'DETAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/include_args_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88064701145826564.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INCLUDE.ARGS.Y',
  p_lov_query=> '.'||to_char(88064701145826564 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88064927960826565.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88064701145826564.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'인수 포함',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/intra_component_navigator
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 1457916849659682.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'INTRA COMPONENT NAVIGATOR',
  p_lov_query=> '.'||to_char(1457916849659682 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1458119331659683.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1457916849659682.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'객체 브라우저',
  p_lov_return_value=>'1001',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1458304212659683.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1457916849659682.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'SQL 명령',
  p_lov_return_value=>'1003',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1458524645659683.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1457916849659682.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'SQL 스크립트',
  p_lov_return_value=>'1004',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1458701375659683.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1457916849659682.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Query Builder',
  p_lov_return_value=>'1002',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/item_display_as2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ITEM_DISPLAY_AS2',
  p_reference_id=> 183325630267116750,
  p_lov_query=> '.'||to_char(25432508098697731 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276326617820361562.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'선택 목록(팝업 LOV 사용)',
  p_lov_return_value=>'SHOW_AS_SL_WITH_POPUP',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276326807769361563.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'팝업 LOV(첫번째 행 집합 및 필터 인출)',
  p_lov_return_value=>'POPUP_FILTER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276327022662361563.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'팝업 색상 선택기',
  p_lov_return_value=>'POPUP_COLOR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276327214394361564.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'암호(Enter를 누를 때 제출)',
  p_lov_return_value=>'PASSWORD_WITH_ENTER_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276327408258361564.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트 필드(Enter를 누를 때 항상 페이지 제출)',
  p_lov_return_value=>'TEXT_WITH_ENTER_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276327608739361564.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(DD-MM-YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276327800953361564.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(DD-MM-YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276328021108361564.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(DD-MM-YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276328232113361564.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(DD.MM.YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276328404220361564.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(DD.MM.YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276328608463361564.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(DD.MM.YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276328830031361564.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY-MM-DD HH24:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276329005489361564.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY-MM-DD HH:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276329226395361564.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY.DD.MM HH24:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH24_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276329414725361565.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY.DD.MM HH:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_HH_MI_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276329604598361565.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY.DD.MM)',
  p_lov_return_value=>'PICK_DATE_YYYY_DD_MM_DOT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276329808482361565.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY/MM/DD HH24:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH24_MI_SLASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276330004444361565.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY/MM/DD HH:MI)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_HH_MI_SLASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276330205270361565.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(YYYY/MM/DD)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD_SLASH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276330427608361565.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(RR-MON-DD HH24:MI)',
  p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276330604253361565.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 생성기(RR-MON-DD HH:MI)',
  p_lov_return_value=>'PICK_DATE_RR_MON_DD_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276330816012361565.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'팝업 키 LOV 인출 없음(설명 표시, 사전 인출 없이 키 값 반환)',
  p_lov_return_value=>'POPUP_KEY_LOV_NOFETCH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276331015870361565.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(YYYY-MM-DD)',
  p_lov_return_value=>'PICK_DATE_YYYY_MM_DD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276331204243361565.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(RR-MON-DD)',
  p_lov_return_value=>'PICK_DATE_RR_MON_DD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276331418189361565.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'셔틀',
  p_lov_return_value=>'SHUTTLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276331620083361565.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'HTML 편집기(최소)',
  p_lov_return_value=>'TEXTAREA_WITH_HTML_EDITOR_BASIC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276331809905361566.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'HTML 편집기(표준)',
  p_lov_return_value=>'TEXTAREA_WITH_HTML_EDITOR_STANDARD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276332029725361566.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트로 표시(PLSQL 기반, 상태를 저장하지 않음)',
  p_lov_return_value=>'DISPLAY_ONLY_PLSQL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276332222476361566.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-RR)',
  p_lov_return_value=>'PICK_DATE_DD_MON_RR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276332400035361567.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-RR HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276332632022361567.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-RR HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_RR_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276332832052361567.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(항목 형식 마스크 사용)',
  p_lov_return_value=>'PICK_DATE_USING_FORMAT_MASK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276333000193361567.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'선택 목록',
  p_lov_return_value=>'COMBOBOX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276333220225361568.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트 영역(문자 카운터 사용)',
  p_lov_return_value=>'TEXTAREA_CHAR_COUNT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276333406280361568.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트 영역(문자 카운터 및 철자 검사 사용)',
  p_lov_return_value=>'TEXTAREA_CHAR_COUNT_SPELL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276333603593361568.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(애플리케이션 날짜 형식 사용)',
  p_lov_return_value=>'PICK_DATE_USING_APP_DATE_FORMAT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276333824057361568.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'숨김 및 보호됨',
  p_lov_return_value=>'HIDDEN_PROTECTED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276334010769361568.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'숨김',
  p_lov_return_value=>'HIDDEN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276334205135361568.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'HTML 테이블 정지 및 시작(레이블만 표시)',
  p_lov_return_value=>'STOP_AND_START_HTML_TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276334421800361568.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트로 표시(LOV 기반, 상태를 저장하지 않음)',
  p_lov_return_value=>'DISPLAY_ONLY_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276334604740361568.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트로 표시(상태를 저장하지 않음)',
  p_lov_return_value=>'DISPLAY_ONLY_HTML',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276334829062361568.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트로 표시(이스케이프 특수 문자, 상태를 저장하지 않음)',
  p_lov_return_value=>'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276335029787361568.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트로 표시(상태 저장)',
  p_lov_return_value=>'DISPLAY_AND_SAVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276335229355361568.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'체크 박스',
  p_lov_return_value=>'CHECKBOX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276335425234361568.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'팝업 LOV(첫번째 행 집합 인출)',
  p_lov_return_value=>'POPUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276335626249361568.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'다중 선택 목록',
  p_lov_return_value=>'MULTIPLESELECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276335829954361569.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'라디오 그룹',
  p_lov_return_value=>'RADIOGROUP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276336015776361569.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'라디오 그룹(제출 사용)',
  p_lov_return_value=>'RADIOGROUP_WITH_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276336231439361569.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트 영역',
  p_lov_return_value=>'TEXTAREA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276336431049361569.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트 필드',
  p_lov_return_value=>'TEXT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276336622779361569.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'암호',
  p_lov_return_value=>'PASSWORD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276336813751361569.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'목록 관리자(팝업 LOV 기반)',
  p_lov_return_value=>'LIST_MGR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276337024828361570.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'목록 관리자(보기 전용)',
  p_lov_return_value=>'LIST_MGR_VIEW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276337208517361570.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'단추',
  p_lov_return_value=>'BUTTON',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276337423131361570.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'파일 찾아보기...',
  p_lov_return_value=>'FILE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276337627952361570.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'팝업 LOV(인출 없음)',
  p_lov_return_value=>'POPUP2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276337818894361570.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'목록 관리자(팝업 LOV 기반, 인출 없음)',
  p_lov_return_value=>'LIST_MGR2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276338011222361570.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'선택 목록(제출 사용)',
  p_lov_return_value=>'COMBOBOX_WITH_SUBMIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276338205454361570.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트로 표시(LOV 기반, 상태 저장)',
  p_lov_return_value=>'DISPLAY_AND_SAVE_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276338430468361570.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트 영역(자동 높이 사용)',
  p_lov_return_value=>'TEXTAREA-AUTO-HEIGHT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276338620491361570.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'선택 목록(재지정 사용)',
  p_lov_return_value=>'COMBOBOX_WITH_JS_REDIRECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276338811520361571.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트 영역(철자 검사기 사용)',
  p_lov_return_value=>'TEXTAREA_WITH_SPELL_CHECK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276339002648361571.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD/MM/YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276339209554361571.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(MM/DD/YYYY)',
  p_lov_return_value=>'PICK_DATE_MM_DD_YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276339418659361571.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-YYYY)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YYYY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276339632378361571.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-YY)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276339805070361571.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD/MM/YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276340009229361571.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(MM/DD/YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276340212684361571.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-YYYY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276340430971361571.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-YY HH24:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH24_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276340627280361571.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD/MM/YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MM_YYYY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276340815332361571.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(MM/DD/YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_MM_DD_YYYY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276341029218361571.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-YYYY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YYYY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276341221447361572.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(DD-MON-YY HH:MI)',
  p_lov_return_value=>'PICK_DATE_DD_MON_YY_HH_MI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276341405640361572.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트 필드(계산기 팝업 사용)',
  p_lov_return_value=>'TEXT_WITH_CALCULATOR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276341618802361572.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'날짜 선택기(애플리케이션 형식 마스크 사용)',
  p_lov_return_value=>'PICK_DATE_USING_FLOW_FORMAT_MASK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276341829118361572.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'라디오 그룹(재지정 사용)',
  p_lov_return_value=>'RADIOGROUP_WITH_REDIRECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276342022138361572.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'URL 재지정을 반환하는 선택 목록',
  p_lov_return_value=>'COMBOBOX_WITH_URL_REDIRECT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276342225448361572.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'선택 목록(페이지로 분기 사용)',
  p_lov_return_value=>'COMBOBOX_WITH_BRANCH_TO_PAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276342413480361572.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'목록 관리자(팝업 LOV 기반, 대소문자 유지)',
  p_lov_return_value=>'LIST_MGR3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276342614292361572.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트 필드(사용 안함으로 설정됨, 상태를 저장하지 않음)',
  p_lov_return_value=>'TEXT_DISABLED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276342818709361572.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'팝업 키 LOV(설명 표시, 키 값 반환)',
  p_lov_return_value=>'POPUP_KEY_LOV',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276343016415361572.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트 필드(사용 안함으로 설정됨, 상태 저장)',
  p_lov_return_value=>'TEXT_DISABLED_AND_SAVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276343229815361572.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'텍스트 영역(HTML 편집기 사용)',
  p_lov_return_value=>'TEXTAREA_WITH_CONTROLS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276343405842361572.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'비밀번호(Enter를 누를 때 제출되며 상태를 저장하지 않음)',
  p_lov_return_value=>'PASSWORD_WITH_SUBMIT_DNSS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276343620038361572.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25432508098697731.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'비밀번호(상태를 저장하지 않음)',
  p_lov_return_value=>'PASSWORD_DNSS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_all_schemas
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 26396713461308449.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_ALL_SCHEMAS',
  p_lov_query=> 'select username d, username v'||chr(10)||
'from all_users '||chr(10)||
'where wwv_flow_provisioning.restricted_schema_i(username,:APP_USER) = 0'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_all_schemas_wo_ob_schema
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 26377214558019246.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_ALL_SCHEMAS_WO_OB_SCHEMA',
  p_lov_query=> 'select username d, username v'||chr(10)||
'from all_users'||chr(10)||
'where wwv_flow_provisioning.restricted_schema_i(username,:APP_USER) = 0  '||chr(10)||
'and username !=  :OB_SCHEMA   '||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_available_schemas
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 64015215313088942.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_AVAILABLE_SCHEMAS',
  p_lov_query=> 'declare'||chr(10)||
'  q      varchar2(32767) := null;'||chr(10)||
'begin  '||chr(10)||
'  q:=''select htf.escape_sc(upper(c.schema)) d, upper(c.schema) v '';'||chr(10)||
'  q:=q||''from   wwv_flow_company_schemas c, '';'||chr(10)||
'  q:=q||''       wwv_flow_fnd_user u '';'||chr(10)||
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.user_name = :flow_user and '';'||chr(10)||
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';'||chr(10)||
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';'||chr(10)||
'  q:=q||''order by 1'';  '||chr(10)||
'  return q;'||chr(10)||
'end;');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_available_schemas_qb
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 14016705748242026.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_AVAILABLE_SCHEMAS-QB',
  p_lov_query=> 'declare'||chr(10)||
'  q      varchar2(32767) := null;'||chr(10)||
'begin'||chr(10)||
'  q:=''select htf.escape_sc(upper(c.schema)) d, upper(c.schema) v '';'||chr(10)||
'  q:=q||''from   wwv_flow_company_schemas c, ''; '||chr(10)||
'  q:=q||''       wwv_flow_fnd_user u ''; '||chr(10)||
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.user_name = :flow_user and '';'||chr(10)||
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';'||chr(10)||
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';'||chr(10)||
'  q:=q||''  and  nvl(:P1002_POPUP,0) <> 1 '';'||chr(10)||
'  q:=q||''union all '';'||chr(10)||
'  q:=q||''select htf.escape_sc(:P1002_SCHEMA) a,:P1002_SCHEMA b from dual '';'||chr(10)||
'  q:=q||''where  :P1002_POPUP = 1 '';'||chr(10)||
'  q:=q||''order by 1'';'||chr(10)||
'  return q;'||chr(10)||
'end;');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_available_schemas_sc
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 23001304041139468.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_AVAILABLE_SCHEMAS-SC',
  p_lov_query=> 'declare'||chr(10)||
'  q      varchar2(32767) := null;'||chr(10)||
'begin  '||chr(10)||
'  q:=''select htf.escape_sc(upper(c.schema)) d, upper(c.schema) v '';'||chr(10)||
'  q:=q||''from   wwv_flow_company_schemas c, '';'||chr(10)||
'  q:=q||''       wwv_flow_fnd_user u '';'||chr(10)||
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.user_name = :flow_user and '';'||chr(10)||
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';'||chr(10)||
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';'||chr(10)||
'  q:=q||''  and  nvl(:P1003_POPUP,0) <> 1 '';'||chr(10)||
'  q:=q||''union all '';'||chr(10)||
'  q:=q||''select htf.escape_sc(:P1003_SCHEMA) a,:P1003_SCHEMA b from dual '';'||chr(10)||
'  q:=q||''where  :P1003_POPUP = 1 '';'||chr(10)||
'  q:=q||''order by 1'';  '||chr(10)||
'  return q;'||chr(10)||
'end;');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_plug_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 177453120544049153.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_PLUG_TYPES',
  p_reference_id=> 32361488916,
  p_lov_query=> 'select D,R from('||chr(10)||
'select wwv_flow_lang.system_message(''SQL_QUERY'') D, ''SQL_QUERY'' R,1 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''SQL_QUERY'')||'' (''||initcap(wwv_flow_lang.system_message(''STRUCTURED_QUERY''))||'')'' D, ''STRUCTURED_QUERY'' R,1 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''SQL_QUERY'')||'' (''||initcap(wwv_flow_lang.system_message(''FUNCTION_BODY_RETURNING_QUERY''))||'')'' D,''FUNCTION_RETURNING_SQL_QUERY'' R,1 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''HTML_TEXT'') D, ''STATIC_TEXT'' R,1 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''PLSQL_PROCEDURE'')||'' (''||wwv_flow_lang.system_message(''ANONYMOUS_BLOCK'')||'')'' D, ''PLSQL_PROCEDURE'' R,1 OB from dual'||chr(10)||
' union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''WEB_SERVICE_RESULT'')) D,''WEB_SERVICE'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''HELP_TEXT'')) D, ''HELP_TEXT'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''CHART''))||'' (''||wwv_flow_lang.system_message(''HTML'')||'') ''||wwv_flow_lang.system_message(''CHART'') D, ''SIMPLE_CHART'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''CHART''))||'' (SVG)'' D, ''SVG_CHART'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''HTML_TEXT'')||'' (''||wwv_flow_lang.system_message(''ESCAPE_SC'')||'')'' D, ''STATIC_TEXT_ESCAPE_SC'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''HTML_TEXT'')||'' (''||wwv_flow_lang.system_message(''WITH_SHORTCUTS'')||'')'' D, ''STATIC_TEXT_WITH_SHORTCUTS'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''SQL_QUERY'')||'' (''||wwv_flow_lang.system_message(''UPDATEABLE_REPORT'')||'')'' D, ''UPDATABLE_SQL_QUERY'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''URL'') D, ''URL'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select upper(wwv_flow_lang.system_message(''TREE'')) D, ''TREE'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''CALENDAR_TYPE'') D, ''CALENDAR'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select wwv_flow_lang.system_message(''CALENDAR_EASY_TYPE'') D, ''EASY_CALENDAR'' R,3 OB from dual'||chr(10)||
' union all'||chr(10)||
'select ''___________________________________________________'' D,''FLOWS_DIVIDER'' R,4 OB from dual'||chr(10)||
' union all'||chr(10)||
'select upper(wwv_flow_lang.system_message(''LIST''))||'': ''||name D, to_char(id) R,5 OB from wwv_flow_lists where flow_id = :FB_FLOW_ID'||chr(10)||
' union all'||chr(10)||
'select upper(wwv_flow_lang.system_message(''MENU''))||'': ''||htf.escape_sc(name) D, ''M''||id R,5 OB'||chr(10)||
'from wwv_flow_menus where flow_id = :fb_flow_id'||chr(10)||
'order by 1)'||chr(10)||
'order by OB');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_sequences
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 20606105200562019.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_SEQUENCES',
  p_lov_query=> 'select htf.escape_sc(sequence_name) a, sequence_name b from sys.dba_sequences '||chr(10)||
'where sequence_owner = :OB_SCHEMA'||chr(10)||
'order by sequence_name'||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_users
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 96930227515507687.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_USERS',
  p_lov_query=> 'declare'||chr(10)||
'  q varchar2(32767) := null;'||chr(10)||
'begin'||chr(10)||
'  if wwv_flow_global.g_xe then'||chr(10)||
'    q:=''select :APP_USER d, :APP_USER r from dual d '';'||chr(10)||
'  else'||chr(10)||
'    q:=''select ''''- ''''|| wwv_flow_lang.system_message(''''ALL_USERS'''')||'''' -'''',''''0'''' from dual '';'||chr(10)||
'    q:=q||''where exists ( '';'||chr(10)||
'    q:=q||''select 1 '';'||chr(10)||
'    q:=q||''from  wwv_flow_developers '';'||chr(10)||
'    q:=q||''where security_group_id = :flow_security_group_id and '';'||chr(10)||
'    q:=q||''      userid = :flow_user and '';'||chr(10)||
'    q:=q||''      instr(developer_role||'''':'''',''''ADMIN:'''') > 0 '';'||chr(10)||
'    q:=q||''union '';'||chr(10)||
'    q:=q||''select 1 '';'||chr(10)||
'    q:=q||''from wwv_flow_fnd_user '';'||chr(10)||
'    q:=q||''where security_group_id = :flow_security_group_id '';'||chr(10)||
'    q:=q||''and user_name = :flow_user '';'||chr(10)||
'    q:=q||''and attribute_01 in (''''ORACLE_ADMIN'''',''''SCHOOL_ADMIN'''',''''TEACHER'''')) '';'||chr(10)||
'    q:=q||''union all '';'||chr(10)||
'    q:=q||''select user_name, user_name '';'||chr(10)||
'    q:=q||''from wwv_flow_fnd_user '';'||chr(10)||
'    q:=q||''where security_group_id = :flow_security_group_id and '';'||chr(10)||
'    q:=q||''      (user_name = :flow_user or exists ( '';'||chr(10)||
'    q:=q||''select 1 '';'||chr(10)||
'    q:=q||''from  wwv_flow_developers '';'||chr(10)||
'    q:=q||''where security_group_id = :flow_security_group_id and '';'||chr(10)||
'    q:=q||''      userid = :flow_user and '';'||chr(10)||
'    q:=q||''      instr(developer_role||'''':'''',''''ADMIN:'''') > 0 '';'||chr(10)||
'    q:=q||''union '';'||chr(10)||
'    q:=q||''select 1 '';'||chr(10)||
'    q:=q||''from wwv_flow_fnd_user '';'||chr(10)||
'    q:=q||''where security_group_id = :flow_security_group_id '';'||chr(10)||
'    q:=q||''and user_name = :flow_user '';'||chr(10)||
'    q:=q||''and attribute_01 in (''''ORACLE_ADMIN'''',''''SCHOOL_ADMIN'''',''''TEACHER''''))) '';'||chr(10)||
'    q:=q||''order by 1 '';'||chr(10)||
'  end if;'||chr(10)||
'  return q;'||chr(10)||
'end;');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/login_message
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 21459801069722432.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LOGIN_MESSAGE',
  p_lov_query=> '.'||to_char(21459801069722432 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21460014390722445.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>21459801069722432.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'메시지 없음',
  p_lov_return_value=>'NONE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>21460423875722448.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>21459801069722432.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'사용자 정의 메시지',
  p_lov_return_value=>'CUSTOM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/manage_table_constraints
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 165911414842182864.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MANAGE.TABLE.CONSTRAINTS',
  p_lov_query=> 'select htf.escape_sc(c.constraint_name) d,  c.constraint_name r'||chr(10)||
'from sys.dba_constraints c, sys.dba_cons_columns l'||chr(10)||
'where c.table_name = :OBJECT_NAME'||chr(10)||
'and c.owner = :OBJECT_OWNER'||chr(10)||
'and c.constraint_type in (''P'',''U'',''C'',''R'')'||chr(10)||
'and c.constraint_name = l.constraint_name '||chr(10)||
'and l.owner = :OBJECT_OWNER'||chr(10)||
'and l.table_name = :OBJECT_NAME'||chr(10)||
'and (l.position = 1 or l.position is null)'||chr(10)||
'and c.status = ''ENABLED'''||chr(10)||
'order by c.constraint_name, c.constraint_type, l.position');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_a
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88005728392276151.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_A',
  p_lov_query=> '.'||to_char(88005728392276151 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88005902539276153.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88005728392276151.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88006132674276154.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88005728392276151.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88006303849276154.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88005728392276151.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88006502528276154.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88005728392276151.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'30',
  p_lov_return_value=>'30',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88006721789276154.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88005728392276151.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88006905692276155.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88005728392276151.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88007113392276155.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88005728392276151.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'200',
  p_lov_return_value=>'200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88007318997276155.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88005728392276151.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88007513744276155.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88005728392276151.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>182328908607767113.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88005728392276151.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5000,
  p_lov_disp_value=>'5000',
  p_lov_return_value=>'5000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>260332524931295254.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88005728392276151.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10000,
  p_lov_disp_value=>'10000',
  p_lov_return_value=>'10000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>260332828394296254.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88005728392276151.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100000,
  p_lov_disp_value=>'100000',
  p_lov_return_value=>'100000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_b
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88008910861280555.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_B',
  p_lov_query=> '.'||to_char(88008910861280555 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183741320426917019.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88008910861280555.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88009125818280556.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88008910861280555.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88009318636280556.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88008910861280555.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88009527364280557.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88008910861280555.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88009708671280557.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88008910861280555.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'30',
  p_lov_return_value=>'30',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88009918679280557.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88008910861280555.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88010107969280558.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88008910861280555.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88010312982280558.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88008910861280555.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'200',
  p_lov_return_value=>'200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88010525571280558.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88008910861280555.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88010713109280558.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88008910861280555.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88010919618280559.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88008910861280555.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'5000',
  p_lov_return_value=>'5000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88011124222280559.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88008910861280555.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'10000',
  p_lov_return_value=>'10000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88011310169280559.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88008910861280555.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'50000',
  p_lov_return_value=>'50000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/more_less_columns
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 161595731562973452.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MORE_LESS_COLUMNS',
  p_lov_query=> '.'||to_char(161595731562973452 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161595917373973455.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>161595731562973452.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'열 추가',
  p_lov_return_value=>'MORE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161596108445973460.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>161595731562973452.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'열 제거',
  p_lov_return_value=>'LESS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/my_job
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88020412686337805.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MY.JOB',
  p_lov_query=> '.'||to_char(88020412686337805 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88020600548337806.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88020412686337805.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'내 작업',
  p_lov_return_value=>'my_job',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/null_notnull
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88038204225524574.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NULL.NOTNULL',
  p_lov_query=> '.'||to_char(88038204225524574 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88038423679524575.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88038204225524574.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'NOT NULL(값 필요)',
  p_lov_return_value=>'NOT NULL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88038631515524575.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88038204225524574.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'NULL(값이 필요하지 않음)',
  p_lov_return_value=>'NULL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/object_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88081132547977521.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'OBJECT.TYPES',
  p_lov_query=> 'select initcap(wwv_flow_lang.system_message(''FUNCTION'')) d, ''98'' r from dual union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''INDEX'')) d, ''INDEX'' r from dual union all     '||chr(10)||
'select initcap(wwv_flow_lang.system_message(''PACKAGE'')) d, ''117'' r from dual union all     '||chr(10)||
'select initcap(wwv_flow_lang.system_message(''PROCEDURE'')) d, ''121'' r from dual union all     '||chr(10)||
'select initcap(wwv_flow_lang.system_message(''SEQUENCE'')) d, ''97'' r from dual union all     '||chr(10)||
'select initcap(wwv_flow_lang.system_message(''SYNONYM'')) d, ''99'' r from dual union all     '||chr(10)||
'select initcap(wwv_flow_lang.system_message(''TABLE'')) d, ''600'' r from dual union all     '||chr(10)||
'select initcap(wwv_flow_lang.system_message(''TRIGGER'')) d, ''TRIGGER'' r from dual union all     '||chr(10)||
'select initcap(wwv_flow_lang.system_message(''VIEW'')) d, ''48'' r from dual'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/object_types_with_images
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 102439908856593264.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'OBJECT.TYPES.WITH.IMAGES',
  p_lov_query=> 'select initcap(wwv_flow_lang.system_message(''FUNCTION''))||''<br /><a style="padding-left:20px;" href="f?p=4500:98:&SESSION.::NO:98,107,100:P81_CREATE_OBJECT_TYPE:98"><img src="#IMAGE_PREFIX#htmldb/builder/funci.gif" width="58" height="38" title="''||initcap(wwv_flow_lang.system_message(''FUNCTION''))||''" alt="''||initcap(wwv_flow_lang.system_message(''FUNCTION''))||''" /></a>'' d, ''98'' r from dual'||chr(10)||
'union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''INDEX''))||''<br /><a style="padding-left:20px;" href="f?p=4500:56:&SESSION.:index:NO:57:P70_ACTION,P81_CREATE_OBJECT_TYPE:INDEX,INDEX"><img src="#IMAGE_PREFIX#htmldb/builder/indexi.gif" width="58" height="38" title="''||initcap(wwv_flow_lang.system_message(''INDEX''))||''" alt="''||initcap(wwv_flow_lang.system_message(''INDEX''))||''" /></a>'' d,''INDEX'' r from dual'||chr(10)||
'union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''PACKAGE''))||''<br /><a style="padding-left:20px;" href="f?p=4500:117:&SESSION.::NO:117,118,119,120:P81_CREATE_OBJECT_TYPE:117"><img src="#IMAGE_PREFIX#htmldb/builder/packagei.gif" width="58" height="38" title="''||initcap(wwv_flow_lang.system_message(''PACKAGE''))||''" alt="''||initcap(wwv_flow_lang.system_message(''PACKAGE''))||''" /></a>'' d,''117'' r from dual'||chr(10)||
'union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''PROCEDURE''))||''<br /><a style="padding-left:20px;" href="f?p=4500:121:&SESSION.::NO:121,122,123:P81_CREATE_OBJECT_TYPE:121"><img src="#IMAGE_PREFIX#htmldb/builder/proci.gif" width="58" height="38" title="''||initcap(wwv_flow_lang.system_message(''PROCEDURE''))||''" alt="''||initcap(wwv_flow_lang.system_message(''PROCEDURE''))||''" /></a>'' d,''121'' r from dual '||chr(10)||
'union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''SEQUENCE''))||''<br /><a style="padding-left:20px;" href="f?p=4500:97:&SESSION.::NO:97:P81_CREATE_OBJECT_TYPE:97"><img src="#IMAGE_PREFIX#htmldb/builder/seqi.gif" width="58" height="38" title="''||initcap(wwv_flow_lang.system_message(''SEQUENCE''))||''" alt="''||initcap(wwv_flow_lang.system_message(''SEQUENCE''))||''" /></a>'' d,''97'' r from dual'||chr(10)||
'union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''SYNONYM''))||''<br /><a style="padding-left:20px;" href="f?p=4500:99:&SESSION.::NO:99:P81_CREATE_OBJECT_TYPE:99"><img src="#IMAGE_PREFIX#htmldb/builder/syni.gif"  width="58" height="38" title="''||initcap(wwv_flow_lang.system_message(''SYNONYM''))||''" alt="''||initcap(wwv_flow_lang.system_message(''SYNONYM''))||''" /></a>'' d,''99'' r from dual'||chr(10)||
'union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''TABLE''))||''<br /><a style="padding-left:20px;" href="f?p=4500:600:&SESSION.::NO:600,602,604,610,612:P81_CREATE_OBJECT_TYPE:600"><img src="#IMAGE_PREFIX#htmldb/builder/tablei.gif" width="58" height="38" title="''||initcap(wwv_flow_lang.system_message(''TABLE''))||''" alt="''||initcap(wwv_flow_lang.system_message(''TABLE''))||''" /></a>'' d,''600'' r from dual'||chr(10)||
'union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''TRIGGER''))||''<br /><a style="padding-left:20px;" href="f?p=4500:56:&SESSION.:triger:NO:57:P70_ACTION,P81_CREATE_OBJECT_TYPE:CREATE_TRIGGER,TRIGGER"><img src="#IMAGE_PREFIX#htmldb/builder/triggi.gif" width="58" height="38" title="''||initcap(wwv_flow_lang.system_message(''TRIGGER''))||''" alt="''||initcap(wwv_flow_lang.system_message(''TRIGGER''))||''" /></a>'' d,''TRIGGER'' r from dual'||chr(10)||
'union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''VIEW''))||''<br /><a style="padding-left:20px;" href="f?p=4500:48:&SESSION.::NO:48:P81_CREATE_OBJECT_TYPE:48"><img src="#IMAGE_PREFIX#htmldb/builder/viewi.gif" width="58" height="38" title="''||initcap(wwv_flow_lang.system_message(''VIEW''))||''" alt="''||initcap(wwv_flow_lang.system_message(''VIEW''))||''" /></a>'' d,''48'' r from dual');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/object_types_with_images2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 161349613017569311.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'OBJECT.TYPES.WITH.IMAGES2',
  p_lov_query=> '.'||to_char(161349613017569311 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161349926473569318.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>161349613017569311.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'함수',
  p_lov_return_value=>'98',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:98:&SESSION.::NO:98,107,100:P81_CREATE_OBJECT_TYPE:98"><img src="#IMAGE_PREFIX#htmldb/builder/function.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161350104339569322.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>161349613017569311.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'인덱스',
  p_lov_return_value=>'INDEX',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:56:&SESSION.:index:NO:57:P70_ACTION,P81_CREATE_OBJECT_TYPE:INDEX,INDEX"><img src="#IMAGE_PREFIX#htmldb/builder/index.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161350313495569322.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>161349613017569311.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'패키지',
  p_lov_return_value=>'117',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:117:&SESSION.::NO:117,118,119,120:P81_CREATE_OBJECT_TYPE:117"><img src="#IMAGE_PREFIX#htmldb/builder/package.gif" width="58" height="38" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161350510273569323.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>161349613017569311.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'프로시저',
  p_lov_return_value=>'121',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:121:&SESSION.::NO:121,122,123:P81_CREATE_OBJECT_TYPE:121"><img src="#IMAGE_PREFIX#htmldb/builder/procedure.gif" width="58" height="38" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161350704929569323.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>161349613017569311.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'시퀀스',
  p_lov_return_value=>'97',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:97:&SESSION.::NO:97:P81_CREATE_OBJECT_TYPE:97"><img src="#IMAGE_PREFIX#htmldb/builder/sequence.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161350927921569323.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>161349613017569311.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'동의어',
  p_lov_return_value=>'99',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:99:&SESSION.::NO:99:P81_CREATE_OBJECT_TYPE:99"><img src="#IMAGE_PREFIX#htmldb/builder/synonym.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161351109256569323.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>161349613017569311.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'테이블',
  p_lov_return_value=>'TABLE_CREATE',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:TABLE_CREATE:&SESSION.::NO:600,602,604,610,612:P81_CREATE_OBJECT_TYPE:600"><img src="#IMAGE_PREFIX#htmldb/builder/table.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161351331481569324.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>161349613017569311.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'트리거',
  p_lov_return_value=>'TRIGGER',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:3:&SESSION.:triger:NO:3::"><img src="#IMAGE_PREFIX#htmldb/builder/trigger.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161351517964569324.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>161349613017569311.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'뷰',
  p_lov_return_value=>'48',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:48:&SESSION.::NO:48:P81_CREATE_OBJECT_TYPE:48"><img src="#IMAGE_PREFIX#htmldb/builder/view.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>161351731977569324.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>161349613017569311.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'데이터베이스 링크',
  p_lov_return_value=>'91',
  p_lov_template=>'#DISPLAY_VALUE#<br /><a style="padding-left:20px;" href="f?p=4500:91:&SESSION.::NO:91:P81_CREATE_OBJECT_TYPE:91"><img src="#IMAGE_PREFIX#htmldb/builder/dblink.gif" width="54" height="43" title="#DISPLAY_VALUE#" alt="#DISPLAY_VALUE#" /></a>',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/object_types2
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88087713200000281.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'OBJECT.TYPES2',
  p_lov_query=> '.'||to_char(88087713200000281 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88087913591000281.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88087713200000281.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'열',
  p_lov_return_value=>'Columns',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88088111508000282.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88087713200000281.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'패키지',
  p_lov_return_value=>'Packages',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88088331361000282.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88087713200000281.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'프로시저/함수',
  p_lov_return_value=>'Procedures/Functions',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/object_types3
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 149192410304386529.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'OBJECT.TYPES3',
  p_lov_query=> '.'||to_char(149192410304386529 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>149192703287386532.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>149192410304386529.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'함수',
  p_lov_return_value=>'FUNCTION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>149192916678386534.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>149192410304386529.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'인덱스',
  p_lov_return_value=>'INDEX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>149193104939386534.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>149192410304386529.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'패키지',
  p_lov_return_value=>'PACKAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>149193312103386534.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>149192410304386529.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'프로시저',
  p_lov_return_value=>'PROCEDURE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>149193514215386535.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>149192410304386529.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'시퀀스',
  p_lov_return_value=>'SEQUENCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>149193711471386535.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>149192410304386529.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'동의어',
  p_lov_return_value=>'SYNONYM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>149193923583386535.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>149192410304386529.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'테이블',
  p_lov_return_value=>'TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>149194128979386535.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>149192410304386529.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'트리거',
  p_lov_return_value=>'TRIGGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>149194306560386535.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>149192410304386529.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'뷰',
  p_lov_return_value=>'VIEW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>106105223193950457.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>149192410304386529.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'데이터베이스 링크',
  p_lov_return_value=>'DATABASE LINK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>109308316213864971.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>149192410304386529.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'유형',
  p_lov_return_value=>'TYPE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>109321428942887516.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>149192410304386529.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>12,
  p_lov_disp_value=>'구체화된 뷰',
  p_lov_return_value=>'MATERIALIZED VIEW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/ob_create_table_handler
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 17956529721028277.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'OB_CREATE_TABLE_HANDLER',
  p_lov_query=> 'select object_name d, object_name r'||chr(10)||
'from sys.dba_objects'||chr(10)||
'where owner = :OB_SCHEMA '||chr(10)||
'and object_type in (''TABLE'')'||chr(10)||
'and object_name not like ''BIN$%'' '||chr(10)||
'and object_name not like ''DR$%'' '||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/ob_cycle
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 276749314239737540.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'OB_CYCLE',
  p_lov_query=> '.'||to_char(276749314239737540 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276749519233737542.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>276749314239737540.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'순환',
  p_lov_return_value=>'CYCLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/ob_grant_privs
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 15818831028847554.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'OB_GRANT_PRIVS',
  p_lov_query=> 'select a,b from ('||chr(10)||
'      select a,b from ( '||chr(10)||
'            select ''DELETE'' a, ''DELETE'' b from dual union all '||chr(10)||
'            select ''INSERT'', ''INSERT'' from dual union all '||chr(10)||
'            select ''UPDATE'', ''UPDATE'' from dual union all '||chr(10)||
'            select ''SELECT'', ''SELECT'' from dual union all '||chr(10)||
'            select ''REFERENCES'',''REFERENCES'' from dual union all '||chr(10)||
'            select ''ON COMMIT REFRESH'',''ON COMMIT REFRESH'' from dual union all '||chr(10)||
'            select ''QUERY REWRITE'',''QUERY REWRITE'' from dual union all '||chr(10)||
'            select ''DEBUG'',''DEBUG'' from dual union all '||chr(10)||
'            select ''FLASHBACK'',''FLASHBACK'' from dual)'||chr(10)||
'        where :OBJECT_TYPE in ( ''VIEW'')'||chr(10)||
'    union all'||chr(10)||
'      select a,b from ( '||chr(10)||
'            select ''ALTER'' a,  ''ALTER'' b from dual union all '||chr(10)||
'            select ''DELETE'', ''DELETE'' from dual union all '||chr(10)||
'            select ''INDEX'',  ''INDEX''  from dual union all '||chr(10)||
'            select ''INSERT'', ''INSERT'' from dual union all '||chr(10)||
'            select ''UPDATE'', ''UPDATE'' from dual union all '||chr(10)||
'            select ''SELECT'', ''SELECT'' from dual union all '||chr(10)||
'            select ''REFERENCES'',''REFERENCES'' from dual union all '||chr(10)||
'            select ''ON COMMIT REFRESH'',''ON COMMIT REFRESH'' from dual union all '||chr(10)||
'            select ''QUERY REWRITE'',''QUERY REWRITE'' from dual union all '||chr(10)||
'            select ''DEBUG'',''DEBUG'' from dual union all '||chr(10)||
'            select ''FLASHBACK'',''FLASHBACK'' from dual)'||chr(10)||
'        where :OBJECT_TYPE in ( ''TABLE'',''MATERIALIZED_VIEW'')'||chr(10)||
'    union all'||chr(10)||
'      select a,b from ( '||chr(10)||
'            select ''EXECUTE'' a,  ''EXECUTE'' b from dual union all '||chr(10)||
'            select ''DEBUG'', ''DEBUG'' from dual )'||chr(10)||
'        where :OBJECT_TYPE in (  ''FUNCTION'',''PROCEDURE'',''TYPE'',''PACKAGE'',''PACKAGE BODY'')'||chr(10)||
'    union all'||chr(10)||
'      select a,b from ( '||chr(10)||
'            select ''ALTER'' a,  ''ALTER'' b from dual union all '||chr(10)||
'            select ''SELECT'', ''SELECT'' from dual )'||chr(10)||
'        where :OBJECT_TYPE in (  ''SEQUENCE''))');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/ob_order
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 276750123935740352.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'OB_ORDER',
  p_lov_query=> '.'||to_char(276750123935740352 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>276750313195740352.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>276750123935740352.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'순서',
  p_lov_return_value=>'ORDER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/on_delete_cascade_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88046110159554703.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ON.DELETE.CASCADE.Y',
  p_lov_query=> '.'||to_char(88046110159554703 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88046324301554704.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88046110159554703.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'계단식 삭제',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/order_by
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88015211732318611.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ORDER.BY',
  p_lov_query=> '.'||to_char(88015211732318611 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88015409187318612.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88015211732318611.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'제목',
  p_lov_return_value=>'title',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88015624432318612.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88015211732318611.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>''||chr(10)||
'파일 이름',
  p_lov_return_value=>'filename',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88015826924318612.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88015211732318611.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>''||chr(10)||
'생성 날짜(오름차순)',
  p_lov_return_value=>'created_on',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88016003779318613.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88015211732318611.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>''||chr(10)||
'생성 날짜(내림차순)',
  p_lov_return_value=>'created_on desc',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88016226006318613.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88015211732318611.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>''||chr(10)||
'생성자',
  p_lov_return_value=>'created_by',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88016402368318613.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88015211732318611.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>''||chr(10)||
'크기(오름차순)',
  p_lov_return_value=>'doc_size',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88016613155318613.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88015211732318611.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>''||chr(10)||
'크기(내림차순)',
  p_lov_return_value=>'doc_size desc',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/output_format
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88012712031290348.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'OUTPUT.FORMAT',
  p_lov_query=> '.'||to_char(88012712031290348 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88012904683290349.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88012712031290348.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'HTML',
  p_lov_return_value=>'HTML',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88013100776290349.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88012712031290348.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Excel',
  p_lov_return_value=>'EXCEL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p1004_show_results
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 179031515879675216.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P1004_SHOW_RESULTS',
  p_lov_query=> '.'||to_char(179031515879675216 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>179031709094675217.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>179031515879675216.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'결과 표시',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p101_columns
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 150992731358804903.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P101_COLUMNS',
  p_lov_query=> 'select htf.escape_sc(t.column_name)||'' - ''||lower(t.data_type) d, '||chr(10)||
'       t.column_name r'||chr(10)||
'from   sys.dba_tab_columns t'||chr(10)||
'where              '||chr(10)||
'      t.table_name = :P101_TABLE_NAME'||chr(10)||
'  and t.owner = :P101_TABLE_OWNER and'||chr(10)||
'      (nvl(:P101_SHOW,''1'') = ''1'' or t.data_type in (''VARCHAR'',''VARCHAR2''))'||chr(10)||
'order by t.column_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p1220_script_files
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 12563519145254272.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P1220_SCRIPT_FILES',
  p_lov_query=> 'select distinct f.filename, f.id'||chr(10)||
'from wwv_flow_files f, wwv_flow_sw_results r'||chr(10)||
'where f.id = r.file_id '||chr(10)||
'and f.file_type = ''SCRIPT'''||chr(10)||
'and (nvl(:P1220_SHOW,''0'') = ''0'' or run_by = :P1220_SHOW)'||chr(10)||
'order by f.filename');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p1301_session_opts
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 26561807054435939.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P1301_SESSION_OPTS',
  p_lov_query=> '.'||to_char(26561807054435939 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26562005235435939.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>26561807054435939.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'모두',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26562200440435942.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>26561807054435939.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'성공한 세션',
  p_lov_return_value=>'SUC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26562427473435942.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>26561807054435939.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'실패한 세션',
  p_lov_return_value=>'FAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p1302_sesopt
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 26247521414208435.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P1302_SESOPT',
  p_lov_query=> '.'||to_char(26247521414208435 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26247711140208437.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>26247521414208435.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'모두',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26247917746208441.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>26247521414208435.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'성공한 로그인',
  p_lov_return_value=>'SUC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>26248104479208441.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>26247521414208435.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'실패한 로그인',
  p_lov_return_value=>'FAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p2610_users
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 20110029824731114.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P2610_USERS',
  p_lov_query=> '.'||to_char(20110029824731114 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20110203670731120.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>20110029824731114.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'모든 스키마',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20110423350731122.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>20110029824731114.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'내부 스키마',
  p_lov_return_value=>'INTERNAL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20110606356731122.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>20110029824731114.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'데이터베이스 스키마',
  p_lov_return_value=>'USER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p2613_locked_unlocked
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 1493723866781789.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P2613_LOCKED_UNLOCKED',
  p_lov_query=> '.'||to_char(1493723866781789 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1493913666781840.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1493723866781789.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'잠김',
  p_lov_return_value=>'LOCK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1494107328781852.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1493723866781789.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'잠금 해제됨',
  p_lov_return_value=>'UNLOCK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p36_display_options
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 998111353442494.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P36_DISPLAY_OPTIONS',
  p_lov_query=> '.'||to_char(998111353442494 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>998325750442498.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>998111353442494.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'버전',
  p_lov_return_value=>'VERSION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>998523049442499.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>998111353442494.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'설정',
  p_lov_return_value=>'DATABASE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>998704170442500.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>998111353442494.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'옵션',
  p_lov_return_value=>'OPTIONS',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>999130596442500.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>998111353442494.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'국가별 언어 지원',
  p_lov_return_value=>'NLS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>999327277442500.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>998111353442494.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'CGI 환경',
  p_lov_return_value=>'CGI',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>5615222230694443.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>998111353442494.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'매개변수',
  p_lov_return_value=>'PARAMETER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p40_interval
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 174631600082053227.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P40_INTERVAL',
  p_lov_query=> 'select initcap(wwv_flow_lang.system_message(''LAST''))||'' ''   ||initcap(wwv_flow_lang.system_message(''YEAR'')) d, 365 r from dual union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 31 ''||initcap(wwv_flow_lang.system_message(''DAYS'')) d, 31 r from dual union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 48 ''||initcap(wwv_flow_lang.system_message(''HOURS'')) d, 2 r from dual union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 24 ''||initcap(wwv_flow_lang.system_message(''HOURS'')) d, 1 r from dual union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 8 '' ||initcap(wwv_flow_lang.system_message(''HOURS'')) d, 8/24 r from dual union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 6 '' ||initcap(wwv_flow_lang.system_message(''HOURS'')) d, 6/24 r from dual union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 4 '' ||initcap(wwv_flow_lang.system_message(''HOURS'')) d, 4/24 r from dual union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 2 '' ||initcap(wwv_flow_lang.system_message(''HOURS'')) d, 2/24 r from dual union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' ''   ||initcap(wwv_flow_lang.system_message(''HOUR'')) d, 1/24 r from dual union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 30 ''||initcap(wwv_flow_lang.system_message(''MINUTES'')) d, 30/(24*60) r from dual union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 10 ''||initcap(wwv_flow_lang.system_message(''MINUTES'')) d, 10/(24*60) r from dual union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 5 '' ||initcap(wwv_flow_lang.system_message(''MINUTES'')) d, 5/(24*60) r from dual union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' ''   ||initcap(wwv_flow_lang.system_message(''MINUTE'')) d, 1/(24*60) r from dual union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 10 ''||initcap(wwv_flow_lang.system_message(''SECONDS'')) d, 10* (1/(24*60*60)) r from dual union all'||chr(10)||
'select initcap(wwv_flow_lang.system_message(''LAST''))||'' 5 '' ||initcap(wwv_flow_lang.system_message(''SECONDS'')) d, 5* (1/(24*60*60)) r from dual'||chr(10)||
'order by 2 desc');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p42_order_columns
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 148760022603009971.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P42.ORDER.COLUMNS',
  p_lov_query=> 'select htf.escape_sc(column_name) d, column_name v from sys.dba_tab_columns where owner = :F4500_P42_OBJECT_OWNER and table_name = :F4500_P42_OBJECT_NAME order by column_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p64_obj_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 27925820885518618.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P64_OBJ_TYPES',
  p_lov_query=> '.'||to_char(27925820885518618 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27926020563518626.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>27925820885518618.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'애플리케이션',
  p_lov_return_value=>'APPLICATION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27926230018518634.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>27925820885518618.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'CSS 익스포트',
  p_lov_return_value=>'CSS_EXPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27926402670518634.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>27925820885518618.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'애플리케이션 익스포트',
  p_lov_return_value=>'FLOW_EXPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27926614786518636.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>27925820885518618.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'스크립트',
  p_lov_return_value=>'SCRIPT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27926803274518636.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>27925820885518618.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'스크립트 파일 익스포트',
  p_lov_return_value=>'SCRIPT_FILE_EXPORT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27927031603518636.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>27925820885518618.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'테마',
  p_lov_return_value=>'THEME',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27927219004518642.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>27925820885518618.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'정적 파일',
  p_lov_return_value=>'STATIC FILE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p71_columns
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 174553601832855016.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P71_COLUMNS',
  p_lov_query=> 'select htf.escape_sc(COLUMN_NAME)||'' (''||data_type||'')'' d,  column_name r'||chr(10)||
'from sys.dba_tab_columns'||chr(10)||
'where owner =  :OBJECT_OWNER'||chr(10)||
' and table_name= :OBJECT_NAME'||chr(10)||
'order by column_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p76_columns
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 174520707223695721.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P76_COLUMNS',
  p_lov_query=> 'select htf.escape_sc(COLUMN_NAME)||'' (''||data_type||'')'' d,  column_name r'||chr(10)||
'from sys.dba_tab_columns'||chr(10)||
'where owner =  :OBJECT_OWNER and'||chr(10)||
'table_name= :OBJECT_NAME'||chr(10)||
'order by column_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p82_constraints
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 174431027591821617.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P82_CONSTRAINTS',
  p_lov_query=> 'select htf.escape_sc(c.constraint_name) d,  c.constraint_name r'||chr(10)||
'from sys.dba_constraints c, sys.dba_cons_columns l'||chr(10)||
'where c.table_name = :OBJECT_NAME'||chr(10)||
'and c.owner = :OBJECT_OWNER'||chr(10)||
'and c.constraint_type in (''P'',''U'',''C'',''R'')'||chr(10)||
'and c.constraint_name = l.constraint_name '||chr(10)||
'and l.owner = :OBJECT_OWNER'||chr(10)||
'and l.table_name = :OBJECT_NAME'||chr(10)||
'and c.status = ''DISABLED'''||chr(10)||
'order by c.constraint_name, c.constraint_type, l.position');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p86_triggers
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 174475310182109956.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P86_TRIGGERS',
  p_lov_query=> 'select htf.escape_sc(t.trigger_name)||'' (''||t.status||'')'' d, t.trigger_name r'||chr(10)||
'from sys.dba_triggers t'||chr(10)||
'where t.table_name = :OBJECT_NAME '||chr(10)||
'and t.table_owner = :OBJECT_OWNER'||chr(10)||
'order by t.trigger_name');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pk_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 20561306137429854.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PK_TYPES',
  p_lov_query=> '.'||to_char(20561306137429854 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>29761700718146891.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>20561306137429854.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'기본 키 없음',
  p_lov_return_value=>'NONE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20561825857429898.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>20561306137429854.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'새 시퀀스에서 채워짐',
  p_lov_return_value=>'NEW_SEQUENCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20562003984429898.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>20561306137429854.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'기존 시퀀스에서 채워짐',
  p_lov_return_value=>'EXISTING_SEQUENCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20561603688429893.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>20561306137429854.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'채워지지 않음',
  p_lov_return_value=>'NOT_GENERATED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/pl_sql_object_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 9486017492391468.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PL/SQL OBJECT TYPES',
  p_lov_query=> '.'||to_char(9486017492391468 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9486202458391470.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>9486017492391468.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'프로시저',
  p_lov_return_value=>'PROCEDURE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9486430806391474.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>9486017492391468.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'함수',
  p_lov_return_value=>'FUNCTION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9486609421391475.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>9486017492391468.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'패키지',
  p_lov_return_value=>'PACKAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9486818320391475.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>9486017492391468.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'패키지 본문',
  p_lov_return_value=>'PACKAGE BODY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>9487009618391475.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>9486017492391468.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'트리거',
  p_lov_return_value=>'TRIGGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/preserve_case_y
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88034811582507798.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRESERVE.CASE.Y',
  p_lov_query=> '.'||to_char(88034811582507798 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88035027142507799.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88034811582507798.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'대소문자 유지',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/privileges_table_show
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 8935311761146039.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PRIVILEGES.TABLE.SHOW',
  p_lov_query=> '.'||to_char(8935311761146039 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8935521709146041.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>8935311761146039.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'선택한 스키마에 권한 부여',
  p_lov_return_value=>'TO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8935711543146043.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>8935311761146039.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'선택한 스키마에서 권한 부여',
  p_lov_return_value=>'FROM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8935913844146043.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>8935311761146039.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'모두',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/public_private
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88067712358839197.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PUBLIC.PRIVATE',
  p_lov_query=> '.'||to_char(88067712358839197 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88067900572839197.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88067712358839197.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'전용',
  p_lov_return_value=>'PRIVATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88068127252839198.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88067712358839197.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'공용',
  p_lov_return_value=>'PUBLIC',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/query_builder_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 2308814912225605.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'QUERY_BUILDER_TYPE',
  p_lov_query=> '.'||to_char(2308814912225605 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2309026164225610.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>2308814912225605.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'전용',
  p_lov_return_value=>'P',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2309221064225612.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>2308814912225605.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'공용',
  p_lov_return_value=>'R',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>2309411169225612.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>2308814912225605.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'공용 읽기/쓰기',
  p_lov_return_value=>'W',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/query_owners
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 3358317445244033.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'QUERY_OWNERS',
  p_lov_query=> 'declare'||chr(10)||
'  q varchar2(32767) := null;'||chr(10)||
'begin'||chr(10)||
'  if wwv_flow_global.g_xe then'||chr(10)||
'    q:=''select v(''''APP_USER'''') D, v(''''APP_USER'''') R from dual '';'||chr(10)||
'  else'||chr(10)||
'    q:=''SELECT D,R FROM ( '';'||chr(10)||
'    q:=q||''select htf.escape_sc(created_by) d, created_by r '';'||chr(10)||
'    q:=q||''from   WWV_FLOW_QB_SAVED_QUERY '';'||chr(10)||
'    q:=q||''where security_group_id = :FLOW_SECURITY_GROUP_ID '';'||chr(10)||
'    q:=q||''and exists ( '';    '||chr(10)||
'    q:=q||''select 1 '';'||chr(10)||
'    q:=q||''from  wwv_flow_developers '';'||chr(10)||
'    q:=q||''where security_group_id = :flow_security_group_id and '';'||chr(10)||
'    q:=q||''      userid = :flow_user and '';'||chr(10)||
'    q:=q||''      instr(developer_role||'''':'''',''''ADMIN:'''') > 0 '';'||chr(10)||
'    q:=q||''union '';'||chr(10)||
'    q:=q||''select 1 '';'||chr(10)||
'    q:=q||''from wwv_flow_fnd_user '';'||chr(10)||
'    q:=q||''where security_group_id = :flow_security_group_id '';'||chr(10)||
'    q:=q||''and user_name = :flow_user '';'||chr(10)||
'    q:=q||''and attribute_01 in (''''ORACLE_ADMIN'''',''''SCHOOL_ADMIN'''',''''TEACHER'''')) '';'||chr(10)||
'    q:=q||''union all  '';'||chr(10)||
'    q:=q||''select v(''''APP_USER'''') D, v(''''APP_USER'''') R '';'||chr(10)||
'    q:=q||''FROM DUAL) '';'||chr(10)||
'    q:=q||''group by D,R '';'||chr(10)||
'  end if;  '||chr(10)||
'  return q;'||chr(10)||
'end;');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/quota_size
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 1589203900827893.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'QUOTA SIZE',
  p_lov_query=> '.'||to_char(1589203900827893 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1589405753827932.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1589203900827893.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'0',
  p_lov_return_value=>'NONE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1589832194827937.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1589203900827893.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'값(MB)',
  p_lov_return_value=>'VALUE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1589631060827937.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1589203900827893.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'무제한',
  p_lov_return_value=>'UNLIMITED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/recycle_bin_object_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 165057106281786448.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'RECYCLE BIN OBJECT TYPES',
  p_lov_query=> '.'||to_char(165057106281786448 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>165057400753786453.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>165057106281786448.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'인덱스',
  p_lov_return_value=>'INDEX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>165057605335786456.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>165057106281786448.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'테이블',
  p_lov_return_value=>'TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>165057800969786457.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>165057106281786448.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'트리거',
  p_lov_return_value=>'TRIGGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/row_select
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88095631994062466.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ROW.SELECT',
  p_lov_query=> '.'||to_char(88095631994062466 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88095810522062467.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88095631994062466.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'모든 행',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88096011165062467.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88095631994062466.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'선택된 행',
  p_lov_return_value=>'SELECTED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88096206304062468.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88095631994062466.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'행 없음',
  p_lov_return_value=>'NONE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/rows_percent
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88059704693808617.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ROWS.PERCENT',
  p_lov_query=> '.'||to_char(88059704693808617 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88059901028808618.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88059704693808617.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'비율',
  p_lov_return_value=>'percent',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88060116147808618.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88059704693808617.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'행',
  p_lov_return_value=>'rows',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/schema_compare_categories
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 14728126072025797.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SCHEMA COMPARE CATEGORIES',
  p_lov_query=> '.'||to_char(14728126072025797 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14728314552025797.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14728126072025797.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'열 이름',
  p_lov_return_value=>'COLUMN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14728532416025797.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14728126072025797.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'테이블',
  p_lov_return_value=>'TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14728710300025797.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14728126072025797.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'열 데이터 유형',
  p_lov_return_value=>'DATATYPE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14839906156999563.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14728126072025797.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'인덱스',
  p_lov_return_value=>'INDEX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14877305584283250.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14728126072025797.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'함수',
  p_lov_return_value=>'FUNCTION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14929828730535894.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14728126072025797.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'시퀀스',
  p_lov_return_value=>'SEQUENCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14932013409550455.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14728126072025797.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'트리거',
  p_lov_return_value=>'TRIGGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16908630581731543.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14728126072025797.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'패키지',
  p_lov_return_value=>'PACKAGE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16908901622732667.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14728126072025797.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'패키지 본문',
  p_lov_return_value=>'PACKAGE BODY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16909205432733687.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14728126072025797.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'프로시저',
  p_lov_return_value=>'PROCEDURE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16909507509734338.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14728126072025797.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'유형',
  p_lov_return_value=>'TYPE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>77467331623506913.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14728126072025797.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'뷰',
  p_lov_return_value=>'VIEW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/script_output_view_mode
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 11936228645031897.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SCRIPT_OUTPUT_VIEW_MODE',
  p_lov_query=> '.'||to_char(11936228645031897 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>11936413744031900.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>11936228645031897.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'명령문',
  p_lov_return_value=>'STMT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>12078021672086769.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>11936228645031897.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'결과',
  p_lov_return_value=>'RESULTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>11936610007031901.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>11936228645031897.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'피드백',
  p_lov_return_value=>'MSG',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/script_result_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 16851103836270043.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SCRIPT_RESULT_STATUS',
  p_lov_query=> '.'||to_char(16851103836270043 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16851311853270045.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16851103836270043.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'제출 날짜',
  p_lov_return_value=>'SUBMITTED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16851527617270045.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16851103836270043.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'실행 중',
  p_lov_return_value=>'EXECUTING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16851718446270046.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16851103836270043.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'완료',
  p_lov_return_value=>'COMPLETE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16851904138270047.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16851103836270043.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'취소됨',
  p_lov_return_value=>'CANCELED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/search_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 246393217654948737.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SEARCH_TYPE',
  p_lov_query=> '.'||to_char(246393217654948737 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>246393407696948737.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>246393217654948737.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'대소문자 구분',
  p_lov_return_value=>'CASE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>246393625694948737.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>246393217654948737.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'단어 단위로',
  p_lov_return_value=>'WHOLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>246393810673948738.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>246393217654948737.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'정규 표현식 일치',
  p_lov_return_value=>'REGEX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/session_monitoring_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 159923116388036162.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SESSION MONITORING STATUS',
  p_lov_query=> '.'||to_char(159923116388036162 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>159923408566036193.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>159923116388036162.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'모두',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>159923619966036211.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>159923116388036162.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'활성',
  p_lov_return_value=>'ACTIVE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/sga_target_lov
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 1417526170798303.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SGA_TARGET_LOV',
  p_lov_query=> '.'||to_char(1417526170798303 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1417704549798326.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1417526170798303.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'64',
  p_lov_return_value=>'64M',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1417915382798336.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1417526170798303.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'128',
  p_lov_return_value=>'128M',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1418109764798336.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1417526170798303.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'192',
  p_lov_return_value=>'192M',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1418312463798336.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1417526170798303.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'256',
  p_lov_return_value=>'256M',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1418503267798338.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1417526170798303.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'320',
  p_lov_return_value=>'320M',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1418716837798338.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1417526170798303.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'384',
  p_lov_return_value=>'384M',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1418915626798339.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1417526170798303.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'448',
  p_lov_return_value=>'448M',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>1419122341798339.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>1417526170798303.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'512',
  p_lov_return_value=>'512M',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/show_details_checkbox
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 20435801528491678.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SHOW DETAILS CHECKBOX',
  p_lov_query=> '.'||to_char(20435801528491678 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>20436019847491679.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>20435801528491678.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'세부 정보 표시',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/show_difference_only_checkbox
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 14974704196733524.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SHOW DIFFERENCE ONLY CHECKBOX',
  p_lov_query=> '.'||to_char(14974704196733524 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>14974921191733525.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>14974704196733524.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'차이만 표시',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/show_tables_with_and_without_comments
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 8639918272273372.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SHOW TABLES WITH AND WITHOUT COMMENTS',
  p_lov_query=> '.'||to_char(8639918272273372 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8640124542273376.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>8639918272273372.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'설명이 있는 테이블',
  p_lov_return_value=>'WITH',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8640331660273378.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>8639918272273372.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'설명이 없는 테이블',
  p_lov_return_value=>'WITHOUT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>8640518874273378.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>8639918272273372.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'모든 테이블',
  p_lov_return_value=>'ALL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/show_hide_y_n
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88026529019446655.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SHOW.HIDE.Y.N',
  p_lov_query=> '.'||to_char(88026529019446655 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88026728054446655.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88026529019446655.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'표시',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88026921198446656.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88026529019446655.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'숨기기',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/sid_service
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 270736905720819349.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SID_SERVICE',
  p_lov_query=> '.'||to_char(270736905720819349 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>270737132068819350.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>270736905720819349.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'서비스 이름',
  p_lov_return_value=>'SERVICE_NAME',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>270737303121819350.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>270736905720819349.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'SID',
  p_lov_return_value=>'SID',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/sql_script_result_view_mode
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 164092723800780852.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SQL SCRIPT RESULT VIEW MODE',
  p_lov_query=> '.'||to_char(164092723800780852 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>164092906932780860.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>164092723800780852.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'요약',
  p_lov_return_value=>'SUMMARY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>164093123083780865.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>164092723800780852.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'세부 정보',
  p_lov_return_value=>'DETAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/sql_filetype
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88033203570477156.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SQL.FILETYPE',
  p_lov_query=> '.'||to_char(88033203570477156 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88033427813477157.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88033203570477156.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'스크립트 파일(*.sql)',
  p_lov_return_value=>'sql',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/sql_txt_filetype
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88078901941959255.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SQL.TXT.FILETYPE',
  p_lov_query=> '.'||to_char(88078901941959255 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88079103923959257.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88078901941959255.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'텍스트 파일(*.txt)',
  p_lov_return_value=>'txt',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88079307836959257.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88078901941959255.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'스크립트 파일(*.sql)',
  p_lov_return_value=>'sql',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/system_privileges
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SYSTEM PRIVILEGES',
  p_lov_query=> '.'||to_char(25560713417668203 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25560932733668206.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE VIEW',
  p_lov_return_value=>'CREATE VIEW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25561118325668208.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE PROCEDURE',
  p_lov_return_value=>'CREATE PROCEDURE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25561329462668208.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE SYNONYM',
  p_lov_return_value=>'CREATE SYNONYM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25561509484668208.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE TABLE',
  p_lov_return_value=>'CREATE TABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25561703573668209.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE INDEXTYPE',
  p_lov_return_value=>'CREATE INDEXTYPE',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25561918387668209.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE SEQUENCE',
  p_lov_return_value=>'CREATE SEQUENCE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25562101316668209.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE DATABASE LINK',
  p_lov_return_value=>'CREATE DATABASE LINK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25562309219668209.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE TYPE',
  p_lov_return_value=>'CREATE TYPE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25562510373668210.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE MATERIALIZED VIEW',
  p_lov_return_value=>'CREATE MATERIALIZED VIEW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25562725532668210.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE CLUSTER',
  p_lov_return_value=>'CREATE CLUSTER',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25562915030668210.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE TRIGGER',
  p_lov_return_value=>'CREATE TRIGGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25563105054668210.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE OPERATOR',
  p_lov_return_value=>'CREATE OPERATOR',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25563322062668210.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE LIBRARY',
  p_lov_return_value=>'CREATE LIBRARY',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25563526933668211.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE DIMENSION',
  p_lov_return_value=>'CREATE DIMENSION',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25563701512668211.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE JOB',
  p_lov_return_value=>'CREATE JOB',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25563918014668211.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE PROFILE',
  p_lov_return_value=>'CREATE PROFILE',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25564128815668211.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE PUBLIC DATABASE LINK',
  p_lov_return_value=>'CREATE PUBLIC DATABASE LINK',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25564332270668211.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE PUBLIC SYNONYM',
  p_lov_return_value=>'CREATE PUBLIC SYNONYM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25564509385668212.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE ROLE',
  p_lov_return_value=>'CREATE ROLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25564707743668213.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE ROLLBACK SEGMENT',
  p_lov_return_value=>'CREATE ROLLBACK SEGMENT',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25564902366668213.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE RULE',
  p_lov_return_value=>'CREATE RULE',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25565120530668213.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE RULE SET',
  p_lov_return_value=>'CREATE RULE SET',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25565300473668214.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE SESSION',
  p_lov_return_value=>'CREATE SESSION',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25565512486668214.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE TABLESPACE',
  p_lov_return_value=>'CREATE TABLESPACE',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25565717929668214.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>25560713417668203.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'CREATE USER',
  p_lov_return_value=>'CREATE USER',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/table_children
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 3694131248687844.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TABLE_CHILDREN',
  p_lov_query=> 'select d,r from ('||chr(10)||
' select wwv_flow_lang.system_message(''4500_1002_QB_JOIN'')||'||chr(10)||
''' ''||htf.escape_sc(p.column_name)||'||chr(10)||
''' ''||wwv_flow_lang.system_message(''4500_1002_QB_TO'')||'||chr(10)||
''' ''||htf.escape_sc(t.cn)||''.''||htf.escape_sc(c.column_name) d , t.object_id||''|''||c.column_name||''|''||p.column_name r '||chr(10)||
' from sys.dba_cons_columns c, '||chr(10)||
' 	  sys.dba_cons_columns p,'||chr(10)||
'	  ( SELECT p.table_name pn, p.constraint_name pc, c.table_name cn , c.constraint_name cc ,o.object_id ,o.object_name'||chr(10)||
'	    FROM sys.dba_constraints p, sys.dba_constraints c , sys.dba_objects o '||chr(10)||
'	    WHERE (p.constraint_type = ''P'' OR p.constraint_type = ''U'') '||chr(10)||
'		AND c.constraint_type = ''R'' '||chr(10)||
'		AND p.constraint_name = c.r_constraint_name '||chr(10)||
'		AND p.table_name = UPPER(:P59_TNAME) '||chr(10)||
'		and p.owner = :P59_SCHEMA'||chr(10)||
'		and o.object_name = c.table_name'||chr(10)||
'		and o.owner = p.owner'||chr(10)||
'                and p.owner = c.owner) t'||chr(10)||
'where t.cc = c.constraint_name'||chr(10)||
'and t.pc = p.constraint_name'||chr(10)||
'and c.owner = :P59_SCHEMA'||chr(10)||
'and p.owner = c.owner '||chr(10)||
')');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/table_columns
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 502208967145746.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TABLE_COLUMNS',
  p_lov_query=> 'select htf.escape_sc(cc.table_name) ||''(''||htf.escape_sc(cc.column_name)||'')'' d,'||chr(10)||
''||chr(10)||
'       cc.table_name ||''(''||cc.column_name||'')'' r'||chr(10)||
''||chr(10)||
'  from sys.dba_cons_columns cc,sys.dba_constraints cs'||chr(10)||
''||chr(10)||
' where cs.constraint_name = cc.constraint_name'||chr(10)||
''||chr(10)||
'   and (cs.constraint_type =''R'''||chr(10)||
''||chr(10)||
'        OR'||chr(10)||
''||chr(10)||
'        cs.constraint_type =''U'')'||chr(10)||
''||chr(10)||
'   and cs.owner = :F4000_P600_SCHEMAS'||chr(10)||
''||chr(10)||
' order by cc.table_name,cc.position');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/table_parents
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 3693427654677337.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TABLE_PARENTS',
  p_lov_query=> 'select d,r from ('||chr(10)||
' select wwv_flow_lang.system_message(''4500_1002_QB_JOIN'')||'||chr(10)||
' '' ''||htf.escape_sc(c.column_name)||'' ''||wwv_flow_lang.system_message(''4500_1002_QB_TO'')||'||chr(10)||
' '' ''||htf.escape_sc(t.pn)||''.''||htf.escape_sc(p.column_name) d , t.object_id||''|''||p.column_name||''|''||c.column_name r '||chr(10)||
' from sys.dba_cons_columns c, '||chr(10)||
' 	  sys.dba_cons_columns p,'||chr(10)||
'	  ( SELECT p.table_name pn, p.constraint_name pc, c.table_name cn , c.constraint_name cc ,o.object_id ,o.object_name'||chr(10)||
'	    FROM sys.dba_constraints p, sys.dba_constraints c , sys.dba_objects o '||chr(10)||
'	    WHERE (p.constraint_type = ''P'' OR p.constraint_type = ''U'') '||chr(10)||
'		AND c.constraint_type = ''R'' '||chr(10)||
'		AND p.constraint_name = c.r_constraint_name '||chr(10)||
'		AND c.table_name = UPPER(:P59_TNAME) '||chr(10)||
'		and p.owner = :P59_SCHEMA'||chr(10)||
'		and o.object_name = p.table_name'||chr(10)||
'		and o.owner = p.owner'||chr(10)||
'                and p.owner = c.owner) t'||chr(10)||
'where t.cc = c.constraint_name'||chr(10)||
'and t.pc = p.constraint_name'||chr(10)||
'and c.owner = :P59_SCHEMA'||chr(10)||
'and p.owner = c.owner '||chr(10)||
')'||chr(10)||
'');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/top_sql_by
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 236910808625037522.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TOP_SQL_BY',
  p_lov_query=> '.'||to_char(236910808625037522 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>236911029447037524.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>236910808625037522.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'CPU 시간',
  p_lov_return_value=>'CPU_TIME',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>236911210865037524.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>236910808625037522.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'디스크 읽기',
  p_lov_return_value=>'DISK_READS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>236911407417037525.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>236910808625037522.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'실행',
  p_lov_return_value=>'EXECUTIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>236911618778037525.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>236910808625037522.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'버퍼 가져오기',
  p_lov_return_value=>'BUFFER_GETS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>236911815989037525.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>236910808625037522.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'버퍼 가져오기/처리된 행',
  p_lov_return_value=>'EFFICIENCY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>236912011147037525.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>236910808625037522.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'버퍼 가져오기/실행',
  p_lov_return_value=>'EFFICIENCY2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/type_available
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 16945125859541385.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TYPE_AVAILABLE',
  p_lov_query=> 'select htf.escape_sc(type_name) d, type_name r from sys.dba_types where owner = :OB_SCHEMA');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/type_collection_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 16529130513602905.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TYPE_COLLECTION_TYPE',
  p_lov_query=> '.'||to_char(16529130513602905 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16529302646602905.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16529130513602905.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'VArray',
  p_lov_return_value=>'V',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16529528167602906.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16529130513602905.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'중첩 테이블',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/type_data_types
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TYPE_DATA_TYPES',
  p_lov_query=> '.'||to_char(16534820904659665 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16535002611659667.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'BFILE',
  p_lov_return_value=>'BFILE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16535213310659667.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'BLOB',
  p_lov_return_value=>'BLOB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16535418281659667.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'CHAR',
  p_lov_return_value=>'CHAR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16535626402659668.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'CLOB',
  p_lov_return_value=>'CLOB',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16535817963659668.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'DATE',
  p_lov_return_value=>'DATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16536022932659668.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'DECIMAL',
  p_lov_return_value=>'DECIMAL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16536213254659668.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'DOUBLE PRECISION',
  p_lov_return_value=>'DOUBLE PRECISION',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16536400283659668.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'FLOAT',
  p_lov_return_value=>'FLOAT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16536606880659669.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'INTEGER',
  p_lov_return_value=>'INTEGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16536824560659669.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'NUMBER',
  p_lov_return_value=>'NUMBER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16547232731688790.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'REAL',
  p_lov_return_value=>'REAL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16547507582690914.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'SMALLINT',
  p_lov_return_value=>'SMALLINT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16547811738692161.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'RAW',
  p_lov_return_value=>'RAW',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16548116240693431.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'VARCHAR2',
  p_lov_return_value=>'VARCHAR2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16548420395694645.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'REF',
  p_lov_return_value=>'REF',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16548730785697678.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16534820904659665.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'< 중첩된 객체 >',
  p_lov_return_value=>'NEST',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/type_of_type
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 16521502229452853.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TYPE_OF_TYPE',
  p_lov_query=> '.'||to_char(16521502229452853 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16521731440452856.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16521502229452853.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'콜렉션 유형',
  p_lov_return_value=>'C',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>16521925201452858.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>16521502229452853.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'객체 유형',
  p_lov_return_value=>'O',
  p_lov_disp_cond_type=>'NEVER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/unique
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88045300809552005.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'UNIQUE',
  p_lov_query=> '.'||to_char(88045300809552005 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88045530124552006.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88045300809552005.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'고유',
  p_lov_return_value=>'UNIQUE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/unix_dos
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88081812938981328.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'UNIX.DOS',
  p_lov_query=> '.'||to_char(88081812938981328 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88082021798981329.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88081812938981328.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'DOS',
  p_lov_return_value=>'DOS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88082214036981329.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88081812938981328.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'UNIX',
  p_lov_return_value=>'UNIX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/view_detail_summary
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 183733207435875441.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'VIEW_DETAIL_SUMMARY',
  p_lov_query=> '.'||to_char(183733207435875441 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183733411221875446.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>183733207435875441.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'세부 정보',
  p_lov_return_value=>'DETAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>183733609162875449.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>183733207435875441.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'요약',
  p_lov_return_value=>'SUMMARY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/y_n_returns_y_n
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88037119678519608.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'Y.N.RETURNS.Y.N',
  p_lov_query=> '.'||to_char(88037119678519608 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88037301694519609.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88037119678519608.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'예',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88037513209519609.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88037119678519608.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'아니오',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/yes_no_returns_y_n
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 23482928300634173.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'YES.NO.RETURNS.Y.N',
  p_lov_query=> '.'||to_char(23482928300634173 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23483215241634177.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>23482928300634173.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'예',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>23483425275634179.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>23482928300634173.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'아니오',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/yes_checkbox
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 270681628960428645.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'YES_CHECKBOX',
  p_lov_query=> '.'||to_char(270681628960428645 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>270681822685428648.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>270681628960428645.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'예',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/y_noprompt
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88018003898325845.4508 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'Y_NOPROMPT',
  p_lov_query=> '.'||to_char(88018003898325845 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>88018226427325846.4508 + wwv_flow_api.g_id_offset,
  p_lov_id=>88018003898325845.4508 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'&nbsp;'||chr(10)||
''||chr(10)||
'',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

 
--application/pages/page_.4508
prompt  ...PAGE .4508: 0
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => .4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '0',
  p_step_title=> '0',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 975420526780140.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164218',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'1125402729460390';

wwv_flow_api.create_page_plug (
  p_id=> 1376814380580244.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4508,
  p_plug_name=> 'New Tabs',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_07',
  p_plug_source=> s,
  p_plug_source_type=> 1125402729460390 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 11140505307196687.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4508,
  p_plug_name=> 'Global Items For Object Browser',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 9999,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>11141129549203626.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> .4508,
  p_name=>'OB_OBJECT_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 11140505307196687.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>11143605700225196.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> .4508,
  p_name=>'P0_PPRTIMESTAMP',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 11140505307196687.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page .4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_1.450
prompt  ...PAGE 1.4508: 데이터베이스 관리자 로그인
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_roles.htm';

ph:=ph||'<style>'||chr(10)||
'#P1_USERNAME ,#P1_PASSWORD{width:200px;}'||chr(10)||
'</style>';

wwv_flow_api.create_page(
  p_id     => 1.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '데이터베이스 관리자 로그인',
  p_step_title=> '데이터베이스 관리자 로그인',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => 'OFF',
  p_group_id => 206250111084432914+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164218',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>1.4508,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>1.4508,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 1043922209309492.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4508,
  p_plug_name=> '데이터베이스 관리자 로그인',
  p_region_name=>'',
  p_plug_template=> 14581217810376674.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 3,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 20465925738554202.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4508,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||':P1_PASSWORD := null;';

wwv_flow_api.create_page_plug (
  p_id=> 23127729082024333.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4508,
  p_plug_name=> 'reset',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 13,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'특정 데이터베이스 권한이 필요한 페이지에 대해 액세스를 요청했습니다. DBA 롤이 부여된 데이터베이스 계정의 증명서를 입력하십시오.';

wwv_flow_api.create_page_plug (
  p_id=> 61702507141217978.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4508,
  p_plug_name=> 'Login Message',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_header=> '<span class="fielddata">',
  p_plug_footer=> '</span><p /><p />',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'이 데이터베이스에서 DBA 또는 SELECT_CATALOG_ROLE 권한을 가진 데이터베이스 계정에 대한 사용자 이름 및 암호를 입력하십시오.';

wwv_flow_api.create_page_item(
  p_id=>1046305318309560.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4508,
  p_name=>'P1_USERNAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 1043922209309492.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'사용자 이름',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 25,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'암호를 입력하십시오.';

wwv_flow_api.create_page_item(
  p_id=>1046904764309562.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4508,
  p_name=>'P1_PASSWORD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 1043922209309492.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'암호',
  p_source_type=> 'STATIC',
  p_display_as=> 'PASSWORD_WITH_SUBMIT_DNSS',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 25,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>206105727449627884.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4508,
  p_name=>'P1_APP',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 1043922209309492.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '&APP_ID.',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'substr(:REQUEST,1,instr(:REQUEST,'','')-1)',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>206106408533631817.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4508,
  p_name=>'P1_PAGE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 1043922209309492.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '1',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'substr(:REQUEST,instr(:REQUEST,'','')+1)',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>359654713065770667.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4508,
  p_name=>'P1_LOGIN',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 1043922209309492.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'LOGIN_BUTTON',
  p_prompt=>'로그인',
  p_source=>'LOGIN_BUTTON',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 1047801276309580.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1.4508,
  p_validation_name => 'P1_USERNAME Not Null',
  p_validation_sequence=> 2,
  p_validation => 'P1_USERNAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '사용자 이름을 지정해야 합니다.',
  p_associated_item=> 1046305318309560.4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD',
  p_validation_comment=> 'generated 06-MAY-2002 18:28');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 1048123136309581.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1.4508,
  p_validation_name => 'P1_PASSWORD Not Null',
  p_validation_sequence=> 3,
  p_validation => 'P1_PASSWORD',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '암호를 지정해야 합니다.',
  p_associated_item=> 1046904764309562.4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD',
  p_validation_comment=> 'generated 06-MAY-2002 18:28');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 206083700119496957.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 1.4508,
  p_validation_name => 'check dba password',
  p_validation_sequence=> 13,
  p_validation => 'declare l_auth boolean := false;'||chr(10)||
'begin'||chr(10)||
'if not wwv_flow_utilities.db_version_is_at_least(''10.2.0.3'') then'||chr(10)||
'    -- 9ir2 or 10g (pre-10.2.0.3)'||chr(10)||
'    l_auth := wwv_flow_login.authenticate('||chr(10)||
'        p_username => :P1_USERNAME,'||chr(10)||
'        p_password => :P1_PASSWORD);'||chr(10)||
'else'||chr(10)||
'    -- 10.2.0.3 or greater and 11g'||chr(10)||
'    l_auth := sys.wwv_flow_val.verify_user('||chr(10)||
'        username => :P1_USERNAME,'||chr(10)||
'        password => :P1_PASSWORD) = sys.wwv_flow_val.valid_user;'||chr(10)||
'end if;'||chr(10)||
'if l_auth and wwv_flow_login.user_is_dba(p_username => :P1_USERNAME) then'||chr(10)||
'    :F4500_DBA_LOGIN := ''Y'';'||chr(10)||
'    :DBA_USERNAME := upper(:P1_USERNAME);'||chr(10)||
'    owa_util.redirect_url(''f?p=''||:P1_APP||'':''||:P1_PAGE||'':''||:SESSION);'||chr(10)||
'    return true;'||chr(10)||
'end if;'||chr(10)||
':F4500_DBA_LOGIN := ''N'';'||chr(10)||
'return false;'||chr(10)||
'exception when others then'||chr(10)||
'    return false;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '암호가 올바르지 않거나 사용자에게 필수 롤이 없습니다.',
  p_associated_item=> .4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'1';

wwv_flow_api.create_page_process(
  p_id     => 1048720322309595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1.4508,
  p_process_sequence=> 2,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'clear Items on this page',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 1.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_2.450
prompt  ...PAGE 2.4508: 트리거가 없는 테이블
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_excp_rpt.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 2.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '트리거가 없는 테이블',
  p_step_title=> '트리거가 없는 테이블',
  p_step_sub_title => 'Table Comments',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 276037127560809519+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3490920094618697.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164219',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>2.4508,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 69172222338446490.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4508,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106954406499588564.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'이 보고서에는 트리거가 없는 테이블이 표시됩니다.';

wwv_flow_api.create_page_plug (
  p_id=> 69172413159446494.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4508,
  p_plug_name=> '보고서',
  p_region_name=>'',
  p_plug_template=> 81906901123495005.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 69172615825446495.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4508,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select a.table_name'||chr(10)||
'    from sys.all_tables a'||chr(10)||
'   where owner = :P2_OWNER'||chr(10)||
'  and (:P2_FIND is null or a.table_name like ''%''||upper(:P2_FIND)||''%'' )'||chr(10)||
'  and a.table_name not like ''BIN$%'''||chr(10)||
'  and not exists ('||chr(10)||
'     select 1 '||chr(10)||
'     from all_triggers '||chr(10)||
'     where table_owner = :p2_owner and table_name = a.table_name)';

wwv_flow_api.create_report_region (
  p_id=> 69172828579446495.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4508,
  p_name=> 'Tables without Triggers',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_required_role => 270111329240924563+ wwv_flow_api.g_id_offset,
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 11028007180514315.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '데이터를 찾을 수 없습니다.',
  p_query_num_rows_item=> 'P2_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> '다운로드',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> '인쇄',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> ' width="13" height="12" ',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'generated 26-MAR-2003 13:37:26');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 69173007232446499.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 69172828579446495.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'TABLE_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> '트리거가 없는 테이블',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '100',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 69173409024446500.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 2.4508,
  p_plug_name=> 'schema',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_06',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>69175712074446516.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4508,
  p_branch_action=> '2',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'테이블 이름에 대해 대소문자 구분 없이 질의를 입력하고 <b>실행</b>을 누르십시오.';

wwv_flow_api.create_page_item(
  p_id=>69173623080446502.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4508,
  p_name=>'P2_FIND',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 69172222338446490.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'테이블 이름',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'데이터베이스 스키마 소유자의 이름';

wwv_flow_api.create_page_item(
  p_id=>69174122456446507.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4508,
  p_name=>'P2_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 69173409024446500.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'스키마',
  p_source=>'wwv_flow_user_api.get_default_schema',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'LIST_AVAILABLE_SCHEMAS',
  p_lov => 'declare'||chr(10)||
'  q      varchar2(32767) := null;'||chr(10)||
'begin  '||chr(10)||
'  q:=''select htf.escape_sc(upper(c.schema)) d, upper(c.schema) v '';'||chr(10)||
'  q:=q||''from   wwv_flow_company_schemas c, '';'||chr(10)||
'  q:=q||''       wwv_flow_fnd_user u '';'||chr(10)||
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.user_name = :flow_user and '';'||chr(10)||
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';'||chr(10)||
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';'||chr(10)||
'  q:=q||''order by 1'';  '||chr(10)||
'  return q;'||chr(10)||
'end;',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- 스키마 선택 - ',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="htmldbTopSchema"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'표시할 행 수를 선택하고 <b>실행</b>을 누르십시오.';

wwv_flow_api.create_page_item(
  p_id=>69174604923446510.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4508,
  p_name=>'P2_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 69172222338446490.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'행',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_A',
  p_lov => '.'||to_char(88005728392276151 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>69175102720446511.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4508,
  p_name=>'2_704_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 69172222338446490.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'실행',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 69175301137446513.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 2.4508,
  p_computation_sequence => 10,
  p_computation_item=> 'P2_OWNER',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'upper(wwv_flow_user_api.get_default_schema)',
  p_compute_when => 'P2_OWNER',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 69175520849446515.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2.4508,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>69175102720446511.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:P2_OWNER);'||chr(10)||
'wwv_flow_security.g_parse_as_schema_override := :P2_OWNER;'||chr(10)||
':G_PARSE_AS_SCHEMA_OVERRIDE := :P2_OWNER;';

wwv_flow_api.create_page_process(
  p_id     => 69192210847547410.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 2.4508,
  p_process_sequence=> 20,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'validate schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '부적합한 스키마',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 2.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_3.450
prompt  ...PAGE 3.4508: 테이블 생성 트리거 선택
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 3.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '테이블 생성 트리거 선택',
  p_step_title=> '테이블 선택',
  p_html_page_onload=>'onload="window.parent.obFrameSize();"',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 11540120040990569+ wwv_flow_api.g_id_offset,
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 149801911314283473.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164219',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 106724407422013886.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4508,
  p_plug_name=> '트리거 생성',
  p_region_name=>'',
  p_plug_template=> 140310301493602560.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 07-FEB-2003 18:17:26');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'150811814776114073';

wwv_flow_api.create_page_plug (
  p_id=> 150817615862142740.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4508,
  p_plug_name=> 'Progress Indicator',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 150811814776114073 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 106724622614013889.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 3.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 106724407422013886+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:top.ob_Reset();top.gSideBar.onchange();',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 106724801560013890.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 3.4508,
  p_button_sequence=> 30,
  p_button_plug_id => 106724407422013886+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '다음 &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>106728014234013914.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4508,
  p_branch_action=> 'f?p=&APP_ID.:84:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 03-FEB-2005 20:36 by SYME');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'이 트리거와 연관된 테이블을 선택하십시오.';

wwv_flow_api.create_page_item(
  p_id=>106725016917013892.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4508,
  p_name=>'P3_TABLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 106724407422013886.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'테이블 이름',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'POPUP',
  p_named_lov=> 'OB_CREATE_TABLE_HANDLER',
  p_lov => 'select object_name d, object_name r'||chr(10)||
'from sys.dba_objects'||chr(10)||
'where owner = :OB_SCHEMA '||chr(10)||
'and object_type in (''TABLE'')'||chr(10)||
'and object_name not like ''BIN$%'' '||chr(10)||
'and object_name not like ''DR$%'' '||chr(10)||
'order by 1',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'P3_FROM',
  p_display_when_type=>'ITEM_IS_NULL',
  p_field_template => 3301625476864638.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => 'Generated 07-FEB-2003 18:17:26');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'선택한 테이블을 소유하는 데이터베이스 스키마를 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>106725532339013897.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4508,
  p_name=>'P3_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 106724407422013886.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'스키마:',
  p_source=>'OB_SCHEMA',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 273749223696559998.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4508,
  p_computation_sequence => 10,
  p_computation_item=> 'P3_TABLE',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'QUERY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'select table_name from sys.dba_tables where upper(table_name) = upper(:p3_table);',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 106727400220013903.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 3.4508,
  p_computation_sequence => 20,
  p_computation_item=> 'F4500_LAST_VIEW',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'IFRAME_CANCEL',
  p_compute_when => 'P3_FROM',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 274022614606626627.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 3.4508,
  p_validation_name => 'table exists',
  p_validation_sequence=> 10,
  p_validation => 'select 1 from sys.dba_objects where upper(object_name) = upper(:P3_TABLE) and owner = :OB_SCHEMA and object_type ='||chr(10)||
'''TABLE''',
  p_validation_type => 'EXISTS',
  p_error_message => '테이블이 존재하지 않습니다.',
  p_associated_item=> .4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 3.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_4.450
prompt  ...PAGE 4.4508: 인덱스가 변경됨
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 4.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '인덱스가 변경됨',
  p_step_title=> '변경된 테이블',
  p_html_page_onload=>'onload="window.parent.obFrameSize();"',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 11093307704620192+ wwv_flow_api.g_id_offset,
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 10980707030991881.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164219',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<img src="#IMAGE_PREFIX#htmldb/builder/fail.gif" alt=""/>다음 원인으로 인해 &OBJECT_TYPE. 작업을 실패했습니다.'||chr(10)||
'<p>&P4_MSG.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 107474329693138421.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4508,
  p_plug_name=> '오류',
  p_region_name=>'',
  p_plug_template=> 140310301493602560.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 31,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2',
  p_plug_display_when_condition => 'P4_MSG',
  p_plug_display_when_cond2=>'SUCCESS',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 107474522298138421.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4508,
  p_plug_name=> 'SQL',
  p_region_name=>'',
  p_plug_template=> 18960127747559478.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 41,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'-- SR: JAS 01/26/09 - could not determine how to exercise page, did not change'||chr(10)||
'  if ( :P70_ACTION in (''RENAME'',''COPY'') ) then '||chr(10)||
'    if ( :P70_ACTION = ''COPY'') then '||chr(10)||
'        for c1 in (select object_id,object_name,owner,object_type'||chr(10)||
'                    from sys.dba_objects'||chr(10)||
'                   where owner = :OBJECT_OWNER'||chr(10)||
'                   and object_name = :P93_NEW_TABLE)'||chr(10)||
'       loop'||chr(10)||
'          :OBJECT';

s:=s||'_ID    := c1.object_id;'||chr(10)||
'          :OBJECT_NAME  := c1.object_name;'||chr(10)||
'          :OBJECT_TYPE  := c1.object_type;'||chr(10)||
'          :OBJECT_OWNER := c1.owner;'||chr(10)||
'      end loop;'||chr(10)||
'   end if;/* end copy if */'||chr(10)||
'    if ( :P70_ACTION = ''RENAME'') then '||chr(10)||
'        for c1 in (select object_id,object_name,owner,object_type'||chr(10)||
'                    from sys.dba_objects'||chr(10)||
'                   where owner = :OBJECT_OWNER'||chr(10)||
'                ';

s:=s||'   and object_name = :P73_NEW_TABLE_NAME)'||chr(10)||
'       loop'||chr(10)||
'          :OBJECT_ID    := c1.object_id;'||chr(10)||
'          :OBJECT_NAME  := c1.object_name;'||chr(10)||
'          :OBJECT_TYPE  := c1.object_type;'||chr(10)||
'          :OBJECT_OWNER := c1.owner;'||chr(10)||
'      end loop;'||chr(10)||
'   end if; /* end rename if */'||chr(10)||
'   end if;'||chr(10)||
''||chr(10)||
'htp.p(''<script>'||chr(10)||
' top.gSideBar.reload("''|| :OBJECT_TYPE ||''","''||:OBJECT_ID||''",true);'||chr(10)||
'</script>'');';

wwv_flow_api.create_page_plug (
  p_id=> 107474712667138423.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4508,
  p_plug_name=> 'Success Javascript',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 51,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_plug_display_when_condition => 'P4_MSG',
  p_plug_display_when_cond2=>'SUCCESS',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 270764810820114173.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 107474329693138421+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:top.ob_Reset();top.gSideBar.onchange();',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 107475119034138424.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 107474329693138421+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>107476418042138429.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4508,
  p_branch_action=> 'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>107475119034138424.4508+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'도움말 텍스트가 필요하지 않습니다.';

wwv_flow_api.create_page_item(
  p_id=>107475508914138426.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4508,
  p_name=>'P4_MSG',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'메시지',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when_type=>'NEVER',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>107476032550138427.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4508,
  p_name=>'P4_OBJECT_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>270771901432158778.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4508,
  p_name=>'P4_SQL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 107474522298138421.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'P5_SQL',
  p_source_type=> 'ITEM',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 70,
  p_cMaxlength=> 2000,
  p_cHeight=> 15,
  p_cAttributes=> 'nowrap',
  p_tag_attributes  => 'readonly="readonly"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'-- SR: JAS 01/26/09 - could not determine how to exercise page, did not change'||chr(10)||
'declare'||chr(10)||
' l_name varchar2(2000);'||chr(10)||
'begin'||chr(10)||
' if :P5_PREVIOUS = 94 then'||chr(10)||
'   l_name := :P94_INDEX_NAME;'||chr(10)||
' else'||chr(10)||
'   l_name := :P77_INDEX_NAME;'||chr(10)||
' end if;'||chr(10)||
' if ( :P5_ACTION = ''CREATE_INDEX'') then '||chr(10)||
'  for r in ( select object_id,object_name,owner,object_type'||chr(10)||
'   from sys.dba_objects'||chr(10)||
'   where owner = :OB_SCHEMA'||chr(10)||
'   and object_name = l_name'||chr(10)||
'';

p:=p||'   and object_type = ''INDEX'' ) loop'||chr(10)||
'     :OBJECT_ID    := r.object_id;'||chr(10)||
'     :OBJECT_NAME  := r.object_name;'||chr(10)||
'     :OBJECT_OWNER := r.owner;'||chr(10)||
'     :OBJECT_TYPE  := r.object_type;'||chr(10)||
'  end loop;'||chr(10)||
' end if; /* end create_index */'||chr(10)||
'htp.p(''<script>'||chr(10)||
' top.gSideBar.reload("''|| :OBJECT_TYPE ||''","''||:OBJECT_ID||''",true);'||chr(10)||
'</script>'');'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 182459028608141946.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 4.4508,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Load new Object',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>':P5_ACTION = ''CREATE_INDEX'' and :P4_MSG = ''SUCCESS''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 4.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_5.450
prompt  ...PAGE 5.4508: 인덱스 변경 확인
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph:=ph||'<script language="JavaScript" type="text/javascript">'||chr(10)||
'    function showDDL(){'||chr(10)||
'        theDDL = document.getElementById(''P67_SQL'');'||chr(10)||
'        showDiv = document.getElementById(''ddlShow'');'||chr(10)||
'        hideDiv = document.getElementById(''ddlHide'');'||chr(10)||
'        hideDiv.style.display = ''inline'';'||chr(10)||
'        theDDL.style.display = ''inline'';'||chr(10)||
'        showDiv.style.display = ''none'';'||chr(10)||
'        }'||chr(10)||
'        '||chr(10)||
'    function hideDD';

ph:=ph||'L(){'||chr(10)||
'        theDDL = document.getElementById(''P67_SQL'');'||chr(10)||
'        showDiv = document.getElementById(''ddlShow'');'||chr(10)||
'        hideDiv = document.getElementById(''ddlHide'');'||chr(10)||
'        hideDiv.style.display = ''none'';'||chr(10)||
'        theDDL.style.display = ''none'';'||chr(10)||
'        showDiv.style.display = ''inline'';'||chr(10)||
'        }'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 5.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '인덱스 변경 확인',
  p_step_title=> '테이블 변경 확인',
  p_html_page_onload=>'onload="window.parent.obFrameSize();"',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215538527409730225+ wwv_flow_api.g_id_offset,
  p_help_text => '',
  p_html_page_header => ' ',
  p_step_template => 149801911314283473.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164219',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>5.4508,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 107489816716162291.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5.4508,
  p_plug_name=> '요청 내용을 확인하십시오. ',
  p_region_name=>'',
  p_plug_template=> 156913627709610019.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 07-FEB-2003 18:17:26');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 107490015850162292.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5.4508,
  p_plug_name=> 'SQL',
  p_region_name=>'',
  p_plug_template=> 18960127747559478.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'149926526903576167';

wwv_flow_api.create_page_plug (
  p_id=> 149949010721628282.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5.4508,
  p_plug_name=> 'Progress Indicator',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 149926526903576167 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'VALUE_OF_ITEM_IN_CONDITION_NOT_IN_COLON_DELIMITED_LIST',
  p_plug_display_when_condition => 'F4500_LAST_VIEW',
  p_plug_display_when_cond2=>'2102',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 107490221219162293.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 107489816716162291+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:top.ob_Reset();top.gSideBar.onchange();',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 107490423349162293.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5.4508,
  p_button_sequence=> 30,
  p_button_plug_id => 107489816716162291+wwv_flow_api.g_id_offset,
  p_button_name    => 'FINISH',
  p_button_image_alt=> '완료',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 107490616048162293.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 5.4508,
  p_button_sequence=> 20,
  p_button_plug_id => 107489816716162291+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&P5_PREVIOUS.:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>107534407216303661.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5.4508,
  p_branch_action=> 'f?p=&APP_ID.:4:&SESSION.::&DEBUG.::P4_OBJECT_ID:&P5_NEW_OBJECT_ID.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>107490423349162293.4508+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 24-FEB-2005 14:27 by SYME');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'선택한 테이블을 소유하는 데이터베이스 스키마를 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>107490830150162294.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5.4508,
  p_name=>'P5_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 107489816716162291.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'스키마:',
  p_source=>'OBJECT_OWNER',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when_type=>'NEVER',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'선택된 테이블의 이름을 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>107491320593162295.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5.4508,
  p_name=>'P5_TABLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 107489816716162291.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'객체:',
  p_source=>'if :p5_PREVIOUS = ''77'' then '||chr(10)||
' return :P77_INDEX_NAME;'||chr(10)||
'else'||chr(10)||
' return :P94_INDEX_NAME;'||chr(10)||
'end if;',
  p_source_type=> 'FUNCTION_BODY',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'테이블에서 수행될 작업 유형을 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>107491812633162296.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5.4508,
  p_name=>'P5_ACTION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 3,
  p_item_plug_id => 107489816716162291.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'작업:',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>107492322417162297.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5.4508,
  p_name=>'P5_SQL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 107490015850162292.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 70,
  p_cMaxlength=> 2000,
  p_cHeight=> 15,
  p_tag_attributes  => 'readonly="readonly"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => 'Generated 07-FEB-2003 18:17:26');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>107492522422162297.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5.4508,
  p_name=>'P5_PREVIOUS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 107489816716162291.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Previous',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>107492718130162298.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5.4508,
  p_name=>'P5_NEW_OBJECT_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 107489816716162291.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 107492916493162298.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 5.4508,
  p_computation_sequence => 10,
  p_computation_item=> 'P57_TABLE',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'ITEM_VALUE',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'P73_NEW_TABLE_NAME',
  p_compute_when => ':P70_ACTION = ''RENAME'' and :REQUEST = ''FINISH''',
  p_compute_when_type=>'PLSQL_EXPRESSION');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv ('||chr(10)||
'    p_schema => upper(:OB_SCHEMA)'||chr(10)||
'    );';

wwv_flow_api.create_page_process(
  p_id     => 107493718722162300.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5.4508,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Check privs',
  p_process_sql_clob => p, 
  p_process_error_message=> '&OB_SCHEMA.에 대한 권한이 없습니다.',
  p_process_when_button_id=>107490423349162293.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':P4_MSG := wwv_flow_sw_util.run_other_sql('||chr(10)||
'              p_schema     => upper(:OB_SCHEMA),'||chr(10)||
'              p_sql        => :P5_SQL );'||chr(10)||
'if :p5_PREVIOUS = ''94'' then'||chr(10)||
'for c in (select object_id '||chr(10)||
'          from sys.dba_objects '||chr(10)||
'          where object_name = :p94_index_name '||chr(10)||
'          and owner = :OB_SCHEMA '||chr(10)||
'          and object_type = ''INDEX'') loop'||chr(10)||
'  :P5_NEW_OBJECT_ID := c.object_id;'||chr(10)||
'end loop;'||chr(10)||
'else'||chr(10)||
'for c';

p:=p||' in (select object_id '||chr(10)||
'          from sys.dba_objects '||chr(10)||
'          where object_name = :p77_index_name '||chr(10)||
'          and owner = :OB_SCHEMA '||chr(10)||
'          and object_type = ''INDEX'') loop'||chr(10)||
'  :P5_NEW_OBJECT_ID := c.object_id;'||chr(10)||
'end loop;'||chr(10)||
'end if;';

wwv_flow_api.create_page_process(
  p_id     => 107493904672162301.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5.4508,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'run DDL',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>107490423349162293.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.save_history ('||chr(10)||
'    p_security_group_id => :flow_security_group_id ,'||chr(10)||
'    p_user              => :flow_user,'||chr(10)||
'    p_sql_cmd           => :P5_SQL,'||chr(10)||
'    p_schema            => upper(:OB_SCHEMA)'||chr(10)||
'    );';

wwv_flow_api.create_page_process(
  p_id     => 107494126732162301.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 5.4508,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'save History',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>107490423349162293.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 5.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_7.450
prompt  ...PAGE 7.4508: 조회 테이블 생성 완료
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 7.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '조회 테이블 생성 완료',
  p_step_title=> '테이블 생성',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215538527409730225+ wwv_flow_api.g_id_offset,
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 10980707030991881.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164219',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 126727132100826335.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4508,
  p_plug_name=> '작업',
  p_region_name=>'',
  p_plug_template=> 30488201226315070.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 35404206746396755 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => 'NEVER',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<img src="#IMAGE_PREFIX#htmldb/builder/fail.gif" alt="" />"&P105_NEW_TABLE_TO_BE_CREATED." 테이블 생성을 실패했습니다.<br>  &P7_DDL_STATUS.';

wwv_flow_api.create_page_plug (
  p_id=> 126727325556826340.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4508,
  p_plug_name=> 'Create Table Failed',
  p_region_name=>'',
  p_plug_template=> 106819925599248236.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2',
  p_plug_display_when_condition => 'P7_DDL_STATUS',
  p_plug_display_when_cond2=>'SUCCESS',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 126727527751826343.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 7.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 126727325556826340+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '< 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:105:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 126728219494826365.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4508,
  p_computation_sequence => 20,
  p_computation_item=> 'P57_TABLE',
  p_computation_point=> 'AFTER_HEADER',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '&P602_NAME.',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 126728409921826371.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4508,
  p_computation_sequence => 30,
  p_computation_item=> 'P42_OBJECT_ID',
  p_computation_point=> 'AFTER_HEADER',
  p_computation_type=> 'QUERY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'select object_id'||chr(10)||
'from sys.dba_objects'||chr(10)||
'where owner = :P56_SCHEMA'||chr(10)||
'and object_name = :P57_TABLE'||chr(10)||
'and object_type = ''TABLE''',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 126728611159826372.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4508,
  p_computation_sequence => 10,
  p_computation_item=> 'P602_NAME',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'htf.escape_sc(:P602_NAME)',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 126728813666826372.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4508,
  p_computation_sequence => 10,
  p_computation_item=> 'P602_SCHEMA',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'htf.escape_sc(:P602_SCHEMA)',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||' for r in ( select object_id,object_name,owner,object_type'||chr(10)||
'from sys.dba_objects'||chr(10)||
'where owner = :OB_SCHEMA'||chr(10)||
'and object_name = :P105_NEW_TABLE_TO_BE_CREATED'||chr(10)||
'and object_type = ''TABLE'' ) loop'||chr(10)||
' :OBJECT_ID    := r.object_id;'||chr(10)||
' :OBJECT_NAME  := r.object_name;'||chr(10)||
' :OBJECT_OWNER := r.owner;'||chr(10)||
' :OBJECT_TYPE  := r.object_type;'||chr(10)||
''||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
''||chr(10)||
'htp.p(''<script type="text/javascript">top.gSideBar.reload("TABLE","''||:OBJECT';

p:=p||'_ID||''",true);</script>'');';

wwv_flow_api.create_page_process(
  p_id     => 126729024635826377.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 7.4508,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Load new Object_name/type/id',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'P7_DDL_STATUS',
  p_process_when_type=>'',
  p_process_when2=>'SUCCESS',
  p_process_when_type2=>'',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 7.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_8.450
prompt  ...PAGE 8.4508: 동의어가 생성됨
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 8.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '동의어가 생성됨',
  p_step_title=> '생성된 뷰',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 10980707030991881.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164219',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'동의어 생성을 실패했습니다.<br />'||chr(10)||
'&P8_MSG.';

wwv_flow_api.create_page_plug (
  p_id=> 107691211986788096.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4508,
  p_plug_name=> '오류',
  p_region_name=>'',
  p_plug_template=> 140310301493602560.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 21,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2',
  p_plug_display_when_condition => 'P8_MSG',
  p_plug_display_when_cond2=>'SUCCESS',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 107691627841788100.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 8.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 107691211986788096+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:top.ob_Reset();',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 107691818213788100.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 8.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 107691032442788092+wwv_flow_api.g_id_offset,
  p_button_name    => 'OK',
  p_button_image_alt=> '확인',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:SYNONYM_DETAIL:&SESSION.:GETOBJECT:&DEBUG.::OB_OBJECT_NAME:&OBJECT_ID.',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 107691416204788097.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 8.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 107691211986788096+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:127:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>107692206615788105.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4508,
  p_name=>'P8_MSG',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'for r in ( select object_id,object_name,owner,object_type'||chr(10)||
' from sys.dba_objects'||chr(10)||
' where owner = :OB_SCHEMA'||chr(10)||
' and object_name = :P99_NAME'||chr(10)||
' and object_type = ''SYNONYM'' ) loop'||chr(10)||
' :OBJECT_ID    := r.object_id;'||chr(10)||
' :OBJECT_NAME  := r.object_name;'||chr(10)||
' :OBJECT_OWNER := r.owner;'||chr(10)||
' :OBJECT_TYPE  := r.object_type;'||chr(10)||
''||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'htp.p(''<script>'||chr(10)||
' top.gSideBar.reload("''|| :OBJECT_TYPE ||''","''||:OBJECT_ID||''",true);'||chr(10)||
'</scrip';

p:=p||'t>'');';

wwv_flow_api.create_page_process(
  p_id     => 182563319407300115.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8.4508,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Load new Object',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'P8_MSG',
  p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_process_when2=>'SUCCESS',
  p_process_when_type2=>'',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 8.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_9.450
prompt  ...PAGE 9.4508: 트리거 생성 확인
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph:=ph||'<script language="JavaScript" type="text/javascript">'||chr(10)||
'    function showDDL(){'||chr(10)||
'        theDDL = document.getElementById(''P67_SQL'');'||chr(10)||
'        showDiv = document.getElementById(''ddlShow'');'||chr(10)||
'        hideDiv = document.getElementById(''ddlHide'');'||chr(10)||
'        hideDiv.style.display = ''inline'';'||chr(10)||
'        theDDL.style.display = ''inline'';'||chr(10)||
'        showDiv.style.display = ''none'';'||chr(10)||
'        }'||chr(10)||
'        '||chr(10)||
'    function hideDD';

ph:=ph||'L(){'||chr(10)||
'        theDDL = document.getElementById(''P67_SQL'');'||chr(10)||
'        showDiv = document.getElementById(''ddlShow'');'||chr(10)||
'        hideDiv = document.getElementById(''ddlHide'');'||chr(10)||
'        hideDiv.style.display = ''none'';'||chr(10)||
'        theDDL.style.display = ''none'';'||chr(10)||
'        showDiv.style.display = ''inline'';'||chr(10)||
'        }'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 9.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '트리거 생성 확인',
  p_step_title=> '테이블 변경 확인',
  p_html_page_onload=>'onload="window.parent.obFrameSize();"',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215538527409730225+ wwv_flow_api.g_id_offset,
  p_help_text => '',
  p_html_page_header => ' ',
  p_step_template => 149801911314283473.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164219',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>9.4508,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 108192008291627341.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4508,
  p_plug_name=> '요청 내용을 확인하십시오. ',
  p_region_name=>'',
  p_plug_template=> 156913627709610019.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 07-FEB-2003 18:17:26');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 108192200834627347.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4508,
  p_plug_name=> 'SQL',
  p_region_name=>'',
  p_plug_template=> 18960127747559478.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'150811814776114073';

wwv_flow_api.create_page_plug (
  p_id=> 150816405819139865.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4508,
  p_plug_name=> 'Progress Indicator',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 150811814776114073 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 108192406052627348.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 9.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 108192008291627341+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:top.ob_Reset();top.gSideBar.onchange();',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 108192601224627348.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 9.4508,
  p_button_sequence=> 30,
  p_button_plug_id => 108192008291627341+wwv_flow_api.g_id_offset,
  p_button_name    => 'FINISH',
  p_button_image_alt=> '완료',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 108192830309627349.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 9.4508,
  p_button_sequence=> 20,
  p_button_plug_id => 108192008291627341+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:84:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>108215531314676142.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4508,
  p_branch_action=> 'f?p=&APP_ID.:16:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>108192601224627348.4508+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 24-FEB-2005 21:02 by SYME');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'선택한 테이블을 소유하는 데이터베이스 스키마를 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>108193005205627351.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4508,
  p_name=>'P9_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 108192008291627341.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'스키마:',
  p_source=>'OB_SCHEMA',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'선택된 테이블의 이름을 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>108193517080627355.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4508,
  p_name=>'P9_TABLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 108192008291627341.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'객체:',
  p_source=>'P3_TABLE',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'테이블에서 수행될 작업 유형을 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>108194026282627356.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4508,
  p_name=>'P9_ACTION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 3,
  p_item_plug_id => 108192008291627341.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'작업:',
  p_source=>'wwv_flow_lang.system_message(''CREATE_TRIGGER'',:P84_TRIGGER_NAME);',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>108194505205627357.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 9.4508,
  p_name=>'P9_SQL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 108192200834627347.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 70,
  p_cMaxlength=> 2000,
  p_cHeight=> 15,
  p_tag_attributes  => 'readonly="readonly"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => 'Generated 07-FEB-2003 18:17:26');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv ('||chr(10)||
'    p_schema => upper(:OB_SCHEMA)'||chr(10)||
'    );';

wwv_flow_api.create_page_process(
  p_id     => 108195917976627367.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 9.4508,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Check privs',
  p_process_sql_clob => p, 
  p_process_error_message=> '&P56_SCHEMA.에 대한 권한이 없습니다.',
  p_process_when_button_id=>108192601224627348.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':P16_MSG := wwv_flow_sw_util.run_other_sql('||chr(10)||
'              p_schema     => upper(:OB_SCHEMA),'||chr(10)||
'              p_sql        => :P9_SQL );'||chr(10)||
''||chr(10)||
'for c in (select object_id from sys.dba_objects where object_name = :P84_TRIGGER_NAME and owner = :OB_SCHEMA and'||chr(10)||
'          object_type = ''TRIGGER'') loop'||chr(10)||
'  :object_id := c.object_id;'||chr(10)||
'  :object_type := ''TRIGGER'';'||chr(10)||
'end loop;';

wwv_flow_api.create_page_process(
  p_id     => 108196125269627368.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 9.4508,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'run DDL',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>108192601224627348.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.save_history ('||chr(10)||
'    p_security_group_id => :flow_security_group_id ,'||chr(10)||
'    p_user              => :flow_user,'||chr(10)||
'    p_sql_cmd           => :P9_SQL,'||chr(10)||
'    p_schema            => upper(:OB_SCHEMA)'||chr(10)||
'    );';

wwv_flow_api.create_page_process(
  p_id     => 108196325839627370.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 9.4508,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'save History',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>108192601224627348.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 9.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_10.45
prompt  ...PAGE 10.4508: 스크립트 - 실행
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_rep_run_script.htm';

ph:=ph||'<script language="JavaScript" type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
''||chr(10)||
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 10.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '스크립트 - 실행',
  p_step_title=> '스크립트 실행',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 213236600761856491+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => 3490920094618697.4508+ wwv_flow_api.g_id_offset,
  p_required_role => 11650706329157488+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164219',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>10.4508,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>10.4508,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 10048401428195635.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4508,
  p_plug_name=> 'Schema',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_06',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 22279526089373324.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4508,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'wwv_flow_sw_script.display_run_confirm('||chr(10)||
'    p_file_id => :F4500_P10_FILE_ID,'||chr(10)||
'    p_date_time_format => ''&DATE_TIME_FORMAT.'');';

wwv_flow_api.create_page_plug (
  p_id=> 42832115592689804.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4508,
  p_plug_name=> '스크립트 실행',
  p_region_name=>'',
  p_plug_template=> 140310301493602560.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 109787703963442985.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 10.4508,
  p_button_sequence=> 30,
  p_button_plug_id => 42832115592689804+wwv_flow_api.g_id_offset,
  p_button_name    => 'EDIT_SCRIPT',
  p_button_image_alt=> '스크립트 편집',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:60:&SESSION.::&DEBUG.::P60_FILE_ID:&F4500_P10_FILE_ID.',
  p_button_condition=> 'wwv_flow_sw_script.script_w_warning(p_file_id => :F4500_P10_FILE_ID)',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 372022143187.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 10.4508,
  p_button_sequence=> 1,
  p_button_plug_id => 42832115592689804+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:1004:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 7732532393677275.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 10.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 42832115592689804+wwv_flow_api.g_id_offset,
  p_button_name    => 'RUN_IN_BACKGROUND',
  p_button_image_alt=> '실행',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 372007991036.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 10.4508,
  p_button_sequence=> 15,
  p_button_plug_id => 42832115592689804+wwv_flow_api.g_id_offset,
  p_button_name    => 'RUN',
  p_button_image_alt=> '지금 실행',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>10103208092528775.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4508,
  p_branch_action=> 'f?p=&APP_ID.:1220:&SESSION.:fsp_sort_8_desc:&DEBUG.:RP,1220:P1220_SHOW,P1220_FILE_ID,P1220_VIEW:&APP_USER.,&F4500_P10_FILE_ID.,DETAIL&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 30,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 26-JAN-2005 12:18 by CBCHO');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'이 스크립트를 실행할 데이터베이스 스키마(또는 사용자 이름)를 선택하십시오.';

wwv_flow_api.create_page_item(
  p_id=>29063885017.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4508,
  p_name=>'P10_RUN_AS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 10048401428195635.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'스키마',
  p_source=>'wwv_flow_user_api.get_default_schema',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'LIST_AVAILABLE_SCHEMAS',
  p_lov => 'declare'||chr(10)||
'  q      varchar2(32767) := null;'||chr(10)||
'begin  '||chr(10)||
'  q:=''select htf.escape_sc(upper(c.schema)) d, upper(c.schema) v '';'||chr(10)||
'  q:=q||''from   wwv_flow_company_schemas c, '';'||chr(10)||
'  q:=q||''       wwv_flow_fnd_user u '';'||chr(10)||
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.user_name = :flow_user and '';'||chr(10)||
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';'||chr(10)||
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';'||chr(10)||
'  q:=q||''order by 1'';  '||chr(10)||
'  return q;'||chr(10)||
'end;',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="htmldbTopSchema"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>29128987183.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4508,
  p_name=>'F4500_P10_FILE_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 42832115592689804.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'F4500_P10_FILE_ID',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>16826800561032587.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4508,
  p_name=>'P10_RESULT_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 10048401428195635.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>145945111357011245.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4508,
  p_name=>'P10_SCRIPT_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 42832115592689804.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'select filename'||chr(10)||
'from wwv_flow_files'||chr(10)||
'where id = :F4500_P10_FILE_ID'||chr(10)||
'and file_type = ''SCRIPT''',
  p_source_type=> 'QUERY',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 18056327424.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 10.4508,
  p_validation_name => 'Must Select Run As',
  p_validation_sequence=> 10,
  p_validation => 'P10_RUN_AS',
  p_validation_type => 'ITEM_NOT_ZERO',
  p_error_message => '이 스크립트를 실행하려면 Oracle Schema(사용자 이름)를 지정해야 합니다.  ',
  p_validation_condition=> 'RUN,RUN_IN_BACKGROUND',
  p_validation_condition_type=> 'REQUEST_IN_CONDITION',
  p_associated_item=> 29063885017.4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_IN_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 11073708320589640.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 10.4508,
  p_validation_name => 'job queue process set?',
  p_validation_sequence=> 20,
  p_validation => 'declare'||chr(10)||
'  l_jqp varchar2(1000) := ''0'';'||chr(10)||
'begin '||chr(10)||
'  for c1 in (select value '||chr(10)||
'             from v$parameter'||chr(10)||
'             where name = ''job_queue_processes'')'||chr(10)||
'  loop'||chr(10)||
'    l_jqp := c1.value;'||chr(10)||
'  end loop;'||chr(10)||
'  '||chr(10)||
'  if l_jqp = ''0'' then'||chr(10)||
'  	return false;'||chr(10)||
'  else'||chr(10)||
'  	return true;'||chr(10)||
'  end if;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '데이터베이스 작업 대기열 프로세스가 사용으로 설정되지 않았습니다. 관리자에게 문의하여 JOB_QUEUE_PROCESSES 초기화 매개변수를 설정하십시오.',
  p_when_button_pressed=> 7732532393677275.4508 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv ('||chr(10)||
'    p_schema => :P10_RUN_AS'||chr(10)||
'    );';

wwv_flow_api.create_page_process(
  p_id     => 128081917428230107.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10.4508,
  p_process_sequence=> 2,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'check priv',
  p_process_sql_clob => p, 
  p_process_error_message=> '권한을 검사하는 중 오류가 발생했습니다.',
  p_process_when_button_id=>372007991036.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_preferences.set_preference('||chr(10)||
'p_preference=>''FSP4500_P1220_R11177418830226625_SORT'','||chr(10)||
'p_value => ''fsp_sort_8'','||chr(10)||
'p_user => v(''USER''));';

wwv_flow_api.create_page_process(
  p_id     => 19995201456899729.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10.4508,
  p_process_sequence=> 3,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set sort preference',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':P10_RESULT_ID := wwv_flow_sw_script.submit_to_run ('||chr(10)||
'                   p_file_id  => :F4500_P10_FILE_ID,'||chr(10)||
'                   p_run_by   => :APP_USER,'||chr(10)||
'                   p_run_as   => :P10_RUN_AS'||chr(10)||
'                   );';

wwv_flow_api.create_page_process(
  p_id     => 16829118962066241.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10.4508,
  p_process_sequence=> 45,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'submit script',
  p_process_sql_clob => p, 
  p_process_error_message=> '실행할 스크립트를 제출할 수 없습니다.',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_script.run_file'||chr(10)||
'      (p_result_id => :P10_RESULT_ID,'||chr(10)||
'       p_file_id => :F4500_P10_FILE_ID,       '||chr(10)||
'       p_schema    => :P10_RUN_AS,'||chr(10)||
'       p_run_by  => :APP_USER);';

wwv_flow_api.create_page_process(
  p_id     => 9321931833012508.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10.4508,
  p_process_sequence=> 46,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'run script',
  p_process_sql_clob => p, 
  p_process_error_message=> '스크립트를 실행할 수 없습니다.',
  p_process_when_button_id=>372007991036.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_script.run_file'||chr(10)||
'      (p_result_id => :P10_RESULT_ID,'||chr(10)||
'       p_file_id   => :F4500_P10_FILE_ID,'||chr(10)||
'       p_job_id    => :FLOW_JOB,'||chr(10)||
'       p_schema    => :P10_RUN_AS,'||chr(10)||
'       p_run_by    => :APP_USER,'||chr(10)||
'       p_session   => :app_session);';

wwv_flow_api.create_page_process(
  p_id     => 9343822548189616.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 10.4508,
  p_process_sequence=> 50,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL_DBMS_JOB',
  p_process_name=> 'run script in job',
  p_process_sql_clob => p, 
  p_process_error_message=> '작업에서 스크립트를 실행할 수 없습니다.',
  p_process_when_button_id=>7732532393677275.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '실행을 위해 스크립트가 제출되었습니다. 결과를 보려면 스크립트 아이콘을 누르십시오.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 10.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_11.45
prompt  ...PAGE 11.4508: 데이터베이스 모니터
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/dbadm_montitor.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 11.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '데이터베이스 모니터',
  p_step_title=> '데이터베이스 모니터',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 206250111084432914+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164220',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>11.4508,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 133761309661244883.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4508,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'133792932105421631';

wwv_flow_api.create_page_plug (
  p_id=> 133796225310429187.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4508,
  p_plug_name=> 'Activity',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 11,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 133792932105421631 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/chart_bar_64.gif" border="0" height="64" width="64" alt="" /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 11.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_12.45
prompt  ...PAGE 12.4508: DDL 생성
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_ddl.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 12.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'DDL 생성',
  p_step_title=> 'DDL 생성',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164220',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>12.4508,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 111995127950763042.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 12.4508,
  p_plug_name=> 'menu',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select owner schema_owner, '||chr(10)||
'       sum(decode(object_type,''TABLE'',1,0)) tables,'||chr(10)||
'       sum(decode(object_type,''VIEW'',1,0)) views,'||chr(10)||
'       sum(decode(object_type,''PACKAGE'',1,0)) packages,'||chr(10)||
'       sum(decode(object_type,''PROCEDURE'',1,0)) procedures,'||chr(10)||
'       sum(decode(object_type,''FUNCTION'',1,0)) functions,'||chr(10)||
'       sum(decode(object_type,''TRIGGER'',1,0)) triggers,'||chr(10)||
'       sum(decode(object_type,''SYNONYM'',';

s:=s||'1,0)) synonyms,'||chr(10)||
'       sum(decode(object_type,''TYPE'',1,0)) types,'||chr(10)||
'       sum(decode(object_type,''SEQUENCE'',1,0)) sequences,'||chr(10)||
'       sum(decode(object_type,''INDEX'',1,0)) indexes,'||chr(10)||
'       sum(decode(object_type,''DATABASE LINK'',1,0)) database_links,'||chr(10)||
'       sum(decode(object_type,''MATERIALIZED VIEW'',1,0)) materialized_views'||chr(10)||
'from ('||chr(10)||
'select owner, object_type, object_name'||chr(10)||
'from sys.dba_objects where owner i';

s:=s||'n ('||chr(10)||
'select c.schema'||chr(10)||
'from   wwv_flow_company_schemas c,'||chr(10)||
'       wwv_flow_fnd_user u'||chr(10)||
'where  c.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.security_group_id = :flow_security_group_id and'||chr(10)||
'       u.user_name = :flow_user and'||chr(10)||
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or'||chr(10)||
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0))'||chr(10)||
') x'||chr(10)||
'group by owner';

wwv_flow_api.create_report_region (
  p_id=> 112008410335786392.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 12.4508,
  p_name=> '스키마 객체',
  p_region_name=>'',
  p_template=> 140310301493602560.4508+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 11,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 11028007180514315.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '데이터를 찾을 수 없습니다.',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 112033400171849651.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 112008410335786392.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA_OWNER',
  p_column_display_sequence=> 1,
  p_column_heading=> '스키마',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 112018722718808831.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 112008410335786392.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'TABLES',
  p_column_display_sequence=> 2,
  p_column_heading=> '테이블',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 112018817897808832.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 112008410335786392.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'VIEWS',
  p_column_display_sequence=> 3,
  p_column_heading=> '뷰',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 112018925361808832.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 112008410335786392.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PACKAGES',
  p_column_display_sequence=> 4,
  p_column_heading=> '패키지',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 112019004670808832.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 112008410335786392.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'PROCEDURES',
  p_column_display_sequence=> 5,
  p_column_heading=> '프로시저',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 112019128704808832.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 112008410335786392.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'FUNCTIONS',
  p_column_display_sequence=> 6,
  p_column_heading=> '함수 ',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 112019214354808832.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 112008410335786392.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'TRIGGERS',
  p_column_display_sequence=> 7,
  p_column_heading=> '트리거',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 112019331357808833.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 112008410335786392.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'SYNONYMS',
  p_column_display_sequence=> 8,
  p_column_heading=> '동의어',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 112019405748808833.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 112008410335786392.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'TYPES',
  p_column_display_sequence=> 9,
  p_column_heading=> '유형',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 112019522070808833.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 112008410335786392.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'SEQUENCES',
  p_column_display_sequence=> 10,
  p_column_heading=> '시퀀스',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 109838616390970644.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 112008410335786392.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'INDEXES',
  p_column_display_sequence=> 11,
  p_column_heading=> '인덱스',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 112019627606808833.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 112008410335786392.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'DATABASE_LINKS',
  p_column_display_sequence=> 12,
  p_column_heading=> '데이터베이스 링크',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 109835426602935710.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 112008410335786392.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'MATERIALIZED_VIEWS',
  p_column_display_sequence=> 13,
  p_column_heading=> '구체화된 뷰',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 275630221694208722.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 12.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 112008410335786392+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:1005:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 112022311206824401.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 12.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 112008410335786392+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_image_alt=> '스크립트 작성 &gt;',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 12.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_13.45
prompt  ...PAGE 13.4508: 데이터 디렉토리
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_objs.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 13.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '데이터 디렉토리',
  p_step_title=> '데이터 디렉토리',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 11093307704620192+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3490920094618697.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164220',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>13.4508,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3310207015870962.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 13.4508,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106954406499588564.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6705008447713236.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 13.4508,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 11600917523650714.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 13.4508,
  p_plug_name=> 'schema owner',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_06',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'   q  varchar2(32767);'||chr(10)||
'begin'||chr(10)||
'--wwv_flow_security.g_parse_as_schema := --nvl(:P13_SCHEMA,wwv_flow_user_api.get_default_schema);'||chr(10)||
'wwv_flow_security.g_parse_as_schema_override := nvl(:P13_SCHEMA,wwv_flow_user_api.get_default_schema);'||chr(10)||
'q := '||chr(10)||
'''select o.object_name, c.comments '';'||chr(10)||
'q := q||'' from sys.all_objects o, sys.all_tab_comments c '';'||chr(10)||
'q := q||'' where o.owner = c.owner '';'||chr(10)||
'q := q||'' and o.object';

s:=s||'_name = c.table_name '';'||chr(10)||
'q := q||'' and o.object_type = ''''VIEW'''' and (o.owner = ''''SYS'''' or o.owner=''''FLOWS_030100'''') '';'||chr(10)||
'q := q||'' and (o.object_name like ''''USER%'''' '';'||chr(10)||
'q := q||'' or  o.object_name like ''''ALL%''''  '';'||chr(10)||
'q := q||'' or  o.object_name like ''''APEX_%'''') '';'||chr(10)||
'if :F4500_P13_SEARCH_CRITERIA is not null then'||chr(10)||
'  q := q||'' and o.object_name like upper(''''%'''' || :F4500_P13_SEARCH_CRITERIA || ''''%'''') '';'||chr(10)||
'end ';

s:=s||'if;'||chr(10)||
'return q;'||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 72488043357529861.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 13.4508,
  p_name=> 'Browse Oracle Data Dictionary',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 40,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'P13_SCHEMA',
  p_display_condition_type=> 'ITEM_IS_NOT_ZERO',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 11028007180514315.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '데이터를 찾을 수 없습니다.',
  p_query_num_rows_item=> 'F4500_P13_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> '다운로드',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> '인쇄',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '데이터 디렉토리',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48814928213772363.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72488043357529861.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'OBJECT_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> '데이터 딕셔너리 뷰 이름',
  p_column_link=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.::F4500_P14_OBJECT_NAME:#OBJECT_NAME#',
  p_column_linktext=>'#OBJECT_NAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '40',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48815017870772363.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72488043357529861.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'COMMENTS',
  p_column_display_sequence=> 2,
  p_column_heading=> '설명',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '60',
  p_column_comment=>'');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>72492410848555529.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13.4508,
  p_branch_action=> '13',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 20-JUL-2001 11:30 by CBCHO');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'이 페이지를 볼 때 사용하는 데이터베이스 스키마를 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>465515900436190.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13.4508,
  p_name=>'P13_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 11600917523650714.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'wwv_flow_user_api.get_default_schema',
  p_item_default_type => 'PLSQL_EXPRESSION',
  p_prompt=>'스키마',
  p_source=>'wwv_flow_user_api.get_default_schema',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX_WITH_SUBMIT',
  p_named_lov=> 'LIST_AVAILABLE_SCHEMAS',
  p_lov => 'declare'||chr(10)||
'  q      varchar2(32767) := null;'||chr(10)||
'begin  '||chr(10)||
'  q:=''select htf.escape_sc(upper(c.schema)) d, upper(c.schema) v '';'||chr(10)||
'  q:=q||''from   wwv_flow_company_schemas c, '';'||chr(10)||
'  q:=q||''       wwv_flow_fnd_user u '';'||chr(10)||
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.user_name = :flow_user and '';'||chr(10)||
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';'||chr(10)||
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';'||chr(10)||
'  q:=q||''order by 1'';  '||chr(10)||
'  return q;'||chr(10)||
'end;',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- 스키마 -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="htmldbTopSchema"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>467211183444240.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13.4508,
  p_name=>'P13_SCHEMA_LABEL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 3310207015870962.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'wwv_flow_lang.system_message(''CONFIRM.PARSING_SCHEMA'')',
  p_source_type=> 'FUNCTION',
  p_source_post_computation => 'htf.escape_sc(:P13_SCHEMA_LABEL)',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'대소문자 구분 없이 질의를 입력하고 <b>실행</b>을 누르십시오.';

wwv_flow_api.create_page_item(
  p_id=>72478811694506653.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13.4508,
  p_name=>'F4500_P13_SEARCH_CRITERIA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 3310207015870962.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'검색',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>72481181435512267.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13.4508,
  p_name=>'F4500_P13_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 99,
  p_item_plug_id => 3310207015870962.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'실행',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'CENTER-CENTER',
  p_field_alignment  => 'CENTER-BOTTOM',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'보고서에 표시할 행 수를 선택하고 <b>실행</b>을 누르십시오.';

wwv_flow_api.create_page_item(
  p_id=>72547419252784171.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13.4508,
  p_name=>'F4500_P13_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 3310207015870962.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'표시',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_A',
  p_lov => '.'||to_char(88005728392276151 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 112261530045965316.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13.4508,
  p_computation_sequence => 10,
  p_computation_item=> 'P13_SCHEMA',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'upper(wwv_flow_user_api.get_default_schema)',
  p_compute_when => 'P13_SCHEMA',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 72506184274587104.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 13.4508,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 72916716738362484.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 13.4508,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset when max rows display changes',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:P13_SCHEMA);';

wwv_flow_api.create_page_process(
  p_id     => 69265424643797427.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 13.4508,
  p_process_sequence=> 20,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Validate Schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '부적합한 스키마',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 13.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_14.45
prompt  ...PAGE 14.4508: 데이터 딕셔너리 브라우저
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_objs.htm';

ph:=ph||'<script language="JavaScript1.1" type="text/javascript">'||chr(10)||
'function ToggleAll(e){'||chr(10)||
'  if (e.checked){CheckAll(); }'||chr(10)||
'  else{ClearAll();}'||chr(10)||
'  }'||chr(10)||
''||chr(10)||
'function Check(e){e.checked = true; }'||chr(10)||
'function Clear(e){e.checked = false;}'||chr(10)||
'function CheckAll(){'||chr(10)||
'  var ml = document.wwv_flow;'||chr(10)||
'  var len = ml.elements.length;'||chr(10)||
'  for (var i = 0; i < len; i++){'||chr(10)||
'    var e = ml.elements[i];'||chr(10)||
'    if (e.name == "f01") {Check(e);}'||chr(10)||
'   }'||chr(10)||
'  ';

ph:=ph||'ml.f01.checked = true;'||chr(10)||
' }'||chr(10)||
''||chr(10)||
'function ClearAll(){'||chr(10)||
'  var ml = document.wwv_flow;'||chr(10)||
'  var len = ml.elements.length;'||chr(10)||
'  for (var i = 0; i < len; i++){'||chr(10)||
'    var e = ml.elements[i];'||chr(10)||
'    if (e.name == "f01") {Clear(e);}'||chr(10)||
'  }'||chr(10)||
'  ml.f01.checked = false;'||chr(10)||
'}'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 14.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '데이터 딕셔너리 브라우저',
  p_step_title=> '데이터 딕셔너리 브라우저',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 11093307704620192+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => 3490920094618697.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164220',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>14.4508,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>14.4508,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 8433315974658433.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4508,
  p_plug_name=> 'topbar',
  p_region_name=>'',
  p_plug_template=> 3239725494807263.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 5,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 11641430924922520.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4508,
  p_plug_name=> 'schema',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_06',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 22511717122091395.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4508,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'  q varchar2(32767);'||chr(10)||
'begin'||chr(10)||
'wwv_flow_security.g_parse_as_schema_override := :F4500_P15_PARSE_STMT_AS;'||chr(10)||
'  q := '||chr(10)||
'''select'||chr(10)||
'  wwv_flow_item.checkbox(1,x.column_name) include,  '||chr(10)||
'  x.column_id,'||chr(10)||
'  x.column_name column_name, '||chr(10)||
'  wwv_flow_item.text(2,null) condition,   '||chr(10)||
'  x.data_type data_type,'||chr(10)||
'  x.comments,'||chr(10)||
'  wwv_flow_item.hidden(3,x.data_type) data_type,  '||chr(10)||
'  wwv_flow_item.hidden(4,x.column_name)'||chr(10)||
'from';

s:=s||' ('||chr(10)||
'select '||chr(10)||
'  t.column_id,'||chr(10)||
'  t.column_name,'||chr(10)||
'  t.data_type,'||chr(10)||
'  c.comments'||chr(10)||
'from all_tab_columns t, all_col_comments c'||chr(10)||
'where t.owner = c.owner'||chr(10)||
'and t.table_name = c.table_name'||chr(10)||
'and t.column_name = c.column_name'||chr(10)||
'and (t.owner = ''''SYS'''' or t.owner = ''''FLOWS_030100'''')'||chr(10)||
'and t.table_name = :F4500_P14_OBJECT_NAME'||chr(10)||
') x'';'||chr(10)||
'return q;'||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4508,
  p_name=> 'Dictionary Query By Example (QBE) Form',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 11028007180514315.4508+ wwv_flow_api.g_id_offset,
  p_plug_query_max_columns=> 60,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '1000',
  p_query_options=> 'GENERIC_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_LEFT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48718216970771769.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'COL01',
  p_column_display_sequence=> 1,
  p_column_heading=> '포함',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48718313462771769.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'COL02',
  p_column_display_sequence=> 2,
  p_column_heading=> '시퀀스',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48718420839771769.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'COL03',
  p_column_display_sequence=> 3,
  p_column_heading=> '열 이름',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48718529301771769.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'COL04',
  p_column_display_sequence=> 4,
  p_column_heading=> '열 조건',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48718632395771769.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'COL05',
  p_column_display_sequence=> 5,
  p_column_heading=> '데이터 유형',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48718718158771769.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'COL06',
  p_column_display_sequence=> 6,
  p_column_heading=> '설명',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48718831167771769.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'COL07',
  p_column_display_sequence=> 7,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48718909626771769.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'COL08',
  p_column_display_sequence=> 8,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48719009204771770.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'COL09',
  p_column_display_sequence=> 9,
  p_column_heading=> 'COL09',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48719105173771770.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'COL10',
  p_column_display_sequence=> 10,
  p_column_heading=> 'COL10',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48719221922771770.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'COL11',
  p_column_display_sequence=> 11,
  p_column_heading=> 'COL11',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48719316380771770.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'COL12',
  p_column_display_sequence=> 12,
  p_column_heading=> 'COL12',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48719417803771770.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'COL13',
  p_column_display_sequence=> 13,
  p_column_heading=> 'COL13',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48719518395771770.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'COL14',
  p_column_display_sequence=> 14,
  p_column_heading=> 'COL14',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48719617809771770.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'COL15',
  p_column_display_sequence=> 15,
  p_column_heading=> 'COL15',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191029519116227646.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'COL16',
  p_column_display_sequence=> 16,
  p_column_heading=> 'Col16',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191029610644227647.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'COL17',
  p_column_display_sequence=> 17,
  p_column_heading=> 'Col17',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191029716011227647.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 18,
  p_form_element_id=> null,
  p_column_alias=> 'COL18',
  p_column_display_sequence=> 18,
  p_column_heading=> 'Col18',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191029817088227647.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 19,
  p_form_element_id=> null,
  p_column_alias=> 'COL19',
  p_column_display_sequence=> 19,
  p_column_heading=> 'Col19',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191029916789227647.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 20,
  p_form_element_id=> null,
  p_column_alias=> 'COL20',
  p_column_display_sequence=> 20,
  p_column_heading=> 'Col20',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191030025132227647.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 21,
  p_form_element_id=> null,
  p_column_alias=> 'COL21',
  p_column_display_sequence=> 21,
  p_column_heading=> 'Col21',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191030120853227647.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 22,
  p_form_element_id=> null,
  p_column_alias=> 'COL22',
  p_column_display_sequence=> 22,
  p_column_heading=> 'Col22',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191030206484227647.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 23,
  p_form_element_id=> null,
  p_column_alias=> 'COL23',
  p_column_display_sequence=> 23,
  p_column_heading=> 'Col23',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191030332711227648.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 24,
  p_form_element_id=> null,
  p_column_alias=> 'COL24',
  p_column_display_sequence=> 24,
  p_column_heading=> 'Col24',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191030404015227648.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 25,
  p_form_element_id=> null,
  p_column_alias=> 'COL25',
  p_column_display_sequence=> 25,
  p_column_heading=> 'Col25',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191030511643227648.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 26,
  p_form_element_id=> null,
  p_column_alias=> 'COL26',
  p_column_display_sequence=> 26,
  p_column_heading=> 'Col26',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191030618215227648.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 27,
  p_form_element_id=> null,
  p_column_alias=> 'COL27',
  p_column_display_sequence=> 27,
  p_column_heading=> 'Col27',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191030726761227648.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 28,
  p_form_element_id=> null,
  p_column_alias=> 'COL28',
  p_column_display_sequence=> 28,
  p_column_heading=> 'Col28',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191030832475227648.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 29,
  p_form_element_id=> null,
  p_column_alias=> 'COL29',
  p_column_display_sequence=> 29,
  p_column_heading=> 'Col29',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191030919647227648.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 30,
  p_form_element_id=> null,
  p_column_alias=> 'COL30',
  p_column_display_sequence=> 30,
  p_column_heading=> 'Col30',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191031004327227648.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 31,
  p_form_element_id=> null,
  p_column_alias=> 'COL31',
  p_column_display_sequence=> 31,
  p_column_heading=> 'Col31',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191031110691227648.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 32,
  p_form_element_id=> null,
  p_column_alias=> 'COL32',
  p_column_display_sequence=> 32,
  p_column_heading=> 'Col32',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191031218978227649.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 33,
  p_form_element_id=> null,
  p_column_alias=> 'COL33',
  p_column_display_sequence=> 33,
  p_column_heading=> 'Col33',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191031318337227649.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 34,
  p_form_element_id=> null,
  p_column_alias=> 'COL34',
  p_column_display_sequence=> 34,
  p_column_heading=> 'Col34',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191031402823227649.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 35,
  p_form_element_id=> null,
  p_column_alias=> 'COL35',
  p_column_display_sequence=> 35,
  p_column_heading=> 'Col35',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191031516513227649.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 36,
  p_form_element_id=> null,
  p_column_alias=> 'COL36',
  p_column_display_sequence=> 36,
  p_column_heading=> 'Col36',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191031603927227649.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 37,
  p_form_element_id=> null,
  p_column_alias=> 'COL37',
  p_column_display_sequence=> 37,
  p_column_heading=> 'Col37',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191031722871227649.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 38,
  p_form_element_id=> null,
  p_column_alias=> 'COL38',
  p_column_display_sequence=> 38,
  p_column_heading=> 'Col38',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191031805641227649.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 39,
  p_form_element_id=> null,
  p_column_alias=> 'COL39',
  p_column_display_sequence=> 39,
  p_column_heading=> 'Col39',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191031923723227649.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 40,
  p_form_element_id=> null,
  p_column_alias=> 'COL40',
  p_column_display_sequence=> 40,
  p_column_heading=> 'Col40',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191032023968227650.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 41,
  p_form_element_id=> null,
  p_column_alias=> 'COL41',
  p_column_display_sequence=> 41,
  p_column_heading=> 'Col41',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191032102507227650.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 42,
  p_form_element_id=> null,
  p_column_alias=> 'COL42',
  p_column_display_sequence=> 42,
  p_column_heading=> 'Col42',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191032204363227650.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 43,
  p_form_element_id=> null,
  p_column_alias=> 'COL43',
  p_column_display_sequence=> 43,
  p_column_heading=> 'Col43',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191032300003227650.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 44,
  p_form_element_id=> null,
  p_column_alias=> 'COL44',
  p_column_display_sequence=> 44,
  p_column_heading=> 'Col44',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191032426520227650.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 45,
  p_form_element_id=> null,
  p_column_alias=> 'COL45',
  p_column_display_sequence=> 45,
  p_column_heading=> 'Col45',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191032530901227650.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 46,
  p_form_element_id=> null,
  p_column_alias=> 'COL46',
  p_column_display_sequence=> 46,
  p_column_heading=> 'Col46',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191032628309227650.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 47,
  p_form_element_id=> null,
  p_column_alias=> 'COL47',
  p_column_display_sequence=> 47,
  p_column_heading=> 'Col47',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191032729791227650.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 48,
  p_form_element_id=> null,
  p_column_alias=> 'COL48',
  p_column_display_sequence=> 48,
  p_column_heading=> 'Col48',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191032817859227651.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 49,
  p_form_element_id=> null,
  p_column_alias=> 'COL49',
  p_column_display_sequence=> 49,
  p_column_heading=> 'Col49',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191032901529227651.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 50,
  p_form_element_id=> null,
  p_column_alias=> 'COL50',
  p_column_display_sequence=> 50,
  p_column_heading=> 'Col50',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191033006050227652.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 51,
  p_form_element_id=> null,
  p_column_alias=> 'COL51',
  p_column_display_sequence=> 51,
  p_column_heading=> 'Col51',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191033129993227652.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 52,
  p_form_element_id=> null,
  p_column_alias=> 'COL52',
  p_column_display_sequence=> 52,
  p_column_heading=> 'Col52',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191033221815227652.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 53,
  p_form_element_id=> null,
  p_column_alias=> 'COL53',
  p_column_display_sequence=> 53,
  p_column_heading=> 'Col53',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191033321315227652.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 54,
  p_form_element_id=> null,
  p_column_alias=> 'COL54',
  p_column_display_sequence=> 54,
  p_column_heading=> 'Col54',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191033418668227652.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 55,
  p_form_element_id=> null,
  p_column_alias=> 'COL55',
  p_column_display_sequence=> 55,
  p_column_heading=> 'Col55',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191033510260227653.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 56,
  p_form_element_id=> null,
  p_column_alias=> 'COL56',
  p_column_display_sequence=> 56,
  p_column_heading=> 'Col56',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191033632393227653.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 57,
  p_form_element_id=> null,
  p_column_alias=> 'COL57',
  p_column_display_sequence=> 57,
  p_column_heading=> 'Col57',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191033723264227653.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 58,
  p_form_element_id=> null,
  p_column_alias=> 'COL58',
  p_column_display_sequence=> 58,
  p_column_heading=> 'Col58',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191033822141227653.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 59,
  p_form_element_id=> null,
  p_column_alias=> 'COL59',
  p_column_display_sequence=> 59,
  p_column_heading=> 'Col59',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 191033916672227653.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72610012393226909.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 60,
  p_form_element_id=> null,
  p_column_alias=> 'COL60',
  p_column_display_sequence=> 60,
  p_column_heading=> 'Col60',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 72687949604609551.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4508,
  p_plug_name=> 'Data Dictionary View',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 72673335411575794.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 14.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 8433315974658433+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 72676514275580298.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 14.4508,
  p_button_sequence=> 20,
  p_button_plug_id => 8433315974658433+wwv_flow_api.g_id_offset,
  p_button_name    => 'Query',
  p_button_image_alt=> '질의',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>72676946566580304.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4508,
  p_branch_action=> '15',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>72676514275580298.4508+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>72673714957575801.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4508,
  p_branch_action=> '13',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>72673335411575794.4508+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'데이터 딕셔너리 뷰 이름을 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>72694595799623334.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4508,
  p_name=>'F4500_P14_OBJECT_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 72687949604609551.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'뷰 이름',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>72783020283894832.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4508,
  p_name=>'F4500_P14_QUERY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 72610012393226909.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'F4500_P14_QUERY',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'예제 질의별로 이 질의의 구문을 분석할 데이터베이스 스키마(또는 사용자 이름)를 선택하십시오.';

wwv_flow_api.create_page_item(
  p_id=>72974620438464018.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4508,
  p_name=>'F4500_P15_PARSE_STMT_AS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 11641430924922520.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'스키마',
  p_source=>'wwv_flow_user_api.get_default_schema',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'LIST_AVAILABLE_SCHEMAS',
  p_lov => 'declare'||chr(10)||
'  q      varchar2(32767) := null;'||chr(10)||
'begin  '||chr(10)||
'  q:=''select htf.escape_sc(upper(c.schema)) d, upper(c.schema) v '';'||chr(10)||
'  q:=q||''from   wwv_flow_company_schemas c, '';'||chr(10)||
'  q:=q||''       wwv_flow_fnd_user u '';'||chr(10)||
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.user_name = :flow_user and '';'||chr(10)||
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';'||chr(10)||
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';'||chr(10)||
'  q:=q||''order by 1'';  '||chr(10)||
'  return q;'||chr(10)||
'end;',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- 스키마 선택 -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="htmldbTopSchema"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'모든 행 검사';

wwv_flow_api.create_page_item(
  p_id=>101240401152279929.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4508,
  p_name=>'F4500_P14_CHECK_ALL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 72610012393226909.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'모두 선택',
  p_post_element_text=>'<input type="checkbox" name="f10" onclick="ToggleAll(this)" />',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 12399821819620115.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 112334425618219519.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4508,
  p_computation_sequence => 10,
  p_computation_item=> 'F4500_P15_PARSE_STMT_AS',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'upper(wwv_flow_user_api.get_default_schema)',
  p_compute_when => 'F4500_P15_PARSE_STMT_AS',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 101182427964386235.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14.4508,
  p_validation_name => 'select at least one column',
  p_validation_sequence=> 10,
  p_validation => 'declare'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  if wwv_flow.g_f01.count = 0 then'||chr(10)||
''||chr(10)||
'    return false;'||chr(10)||
''||chr(10)||
'  else'||chr(10)||
''||chr(10)||
'    return true;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '열을 보려면 한 개 이상 지정해야 합니다. ',
  p_when_button_pressed=> 72676514275580298.4508 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 128448727865650733.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 14.4508,
  p_validation_name => 'must select parse as',
  p_validation_sequence=> 10,
  p_validation => 'F4500_P15_PARSE_STMT_AS',
  p_validation_type => 'ITEM_NOT_ZERO',
  p_error_message => '이 질의 구문을 분석하려면 Oracle Schema(사용자 이름)를 지정해야 합니다.  ',
  p_when_button_pressed=> 72676514275580298.4508 + wwv_flow_api.g_id_offset,
  p_associated_item=> 72974620438464018.4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_sql   varchar2(32767) := null;'||chr(10)||
'  l_count number := 1;'||chr(10)||
'begin  '||chr(10)||
'  l_sql:=''select '';'||chr(10)||
''||chr(10)||
'  for i in 1..wwv_flow.g_f01.count loop'||chr(10)||
'    l_sql:=l_sql||wwv_flow.g_f01(i)||'', '';'||chr(10)||
'  end loop;'||chr(10)||
'  l_sql:=rtrim(l_sql,'', '');'||chr(10)||
''||chr(10)||
'  l_sql:=l_sql||'' from ''||:F4500_P14_OBJECT_NAME;  '||chr(10)||
'  '||chr(10)||
'  for j in 1..wwv_flow.g_f02.count loop'||chr(10)||
'    if wwv_flow.g_f02(j) is not null then      '||chr(10)||
'      if l_count = 1 then      '||chr(10)||
'      ';

p:=p||'  l_sql:=l_sql||'' where ''||wwv_flow.g_f04(j)||'' like '';'||chr(10)||
'        l_sql:=l_sql||wwv_flow_utilities.ite(wwv_flow.g_f03(j)=''VARCHAR2'','||chr(10)||
'                                             ''''''''||upper(wwv_flow.g_f02(j))||'''''''','||chr(10)||
'                                             wwv_flow.g_f02(j));'||chr(10)||
'      elsif l_count > 1 then'||chr(10)||
'        l_sql:=l_sql||'' and ''||wwv_flow.g_f04(j)||'' like '';'||chr(10)||
'        l_sql:=l_sql||wwv_flow_u';

p:=p||'tilities.ite(wwv_flow.g_f03(j)=''VARCHAR2'','||chr(10)||
'                                             ''''''''||upper(wwv_flow.g_f02(j))||'''''''','||chr(10)||
'                                             wwv_flow.g_f02(j));'||chr(10)||
'      end if;'||chr(10)||
'      l_count := l_count + 1;'||chr(10)||
'    end if;    '||chr(10)||
'  end loop; '||chr(10)||
'  '||chr(10)||
'  :f4500_p14_query := l_sql;'||chr(10)||
'  '||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 72792311558912454.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 14.4508,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'query',
  p_process_sql_clob => p, 
  p_process_error_message=> '적합한 데이터 딕셔너리 질의를 작성하는 중 오류가 발생했습니다.',
  p_process_when_button_id=>72676514275580298.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:F4500_P15_PARSE_STMT_AS);';

wwv_flow_api.create_page_process(
  p_id     => 69310525990845161.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 14.4508,
  p_process_sequence=> 20,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Validate Schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '부적합한 스키마',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 14.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_15.45
prompt  ...PAGE 15.4508: 데이터 딕셔너리 브라우저
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_objs.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 15.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '데이터 딕셔너리 브라우저',
  p_step_title=> '데이터 딕셔너리 브라우저',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215533519659718594+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 7493627476185560.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164221',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>15.4508,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 8428426757653465.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 15.4508,
  p_plug_name=> 'topbar',
  p_region_name=>'',
  p_plug_template=> 106954406499588564.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 22512824048093435.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 15.4508,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'begin'||chr(10)||
'--'||chr(10)||
'-- flows has privs to set non public parsing schema'||chr(10)||
'--'||chr(10)||
'wwv_flow_sw_api.check_priv ('||chr(10)||
'    p_schema => :F4500_P15_PARSE_STMT_AS);'||chr(10)||
''||chr(10)||
'--wwv_flow.g_flow_owner := wwv_flow_security.g_parse_as_schema;'||chr(10)||
'--wwv_flow_security.g_parse_as_schema := :F4500_P15_PARSE_STMT_AS;'||chr(10)||
'wwv_flow_security.g_parse_as_schema_override := :F4500_P15_PARSE_STMT_AS;'||chr(10)||
'wwv_flow.debug(:f4500_p14_query);'||chr(10)||
'return :f4500_p14_query;';

s:=s||''||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 15.4508,
  p_name=> 'Query Results',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 11028007180514315.4508+ wwv_flow_api.g_id_offset,
  p_plug_query_max_columns=> 60,
  p_query_headings_type=> 'QUERY_COLUMNS_INITCAP',
  p_query_num_rows=> '15',
  p_query_options=> 'GENERIC_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '데이터를 찾을 수 없습니다.',
  p_query_num_rows_item=> 'F4500_P15_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '1000',
  p_pagination_display_position=> 'BOTTOM_LEFT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48496908414770400.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'COL01',
  p_column_display_sequence=> 1,
  p_column_heading=> 'COL01',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48497024693770400.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'COL02',
  p_column_display_sequence=> 2,
  p_column_heading=> 'COL02',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48497115550770400.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'COL03',
  p_column_display_sequence=> 3,
  p_column_heading=> 'COL03',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48497214669770400.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'COL04',
  p_column_display_sequence=> 4,
  p_column_heading=> 'COL04',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48497315430770401.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'COL05',
  p_column_display_sequence=> 5,
  p_column_heading=> 'COL05',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48497418633770401.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'COL06',
  p_column_display_sequence=> 6,
  p_column_heading=> 'COL06',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48497501678770401.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'COL07',
  p_column_display_sequence=> 7,
  p_column_heading=> 'COL07',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48497624681770401.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'COL08',
  p_column_display_sequence=> 8,
  p_column_heading=> 'COL08',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48497703128770401.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'COL09',
  p_column_display_sequence=> 9,
  p_column_heading=> 'COL09',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48497823777770401.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'COL10',
  p_column_display_sequence=> 10,
  p_column_heading=> 'COL10',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48497912399770401.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'COL11',
  p_column_display_sequence=> 11,
  p_column_heading=> 'COL11',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48498024704770401.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'COL12',
  p_column_display_sequence=> 12,
  p_column_heading=> 'COL12',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48498100804770401.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'COL13',
  p_column_display_sequence=> 13,
  p_column_heading=> 'COL13',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48498211783770402.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'COL14',
  p_column_display_sequence=> 14,
  p_column_heading=> 'COL14',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48498322912770402.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'COL15',
  p_column_display_sequence=> 15,
  p_column_heading=> 'COL15',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 101387732499375710.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'COL16',
  p_column_display_sequence=> 16,
  p_column_heading=> 'COL16',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 101387824096375712.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'COL17',
  p_column_display_sequence=> 17,
  p_column_heading=> 'COL17',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 101387902538375712.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 18,
  p_form_element_id=> null,
  p_column_alias=> 'COL18',
  p_column_display_sequence=> 18,
  p_column_heading=> 'COL18',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 101388010724375712.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 19,
  p_form_element_id=> null,
  p_column_alias=> 'COL19',
  p_column_display_sequence=> 19,
  p_column_heading=> 'COL19',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 101388126372375712.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 20,
  p_form_element_id=> null,
  p_column_alias=> 'COL20',
  p_column_display_sequence=> 20,
  p_column_heading=> 'COL20',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162268930148685559.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 21,
  p_form_element_id=> null,
  p_column_alias=> 'COL21',
  p_column_display_sequence=> 21,
  p_column_heading=> 'COL21',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162269023884685559.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 22,
  p_form_element_id=> null,
  p_column_alias=> 'COL22',
  p_column_display_sequence=> 22,
  p_column_heading=> 'COL22',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162269121692685565.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 23,
  p_form_element_id=> null,
  p_column_alias=> 'COL23',
  p_column_display_sequence=> 23,
  p_column_heading=> 'COL23',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162269213375685566.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 24,
  p_form_element_id=> null,
  p_column_alias=> 'COL24',
  p_column_display_sequence=> 24,
  p_column_heading=> 'COL24',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162269321244685566.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 25,
  p_form_element_id=> null,
  p_column_alias=> 'COL25',
  p_column_display_sequence=> 25,
  p_column_heading=> 'COL25',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162269410621685566.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 26,
  p_form_element_id=> null,
  p_column_alias=> 'COL26',
  p_column_display_sequence=> 26,
  p_column_heading=> 'COL26',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162269504428685566.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 27,
  p_form_element_id=> null,
  p_column_alias=> 'COL27',
  p_column_display_sequence=> 27,
  p_column_heading=> 'COL27',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162269604156685566.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 28,
  p_form_element_id=> null,
  p_column_alias=> 'COL28',
  p_column_display_sequence=> 28,
  p_column_heading=> 'COL28',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162269728992685566.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 29,
  p_form_element_id=> null,
  p_column_alias=> 'COL29',
  p_column_display_sequence=> 29,
  p_column_heading=> 'COL29',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162269820824685566.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 30,
  p_form_element_id=> null,
  p_column_alias=> 'COL30',
  p_column_display_sequence=> 30,
  p_column_heading=> 'COL30',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162269903098685567.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 31,
  p_form_element_id=> null,
  p_column_alias=> 'COL31',
  p_column_display_sequence=> 31,
  p_column_heading=> 'COL31',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162270022230685567.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 32,
  p_form_element_id=> null,
  p_column_alias=> 'COL32',
  p_column_display_sequence=> 32,
  p_column_heading=> 'COL32',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162270123628685567.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 33,
  p_form_element_id=> null,
  p_column_alias=> 'COL33',
  p_column_display_sequence=> 33,
  p_column_heading=> 'COL33',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162270214729685567.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 34,
  p_form_element_id=> null,
  p_column_alias=> 'COL34',
  p_column_display_sequence=> 34,
  p_column_heading=> 'COL34',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162270306013685567.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 35,
  p_form_element_id=> null,
  p_column_alias=> 'COL35',
  p_column_display_sequence=> 35,
  p_column_heading=> 'COL35',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162270403739685567.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 36,
  p_form_element_id=> null,
  p_column_alias=> 'COL36',
  p_column_display_sequence=> 36,
  p_column_heading=> 'COL36',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162270512314685567.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 37,
  p_form_element_id=> null,
  p_column_alias=> 'COL37',
  p_column_display_sequence=> 37,
  p_column_heading=> 'COL37',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162270619695685567.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 38,
  p_form_element_id=> null,
  p_column_alias=> 'COL38',
  p_column_display_sequence=> 38,
  p_column_heading=> 'COL38',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162270725824685568.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 39,
  p_form_element_id=> null,
  p_column_alias=> 'COL39',
  p_column_display_sequence=> 39,
  p_column_heading=> 'COL39',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162270819092685568.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 40,
  p_form_element_id=> null,
  p_column_alias=> 'COL40',
  p_column_display_sequence=> 40,
  p_column_heading=> 'COL40',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162270931199685568.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 41,
  p_form_element_id=> null,
  p_column_alias=> 'COL41',
  p_column_display_sequence=> 41,
  p_column_heading=> 'COL41',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162271022721685568.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 42,
  p_form_element_id=> null,
  p_column_alias=> 'COL42',
  p_column_display_sequence=> 42,
  p_column_heading=> 'COL42',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162271100480685568.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 43,
  p_form_element_id=> null,
  p_column_alias=> 'COL43',
  p_column_display_sequence=> 43,
  p_column_heading=> 'COL43',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162271206417685568.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 44,
  p_form_element_id=> null,
  p_column_alias=> 'COL44',
  p_column_display_sequence=> 44,
  p_column_heading=> 'COL44',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162271320546685568.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 45,
  p_form_element_id=> null,
  p_column_alias=> 'COL45',
  p_column_display_sequence=> 45,
  p_column_heading=> 'COL45',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162271422779685568.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 46,
  p_form_element_id=> null,
  p_column_alias=> 'COL46',
  p_column_display_sequence=> 46,
  p_column_heading=> 'COL46',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162271504769685569.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 47,
  p_form_element_id=> null,
  p_column_alias=> 'COL47',
  p_column_display_sequence=> 47,
  p_column_heading=> 'COL47',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162271608376685569.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 48,
  p_form_element_id=> null,
  p_column_alias=> 'COL48',
  p_column_display_sequence=> 48,
  p_column_heading=> 'COL48',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162271732479685569.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 49,
  p_form_element_id=> null,
  p_column_alias=> 'COL49',
  p_column_display_sequence=> 49,
  p_column_heading=> 'COL49',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162271816655685569.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 50,
  p_form_element_id=> null,
  p_column_alias=> 'COL50',
  p_column_display_sequence=> 50,
  p_column_heading=> 'COL50',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162271917777685569.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 51,
  p_form_element_id=> null,
  p_column_alias=> 'COL51',
  p_column_display_sequence=> 51,
  p_column_heading=> 'COL51',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162272006093685569.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 52,
  p_form_element_id=> null,
  p_column_alias=> 'COL52',
  p_column_display_sequence=> 52,
  p_column_heading=> 'COL52',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162272124828685569.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 53,
  p_form_element_id=> null,
  p_column_alias=> 'COL53',
  p_column_display_sequence=> 53,
  p_column_heading=> 'COL53',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162272203274685569.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 54,
  p_form_element_id=> null,
  p_column_alias=> 'COL54',
  p_column_display_sequence=> 54,
  p_column_heading=> 'COL54',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162272315265685570.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 55,
  p_form_element_id=> null,
  p_column_alias=> 'COL55',
  p_column_display_sequence=> 55,
  p_column_heading=> 'COL55',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162272400451685570.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 56,
  p_form_element_id=> null,
  p_column_alias=> 'COL56',
  p_column_display_sequence=> 56,
  p_column_heading=> 'COL56',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162272518315685570.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 57,
  p_form_element_id=> null,
  p_column_alias=> 'COL57',
  p_column_display_sequence=> 57,
  p_column_heading=> 'COL57',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162272609604685570.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 58,
  p_form_element_id=> null,
  p_column_alias=> 'COL58',
  p_column_display_sequence=> 58,
  p_column_heading=> 'COL58',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162272725503685570.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 59,
  p_form_element_id=> null,
  p_column_alias=> 'COL59',
  p_column_display_sequence=> 59,
  p_column_heading=> 'COL59',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 162272824324685570.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 72708419326651673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 60,
  p_form_element_id=> null,
  p_column_alias=> 'COL60',
  p_column_display_sequence=> 60,
  p_column_heading=> 'COL60',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'이 페이지에는 데이터 딕셔너리 질의 결과가 표시됩니다. 결과 목록 상단에 있는 탐색 단추를 눌러 새 질의를 입력하거나 다른 데이터 딕셔너리 테이블을 찾아보십시오.';

wwv_flow_api.create_page_plug (
  p_id=> 72709513331652891.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 15.4508,
  p_plug_name=> '질의 결과',
  p_region_name=>'',
  p_plug_template=> 81906901123495005.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 72923691296374499.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 15.4508,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 73051386810876661.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 15.4508,
  p_button_sequence=> 1,
  p_button_plug_id => 8428426757653465+wwv_flow_api.g_id_offset,
  p_button_name    => 'New Query',
  p_button_image_alt=> '새 질의',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 73092323108960513.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 15.4508,
  p_button_sequence=> 11,
  p_button_plug_id => 8428426757653465+wwv_flow_api.g_id_offset,
  p_button_name    => 'BrowseAnotherView',
  p_button_image_alt=> '다른 뷰 찾아보기',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>73051719881876667.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 15.4508,
  p_branch_action=> '14',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>73051386810876661.4508+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>73092721135960520.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 15.4508,
  p_branch_action=> '13',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>73092323108960513.4508+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>72886276500307504.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 15.4508,
  p_branch_action=> '15',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 20-JUL-2001 16:22 by CBCHO');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'보고서에 표시할 최대 행 수를 선택하십시오.';

wwv_flow_api.create_page_item(
  p_id=>72928317406381693.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 15.4508,
  p_name=>'F4500_P15_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 8428426757653465.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'표시',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_A',
  p_lov => '.'||to_char(88005728392276151 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>83958920185763837.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 15.4508,
  p_name=>'F4500_P15_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 8428426757653465.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'실행',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 72933410758391006.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 15.4508,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset when max rows changes',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_disp_page_plugs.reset_region_pagination(72708419326651673);';

wwv_flow_api.create_page_process(
  p_id     => 37917032522591199.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 15.4508,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'reset pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 15.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_16.45
prompt  ...PAGE 16.4508: 트리거가 생성됨
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 16.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '트리거가 생성됨',
  p_step_title=> '변경된 테이블',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 10980707030991881.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164221',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<img src="#IMAGE_PREFIX#htmldb/builder/fail.gif" alt="">다음 원인으로 인해 트리거 생성 작업을 실패했습니다.<br>'||chr(10)||
'&P16_MSG.';

wwv_flow_api.create_page_plug (
  p_id=> 108198732257632292.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4508,
  p_plug_name=> 'Error',
  p_region_name=>'',
  p_plug_template=> 106819925599248236.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 31,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2',
  p_plug_display_when_condition => 'P16_MSG',
  p_plug_display_when_cond2=>'SUCCESS',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 108199509676632295.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 16.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 108198732257632292+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:9:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'도움말 텍스트가 필요하지 않습니다.';

wwv_flow_api.create_page_item(
  p_id=>108199917731632296.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4508,
  p_name=>'P16_MSG',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'메시지',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when_type=>'NEVER',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'for r in ( select object_id,object_name,owner,object_type'||chr(10)||
' from sys.dba_objects'||chr(10)||
' where owner = :OB_SCHEMA'||chr(10)||
' and object_name = :P84_TRIGGER_NAME'||chr(10)||
' and object_type = ''TRIGGER'' ) loop'||chr(10)||
' :OBJECT_ID    := r.object_id;'||chr(10)||
' :OBJECT_NAME  := r.object_name;'||chr(10)||
' :OBJECT_OWNER := r.owner;'||chr(10)||
' :OBJECT_TYPE  := r.object_type;'||chr(10)||
''||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'htp.p(''<script>'||chr(10)||
' top.gSideBar.reload("''|| :OBJECT_TYPE ||''","''||:OBJECT_ID||''",true);';

p:=p||''||chr(10)||
'</script>'');';

wwv_flow_api.create_page_process(
  p_id     => 182503528617217617.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 16.4508,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'route page',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'P16_MSG',
  p_process_when_type=>'',
  p_process_when2=>'SUCCESS',
  p_process_when_type2=>'',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 16.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_18.45
prompt  ...PAGE 18.4508: DDL 생성
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_ddl.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 18.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'DDL 생성',
  p_step_title=> 'DDL 생성',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 11093307704620192+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 20823807893218193.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164221',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>18.4508,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6810825540619084.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4508,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 74343509509191237.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4508,
  p_plug_name=> 'DDL 생성',
  p_region_name=>'',
  p_plug_template=> 140310301493602560.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'List:  DDL Wizard';

wwv_flow_api.create_page_plug (
  p_id=> 87140610261575493.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4508,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 87134126220568115 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>DDL(데이터 정의어) 스크립트를 작성하려는 데이터베이스 객체를 소유하는 데이터베이스 스키마를 선택하십시오.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 239287223624468794.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4508,
  p_plug_name=> 'DDL 생성',
  p_region_name=>'',
  p_plug_template=> 81906901123495005.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 74368913703223471.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 18.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 74343509509191237+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 74371220283225403.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 18.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 74343509509191237+wwv_flow_api.g_id_offset,
  p_button_name    => 'Next',
  p_button_image_alt=> '다음 &gt;',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>74355506047207982.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4508,
  p_branch_action=> '43',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>74371220283225403.4508+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 15-JUL-2002 13:44 by CBCHO');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'DDL을 생성하려는 객체를 소유하는 데이터베이스 스키마를 선택하십시오.';

wwv_flow_api.create_page_item(
  p_id=>74350120711201184.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4508,
  p_name=>'F4500_P18_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 74343509509191237.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'스키마',
  p_source=>'wwv_flow_user_api.get_default_schema',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'LIST_AVAILABLE_SCHEMAS',
  p_lov => 'declare'||chr(10)||
'  q      varchar2(32767) := null;'||chr(10)||
'begin  '||chr(10)||
'  q:=''select htf.escape_sc(upper(c.schema)) d, upper(c.schema) v '';'||chr(10)||
'  q:=q||''from   wwv_flow_company_schemas c, '';'||chr(10)||
'  q:=q||''       wwv_flow_fnd_user u '';'||chr(10)||
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.user_name = :flow_user and '';'||chr(10)||
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';'||chr(10)||
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';'||chr(10)||
'  q:=q||''order by 1'';  '||chr(10)||
'  return q;'||chr(10)||
'end;',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- 스키마 선택 - ',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301625476864638.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 148823616528244857.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4508,
  p_computation_sequence => 10,
  p_computation_item=> 'LAST_SELECTED_PARSE_AS',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'ITEM_VALUE',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'F4500_P18_SCHEMA',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 87184711302620651.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 18.4508,
  p_validation_name => 'F4500_P18_SCHEMA Not Null',
  p_validation_sequence=> 1,
  p_validation => 'F4500_P18_SCHEMA',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '스키마를 지정해야 합니다.',
  p_associated_item=> 74350120711201184.4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 01-AUG-2002 11:49');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 18.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_21.45
prompt  ...PAGE 21.4508: 최상위 SQL
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/dbadm_topsql.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 21.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '최상위 SQL',
  p_step_title=> '최상위 SQL',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 206250111084432914+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 206059717799303330+ wwv_flow_api.g_id_offset,
  p_required_patch=> 140265918963157648.4508 + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164222',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>21.4508,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 134582407812955080.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4508,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 160632704976002525.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4508,
  p_plug_name=> 'Query Parameter Container',
  p_region_name=>'',
  p_plug_template=> 106954406499588564.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'    x   varchar2(32767);'||chr(10)||
'    p   varchar2(32767):= null;'||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'x:=''select * from ( '';'||chr(10)||
'x:=x||''select htf.escape_sc(replace(replace(substr(sql_text,1,500),'''','''','''', ''''),'''',''''||chr(32)||chr(32),'''',''''||chr(32))) sql_text, '';'||chr(10)||
'x:=x||''  (cpu_time/1000000) cpu_time,disk_reads,buffer_gets, '';'||chr(10)||
'x:=x||''  executions, '';'||chr(10)||
'x:=x||''  case when rows_processed = 0 then null else (buffer_gets/nvl(replace(rows';

s:=s||'_processed,0,1),1)) end efficiency, '';'||chr(10)||
'x:=x||''  (buffer_gets/nvl(replace(executions,0,1),1)) efficiency2, '';'||chr(10)||
'x:=x||''  child_number,hash_value,address, '';'||chr(10)||
'x:=x||'' case '';'||chr(10)||
'x:=x||'' when (select count(*) from v$sql_plan sp where  sp.address=s.address '';'||chr(10)||
'x:=x||'' and sp.HASH_VALUE=s.hash_value and sp.CHILD_NUMBER=s.child_number) > 0'';'||chr(10)||
'x:=x||'' then ''''<a href="f?p=4500:551:&SESSION.::NO:551:P551_ADDRESS,P';

s:=s||'551_HASH_VALUE,P551_CHILD_NUMBER:''''||s.address||'''',''''||s.hash_value||'''',''''||s.child_number||''''"><img src="#IMAGE_PREFIX#24find.gif" border="0" alt="" width="24" height="24" /></a> '''' '';'||chr(10)||
'x:=x||'' else null '';'||chr(10)||
'x:=x||'' end x, '';'||chr(10)||
'x:=x||'' null link, '';'||chr(10)||
'x:=x||''  (elapsed_time/1000000) elapsed_time,  '';'||chr(10)||
'x:=x||''  ''''''||wwv_flow_lang.system_message(''SESSION_MON_ELAPSED'')||'' ''''||to_char((elapsed_time/1000000)';

s:=s||',''''999G999G999G999D00'''') || '';'||chr(10)||
'x:=x||''  ''''<br />''||wwv_flow_lang.system_message(''SESSION_MON_CPU'')||'' ''''||to_char((cpu_time/1000000),''''999G999G999G999D00'''') the_time,  '';'||chr(10)||
'x:=x||''  ''''''||wwv_flow_lang.system_message(''SESSION_MON_DISK'')||'' ''''||to_char(disk_reads,''''999G999G999G999'''')||''''<br />''''|| '';'||chr(10)||
'x:=x||''  ''''''||wwv_flow_lang.system_message(''SESSION_MON_BUFFER'')||'' ''''||to_char(buffer_gets,''''999G999G';

s:=s||'999G999'''') reads,module  '';'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'x:=x||''from v$sql s '';'||chr(10)||
'-- Begin Predicates'||chr(10)||
'if :P21_SEARCH is not null then'||chr(10)||
'  p := p||''where instr(upper(sql_text),upper(:P21_SEARCH))>0 '';'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'if :P21_MINIMUM_EXECUTIONS  is not null then'||chr(10)||
'    if p is null then'||chr(10)||
'        p := p||'' where '';'||chr(10)||
'    else'||chr(10)||
'        p := p||'' and '';'||chr(10)||
'    end if;'||chr(10)||
'    '||chr(10)||
'    p := p||''EXECUTIONS >=:P21_MINIMUM_EXECUTIONS '';'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'if :P21_MODULE';

s:=s||' is not null then'||chr(10)||
'    if p is null then'||chr(10)||
'        p := p||'' where '';'||chr(10)||
'    else'||chr(10)||
'        p := p||'' and '';'||chr(10)||
'    end if;'||chr(10)||
'    p := p||'' instr(upper(module),upper(:P21_MODULE))>0 '';'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'if p is not null then'||chr(10)||
'    x:=x||p;'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'-- End Predicates'||chr(10)||
'x:=x||'' order by '';'||chr(10)||
''||chr(10)||
'case :P21_TOP_BY'||chr(10)||
'    when ''CPU_TIME'' then x:=x||'' CPU_TIME '';'||chr(10)||
'    when ''DISK_READS'' then x:=x||'' DISK_READS '';'||chr(10)||
'    when ''BUFFER_GETS'' th';

s:=s||'en x:=x||'' BUFFER_GETS '';'||chr(10)||
'    when ''EXECUTIONS'' then x:=x||'' EXECUTIONS '';'||chr(10)||
'    when ''EFFICIENCY'' then x:=x||'' EFFICIENCY '';'||chr(10)||
'    when ''EFFICIENCY2'' then x:=x||'' EFFICIENCY2 '';'||chr(10)||
'    '||chr(10)||
'else x:=x||'' CPU_TIME '';'||chr(10)||
'end case;'||chr(10)||
''||chr(10)||
''||chr(10)||
'x:=x||''  desc nulls last) '';'||chr(10)||
''||chr(10)||
'wwv_flow.debug(x);'||chr(10)||
''||chr(10)||
'return x;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4508,
  p_name=> 'Top SQL',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 21,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 11028007180514315.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '데이터를 찾을 수 없습니다.',
  p_query_num_rows_item=> 'P21_TOP_N',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '10000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 171388315032544852.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SQL_TEXT',
  p_column_display_sequence=> 16,
  p_column_heading=> 'SQL 텍스트',
  p_column_css_style=>'font-family:monospace;',
  p_column_hit_highlight=>'&P21_SEARCH.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 171388404157544852.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'CPU_TIME',
  p_column_display_sequence=> 5,
  p_column_heading=> 'CPU<br />Time in<br />Seconds',
  p_column_format=> '999G999G999G999G990D000',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 171388519098544852.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'DISK_READS',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Disk<br />Reads',
  p_column_format=> '999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 171388702211544853.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'BUFFER_GETS',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Buffer<br />Gets',
  p_column_format=> '999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 171389222447544853.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'EXECUTIONS',
  p_column_display_sequence=> 9,
  p_column_heading=> '실행',
  p_column_format=> '999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 171460708330609160.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'EFFICIENCY',
  p_column_display_sequence=> 13,
  p_column_heading=> '버퍼 가져오기<br />/처리된<br />행',
  p_column_format=> '999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 189510522012751279.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'EFFICIENCY2',
  p_column_display_sequence=> 14,
  p_column_heading=> '버퍼<br />가져오기/<br />실행',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 171389514740544854.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'CHILD_NUMBER',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Child Number',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 171389602402544854.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'HASH_VALUE',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Hash Value',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 171389730882544854.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'ADDRESS',
  p_column_display_sequence=> 12,
  p_column_heading=> 'Address',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 287415608918139948.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'X',
  p_column_display_sequence=> 1,
  p_column_heading=> '<br />',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 182588111320364025.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'LINK',
  p_column_display_sequence=> 2,
  p_column_heading=> '<br />',
  p_column_link=>'f?p=&APP_ID.:551:&SESSION.::&DEBUG.:551:P551_ADDRESS,P551_HASH_VALUE,P551_CHILD_NUMBER:#ADDRESS#,#HASH_VALUE#,#CHILD_NUMBER#',
  p_column_linktext=>'<img src="#IMAGE_PREFIX#24find.gif" border="0" alt="" width="24" height="24" />',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 189510628385751281.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'ELAPSED_TIME',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Elapsed <br />Time in<br />Seconds',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 193252116724137021.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'THE_TIME',
  p_column_display_sequence=> 3,
  p_column_heading=> '시간<br />(초)',
  p_column_css_style=>'white-space:nowrap;',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 193302526383187173.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'READS',
  p_column_display_sequence=> 6,
  p_column_heading=> '읽기',
  p_column_css_style=>'white-space:nowrap;',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 193326725259205755.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 168892618181554185.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'MODULE',
  p_column_display_sequence=> 15,
  p_column_heading=> '모듈',
  p_column_hit_highlight=>'&P21_MODULE.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 192861814985660446.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4508,
  p_plug_name=> 'Query Parameter Container Line 2',
  p_region_name=>'',
  p_plug_template=> 22867306215341549.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 2,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>160636702055008428.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4508,
  p_branch_action=> 'f?p=&FLOW_ID.:21:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'SQL 텍스트에 대해 대소문자 구분 없이 질의 조건을 입력하십시오.';

wwv_flow_api.create_page_item(
  p_id=>160635519867006875.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4508,
  p_name=>'P21_SEARCH',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 160632704976002525.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'SQL 텍스트',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 15,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'U',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>160636525408008427.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4508,
  p_name=>'P21_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 160632704976002525.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'실행',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'표시할 최대 SQL 문 수를 지정하십시오.';

wwv_flow_api.create_page_item(
  p_id=>161861005551431142.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4508,
  p_name=>'P21_TOP_N',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 19,
  p_item_plug_id => 192861814985660446.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '10',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'최상위 표시',
  p_source=>'10',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_A',
  p_lov => '.'||to_char(88005728392276151 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap" style="padding-left:15px;"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'U',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'보고서 정렬 환경설정을 나타냅니다.';

wwv_flow_api.create_page_item(
  p_id=>171366328266454012.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4508,
  p_name=>'P21_TOP_BY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 17,
  p_item_plug_id => 192861814985660446.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'최상위 기준',
  p_source=>'EFFICIENCY',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'TOP_SQL_BY',
  p_lov => '.'||to_char(236910808625037522 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'U',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'최소한 이 실행 수를 가진 SQL 명령으로 질의를 제한하십시오.';

wwv_flow_api.create_page_item(
  p_id=>180387913498802349.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4508,
  p_name=>'P21_MINIMUM_EXECUTIONS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 12,
  p_item_plug_id => 160632704976002525.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'최소 실행',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 4,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap" style="padding-left:15px;"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'U',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'클라이언트 애플리케이션으로 설정된 모듈을 지정하십시오.';

wwv_flow_api.create_page_item(
  p_id=>192864705765667292.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4508,
  p_name=>'P21_MODULE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 160632704976002525.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'모듈',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP',
  p_lov => 'select distinct module d, module r'||chr(10)||
'  from v$sql',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap" style="padding-left:15px;"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'U',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 238759409305130430.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4508,
  p_computation_sequence => 10,
  p_computation_item=> 'F4500_LAST_VIEW',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '21',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 241565932566286195.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 21.4508,
  p_validation_name => 'P21_MINIMUM_EXECUTIONS',
  p_validation_sequence=> 10,
  p_validation => 'P21_MINIMUM_EXECUTIONS',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => '숫자 값을 입력하십시오.',
  p_associated_item=> 180387913498802349.4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 160637327486009049.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 21.4508,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 21.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_22.45
prompt  ...PAGE 22.4508: 테이블에서 트리거 생성
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph:=ph||'<script language="JavaScript" type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
'function ob_trigTog(pThis){'||chr(10)||
'  var tValue = html_GetElement(pThis);'||chr(10)||
' if(pThis && tValue && tValue.value == ''update of''){'||chr(10)||
'   html_ShowItemRow(''P22_COL_NAME'');'||chr(10)||
' }else{'||chr(10)||
'   html_HideItemRow(''P22_COL_NAME'');'||chr(10)||
' }'||chr(10)||
'}'||chr(10)||
'//-->'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 22.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '테이블에서 트리거 생성',
  p_step_title=> '테이블 수정',
  p_html_page_onload=>'onload="ob_trigTog(''P22_OPT'');"',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 11540120040990569+ wwv_flow_api.g_id_offset,
  p_help_text => '',
  p_html_page_header => ' ',
  p_step_template => 10980707030991881.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164222',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>22.4508,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 145976118207192151.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4508,
  p_plug_name=> '트리거 생성',
  p_region_name=>'',
  p_plug_template=> 140310301493602560.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 07-FEB-2003 18:17:26');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select column_id, COLUMN_NAME,  DATA_TYPE, DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE'||chr(10)||
'from sys.dba_tab_columns'||chr(10)||
'where owner =  :OB_SCHEMA and'||chr(10)||
'table_name= :OBJECT_NAME'||chr(10)||
'order by column_id';

wwv_flow_api.create_report_region (
  p_id=> 145976303508192158.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4508,
  p_name=> '기존 열',
  p_region_name=>'',
  p_template=> 18960127747559478.4508+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 7082409118250737.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '5000',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'P3_TABLE');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145976604515192159.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145976303508192158.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'COLUMN_ID',
  p_column_display_sequence=> 1,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145976702012192159.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145976303508192158.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'COLUMN_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> '열',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145976829673192159.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145976303508192158.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'DATA_TYPE',
  p_column_display_sequence=> 3,
  p_column_heading=> '유형',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145976930838192159.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145976303508192158.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'DATA_LENGTH',
  p_column_display_sequence=> 4,
  p_column_heading=> '길이',
  p_column_format=> '999G999G990',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145977001770192159.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145976303508192158.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'DATA_PRECISION',
  p_column_display_sequence=> 5,
  p_column_heading=> '전체 자릿수',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145977111250192159.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145976303508192158.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'DATA_SCALE',
  p_column_display_sequence=> 6,
  p_column_heading=> '소수점 이하 자릿수',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145976527242192158.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145976303508192158.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'NULLABLE',
  p_column_display_sequence=> 7,
  p_column_heading=> '널',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select owner,'||chr(10)||
'       trigger_name, '||chr(10)||
'       table_owner,'||chr(10)||
'       TABLE_NAME,'||chr(10)||
'       BASE_OBJECT_TYPE,'||chr(10)||
'       TRIGGER_TYPE,'||chr(10)||
'       TRIGGERING_EVENT,'||chr(10)||
'       WHEN_CLAUSE,'||chr(10)||
'       ACTION_TYPE,'||chr(10)||
'       status,'||chr(10)||
'       TRIGGER_BODY'||chr(10)||
'from sys.dba_triggers t'||chr(10)||
'where t.table_name = :OBJECT_NAME'||chr(10)||
'and t.table_owner = :OB_SCHEMA'||chr(10)||
'order by t.trigger_name';

wwv_flow_api.create_report_region (
  p_id=> 145977220168192159.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4508,
  p_name=> '기존 트리거',
  p_region_name=>'',
  p_template=> 18960127747559478.4508+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 40,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 7082409118250737.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '5000',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145977426744192160.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145977220168192159.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'OWNER',
  p_column_display_sequence=> 1,
  p_column_heading=> '트리거 스키마',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145977503608192160.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145977220168192159.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'TRIGGER_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> '이름',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145977601226192160.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145977220168192159.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'TABLE_OWNER',
  p_column_display_sequence=> 3,
  p_column_heading=> '테이블 스키마',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145977702975192160.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145977220168192159.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'TABLE_NAME',
  p_column_display_sequence=> 4,
  p_column_heading=> '테이블 이름',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145977826663192160.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145977220168192159.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'BASE_OBJECT_TYPE',
  p_column_display_sequence=> 5,
  p_column_heading=> '기본 객체',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145977913239192160.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145977220168192159.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'TRIGGER_TYPE',
  p_column_display_sequence=> 6,
  p_column_heading=> '유형',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145978018767192161.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145977220168192159.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'TRIGGERING_EVENT',
  p_column_display_sequence=> 7,
  p_column_heading=> '이벤트',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145978119250192161.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145977220168192159.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'WHEN_CLAUSE',
  p_column_display_sequence=> 8,
  p_column_heading=> '시기',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145978208812192161.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145977220168192159.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'ACTION_TYPE',
  p_column_display_sequence=> 9,
  p_column_heading=> '작업',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145978308909192161.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145977220168192159.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'STATUS',
  p_column_display_sequence=> 10,
  p_column_heading=> '상태',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 145978410713192161.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 145977220168192159.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'TRIGGER_BODY',
  p_column_display_sequence=> 11,
  p_column_heading=> '본문',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 145978527031192162.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 22.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 145976118207192151+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:IFRAME_CANCEL:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 145978726604192172.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 22.4508,
  p_button_sequence=> 30,
  p_button_plug_id => 145976118207192151+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '다음 &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>145986020520192238.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_branch_action=> 'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 23-FEB-2005 17:41 by SYME');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'데이터베이스 스키마 소유자의 이름';

wwv_flow_api.create_page_item(
  p_id=>145979118524192174.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_name=>'P22_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 145976118207192151.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => '&OB_SCHEMA.',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'스키마:',
  p_source=>'OB_SCHEMA',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'트리거를 생성할 테이블 이름';

wwv_flow_api.create_page_item(
  p_id=>145979622996192189.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_name=>'P22_TABLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 145976118207192151.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => ':OBJECT_NAME',
  p_item_default_type => 'PLSQL_EXPRESSION',
  p_prompt=>'테이블:',
  p_source=>':OBJECT_NAME',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>145980124785192190.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_name=>'P22_X',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 145976118207192151.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'STOP_AND_START_HTML_TABLE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'생성할 트리거 이름 입력';

wwv_flow_api.create_page_item(
  p_id=>145980304034192191.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_name=>'P22_TRIGGER_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 145976118207192151.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => '&OBJECT_NAME._T1',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'트리거 이름',
  p_source=>'&OBJECT_NAME._T1',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 50,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301625476864638.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>145980820441192192.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_name=>'P22_PRESERVE_CASE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 45,
  p_item_plug_id => 145976118207192151.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'PRESERVE.CASE.Y',
  p_lov => '.'||to_char(88034811582507798 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'트리거 실행 시기 지정';

wwv_flow_api.create_page_item(
  p_id=>145981011748192192.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_name=>'P22_BEFORE_OR_AFTER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 145976118207192151.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'BEFORE',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'실행 지점:',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'STATIC:BEFORE;BEFORE,AFTER;AFTER',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301625476864638.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'트리거가 실행되도록 할 작업 지정';

wwv_flow_api.create_page_item(
  p_id=>145981502751192193.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_name=>'P22_OPT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 145976118207192151.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'insert, update, delete',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'옵션:',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'STATIC(~,*):delete*delete~delete, insert*delete, insert~insert*insert~insert, update*insert, update~insert, update, delete*insert, update, delete~update*update~update, delete*update, delete~update of *update of',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_tag_attributes  => 'onchange="ob_trigTog(this)"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301625476864638.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'트리거를 생성할 테이블 이름';

wwv_flow_api.create_page_item(
  p_id=>145982021984192195.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_name=>'P22_TNAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 145976118207192151.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => ':OBJECT_NAME',
  p_item_default_type => 'PLSQL_EXPRESSION',
  p_prompt=>'시간:',
  p_source=>':OBJECT_NAME',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'트리거 이름에 대한 대소문자 유지 여부 지정';

wwv_flow_api.create_page_item(
  p_id=>145982428529192205.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_name=>'P22_PROCESSED',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 145976118207192151.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'for each row',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'&nbsp;',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'FOR.EACH.ROW',
  p_lov => '.'||to_char(88058923955804681 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => 'Generated 07-FEB-2003 18:17:26');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>145982927609192206.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_name=>'P22_X2',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 85,
  p_item_plug_id => 145976118207192151.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'STOP_AND_START_HTML_TABLE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'트리거에 대한 PL/SQL 본문 입력';

wwv_flow_api.create_page_item(
  p_id=>145983109397192207.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_name=>'P22_TEXT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 145976118207192151.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'트리거 본문:',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> null,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- 열 선택 -',
  p_lov_null_value=> '0',
  p_cSize=> 70,
  p_cMaxlength=> 2000,
  p_cHeight=> 12,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 3,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301625476864638.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => 'Generated 07-FEB-2003 18:17:26');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'''갱신'' 트리거 유형을 선택할 경우 열을 선택해야 합니다.';

wwv_flow_api.create_page_item(
  p_id=>145983610662192207.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_name=>'P22_COL_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 65,
  p_item_plug_id => 145976118207192151.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'열',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'select htf.escape_sc(column_name) d, column_name r from sys.dba_tab_columns where table_name = :P22_TABLE AND OWNER = :OB_SCHEMA',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- 선택 -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301625476864638.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>'||chr(10)||
'트리거에 대해 적합한 when 절을 입력하십시오. 다음과 같이 참조를 사용할 수도 있습니다.'||chr(10)||
'</p>'||chr(10)||
'<p>'||chr(10)||
'NEW.deptno > 5'||chr(10)||
'</p>'||chr(10)||
'<p>'||chr(10)||
'when 절에는 :NEW 구문이 사용되지 않습니다.'||chr(10)||
'</p>';

wwv_flow_api.create_page_item(
  p_id=>145984121881192208.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_name=>'P22_WHEN',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 82,
  p_item_plug_id => 145976118207192151.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'시기',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 50,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 145984621119192219.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_computation_sequence => 5,
  p_computation_item=> 'P22_TRIGGER_NAME',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'upper(replace(:P22_TRIGGER_NAME,chr(32),''_''))',
  p_compute_when => 'P22_PRESERVE_CASE',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 145984800715192227.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4508,
  p_computation_sequence => 10,
  p_computation_item=> 'P25_SQL',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'declare'||chr(10)||
't_name varchar2(2000);'||chr(10)||
'begin'||chr(10)||
' if :P22_PRESERVE_CASE = ''Y'' then'||chr(10)||
'   t_name := :P22_TRIGGER_NAME;'||chr(10)||
' else'||chr(10)||
'   t_name := upper(:P22_TRIGGER_NAME);'||chr(10)||
' end if;'||chr(10)||
'return wwv_flow_sw_util.get_trigger2_ddl('||chr(10)||
'         p_table_name => :OBJECT_NAME,'||chr(10)||
'         p_action     => ''create or replace'','||chr(10)||
'         p_trigger_nm => t_name,'||chr(10)||
'         p_when       => :P22_BEFORE_OR_AFTER,'||chr(10)||
'         p_operations => replace(:P22_OPT,'','','' or''),'||chr(10)||
'         p_for_each   => :P22_PROCESSED,'||chr(10)||
'         p_body       => :P22_TEXT,'||chr(10)||
'         p_col        => :P22_COL_NAME,'||chr(10)||
'         p_col_when   => :P22_WHEN );'||chr(10)||
'end;',
  p_computation_comment=> 'declare q varchar2(32767);'||chr(10)||
'begin'||chr(10)||
'   q := ''create or replace trigger ''||:P84_TRIGGER_NAME||chr(10);'||chr(10)||
'   q := q||:P84_BEFORE_OR_AFTER||'' ''||replace(:P84_OPT,'','','' or'')||'||chr(10)||
'        '' on ''||:p57_TABLE||chr(10);'||chr(10)||
'   q := q||:P84_PROCESSED||chr(10);'||chr(10)||
'   q := q||''begin''||chr(10)||:P84_TEXT||chr(10)||''end;''||chr(10)||''/'';   '||chr(10)||
'   return q;'||chr(10)||
'end;',
  p_computation_error_message => '인덱스 생성 SQL 구문을 작성할 수 없습니다.',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 145985004479192229.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 22.4508,
  p_validation_name => 'TriggerNameMand',
  p_validation_sequence=> 10,
  p_validation => 'P22_TRIGGER_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '트리거 이름을 지정해야 합니다.',
  p_associated_item=> 145980304034192191.4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 145985207924192235.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 22.4508,
  p_validation_name => 'TriggerTextMand',
  p_validation_sequence=> 20,
  p_validation => 'P22_TEXT',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '트리거 본문을 지정해야 합니다.',
  p_associated_item=> 145983109397192207.4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 145985424382192236.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 22.4508,
  p_validation_name => 'reserved name',
  p_validation_sequence=> 30,
  p_validation => 'if wwv_flow_sw_util.is_database_reserved_word(p_word=>:P22_TRIGGER_NAME) then'||chr(10)||
'  return false;'||chr(10)||
'else'||chr(10)||
'  return true;'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '지정된 트리거 이름은 Oracle 예약어입니다. 다른 이름을 선택하십시오.',
  p_associated_item=> .4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 145985608174192236.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 22.4508,
  p_validation_name => 'Unique trigger name',
  p_validation_sequence=> 40,
  p_validation => 'select 1 from sys.dba_triggers where trigger_name = :P22_TRIGGER_NAME',
  p_validation_type => 'NOT_EXISTS',
  p_error_message => '이미 사용된 트리거 이름입니다.',
  p_when_button_pressed=> 145978726604192172.4508 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 145985830826192237.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 22.4508,
  p_validation_name => 'valid update of and column name',
  p_validation_sequence=> 50,
  p_validation => 'if :p22_opt = ''update of'' and :p22_col_name = ''0'' then'||chr(10)||
'  return false;'||chr(10)||
'else'||chr(10)||
'  return true;'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '"갱신" 트리거의 경우 열을 선택해야 합니다.',
  p_when_button_pressed=> 145978726604192172.4508 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 22.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_23.45
prompt  ...PAGE 23.4508: query builder 결과
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 23.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'query builder 결과',
  p_step_title=> 'query builder 결과',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 14599108081253832.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164222',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare '||chr(10)||
'  l_sql varchar2(32000) := :P1002_QUERY;'||chr(10)||
'begin'||chr(10)||
'wwv_flow.g_flow_owner := wwv_flow_security.g_parse_as_schema;'||chr(10)||
'wwv_flow_query_builder.check_priv (p_schema => :P1002_SCHEMA);'||chr(10)||
'wwv_flow_security.g_parse_as_schema := :P1002_SCHEMA;'||chr(10)||
'return l_sql;'||chr(10)||
'end; ';

wwv_flow_api.create_report_region (
  p_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4508,
  p_name=> 'results',
  p_region_name=>'',
  p_template=> 12270828624874231.4508+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'RT',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 11028007180514315.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'QUERY_COLUMNS',
  p_query_num_rows=> '15',
  p_query_options=> 'GENERIC_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '데이터를 찾을 수 없습니다.',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> '다운로드',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_exp_filename=> 'Results.csv',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4348623393330557.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'COL01',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Col01',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4348732177330557.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'COL02',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Col02',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4348819176330557.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'COL03',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Col03',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4348911783330557.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'COL04',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Col04',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4349009268330557.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'COL05',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Col05',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4349101121330558.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'COL06',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Col06',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4349218228330558.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'COL07',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Col07',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4349303988330558.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'COL08',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Col08',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4349424164330558.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'COL09',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Col09',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4349532076330558.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'COL10',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Col10',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4349605066330558.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'COL11',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Col11',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4349732439330558.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'COL12',
  p_column_display_sequence=> 12,
  p_column_heading=> 'Col12',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4349801732330558.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'COL13',
  p_column_display_sequence=> 13,
  p_column_heading=> 'Col13',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4349928913330558.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'COL14',
  p_column_display_sequence=> 14,
  p_column_heading=> 'Col14',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4350005849330559.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'COL15',
  p_column_display_sequence=> 15,
  p_column_heading=> 'Col15',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4350116939330559.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'COL16',
  p_column_display_sequence=> 16,
  p_column_heading=> 'Col16',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4350207886330559.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'COL17',
  p_column_display_sequence=> 17,
  p_column_heading=> 'Col17',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4350303267330559.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 18,
  p_form_element_id=> null,
  p_column_alias=> 'COL18',
  p_column_display_sequence=> 18,
  p_column_heading=> 'Col18',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4350418593330559.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 19,
  p_form_element_id=> null,
  p_column_alias=> 'COL19',
  p_column_display_sequence=> 19,
  p_column_heading=> 'Col19',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4350508128330559.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 20,
  p_form_element_id=> null,
  p_column_alias=> 'COL20',
  p_column_display_sequence=> 20,
  p_column_heading=> 'Col20',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4350601606330559.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 21,
  p_form_element_id=> null,
  p_column_alias=> 'COL21',
  p_column_display_sequence=> 21,
  p_column_heading=> 'Col21',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4350714454330559.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 22,
  p_form_element_id=> null,
  p_column_alias=> 'COL22',
  p_column_display_sequence=> 22,
  p_column_heading=> 'Col22',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4350817456330559.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 23,
  p_form_element_id=> null,
  p_column_alias=> 'COL23',
  p_column_display_sequence=> 23,
  p_column_heading=> 'Col23',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4350906976330560.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 24,
  p_form_element_id=> null,
  p_column_alias=> 'COL24',
  p_column_display_sequence=> 24,
  p_column_heading=> 'Col24',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4351027155330560.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 25,
  p_form_element_id=> null,
  p_column_alias=> 'COL25',
  p_column_display_sequence=> 25,
  p_column_heading=> 'Col25',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4351104489330560.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 26,
  p_form_element_id=> null,
  p_column_alias=> 'COL26',
  p_column_display_sequence=> 26,
  p_column_heading=> 'Col26',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4351200861330560.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 27,
  p_form_element_id=> null,
  p_column_alias=> 'COL27',
  p_column_display_sequence=> 27,
  p_column_heading=> 'Col27',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4351310658330560.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 28,
  p_form_element_id=> null,
  p_column_alias=> 'COL28',
  p_column_display_sequence=> 28,
  p_column_heading=> 'Col28',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4351417497330560.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 29,
  p_form_element_id=> null,
  p_column_alias=> 'COL29',
  p_column_display_sequence=> 29,
  p_column_heading=> 'Col29',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4351530996330560.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 30,
  p_form_element_id=> null,
  p_column_alias=> 'COL30',
  p_column_display_sequence=> 30,
  p_column_heading=> 'Col30',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4345606818330554.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 31,
  p_form_element_id=> null,
  p_column_alias=> 'COL31',
  p_column_display_sequence=> 31,
  p_column_heading=> 'Col31',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4345709023330554.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 32,
  p_form_element_id=> null,
  p_column_alias=> 'COL32',
  p_column_display_sequence=> 32,
  p_column_heading=> 'Col32',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4345812127330554.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 33,
  p_form_element_id=> null,
  p_column_alias=> 'COL33',
  p_column_display_sequence=> 33,
  p_column_heading=> 'Col33',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4345917382330554.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 34,
  p_form_element_id=> null,
  p_column_alias=> 'COL34',
  p_column_display_sequence=> 34,
  p_column_heading=> 'Col34',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4346028532330554.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 35,
  p_form_element_id=> null,
  p_column_alias=> 'COL35',
  p_column_display_sequence=> 35,
  p_column_heading=> 'Col35',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4346124612330554.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 36,
  p_form_element_id=> null,
  p_column_alias=> 'COL36',
  p_column_display_sequence=> 36,
  p_column_heading=> 'Col36',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4346213755330554.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 37,
  p_form_element_id=> null,
  p_column_alias=> 'COL37',
  p_column_display_sequence=> 37,
  p_column_heading=> 'Col37',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4346314733330554.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 38,
  p_form_element_id=> null,
  p_column_alias=> 'COL38',
  p_column_display_sequence=> 38,
  p_column_heading=> 'Col38',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4346413799330555.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 39,
  p_form_element_id=> null,
  p_column_alias=> 'COL39',
  p_column_display_sequence=> 39,
  p_column_heading=> 'Col39',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4346503891330555.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 40,
  p_form_element_id=> null,
  p_column_alias=> 'COL40',
  p_column_display_sequence=> 40,
  p_column_heading=> 'Col40',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4346601482330555.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 41,
  p_form_element_id=> null,
  p_column_alias=> 'COL41',
  p_column_display_sequence=> 41,
  p_column_heading=> 'Col41',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4346727710330555.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 42,
  p_form_element_id=> null,
  p_column_alias=> 'COL42',
  p_column_display_sequence=> 42,
  p_column_heading=> 'Col42',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4346828687330555.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 43,
  p_form_element_id=> null,
  p_column_alias=> 'COL43',
  p_column_display_sequence=> 43,
  p_column_heading=> 'Col43',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4346920935330555.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 44,
  p_form_element_id=> null,
  p_column_alias=> 'COL44',
  p_column_display_sequence=> 44,
  p_column_heading=> 'Col44',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4347001983330555.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 45,
  p_form_element_id=> null,
  p_column_alias=> 'COL45',
  p_column_display_sequence=> 45,
  p_column_heading=> 'Col45',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4347116666330555.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 46,
  p_form_element_id=> null,
  p_column_alias=> 'COL46',
  p_column_display_sequence=> 46,
  p_column_heading=> 'Col46',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4347208498330555.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 47,
  p_form_element_id=> null,
  p_column_alias=> 'COL47',
  p_column_display_sequence=> 47,
  p_column_heading=> 'Col47',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4347302539330555.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 48,
  p_form_element_id=> null,
  p_column_alias=> 'COL48',
  p_column_display_sequence=> 48,
  p_column_heading=> 'Col48',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4347422580330556.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 49,
  p_form_element_id=> null,
  p_column_alias=> 'COL49',
  p_column_display_sequence=> 49,
  p_column_heading=> 'Col49',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4347527682330556.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 50,
  p_form_element_id=> null,
  p_column_alias=> 'COL50',
  p_column_display_sequence=> 50,
  p_column_heading=> 'Col50',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4347629829330556.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 51,
  p_form_element_id=> null,
  p_column_alias=> 'COL51',
  p_column_display_sequence=> 51,
  p_column_heading=> 'Col51',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4347710057330556.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 52,
  p_form_element_id=> null,
  p_column_alias=> 'COL52',
  p_column_display_sequence=> 52,
  p_column_heading=> 'Col52',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4347807428330556.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 53,
  p_form_element_id=> null,
  p_column_alias=> 'COL53',
  p_column_display_sequence=> 53,
  p_column_heading=> 'Col53',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4347902500330556.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 54,
  p_form_element_id=> null,
  p_column_alias=> 'COL54',
  p_column_display_sequence=> 54,
  p_column_heading=> 'Col54',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4348012066330556.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 55,
  p_form_element_id=> null,
  p_column_alias=> 'COL55',
  p_column_display_sequence=> 55,
  p_column_heading=> 'Col55',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4348102133330556.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 56,
  p_form_element_id=> null,
  p_column_alias=> 'COL56',
  p_column_display_sequence=> 56,
  p_column_heading=> 'Col56',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4348202924330557.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 57,
  p_form_element_id=> null,
  p_column_alias=> 'COL57',
  p_column_display_sequence=> 57,
  p_column_heading=> 'Col57',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4348327301330557.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 58,
  p_form_element_id=> null,
  p_column_alias=> 'COL58',
  p_column_display_sequence=> 58,
  p_column_heading=> 'Col58',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4348402381330557.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 59,
  p_form_element_id=> null,
  p_column_alias=> 'COL59',
  p_column_display_sequence=> 59,
  p_column_heading=> 'Col59',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 4348515291330557.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 4345425019330550.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 60,
  p_form_element_id=> null,
  p_column_alias=> 'COL60',
  p_column_display_sequence=> 60,
  p_column_heading=> 'Col60',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'wwv_flow_security.g_parse_as_schema := wwv_flow.g_flow_owner;';

wwv_flow_api.create_page_plug (
  p_id=> 4353017532337858.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4508,
  p_plug_name=> 'reset parse schema',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'NEVER',
  p_plug_display_when_condition => 'RT',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 23.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_24.45
prompt  ...PAGE 24.4508: 테이블 검색기
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/wrkshp_table_finder.htm';

ph:=ph||'<script type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
'function p24_SaveBack(){'||chr(10)||
'var lValue = opener.$x(''P1003_SQL_COMMAND1'').value + ''\n\n'' + $x(''qReturn'').value;'||chr(10)||
'$x_Value(opener.$x(''P1003_SQL_COMMAND1''),lValue);'||chr(10)||
'window.close();'||chr(10)||
'}'||chr(10)||
'var p24TabTest = false;'||chr(10)||
'function p24_Init(){'||chr(10)||
'if(p24TabTest){'||chr(10)||
'$d_TabClick(''columntab'',''columnreport'',''tabcurrent'',p24Tabs)'||chr(10)||
'}else{'||chr(10)||
'$d_TabClick(''tabletab'',''tablereport'',''tabcurrent'',p24Tabs)';

ph:=ph||''||chr(10)||
'}'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'var p24Tabs = [''tabletab'',''columntab''];'||chr(10)||
'//-->'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 24.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '테이블 검색기',
  p_step_title=> '테이블 검색기',
  p_html_page_onload=>'onload="p24_Init()"',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => 102479827851590823.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164223',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>24.4508,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>24.4508,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 12117026009139651.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4508,
  p_plug_name=> '단추 모음',
  p_region_name=>'',
  p_plug_template=> 106954406499588564.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 7,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BEFORE_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select object_id, table_name, num_rows, '||chr(10)||
'       t.last_analyzed, ''TABLE'' object_type'||chr(10)||
'from sys.dba_tables t, sys.dba_objects o, (select wwv_flow_user_api.get_default_schema s from dual) d'||chr(10)||
'where o.object_name = t.table_name'||chr(10)||
'and   o.object_type = ''TABLE'''||chr(10)||
'and  (instr(t.table_name,upper(:P24_FIND)) > 0 OR :P24_FIND IS NULL) '||chr(10)||
'and   t.owner = nvl(:P1003_SCHEMA,d.s)'||chr(10)||
'and   o.owner=nvl(:P1003_SCHEMA,d.s)'||chr(10)||
'un';

s:=s||'ion all'||chr(10)||
'select object_id, view_name table_name, null num_rows, '||chr(10)||
'       null last_analyzed, ''VIEW'' object_type'||chr(10)||
'from sys.dba_views v, sys.dba_objects o'||chr(10)||
'where o.object_name = v.view_name'||chr(10)||
'and   o.object_type = ''VIEW'''||chr(10)||
'and  (instr(v.view_name,upper(:P24_FIND)) > 0 OR :P24_FIND IS NULL) '||chr(10)||
'and   v.owner = :P1003_SCHEMA'||chr(10)||
'and   o.owner =:P1003_SCHEMA'||chr(10)||
'and   :P24_INCLUDE_VIEWS = ''YES''';

wwv_flow_api.create_report_region (
  p_id=> 12183729610626245.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4508,
  p_name=> 'Tables',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<div id="tablereport">',
  p_footer=> '</div>',
  p_customized=> '0',
  p_query_row_template=> 11028007180514315.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '데이터를 찾을 수 없습니다.',
  p_query_num_rows_item=> 'P24_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '20000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12184028410626250.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 12183729610626245.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'OBJECT_ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Object Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12184115287626250.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 12183729610626245.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'TABLE_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> '테이블 이름',
  p_column_link=>'f?p=&APP_ID.:24:&SESSION.:&REQUEST.:&DEBUG.::P24_TABLE_NAME:#TABLE_NAME#',
  p_column_linktext=>'#TABLE_NAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12184223295626250.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 12183729610626245.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'NUM_ROWS',
  p_column_display_sequence=> 3,
  p_column_heading=> '행',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 40945525348156654.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 12183729610626245.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'LAST_ANALYZED',
  p_column_display_sequence=> 4,
  p_column_heading=> '마지막 분석 날짜',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12184404832626251.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 12183729610626245.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'OBJECT_TYPE',
  p_column_display_sequence=> 5,
  p_column_heading=> '유형',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select column_name, data_type, data_length, data_precision, data_scale, NULLABLE'||chr(10)||
'from sys.DBA_TAB_COLUMNS c'||chr(10)||
'where table_name = :p24_table_name and'||chr(10)||
'    c.owner = :P1003_SCHEMA'||chr(10)||
'order by column_id';

wwv_flow_api.create_report_region (
  p_id=> 12243208082566182.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4508,
  p_name=> 'Columns',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'P24_TABLE_NAME',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 11028007180514315.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '150000',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '데이터를 찾을 수 없습니다.',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '150000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12" alt=""',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12243500051566185.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 12243208082566182.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'COLUMN_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> '열',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12243616112566185.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 12243208082566182.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'DATA_TYPE',
  p_column_display_sequence=> 2,
  p_column_heading=> '데이터 유형',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12243703595566185.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 12243208082566182.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'DATA_LENGTH',
  p_column_display_sequence=> 3,
  p_column_heading=> '길이',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12243817097566185.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 12243208082566182.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'DATA_PRECISION',
  p_column_display_sequence=> 4,
  p_column_heading=> '전체 자릿수',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12243901714566185.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 12243208082566182.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'DATA_SCALE',
  p_column_display_sequence=> 5,
  p_column_heading=> '소수점 이하 자릿수',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 40969229915337787.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 12243208082566182.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'NULLABLE',
  p_column_display_sequence=> 6,
  p_column_heading=> '널 가능',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>23482928300634173 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare '||chr(10)||
'q2 varchar2(32767);'||chr(10)||
'begin'||chr(10)||
'q2 := ''select ''||chr(10);'||chr(10)||
'for c1 in ('||chr(10)||
'select column_name'||chr(10)||
'from sys.dba_TAB_COLUMNS c'||chr(10)||
'where table_name = :P24_TABLE_NAME and'||chr(10)||
'    c.owner = :P1003_SCHEMA'||chr(10)||
'order by column_id) loop'||chr(10)||
'q2 := q2 ||'' ''||htf.escape_sc(c1.column_name)||'',''||chr(10);'||chr(10)||
'end loop;'||chr(10)||
'q2 := rtrim(rtrim(q2,chr(10)),'','')||chr(10)||'' from ''||:P24_TABLE_NAME||chr(10);'||chr(10)||
'htp.p(''<textarea id="qReturn" style="';

s:=s||'width:100%;height:200px;">''||q2||''</textarea>'');'||chr(10)||
'end;'||chr(10)||
'';

wwv_flow_api.create_page_plug (
  p_id=> 12257807960632350.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4508,
  p_plug_name=> 'Select View',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'ITEM_IS_NOT_NULL',
  p_plug_display_when_condition => 'P24_TABLE_NAME',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'wwv_flow_f4000_util.show_help_link ('||chr(10)||
'   p_lang           => ''en-us'','||chr(10)||
'   p_session_id     => :app_session,'||chr(10)||
'   p_application_id => 4500,'||chr(10)||
'   p_page_id        => wwv_flow.g_flow_step_id);';

wwv_flow_api.create_page_plug (
  p_id=> 89358232213812453.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4508,
  p_plug_name=> 'Help',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 5,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BEFORE_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<div>';

wwv_flow_api.create_page_plug (
  p_id=> 98328429053791328.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4508,
  p_plug_name=> 'Open Div',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Error displaying region',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<div id="tables">',
  p_plug_footer=> '</div>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'</div>';

wwv_flow_api.create_page_plug (
  p_id=> 98328622929791328.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4508,
  p_plug_name=> 'Close Div',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 2000,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Error displaying region',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'98332317887807047';

wwv_flow_api.create_page_plug (
  p_id=> 98334600702811560.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4508,
  p_plug_name=> 'Region_Tabs',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 98332317887807047 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<script type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
'var p24TabTest = true;'||chr(10)||
'//-->'||chr(10)||
'</script>';

wwv_flow_api.create_page_plug (
  p_id=> 98338412608824440.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4508,
  p_plug_name=> 'js',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 0,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'BEFORE_FOOTER',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'ITEM_IS_NOT_NULL',
  p_plug_display_when_condition => 'P24_TABLE_NAME',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<div id="columnreport" style="display:none;">';

wwv_flow_api.create_page_plug (
  p_id=> 98339511354833599.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4508,
  p_plug_name=> 'Sub Div Open',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 29,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Error displaying region',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'</div>';

wwv_flow_api.create_page_plug (
  p_id=> 98339730224833600.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4508,
  p_plug_name=> 'Sub Div Close',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Error displaying region',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'htp.p(''<br /><input value="''||wwv_flow_lang.system_message(''SQL_REPORT_WIZ.RETURN_VALUE'')||''" type="button" onclick="p24_SaveBack()"/>'');';

wwv_flow_api.create_page_plug (
  p_id=> 98520530596378377.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4508,
  p_plug_name=> 'Save to Worksheet',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 45,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_plug_display_when_condition => 'P24_STATE',
  p_plug_display_when_cond2=>'SC',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 142868013283899762.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4508,
  p_plug_name=> 'Hidden Items',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 0,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_header=> '<div style="display:none;">',
  p_plug_footer=> '</div>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 12226604666243469.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 24.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 12117026009139651+wwv_flow_api.g_id_offset,
  p_button_name    => 'CLOSE',
  p_button_image_alt=> '닫기',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:window.close();',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>12166725687262782.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4508,
  p_branch_action=> 'f?p=&APP_ID.:24:&SESSION.:&REQUEST.:&DEBUG.::p24_table_name:',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'질의 조건을 입력하고 <b>실행</b>을 누르십시오.';

wwv_flow_api.create_page_item(
  p_id=>12165709394260825.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4508,
  p_name=>'P24_FIND',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 12117026009139651.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'검색',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 15,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>12166516320262781.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4508,
  p_name=>'P24_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 12117026009139651.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'실행',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'뷰를 포함시키려면 선택하십시오.';

wwv_flow_api.create_page_item(
  p_id=>12182711818611559.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4508,
  p_name=>'P24_INCLUDE_VIEWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 12117026009139651.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_post_element_text=>'&nbsp;&nbsp;',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'CHECKBOX FOR VIEWS',
  p_lov => '.'||to_char(12319218872723617 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'SQL 질의에 대해 표시할 최대 결과 행 수를 결정합니다.';

wwv_flow_api.create_page_item(
  p_id=>12221908775216250.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4508,
  p_name=>'P24_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 17,
  p_item_plug_id => 12117026009139651.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'행',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_A',
  p_lov => '.'||to_char(88005728392276151 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'선택한 테이블 이름을 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>12244614315567983.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4508,
  p_name=>'P24_TABLE_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 12243208082566182.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'테이블:',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_AND_SAVE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'선택한 스키마를 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>14003528650686435.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4508,
  p_name=>'P24_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 16,
  p_item_plug_id => 12117026009139651.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'스키마:',
  p_post_element_text=>'&nbsp;',
  p_source=>'&P1003_SCHEMA.',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 15,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>142872704756906673.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4508,
  p_name=>'P24_STATE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 142868013283899762.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 12253126483599912.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 24.4508,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>12166516320262781.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':P1003_SCHEMA := :P2001_FEED_OWNER;';

wwv_flow_api.create_page_process(
  p_id     => 77533228440026331.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 24.4508,
  p_process_sequence=> 1,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'POPUP FROM OB',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'OB',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:P1003_SCHEMA);';

wwv_flow_api.create_page_process(
  p_id     => 12215629460165530.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 24.4508,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'validate schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'P1003_SCHEMA',
  p_process_when_type=>'ITEM_IS_NOT_NULL',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 24.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_25.45
prompt  ...PAGE 25.4508: 트리거 생성 확인
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph:=ph||'<script language="JavaScript" type="text/javascript">'||chr(10)||
'    function showDDL(){'||chr(10)||
'        theDDL = document.getElementById(''P67_SQL'');'||chr(10)||
'        showDiv = document.getElementById(''ddlShow'');'||chr(10)||
'        hideDiv = document.getElementById(''ddlHide'');'||chr(10)||
'        hideDiv.style.display = ''inline'';'||chr(10)||
'        theDDL.style.display = ''inline'';'||chr(10)||
'        showDiv.style.display = ''none'';'||chr(10)||
'        }'||chr(10)||
'        '||chr(10)||
'    function hideDD';

ph:=ph||'L(){'||chr(10)||
'        theDDL = document.getElementById(''P67_SQL'');'||chr(10)||
'        showDiv = document.getElementById(''ddlShow'');'||chr(10)||
'        hideDiv = document.getElementById(''ddlHide'');'||chr(10)||
'        hideDiv.style.display = ''none'';'||chr(10)||
'        theDDL.style.display = ''none'';'||chr(10)||
'        showDiv.style.display = ''inline'';'||chr(10)||
'        }'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 25.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '트리거 생성 확인',
  p_step_title=> '테이블 변경 확인',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => ' ',
  p_step_template => 10980707030991881.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164223',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>25.4508,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 146000726976226026.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25.4508,
  p_plug_name=> '요청 내용을 확인하십시오. ',
  p_region_name=>'',
  p_plug_template=> 140310301493602560.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated 07-FEB-2003 18:17:26');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 146000925307226031.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25.4508,
  p_plug_name=> 'SQL',
  p_region_name=>'',
  p_plug_template=> 18960127747559478.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 146001104570226032.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 146000726976226026+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&F4500_LAST_VIEW.:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 146001305874226033.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25.4508,
  p_button_sequence=> 30,
  p_button_plug_id => 146000726976226026+wwv_flow_api.g_id_offset,
  p_button_name    => 'FINISH',
  p_button_image_alt=> '완료',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 146001515089226033.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25.4508,
  p_button_sequence=> 20,
  p_button_plug_id => 146000726976226026+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>146004027881226041.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4508,
  p_branch_action=> 'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>146001305874226033.4508+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 24-FEB-2005 21:02 by SYME');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'선택한 테이블을 소유하는 데이터베이스 스키마를 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>146001707896226033.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4508,
  p_name=>'P25_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 146000726976226026.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'스키마:',
  p_source=>'OB_SCHEMA',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'테이블에서 수행될 작업 유형을 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>146002221454226035.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4508,
  p_name=>'P25_ACTION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 3,
  p_item_plug_id => 146000726976226026.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'작업:',
  p_source=>'Create trigger &P22_TRIGGER_NAME.',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>146002702523226036.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4508,
  p_name=>'P25_SQL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 146000925307226031.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 70,
  p_cMaxlength=> 2000,
  p_cHeight=> 15,
  p_tag_attributes  => 'readonly="readonly"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => 'Generated 07-FEB-2003 18:17:26');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'선택된 테이블의 이름을 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>146002904793226037.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4508,
  p_name=>'P25_TABLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 146000726976226026.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'객체:',
  p_source=>'OBJECT_NAME',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv ('||chr(10)||
'    p_schema => upper(:OB_SCHEMA)'||chr(10)||
'    );';

wwv_flow_api.create_page_process(
  p_id     => 146003421234226039.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25.4508,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Check privs',
  p_process_sql_clob => p, 
  p_process_error_message=> '&P56_SCHEMA.에 대한 권한이 없습니다.',
  p_process_when_button_id=>146001305874226033.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':P26_MSG := wwv_flow_sw_util.run_other_sql('||chr(10)||
'              p_schema     => upper(:OB_SCHEMA),'||chr(10)||
'              p_sql        => :P25_SQL );'||chr(10)||
''||chr(10)||
'for c in (select object_id from sys.dba_objects '||chr(10)||
'           where object_name = :P22_TRIGGER_NAME and owner = :OB_SCHEMA and'||chr(10)||
'          object_type = ''TRIGGER'') loop'||chr(10)||
'  :object_id := c.object_id;'||chr(10)||
'  :object_type := ''TRIGGER'';'||chr(10)||
'end loop;';

wwv_flow_api.create_page_process(
  p_id     => 146003628078226039.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25.4508,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'run DDL',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>146001305874226033.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.save_history ('||chr(10)||
'    p_security_group_id => :flow_security_group_id ,'||chr(10)||
'    p_user              => :flow_user,'||chr(10)||
'    p_sql_cmd           => :P25_SQL,'||chr(10)||
'    p_schema            => upper(:OB_SCHEMA)'||chr(10)||
'    );';

wwv_flow_api.create_page_process(
  p_id     => 146003823945226040.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25.4508,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'save History',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>146001305874226033.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 25.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_26.45
prompt  ...PAGE 26.4508: 트리거가 생성됨
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 26.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '트리거가 생성됨',
  p_step_title=> '변경된 테이블',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 10980707030991881.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164223',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<img src="#IMAGE_PREFIX#htmldb/builder/fail.gif" alt="">다음 원인으로 인해 트리거 생성 작업을 실패했습니다.<br>'||chr(10)||
'&P26_MSG.';

wwv_flow_api.create_page_plug (
  p_id=> 146006721667233564.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 26.4508,
  p_plug_name=> 'Error',
  p_region_name=>'',
  p_plug_template=> 106819925599248236.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 31,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2',
  p_plug_display_when_condition => 'P26_MSG',
  p_plug_display_when_cond2=>'SUCCESS',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<pre>&P9_SQL.</pre>';

wwv_flow_api.create_page_plug (
  p_id=> 146006904321233566.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 26.4508,
  p_plug_name=> 'SQL',
  p_region_name=>'',
  p_plug_template=> 18960127747559478.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 41,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 146007325893233569.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 26.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 146006721667233564+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>182318116609722105.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26.4508,
  p_branch_action=> 'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 04-MAY-2005 14:26 by SYME');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'도움말 텍스트가 필요하지 않습니다.';

wwv_flow_api.create_page_item(
  p_id=>146007721346233571.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26.4508,
  p_name=>'P26_MSG',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'메시지',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when_type=>'NEVER',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'for r in ( '||chr(10)||
'   select object_name, owner'||chr(10)||
'     from sys.dba_objects'||chr(10)||
'    where owner = :OB_SCHEMA'||chr(10)||
'      and object_id = :OBJECT_ID'||chr(10)||
'      and object_type = ''TRIGGER'' ) loop'||chr(10)||
'--   :OBJECT_ID    := r.object_id;'||chr(10)||
'   :OBJECT_NAME  := r.object_name;'||chr(10)||
'   :OBJECT_OWNER := r.owner;'||chr(10)||
'--   :OBJECT_TYPE  := r.object_type;'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'htp.p(''<script>'||chr(10)||
' top.gSideBar.reload("''|| :OBJECT_TYPE ||''","''||:OBJECT_ID||''",true';

p:=p||');'||chr(10)||
'</script>'');';

wwv_flow_api.create_page_process(
  p_id     => 127846811585766356.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 26.4508,
  p_process_sequence=> 20,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Load new Object',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'P26_MSG',
  p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_process_when2=>'SUCCESS',
  p_process_when_type2=>'',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 26.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_27.45
prompt  ...PAGE 27.4508: PL/SQL 소스 코드 검색
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_plsql.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 27.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'PL/SQL 소스 코드 검색',
  p_step_title=> 'PL/SQL 소스 코드 검색',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 276002212445738952+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 3490920094618697.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164223',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>27.4508,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 163508131770932082.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 27.4508,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select name, type, line, text'||chr(10)||
'from sys.all_source'||chr(10)||
'where owner = :P27_SCHEMA'||chr(10)||
'and (:P27_OBJECT is null or upper(name)like upper(:P27_OBJECT))'||chr(10)||
'and (:P27_TEXT is null or upper(text) like upper(:P27_TEXT))'||chr(10)||
'and (line >= nvl(:P27_FROM_LINE,0) and line <= nvl(:P27_TO_LINE,999999999))';

wwv_flow_api.create_report_region (
  p_id=> 163512629608950314.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 27.4508,
  p_name=> 'Search PL/SQL Source',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_required_role => 270111329240924563+ wwv_flow_api.g_id_offset,
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 11028007180514315.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'PL/SQL 프로그램 단위 행을 찾을 수 없습니다.',
  p_query_num_rows_item=> 'P27_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '10000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'and (:P27_TEXT is null or regexp_instr(text,:P27_TEXT) > 0)');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 163513004158950319.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 163512629608950314.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> '객체 이름',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 163513120016950321.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 163512629608950314.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'TYPE',
  p_column_display_sequence=> 2,
  p_column_heading=> '유형',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 163513213723950321.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 163512629608950314.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'LINE',
  p_column_display_sequence=> 3,
  p_column_heading=> '행',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 163513327803950321.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 163512629608950314.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'TEXT',
  p_column_display_sequence=> 4,
  p_column_heading=> '텍스트',
  p_column_hit_highlight=>'&P27_TEXT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 163519519050985123.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 27.4508,
  p_plug_name=> 'Owner',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 0,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_06',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 163544124488204308.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 27.4508,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 22867306215341549.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>163938104362639631.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4508,
  p_branch_action=> 'f?p=&FLOW_ID.:27:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'검색 범위를 PL/SQL 객체 행 번호로 제한하려면 시작 행 번호를 입력하십시오. 그런 다음 <b>실행</b>을 누르거나 <b>종료 행</b> 필드에 마지막 행 번호를 입력하십시오.';

wwv_flow_api.create_page_item(
  p_id=>10272119258228776.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4508,
  p_name=>'P27_FROM_LINE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 163544124488204308.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'시작 행',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 15,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'검색 범위를 PL/SQL 객체 행 번호로 제한하려면 검색에 포함할 종료 행 번호를 입력하고 <b>실행</b>을 누르십시오.';

wwv_flow_api.create_page_item(
  p_id=>10272901381233082.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4508,
  p_name=>'P27_TO_LINE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 163544124488204308.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'종료 행',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 15,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'%를 와일드 카드 문자로 사용하여 질의(대소문자 구분 안함)를 입력하십시오.';

wwv_flow_api.create_page_item(
  p_id=>10278425632315723.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4508,
  p_name=>'P27_TXT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 0,
  p_item_plug_id => 163544124488204308.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'검색 문자열에서 %를 와일드 카드 문자로 사용하십시오.',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 3,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>10280704076328473.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4508,
  p_name=>'P27_X',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> .5,
  p_item_plug_id => 163544124488204308.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_display_as=> 'STOP_AND_START_HTML_TABLE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'데이터베이스 스키마 소유자의 이름';

wwv_flow_api.create_page_item(
  p_id=>163539403139131919.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4508,
  p_name=>'P27_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 163519519050985123.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'wwv_flow_user_api.get_default_schema',
  p_item_default_type => 'PLSQL_EXPRESSION',
  p_prompt=>'스키마',
  p_source=>'wwv_flow_user_api.get_default_schema',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX_WITH_SUBMIT',
  p_named_lov=> 'LIST_AVAILABLE_SCHEMAS',
  p_lov => 'declare'||chr(10)||
'  q      varchar2(32767) := null;'||chr(10)||
'begin  '||chr(10)||
'  q:=''select htf.escape_sc(upper(c.schema)) d, upper(c.schema) v '';'||chr(10)||
'  q:=q||''from   wwv_flow_company_schemas c, '';'||chr(10)||
'  q:=q||''       wwv_flow_fnd_user u '';'||chr(10)||
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.user_name = :flow_user and '';'||chr(10)||
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';'||chr(10)||
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';'||chr(10)||
'  q:=q||''order by 1'';  '||chr(10)||
'  return q;'||chr(10)||
'end;',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="htmldbTopSchema"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'표시할 행 수를 선택하고 <b>실행</b>을 누르십시오.';

wwv_flow_api.create_page_item(
  p_id=>163922222231566242.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4508,
  p_name=>'P27_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 163544124488204308.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'표시',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_A',
  p_lov => '.'||to_char(88005728392276151 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 20,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'객체 이름을 입력하고 <b>실행</b>을 누르십시오.';

wwv_flow_api.create_page_item(
  p_id=>163930329681606231.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4508,
  p_name=>'P27_OBJECT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 163544124488204308.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'객체 이름',
  p_post_element_text=>'&nbsp;&nbsp;',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT_WITH_ENTER_SUBMIT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'PL/SQL 코드에 대한 질의를 입력하고 <b>실행</b>을 누르십시오.';

wwv_flow_api.create_page_item(
  p_id=>163931103146608045.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4508,
  p_name=>'P27_TEXT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 163544124488204308.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'텍스트',
  p_post_element_text=>'&nbsp;&nbsp;',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT_WITH_ENTER_SUBMIT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>163937914275639630.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4508,
  p_name=>'P27_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 163544124488204308.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'실행',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 276406030441418929.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4508,
  p_computation_sequence => 10,
  p_computation_item=> 'P27_SCHEMA',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'wwv_flow_user_api.get_default_schema;',
  p_compute_when => 'P27_SCHEMA',
  p_compute_when_type=>'ITEM_IS_NULL');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 163938616699640313.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 27.4508,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.check_priv(:P27_SCHEMA);'||chr(10)||
'wwv_flow_security.g_parse_as_schema_override := :P27_SCHEMA;'||chr(10)||
':G_PARSE_AS_SCHEMA_OVERRIDE := :P27_SCHEMA;';

wwv_flow_api.create_page_process(
  p_id     => 69230410388689297.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 27.4508,
  p_process_sequence=> 20,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Validate Schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '스키마 검증',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 27.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_29.45
prompt  ...PAGE 29.4508: DDL 생성
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_ddl.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 29.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'DDL 생성',
  p_step_title=> 'DDL 생성',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215532403383713875+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 20823807893218193.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164224',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>29.4508,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6814231558630341.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 29.4508,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 82336717613137775.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 29.4508,
  p_plug_name=> '스크립트',
  p_region_name=>'',
  p_plug_template=> 61427413413570608.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 1000,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_no_data_found=>'<font class="fielddata">객체를 찾을 수 없습니다.</font>',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_query_break_cols => '1',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'List:  DDL Wizard';

wwv_flow_api.create_page_plug (
  p_id=> 87151528579582262.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 29.4508,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 87134126220568115 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 82678409794459665.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 29.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 82336717613137775+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 82681018106461976.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 29.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 82336717613137775+wwv_flow_api.g_id_offset,
  p_button_name    => 'Previous',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&F4500_LAST_VIEW.:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>87105209651530215.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 29.4508,
  p_name=>'F4500_P18_DDL_TYPE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 82336717613137775.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'F4500_P18_DDL',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'SQL을 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>87217505239653834.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 29.4508,
  p_name=>'F4500_P18_DDL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 82336717613137775.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'--'||chr(10)||
'-- Check that the user has the appropriate privileges'||chr(10)||
'--'||chr(10)||
'wwv_flow_sw_api.check_priv ( p_schema => :F4500_P18_SCHEMA );'||chr(10)||
''||chr(10)||
'--'||chr(10)||
'-- if generate DDL is from page 43, pass only select object types'||chr(10)||
'--'||chr(10)||
'if :f4500_p18_ddl_type = ''OBJECT_TYPE'' then'||chr(10)||
'   wwv_flow_generate_ddl.execute_get_ddl('||chr(10)||
'           p_schema       => :f4500_p18_schema,'||chr(10)||
'           p_object_types => :f4500_p18_object_type,'||chr(10)||
'           p_output_type  => ''DISPLAY'');'||chr(10)||
'--'||chr(10)||
'-- if generate DDL is from page 44, pass only select object names'||chr(10)||
'--'||chr(10)||
'elsif :f4500_p18_ddl_type = ''OBJECT_NAME'' then'||chr(10)||
'   wwv_flow_generate_ddl.execute_get_ddl('||chr(10)||
'         p_schema => :f4500_p18_schema,'||chr(10)||
'         p_object_types => :f4500_p18_object_type,'||chr(10)||
'         p_objects => :f4500_p18_object_name,'||chr(10)||
'         p_output_type => ''DISPLAY'');'||chr(10)||
'end if;',
  p_source_type=> 'PLSQL_ANONYMOUS_BLOCK',
  p_display_as=> 'DISPLAY_ONLY_PLSQL',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 29.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_31.45
prompt  ...PAGE 31.4508: 스크립트 할당량
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_rep_quotas.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 31.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '스크립트 할당량',
  p_step_title=> '스크립트 할당량',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164224',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>31.4508,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 150029301997796011.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 31.4508,
  p_plug_name=> '결과 할당량(바이트)',
  p_region_name=>'',
  p_plug_template=> 140310301493602560.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 150052917506895121.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 31.4508,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 164592024753268295.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 31.4508,
  p_plug_name=> '스크립트 할당량(바이트)',
  p_region_name=>'',
  p_plug_template=> 140310301493602560.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 150929922265552010.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 31.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 150029301997796011+wwv_flow_api.g_id_offset,
  p_button_name    => 'OK',
  p_button_image_alt=> '확인',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:1004:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
null;
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'개별 스크립트 결과에 허용되는 최대 크기를 식별합니다. 이 크기는 관리자가 설정하므로 작업 영역 내에서 변경할 수 없습니다. 스크립트 결과에 허용되는 최대 크기에 도달하면 실행 중인 모든 스크립트가 취소됩니다.';

wwv_flow_api.create_page_item(
  p_id=>150030705591806521.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31.4508,
  p_name=>'P31_SCRIPT_QUOTA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 150029301997796011.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'최대 스크립트 결과 크기: ',
  p_source=>'to_char(nvl(to_number(wwv_flow_platform.get_preference(''SQL_SCRIPT_MAX_OUTPUT_SIZE'')),2000000),''999G999G999G999G999'')',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'스크립트 결과에 할당된 공간량을 식별합니다. 이 할당량은 관리자가 설정하므로 작업 영역 내에서 변경할 수 없습니다. <b>모든 스크립트 결과에 대한 할당량</b>에 도달하면 실행 중인 모든 스크립트가 취소됩니다.';

wwv_flow_api.create_page_item(
  p_id=>150032513210808776.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31.4508,
  p_name=>'P31_TOTAL_QUOTA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 150029301997796011.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'모든 스크립트 결과에 대한 할당량: ',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 10,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'스크립트 결과를 생성할 때 사용할 수 있는 사용 가능한 작업 영역 공간을 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>150033722214811335.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31.4508,
  p_name=>'P31_FREE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 150029301997796011.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'사용 가능: ',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'작업 영역에 현재 사용된 스크립트 결과 할당량의 비율을 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>150034629833813503.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31.4508,
  p_name=>'P31_AVAILABLE_SPACE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 150029301997796011.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'할당량:',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'작업 영역에 현재 사용된 스크립트 결과 크기를 식별합니다.';

wwv_flow_api.create_page_item(
  p_id=>150040021091829941.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31.4508,
  p_name=>'P31_USED',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 25,
  p_item_plug_id => 150029301997796011.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'사용됨',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'개별 스크립트에 허용되는 최대 크기를 식별합니다. 이 할당량은 관리자가 설정하므로 작업 영역 내에서 변경할 수 없습니다.';

wwv_flow_api.create_page_item(
  p_id=>164592806529272486.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31.4508,
  p_name=>'P31_SCRIPT_MAX_SIZE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 164592024753268295.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'최대 스크립트 크기: ',
  p_source=>'to_char(nvl(to_number(wwv_flow_platform.get_preference(''MAX_SCRIPT_SIZE'')),2000000),''999G999G999G999G999'')',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'    l_max_output_size   number := 0;'||chr(10)||
'    l_used              number := 0;'||chr(10)||
'    l_free              number := 0;'||chr(10)||
'begin'||chr(10)||
'    l_max_output_size := nvl(wwv_flow_platform.get_preference(''WORKSPACE_MAX_OUTPUT_SIZE''),10000000);'||chr(10)||
'    for c1 in (select sum(result_size) the_sum'||chr(10)||
'                 from wwv_flow_sw_detail_results'||chr(10)||
'                where security_group_id = :flow_security_group_id)'||chr(10)||
'    loop'||chr(10)||
' ';

p:=p||'       l_used := nvl(c1.the_sum,0);'||chr(10)||
'        exit;'||chr(10)||
'    end loop;--c1'||chr(10)||
'    '||chr(10)||
'    l_free := nvl(l_max_output_size - l_used,0);'||chr(10)||
'    if sign(l_free) = -1 then'||chr(10)||
'        l_free := 0;'||chr(10)||
'    end if;'||chr(10)||
'    '||chr(10)||
'    '||chr(10)||
'    '||chr(10)||
'    '||chr(10)||
'    :P31_FREE := to_char(l_free,''999G999G999G999G999'');'||chr(10)||
'    :P31_USED := to_char(l_used,''999G999G999G999G999'');'||chr(10)||
'    '||chr(10)||
'    :P31_TOTAL_QUOTA := to_char(l_max_output_size,''999G999G999G999G999'');'||chr(10)||
'    ';

p:=p||''||chr(10)||
'    :P31_AVAILABLE_SPACE := wwv_flow_sw_script.draw_quotameter2('||chr(10)||
'                                   p_max_size       => l_max_output_size,'||chr(10)||
'                                   p_current_size   => l_used);'||chr(10)||
'    '||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 150010615148724106.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 31.4508,
  p_process_sequence=> 40,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Compute Space Info at Bottom',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 31.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_34.45
prompt  ...PAGE 34.4508: 긴 작업
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/dbadm_long_opr.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 34.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '긴 작업',
  p_step_title=> '긴 작업',
  p_step_sub_title => 'Long Operations',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 206250111084432914+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 206059717799303330+ wwv_flow_api.g_id_offset,
  p_required_patch=> 140265918963157648.4508 + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164224',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>34.4508,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 137473929023285726.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 34.4508,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select l.SID, l.SERIAL#,s.username,s.module,s.action,s.client_info,'||chr(10)||
'       l.OPNAME, l.TARGET, l.TARGET_DESC, l.SOFAR, l.TOTALWORK, l.UNITS, '||chr(10)||
'       l.START_TIME, l.LAST_UPDATE_TIME, round((l.TIME_REMAINING/60),2) TIME_REMAINING, round((l.ELAPSED_SECONDS/60),2) ELAPSED_SECONDS, l.CONTEXT, '||chr(10)||
'       l.MESSAGE,       '||chr(10)||
'       ROUND(l.sofar/l.totalwork*100, 2) pct_complete'||chr(10)||
'  from v$session_longops l,v$s';

s:=s||'ession s'||chr(10)||
' where l.sid = s.sid'||chr(10)||
'   and l.time_remaining > 0';

wwv_flow_api.create_report_region (
  p_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 34.4508,
  p_name=> '긴 작업',
  p_region_name=>'',
  p_template=> 61427413413570608.4508+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 11028007180514315.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '긴 작업을 찾을 수 없습니다.',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178260318963549444.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'SID',
  p_column_link=>'f?p=&APP_ID.:550:&SESSION.::&DEBUG.::P550_SID:#SID#',
  p_column_linktext=>'#SID#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178260423624549444.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'SERIAL#',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Serial#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178260529874549444.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'USERNAME',
  p_column_display_sequence=> 19,
  p_column_heading=> 'Username',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178262116030549448.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'USERNAME',
  p_column_display_sequence=> 20,
  p_column_heading=> 'Username',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178260606497549445.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'MODULE',
  p_column_display_sequence=> 3,
  p_column_heading=> '모듈',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178260732762549445.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'ACTION',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Action',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178260800220549445.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'CLIENT_INFO',
  p_column_display_sequence=> 5,
  p_column_heading=> '클라이언트 정보',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178260913925549445.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'OPNAME',
  p_column_display_sequence=> 6,
  p_column_heading=> '작업',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178261016632549445.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'TARGET',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Target',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178261111266549445.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'TARGET_DESC',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Target Desc',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178261208273549445.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'SOFAR',
  p_column_display_sequence=> 9,
  p_column_heading=> '현재<br />단위',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178261306774549445.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'TOTALWORK',
  p_column_display_sequence=> 10,
  p_column_heading=> '총<br />단위',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178261429155549445.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'UNITS',
  p_column_display_sequence=> 11,
  p_column_heading=> '단위<br />설명',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178261531527549446.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'START_TIME',
  p_column_display_sequence=> 12,
  p_column_heading=> '시작 시간',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178261625998549447.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'LAST_UPDATE_TIME',
  p_column_display_sequence=> 13,
  p_column_heading=> '마지막<br />갱신<br />시간',
  p_column_format=> '&TIME_FORMAT.',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178261723873549447.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'TIME_REMAINING',
  p_column_display_sequence=> 14,
  p_column_heading=> '남은<br />시간(분)',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178261819499549447.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'ELAPSED_SECONDS',
  p_column_display_sequence=> 15,
  p_column_heading=> '경과<br />시간(분)',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178261903992549447.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'CONTEXT',
  p_column_display_sequence=> 16,
  p_column_heading=> 'Context',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178262021903549447.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 18,
  p_form_element_id=> null,
  p_column_alias=> 'MESSAGE',
  p_column_display_sequence=> 18,
  p_column_heading=> 'Message',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 178420827712964448.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 178260032336549436.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 19,
  p_form_element_id=> null,
  p_column_alias=> 'PCT_COMPLETE',
  p_column_display_sequence=> 17,
  p_column_heading=> '완료율<br />',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 34.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_36.45
prompt  ...PAGE 36.4508: 데이터베이스 정보
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/dbadm_db_detail.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 36.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '데이터베이스 정보',
  p_step_title=> '데이터베이스 정보',
  p_step_sub_title => 'Database Identification',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 206250111084432914+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_role => 206059717799303330+ wwv_flow_api.g_id_offset,
  p_required_patch=> 140265918963157648.4508 + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164224',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>36.4508,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 996831560382082.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 36.4508,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106954406499588564.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select name,value,ISDEFAULT,'||chr(10)||
'       DESCRIPTION'||chr(10)||
'  from v$parameter'||chr(10)||
' where /* lower(name) like ''%''||lower(:P555_SEARCH)||''%'''||chr(10)||
'   and (:P555_SHOW = ''ALL'''||chr(10)||
'        or'||chr(10)||
'          (:P555_SHOW = ''CUSTOM'' and isdefault = ''FALSE'')) '||chr(10)||
'   and */ substr(name,1,2) != ''__'''||chr(10)||
'order by name';

wwv_flow_api.create_report_region (
  p_id=> 5632008088794443.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 36.4508,
  p_name=> '매개변수',
  p_region_name=>'',
  p_template=> 61427413413570608.4508+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 60,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'instr('':''||:P36_DISPLAY||'':'','':PARAMETER:'') > 0',
  p_display_condition_type=> 'PLSQL_EXPRESSION',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 172773906323382535.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '5000',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '데이터를 찾을 수 없습니다.',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '10000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5632302474794468.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 5632008088794443.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> '이름',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5632406892794469.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 5632008088794443.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'VALUE',
  p_column_display_sequence=> 2,
  p_column_heading=> '값',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5632509538794469.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 5632008088794443.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'ISDEFAULT',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Is&nbsp;기본값',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 5632627784794469.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 5632008088794443.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'DESCRIPTION',
  p_column_display_sequence=> 4,
  p_column_heading=> '설명',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select NAME,'||chr(10)||
'       CREATED,'||chr(10)||
'       RESETLOGS_TIME,'||chr(10)||
'       PRIOR_RESETLOGS_CHANGE#,'||chr(10)||
'       PRIOR_RESETLOGS_TIME,'||chr(10)||
'       LOG_MODE,'||chr(10)||
'       CHECKPOINT_CHANGE#,'||chr(10)||
'       ARCHIVE_CHANGE#,'||chr(10)||
'       OPEN_RESETLOGS,'||chr(10)||
'       VERSION_TIME,'||chr(10)||
'       OPEN_MODE,'||chr(10)||
'       PROTECTION_MODE,'||chr(10)||
'       PROTECTION_LEVEL,'||chr(10)||
'       REMOTE_ARCHIVE,'||chr(10)||
'       DATABASE_ROLE,'||chr(10)||
'       ARCHIVELOG_CHANGE#,'||chr(10)||
'       SWITCHOVER_STATUS,'||chr(10)||
'       DAT';

s:=s||'AGUARD_BROKER,'||chr(10)||
'       GUARD_STATUS,'||chr(10)||
'       FORCE_LOGGING'||chr(10)||
'  from v$database';

wwv_flow_api.create_report_region (
  p_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 36.4508,
  p_name=> '데이터베이스',
  p_region_name=>'',
  p_template=> 61427413413570608.4508+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'instr('':''||:P36_DISPLAY||'':'','':DATABASE:'') > 0',
  p_display_condition_type=> 'PLSQL_EXPRESSION',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 161923301611160944.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '데이터를 찾을 수 없습니다.',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172512609361041599.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'NAME',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172512705827041599.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'CREATED',
  p_column_display_sequence=> 2,
  p_column_heading=> 'CREATED',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172512902493041599.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'RESETLOGS_TIME',
  p_column_display_sequence=> 3,
  p_column_heading=> 'RESETLOGS_TIME',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172513026750041599.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PRIOR_RESETLOGS_CHANGE#',
  p_column_display_sequence=> 4,
  p_column_heading=> 'PRIOR_RESETLOGS_CHANGE#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172513100737041600.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'PRIOR_RESETLOGS_TIME',
  p_column_display_sequence=> 5,
  p_column_heading=> 'PRIOR_RESETLOGS_TIME',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172513201718041600.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'LOG_MODE',
  p_column_display_sequence=> 6,
  p_column_heading=> 'LOG_MODE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172513328511041600.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'CHECKPOINT_CHANGE#',
  p_column_display_sequence=> 7,
  p_column_heading=> 'CHECKPOINT_CHANGE#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172513400321041600.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'ARCHIVE_CHANGE#',
  p_column_display_sequence=> 8,
  p_column_heading=> 'ARCHIVE_CHANGE#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172514000103041600.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'OPEN_RESETLOGS',
  p_column_display_sequence=> 9,
  p_column_heading=> 'OPEN_RESETLOGS',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172514118014041601.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'VERSION_TIME',
  p_column_display_sequence=> 10,
  p_column_heading=> 'VERSION_TIME',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172514200823041601.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'OPEN_MODE',
  p_column_display_sequence=> 11,
  p_column_heading=> 'OPEN_MODE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172514331382041601.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'PROTECTION_MODE',
  p_column_display_sequence=> 12,
  p_column_heading=> 'PROTECTION_MODE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172514405190041601.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'PROTECTION_LEVEL',
  p_column_display_sequence=> 13,
  p_column_heading=> 'PROTECTION_LEVEL',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172514514003041601.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'REMOTE_ARCHIVE',
  p_column_display_sequence=> 14,
  p_column_heading=> 'REMOTE_ARCHIVE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172514819520041601.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'DATABASE_ROLE',
  p_column_display_sequence=> 15,
  p_column_heading=> 'DATABASE_ROLE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172514915226041602.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'ARCHIVELOG_CHANGE#',
  p_column_display_sequence=> 16,
  p_column_heading=> 'ARCHIVELOG_CHANGE#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172515117807041602.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'SWITCHOVER_STATUS',
  p_column_display_sequence=> 17,
  p_column_heading=> 'SWITCHOVER_STATUS',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172515226718041602.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 18,
  p_form_element_id=> null,
  p_column_alias=> 'DATAGUARD_BROKER',
  p_column_display_sequence=> 18,
  p_column_heading=> 'DATAGUARD_BROKER',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172515313032041602.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 19,
  p_form_element_id=> null,
  p_column_alias=> 'GUARD_STATUS',
  p_column_display_sequence=> 19,
  p_column_heading=> 'GUARD_STATUS',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172515713476041603.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172512209864041595.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 20,
  p_form_element_id=> null,
  p_column_alias=> 'FORCE_LOGGING',
  p_column_display_sequence=> 20,
  p_column_heading=> 'FORCE_LOGGING',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 172517917883045293.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 36.4508,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select banner from v$version';

wwv_flow_api.create_report_region (
  p_id=> 172673725969331492.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 36.4508,
  p_name=> '버전',
  p_region_name=>'',
  p_template=> 61427413413570608.4508+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 7,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'instr('':''||:P36_DISPLAY||'':'','':VERSION:'') > 0',
  p_display_condition_type=> 'PLSQL_EXPRESSION',
  p_plug_caching=> 'NOT_CACHED',
  p_footer=> '<p />',
  p_customized=> '0',
  p_query_row_template=> 172773906323382535.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '데이터를 찾을 수 없습니다.',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172673910997331494.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172673725969331492.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'BANNER',
  p_column_display_sequence=> 1,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select * from v$option';

wwv_flow_api.create_report_region (
  p_id=> 172675002205334076.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 36.4508,
  p_name=> '옵션',
  p_region_name=>'',
  p_template=> 61427413413570608.4508+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'instr('':''||:P36_DISPLAY||'':'','':OPTIONS:'') > 0',
  p_display_condition_type=> 'PLSQL_EXPRESSION',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 172773906323382535.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '50000',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '데이터를 찾을 수 없습니다.',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172675205390334077.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172675002205334076.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'PARAMETER',
  p_column_display_sequence=> 1,
  p_column_heading=> '매개변수',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172675332169334078.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172675002205334076.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'VALUE',
  p_column_display_sequence=> 2,
  p_column_heading=> '값',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select * from v$nls_parameters';

wwv_flow_api.create_report_region (
  p_id=> 172752728356379421.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 36.4508,
  p_name=> '국가별 언어 지원',
  p_region_name=>'',
  p_template=> 61427413413570608.4508+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 40,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'instr('':''||:P36_DISPLAY||'':'','':NLS:'') > 0',
  p_display_condition_type=> 'PLSQL_EXPRESSION',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 172773906323382535.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '50000',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '데이터를 찾을 수 없습니다.',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172752905784379422.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172752728356379421.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'PARAMETER',
  p_column_display_sequence=> 1,
  p_column_heading=> '국가별 언어 매개변수',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 172753010951379422.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 172752728356379421.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'VALUE',
  p_column_display_sequence=> 2,
  p_column_heading=> '값',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'    l_block varchar2(32767);'||chr(10)||
'    '||chr(10)||
'    procedure add_row(p_parameter in varchar2)'||chr(10)||
'    is'||chr(10)||
'    begin'||chr(10)||
'        l_block := l_block ||''<tr><th align="right">''||p_parameter||''</th><td>''||owa_util.get_cgi_env(p_parameter)||''</td></tr>''||chr(13);'||chr(10)||
'    end add_row;'||chr(10)||
'begin'||chr(10)||
'    l_block :=''<table class="htmldbVerticalRptPlain"  summary="" cellpadding="0" cellspacing="0" border="0">'';'||chr(10)||
'    '||chr(10)||
'    add_row(''PLS';

s:=s||'QL_GATEWAY'');'||chr(10)||
'    add_row(''GATEWAY_IVERSION'');'||chr(10)||
'    add_row(''SERVER_SOFTWARE'');'||chr(10)||
'    add_row(''GATEWAY_INTERFACE'');'||chr(10)||
'    add_row(''SERVER_PORT'');'||chr(10)||
'    add_row(''SERVER_NAME'');'||chr(10)||
'    add_row(''REQUEST_METHOD'');'||chr(10)||
'    add_row(''QUERY_STRING'');'||chr(10)||
'    add_row(''PATH_INFO'');'||chr(10)||
'    add_row(''SCRIPT_NAME'');'||chr(10)||
'    add_row(''REMOTE_ADDR'');'||chr(10)||
'    add_row(''SERVER_PROTOCOL'');'||chr(10)||
'    add_row(''REQUEST_PROTOCOL'');'||chr(10)||
'    add_row(''REMOTE_USER';

s:=s||''');'||chr(10)||
'    add_row(''HTTP_USER_AGENT'');'||chr(10)||
'    add_row(''HTTP_HOST'');'||chr(10)||
'    --add_row(''HTTP_ACCEPT'');'||chr(10)||
'    add_row(''HTTP_ACCEPT_ENCODING'');'||chr(10)||
'    add_row(''HTTP_ACCEPT_LANGUAGE'');'||chr(10)||
'    --add_row(''HTTP_REFERER'');'||chr(10)||
'    add_row(''HTTP_ORACLE_ECID'');'||chr(10)||
'    add_row(''WEB_AUTHENT_PREFIX'');'||chr(10)||
'    add_row(''DAD_NAME'');'||chr(10)||
'    add_row(''DOC_ACCESS_PATH'');'||chr(10)||
'    add_row(''DOCUMENT_TABLE'');'||chr(10)||
'    add_row(''PATH_ALIAS'');'||chr(10)||
'    add_row(''REQUEST';

s:=s||'_CHARSET'');'||chr(10)||
'    add_row(''REQUEST_IANA_CHARSET'');'||chr(10)||
'    add_row(''SCRIPT_PREFIX'');'||chr(10)||
'    --add_row(''HTTP_COOKIE'');'||chr(10)||
'    '||chr(10)||
'    l_block := l_block ||''</table>'';'||chr(10)||
'    htp.p(l_block);'||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 172789621476405877.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 36.4508,
  p_plug_name=> 'CGI 환경',
  p_region_name=>'',
  p_plug_template=> 61427413413570608.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'PLSQL_EXPRESSION',
  p_plug_display_when_condition => 'instr('':''||:P36_DISPLAY||'':'','':CGI:'') > 0',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>1001509298526032.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 36.4508,
  p_branch_action=> 'f?p=&FLOW_ID.:36:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1000529716523424.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 36.4508,
  p_name=>'P36_DISPLAY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 996831560382082.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'VERSION',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'VERSION',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_named_lov=> 'P36_DISPLAY_OPTIONS',
  p_lov => '.'||to_char(998111353442494 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 7,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1001305952526018.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 36.4508,
  p_name=>'P36_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 996831560382082.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'실행',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 36.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_38.45
prompt  ...PAGE 38.4508: QB - 저장된 SQL
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 38.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'QB - 저장된 SQL',
  p_step_title=> '저장된 질의',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 11093307704620192+ wwv_flow_api.g_id_offset,
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 14599108081253832.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164224',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 159939829413099962.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 38.4508,
  p_plug_name=> 'Find Criteria',
  p_region_name=>'',
  p_plug_template=> 22867306215341549.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'   ID,'||chr(10)||
'  initcap(substr(title,1,50)) title,'||chr(10)||
'  last_updated_on Updated,'||chr(10)||
'  created_by,'||chr(10)||
'  last_UPDATED_BY,'||chr(10)||
'  description,'||chr(10)||
'  QUERY_OWNER schema'||chr(10)||
'from wwv_flow_qb_saved_query'||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'and (:p38_find is null or instr( upper(title) ,upper(:p38_find) ) > 0 )'||chr(10)||
'and (:p38_owner = ''0'' or created_by = :p38_owner)'||chr(10)||
'and query_type = ''W'''||chr(10)||
'and (created_by = :APP_USER or';

s:=s||''||chr(10)||
'exists ('||chr(10)||
'select 1'||chr(10)||
'from  wwv_flow_developers'||chr(10)||
'where security_group_id = :flow_security_group_id and'||chr(10)||
'userid = :APP_USER and'||chr(10)||
'instr(developer_role||'':'',''ADMIN:'') > 0'||chr(10)||
'union'||chr(10)||
'select 1'||chr(10)||
'from wwv_flow_fnd_user'||chr(10)||
'where security_group_id = :FLOW_SECURITY_GROUP_ID'||chr(10)||
'and user_name = :APP_USER'||chr(10)||
'and attribute_01 in (''ORACLE_ADMIN'',''SCHOOL_ADMIN'',''TEACHER'')))';

wwv_flow_api.create_report_region (
  p_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 38.4508,
  p_name=> 'Saved Queries',
  p_region_name=>'',
  p_template=> 12270828624874231.4508+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'UPDATABLE_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'P38_VIEW',
  p_display_when_cond2=> 'DETAIL',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 11028007180514315.4508+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '저장된 SQL을 찾을 수 없습니다.',
  p_query_num_rows_item=> 'P38_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 159959511942138966.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'CHECK$01',
  p_column_display_sequence=> 1,
  p_column_heading=> '삭제',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'CHECKBOX',
  p_pk_col_source=> s,
  p_derived_column=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 160113424849394443.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Id',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'HIDDEN',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 159940904414099968.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'TITLE',
  p_column_display_sequence=> 4,
  p_column_heading=> '이름',
  p_column_link=>'f?p=&APP_ID.:1002:&SESSION.:LOAD:&DEBUG.::P1002_QUERY_ID,P1002_SCHEMA:#ID#,#SCHEMA#',
  p_column_linktext=>'#TITLE#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 159941115102099968.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'UPDATED',
  p_column_display_sequence=> 7,
  p_column_heading=> '마지막 갱신 날짜',
  p_column_format=> 'SINCE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 160107426993376207.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'CREATED_BY',
  p_column_display_sequence=> 3,
  p_column_heading=> '소유자',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 159941312755099969.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'LAST_UPDATED_BY',
  p_column_display_sequence=> 6,
  p_column_heading=> '갱신자',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 159941419384099969.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'DESCRIPTION',
  p_column_display_sequence=> 5,
  p_column_heading=> '설명',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 160115520166404770.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Schema',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 160019417324254067.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 38.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 159939829413099962+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_image_alt=> '선택된 항목 삭제',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:PPR_Tabluar_Submit(''SavedSQLHolder'',''4500'',''38'',''DELETE'',true,''R159940232617099966'',''BOX_BODY'');',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 159974622387246003.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 38.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 159939829413099962+wwv_flow_api.g_id_offset,
  p_button_name    => 'GO',
  p_button_image_alt=> '실행',
  p_button_position=> 'REGION_TEMPLATE_EDIT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:qb_getSavedSQL(false);',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>159945027925099984.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 38.4508,
  p_branch_action=> 'f?p=&APP_ID.:38:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'질의 소유자를 선택하고 <b>실행</b>을 누르십시오.';

wwv_flow_api.create_page_item(
  p_id=>159942102412099972.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 38.4508,
  p_name=>'P38_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 159939829413099962.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'소유자',
  p_source=>'V(''APP_USER'')',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'QUERY_OWNERS',
  p_lov => 'declare'||chr(10)||
'  q varchar2(32767) := null;'||chr(10)||
'begin'||chr(10)||
'  if wwv_flow_global.g_xe then'||chr(10)||
'    q:=''select v(''''APP_USER'''') D, v(''''APP_USER'''') R from dual '';'||chr(10)||
'  else'||chr(10)||
'    q:=''SELECT D,R FROM ( '';'||chr(10)||
'    q:=q||''select htf.escape_sc(created_by) d, created_by r '';'||chr(10)||
'    q:=q||''from   WWV_FLOW_QB_SAVED_QUERY '';'||chr(10)||
'    q:=q||''where security_group_id = :FLOW_SECURITY_GROUP_ID '';'||chr(10)||
'    q:=q||''and exists ( '';    '||chr(10)||
'    q:=q||''select 1 '';'||chr(10)||
'    q:=q||''from  wwv_flow_developers '';'||chr(10)||
'    q:=q||''where security_group_id = :flow_security_group_id and '';'||chr(10)||
'    q:=q||''      userid = :flow_user and '';'||chr(10)||
'    q:=q||''      instr(developer_role||'''':'''',''''ADMIN:'''') > 0 '';'||chr(10)||
'    q:=q||''union '';'||chr(10)||
'    q:=q||''select 1 '';'||chr(10)||
'    q:=q||''from wwv_flow_fnd_user '';'||chr(10)||
'    q:=q||''where security_group_id = :flow_security_group_id '';'||chr(10)||
'    q:=q||''and user_name = :flow_user '';'||chr(10)||
'    q:=q||''and attribute_01 in (''''ORACLE_ADMIN'''',''''SCHOOL_ADMIN'''',''''TEACHER'''')) '';'||chr(10)||
'    q:=q||''union all  '';'||chr(10)||
'    q:=q||''select v(''''APP_USER'''') D, v(''''APP_USER'''') R '';'||chr(10)||
'    q:=q||''FROM DUAL) '';'||chr(10)||
'    q:=q||''group by D,R '';'||chr(10)||
'  end if;  '||chr(10)||
'  return q;'||chr(10)||
'end;',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- 모든 사용자 -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'검색에 사용할 문자열을 입력하고 <b>실행</b>을 누르십시오.';

wwv_flow_api.create_page_item(
  p_id=>159942615380099976.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 38.4508,
  p_name=>'P38_FIND',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 159939829413099962.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'이름',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'한 페이지에 표시할 행 수를 선택하고 <b>실행</b>을 누르십시오.';

wwv_flow_api.create_page_item(
  p_id=>159944121760099979.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 38.4508,
  p_name=>'P38_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 27,
  p_item_plug_id => 159939829413099962.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '10',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'표시',
  p_source=>'10',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_A',
  p_lov => '.'||to_char(88005728392276151 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:WWV_FLOW_QB_SAVED_QUERY:ID';

wwv_flow_api.create_page_process(
  p_id     => 159944614049099982.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 38.4508,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'MULTI_ROW_DELETE',
  p_process_name=> 'Delete',
  p_process_sql_clob => p, 
  p_process_error_message=> '질의를 삭제할 수 없습니다.',
  p_process_when=>'DELETE',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '질의가 삭제됨',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 205961520224603885.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 38.4508,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'DELETE',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 38.4508
--
 
begin
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 160112712017394439.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 1,
  p_query_column_name=> 'ID',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 159956320301128242.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 2,
  p_query_column_name=> 'TITLE',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 159956508083128243.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 3,
  p_query_column_name=> 'UPDATED',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 160107017342376203.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 4,
  p_query_column_name=> 'CREATED_BY',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 159956717081128243.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 5,
  p_query_column_name=> 'LAST_UPDATED_BY',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 159956800507128243.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 6,
  p_query_column_name=> 'DESCRIPTION',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
wwv_flow_api.create_region_rpt_cols (
  p_id     => 160115421666404766.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_plug_id=> 159940232617099966.4508 + wwv_flow_api.g_id_offset,
  p_column_sequence=> 7,
  p_query_column_name=> 'SCHEMA',
  p_display_as=> 'TEXT',
  p_column_comment=> '');
 
null;
end;
null;
 
end;
/

 
--application/pages/page_42.45
prompt  ...PAGE 42.4508: QBE(예제별 질의)
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph:=ph||'<SCRIPT LANGUAGE="JavaScript1.1" type="text/javascript">'||chr(10)||
'function ToggleAll(e) '||chr(10)||
'  {'||chr(10)||
'  if (e.checked)'||chr(10)||
'    CheckAll();'||chr(10)||
'  else '||chr(10)||
'    ClearAll();'||chr(10)||
'  }'||chr(10)||
'function Check(e)    '||chr(10)||
'  {'||chr(10)||
'  e.checked = true;'||chr(10)||
'  }'||chr(10)||
'function Clear(e)    '||chr(10)||
'  {'||chr(10)||
'  e.checked = false;'||chr(10)||
'  }'||chr(10)||
'function CheckAll()    '||chr(10)||
'  {'||chr(10)||
'  var ml = document.wwv_flow;'||chr(10)||
'  var len = ml.elements.length;'||chr(10)||
'  for (var i = 0; i < len; i++)'||chr(10)||
'    {'||chr(10)||
'    var e = ml.elements[i]';

ph:=ph||';'||chr(10)||
'    if (e.name == "f01")'||chr(10)||
'      Check(e);'||chr(10)||
'    }'||chr(10)||
'  ml.f01.checked = true;'||chr(10)||
'  }'||chr(10)||
'function ClearAll()'||chr(10)||
'  {'||chr(10)||
'  var ml = document.wwv_flow;'||chr(10)||
'  var len = ml.elements.length;'||chr(10)||
'  for (var i = 0; i < len; i++)'||chr(10)||
'    {'||chr(10)||
'    var e = ml.elements[i];'||chr(10)||
'    if (e.name == "f01")'||chr(10)||
'      Clear(e);'||chr(10)||
'    }'||chr(10)||
'  ml.f01.checked = false;'||chr(10)||
'  }'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 42.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'QBE(예제별 질의)',
  p_step_title=> 'QBE(예제별 질의)',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 11539602725985552+ wwv_flow_api.g_id_offset,
  p_help_text => '',
  p_html_page_header => ' ',
  p_step_template => 10980707030991881.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164224',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>42.4508,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 14689615963936701.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 42.4508,
  p_plug_name=> 'View Subtabs',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 11795609889491706 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_plug_display_when_condition => 'OBJECT_TYPE',
  p_plug_display_when_cond2=>'VIEW',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 14744016215230180.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 42.4508,
  p_plug_name=> 'Table Subtabs',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 11739111107829730 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_plug_display_when_condition => 'OBJECT_TYPE',
  p_plug_display_when_cond2=>'TABLE',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 25164721533986545.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 42.4508,
  p_plug_name=> '작업',
  p_region_name=>'',
  p_plug_template=> 30488201226315070.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 80,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 35404206746396755 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => 'NEVER',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'  q       varchar2(32767);'||chr(10)||
'  l_none  varchar2(100);'||chr(10)||
'begin'||chr(10)||
'l_none := wwv_flow_lang.system_message(''F4000_P806_NONE'');'||chr(10)||
'      '||chr(10)||
'if (wwv_flow_collection.collection_exists(''SW_QBE'')) and'||chr(10)||
'   (nvl(:OBJECT_NAME,'' '') = nvl(:F4500_P42_PREV_OBJECT,'' '')) then    '||chr(10)||
'  q:=''select '';'||chr(10)||
'  q:=q||''DECODE(c.c008,c.c004,'';'||chr(10)||
'  q:=q||''wwv_flow_item.checkbox(1,c.c004,''''CHECKED''''),'';'||chr(10)||
'  q:=q||''wwv_flow_item.checkbox(1,c';

s:=s||'.c004)) include, '';  '||chr(10)||
'  q:=q||''c.c003||''''.'''' column_id, '';'||chr(10)||
'  q:=q||''c.c004 column_name, '';'||chr(10)||
'  q:=q||''decode(substr(c.c006,1,decode(instr(c.c006,''''(''''),0,length(c.c006),instr(c.c006,''''('''')-1)),'';'||chr(10)||
'  q:=q||''''''VARCHAR2'''',''''<img src="#IMAGE_PREFIX#varchar.gif" width="16" height="16" alt="varchar2" />'''' '';'||chr(10)||
'  q:=q||'',''''CHAR'''',''''<img src="#IMAGE_PREFIX#varchar.gif" width="16" height="16" alt="char" />'''' '';';

s:=s||''||chr(10)||
'  q:=q||'',''''DATE'''',''''<img src="#IMAGE_PREFIX#date.gif" width="16" height="16" alt="date" />'''' '';'||chr(10)||
'  q:=q||'',''''TIMESTAMP'''',''''<img src="#IMAGE_PREFIX#date.gif" width="16" height="16" alt="date">'''' '';'||chr(10)||
'  q:=q||'',''''NUMBER'''',''''<img src="#IMAGE_PREFIX#number.gif" width="16" height="16" alt="number" />'''' '';'||chr(10)||
'  q:=q||'',wwv_flow_lang.system_message(''''F4500.NO_IMAGE'''')) dt_img, '';   '||chr(10)||
'  q:=q||''DECODE(substr(c.';

s:=s||'c006,1,decode(instr(c.c006,''''(''''),0,length(c.c006),instr(c.c006,''''('''')-1)),''''VARCHAR2'''',wwv_flow_item.text(2,c.c005),'';'||chr(10)||
'  q:=q||''''''CHAR'''',wwv_flow_item.text(2,c.c005),'';'||chr(10)||
'  q:=q||''''''NUMBER'''',wwv_flow_item.text(2,c.c005),'';'||chr(10)||
'  q:=q||''''''DATE'''',wwv_flow_item.text(2,c.c005),'';'||chr(10)||
'  q:=q||''''''CLOB'''',wwv_flow_item.text(2,c.c005),'';'||chr(10)||
'  q:=q||''''''TIMESTAMP'''',wwv_flow_item.text(2,c.c005),'';'||chr(10)||
'  q:=q||''''''BINARY_FLOAT';

s:=s||''''',wwv_flow_item.text(2,c.c005),'';'||chr(10)||
'  q:=q||''''''BINARY_DOUBLE'''',wwv_flow_item.text(2,c.c005),'';'||chr(10)||
'  q:=q||''''''<b>''||wwv_flow_lang.system_message(''F4500_NOT_AVAIL_SEARCH'')||''</b>'''') condition, '';  '||chr(10)||
'  q:=q||''DECODE(c.c007,null,'''''' || l_none || '''''',c.c007) comments, '';'||chr(10)||
'  q:=q||''wwv_flow_item.hidden(3,c.c006) data_type,  ''; '||chr(10)||
'  q:=q||''wwv_flow_item.hidden(4,c.c004) column_name, '';'||chr(10)||
'  q:=q||''wwv_flow_item.hid';

s:=s||'den(5,c.c003) column_id2, '';'||chr(10)||
'  q:=q||''wwv_flow_item.hidden(6,c.c007) comments2  ''; '||chr(10)||
'  q:=q||''from wwv_flow_collections c   '';'||chr(10)||
'  q:=q||''where collection_name = ''''SW_QBE''''  '';              '||chr(10)||
'  q:=q||''order by to_number(c.c003) '';      '||chr(10)||
'else '||chr(10)||
'  q:=''select '';'||chr(10)||
'  q:=q||''wwv_flow_item.checkbox(1,x.column_name) include, '';  '||chr(10)||
'  q:=q||''x.column_id||''''.'''', '';'||chr(10)||
'  q:=q||''x.column_name column_name, '';'||chr(10)||
'  q:=q||''de';

s:=s||'code(substr(x.data_type,1,decode(instr(x.data_type,''''(''''),0,length(x.data_type),instr(x.data_type,''''('''')-1)),''''VARCHAR2'''','';'||chr(10)||
'  q:=q||''''''<img src="#IMAGE_PREFIX#varchar.gif" width="16" height="16" alt="varchar2" />'''''';'||chr(10)||
'  q:=q||'',''''CHAR'''',''''<img src="#IMAGE_PREFIX#varchar.gif" width="16" height="16" alt="char" />'''''';'||chr(10)||
'  q:=q||'',''''DATE'''',''''<img src="#IMAGE_PREFIX#date.gif" width="16" height="16" alt="';

s:=s||'date" />'''' '';'||chr(10)||
'q:=q||'',''''TIMESTAMP'''',''''<img src="#IMAGE_PREFIX#date.gif" width="16" height="16" alt="date" />'''' '';'||chr(10)||
'  q:=q||'',''''NUMBER'''',''''<img src="#IMAGE_PREFIX#number.gif" width="16" height="16" alt="number" />'''' '';'||chr(10)||
'  q:=q||'',''''no image'''') dt_img, ''; '||chr(10)||
'  q:=q||''DECODE(substr(x.data_type,1,decode(instr(x.data_type,''''(''''),0,length(x.data_type),instr(x.data_type,''''('''')-1)),''''VARCHAR2'''',wwv_flow_item.';

s:=s||'text(2),'';'||chr(10)||
'  q:=q||''''''CHAR'''',wwv_flow_item.text(2),'';'||chr(10)||
'  q:=q||''''''NUMBER'''',wwv_flow_item.text(2),'';'||chr(10)||
'  q:=q||''''''DATE'''',wwv_flow_item.text(2),'';'||chr(10)||
'  q:=q||''''''CLOB'''',wwv_flow_item.text(2),'';'||chr(10)||
'  q:=q||''''''TIMESTAMP'''',wwv_flow_item.text(2),'';'||chr(10)||
'  q:=q||''''''BINARY_FLOAT'''',wwv_flow_item.text(2),'';'||chr(10)||
'  q:=q||''''''BINARY_DOUBLE'''',wwv_flow_item.text(2),'';'||chr(10)||
'  q:=q||''''''<b>''||wwv_flow_lang.system_message(''F4500_NOT_AVAIL_S';

s:=s||'EARCH'')||''</b>'''') condition, '';    '||chr(10)||
'  q:=q||''DECODE(x.comments,null,'''''' || l_none || '''''',x.comments) comments, '';'||chr(10)||
'  q:=q||''wwv_flow_item.hidden(3,x.data_type) data_type,  ''; '||chr(10)||
'  q:=q||''wwv_flow_item.hidden(4,x.column_name) column_name2, '';'||chr(10)||
'  q:=q||''wwv_flow_item.hidden(5,x.column_id) column_id2, '';'||chr(10)||
'  q:=q||''wwv_flow_item.hidden(6,x.comments) comments2 '';            '||chr(10)||
'  q:=q||''from ( '';'||chr(10)||
'  q:=q||''sele';

s:=s||'ct  '';'||chr(10)||
'  q:=q||''t.owner, '';'||chr(10)||
'  q:=q||''t.column_id, '';'||chr(10)||
'  q:=q||''t.column_name, '';'||chr(10)||
'  q:=q||''t.data_type, '';'||chr(10)||
'  q:=q||''c.comments, '';'||chr(10)||
'  q:=q||''t.table_name '';'||chr(10)||
'  q:=q||''from sys.dba_tab_columns t, sys.dba_col_comments c '';'||chr(10)||
'  q:=q||''where t.owner = c.owner '';'||chr(10)||
'  q:=q||''and t.table_name = c.table_name '';'||chr(10)||
'  q:=q||''and t.column_name = c.column_name '';'||chr(10)||
'  q:=q||''and t.owner = :OBJECT_OWNER '';'||chr(10)||
'  q:=q||''and t.ta';

s:=s||'ble_name = :OBJECT_NAME '';  '||chr(10)||
'  q:=q||''order by t.column_id) x'';'||chr(10)||
'end if;     '||chr(10)||
'return q;'||chr(10)||
'end; '||chr(10)||
'';

wwv_flow_api.create_report_region (
  p_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 42.4508,
  p_name=> '<a name="QBE"></a>질의',
  p_region_name=>'',
  p_template=> 271411522116469289.4508+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_header=> '<p>확인하려는 열을 선택하십시오. 특정 행을 제한하려면 <b>열 조건</b>에 조건을 입력하십시오. 대체 문자로 "%"를 사용하십시오.</p>',
  p_customized=> '0',
  p_query_row_template=> 11028007180514315.4508+ wwv_flow_api.g_id_offset,
  p_plug_query_max_columns=> 60,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '5000',
  p_query_options=> 'GENERIC_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48744611625771964.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'COL01',
  p_column_display_sequence=> 1,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48744703732771965.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'COL02',
  p_column_display_sequence=> 2,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48744831767771965.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'COL03',
  p_column_display_sequence=> 3,
  p_column_heading=> '열',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48744920914771965.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'COL04',
  p_column_display_sequence=> 4,
  p_column_heading=> '유형',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48745020203771965.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'COL05',
  p_column_display_sequence=> 5,
  p_column_heading=> '열 조건',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48745129314771965.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'COL06',
  p_column_display_sequence=> 6,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48745220420771965.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'COL07',
  p_column_display_sequence=> 7,
  p_column_heading=> '설명',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48745329126771966.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'COL08',
  p_column_display_sequence=> 8,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48745431859771966.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'COL09',
  p_column_display_sequence=> 9,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48745516120771966.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'COL10',
  p_column_display_sequence=> 10,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48745617768771966.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'COL11',
  p_column_display_sequence=> 11,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48745720531771966.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'COL12',
  p_column_display_sequence=> 12,
  p_column_heading=> 'COL12',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48745806330771966.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'COL13',
  p_column_display_sequence=> 13,
  p_column_heading=> 'COL13',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48745928932771966.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'COL14',
  p_column_display_sequence=> 14,
  p_column_heading=> 'COL14',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48746018801771966.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'COL15',
  p_column_display_sequence=> 15,
  p_column_heading=> 'COL15',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 69242806143362965.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'COL16',
  p_column_display_sequence=> 16,
  p_column_heading=> 'Col16',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 69242910418362965.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'COL17',
  p_column_display_sequence=> 17,
  p_column_heading=> 'Col17',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 69243007646362965.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 18,
  p_form_element_id=> null,
  p_column_alias=> 'COL18',
  p_column_display_sequence=> 18,
  p_column_heading=> 'Col18',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 69243112334362966.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 19,
  p_form_element_id=> null,
  p_column_alias=> 'COL19',
  p_column_display_sequence=> 19,
  p_column_heading=> 'Col19',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 69243214008362966.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 20,
  p_form_element_id=> null,
  p_column_alias=> 'COL20',
  p_column_display_sequence=> 20,
  p_column_heading=> 'Col20',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146117425755734018.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 21,
  p_form_element_id=> null,
  p_column_alias=> 'COL21',
  p_column_display_sequence=> 21,
  p_column_heading=> 'Col21',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146117519706734019.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 22,
  p_form_element_id=> null,
  p_column_alias=> 'COL22',
  p_column_display_sequence=> 22,
  p_column_heading=> 'Col22',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146117604210734019.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 23,
  p_form_element_id=> null,
  p_column_alias=> 'COL23',
  p_column_display_sequence=> 23,
  p_column_heading=> 'Col23',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146117701451734019.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 24,
  p_form_element_id=> null,
  p_column_alias=> 'COL24',
  p_column_display_sequence=> 24,
  p_column_heading=> 'Col24',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146117828148734019.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 25,
  p_form_element_id=> null,
  p_column_alias=> 'COL25',
  p_column_display_sequence=> 25,
  p_column_heading=> 'Col25',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146117925306734019.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 26,
  p_form_element_id=> null,
  p_column_alias=> 'COL26',
  p_column_display_sequence=> 26,
  p_column_heading=> 'Col26',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146118011647734019.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 27,
  p_form_element_id=> null,
  p_column_alias=> 'COL27',
  p_column_display_sequence=> 27,
  p_column_heading=> 'Col27',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146118111635734019.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 28,
  p_form_element_id=> null,
  p_column_alias=> 'COL28',
  p_column_display_sequence=> 28,
  p_column_heading=> 'Col28',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146118221134734019.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 29,
  p_form_element_id=> null,
  p_column_alias=> 'COL29',
  p_column_display_sequence=> 29,
  p_column_heading=> 'Col29',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146118327180734020.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 30,
  p_form_element_id=> null,
  p_column_alias=> 'COL30',
  p_column_display_sequence=> 30,
  p_column_heading=> 'Col30',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146118431742734020.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 31,
  p_form_element_id=> null,
  p_column_alias=> 'COL31',
  p_column_display_sequence=> 31,
  p_column_heading=> 'Col31',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146118500343734020.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 32,
  p_form_element_id=> null,
  p_column_alias=> 'COL32',
  p_column_display_sequence=> 32,
  p_column_heading=> 'Col32',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146118621698734020.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 33,
  p_form_element_id=> null,
  p_column_alias=> 'COL33',
  p_column_display_sequence=> 33,
  p_column_heading=> 'Col33',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146118731553734020.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 34,
  p_form_element_id=> null,
  p_column_alias=> 'COL34',
  p_column_display_sequence=> 34,
  p_column_heading=> 'Col34',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146118829855734020.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 35,
  p_form_element_id=> null,
  p_column_alias=> 'COL35',
  p_column_display_sequence=> 35,
  p_column_heading=> 'Col35',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146118929603734020.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 36,
  p_form_element_id=> null,
  p_column_alias=> 'COL36',
  p_column_display_sequence=> 36,
  p_column_heading=> 'Col36',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146119025530734020.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 37,
  p_form_element_id=> null,
  p_column_alias=> 'COL37',
  p_column_display_sequence=> 37,
  p_column_heading=> 'Col37',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146119106861734020.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 38,
  p_form_element_id=> null,
  p_column_alias=> 'COL38',
  p_column_display_sequence=> 38,
  p_column_heading=> 'Col38',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146119217706734021.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 39,
  p_form_element_id=> null,
  p_column_alias=> 'COL39',
  p_column_display_sequence=> 39,
  p_column_heading=> 'Col39',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146119328043734021.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 40,
  p_form_element_id=> null,
  p_column_alias=> 'COL40',
  p_column_display_sequence=> 40,
  p_column_heading=> 'Col40',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146119413258734021.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 41,
  p_form_element_id=> null,
  p_column_alias=> 'COL41',
  p_column_display_sequence=> 41,
  p_column_heading=> 'Col41',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146119519709734021.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 42,
  p_form_element_id=> null,
  p_column_alias=> 'COL42',
  p_column_display_sequence=> 42,
  p_column_heading=> 'Col42',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146119627127734021.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 43,
  p_form_element_id=> null,
  p_column_alias=> 'COL43',
  p_column_display_sequence=> 43,
  p_column_heading=> 'Col43',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146119724022734021.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 44,
  p_form_element_id=> null,
  p_column_alias=> 'COL44',
  p_column_display_sequence=> 44,
  p_column_heading=> 'Col44',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146119812299734021.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 45,
  p_form_element_id=> null,
  p_column_alias=> 'COL45',
  p_column_display_sequence=> 45,
  p_column_heading=> 'Col45',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146119908892734021.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 46,
  p_form_element_id=> null,
  p_column_alias=> 'COL46',
  p_column_display_sequence=> 46,
  p_column_heading=> 'Col46',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146120005803734021.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 47,
  p_form_element_id=> null,
  p_column_alias=> 'COL47',
  p_column_display_sequence=> 47,
  p_column_heading=> 'Col47',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146120112231734022.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 48,
  p_form_element_id=> null,
  p_column_alias=> 'COL48',
  p_column_display_sequence=> 48,
  p_column_heading=> 'Col48',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146120200318734022.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 49,
  p_form_element_id=> null,
  p_column_alias=> 'COL49',
  p_column_display_sequence=> 49,
  p_column_heading=> 'Col49',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146120311587734022.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 50,
  p_form_element_id=> null,
  p_column_alias=> 'COL50',
  p_column_display_sequence=> 50,
  p_column_heading=> 'Col50',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146120418996734022.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 51,
  p_form_element_id=> null,
  p_column_alias=> 'COL51',
  p_column_display_sequence=> 51,
  p_column_heading=> 'Col51',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146120513900734022.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 52,
  p_form_element_id=> null,
  p_column_alias=> 'COL52',
  p_column_display_sequence=> 52,
  p_column_heading=> 'Col52',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146120609695734022.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 53,
  p_form_element_id=> null,
  p_column_alias=> 'COL53',
  p_column_display_sequence=> 53,
  p_column_heading=> 'Col53',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146120700991734022.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 54,
  p_form_element_id=> null,
  p_column_alias=> 'COL54',
  p_column_display_sequence=> 54,
  p_column_heading=> 'Col54',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146120810759734022.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 55,
  p_form_element_id=> null,
  p_column_alias=> 'COL55',
  p_column_display_sequence=> 55,
  p_column_heading=> 'Col55',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146120922378734022.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 56,
  p_form_element_id=> null,
  p_column_alias=> 'COL56',
  p_column_display_sequence=> 56,
  p_column_heading=> 'Col56',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146121022409734023.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 57,
  p_form_element_id=> null,
  p_column_alias=> 'COL57',
  p_column_display_sequence=> 57,
  p_column_heading=> 'Col57',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146121118439734023.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 58,
  p_form_element_id=> null,
  p_column_alias=> 'COL58',
  p_column_display_sequence=> 58,
  p_column_heading=> 'Col58',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146121200153734023.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 59,
  p_form_element_id=> null,
  p_column_alias=> 'COL59',
  p_column_display_sequence=> 59,
  p_column_heading=> 'Col59',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 146121301000734023.4508 + wwv_flow_api.g_id_offset,
  p_region_id=> 101162609984227437.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 60,
  p_form_element_id=> null,
  p_column_alias=> 'COL60',
  p_column_display_sequence=> 60,
  p_column_heading=> 'Col60',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 103235917082519926.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 42.4508,
  p_plug_name=> '<a name="ORD"></a>Ordering',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 131505108345142117.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 42.4508,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 106954406499588564.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 25,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 162238101270647034.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 42.4508,
  p_plug_name=> 'MV Tabs',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 15852414527126687 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_plug_display_when_condition => 'OBJECT_TYPE',
  p_plug_display_when_cond2=>'MATERIALIZED VIEW',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 101176810600355984.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 42.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 131505108345142117+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:&F4500_LAST_VIEW.:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 101177717873358107.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 42.4508,
  p_button_sequence=> 20,
  p_button_plug_id => 131505108345142117+wwv_flow_api.g_id_offset,
  p_button_name    => 'QUERY',
  p_button_image_alt=> '질의',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 61435025248281233.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 42.4508,
  p_button_sequence=> 30,
  p_button_plug_id => 131505108345142117+wwv_flow_api.g_id_offset,
  p_button_name    => 'PREVIOUS',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P42_PREV_PAGE',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>101178015886358109.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_branch_action=> '46',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>101177717873358107.4508+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>1255329411407271.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'F4500_P42_INCLUDE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 140,
  p_item_plug_id => 101162609984227437.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'Include',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'객체 유형';

wwv_flow_api.create_page_item(
  p_id=>1851230509574095.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'F4500_P42_OBJECT_TYPE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 131505108345142117.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'객체 유형:',
  p_source=>'OBJECT_TYPE',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_AND_SAVE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>기본적으로 질의 결과는 참조 무결성 참조 테이블 링크와 함께 표시됩니다. 테이블에 많은 참조 무결성 테이블이 있는 경우 보다 빠른 질의 결과를 얻으려면 <strong>숨기기</strong>를 선택하십시오.</p>';

wwv_flow_api.create_page_item(
  p_id=>3561718403811883.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'P42_SHOW_DRILL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 35,
  p_item_plug_id => 101162609984227437.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'N',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'링크 드릴 업 및 드릴 다운:',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'SHOW.HIDE.Y.N',
  p_lov => '.'||to_char(88026529019446655 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 2,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'OBJECT_TYPE',
  p_display_when2=>'TABLE',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>61433811957267869.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'P42_PREV_PAGE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 150,
  p_item_plug_id => 101162609984227437.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Prev Page',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>66628210769913219.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'P42_OBJECT_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 101162609984227437.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'데이터베이스 객체 소유자의 이름';

wwv_flow_api.create_page_item(
  p_id=>101163711050242106.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'F4500_P42_OBJECT_OWNER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 131505108345142117.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'스키마:',
  p_post_element_text=>'&nbsp;',
  p_source=>'OB_SCHEMA',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_AND_SAVE_LOV',
  p_named_lov=> 'LIST_AVAILABLE_SCHEMAS',
  p_lov => 'declare'||chr(10)||
'  q      varchar2(32767) := null;'||chr(10)||
'begin  '||chr(10)||
'  q:=''select htf.escape_sc(upper(c.schema)) d, upper(c.schema) v '';'||chr(10)||
'  q:=q||''from   wwv_flow_company_schemas c, '';'||chr(10)||
'  q:=q||''       wwv_flow_fnd_user u '';'||chr(10)||
'  q:=q||''where  c.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.security_group_id = :flow_security_group_id and '';'||chr(10)||
'  q:=q||''       u.user_name = :flow_user and '';'||chr(10)||
'  q:=q||''       (u.ALLOW_ACCESS_TO_SCHEMAS is null or '';'||chr(10)||
'  q:=q||''        instr('''':''''||u.ALLOW_ACCESS_TO_SCHEMAS||'''':'''','''':''''||c.schema||'''':'''')>0) '';'||chr(10)||
'  q:=q||''order by 1'';  '||chr(10)||
'  return q;'||chr(10)||
'end;',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'테이블 또는 뷰 이름';

wwv_flow_api.create_page_item(
  p_id=>101164306090244448.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'F4500_P42_OBJECT_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 131505108345142117.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'테이블/뷰 이름:',
  p_post_element_text=>'&nbsp;',
  p_source=>'OBJECT_NAME',
  p_source_type=> 'ITEM',
  p_display_as=> 'DISPLAY_AND_SAVE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187652405321922937.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>101190532012445134.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'F4500_P42_QUERY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 101162609984227437.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'Query',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'모든 열을 선택합니다.';

wwv_flow_api.create_page_item(
  p_id=>101237730494251100.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'F4500_P42_CHECK_ALL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 101162609984227437.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'N',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'모두 선택:',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_lov => 'STATIC:;Y',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onclick="ToggleAll(this)"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>정렬 순서를 선택하십시오.</p>';

wwv_flow_api.create_page_item(
  p_id=>103239521574563385.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'F4500_P42_ORDER_BY_1',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 103235917082519926.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'정렬 기준',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'P42.ORDER.COLUMNS',
  p_lov => 'select htf.escape_sc(column_name) d, column_name v from sys.dba_tab_columns where owner = :F4500_P42_OBJECT_OWNER and table_name = :F4500_P42_OBJECT_NAME order by column_id',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'<p>정렬 순서를 선택하십시오.</p>';

wwv_flow_api.create_page_item(
  p_id=>103241122208578357.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'F4500_P42_ORDER_BY_2',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 103235917082519926.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'정렬 기준',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'P42.ORDER.COLUMNS',
  p_lov => 'select htf.escape_sc(column_name) d, column_name v from sys.dba_tab_columns where owner = :F4500_P42_OBJECT_OWNER and table_name = :F4500_P42_OBJECT_NAME order by column_id',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'정렬 순서를 선택하십시오.';

wwv_flow_api.create_page_item(
  p_id=>103242722412593418.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'F4500_P42_ORDER_BY_3',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 103235917082519926.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'정렬 기준',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'P42.ORDER.COLUMNS',
  p_lov => 'select htf.escape_sc(column_name) d, column_name v from sys.dba_tab_columns where owner = :F4500_P42_OBJECT_OWNER and table_name = :F4500_P42_OBJECT_NAME order by column_id',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>103245104512601726.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'F4500_P42_ASC_1',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 103235917082519926.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'ASC',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'ASC.DESC.RETURNS.ASC.DESC',
  p_lov => '.'||to_char(88023114905423598 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>103246124125607804.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'F4500_P42_ASC_2',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 103235917082519926.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'ASC',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'ASC.DESC.RETURNS.ASC.DESC',
  p_lov => '.'||to_char(88023114905423598 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>103246819380610060.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'F4500_P42_ASC_3',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 110,
  p_item_plug_id => 103235917082519926.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'ASC',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'ASC.DESC.RETURNS.ASC.DESC',
  p_lov => '.'||to_char(88023114905423598 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 3301520602864636.4508+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>106409321557809657.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'F4500_P42_PREV_OBJECT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 120,
  p_item_plug_id => 101162609984227437.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'Prev Object',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>106571602146350378.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_name=>'F4500_P42_VIEW_QUERY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 130,
  p_item_plug_id => 101162609984227437.4508+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'View Query',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 1260112919412009.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_computation_sequence => 10,
  p_computation_item=> 'F4500_P42_INCLUDE',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'wwv_flow_utilities.table_to_string2(wwv_flow.g_f01);',
  p_compute_when => '',
  p_compute_when_type=>'%null%');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 106410210990814482.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4508,
  p_computation_sequence => 10,
  p_computation_item=> 'F4500_P42_PREV_OBJECT',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> ':OBJECT_NAME',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 101181013311377789.4508 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 42.4508,
  p_validation_name => 'select at least one column',
  p_validation_sequence=> 10,
  p_validation => 'declare'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  if wwv_flow.g_f01.count = 0 then'||chr(10)||
''||chr(10)||
'    return false;'||chr(10)||
''||chr(10)||
'  else'||chr(10)||
''||chr(10)||
'    return true;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '열을 보려면 한 개 이상 지정해야 합니다. ',
  p_when_button_pressed=> 101177717873358107.4508 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4508 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_util.get_object_info ('||chr(10)||
'      p_object_id    => :OBJECT_ID,'||chr(10)||
'      p_object_owner => :OB_SCHEMA,'||chr(10)||
'      p_object_name  => :OBJECT_NAME,'||chr(10)||
'      p_object_type  => :OBJECT_TYPE);'||chr(10)||
''||chr(10)||
'--'||chr(10)||
'-- Check that the user has the appropriate privileges'||chr(10)||
'--'||chr(10)||
'wwv_flow_sw_api.check_priv ( p_schema => :OBJECT_OWNER );';

wwv_flow_api.create_page_process(
  p_id     => 66629428776918411.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 42.4508,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set values based on object id',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_sql          varchar2(32767) := null;'||chr(10)||
'  l_view_sql     varchar2(32767) := null;'||chr(10)||
'  l_order_by     varchar2(32767) := null;'||chr(10)||
'  l_ct           pls_integer := 1;  '||chr(10)||
'  '||chr(10)||
'  l_column       varchar2(4000) := null; '||chr(10)||
'begin'||chr(10)||
'  if wwv_flow.g_f01.count = 0 then'||chr(10)||
'      raise_application_error (-20001,''You must check at least one column to view.'');'||chr(10)||
'  end if;'||chr(10)||
'   '||chr(10)||
'  begin'||chr(10)||
'  l_sql := wwv_flow_table_drill.bui';

p:=p||'ld_sql ('||chr(10)||
'               p_owner     => :OBJECT_OWNER,'||chr(10)||
'               p_to_table  => :OBJECT_NAME,'||chr(10)||
'               p_type      => :OBJECT_TYPE,'||chr(10)||
'               p_include   => wwv_flow_utilities.table_to_string2(wwv_flow.g_f01),'||chr(10)||
'               p_show_drill => :P42_SHOW_DRILL);'||chr(10)||
''||chr(10)||
'  l_view_sql := wwv_flow_table_drill.build_view_sql ('||chr(10)||
'               p_owner     => :OBJECT_OWNER,'||chr(10)||
'               p_to_table ';

p:=p||' => :OBJECT_NAME,'||chr(10)||
'               p_type      => :OBJECT_TYPE,'||chr(10)||
'               p_include   => wwv_flow_utilities.table_to_string2(wwv_flow.g_f01));'||chr(10)||
'  exception when others then'||chr(10)||
'    raise_application_error (-20001,''build_sql error ''||sqlerrm);'||chr(10)||
'  end;'||chr(10)||
'  '||chr(10)||
'  begin'||chr(10)||
'  for j in 1..wwv_flow.g_f02.count loop'||chr(10)||
'    '||chr(10)||
'   l_column := wwv_flow.g_f04(j);'||chr(10)||
'   l_column := ''"''||l_column||''"'';'||chr(10)||
'    '||chr(10)||
'   if wwv_flow.g_f02(j';

p:=p||') is not null then      '||chr(10)||
'     if l_ct = 1 then      '||chr(10)||
'       l_sql:=l_sql||'' where ''||l_column||'' like ''; '||chr(10)||
'       l_view_sql:=l_view_sql||''where ''||l_column||'' like '';      '||chr(10)||
'     elsif l_ct > 1 then'||chr(10)||
'       l_sql:=l_sql||'' and ''||l_column||'' like ''; '||chr(10)||
'       l_view_sql:=l_view_sql||''and ''||l_column||'' like '';       '||chr(10)||
'     end if; '||chr(10)||
'     '||chr(10)||
'     if wwv_flow.g_f03(j) in (''VARCHAR2'',''CHAR'') then'||chr(10)||
'        l_s';

p:=p||'ql:=l_sql||''''''''||wwv_flow.g_f02(j)||'''''''';'||chr(10)||
'        l_view_sql:=l_view_sql||''''''''||wwv_flow.g_f02(j)||''''''''||chr(10);'||chr(10)||
'     elsif wwv_flow.g_f03(j) = ''DATE'' then'||chr(10)||
'        l_sql:=l_sql||''to_date(''''''||wwv_flow.g_f02(j)||'''''')'';'||chr(10)||
'        l_view_sql:=l_view_sql||''to_date(''''''||wwv_flow.g_f02(j)||'''''')''||chr(10);'||chr(10)||
'     else'||chr(10)||
' 	l_sql:=l_sql||''''''''||wwv_flow.g_f02(j)||'''''''';'||chr(10)||
'        l_view_sql:=l_view_sql||''''''''||wwv_f';

p:=p||'low.g_f02(j)||''''''''||chr(10);'||chr(10)||
'     end if;'||chr(10)||
'     '||chr(10)||
'     l_ct := l_ct + 1;     '||chr(10)||
'   end if;    '||chr(10)||
'  end loop; '||chr(10)||
'  exception when others then'||chr(10)||
'    raise_application_error (-20001,''where clause error ''||sqlerrm);'||chr(10)||
'  end;'||chr(10)||
'  '||chr(10)||
'  --'||chr(10)||
'  -- build order by clause'||chr(10)||
'  --'||chr(10)||
'  begin'||chr(10)||
'  if replace(:F4500_P42_ORDER_BY_1,''%''||''null%'',null) is not null then    '||chr(10)||
'    l_order_by := ''"''||:F4500_P42_ORDER_BY_1||''" ''||:F4500_P42_ASC_1';

p:=p||';'||chr(10)||
'  end if;  '||chr(10)||
'  if replace(:F4500_P42_ORDER_BY_2,''%''||''null%'',null) is not null then'||chr(10)||
'    if l_order_by is not null then'||chr(10)||
'      l_order_by := l_order_by||'', '';'||chr(10)||
'    end if;'||chr(10)||
'    l_order_by := l_order_by||''"''||:F4500_P42_ORDER_BY_2||''" ''||:F4500_P42_ASC_2;'||chr(10)||
'  end if;'||chr(10)||
'  if replace(:F4500_P42_ORDER_BY_3,''%''||''null%'',null) is not null then'||chr(10)||
'    if l_order_by is not null then'||chr(10)||
'      l_order_by := l_order_by||';

p:=p||''', '';'||chr(10)||
'    end if;'||chr(10)||
'    l_order_by := l_order_by||''"''||:F4500_P42_ORDER_BY_3||''" ''||:F4500_P42_ASC_3;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'  if l_order_by is not null then'||chr(10)||
'    l_sql := l_sql||'' order by ''||l_order_by;'||chr(10)||
'    l_view_sql := l_view_sql||''order by ''||l_order_by;'||chr(10)||
'  end if;  '||chr(10)||
'  exception when others then'||chr(10)||
'    raise_application_error (-20001,''order by error ''||sqlerrm);'||chr(10)||
'  end;'||chr(10)||
'   '||chr(10)||
'  begin  '||chr(10)||
'  -- '||chr(10)||
'  -- assign the query ';

p:=p||'as :F4500_P42_QUERY value '||chr(10)||
'  --'||chr(10)||
'  --:F4500_P42_QUERY := l_sql;'||chr(10)||
'  wwv_flow.update_cache_with_write (p_name=>''F4500_P42_QUERY'', p_value=> l_sql);'||chr(10)||
'  -- '||chr(10)||
'  -- to show sql in SQL command processor '||chr(10)||
'  --'||chr(10)||
'  --:F4500_P42_VIEW_QUERY := l_view_sql;'||chr(10)||
'  wwv_flow.update_cache_with_write (p_name=>''F4500_P42_VIEW_QUERY'', p_value=> l_view_sql);'||chr(10)||
'  exception when others then'||chr(10)||
'    raise_application_error (-20001,''assi';

p:=p||'gn value error ''||sqlerrm);'||chr(10)||
'  end; '||chr(10)||
'exception when others then'||chr(10)||
'  raise_application_error(-20001,''l_sql length=''||length(l_sql)||'' ''||''l_view_sql length=''||length(l_view_sql)||'' ''||sqlerrm);'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 101189126645417246.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 42.4508,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'build query for p46 report',
  p_process_sql_clob => p, 
  p_process_error_message=> '적합한 질의를 작성하는 중 오류가 발생했습니다.',
  p_process_when_button_id=>101177717873358107.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'46';

wwv_flow_api.create_page_process(
  p_id     => 103312424276747343.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 42.4508,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'clear p46 cache',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>101177717873358107.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_disp_page_plugs.reset_region_pagination(101186020403404926);';

wwv_flow_api.create_page_process(
  p_id     => 102992403743220689.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 42.4508,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'reset pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>101177717873358107.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 101942521793263623.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 42.4508,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_sw_api.create_sw_qbe_collection ('||chr(10)||
'    p_object_owner     => :OBJECT_OWNER,'||chr(10)||
'    p_object_name      => :OBJECT_NAME,'||chr(10)||
'    p_column_ids       => wwv_flow.g_f05,'||chr(10)||
'    p_column_names     => wwv_flow.g_f04,'||chr(10)||
'    p_query_conditions => wwv_flow.g_f02,'||chr(10)||
'    p_data_types       => wwv_flow.g_f03,'||chr(10)||
'    p_comments         => wwv_flow.g_f06,    '||chr(10)||
'    p_checked          => wwv_flow.g_f01'||chr(10)||
'    );';

wwv_flow_api.create_page_process(
  p_id     => 106129625187320240.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 42.4508,
  p_process_sequence=> 1,
  p_process_point=> 'ON_SUBMIT_BEFORE_COMPUTATION',
  p_process_type=> 'PLSQL',
  p_process_name=> 'create SW_QBE collection',
  p_process_sql_clob => p, 
  p_process_error_message=> 'sw_qbe 콜렉션을 생성하는 중 오류가 발생했습니다.',
  p_process_when_button_id=>101177717873358107.4508 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 42.4508
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_43.45
prompt  ...PAGE 43.4508: DDL 생성
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEUTL/sql_utl_ddl.htm';

ph:=ph||'<script type="text/javascript">'||chr(10)||
'function ToggleAll(e){'||chr(10)||
'  if (e.checked){CheckAll(); }'||chr(10)||
'  else{ClearAll();}'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'function CheckAll() { '||chr(10)||
'  html_CheckAll(''objects'',true);'||chr(10)||
'}'||chr(10)||
''||chr(10)||
'function ClearAll() {  '||chr(10)||
'  html_CheckAll(''objects'',false);'||chr(10)||
'}'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 43.4508,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'DDL 생성',
  p_step_title=> 'DDL 생성',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 215532403383713875+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => 20823807893218193.4508+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164225',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>43.4508,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>43.4508,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6811902815622003.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 43.4508,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(6696510824685479 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 6698104029693013.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 85523417424861176.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 43.4508,
  p_plug_name=> 'DDL 생성',
  p_region_name=>'',
  p_plug_template=> 140310301493602560.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'List:  DDL Wizard';

wwv_flow_api.create_page_plug (
  p_id=> 87143407026576996.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 43.4508,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 87134126220568115 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>DDL을 생성하려는 객체 유형을 선택하십시오.</p>'||chr(10)||
'<p><b>DDL 생성</b>을 누르면 선택된 객체 유형에 대한 DDL이 생성됩니다. 선택된 객체 유형에 대한 객체 이름을 선택하려면 <b>다음</b>을 누르십시오.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 239291101376481238.4508 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 43.4508,
  p_plug_name=> 'DDL 생성',
  p_region_name=>'',
  p_plug_template=> 81906901123495005.4508+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 217757328098083233.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 43.4508,
  p_button_sequence=> 50,
  p_button_plug_id => 85523417424861176+wwv_flow_api.g_id_offset,
  p_button_name    => 'CHECK_ALL',
  p_button_image   => 'template:'||to_char(26471527454710106+wwv_flow_api.g_id_offset),
  p_button_image_alt=> '모두 선택',
  p_button_position=> 'BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:CheckAll();',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 217758001217084923.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 43.4508,
  p_button_sequence=> 60,
  p_button_plug_id => 85523417424861176+wwv_flow_api.g_id_offset,
  p_button_name    => 'UNCHECK_ALL',
  p_button_image   => 'template:'||to_char(26471527454710106+wwv_flow_api.g_id_offset),
  p_button_image_alt=> '모두 선택 취소',
  p_button_position=> 'BOTTOM',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:ClearAll();',
  p_button_condition_type=> 'NEVER',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 85527814598864609.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 43.4508,
  p_button_sequence=> 10,
  p_button_plug_id => 85523417424861176+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 87097320371476462.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 43.4508,
  p_button_sequence=> 20,
  p_button_plug_id => 85523417424861176+wwv_flow_api.g_id_offset,
  p_button_name    => 'GenerateDDL',
  p_button_image_alt=> 'DDL 생성',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 85539028451868614.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 43.4508,
  p_button_sequence=> 30,
  p_button_plug_id => 85523417424861176+wwv_flow_api.g_id_offset,
  p_button_name    => 'Next',
  p_button_image_alt=> '다음 &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 85533522217866787.4508 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 43.4508,
  p_button_sequence=> 40,
  p_button_plug_id => 85523417424861176+wwv_flow_api.g_id_offset,
  p_button_name    => 'Previous',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button