set define off
set verify off
set serveroutput on size 1000000
set feedback off
begin wwv_flow.g_import_in_progress := true; end; 
/
 
 
--application/set_environment
prompt  APPLICATION 4708 - APEX - New Service Signup
--
-- Application Export:
--   Application:     4708
--   Name:            APEX - New Service Signup
--   Date and Time:   08:07 Tuesday May 19, 2009
--   Exported By:     
--   Flashback:       0
--   Export Type:     Application Export
--   Version: 3.2.1.00.08
 
-- Import:
--   Using application builder
--   or
--   Using SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
 
-- Application Statistics:
--   Pages:                 9
--     Items:              20
--     Computations:        3
--     Validations:        22
--     Processes:           2
--     Regions:            18
--     Buttons:            24
--   Shared Components
--     Breadcrumbs:         0
--        Entries           0
--     Items:               2
--     Computations:        1
--     Processes:           0
--     Parent Tabs:         1
--     Tab Sets:            1
--        Tabs:             1
--     NavBars:             0
--     Lists:               2
--     Shortcuts:           1
--     Themes:              0
--     Templates:
--        Page:             3
--        List:             3
--        Report:           0
--        Label:            2
--        Region:           3
--     Messages:            0
--     Build Options:       1
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>10);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en-us'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2009.01.12');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := 4708;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(4708);
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(4708);
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => 4708,
  p_display_id=> 4708,
  p_owner => 'APEX_030200',
  p_name  => 'APEX - New Service Signup',
  p_alias => 'A198397503349472863',
  p_page_view_logging => 'YES',
  p_default_page_template=> 108132430112395957.4708 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=> 4674102852.4708 + wwv_flow_api.g_id_offset,
  p_default_region_template=> 4688102857.4708 + wwv_flow_api.g_id_offset,
  p_error_template    => 108132430112395957.4708 + wwv_flow_api.g_id_offset,
  p_charset           => 'utf-8',
  p_checksum_salt_last_reset => '20090519073429',
  p_max_session_length_sec=> 28800,
  p_home_link         => 'f?p=4700:10:&SESSION.',
  p_flow_language     => 'ko',
  p_flow_language_derived_from=> 'BROWSER',
  p_flow_image_prefix => '/i/',
  p_documentation_banner=> '',
  p_authentication    => 'CUSTOM2',
  p_login_url         => 'development_service_home_login',
  p_logout_url        => '',
  p_application_tab_set=> 1,
  p_logo_image => '#IMAGE_PREFIX#htmldb/apex_logo.gif',
  p_logo_image_attributes => 'width="300" height="30" alt="&PRODUCT_NAME."',
  p_public_url_prefix => '',
  p_public_user       => 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server      => '',
  p_cust_authentication_process=> '.'||to_char(108165525079033088 + wwv_flow_api.g_id_offset)||'.',
  p_cust_authentication_page=> '',
  p_custom_auth_login_url=> '',
  p_flow_version      => '&PRODUCT_NAME. 3.2.1.00.08',
  p_flow_status       => 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'This application is currently unavailable.',
  p_build_status      => 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'Y',
  p_vpd               => '',
  p_csv_encoding    => 'Y',
  p_theme_id => 3,
  p_default_label_template => 187206412134572319.4708 + wwv_flow_api.g_id_offset,
  p_default_list_template => 4794278052.4708 + wwv_flow_api.g_id_offset,
  p_substitution_string_01 => 'PRODUCT_NAME',
  p_substitution_value_01  => 'Application Express',
  p_substitution_string_02 => 'DONE',
  p_substitution_value_02  => '완료',
  p_substitution_string_03 => 'MSG_COMPANY',
  p_substitution_value_03  => '작업 영역: &COMPANY.',
  p_substitution_string_04 => 'CLOSE',
  p_substitution_value_04  => '닫기',
  p_substitution_string_05 => 'DATE_FORMAT',
  p_substitution_value_05  => 'rr/mm/dd',
  p_substitution_string_06 => 'LONG_DATE_FORMAT',
  p_substitution_value_06  => 'fmDay yyyy"년"mm"월"dd"일"',
  p_substitution_string_07 => 'TIME_FORMAT',
  p_substitution_value_07  => 'AM hh:mi:ss',
  p_substitution_string_08 => 'DATE_TIME_FORMAT',
  p_substitution_value_08  => 'rr/mm/dd AM hh:mi:ss',
  p_substitution_string_09 => 'RETURN_TO_APPLICATION',
  p_substitution_value_09  => '애플리케이션으로 돌아가기',
  p_substitution_string_10 => 'MSG_LANGUAGE',
  p_substitution_value_10  => '언어',
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss=> '20090518142942',
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
null;
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
null;
 
end;
/

prompt  ...application processes
--
prompt  ...application items
--
--application/shared_components/logic/application_items/f4700_req_new_schema
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 103247625354177724.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'F4700_REQ_NEW_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> 'N',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> '');
 
null;
 
end;
/

--application/shared_components/logic/application_items/help_page
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 318946157429.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'HELP_PAGE',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'flow page that you would like help for.');
 
null;
 
end;
/

prompt  ...application level computations
--
 
begin
 
--application/shared_components/logic/application_computations/f4700_req_new_schema
wwv_flow_api.create_flow_computation (
  p_id => 103248202067189926.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_computation_sequence => 10,
  p_computation_item => 'F4700_REQ_NEW_SCHEMA',
  p_computation_point    => 'ON_NEW_INSTANCE',
  p_computation_type => 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation => 'declare l_schema_status varchar2(255) := null;'||chr(10)||
'begin'||chr(10)||
'l_schema_status := wwv_flow_platform.get_preference(''REQ_NEW_SCHEMA'');'||chr(10)||
'return l_schema_status;'||chr(10)||
'end;',
  p_compute_when=> 'nvl(wwv_flow_platform.get_preference(''SERVICE_REQUEST_FLOW''),''MANUAL'') <> ''MANUAL''',
  p_compute_when_type=> 'PLSQL_EXPRESSION',
  p_computation_error_message=>'',
  p_computation_comment=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset);
 
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
--application/shared_components/navigation/tabs/standard/t_home
wwv_flow_api.create_tab (
  p_id=> 11449918469894500.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'HOME',
  p_tab_sequence=> 10,
  p_tab_name=> 'T_HOME',
  p_tab_text => '서비스&nbsp;요청',
  p_tab_step => 10,
  p_tab_also_current_for_pages => '20,25,40,1,27,30',
  p_tab_parent_tabset=>'TOP',
  p_required_patch=>null + wwv_flow_api.g_id_offset,
  p_tab_comment  => '');
 
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
--application/shared_components/navigation/tabs/parent/t_top
wwv_flow_api.create_toplevel_tab (
  p_id=> 11450003334894502.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'TOP',
  p_tab_sequence=> 20,
  p_tab_name  => 'T_TOP',
  p_tab_text  => '&PRODUCT_NAME.',
  p_tab_target=> 'f?p=4700:10:&SESSION.:',
  p_current_on_tabset=> 'HOME',
  p_required_patch=>null + wwv_flow_api.g_id_offset,
  p_tab_comment=> '');
 
 
end;
/

prompt  ...Shared Lists of values
--
--application/shared_components/user_interface/lov/new_or_existing_schema
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 150771414457811401.4708 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NEW_OR_EXISTING_SCHEMA',
  p_lov_query=> '.'||to_char(150771414457811401 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>150771702466811402.4708 + wwv_flow_api.g_id_offset,
  p_lov_id=>150771414457811401.4708 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'데이터베이스에서 기존 스키마 사용',
  p_lov_return_value=>'NO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>150771902162811402.4708 + wwv_flow_api.g_id_offset,
  p_lov_id=>150771414457811401.4708 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'새 스키마 요청',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

 
--application/pages/page_1.470
prompt  ...PAGE 1.4708: 작업 영역 요청 - 첫번째 페이지
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 1.4708,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'HOME',
  p_name   => '작업 영역 요청 - 첫번째 페이지',
  p_step_title=> '작업 영역 요청',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164415',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&PRODUCT_NAME. 등록을 시작합니다. &PRODUCT_NAME.에 대한 액세스 권한을 얻으려면 이 요청을 완료하십시오. &PRODUCT_NAME. 사이트 관리자가 요청을 검토하면 사용자의 계정 암호 또는 기타 상태 정보가 전자 메일로 전송됩니다.';

wwv_flow_api.create_page_plug (
  p_id=> 11481918919027098.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4708,
  p_plug_name=> '&PRODUCT_NAME. 등록',
  p_region_name=>'',
  p_plug_template=> 4688102857.4708+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 60576931321681806.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4708,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 4762183464 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 11484024561036668.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1.4708,
  p_button_sequence=> 20,
  p_button_plug_id => 11481918919027098+wwv_flow_api.g_id_offset,
  p_button_name    => 'QUIT',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4550:1',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 11483819050036659.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1.4708,
  p_button_sequence=> 10,
  p_button_plug_id => 11481918919027098+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> '다음 &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>66683221933097168.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4708,
  p_branch_action=> 'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>11483819050036659.4708+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 19-JAN-2007 16:08 by SBKENNED');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 1.4708
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_3.470
prompt  ...PAGE 3.4708: 작업 영역 요청 - 확인
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 3.4708,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '작업 영역 요청 - 확인',
  p_step_title=> '작업 영역 요청',
  p_step_sub_title => 'Confirmation',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164416',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 60540130725446991.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4708,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 4762183464 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'60555613032506142';

wwv_flow_api.create_page_plug (
  p_id=> 60559100827521617.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4708,
  p_plug_name=> '확인',
  p_region_name=>'',
  p_plug_template=> 60551104085502857.4708+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 60555613032506142 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 60542102714447006.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 3.4708,
  p_validation_name => 'Verification code',
  p_validation_sequence=> 10,
  p_validation => 'begin'||chr(10)||
'for c1 in'||chr(10)||
'       (select * from wwv_flow_request_verifications'||chr(10)||
'where session_id = :APP_SESSION) loop'||chr(10)||
'   if c1.verification_string = :P3_verification_code then'||chr(10)||
'      return true;'||chr(10)||
'   else '||chr(10)||
'      return false;'||chr(10)||
'   end if;'||chr(10)||
'end loop;'||chr(10)||
'return false;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '부적합한 확인 코드',
  p_associated_item=> 60541510567447001.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 3.4708
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_10.47
prompt  ...PAGE 10.4708: 작업 영역 요청 - 관리자
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 10.4708,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'HOME',
  p_name   => '작업 영역 요청 - 관리자',
  p_step_title=> '작업 영역 요청',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164416',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 303415113933.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4708,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 4762183464 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'nowrap="nowrap"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 317861684012.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4708,
  p_plug_name=> '&PRODUCT_NAME. 등록',
  p_region_name=>'',
  p_plug_template=> 4688102857.4708+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<p>요청한 서비스를 관리할 관리자를 지정하십시오. 요청이 승인되면 이 관리자에게는 다른 관리자 및 개발자를 설정할 수 있는 권한이 부여됩니다.</p>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 318063805793.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 10.4708,
  p_button_sequence=> 1,
  p_button_plug_id => 317861684012+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4550:1',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 317910858512.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 10.4708,
  p_button_sequence=> 10,
  p_button_plug_id => 317861684012+wwv_flow_api.g_id_offset,
  p_button_name    => 'Proceed',
  p_button_image_alt=> '다음 &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 60582700331710649.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 10.4708,
  p_button_sequence=> 20,
  p_button_plug_id => 317861684012+wwv_flow_api.g_id_offset,
  p_button_name    => 'Back',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>66684507519102505.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4708,
  p_branch_action=> 'f?p=&APP_ID.:20:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>317910858512.4708+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 19-JAN-2007 16:09 by SBKENNED');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'이 서비스를 관리할 관리자 사용자의 이름을 입력하십시오. 이것은 초기화할 관리자 이름이며 언제든지 기본 관리자를 변경할 수 있습니다.';

wwv_flow_api.create_page_item(
  p_id=>317887807410.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4708,
  p_name=>'ADMIN_FIRST_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 317861684012.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'이름',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187206506383572320.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'이 서비스를 관리할 관리자의 성을 입력하십시오. 이것은 초기화할 관리자 이름이며 언제든지 기본 관리자를 변경할 수 있습니다.';

wwv_flow_api.create_page_item(
  p_id=>317891809893.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4708,
  p_name=>'ADMIN_LAST_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 317861684012.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'성',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187206506383572320.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'이 서비스를 관리할 관리자의 전자 메일 주소를 입력하십시오. 이 전자 메일 계정에 초기 로그인 정보가 전송됩니다. 이것은 초기화할 관리자 이름이며 언제든지 기본 관리자를 변경할 수 있습니다.';

wwv_flow_api.create_page_item(
  p_id=>317897816033.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4708,
  p_name=>'ADMIN_EMAIL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 317861684012.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'전자 메일',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187206506383572320.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>172161311548860690.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 10.4708,
  p_name=>'P10_EMAIL_NOTE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 317861684012.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'wwv_flow_lang.system_message(''F4700.EMAIL_NOTE'')',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187206412134572319.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 85897954908.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 10.4708,
  p_validation_name => 'ADMIN_EMAIL Not Null',
  p_validation_sequence=> 1,
  p_validation => 'ADMIN_EMAIL',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '전자 메일을 지정해야 합니다.',
  p_associated_item=> 317897816033.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 21-FEB-2001 19:21');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 85893949306.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 10.4708,
  p_validation_name => 'ADMIN_FIRST_NAME Not Null',
  p_validation_sequence=> 2,
  p_validation => 'ADMIN_FIRST_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '이름을 지정해야 합니다.',
  p_associated_item=> 317887807410.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 21-FEB-2001 19:20');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 85895949307.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 10.4708,
  p_validation_name => 'ADMIN_LAST_NAME Not Null',
  p_validation_sequence=> 3,
  p_validation => 'ADMIN_LAST_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '성을 지정해야 합니다.',
  p_associated_item=> 317891809893.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 21-FEB-2001 19:20');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 200716226993770297.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 10.4708,
  p_validation_name => 'ADMIN_EMAIL must be valid',
  p_validation_sequence=> 13,
  p_validation => 'declare'||chr(10)||
'  l_at number;'||chr(10)||
'  l_dot number;'||chr(10)||
'begin'||chr(10)||
'  l_at := instr(nvl(:ADMIN_EMAIL,''x''),''@'');'||chr(10)||
'  l_dot := instr(nvl(:ADMIN_EMAIL,''x''),''.'',l_at);'||chr(10)||
'  return l_at > 1 and l_dot > 1 and (l_dot - l_at) > 1;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '전자 메일 주소가 부적합합니다.',
  p_validation_condition=> 'ADMIN_EMAIL',
  p_validation_condition_type=> 'ITEM_IS_NOT_NULL',
  p_when_button_pressed=> 317910858512.4708 + wwv_flow_api.g_id_offset,
  p_associated_item=> 317897816033.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 82851232592633865.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 10.4708,
  p_validation_name => 'ADMIN_EMAIL contains no spaces',
  p_validation_sequence=> 23,
  p_validation => 'ADMIN_EMAIL',
  p_validation_type => 'ITEM_CONTAINS_NO_SPACES',
  p_error_message => '전자 메일 주소에 공백이 있으면 안됩니다.',
  p_validation_condition=> 'ADMIN_EMAIL',
  p_validation_condition_type=> 'ITEM_IS_NOT_NULL',
  p_when_button_pressed=> 317910858512.4708 + wwv_flow_api.g_id_offset,
  p_associated_item=> 317897816033.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 10.4708
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_20.47
prompt  ...PAGE 20.4708: 작업 영역 요청 - 작업 영역
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 20.4708,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'HOME',
  p_name   => '작업 영역 요청 - 작업 영역',
  p_step_title=> '작업 영역 요청',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164416',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 318018076313.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 20.4708,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 4762183464 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 318020076313.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 20.4708,
  p_plug_name=> '&PRODUCT_NAME. 등록',
  p_region_name=>'',
  p_plug_template=> 4688102857.4708+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<p>소유하려는 작업 영역 이름을 입력하십시오. 서비스가 승인되면 작업 영역/사용자 이름/암호 조합을 사용하여 로그인하십시오.</p>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 318069824396.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20.4708,
  p_button_sequence=> 1,
  p_button_plug_id => 318020076313+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4550:1',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 318000076307.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20.4708,
  p_button_sequence=> 10,
  p_button_plug_id => 318020076313+wwv_flow_api.g_id_offset,
  p_button_name    => 'Proceed',
  p_button_image_alt=> '다음 &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4897434514.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20.4708,
  p_button_sequence=> 5,
  p_button_plug_id => 318020076313+wwv_flow_api.g_id_offset,
  p_button_name    => 'Back',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:::',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>103266820730242631.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4708,
  p_branch_action=> 'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>318000076307.4708+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 5,
  p_branch_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_branch_condition=> 'F4700_REQ_NEW_SCHEMA',
  p_branch_condition_text=>'Y',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 13-NOV-2007 01:44 by RAJU');
 
wwv_flow_api.create_page_branch(
  p_id=>66686503841110936.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4708,
  p_branch_action=> 'f?p=&APP_ID.:40:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 19-JAN-2007 16:10 by SBKENNED');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'소유하려는 작업 영역 이름을 입력하십시오. 서비스가 등록되면 작업 영역/사용자 이름/암호 조합을 사용하여 로그인하십시오.'||chr(10)||
''||chr(10)||
'작업 영역은 개발자 팀이 다중 애플리케이션에 대해 작업할 수 있는 데이터베이스 내의 가상 영역으로, 하나 이상의 스키마에서 권한을 가질 수 있습니다.';

wwv_flow_api.create_page_item(
  p_id=>11425313649770094.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4708,
  p_name=>'COMPANY_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 318020076313.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'작업 영역',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'TEXT_WITH_ENTER_SUBMIT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187206506383572320.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 103266130295235904.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4708,
  p_computation_sequence => 10,
  p_computation_item=> 'NEW_SCHEMA',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'YES',
  p_compute_when => 'F4700_REQ_NEW_SCHEMA',
  p_compute_when_text=>'Y',
  p_compute_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 11428213434779559.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 20.4708,
  p_validation_name => 'COMPANY_NAME Not Null',
  p_validation_sequence=> 1,
  p_validation => 'COMPANY_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '작업 영역을 지정해야 합니다.',
  p_associated_item=> 11425313649770094.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 12-DEC-2002 18:18');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 16917802136315321.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 20.4708,
  p_validation_name => 'company doesn''t already exist',
  p_validation_sequence=> 10,
  p_validation => 'for c1 in (select null'||chr(10)||
'             from wwv_flow_provision_company'||chr(10)||
'            where company_name = upper(:COMPANY_NAME)) loop'||chr(10)||
'  return false;'||chr(10)||
'  exit;'||chr(10)||
'end loop;'||chr(10)||
'for c1 in (select null'||chr(10)||
'             from wwv_flow_companies'||chr(10)||
'            where short_name = upper(:COMPANY_NAME) ) loop'||chr(10)||
'   return false;'||chr(10)||
'   exit;'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'return true;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '이름이 &COMPANY_NAME.인 작업 영역이 존재합니다.',
  p_associated_item=> 11425313649770094.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 111462914137977065.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 20.4708,
  p_validation_name => 'Invalid characters in workspace name',
  p_validation_sequence=> 20,
  p_validation => 'COMPANY_NAME',
  p_validation2 => '<>',
  p_validation_type => 'ITEM_IN_VALIDATION_CONTAINS_NO_CHAR_IN_STRING2',
  p_error_message => '작업 영역 이름이 부적합합니다.',
  p_when_button_pressed=> 318000076307.4708 + wwv_flow_api.g_id_offset,
  p_associated_item=> 11425313649770094.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 20.4708
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_25.47
prompt  ...PAGE 25.4708: 작업 영역 요청 - 스키마 지정
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 25.4708,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'HOME',
  p_name   => '작업 영역 요청 - 스키마 지정',
  p_step_title=> '작업 영역 요청',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164416',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4861831036.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25.4708,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 4762183464 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4863831037.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25.4708,
  p_plug_name=> '&PRODUCT_NAME. 등록',
  p_region_name=>'',
  p_plug_template=> 4688102857.4708+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 4839831015.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25.4708,
  p_button_sequence=> 1,
  p_button_plug_id => 4863831037+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4550:1',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4841831018.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25.4708,
  p_button_sequence=> 10,
  p_button_plug_id => 4863831037+wwv_flow_api.g_id_offset,
  p_button_name    => 'Proceed',
  p_button_image_alt=> '다음 &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 103271221441394134.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25.4708,
  p_button_sequence=> 3,
  p_button_plug_id => 4863831037+wwv_flow_api.g_id_offset,
  p_button_name    => 'BACK',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:20:&SESSION.::&DEBUG.:::',
  p_button_condition=> 'F4700_REQ_NEW_SCHEMA',
  p_button_condition2=> 'Y',
  p_button_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 4893430263.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 25.4708,
  p_button_sequence=> 5,
  p_button_plug_id => 4863831037+wwv_flow_api.g_id_offset,
  p_button_name    => 'Back',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:40:&SESSION.::&DEBUG.:::',
  p_button_condition=> 'F4700_REQ_NEW_SCHEMA',
  p_button_condition2=> 'Y',
  p_button_condition_type=> 'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>177096326383922599.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4708,
  p_branch_action=> 'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>4841831018.4708+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'FUNCTION_BODY',
  p_branch_condition=> 'if :NEW_SCHEMA = ''YES'' then'||chr(10)||
'  return false;'||chr(10)||
'else'||chr(10)||
'  for c1 in (select 1 from dual where'||chr(10)||
' wwv_flow_provisioning.restricted_schema_i(:P25_SCHEMA,:COMPANY_NAME) = ''1'''||chr(10)||
'union all '||chr(10)||
'select 1 from wwv_flow_company_schemas where schema = :P25_SCHEMA) loop'||chr(10)||
'  return true;'||chr(10)||
'  end loop;'||chr(10)||
'  return false;'||chr(10)||
'end if;',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 27-APR-2005 05:12 by SSPADAFO');
 
wwv_flow_api.create_page_branch(
  p_id=>66700008567178536.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4708,
  p_branch_action=> 'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 20,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 19-JAN-2007 16:21 by SBKENNED');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'필요한 디스크 공간의 양을 선택하십시오. 스키마가 생성되면 필요한 경우 공간을 추가로 요청할 수 있습니다.';

wwv_flow_api.create_page_item(
  p_id=>4849831028.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4708,
  p_name=>'DATABASE_SIZE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 4863831037.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'declare'||chr(10)||
'    l_default number;'||chr(10)||
'begin'||chr(10)||
'    for c1 in (select req_size'||chr(10)||
'                 from wwv_flow_workspace_req_size'||chr(10)||
'                where request_type = ''N'''||chr(10)||
'                  and default_size = ''Y'') loop'||chr(10)||
'        l_default := c1.req_size;'||chr(10)||
'        exit;'||chr(10)||
'    end loop;'||chr(10)||
'    return l_default;'||chr(10)||
'end;',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'초기 공간 할당(MB):',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'select req_size d, req_size r'||chr(10)||
'  from wwv_flow_workspace_req_size'||chr(10)||
' where request_type = ''N'''||chr(10)||
'   and display = ''Y'''||chr(10)||
' order by to_number(req_size)',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="instructiontext"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT-TOP',
  p_field_alignment  => 'LEFT-BOTTOM',
  p_display_when=>'NEW_SCHEMA',
  p_display_when2=>'YES',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 187206412134572319.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'이 스키마는 데이터베이스 객체를 소유할 Oracle 데이터베이스 사용자입니다. 스키마 변경은 복잡한 작업이므로 이 이름을 선택할 때 약간의 시간이 소요될 수 있습니다. 서비스가 등록되면 스키마 암호와 로그인 암호가 전송됩니다. 작업 영역이 생성되면 스키마를 더 추가할 수 있습니다.'||chr(10)||
''||chr(10)||
''||chr(10)||
''||chr(10)||
'적합한 스키마 이름은 다음 지침을 따라야 합니다.'||chr(10)||
''||chr(10)||
' - 1-30바이트 길이여야 함\n'||chr(10)||
' - 따옴표를 포함할 수 없음'||chr(10)||
''||chr(10)||
' - 문자로 시작해야 함\n'||chr(10)||
' - 밑줄(_), 달러($) 및 파운드(#) 기호를 제외한\n'||chr(10)||
' 영숫자만 포함할 수 있음'||chr(10)||
''||chr(10)||
' - Oracle 예약어일 수 없음'||chr(10)||
''||chr(10)||
' - DUAL일 수 없음';

wwv_flow_api.create_page_item(
  p_id=>320269887457.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4708,
  p_name=>'SCHEMA_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 4863831037.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'생성할&nbsp;새&nbsp;스키마',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT_WITH_ENTER_SUBMIT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 30,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'NEW_SCHEMA',
  p_display_when2=>'YES',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 187206506383572320.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'새 &PRODUCT_NAME. 작업 영역에 액세스할 수 있도록 하려는 스키마 이름을 입력하십시오. 작업 영역이 생성되면 스키마를 더 추가할 수 있습니다.'||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>11472001772984287.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4708,
  p_name=>'EXISTING_SCHEMA_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 4863831037.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'이 기존 스키마 사용',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT_WITH_ENTER_SUBMIT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'NEW_SCHEMA',
  p_display_when2=>'NO',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 187206506383572320.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>172217307242398784.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4708,
  p_name=>'NEW_SCHEMA_HINT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 4863831037.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'wwv_flow_lang.system_message(''F4700.NEW_SCHEMA_HINT'')',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'NEW_SCHEMA',
  p_display_when2=>'YES',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 187206412134572319.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>172222728497414363.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4708,
  p_name=>'EXISTING_SCHEMA_HINT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 4,
  p_item_plug_id => 4863831037.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'wwv_flow_lang.system_message(''F4700.EXISTING_SCHEMA_HINT'')',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'NEW_SCHEMA',
  p_display_when2=>'NO',
  p_display_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_field_template => 187206412134572319.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>172226501055425374.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4708,
  p_name=>'NEW_TABLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 6,
  p_item_plug_id => 4863831037.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'STOP_AND_START_HTML_TABLE',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187206412134572319.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>177097216171957551.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4708,
  p_name=>'P25_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'New&nbsp;schema&nbsp;to&nbsp;create',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 30,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187206506383572320.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 177098721282977925.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4708,
  p_computation_sequence => 10,
  p_computation_item=> 'P25_SCHEMA',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'begin'||chr(10)||
'return nvl(upper(:EXISTING_SCHEMA_NAME),upper(:SCHEMA_NAME));'||chr(10)||
'end;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 174995802627402506.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25.4708,
  p_validation_name => 'new schema name not null',
  p_validation_sequence=> 5,
  p_validation => 'SCHEMA_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '스키마 이름을 지정해야 합니다.',
  p_validation_condition=> ':NEW_SCHEMA = ''YES''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 320269887457.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 174996724098408796.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25.4708,
  p_validation_name => 'existing schema name not null',
  p_validation_sequence=> 7,
  p_validation => 'EXISTING_SCHEMA_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '스키마 이름을 지정해야 합니다.',
  p_validation_condition=> ':NEW_SCHEMA = ''NO''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 11472001772984287.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 16910421773188557.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25.4708,
  p_validation_name => 'schema exists',
  p_validation_sequence=> 10,
  p_validation => 'select null from sys.user$ where name = upper(:EXISTING_SCHEMA_NAME) and type#=1',
  p_validation_type => 'EXISTS',
  p_error_message => '&EXISTING_SCHEMA_NAME. 스키마가 존재하지 않습니다.',
  p_validation_condition=> ':NEW_SCHEMA = ''NO''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 11472001772984287.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 175002332334505711.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25.4708,
  p_validation_name => 'name not an existing role',
  p_validation_sequence=> 15,
  p_validation => 'select null from sys.user$ where name = upper(:EXISTING_SCHEMA_NAME) and type#=0',
  p_validation_type => 'NOT_EXISTS',
  p_error_message => '부적합한 스키마',
  p_validation_condition=> ':NEW_SCHEMA = ''NO''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> .4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 31864751459513493.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25.4708,
  p_validation_name => 'new schema does not exist',
  p_validation_sequence=> 20,
  p_validation => 'select 1 from sys.user$ where name = upper(:SCHEMA_NAME)',
  p_validation_type => 'NOT_EXISTS',
  p_error_message => '부적합한 스키마',
  p_validation_condition=> ':NEW_SCHEMA = ''YES''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 320269887457.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 175703518948689391.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25.4708,
  p_validation_name => 'schema is not restricted when admin is restricted',
  p_validation_sequence=> 25,
  p_validation => 'if :NEW_SCHEMA = ''YES'' then'||chr(10)||
'    for c1 in (select 1 from dual where'||chr(10)||
'      wwv_flow_provisioning.restricted_schema_i(upper(:SCHEMA_NAME),:COMPANY_NAME) = ''1'') loop'||chr(10)||
'      return false;'||chr(10)||
'    end loop;'||chr(10)||
'    return true;'||chr(10)||
'else'||chr(10)||
'    for c1 in (select 1 from dual where'||chr(10)||
'      wwv_flow_provisioning.site_admin_is_restricted_i = ''1'' and'||chr(10)||
'      wwv_flow_provisioning.restricted_schema_i(upper(:EXISTING_SCHEMA_NAME),:COMPANY_NAME) = ''1'') loop'||chr(10)||
'      return false;'||chr(10)||
'    end loop;'||chr(10)||
'    return true;'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '부적합한 스키마'||chr(10)||
'',
  p_associated_item=> .4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 31865013913542993.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25.4708,
  p_validation_name => 'no spaces in name',
  p_validation_sequence=> 30,
  p_validation => 'SCHEMA_NAME',
  p_validation_type => 'ITEM_CONTAINS_NO_SPACES',
  p_error_message => '스키마 이름에 공백이 있으면 안됩니다.',
  p_validation_condition=> ':NEW_SCHEMA = ''YES''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 320269887457.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 47216914721574906.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25.4708,
  p_validation_name => 'schema name cant contain quotes',
  p_validation_sequence=> 100,
  p_validation => 'instr(:SCHEMA_NAME,'''''''')+instr(:SCHEMA_NAME,''"'') = 0',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => '스키마 이름에 따옴표가 있으면 안됩니다.',
  p_validation_condition=> ':NEW_SCHEMA = ''YES'' and'||chr(10)||
':SCHEMA_NAME is not null',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 320269887457.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 47217711926597880.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25.4708,
  p_validation_name => 'cannot be an oracle reserved word',
  p_validation_sequence=> 110,
  p_validation => 'not wwv_flow_provision.is_reserved(:SCHEMA_NAME)',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => '스키마 이름(&SCHEMA_NAME.)이 Oracle 예약어입니다. 다른 스키마를 입력하십시오.',
  p_validation_condition=> ':NEW_SCHEMA = ''YES'' and'||chr(10)||
':SCHEMA_NAME is not null',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 320269887457.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 59988904879054677.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25.4708,
  p_validation_name => 'schema name is valid',
  p_validation_sequence=> 120,
  p_validation => 'wwv_flow_utilities.is_valid_identifier(:SCHEMA_NAME)',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => '스키마 이름이 부적합합니다. 다른 이름을 지정하십시오.',
  p_validation_condition=> ':NEW_SCHEMA = ''YES'' and'||chr(10)||
':SCHEMA_NAME is not null',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 320269887457.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 175009024256995482.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 25.4708,
  p_validation_name => 'new schema not used in existing workspace',
  p_validation_sequence=> 130,
  p_validation => 'select 1 from wwv_flow_company_schemas where schema = upper(:SCHEMA_NAME)',
  p_validation_type => 'NOT_EXISTS',
  p_error_message => '부적합한 스키마',
  p_validation_condition=> ':NEW_SCHEMA = ''YES'' and'||chr(10)||
':SCHEMA_NAME is not null',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> .4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':schema_name := trim(replace(:schema_name,''-'',''_''));'||chr(10)||
':schema_name := replace(:schema_name,''&'','''');'||chr(10)||
':schema_name := replace(:schema_name,''\'','''');'||chr(10)||
':schema_name := replace(:schema_name,''/'','''');'||chr(10)||
':schema_name := replace(:schema_name,''['','''');'||chr(10)||
':schema_name := replace(:schema_name,'']'','''');'||chr(10)||
':schema_name := replace(:schema_name,''('','''');'||chr(10)||
':schema_name := replace(:schema_name,'')'','''');'||chr(10)||
':schema_name := replace(:';

p:=p||'schema_name,''&'','''');'||chr(10)||
':schema_name := replace(:schema_name,''\'','''');'||chr(10)||
':schema_name := replace(:schema_name,''/'','''');'||chr(10)||
':schema_name := replace(:schema_name,''+'','''');'||chr(10)||
':schema_name := replace(:schema_name,''='','''');'||chr(10)||
':schema_name := replace(:schema_name,''*'','''');'||chr(10)||
':schema_name := replace(:schema_name,''&'','''');'||chr(10)||
':schema_name := replace(:schema_name,''$'','''');'||chr(10)||
':schema_name := replace(:schema_name,''&'','''');'||chr(10)||
':schema_nam';

p:=p||'e := replace(:schema_name,'';'','''');'||chr(10)||
':schema_name := replace(:schema_name,''%'','''');'||chr(10)||
':schema_name := replace(:schema_name,''#'','''');'||chr(10)||
':schema_name := replace(:schema_name,''@'','''');'||chr(10)||
':schema_name := replace(:schema_name,''!'','''');'||chr(10)||
':schema_name := replace(:schema_name,''~'','''');'||chr(10)||
':schema_name := replace(:schema_name,''`'','''');'||chr(10)||
':schema_name := replace(:schema_name,'''''''','''');'||chr(10)||
':schema_name := replace(:schema_name,'':'',''';

p:=p||''');'||chr(10)||
':schema_name := replace(:schema_name,''"'','''');'||chr(10)||
':schema_name := replace(:schema_name,''?'','''');'||chr(10)||
':schema_name := replace(:schema_name,''<'','''');'||chr(10)||
':schema_name := replace(:schema_name,''>'','''');'||chr(10)||
':schema_name := replace(:schema_name,''{'','''');'||chr(10)||
':schema_name := replace(:schema_name,''}'','''');'||chr(10)||
':schema_name := replace(:schema_name,''.'','''');'||chr(10)||
':schema_name := replace(:schema_name,'','','''');'||chr(10)||
':schema_name := replace(:sch';

p:=p||'ema_name,''^'','''');';

wwv_flow_api.create_page_process(
  p_id     => 13059725120036431.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25.4708,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'remove bad char from schema name',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 25.4708
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_26.47
prompt  ...PAGE 26.4708: 작업 영역 요청 - 스키마 경고
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 26.4708,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => '작업 영역 요청 - 스키마 경고',
  p_step_title=> '작업 영역 요청',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164416',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 177082230240844373.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 26.4708,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 4762183464 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 177082418885844385.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 26.4708,
  p_plug_name=> '경고',
  p_region_name=>'',
  p_plug_template=> 4688102857.4708+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 177082609759844393.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 26.4708,
  p_button_sequence=> 1,
  p_button_plug_id => 177082418885844385+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4550:1',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 177082802719844403.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 26.4708,
  p_button_sequence=> 10,
  p_button_plug_id => 177082418885844385+wwv_flow_api.g_id_offset,
  p_button_name    => 'Proceed',
  p_button_image_alt=> '다음 &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 177083008639844403.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 26.4708,
  p_button_sequence=> 5,
  p_button_plug_id => 177082418885844385+wwv_flow_api.g_id_offset,
  p_button_name    => 'Back',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:::',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>66706514632218067.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26.4708,
  p_branch_action=> 'f?p=&APP_ID.:27:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 19-JAN-2007 16:28 by SBKENNED');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>177084702792844420.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26.4708,
  p_name=>'P26_RESTRICTED_SCHEMA_WARNING',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 177082418885844385.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_post_element_text=>'<p />',
  p_source=>'wwv_flow_lang.system_message(p_name=>''F4700.P26_WARN_RESTRICTED_SCHEMA'',p0=>v(''PRODUCT_NAME''))',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'select 1 from dual where'||chr(10)||
' wwv_flow_provisioning.restricted_schema_i(:P25_SCHEMA,:COMPANY_NAME) = ''1''',
  p_display_when_type=>'EXISTS',
  p_field_template => 187206412134572319.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>177084927778844420.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26.4708,
  p_name=>'P26_SHARED_SCHEMA_WARNING',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 4,
  p_item_plug_id => 177082418885844385.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source=>'wwv_flow_lang.system_message(p_name=>''F4700.P26_WARN_SHARED_SCHEMA'',p0=>v(''PRODUCT_NAME''))',
  p_source_type=> 'FUNCTION',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>'select 1 from wwv_flow_company_schemas where schema = upper(:P25_SCHEMA)',
  p_display_when_type=>'EXISTS',
  p_field_template => 187206412134572319.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>177095520711911576.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26.4708,
  p_name=>'P26_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 14,
  p_item_plug_id => 177082418885844385.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 26.4708
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_27.47
prompt  ...PAGE 27.4708: 작업 영역 요청 - 프로젝트 설명
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 27.4708,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'HOME',
  p_name   => '작업 영역 요청 - 프로젝트 설명',
  p_step_title=> '작업 영역 요청',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164416',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 109193847235.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 27.4708,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 4762183464 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 109195847236.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 27.4708,
  p_plug_name=> '&PRODUCT_NAME. 등록',
  p_region_name=>'',
  p_plug_template=> 4688102857.4708+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<p>이 정보는 &PRODUCT_NAME. 관리자가 해당 서비스의 용도를 파악하는 데 유용됩니다.</p>&P27_MORE_JUSTIFICATION.',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 109153847210.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 27.4708,
  p_button_sequence=> 1,
  p_button_plug_id => 109195847236+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4550:1',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 109155847214.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 27.4708,
  p_button_sequence=> 10,
  p_button_plug_id => 109195847236+wwv_flow_api.g_id_offset,
  p_button_name    => 'Proceed',
  p_button_image_alt=> '다음 &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 109157847214.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 27.4708,
  p_button_sequence=> 5,
  p_button_plug_id => 109195847236+wwv_flow_api.g_id_offset,
  p_button_name    => 'Back',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:::',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>66702007660187721.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4708,
  p_branch_action=> 'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>109155847214.4708+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 19-JAN-2007 16:23 by SBKENNED');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'서비스 요청 목적을 입력하십시오. 이 정보는 &PRODUCT_NAME. 관리자 참조용입니다.';

wwv_flow_api.create_page_item(
  p_id=>109173847225.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4708,
  p_name=>'PROJECT_DESCRIPTION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 109195847236.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'이 서비스를 요청하는 이유를 제공하십시오.',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXTAREA_WITH_SPELL_CHECK',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 50,
  p_cMaxlength=> 2000,
  p_cHeight=> 8,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 187206506383572320.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'회사 또는 서비스 계약에 따라 요청에 대한 근거가 필요할 경우 근거를 제공하십시오.';

wwv_flow_api.create_page_item(
  p_id=>109175847225.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4708,
  p_name=>'PROJECT_JUSTIFICATION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 109195847236.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'서비스 요청 근거(선택 사항)',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXTAREA_WITH_SPELL_CHECK',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 50,
  p_cMaxlength=> 2000,
  p_cHeight=> 8,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_display_when_type=>'NEVER',
  p_field_template => 187206412134572319.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>177451430104093580.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4708,
  p_name=>'P27_MORE_JUSTIFICATION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 109195847236.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_HTML',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_display_when_type=>'NEVER',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 177458508913257768.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4708,
  p_computation_sequence => 10,
  p_computation_item=> 'P27_MORE_JUSTIFICATION',
  p_computation_point=> 'BEFORE_HEADER',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'declare x varchar2(32767) := null;'||chr(10)||
'begin'||chr(10)||
'    if wwv_flow_provisioning.restricted_schema_i(:P25_SCHEMA,:COMPANY_NAME) = ''1'' then'||chr(10)||
'      x := wwv_flow_lang.system_message(''F4700.P26_JUSTIFY_RESTRICTED_SCHEMA'');'||chr(10)||
'    end if;      '||chr(10)||
'    for c1 in (select 1 from wwv_flow_company_schemas '||chr(10)||
'        where schema = :P25_SCHEMA) loop'||chr(10)||
'      if x is not null then x := x||''<p />''; end if;'||chr(10)||
'      x := x||wwv_flow_lang.system_message(''F4700.P26_JUSTIFY_SHARED_SCHEMA'');'||chr(10)||
'      exit;'||chr(10)||
'    end loop;'||chr(10)||
'    return x||''<p />'';'||chr(10)||
'end;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 109236958762.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 27.4708,
  p_validation_name => 'PROJECT_DESCRIPTION Not Null',
  p_validation_sequence=> 1,
  p_validation => 'PROJECT_DESCRIPTION',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => '이 서비스를 요청하는 이유를 설명해야 합니다.',
  p_associated_item=> 109173847225.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 23-FEB-2001 12:53');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 27.4708
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_30.47
prompt  ...PAGE 30.4708: 작업 영역 요청 - 확인
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 30.4708,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'HOME',
  p_name   => '작업 영역 요청 - 확인',
  p_step_title=> '작업 영역 요청',
  p_allow_duplicate_submissions=>'N',
  p_on_dup_submission_goto_url=>'',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164416',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 318115852998.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 30.4708,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 4762183464 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'htp.p(''<table class="htmldbStandard3" cellspacing="0" cellpadding="0" border="0" summary="">'');'||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'htp.p(''<td class="htmldbFDB"><img src="#OWNER#.wwv_flow_image_generator.get_image?p_position=1&p_sessionid=''|| :APP_SESSION ||''" height="60", width="40"/><img src="#OWNER#.wwv_flow_image_generator.get_image?p_position=2&p_sessionid=''|| :APP_SESSION ||''" height="60", width="40"/><img src="';

s:=s||'#OWNER#.wwv_flow_image_generator.get_image?p_position=3&p_sessionid=''|| :APP_SESSION ||''" height="60", width="40"/><img src="#OWNER#.wwv_flow_image_generator.get_image?p_position=4&p_sessionid=''|| :APP_SESSION ||''" height="60", width="40"/><img src="#OWNER#.wwv_flow_image_generator.get_image?p_position=5&p_sessionid=''|| :APP_SESSION ||''" height="60", width="40"/>'||chr(10)||
' </td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
'htp.p(''<';

s:=s||'/table>'');'||chr(10)||
'htp.p(''<p>'' || wwv_flow_lang.system_message(p_name=>''SERVICE_SIGNUP.ACCEPT'')||''</p>'');'||chr(10)||
''||chr(10)||
''||chr(10)||
'htp.p(''<p><b>''||wwv_flow_lang.system_message(p_name=>''SERVICE_SIGNUP.WORKSPACE_INFO'')||'':</b><p>'');'||chr(10)||
'  htp.p(''<table class="htmldbStandard3" cellspacing="0" cellpadding="0" border="0" summary="">'');'||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'htp.p(''<td>''||wwv_flow_lang.system_message(p_name=>''SERVICE_SIGNUP.NAME'')||''</td>'');'||chr(10)||
'ht';

s:=s||'p.p(''<td class="htmldbFDB">''||htf.escape_sc(:COMPANY_NAME)||''</td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'htp.p(''<td>''||wwv_flow_lang.system_message(p_name=>''SERVICE_SIGNUP.DESCRIPTION'')||''</td>'');'||chr(10)||
'htp.p(''<td class="htmldbFDB">''||htf.escape_sc(substr(:PROJECT_DESCRIPTION,1,50))||''...</td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
'htp.p(''</table>'');'||chr(10)||
''||chr(10)||
'htp.p(''<p><b>''||wwv_flow_lang.system_message(p_name=>''SERVICE_SIGNUP.ADMIN_I';

s:=s||'NFO'')||'':</b></p>'');'||chr(10)||
'  htp.p(''<table class="htmldbStandard3" cellspacing="0" cellpadding="0" border="0" summary="">'');'||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'htp.p(''<td>''||wwv_flow_lang.system_message(p_name=>''SERVICE_SIGNUP.FIRST_NAME'')||''</td>'');'||chr(10)||
'htp.p(''<td class="htmldbFDB">''||htf.escape_sc(:ADMIN_FIRST_NAME)||''</td>'');'||chr(10)||
'htp.p(''</tr><tr>'');'||chr(10)||
'htp.p(''<td>''||wwv_flow_lang.system_message(p_name=>''SERVICE_SIGNUP.LAST_NAME'')|';

s:=s||'|''</td>'');'||chr(10)||
'htp.p(''<td class="htmldbFDB">''||htf.escape_sc(:ADMIN_LAST_NAME)||''</td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'htp.p(''<td>''||wwv_flow_lang.system_message(p_name=>''SERVICE_SIGNUP.EMAIL'')||''</td>'');'||chr(10)||
'htp.p(''<td class="htmldbFDB">''||htf.escape_sc(:ADMIN_EMAIL)||''</td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
'htp.p(''</table>'');'||chr(10)||
''||chr(10)||
'htp.p(''<p><b>''||wwv_flow_lang.system_message(p_name=>''SERVICE_SIGNUP.SCHEMA_INFO'')||'':</b>';

s:=s||'</p>'');'||chr(10)||
'  htp.p(''<table class="htmldbStandard3" cellspacing="0" cellpadding="0" border="0" summary="">'');'||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'htp.p(''<td>''||wwv_flow_lang.system_message(p_name=>''SERVICE_SIGNUP.REUSE_SCHEMA'')||''</td>'');'||chr(10)||
'if :NEW_SCHEMA = ''NO'' then'||chr(10)||
'  htp.p(''<td class="htmldbFDB">''||wwv_flow_lang.system_message(p_name=>''SERVICE_SIGNUP.YES'')||''</td>'');'||chr(10)||
'else'||chr(10)||
'  htp.p(''<td class="htmldbFDB">''||wwv_flow_lang.sy';

s:=s||'stem_message(p_name=>''SERVICE_SIGNUP.NO'')||''</td>'');'||chr(10)||
'end if;'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'htp.p(''<td>''||wwv_flow_lang.system_message(p_name=>''SERVICE_SIGNUP.SCHEMA_NAME'')||''</td>'');'||chr(10)||
'if :NEW_SCHEMA = ''YES'' then'||chr(10)||
'  htp.p(''<td class="htmldbFDB">''||htf.escape_sc(:SCHEMA_NAME)||''</td>'');'||chr(10)||
'else'||chr(10)||
'  htp.p(''<td class="htmldbFDB">''||htf.escape_sc(:EXISTING_SCHEMA_NAME)||''</td>'');'||chr(10)||
'end if;'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
'if :';

s:=s||'NEW_SCHEMA = ''YES'' then'||chr(10)||
'  htp.p(''<tr>'');'||chr(10)||
'  htp.p(''<td>''||wwv_flow_lang.system_message(p_name=>''SERVICE_SIGNUP.DB_SIZE'')||''</td>'');'||chr(10)||
'  htp.p(''<td class="htmldbFDB">''||htf.escape_sc(:DATABASE_SIZE)||''</td>'');'||chr(10)||
'  htp.p(''</tr>'');'||chr(10)||
'end if;'||chr(10)||
'htp.p(''</table>'');'||chr(10)||
''||chr(10)||
'if :NEW_SCHEMA = ''NO'' then'||chr(10)||
'    declare l_count pls_integer;'||chr(10)||
'    begin'||chr(10)||
'      select count(*) into l_count from wwv_flow_company_schemas where schema ';

s:=s||'= upper(:EXISTING_SCHEMA_NAME);'||chr(10)||
'      if l_count > 0 then'||chr(10)||
'        htp.p(''<p><b>''||wwv_flow_lang.system_message(p_name=>''WARNING'')||'':</b></p>'');'||chr(10)||
'        htp.p(''<table class="htmldbStandard3" cellspacing="0" cellpadding="0" border="0" summary="">'');'||chr(10)||
'        htp.p(''<tr>'');'||chr(10)||
'        htp.p(''<td class="htmldbFDB">''||wwv_flow_lang.system_message(p_name=>''F4700.SCHEMA_USED_BY_WORKSPACES'',p0=>l_count)||''</';

s:=s||'td>'');'||chr(10)||
'        htp.p(''</tr>'');'||chr(10)||
'        htp.p(''</table>'');'||chr(10)||
'      end if;'||chr(10)||
'    end;    '||chr(10)||
'    if wwv_flow_provisioning.restricted_schema(upper(:EXISTING_SCHEMA_NAME),:COMPANY_NAME) then'||chr(10)||
'        htp.p(''<p><b>''||wwv_flow_lang.system_message(p_name=>''WARNING'')||'':</b></p>'');'||chr(10)||
'        htp.p(''<table class="htmldbStandard3" cellspacing="0" cellpadding="0" border="0" summary="">'');'||chr(10)||
'        htp.p(''<tr>'');'||chr(10)||
'     ';

s:=s||'   htp.p(''<td class="htmldbFDB">''||wwv_flow_lang.system_message(p_name=>''F4700.SCHEMA_RESTRICTED'')||''</td>'');'||chr(10)||
'        htp.p(''</tr>'');'||chr(10)||
'        htp.p(''</table>'');'||chr(10)||
'    end if;'||chr(10)||
'else'||chr(10)||
'    if wwv_flow_provisioning.restricted_schema(upper(:SCHEMA_NAME),:COMPANY_NAME) then'||chr(10)||
'        htp.p(''<p><b>''||wwv_flow_lang.system_message(p_name=>''WARNING'')||'':</b></p>'');'||chr(10)||
'        htp.p(''<table class="htmldbStandard3" ce';

s:=s||'llspacing="0" cellpadding="0" border="0" summary="">'');'||chr(10)||
'        htp.p(''<tr>'');'||chr(10)||
'        htp.p(''<td class="htmldbFDB">''||wwv_flow_lang.system_message(p_name=>''F4700.SCHEMA_RESTRICTED'')||''</td>'');'||chr(10)||
'        htp.p(''</tr>'');'||chr(10)||
'        htp.p(''</table>'');'||chr(10)||
'    end if;'||chr(10)||
'end if;';

wwv_flow_api.create_page_plug (
  p_id=> 94840826419648214.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 30.4708,
  p_plug_name=> '확인',
  p_region_name=>'',
  p_plug_template=> 4688102857.4708+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'code remove for justification'||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'htp.p(''<td>''||wwv_flow_lang.system_message(p_name=>''SERVICE_SIGNUP.JUSTIFICATION'')||''</td>'');'||chr(10)||
'htp.p(''<td class="htmldbFDB">''||htf.escape_sc(substr(:PROJECT_JUSTIFICATION,1,50))||''...</td>'');'||chr(10)||
'htp.p(''</tr>'');');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 318079852987.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 30.4708,
  p_button_sequence=> 1,
  p_button_plug_id => 94840826419648214+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4550:1',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 318141939408.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 30.4708,
  p_button_sequence=> 20,
  p_button_plug_id => 94840826419648214+wwv_flow_api.g_id_offset,
  p_button_name    => 'Accept',
  p_button_image_alt=> '요청 제출',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 318938118262.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 30.4708,
  p_button_sequence=> 2,
  p_button_plug_id => 94840826419648214+wwv_flow_api.g_id_offset,
  p_button_name    => 'Back_button',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&FLOW_ID.:27:&SESSION.::&DEBUG.:::',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>60145132142214439.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30.4708,
  p_branch_action=> 'f?p=&APP_ID.:3:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'이 상자에 표시된 확인 코드를 입력해야 합니다.'||chr(10)||
'문자는 <b>대소문자를 구분</b>하므로 입력할 때 주의해야 합니다.';

wwv_flow_api.create_page_item(
  p_id=>29906703634753342.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30.4708,
  p_name=>'P30_VERIFICATION_CODE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 94840826419648214.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'확인 코드: ',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 10,
  p_cMaxlength=> 5,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 187206506383572320.4708+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 29962128538283685.4708 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 30.4708,
  p_validation_name => 'Verification code',
  p_validation_sequence=> 10,
  p_validation => 'begin'||chr(10)||
'for c1 in'||chr(10)||
'       (select * from wwv_flow_request_verifications'||chr(10)||
'where session_id = :APP_SESSION) loop'||chr(10)||
'   if c1.verification_string = :P30_verification_code then'||chr(10)||
'      return true;'||chr(10)||
'   else '||chr(10)||
'      return false;'||chr(10)||
'   end if;'||chr(10)||
'end loop;'||chr(10)||
'return false;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => '부적합한 확인 코드',
  p_associated_item=> 29906703634753342.4708 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_schema varchar2(255);'||chr(10)||
'begin'||chr(10)||
'  if :NEW_SCHEMA = ''YES'' then'||chr(10)||
'    l_schema := :SCHEMA_NAME;'||chr(10)||
'  else'||chr(10)||
'    l_schema := :EXISTING_SCHEMA_NAME;'||chr(10)||
'  end if;'||chr(10)||
'wwv_flow_provisioning.make_request ('||chr(10)||
'  p_COMPANY_NAME => :COMPANY_NAME,'||chr(10)||
'  p_ADMIN_FIRST_NAME => :ADMIN_FIRST_NAME,'||chr(10)||
'  p_ADMIN_LAST_NAME => :ADMIN_LAST_NAME,'||chr(10)||
'  p_ADMIN_EMAIL => :ADMIN_EMAIL,'||chr(10)||
'  p_ADMIN_PHONE => :ADMIN_PHONE,'||chr(10)||
'  p_ADMIN_USERID => :A';

p:=p||'DMIN_EMAIL,'||chr(10)||
'  p_COMPANY_ADDRESS => null,'||chr(10)||
'  p_CITY => null,'||chr(10)||
'  p_STATE => null,'||chr(10)||
'  p_ZIP => null,'||chr(10)||
'  p_COUNTRY => null,'||chr(10)||
'  p_COMPANY_TYPE => null,  '||chr(10)||
'  p_COMPANY_PHONE => null,'||chr(10)||
'  p_COMPANY_FAX => null,'||chr(10)||
'  p_DATABASE_SIZE=> :DATABASE_SIZE,  '||chr(10)||
'  p_SCHEMA_NAME=> l_schema,'||chr(10)||
'  p_project_description=> :PROJECT_DESCRIPTION,'||chr(10)||
'  p_project_justification=> :PROJECT_JUSTIFICATION'||chr(10)||
'  );'||chr(10)||
'  --'||chr(10)||
'  wwv_flow_mail.push_queue_ba';

p:=p||'ckground;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 16952718581632268.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 30.4708,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'make request',
  p_process_sql_clob => p, 
  p_process_error_message=> '&MSG_COMPANY.을(를) 요청하는 중 오류가 발생했습니다.',
  p_process_success_message=> '&MSG_COMPANY. &COMPANY_NAME.이(가) 요청되었습니다. 요청이 검토되면 관리자 계정 암호 또는 기타 상태 정보가 전자 메일 주소 &ADMIN_EMAIL.(으)로 전송됩니다.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 30.4708
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_40.47
prompt  ...PAGE 40.4708: 작업 영역 요청 - 새 스키마 또는 기존 스키마
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 40.4708,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> 'HOME',
  p_name   => '작업 영역 요청 - 새 스키마 또는 기존 스키마',
  p_step_title=> '작업 영역 요청',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409164416',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 318719223870.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 40.4708,
  p_plug_name=> '&PRODUCT_NAME. 등록',
  p_region_name=>'',
  p_plug_template=> 4688102857.4708+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<p>요청한 작업 영역에 기존 데이터베이스 스키마의 권한이 있어야 하는지 아니면 새 데이터베이스 스키마 생성에 대한 요청인지 지정하십시오.</p>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 318723223878.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 40.4708,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 4762183464 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 101384848266.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 40.4708,
  p_button_sequence=> 1,
  p_button_plug_id => 318719223870+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> '취소',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4550:1',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 318709223867.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 40.4708,
  p_button_sequence=> 3,
  p_button_plug_id => 318719223870+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT_STEP',
  p_button_image_alt=> '다음 &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 101391869900.4708 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 40.4708,
  p_button_sequence=> 2,
  p_button_plug_id => 318719223870+wwv_flow_api.g_id_offset,
  p_button_name    => 'Back',
  p_button_image_alt=> '&lt; 이전',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:20:&SESSION.::&DEBUG.:::',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>66692613453132594.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 40.4708,
  p_branch_action=> 'f?p=&APP_ID.:25:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>318709223867.4708+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 19-JAN-2007 16:14 by SBKENNED');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'도움말 텍스트가 없습니다.';

wwv_flow_api.create_page_item(
  p_id=>11463031938945752.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 40.4708,
  p_name=>'NEW_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 318719223870.4708+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'&nbsp;',
  p_source=>'YES',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'NEW_OR_EXISTING_SCHEMA',
  p_lov => '.'||to_char(150771414457811401 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'Y',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="instructiontext"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 40.4708
--
 
begin
 
null;
end;
null;
 
end;
/

prompt  ...lists
--
--application/shared_components/navigation/lists/provisionnewservice
 
begin
 
wwv_flow_api.create_list (
  p_id=> 4762183464.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'ProvisionNewService',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 91248625890266048 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 60577706518684017.4708 + wwv_flow_api.g_id_offset,
  p_list_id=> 4762183464.4708 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>0,
  p_list_item_link_text=> '시작',
  p_list_item_link_target=> 'f?p=&APP_ID.:1:&SESSION.::&DEBUG.::::',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '1',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 4770195076.4708 + wwv_flow_api.g_id_offset,
  p_list_id=> 4762183464.4708 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>1,
  p_list_item_link_text=> '관리자 지정',
  p_list_item_link_target=> 'f?p=4700:10:&SESSION.',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '10',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 4768193355.4708 + wwv_flow_api.g_id_offset,
  p_list_id=> 4762183464.4708 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>2,
  p_list_item_link_text=> '작업 영역 이름 지정',
  p_list_item_link_target=> 'f?p=&APP_ID.:20:&SESSION.::&DEBUG.::::',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '20',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 4836827003.4708 + wwv_flow_api.g_id_offset,
  p_list_id=> 4762183464.4708 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>4,
  p_list_item_link_text=> '데이터베이스 스키마 선택',
  p_list_item_link_target=> 'f?p=&APP_ID.:25:&SESSION.::&DEBUG.::::',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '25,26,40',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 109218886058.4708 + wwv_flow_api.g_id_offset,
  p_list_id=> 4762183464.4708 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>5,
  p_list_item_link_text=> '요청 근거',
  p_list_item_link_target=> 'f?p=&APP_ID.:27:&SESSION.::&DEBUG.::::',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '27',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 4764187459.4708 + wwv_flow_api.g_id_offset,
  p_list_id=> 4762183464.4708 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>6,
  p_list_item_link_text=> '확인',
  p_list_item_link_target=> 'f?p=&APP_ID.:30:&SESSION.::&DEBUG.::::',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_current_for_pages=> '30,3',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/lists/confirmed_list
 
begin
 
wwv_flow_api.create_list (
  p_id=> 60555613032506142.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Confirmed List',
  p_list_status=> 'PUBLIC',
  p_list_displayed=> 'BY_DEFAULT',
  p_display_row_template_id=> 66657631629028386 + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_list_item (
  p_id=> 60556328270510578.4708 + wwv_flow_api.g_id_offset,
  p_list_id=> 60555613032506142.4708 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>10,
  p_list_item_link_text=> '&PRODUCT_NAME. 로그인 페이지로 돌아가기',
  p_list_item_link_target=> 'f?p=4550:1:&SESION.',
  p_list_item_icon   => 'htmldb/icons/pt_page.png',
  p_list_item_icon_attributes=> 'alt="" width="20" height="20"',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 60556713163515635.4708 + wwv_flow_api.g_id_offset,
  p_list_id=> 60555613032506142.4708 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>20,
  p_list_item_link_text=> '&PRODUCT_NAME. Oracle Technology Network 홈 페이지',
  p_list_item_link_target=> 'http://www.oracle.com/technology/products/database/application_express/',
  p_list_item_icon   => 'htmldb/icons/pt_page.png',
  p_list_item_icon_attributes=> 'alt="" width="20" height="20"',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
wwv_flow_api.create_list_item (
  p_id=> 60557022860518470.4708 + wwv_flow_api.g_id_offset,
  p_list_id=> 60555613032506142.4708 + wwv_flow_api.g_id_offset,
  p_list_item_type=> 'LINK',
  p_list_item_status=> 'PUBLIC',
  p_item_displayed=> 'BY_DEFAULT',
  p_list_item_display_sequence=>30,
  p_list_item_link_text=> '&PRODUCT_NAME. 토론 포럼',
  p_list_item_link_target=> 'http://forums.oracle.com/forums/forum.jspa?forumID=137',
  p_list_item_icon   => 'htmldb/icons/pt_page.png',
  p_list_item_icon_attributes=> 'alt="" width="20" height="20"',
  p_list_countclicks_y_n=> 'N',
  p_list_text_01=> '',
  p_list_item_current_type=> 'COLON_DELIMITED_PAGE_LIST',
  p_list_item_owner=> '');
 
null;
 
end;
/

--application/shared_components/navigation/breadcrumbs
prompt  ...breadcrumbs
--
prompt  ...page templates for application: 4708
--
--application/shared_components/user_interface/templates/page/printer_friendly_ko
prompt  ......Page template 4674102852.4708
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">'||chr(10)||
'<head><title>#TITLE#</title><link rel="icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon"><link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">#HEAD#<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" ty';

c1:=c1||'pe="text/css" /><!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_ie_3_1.css" type="text/css" /><![endif]--></head><body #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>';

c2:=c2||'</body>'||chr(10)||
'</html>';

c3:=c3||'<br />#BOX_BODY#';

wwv_flow_api.create_template(
  p_id=> 4674102852.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'printer-friendly.ko',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="htmldbSuccessMessage" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="htmldbNotification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"',
  p_theme_id  => 3,
  p_theme_class_id => 5,
  p_error_page_template => '<br />'||chr(10)||
'<br />'||chr(10)||
'<pre>#MESSAGE#</pre>'||chr(10)||
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>',
  p_reference_id=> 80874804748045950,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/columbus_login_and_logout_page_ko
prompt  ......Page template 108132430112395957.4708
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">'||chr(10)||
'<head><title>#TITLE#</title><link rel="icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon"><link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">#HEAD#<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" ty';

c1:=c1||'pe="text/css" /><!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_ie_3_1.css" type="text/css" /><![endif]--></head><body #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'||chr(10)||
'';

c2:=c2||'<div class="htmldbFlowL">&MSG_LANGUAGE.: &BROWSER_LANGUAGE.</div>'||chr(10)||
'<div class="htmldbFlowV">#FLOW_VERSION#</div>'||chr(10)||
'<div class="htmldbNewBottom">'||chr(10)||
'<div class="htmldbNewBottom1"><br /></div>'||chr(10)||
'<div class="htmldbNewBottom2">&MSG_COPYRIGHT.</div>'||chr(10)||
'<br />'||chr(10)||
'</div>'||chr(10)||
'#FORM_CLOSE#'||chr(10)||
'<a name="END"><br /></a>'||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<div id="htmldbLogo2">#LOGO#</div>'||chr(10)||
'<div class="htmldbSep"><br/></div>'||chr(10)||
'<div id="htmldbBreadcrumbTop"><br /></div>'||chr(10)||
'<div class="htmldbBreadcrumbRegion"><br /></div>'||chr(10)||
'<a name="SkipRepNav"></a>'||chr(10)||
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>'||chr(10)||
'<div class="htmldbBodyMargin">'||chr(10)||
'<table summary="" cellpadding="0" cellspacing="0" border="0" height="70%">'||chr(10)||
'<tr>'||chr(10)||
'<td ';

c3:=c3||'valign="top">#REGION_POSITION_01#</td>'||chr(10)||
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>'||chr(10)||
'<td valign="top">#REGION_POSITION_02##REGION_POSITION_04##BOX_BODY#</td>'||chr(10)||
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>'||chr(10)||
'<td valign="top" style="width:100%"><div style="float:right;">#REGION_POSITION_03##REGION_POSITION_05#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'</div>';

wwv_flow_api.create_template(
  p_id=> 108132430112395957.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> '(Columbus) Login and Logout Page.ko',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="htmldbSuccessMessage" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="htmldbNotification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"',
  p_theme_id  => 3,
  p_theme_class_id => 6,
  p_error_page_template => '<br />'||chr(10)||
'<br />'||chr(10)||
'<pre>#MESSAGE#</pre>'||chr(10)||
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>',
  p_reference_id=> 80966020820422852,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/green_look_no_sidebar_from_4999_ko
prompt  ......Page template 258573723069846308.4708
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns="http://www.w3.org/1999/xhtml" xmlns:htmldb="http://htmldb.oracle.com" xmlns:apex="http://apex.oracle.com">'||chr(10)||
'<head><title>#TITLE#</title><link rel="icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon"><link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">#HEAD#<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" ty';

c1:=c1||'pe="text/css" /><!--[if IE]><link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_ie_3_1.css" type="text/css" /><![endif]--></head><body #ONLOAD#><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>';

c2:=c2||'<div class="htmldbFlowL">&MSG_LANGUAGE.: &BROWSER_LANGUAGE.</div>'||chr(10)||
'<div class="htmldbFlowV">#FLOW_VERSION#</div>'||chr(10)||
'<div class="htmldbNewBottom">'||chr(10)||
'<div class="htmldbNewBottom1"><span>&MSG_COMPANY.</span><span>&MSG_USER.: &USER.</span></div>'||chr(10)||
'<div class="htmldbNewBottom2">&MSG_COPYRIGHT.</div>'||chr(10)||
'<br />'||chr(10)||
'</div>'||chr(10)||
'#FORM_CLOSE#'||chr(10)||
'<a name="END"><br /></a>'||chr(10)||
'</body>'||chr(10)||
'</html>'||chr(10)||
'';

c3:=c3||'<table summary="" cellpadding="0" cellspacing="0" border="0" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td align="left"><a id="htmldbLogo2" href="#HOME_LINK#">#LOGO#</a></td>'||chr(10)||
'<td valign="top" align="right" class="NavBar">#NAVIGATION_BAR#<td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td valign="bottom" align="right" colspan="2"><div id="htmldbPageTabs">#REGION_POSITION_07#</div></td><td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'<div id="htmldbBreadcrumbTop"><br /></div>'||chr(10)||
'<div ';

c3:=c3||'class="htmldbBreadcrumbRegion"><div class="htmldbBreadcrumbs">#REGION_POSITION_08#<span id="htmldbCustomize">#CUSTOMIZE#</span></div></div>'||chr(10)||
'<a name="SkipRepNav"></a>'||chr(10)||
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>'||chr(10)||
'<div class="htmldbBodyMargin">'||chr(10)||
'<div>#REGION_POSITION_01#</div>'||chr(10)||
'<table summary="" cellpadding="0" cellspacing="0" border="0" height="70%">';

c3:=c3||''||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top">#REGION_POSITION_02##BOX_BODY#</td>'||chr(10)||
'<td class="htmldbColumnSep"><div class="htmldbColumnSep"><br /></div></td>'||chr(10)||
'<td valign="top"><div style="float:right">#REGION_POSITION_03##REGION_POSITION_05#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'<div>#REGION_POSITION_04#</div>'||chr(10)||
'</div>';

wwv_flow_api.create_template(
  p_id=> 258573723069846308.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Green Look (No SideBar) From 4999.ko',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="htmldbSuccessMessage" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#SUCCESS_MESSAGE#</div>'||chr(10)||
'',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="htmldbNotification" id="MESSAGE"><img src="#IMAGE_PREFIX#delete.gif" onclick="$x_Remove(''MESSAGE'')"  style="float:right;" class="pb" alt="" />#MESSAGE#</div>'||chr(10)||
'',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_08',
  p_theme_id  => 3,
  p_theme_class_id => 1,
  p_error_page_template => '<br />'||chr(10)||
'<br />'||chr(10)||
'<pre>#MESSAGE#</pre>'||chr(10)||
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>',
  p_reference_id=> 18525411970780075,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

prompt  ...button templates
--
---------------------------------------
prompt  ...region templates
--
--application/shared_components/user_interface/templates/region/wizard_box
prompt  ......region template 4688102857.4708
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="htmldbWizard" summary="" cellpadding="0" cellspacing="0" border="0" id="#REGION_STATIC_ID#"><thead><tr><th class="H1">#TITLE#</th><th class="H2">#CLOSE#&nbsp;&nbsp;&nbsp;#DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#</th></tr></thead><tbody><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 4688102857.4708 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Box',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 3,
  p_theme_class_id => 12,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_reference_id=> 18253116293565611,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 4688102857.4708 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_box_confirm
prompt  ......region template 60551104085502857.4708
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table class="htmldbWizard" summary="" cellpadding="0" cellspacing="0" border="0" id="#REGION_STATIC_ID#"><thead><tr><th class="H1">#TITLE#</th><th class="H2">#CLOSE#&nbsp;&nbsp;&nbsp;#DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#</th></tr></thead><tbody class="Confirm"><tr><td colspan="2" class="B">#BODY#</td></tr></tbody></table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 60551104085502857.4708 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Box (Confirm)',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 3,
  p_theme_class_id => 12,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_reference_id=> 186682507972859454,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 60551104085502857.4708 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/info_c_htmldbinfo_from_4999
prompt  ......region template 94734804379445706.4708
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="htmldbInfo" summary="" id="#REGION_STATIC_ID#"><thead><tr><th class="L"><br /></th><th class="C">#TITLE#</th><th class="R"><br /></th></tr></thead><tbody><tr><td colspan="3" class="B">#BODY#</td></tr></tbody></table>';

t2:=t2||' ';

wwv_flow_api.create_plug_template (
  p_id       => 94734804379445706.4708 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Info (c:htmldbInfo)  From 4999',
  p_plug_table_bgcolor     => '#F7F7E7',
  p_theme_id  => 3,
  p_theme_class_id => 2,
  p_plug_heading_bgcolor => '#F7F7E7',
  p_plug_font_size => '-1',
  p_reference_id=> 17355419405599943,
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2:=t2||' ';

wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 94734804379445706.4708 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

prompt  ...List Templates
--
--application/shared_components/user_interface/templates/list/standard_list_c_htmldbstandardlist_from_4999
prompt  ......list template 4794278052.4708
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td class="htmldbStandardList1"><a href="#LINK#" class="itemLink" title="#TEXT_ESC_SC#">#TEXT#</a></td></tr>';

t2:=t2||'<tr><td class="htmldbStandardList2"><a href="#LINK#" class="itemLink" title="#TEXT_ESC_SC#">#TEXT#</a></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>4794278052.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Standard List (c:htmldbStandardList) From 4999',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_list_template_before_rows=>'<table class="htmldbStandardList" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tbody>',
  p_list_template_after_rows=>'</tbody></table>',
  p_reference_id=>17385324891888482,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/unordered_list_from_4999
prompt  ......list template 66657631629028386.4708
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#" title="#TEXT_ESC_SC#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>66657631629028386.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Unordered List from 4999',
  p_theme_id  => 3,
  p_theme_class_id => 1,
  p_list_template_before_rows=>'<ul class="htmldbUl">',
  p_list_template_after_rows=>'</ul>',
  p_reference_id=>60219508156141083,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/wizard_sidebar_c_htmldbwizbar
prompt  ......list template 91248625890266048.4708
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<div class="htmldbWizCurrent">#TEXT#</div>';

t2:=t2||'<div class="htmldbWizNon">#TEXT#</div>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91248625890266048.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Wizard Sidebar (c:htmldbWizBar)',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_list_template_before_rows=>'<div class="htmldbWizBar">',
  p_list_template_after_rows=>'</div>',
  p_between_items=>'<div class="htmldbWizArrow"><img src="#IMAGE_PREFIX#arrow_down.gif" width="7" height="6" alt="Down" /></div>',
  p_reference_id=>60218330803141060,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

prompt  ...report templates
--
prompt  ...label templates
--
--application/shared_components/user_interface/templates/label/formfield_nonrequired
prompt  ......label template 187206412134572319.4708
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 187206412134572319.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'FormField_Nonrequired',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_reference_id=> 17388415351892041,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/formfield_required
prompt  ......label template 187206506383572320.4708
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 187206506383572320.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'FormField_Required',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelRequired" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999"><img src="#IMAGE_PREFIX#requiredicon_status2.gif" alt="" />',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'',
  p_on_error_after_label=>'',
  p_theme_id  => 3,
  p_theme_class_id => 0,
  p_reference_id=> 17388508175892042,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

prompt  ...breadcrumb templates
--
--application/shared_components/user_interface/templates/popuplov
prompt  ...popup list of values templates
--
prompt  ......template 14663214008465131.4708
 
begin
 
begin
wwv_flow_api.create_popup_lov_template (
  p_id=> 14663214008465131.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_popup_icon=>'#IMAGE_PREFIX#htmldb/icons/view_small.gif',
  p_popup_icon_attr=>'width="18" height="18" alt="#LIST_OF_VALUES#" title="#LIST_OF_VALUES#"',
  p_popup_icon2=>'',
  p_popup_icon_attr2=>'',
  p_page_name=>'winlov',
  p_page_title=>'검색 대화상자',
  p_page_html_head=>'<html lang="&BROWSER_LANGUAGE.">'||chr(10)||
'<head>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#css/apex_builder_3_1.css" type="text/css" />'||chr(10)||
'<script src="#IMAGE_PREFIX#javascript/apex_builder.js" type="text/javascript"></script>'||chr(10)||
'<style>a{font-size:12px;}</style>'||chr(10)||
'</head>',
  p_page_body_attr=>'onload="first_field()" class="htmldbPopup"',
  p_before_field_text=>'',
  p_page_heading_text=>'<div style="padding:2px;"><table><tr><td valign="top"><img src="#IMAGE_PREFIX#magnifying_glass_white_bg.gif" /></td><td>',
  p_page_footer_text =>'</td></tr></table></div>',
  p_filter_width     =>'20',
  p_filter_max_width =>'100',
  p_filter_text_attr =>'',
  p_find_button_text =>'검색',
  p_find_button_image=>'',
  p_find_button_attr =>'',
  p_close_button_text=>'닫기',
  p_close_button_image=>'',
  p_close_button_attr=>'',
  p_next_button_text =>'다음 >',
  p_next_button_image=>'',
  p_next_button_attr =>'',
  p_prev_button_text =>'< 이전',
  p_prev_button_image=>'',
  p_prev_button_attr =>'',
  p_after_field_text=>'</div>',
  p_scrollbars=>'1',
  p_resizable=>'1',
  p_width =>'400',
  p_height=>'500',
  p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">#FIRST_ROW# - #LAST_ROW# 행</div><center>',
  p_result_rows_per_pg=>200,
  p_before_result_set=>'<div style="padding-left:6px;">',
  p_theme_id  => 3,
  p_theme_class_id => 1,
  p_reference_id       => 17343114994581872,
  p_translate_this_template => 'N',
  p_after_result_set   =>'</div>');
end;
null;
 
end;
/

prompt  ...calendar templates
--
prompt  ...application themes
--
prompt  ...build options used by application 4708
--
 
begin
 
--application/shared_components/logic/build_options/company_address
wwv_flow_api.create_build_option (
  p_id=> 46948758488708852.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_build_option_name=> 'company address',
  p_build_option_status=> 'EXCLUDE',
  p_build_option_comment=> 'we can avoid asking internal Oracle folks for address info');
 
end;
/

--application/shared_components/globalization/messages
prompt  ...messages used by application: 4708
--
--application/shared_components/globalization/dyntranslations
prompt  ...dynamic translations used by application: 4708
--
--application/shared_components/globalization/language
prompt  ...Language Maps for Application 4708
--
 
begin
 
null;
 
end;
/

prompt  ...Shortcuts
--
--application/shared_components/user_interface/shortcuts/item_help
 
begin
 
declare
  c1 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999" title="이 항목에 대한 도움말입니다."><img src="#IMAGE_PREFIX#infoicon_status_gray.gif" width="16" height="16" /></a>';

wwv_flow_api.create_shortcut (
 p_id=> 187203309767569784.4708 + wwv_flow_api.g_id_offset,
 p_flow_id=> wwv_flow.g_flow_id,
 p_shortcut_name=> 'ITEM_HELP',
 p_shortcut_type=> 'HTML_TEXT',
 p_error_text=> '도움말을 표시할 수 없습니다.',
 p_reference_id=> 24184979678,
 p_shortcut=> c1);
end;
null;
 
end;
/

prompt  ...web services (9iR2 or better)
--
prompt  ...shared queries
--
prompt  ...report layouts
--
prompt  ...authentication schemes
--
--application/shared_components/security/authentication/database
prompt  ......scheme 108165525079033088.4708
 
begin
 
declare
  s1 varchar2(32767) := null;
  s2 varchar2(32767) := null;
  s3 varchar2(32767) := null;
  s4 varchar2(32767) := null;
  s5 varchar2(32767) := null;
begin
s1:=s1||'-DATABASE-';

s2 := null;
s3 := null;
s4 := null;
s5 := null;
wwv_flow_api.create_auth_setup (
  p_id=> 108165525079033088.4708 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Database',
  p_description=>'Based on authentication scheme from gallery:No Authentication (using DAD)',
  p_page_sentry_function=> s1,
  p_sess_verify_function=> s2,
  p_pre_auth_process=> s3,
  p_auth_function=> s4,
  p_post_auth_process=> s5,
  p_invalid_session_page=>'',
  p_invalid_session_url=>'',
  p_cookie_name=>'',
  p_cookie_path=>'',
  p_cookie_domain=>'',
  p_use_secure_cookie_yn=>'',
  p_ldap_host=>'',
  p_ldap_port=>'',
  p_ldap_string=>'',
  p_attribute_01=>'',
  p_attribute_02=>'',
  p_attribute_03=>'',
  p_attribute_04=>'',
  p_attribute_05=>'',
  p_attribute_06=>'',
  p_attribute_07=>'',
  p_attribute_08=>'',
  p_required_patch=>'');
end;
null;
 
end;
/

--application/end_environment
commit;
commit;
begin 
execute immediate 'alter session set nls_numeric_characters='''||wwv_flow_api.g_nls_numeric_chars||'''';
end;
/
set verify on
set feedback on
prompt  ...done
