@echo off
REM
REM dvca.bat
REM
REM Copyright (c) 1997, 2007, Oracle. All rights reserved.  
REM
REM    NAME
REM      dvca - Shell script to run Data Vault Configuration Assistant
REM
REM
REM    DESCRIPTION
REM      Runs Data Vault Configuration Assistion java application
REM      Run this script with -h or -help option to get the help.
REM
REM   MODIFIED   (MM/DD/YY)
REM      ruparame 08/29/07 - Bug 6365097 Reduce CLASSPATH length
REM      ruparame 07/18/07 - Remove ORACLE_SID since it is not being used
REM      vigaur   06/05/07 - Change jdbc_file for 11G
REM      sgaetjen 09/01/06 - windows port
REM      fjlee    06/07/06 - Created
REM

REM #######################################################################
REM Variables set by Oracle Universal Installer for dependent components.
REM #######################################################################

REM Jar file classpath changes should be made in this file as well as manifestDvca

REM Define ORACLE_HOME -> OH
set OH=%ORACLE_HOME%


REM Version specific JAR files
set JRE_FILE=rt.jar
set I18_FILE=i18n.jar
set EWT_FILE=ewt3.jar
set JEWT_FILE=jewt4.jar
set EWT_COMP_FILE=ewtcompat-3_3_15.jar
set SHARE_FILE=share.jar
set HELP_FILE=help4.jar
set ICE_BROWSER5_FILE=oracle_ice5.jar
set KODIAK_FILE=kodiak.jar
set SWING_FILE=swingall-1_1_1.jar
set XMLPARSER_FILE=xmlparserv2.jar
set JDBC_FILE=ojdbc5.jar
set GDK_FILE1=orai18n.jar
set GDK_FILE2=orai18n-mapping.jar
set GDK_FILE3=orai18n-utility.jar
set GDK_FILE4=orai18n-collation.jar
set NETCFG_FILE=netcfg.jar
set OJMISC_FILE=ojmisc.jar
set PKI_FILE=oraclepki103.jar
set LDAP_FILE=ldapjclnt11.jar
set OPM_FILE=opm.jar
set SRVM_FILE=srvm.jar
set SRVMHAS_FILE=srvmhas.jar
set SRVMASM_FILE=srvmasm.jar
set ASSISTANTS_COMMON_FILE=assistantsCommon.jar
set DVCA_FILE=dvca.jar
set EMLITE_JAR=oemlt-10_1_0.jar
set INSTALLER_FILE=OraInstaller.jar
set PREREQ_JAR_FILE=OraPrereq.jar
set PREREQ_CHECKS_JAR_FILE=OraPrereqChecks.jar

REM Directory Variables
set SRVM_JLIB_DIR=%OH%\jlib
set JRE_DIR=%OH%\jdk\jre
set LIB_DIR=%OH%\lib
set LIB32_DIR=%OH%\lib32
set JLIB_DIR=%OH%\jlib
set DVCA_JLIB_DIR=%OH%\dv\jlib
set ASSISTANTS_JLIB_DIR=%OH%\assistants\jlib
set INSTALLER_JLIB_DIR=%OH%\oui\jlib

REM Classpath
set JRE_CLASSPATH=%JRE_DIR%\lib\%JRE_FILE%
set I18_CLASSPATH=%JRE_DIR%\lib\%I18_FILE%
set EWT_CLASSPATH=%JLIB_DIR%\%EWT_FILE%;%JLIB_DIR%\%EWT_COMP_FILE%
set SHARE_CLASSPATH=%JLIB_DIR%\%SHARE_FILE%
set HELP_CLASSPATH=%JLIB_DIR%\%HELP_FILE%;%JLIB_DIR%\%JEWT_FILE%
set ICE_BROWSER_CLASSPATH=%JLIB_DIR%\%ICE_BROWSER5_FILE%
set KODIAK_CLASSPATH=%JLIB_DIR%\%KODIAK_FILE%
set SWING_CLASSPATH=%JLIB_DIR%\%SWING_FILE%
set XMLPARSER_CLASSPATH=%OH%\lib\%XMLPARSER_FILE%
set JDBC_CLASSPATH=%OH%\jdbc\lib\%JDBC_FILE%
set GDK_CLASSPATH=%JLIB_DIR%\%GDK_FILE1%;%JLIB_DIR%\%GDK_FILE2%;%JLIB_DIR%\%GDK_FILE3%;%JLIB_DIR%\%GDK_FILE4%
set NETCFG_CLASSPATH=%JLIB_DIR%\%NETCFG_FILE%;%JLIB_DIR%\%OJMISC_FILE%;%JLIB_DIR%\%PKI_FILE%;%JLIB_DIR%\%LDAP_FILE%;%JLIB_DIR%\%OPM_FILE%
set SRVM_CLASSPATH=%SRVM_JLIB_DIR%\%SRVM_FILE%;%SRVM_JLIB_DIR%\%SRVMHAS_FILE%;%SRVM_JLIB_DIR%\%SRVMASM_FILE%
set EM_CLASSPATH=%OH%\classes;%JLIB_DIR%\%EMLITE_JAR%;%JLIB_DIR%\emca.jar;%OH%\sysma\lib\emCORE.jar;%OH%\oc4j\j2ee\home\oc4j.jar;%OH%\oc4j\j2ee\home\db_oc4j_deploy.jar;%JLIB_DIR%\emConfigInstall.jar
set ASSISTANTS_COMMON_CLASSPATH=%ASSISTANTS_JLIB_DIR%\%ASSISTANTS_COMMON_FILE%
set DVCA_CLASSPATH=%DVCA_JLIB_DIR%\%DVCA_FILE%
set INSTALLER_CLASSPATH=%INSTALLER_JLIB_DIR%\%INSTALLER_FILE%;%INSTALLER_JLIB_DIR%\%PREREQ_JAR_FILE%;%OH%\inventory\prereqs\oui\%PREREQ_CHECKS_JAR_FILE%;%INSTALLER_JLIB_DIR%\%PREREQ_CHECKS_JAR_FILE%

REM Check for silent or help
set SILENT="false"

:ParamLoop
if /i "%1" == "" goto Cont1
if /i "%1" == "-silent" goto FoundSilent
if /i "%1" == "-install" goto FoundSilent
if /i "%1" == "-help" goto FoundSilent
if /i "%1" == "-h" goto FoundSilent
shift
goto ParamLoop

:FoundSilent
set SILENT="true"

:Cont1

REM The environment variable TWO_TASK cannot be set during the installation
set TWO_TASK=

REM The environment variable JAVA_HOME cannot be set during the installation
set JAVA_HOME=

REM Basic error checking
if not "%OH%" == "" goto Cont2
echo ORACLE_HOME not set. Set ORACLE_HOME and retry
goto End

:Cont2
REM Set SHLIB_PATH for HP to use 32bit native libraries
set SHLIB_PATH=%LIB32_DIR%;%ORACLE_HOME%\network\lib32;%SHLIB_PATH%

REM Set LIBPATH for AIX to use 32bit native libraries
set LIBPATH=%LIB32_DIR%;%ORACLE_HOME%\network\lib32;%LIBPATH%

REM Set Classpath for Data Vault Configuration Assistant
set CLASSPATH=%DVCA_CLASSPATH%;%JDBC_CLASSPATH%;%XMLPARSER_CLASSPATH%

REM Run DVCA

@echo on

%JRE_DIR%\bin\java -Dwindir=%windir% -Dsun.java2d.font.DisableAlgorithmicStyles=true -DORACLE_HOME=%OH% -DJDBC_PROTOCOL=oci -mx128m -classpath %CLASSPATH% oracle.security.datval.dvca.Dvca %*

:End
