set serveroutput on;
/* Insert common schema into csm$dictusers. 
   All other data dictionary schema is already inserted into csm$dictuses 
   when csm$dictuser is created. 
*/
insert into csm$dictusers 
  select distinct u.user#, u.name from sys.user$ u 
  where u.name in ('HR', 'OE', 'SH', 'PM');
/* this function runs a DML statement. It returns how many rows updated */
create or replace function csm$rundml wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
8
102 f3
Ku7Of/ePHTQvbCjNgzvJsAv6Wegwg1zQLcusZ3RAkBAYy8vIL1sftvQddpSWNxxhv9vwNYBS
UM75HMFscMa79rVhSYCXJ4S4EtATscFCLCz0castOwK8cDLRMJzhjDJZDvrg8HSjPKaXf1mU
OLmzKFZp9A0bluiLavPlwo2vsCAuByEwGxtH11HVVHwIG9Yw6WFLcyKyzXTZfDRRwN9ZY7Xe
5X+sUnLYhoI/ggmNZLznejUF

/
/* This function create a sql statment to update the clob/nvarchar2 for a table
   The sql statement will be something like:
      UPDATE USERNAME.TABLENAME SET 
       COL1 := CONVERT(COL1, TOCHAR, FROMCHAR'), COL2:=CONVERT(COL2, TOCHAR, FROMCHAR)
      WHERE ROWID >=MINROWID AND ROWID <MAXROWID;
*/
create or replace function csm$createsql wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
8
8a2 43e
bB30FF0rrlj+f0Kw4iWiDgj0fM8wgztcTCCDfI5Vgp0G8soCEfOsSCUa6DWer4lZ9Nd2sM26
dyXDHjY4HYO8pYa/c/dGps0wVHcowc6Szmgex5Ch8h3zZZ5O18KCD8H+Bc9OF7N5+6W4dPzu
it922uNfgFIwYvPs1O8VbKIMR2epVOwv7WHLC4y77DtABsj8TRgiM7vLL/qic3WmDERoznp1
kuTm3OeqGqXURrJu44nrnql8NQD60BbzLameucuSHw95xET7bSEMKk5jlgi9Fy3PJNtEXn36
MKtZ7leHa4BXKFTyzC9Gw8j2FWOJkRULEeY+sYFkqB2KNe/ApCVvKzaq09P3Z6nyvR1UTCI+
ae0yj5/yV8yGYbAolwANoFZLo/Sw6tHbOAVesCnsTGq99Q29QBBLlYlQp/ERFiDkFipuXJOU
3sjbkFhyUrY1MOB9Q0FBbMGCiFgv96GFwJqGIYCblmCvSjrnpIwwxP+sPN6pRx0i8qJBipNC
UMe2rQfzTg67bKygY/NfhpYAHkP+758hVJhM3kBV//zuCq1wz9YuvERidKpjHtEAMfyhQHoA
3+8hhHw4JakqIrdmRVfuqQ36HzrPmU5cZFMPi8uHbO2wgcKyrh49CZrVCpXZwrSPBEnqbcv5
N8RPOnsHB4H8zTqzA1Y+oSwJHwDejNHZrPgGzPE7HD8NAJGctQyKvrRmt6zXS25YH2RO4NqK
utw7M4sTVWkkG7fI8XSWqSHoe203Xhlby33fc3zkFbMA9goiETxfaPfKlOV7GMbS+GOxnCDz
C4LN4et7I7NG43Ds7j2cTTIRhM0VKzFOXBqn9z5OdifEVccG/tvqeJ4nf3tkQLhT/ryw5e5I
W1QLCotN2pfPV5c02bPBN+WnP6u61a0ZjxEFvzNiIEg++2JpNIseeR9ikbj1KJ7rQfGng0l+
epfJG6A0QY7JeJsY05sPKjgoT2K9C64Wg2T1hBy+men06jXAFHnBHEwv+BfeowkyFHQTACad
PN93ECZq4hpQPDg5PcWB6bHXfibX9l5gVqiL4Cb96aqd8BbEAkVVrqr79MpmYA==

/
create or replace procedure csm$main wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
13bf 845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=


/
prompt This script will update the content of the Oracle Data Dictionary. 
prompt Please ensure you have a full backup before initiating this procedure.
accept conf char prompt 'Would you like to proceed (Y/N)?';
declare
begin

       
    
    if (UPPER('&conf') <> 'Y') then
       return;
    end if;

    csm$main();
    return;

end;
/
declare
   svalue   varchar2(30);
   sqlstmt  varchar2(1024);
   tochar   varchar2(30);
   rowcnt   number;
begin

    
    select value into svalue from csm$parameters where name='CSALTER_FINISHED';
    if (svalue <> 'TRUE') then
       dbms_output.put_line('Checking or Converting phase did not finish successfully');
       dbms_output.put_line('No database (national) character set will be altered');
       dbms_output.put_line('CSALTER finished unsuccessfully.');
       return;
    end if;

     
    select value into svalue from csm$parameters where name='SCAN_CHAR';
    if (svalue = 'YES') then
       dbms_output.put_line('Alter the database character set...');
       select value into tochar from csm$parameters where name='TO_CHARSET_NAME';
       rowcnt := csm$rundml('alter database character set internal_use '||tochar);
       commit;
    end if;

    
    select value into svalue from csm$parameters where name='SCAN_NCHAR';
    if (svalue = 'YES') then
       dbms_output.put_line('Alter the national database character set...');
       select value into tochar from csm$parameters where name='TO_NCHARSET_NAME';
       rowcnt := csm$rundml('alter database national character set internal_use '||tochar);
       commit;
    end if;
    
    dbms_output.put_line('CSALTER operation completed, please restart database');
end;
/
/* restore csm$dictuser */
delete from csm$dictusers where username in ('PM', 'SH', 'HR', 'OE');
drop function csm$rundml;
drop function csm$createsql;
drop procedure csm$main; 
