#!/usr/local/bin/perl
# 
# $Header: files_perm_owner.pl 04-dec-2007.03:51:48 manosing Exp $
#
# files_perm_owner.pl
# 
# Copyright (c) 2006, 2007, Oracle. All rights reserved.  
#
#    NAME
#      files_perm_owner.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <owner and file permission policy>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    manosing    12/04/07 - XbranchMerge manosing_bug-6084513 from main
#    manosing    01/29/07 - correction to .htaccess property
#    manosing    01/12/07 - XbranchMerge manosing_lastpols from main
#    manosing    10/10/06 - Creation
#
#

use strict ;
    

  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaDbUtils.pl";
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaUtils.pl";
  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
  my $maxRowp = $ENV{'HTPERM'};
  my $maxRowpN = $ENV{'NHTPERM'};
  my $maxRowo = $ENV{'HTOWNER'};
  my $maxRow;
  my $limitp=0;
  my $limito=0;

  if(($^O =~ "linux")){
      $maxRow=$maxRowp;
  }elsif($^O eq "MSWin32"){
     $maxRow=$maxRowpN;
  }
  
# Apache conf file parsing(httpd.conf)
  my $sep = $^O =~ m/MSWin32/ ? "\\" : "\/";
  my $htaccessVal = ".htaccess";
  my $httpdConf = $oracleHome.$sep."Apache".$sep."Apache".$sep."conf".$sep."httpd.conf";
  if (open HTTPDCONF, "<$httpdConf"){
        my @htarray = <HTTPDCONF> ;
        
        @htarray = grep(!/^\ *#/, @htarray);
        @htarray = grep(/AccessFileName(\s+)/, @htarray);
        foreach my $en (@htarray){
            $en =~ s/(.*?)#(.*)/\1/ ;
            if($en =~ m/AccessFileName/){
                $en=~ s/^\s+//;
                my @details=split /\s+/, $en;
                if(@details >= 2)
                {
                    $htaccessVal=$details[1];
                    $htaccessVal=~ s/^\s+//;
                    $htaccessVal=~s/\s+$//;
                    last;
                }                    
            }
        }
    }
  
#  my $maxRows;
  # array entries for one permission-owner -> (permission_floodcontrol_ENV owner_floodcontrol_EVN mask file_path proprety_name)
  #  the property printed will look like 'proprety_name_perm' and 'proprety_name_owner'
   my @array =("TKPROF", "TKPROF_OWNER" ,027 ,$oracleHome."/bin/tkprof", "tkprof" ,
           "SQLPLUS", "SQLPLUS_OWNER", 006 ,$oracleHome."/bin/sqlplus",  "sqlplus",
           "WEBCACHE", "WEBCACHE_OWNER", 007 ,$oracleHome."/webcache/webcache.xml",  "webcache",
           "SNMP_RO", "SNMP_RO_OWNER", 007 ,$oracleHome."/network/admin/snmp_ro.ora",  "snmp_ro",
           "SNMP_RW", "SNMP_RW_OWNER", 007 ,$oracleHome."/network/admin/snmp_rw.ora",  "snmp_rw",
           "WDBSVR", "WDBSVR_OWNER", 007 ,$oracleHome."/Apache/modplsql/cfg/wdbsvr.app",  "wdbsvr",
           "XSQL", "XSQL_OWNER", 007 ,$oracleHome."/xdk/admin/XSQLConfig.xml",  "xsql");
       
  for( my $i=0;$i<=$#array;$i=$i+5)
  {
      #$maxRows = $ENV{$array[$i]};
      
          process($array[$i],$array[$i+1],$array[$i+2],$array[$i+3],$array[$i+4]);
      
  }


if(($^O =~ "linux")){

  my %ph=(wanted=>\&file_permission1, follow=>1, follow_skip=>2);
  my %oh=(wanted=>\&file_owner1, follow=>1, follow_skip=>2);

  find(\%ph,"$oracleHome/Apache");
  find(\%oh,"$oracleHome/Apache");
}elsif($^O eq "MSWin32"){

  find(\&file_permission1,"$oracleHome\\Apache");
  find(\&file_owner1,"$oracleHome\\Apache");
}


  
sub file_permission1
{
    my $path=$File::Find::name;
    if($_ eq $htaccessVal){
        if(  ($limitp > $maxRow-1)  &&  ($maxRow != -1)  ){
            exit(0);
        }
        my $perm=file_perm($path);
        if($perm >= 0){
    
             if(($^O =~ "linux")){
                $perm = $perm & 0777 ;
                    if(($perm & 0133)){
                          printf "em_result=htprem|%03o|$path\n",$perm;
                    $limitp++;
                    }
             }elsif($^O eq "MSWin32"){
                if($perm ne "0()"){
                     print "em_result=nt_htperm|$perm|$path\n";
                    $limitp++;
                }
             }
        }

    }
}

#since maxRow for owner and perm are diffenet, maxRow decide how time these function will output. A bigger difference in maxRowp and maxRowo will result in perfromance degradation
sub file_owner1 
{
    my $path=$File::Find::name;
    if($_ eq $htaccessVal){
        if(  ($limito > $maxRowo-1)  &&  ($maxRowo != -1)  ){
            exit(0);
        }
        my $owner =file_owner($path);
        if(!$owner || ($owner == -1)){
            return ;
        }
        my $oracleUser =file_owner($oracleHome);
        if(!$oracleUser || ($oracleUser == -1)){
            return;
        }
        if ($owner ne $oracleUser){
            print "em_result=htowner|$owner|$path\n";
            $limito++;
        }      
        
    }
}
  
sub process
{
    my $PERM =shift;
    my $OWNER =shift;
    my $mask = shift;
    my $path = shift;
    my $prop =shift; 
      my $perm=-1;
   my $NPERM='N'.$PERM;
    $PERM=$ENV{$PERM};
    $OWNER=$ENV{$OWNER};
    $NPERM=$ENV{$NPERM};
  
      if($^O eq "MSWin32"){
          $path =~s /\//\\/g;
     }
     
     if(($^O =~ "linux" && $PERM!=0)|| ($^O eq "MSWin32" && $NPERM!=0)){
          $perm=file_perm($path);
    }
    
#    print "em_result=DEBUG|$PERM ".rand()."\n";
#    print "em_result=DEBUG1|$OWNER ".rand()."\n";
#    print "em_result=DEBUG2|$mask ".rand()."\n";
#    print "em_result=DEBUG3|$path ".rand()."\n";
#    print "em_result=DEBUG4|$prop ".rand()."\n";
#    print "em_result=DEBUG6|$perm ".rand()."\n";
 
    if($perm >= 0){
    
         if(($^O =~ "linux")){
            $perm = $perm & 0777 ;
                if(($perm & $mask)){
                  printf "em_result=$prop\_perm|%03o|$path\n",$perm;
                }
         }elsif($^O eq "MSWin32"){
     #windows check for default permission. not print for 0()
        if($perm ne "0()"){
             print "em_result=nt_$prop\_perm|$perm|$path\n";
        }
         }
    }

    if($OWNER==0){
        return;
    }
    my $owner =file_owner($path);
    if(!$owner || ($owner == -1)){
        return ;
    }
    my $oracleUser =file_owner($oracleHome);
    if(!$oracleUser || ($oracleUser == -1)){
        return;
    }
    if ($owner ne $oracleUser){
        print "em_result=$prop\_owner|$owner|$path\n";
    }
}


