#!/usr/local/bin/perl
# 
# $Header: getHangTraces.pl 11-jan-2007.11:26:10 jsoule Exp $
#
# getHangTraces.pl
# 
# Copyright (c) 2007, Oracle. All rights reserved.  
#
#    NAME
#      getHangTraces.pl - Spur the capture of hang traces for 11g database.
#
#    DESCRIPTION
#      This will use the RDBMS sql script to gather hang traces.
#
#    NOTES
#      None.
#
#    MODIFIED   (MM/DD/YY)
#    jsoule      01/03/07 - Creation
# 

use vars qw($NT);
use strict;

require "emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/db_common.pl";

################################
## process inputs
################################

# stdin
my %stdinArgs = get_stdinvars();
my $username  = $stdinArgs{"EM_SYSDBA_USERNAME"};
my $password  = $stdinArgs{"EM_SYSDBA_PASSWORD"};

# environment variables
my $connect_string = $ENV{"EM_TARGET_ADDRESS"};
if ($password)
{
  EMAGENT_PERL_INFO("using SYSDBA credentials");

  $connect_string = "$username/$password as sysdba";
  #$connect_string = "$username/$password\@$connect_string as sysdba";
}
else
{
  EMAGENT_PERL_INFO("trying BEQ protocol and OS authentication");

  $connect_string = "/ as sysdba";
}

# command line
my $oracle_home = $ARGV[0];
my $oracle_sid  = $ARGV[1];

my ($sqlfile_handle, $sqlfile_name) = create_temp_file(".sql");
print $sqlfile_handle <<"EOS";
oradebug setmypid;
\@$oracle_home/rdbms/admin/hangdiag
oradebug tracefile_name;
exit;
EOS
close $sqlfile_handle;

my $prelim_mode = '-prelim';
my $exit_status = 0;

################################
## spawn sqlplus, piping back the output
################################
if (!$NT)
{
  if (!open(SQLPLUS, "-|"))
  {
    # Locally instantiate the relevant pieces of the ENV array so that
    #  SQL*Plus is spawned in the correct context.
    # Override the ORACLE_HOME, ORACLE_SID, LD_LIBRARY_PATH env variables.
    $ENV{'ORACLE_HOME'}     = $oracle_home;
    $ENV{'ORACLE_SID'}      = $oracle_sid;
    $ENV{'LD_LIBRARY_PATH'} = $oracle_home."/lib:".$ENV{'LD_LIBRARY_PATH'};

    my $exit_status =
     system("$oracle_home/bin/sqlplus $prelim_mode -S \"$connect_string\" < $sqlfile_name");

    exit;
  }
}
else
{
  # Locally instantiate the relevant pieces of the ENV array so that
  #  SQL*Plus is spawned in the correct context.
  # Override the ORACLE_HOME, ORACLE_SID, LD_LIBRARY_PATH env variables.
  $ENV{'ORACLE_HOME'}     = $oracle_home;
  $ENV{'ORACLE_SID'}      = $oracle_sid;
  $ENV{'LD_LIBRARY_PATH'} = $oracle_home."\\lib:".$ENV{'LD_LIBRARY_PATH'};

  # open("-|") is not permitted on NT, but it provides better diagnostics
  # so we keep it for non-NT platforms.
  open(SQLPLUS, "$oracle_home\\bin\\sqlplus $prelim_mode -S \"$connect_string\" < $sqlfile_name |");
}

################################
## The trace file is the last line of the output.
################################
my $tracefile = '';
while (<SQLPLUS>)
{
  $tracefile = $_;
}

close(SQLPLUS);

if ($exit_status)
{
  die "em_error=sqlplus exited with $exit_status\n";
}
else
{
  ################################
  ## return the trace file
  ################################
  print "em_result=$tracefile\n";

  exit 0;
}
