#!/usr/local/bin/perl
# 
# $Header: installationdrv.pl 05-dec-2006.22:29:40 manosing Exp $
#
# installationdrv.pl
# 
# Copyright (c) 2006, Oracle. All rights reserved.  
#
#    NAME
#      installationdrv.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    manosing    11/20/06 - Creation
#
#


use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaUtils.pl";

my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};

my $maxRow=$ENV{"DRIVEPERM"};

if($maxRow==0){
   exit(0);
}

sub ACLs {
     my $driveLetter =shift;
    my $osVolName; my $ouSerialNum; my $ouMaxNameLen; my $ouFsFlags; my $osFsType;
    GetVolumeInformation( $driveLetter, $osVolName,'' , $ouSerialNum, $ouMaxNameLen, $ouFsFlags, $osFsType, 8 );
    if (!($osFsType =~ 'NTFS')){
        return -1;#the filesystem is not NTFS, forget about ACLs
    }

    my %hash;
    my $name;my $mask;my $entry;
    my %resultHash;
    my $count=0;
    
    if ( Get( $driveLetter, \%hash ) ) {
        while( ($name, $mask) = each %hash ) {
            
                my @rights;
                EnumerateRights($mask, \@rights );
                $resultHash{$name} = \@rights;
                $count+=@rights;
        }
    }
    return (\%resultHash, $count);
}


if($^O eq "MSWin32"){

    my $driveLetter = $oracleHome;
    if (!($driveLetter =~ m/(.*):(.*)/)){
        exit(0); #Windows NT filenames without colons are not supported
    }
    $driveLetter  =~ s/(.*?)(:)(.*)/$1$2/;
    $driveLetter = $driveLetter."\\";
    my ($res, $numRows) =  ACLs($driveLetter); # we want all entries. Hoping 9000 is enough.
    if($res == -1){
        exit(0);
    }
    my %hash = %$res;   
    my $arrRef = $hash{"Everyone"};
    if($arrRef ne ""){
        print "em_result=drive_perm|Everyone\n";
    }
}

