#!/usr/local/bin/perl
# 
# $Header: logArchiveDest.pl 12-jan-2007.12:11:50 manosing Exp $
#
# logArchiveDest.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      logArchiveDest.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    manosing    01/12/07 - XbranchMerge manosing_lastpols from main
#    manosing    12/28/06 - flood control for windows policy
#    dkjain      08/18/05 - Fixed repeating key pblm
#    dsukhwal    07/26/05 - log_archive_start only pre 10g 
#    dkjain      07/03/05 - Fixed the em_error with print 
#    dsukhwal    06/14/05 - handle win32 cases
#    dsukhwal    05/12/05 - limit number of rows pushed 
#    dkjain      01/26/05 - Fixed Bug-4143308 
#    dkjain      12/27/04 - Added log_archive_dest_nee function
#    dkjain      12/15/04 - Adding more log_archive_dest_n 
#    dkjain      12/14/04 - Changed owner mask to octet value 
#    dkjain      10/31/04 - Fixed unable to connect
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
  require "emd_common.pl";
  require "semd_common.pl";
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaDbUtils.pl";
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaUtils.pl";
  my %stdinArgs = get_stdinvars();
  my $username = $stdinArgs{"EM_TARGET_USERNAME"};
  my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
  my $oracleOwner;
  my $dsn = "dbi:Oracle:" ;
  my $address = $ENV{EM_TARGET_ADDRESS};
  my $role = $ENV{EM_TARGET_ROLE};
  my $mode = 0;
  my $maxRowsPerm;
  my $maxRowsDxPerm;
  
  if($^O eq "MSWin32"){
     $maxRowsPerm = $ENV{'NLADPERM'};#the maximum number of rows for the policy Log_Archive_Destination_Permission
    $maxRowsDxPerm = $ENV{'NLADDXPERM'};#the maximum number of rows for the policy Log_Archive_Duplex_Destination_Permission
  }else{
    $maxRowsPerm = $ENV{'LADPERM'};#the maximum number of rows for the policy Log_Archive_Destination_Permission
    $maxRowsDxPerm = $ENV{'LADDXPERM'};#the maximum number of rows for the policy Log_Archive_Duplex_Destination_Permission
  }
  my $maxRowsOwner = $ENV{'LADOWN'};#the maximum number of rows for the policy Log_Archive_Destination_Owner
  my $maxRowsDxOwner = $ENV{'LADDXOWN'};#the maximum number of rows for the policy Log_Archive_Duplex_Destination_Owner
  
  if($role =~ /SYSDBA/i)
  {
    $mode = 2;
  }
  elsif($role =~ /SYSOPER/i)
  {
    $mode = 4;
  }

 my $table = "v\$database";  
 my $value = "log_mode";
 my $dbh = open_db_connection("dbi:Oracle:", "$username@".$address,$password,$mode); 
 my @archiveMode = getValue($dbh,$value,"", "",$table);
  

##  If not in archive mode returns without outputting.
 if($archiveMode[0] ne "ARCHIVELOG"){
    close_db_connection($dbh) ;
    exit(0);
 }

 my $banner = "banner" ;
 my $vtable ="v\$version" ;
 my $sth = $dbh->prepare_cached("SELECT $banner FROM $vtable where banner like 'Oracle%' ")
    or die print "em_error=Couldn't prepare statement: $dbh->errstr"; 
    $sth->execute() 
    or die print "em_error=Couldn't execute statement: $sth->errstr";
 my @edition = $sth->fetchrow_array();
 my $name = "name" ;
 $value = "value" ;
 $table = "v\$parameter" ;
 my @logArchiveStart = getValue($dbh,$value,$name, "log_archive_start",$table);
 ##Only single entry will be there in v$parameter
 if( ($logArchiveStart[0] ne "TRUE") && !($edition[0] =~ "10g") ){
   print "em_result=log_archive_start|$logArchiveStart[0]\n" ; 
 }

 $oracleOwner =  file_owner($oracleHome);

 #If Not an Enterprise Edition   
 if(!($edition[0] =~ "Enterprise Edition")){
   log_archive_dest_nee();
   close_db_connection($dbh) ;
   exit(0);
 }
 #The Following part will handle if Db is Enterprise Edition
 my $subscript = 1;
 my @log_archive_dest_ee ; 
 my $log_comma_sep_string  ;
 my $obseletedLogArchive = 1 ;
 while( $subscript < 11){
    @log_archive_dest_ee = getValue($dbh,$value,$name, "log_archive_dest_$subscript",$table);
    if($log_archive_dest_ee[0] ne ""){
      if(defined($log_comma_sep_string)){
       $log_comma_sep_string = qq($log_comma_sep_string, $log_archive_dest_ee[0]);     }
      else {
       $log_comma_sep_string = $log_archive_dest_ee[0] ;
      }
    }  
    $subscript++;
 }
 if( $log_comma_sep_string ne ""){
     $mask = 007 ;
     $globalProperty = 'log_archive_dest_perm' ; 
     if($^O =~ "linux"){
        comma_separated_files($log_comma_sep_string,$mask, $maxRowsPerm);
     }
     elsif($^O eq "MSWin32"){
        win32_comma_sep_files_perm($log_comma_sep_string, $maxRowsPerm, "nt_$globalProperty");
     }  
     $mask = 0 ;
     $globalProperty = 'log_archive_dest_owner' ; 
     comma_separated_files($log_comma_sep_string,$mask,$oracleOwner, $maxRowsOwner);
     $obseletedLogArchive = 0 ;
 }

 #If none of log_archive_dest_1..10 set to a valid directory 
 #in EE then check for log_archive_duplex_dest and log_archive_dest parameter
 if($obseletedLogArchive){
  log_archive_dest_nee();
 }
 close_db_connection($dbh) ;
 exit(0);

 sub log_archive_dest_nee{
  
  my @log_archive_dest  = getValue($dbh,$value,$name, "log_archive_dest",$table) ;  
  my @log_archive_duplex_dest = getValue($dbh,$value,$name, "log_archive_duplex_dest",$table) ;
  my $mask ;

  if($log_archive_dest[0] ne ""){
   $mask = 007 ;
   $globalProperty = 'log_archive_dest_perm' ; 
   if($^O =~ "linux"){
       comma_separated_files($log_archive_dest[0],$mask, $maxRowsPerm);
   }
   elsif($^O eq "MSWin32"){
       win32_comma_sep_files_perm($log_archive_dest[0], $maxRowsPerm, "nt_$globalProperty");
   }  
   $mask = 0 ;
   $globalProperty = 'log_archive_dest_owner' ; 
   comma_separated_files($log_archive_dest[0],$mask,$oracleOwner, $maxRowsOwner);
  
  if($log_archive_duplex_dest[0] ne ""){
   $mask = 007 ;
   $globalProperty = 'log_archive_duplex_dest_perm' ; 
   if($^O =~ "linux"){
       comma_separated_files($log_archive_duplex_dest[0],$mask, $maxRowsDxPerm);
   }
   elsif($^O eq "MSWin32"){
       win32_comma_sep_files_perm($log_archive_duplex_dest[0], $maxRowsDxPerm, "nt_$globalProperty");
   }  
   $mask = 0 ;
   $globalProperty = 'log_archive_duplex_dest_owner' ; 
   comma_separated_files($log_archive_duplex_dest[0],$mask,$oracleOwner,$maxRowsDxOwner);
  }
 }
 }
 
