#!/usr/local/bin/perl
# 
# $Header: ohBinFilesOwner.pl 14-jun-2005.16:24:48 dsukhwal Exp $
#
# ohBinFilesOwner.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      ohBinFilesOwner.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    dsukhwal    05/12/05 - limit number of rows pushed 
#    dsukhwal    05/05/05 - handle win32 cases 
#    dkjain      04/12/05 - modified check condition 
#    dkjain      03/27/05 - Filtering out the files owned by root 
#    dkjain      02/28/05 - Fixed bug-4191040 
#    dkjain      12/30/04 - Adding check_512char,check_64char is removed
#    dkjain      10/31/04 - Bug-3977629
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
  
   use strict ;
   require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaDbUtils.pl";
   require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaUtils.pl";
   my $maxRows = $ENV{'OHBINOWN'};
   my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
   my $property = "oh_bin_files_owner" ;
   my $oracleOwner ;
   my $limit = 0;
   $oracleOwner =file_owner($oracleHome);#works for both mswin32, and linux

   if($^O =~ "linux"){
     my %h=(wanted=>\&verify_files_owner, follow=>1, follow_skip=>2);
     find(\%h, qq($oracleHome/bin)); 
   }
   elsif($^O eq "MSWin32"){
     find(\&verify_files_owner, qq($oracleHome/bin)); 
   }
  #else { code for systems neither mswin32, nor linux}



  #This is to collect owner of a given pathname 
 sub verify_files_owner{
    my $fpath=$File::Find::name;
    if($^O eq "MSWin32"){#perl find will always attach forward slash as directory separator
        $fpath =~ s/\//\\/g;#converting it into backslash for mswin32, for want of a better alternative
    }
    my $retOwner =  file_owner($fpath);
    if(($retOwner ne $oracleOwner)&&($retOwner ne "root")&&($retOwner ne "")&&($retOwner != -1))
    { 
        $fpath = check_512char($fpath);  
        print "em_result=$property|$retOwner|$fpath\n";
        $limit++ ;   #limiting the uploaded rows to $maxRows
        if( ($limit > $maxRows-1)  &&  ($maxRows != -1) ){
    	  exit(0);
	}
    }
 }

