#!/usr/local/bin/perl
# 
# $Header: ohFilesPerm.pl 12-jan-2007.12:11:52 manosing Exp $
#
# ohFilesPerm.pl
# 
# Copyright (c) 2004, 2007, Oracle. All rights reserved.  
#
#    NAME
#      ohFilesPerm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    manosing    01/12/07 - XbranchMerge manosing_lastpols from main
#    dsukhwal    01/06/07 - XbranchMerge manosing_ntpol from main
#    manosing    12/04/06 - bug 5443094
#    dsukhwal    05/12/05 - limit number of rows pushed 
#    dkjain      03/28/05 - Limiting number of rows to be uploaded to 200
#    dsukhwal    02/15/05 - exceptional cases in file_perm usage 
#    dkjain      12/30/04 - check_permission is removed 
#    dkjain      10/31/04 - Bug-3977629
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
 #As this is it to be collected for unix env only.
  use strict ;

  # get $ORACLE_HOME from environment
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaDbUtils.pl";
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaUtils.pl";
  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
  my $maxRows = $ENV{'OHPERM'};
  my $maxRows1 = $ENV{'OHPERM1'};
  my $property = "oh_files_perm" ;
  my $limit = 0 ;
 
##find command will invoke the verify_files_perm on each file under the given point
#Which is ORACLE_HOME for this policy

  if($^O =~ "linux") {
   find(\&verify_files_perm,$oracleHome);
  }
  elsif($^O eq "MSWin32"){
      find(\&verify_files_perm_win32, $oracleHome); 
  }
##############################################################################################

  #This is to verify owner of a given pathname recursively.
  sub verify_files_perm{
    my $fpath=$File::Find::name;
    my $permString ;
    my $flag = 0 ; 
    if(!($fpath=~ qq($oracleHome/bin) ))
    {   
     my $retMode  =  file_perm($fpath);
     if($retMode >= 0){
       $retMode = $retMode & 0777 ;
       if(($retMode & 007)){ 
          $fpath = check_512char($fpath);
          if(  ($limit >= $maxRows1-1)  &&  ($maxRows1 != -1)  ){
            exit(0);
          }
          #$permString = rwx_string($retMode);
          printf "em_result=$property|%03o|$fpath\n",$retMode;
          $limit++ ;   #limiting the uploaded rows to 200
       }
     }
   } 
}



 sub verify_files_perm_win32{
    my $fpath=$File::Find::name;
        $fpath =~ s/\//\\/g;#perl find will always attach forward slash as directory separator
                    #converting it into backslash for mswin32, for want of a better alternative
    if(!compareNegInf($limit, $maxRows1)){
        exit(0);
    }
    my $users = win32_file_perm($fpath);
    if($users != -1){
        if($users ne "0()"){
	    print "em_result=nt_$property|$users|$fpath\n";
            $limit++;
        }
    }
 }


