#!/usr/local/bin/perl
# 
# $Header: osmresp.pl 29-jul-2004.14:34:18 jochen Exp $
#
# osmresp.pl
# 
# Copyright (c) 2004, Oracle. All rights reserved.  
#
#    NAME
#      osmresp.pl - ASM response metric
#
#    DESCRIPTION
#      ASM response metric
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jochen      07/29/04 - jochen_bug-3445521
#    jochen      07/26/04 - Creation
# 

use strict;
use Oraperl;
use DBI;
use DBI qw(:sql_types);

require "emd_common.pl";

my %stdinArgs = get_stdinvars();

my $username = $stdinArgs{"EM_TARGET_USERNAME"};
my $password = $stdinArgs{"EM_TARGET_PASSWORD"};

my $address = $ENV{EM_TARGET_ADDRESS};
my $role = $ENV{EM_TARGET_ROLE};

my $mode = 0;
if($role =~ /SYSDBA/i)
{
  $mode = 2;
}
elsif($role =~ /SYSOPER/i)
{
  $mode = 4;
}

my $lda;
unless ( $lda = DBI->connect('dbi:Oracle:', "$username@".$address, "$password", 
                            {ora_session_mode => $mode,
                             PrintError => 0,
                             RaiseError => 0}) ) 
{ 
  if( index($ora_errstr, "01017",0)!=-1)
  {
    die "$ora_errstr\n";
  }
  else
  {
      print "em_result=0|$ora_errstr\n";
  }
  exit 0;
}
  
print "em_result=1|\n";
  
exit 0; 

