#!/usr/local/bin/perl
# 
# $Header: sgastop.pl 26-may-2005.12:47:14 blivshit Exp $
#
# sgastop.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      sgastop.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    blivshit    05/26/05 - add NT specific environment info 
#    hopark      05/11/05 - Creation
# 
require "emd_common.pl";
require "semd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/db_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/sgapid.pl";
require POSIX;
use vars qw($NT);

$cmd = trim($ARGV[0]);
$sid = trim($ARGV[1]);
$host = trim($ARGV[2]);
$port = trim($ARGV[3]);
$emdhome = trim($ARGV[4]);

if ($emdhome eq "") {
  $emdhome = trim($ENV{'EMDROOT'});
  if($emdhome eq "") {
     $emdhome = trim($ENV{'ORACLE_HOME'});
  }
}
if($sid eq "") {
   $sid = trim($ENV{'ORACLE_SID'});
   if ($sid eq "") {
      $sid = trim($ENV{'ORA_SID'});
   }
}
if ($host eq "") {
   $host  = trim($ENV{'HOSTNAME'});
   ($host,$aliases,$addrtype,$length,@addrs)=gethostbyname($host);
}
if ($port eq "") {
    $port = 15091;
}
$connstr = "(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=" . $host . ")(Port=" . $port . "))(CONNECT_DATA=(SID=" . $sid . ")))";
$rpidval = getsgapid($emdhome, $connstr);
$result = 0;
$msg = "";
if (!($rpidval eq "")) {
    $res = kill 9, $rpidval;
    if ($res) {
        $msg = "killed nmccollector " . $rpidval;
    } else {
        $msg = "failed to kill nmccollector " . $rpidval;
        $result = 1;
    }
} else {
    $msg = "nmccollector process does not exist";
}
print $msg . "\n";
exit $result;

