#!/usr/local/bin/perl
# 
# $Header: sqlnetParams.pl 12-jan-2007.12:11:53 manosing Exp $
#
# sqlnetParams.pl
# 
# Copyright (c) 2004, 2007, Oracle. All rights reserved.  
#
#     NAME
#       sqlnetParams.pl - <one-line expansion of the name>
#
#     DESCRIPTION
#       <short description of component this file declares/defines>
#
#     NOTES
#       <other useful comments, qualifications, etc.>
#
#     MODIFIED    (MM/DD/YY)
#     manosing  01/12/07  - XbranchMerge manosing_lastpols from main
#     manosing  12/28/06  - flood control for windows policy
#     manosing  10/09/06 -  add sqlnet.inbound_connect_timeout ssl_server_dn_match 
#     dsukhwal  06/30/05 - support flood control for all policies 
#     dsukhwal  06/06/05 - handle win32 cases 
#     dsukhwal  05/17/05 - moving to listener metadata 
#     dsukhwal  04/20/05 - use target TNS_ADMIN 
#     dsukhwal     02/15/05 - bug 4171687 : remove chdir 
#     dsukhwal     02/04/05 - change property values 
#     dsukhwal     02/03/05 - add sqlnet.allowed_logon_version 
#     dsukhwal     01/03/05 - support split policies 
#     dsukhwal     01/12/05 - permissions in octal 
#     dsukhwal     12/14/04 - Display permissions in rwx format(bug 4057002) 
#     dkjain         10/13/04 - More functionality added 
#     dkjain         10/08/04 - dkjain_esa_impl_init
#     dkjain         10/08/04 - Creation
# 
  use strict;  
  use vars qw($NT $S); #both come from db_common.pl
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaUtils.pl";
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/db_common.pl";
  
  my $jdkHome = "$ENV{JAVA_HOME}";  
  my $SqlnetLocation = $ENV{'LSNR_ORA_DIR'};#sqlnet.ora location 
  my $fp = $SqlnetLocation.$S."sqlnet.ora";
  my $OHuid = file_owner($ENV{'LSNR_ORACLE_HOME'}); #The owner of the target listener home
  my $allowedLoginFlag = 0; #0 if not defined in sqlnet.ora file, 1 if defined
  my $sslServerDnMatchFlag = 0; #0 if not defined in sqlnet.ora file, 1 if defined
  my $TGT_ORACLE_HOME = $ENV{'LSNR_ORACLE_HOME'};

  my $rowNum;
  sqlnet_ora_perms();
  parse_sqlnet_ora();

sub parse_sqlnet_ora
{#information about trace_directory_server trace_directory_client log_directory_server log_directory_client
  my $pathSep;
  if($NT){
    $pathSep = "\";\"";
  }
  else{
    $pathSep = "\":\"";
  }
  my $classPath = "$ENV{ORACLE_HOME}".$S."sysman".$S."jlib".$S."emdbAgent.jar".$pathSep."$ENV{ORACLE_HOME}".$S."jlib".$S."netcfg.jar";
  my $params = "trace_directory_server trace_directory_client log_directory_server log_directory_client ".
                "sqlnet.allowed_logon_version sqlnet.inbound_connect_timeout ssl_server_dn_match";
  my $systemCommand = 
      "$jdkHome".$S."bin".$S."java -cp $classPath ".
      "oracle.sysman.db.esa.SqlNetParams $SqlnetLocation".$S."sqlnet.ora $params|";
  $! = 0;
    if (!open(CHECKER, "$systemCommand"))
    {
        exit(0);
    }
    my @allLines;
    while (my $line = <CHECKER>)
    {
        if($line){
        $line =~ s/^\s+//;
        $line =~ s/\s+$//;
        push(@allLines,$line);
        }
    }
    my @allUniqLines = uniq_array(@allLines);
    foreach  (@allUniqLines) {
        my @values = split('=', $_);
        if ($values[0] eq "log_directory_client")
        {
            sqlnet_client_log_directory($values[1]);
        }
        elsif ($values[0] eq "log_directory_server")
        {
            sqlnet_server_log_directory($values[1]);
        }
        elsif ($values[0] eq "trace_directory_client")
        {
            sqlnet_client_trace_directory($values[1]);
        }
        elsif ($values[0] eq "trace_directory_server")
        {
            sqlnet_server_trace_directory($values[1]);
        }
        elsif ($values[0] eq "sqlnet.allowed_logon_version")
        {
            $allowedLoginFlag = 1;
            sqlnet_allowed_logon_version($values[1]);
        }     
        elsif ( $values[0] eq "sqlnet.inbound_connect_timeout")    
        {
            sqlnet_ora_inbound_connect_timeout($values[1]);
        }        
        elsif ( $values[0] eq "ssl_server_dn_match")    
        {
            $sslServerDnMatchFlag = 1;
            ssl_server_dn_match($values[1]);
        }
                             
            
    }
    if ($allowedLoginFlag == 0)
    {
        sqlnet_allowed_logon_version("DEFAULT");
    }        
    if ($sslServerDnMatchFlag == 0)
    {
        ssl_server_dn_match("DEFAULT");
    }
}
sub ssl_server_dn_match
{
    my $value = shift;
     my $maxRows = $ENV{'SSLDN'};
     if(!compareNegInf(0, $maxRows)){
         return;
     }
                 
    my $res = check_512char($value);
    if($res != -1){                              
        print "em_result=ssl_server_dn_match|$res|NA\n";
    }
    
}
sub sqlnet_ora_inbound_connect_timeout
{
    my $value = shift;
    my $maxRows = $ENV{'SQLNETINBOUND'};
    if(!compareNegInf(0, $maxRows)){
        return;
    }
    # this is doubtful everywhere else check_512char is used only with windows
    my $res = check_512char($value);
    if($res != -1){
     print "em_result=inbound_connect_timeout|$res|NA\n";   
    }
}
sub sqlnet_ora_perms
{
    my $maxCount;
   if($^O eq "MSWin32"){
    $maxCount = $ENV{'NSQLNETPERMSMAX'};
   }else{
    $maxCount = $ENV{'SQLNETPERMSMAX'};
   } 
    $rowNum = 0;
    my $err="" ;
    if($^O eq "linux") #check if platform is linux
    {
        my $fperms = file_perm($fp);
        if(($fperms >= 0) && (compareNegInf(0,$maxCount)))
        {
            $fperms = $fperms & 0777;
            printf("em_result=sqlnetora_permission|%03o|NA\n",$fperms);
        }
        else
        {
            #file_perm failed to get the permissions for some reason
        }
    }
    elsif($^O eq "MSWin32"){
        if(!compareNegInf($rowNum, $maxCount)){
            return;
        }       
        my $win_perm = check_512char(win32_file_perm($fp));
        if($win_perm != -1) {
            print "em_result=nt_sqlnetora_permission|$fp|$win_perm\n";
            $rowNum++;
        }
    }
    #else
    #{
        #non-linux and non-NT stuff;
    #}
}

sub sqlnet_client_log_directory
{
    my $maxPermCount;#for this subroutine, do not print more than $maxPermCount(applies to only the 
                        #permission rows, not the owner row)
    my $maxOwnCount = $ENV{'CLDOWN'};

    if($^O eq "MSWin32"){
        $maxPermCount = $ENV{'NCLDPERM'};
    }else{
        $maxPermCount = $ENV{'CLDPERM'};
    }
    $rowNum = 0;
    my $perms;
    my $owner;
    my $correctFile = shift;
    if($^O eq "linux") #check if platform is linux
    {
        $perms=file_perm($correctFile);
        if( ($perms >= 0) && compareNegInf($rowNum, $maxPermCount)) {
            $perms = $perms & 0777;
            printf("em_result=client_log_directory_perm|%03o|$correctFile\n",$perms);
            $rowNum++;
        }
        #else{}  #file_perm failed to get the permissions for some reason
    }
    elsif($^O eq "MSWin32"){
        my $win_perm = check_512char(win32_file_perm($correctFile));
        if( ($win_perm != -1) && (compareNegInf($rowNum, $maxPermCount)) ) {
            print "em_result=nt_client_log_directory_perm|$correctFile|$win_perm\n";
            $rowNum++;
        }
    }
    compareOwner("client_log_directory_own", $maxOwnCount, $correctFile, $TGT_ORACLE_HOME);
}

sub sqlnet_server_log_directory
{
    my $maxPermCount;#for this subroutine, do not print more than $maxPermCount(applies to only the
                        #permission rows, not the owner row)
    my $maxOwnCount = $ENV{'SLDOWN'};
    
    if($^O eq "MSWin32"){
        $maxPermCount = $ENV{'NSLDPERM'};
    }else{
        $maxPermCount = $ENV{'SLDPERM'};
    }
    $rowNum = 0;
    my $perms;
    my $owner;
    my $correctFile = shift;
    if($^O eq "linux") #check if platform is linux
    {
        $perms=file_perm($correctFile);
        if( ($perms >= 0) && compareNegInf($rowNum, $maxPermCount) ){
            $perms = $perms & 0777;
            printf("em_result=server_log_directory_perm|%03o|$correctFile\n",$perms); #was %04o
            $rowNum++;
        }
        #else{}  #file_perm failed to get the permissions for some reason
    }
    elsif($^O eq "MSWin32"){
        my $win_perm = check_512char(win32_file_perm($correctFile));
        if( ($win_perm != -1) && (compareNegInf($rowNum, $maxPermCount)) ){
            print "em_result=nt_server_log_directory_perm|$correctFile|$win_perm\n";
            $rowNum++;
        }
    }
    compareOwner("server_log_directory_own", $maxOwnCount, $correctFile, $TGT_ORACLE_HOME);
}

sub sqlnet_client_trace_directory
{
    my $maxPermCount;#for this subroutine, do not print more than $maxPermCount(applies to only the
                        #permission rows, not the owner row)
    my $maxOwnCount = $ENV{'CTDOWN'};

    if($^O eq "MSWin32"){
        $maxPermCount = $ENV{'NCTDPERM'}
    }else{
        $maxPermCount = $ENV{'CTDPERM'}
    }
    $rowNum = 0;
    my $correctFile = shift;
    my $owner;
    if($^O eq "linux") #check if platform is linux
    {
        my $perms=file_perm($correctFile);
        if( ($perms >= 0) && compareNegInf($rowNum, $maxPermCount) ){
            $perms = $perms & 0777;
            printf("em_result=client_trace_directory_perm|%03o|$correctFile\n",$perms); #was %04o
            $rowNum++;
        }
        #else{}  #file_perm failed to get the permissions for some reason
    }
    elsif($^O eq "MSWin32"){
        if(!compareNegInf($rowNum, $maxPermCount)){
            return;
        }       
        my $win_perm = check_512char(win32_file_perm($correctFile));
        if( ($win_perm != -1) && (compareNegInf($rowNum, $maxPermCount)) ){
            print "em_result=nt_client_trace_directory_perm|$correctFile|$win_perm\n";
            $rowNum++;
        }
    }
    compareOwner("client_trace_directory_own", $maxOwnCount, $correctFile, $TGT_ORACLE_HOME);
}
    
sub sqlnet_server_trace_directory
{
    my $maxPermCount;#for this subroutine, do not print more than $maxPermCount(applies to only the
                        #permission rows, not the owner row)
    my $maxOwnCount = $ENV{'STDOWN'};#for this subroutine, do not print more than $maxPermCount(applies to only the
    
    if($^O eq "MSWin32"){
        $maxPermCount = $ENV{'NSTDPERM'};
    }else{
        $maxPermCount = $ENV{'STDPERM'};
    }
    $rowNum = 0;
    my $perms;
    my $owner;
    my $correctFile = shift;
    if($^O eq "linux") #check if platform is linux
    {
        my $perms=file_perm($correctFile);
        if( ($perms >= 0) && compareNegInf($rowNum, $maxPermCount) ){
            $perms = $perms & 0777;
            printf("em_result=server_trace_directory_perm|%03o|$correctFile\n",$perms); #was %04o
            $rowNum++;
        }
    }
    elsif($^O eq "MSWin32"){
        my $win_perm = check_512char(win32_file_perm($correctFile));
        if( ($win_perm != -1) && (compareNegInf($rowNum, $maxPermCount)) ){
            print "em_result=nt_server_trace_directory_perm|$correctFile|$win_perm\n";
            $rowNum++;
        }
    }
    compareOwner("server_trace_directory_own", $maxOwnCount, $correctFile, $TGT_ORACLE_HOME);
}

sub sqlnet_allowed_logon_version
{
    my $value = shift;
    my $maxRows = $ENV{'ALLLOG'};
    if(compareNegInf(0, $maxRows)){
        print "em_result=allowed_logon_version|$value|NA\n";
    }
}
