#!/usr/local/bin/perl
# 
# $Header: utlFileDir.pl 17-aug-2006.04:40:43 denath Exp $
#
# utlFileDir.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      utlFileDir.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    denath      08/17/06 - Fix Bug 5453944 to check and remove duplicate key
#                           values, if exists.
#    dkjain      07/03/05 - Fixed the em_error with print 
#    dsukhwal    05/13/05 - limit number of rows pushed 
#    dsukhwal    05/05/05 - handle win32 cases 
#    dsukhwal    02/15/05 - exceptional cases in file_perm usage 
#    dkjain      12/25/04 - check_permission() removed 
#    dkjain      12/14/04 - Changed mask used to extract the permissions of others 
#    dkjain      10/31/04 - Fixed unable to connect
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
  require "emd_common.pl";
  require "semd_common.pl";
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaDbUtils.pl";
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaUtils.pl";

  my $dsn = "dbi:Oracle:" ;
  my %stdinArgs = get_stdinvars();
  my $username = $stdinArgs{"EM_TARGET_USERNAME"};
  my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
  my $address = $ENV{EM_TARGET_ADDRESS};
  my $role = $ENV{EM_TARGET_ROLE};
  my $mode = 0;
  my $rowNum = 0;
  
  if($role =~ /SYSDBA/i)
  {
    $mode = 2;
  }
  elsif($role =~ /SYSOPER/i)
  {
    $mode = 4;
  }


   my $property1 = "utl_file_dir" ;
   my $property2 ="utl_file_dir_9i+";  
   my $utlFileDirMax = $ENV{'UTLFILEDIRMAX'};
   my $utlFileDir9Max = $ENV{'UTLFILEDIR9MAX'};
   my $table = "v\$parameter";  
   my $value = "value";
   my $name = "name";

   my $dbh = open_db_connection("dbi:Oracle:", "$username@".$address,$password,$mode); 
   my @utlFileDir = getValue($dbh,$value,$name, "utl_file_dir",$table);
  
   $table = "v\$version" ;
   my $banner = "banner" ;
   my $sth = $dbh->prepare_cached("SELECT $banner FROM $table where $banner like '%Oracle%' ")
	    or die print "em_error=Couldn't prepare statement: $dbh->errstr" ; 

        $sth->execute()
        or die print "em_error=Couldn't execute statement: $sth->errstr" ;
   

   my @edition = $sth->fetchrow_array();
   if(!($edition[0]=~ "8i")&&($utlFileDir[0] ne ""))
   {
       ##Policy 2 if the editions is 9i and the utl_file_dir is nonempty this part
       ##will cause a violation.
       $globalProperty = $property2 ;
       split_utl_file_dir($utlFileDir[0], $utlFileDir9Max) ; 
       exit(0);
   }
   elsif(!($edition[0]=~ "8i")&&($utlFileDir[0] eq ""))
   {
      #if editions is 9i and utl_file_dir empty then no need to continue 
      exit(0); 
   }
  
  my @userDumpDest = getValue($dbh,$value,$name, "user_dump_dest",$table);
  close_db_connection($dbh);

  if(($edition[0]=~ "8i") &&($utlFileDir[0] ne "")){
    utl_file_check($utlFileDir[0],$userDumpDest[0],$utlFileDirMax) ; 
  }

  sub utl_file_check() {
   my ($utlFileDir,$userDumpDest,$maxRows) = @_;
   $userDumpDest=~ s/^\?/$oracleHome/g; 
   my @utlFileDirList = split(/, /,$utlFileDir); 
   #Remove the duplicates in array. This is definied in esaUtil.pl
   @utlFileDirList = uniq_array(@utlFileDirList);
   my $dir ;
   #my @dNameList ;
   my $retMode ;
   if(defined($maxRows) && ($maxRows >= 0)){
    splice(@utlFileDirList, $maxRows);
   }
   for $dir (@utlFileDirList){  
    if($dir eq $userDumpDest)
    {
     print "em_result=$property1|$dir\n";
    }
    elsif($dir eq ".")
    {
     print "em_result=$property1|$dir\n" ;
    }
    elsif($dir eq "*")
    {
     print "em_result=$property1|$dir\n" ;
    }
    else {
     if($^O eq "linux"){
         $retMode = file_perm($dir);
         if(($retMode & 007) > 0) {
           #$retMode = ($retMode & 0777) & 007 ;
           $dir = check_512char($dir); 
           #$globalProperty = $property1 ; 
           #@dNameList = util_print(@dNameList,$dir); 
           print "em_result=$property1|$dir\n";
         }
     }
     elsif($^O eq "MSWin32"){
        if(!compareNegInf($rowNum, $maxRows)){
            exit(0);
        }
        $dir = check_512char($dir); 
        print "em_result=$property1|$dir\n" ;
     }
    }
   }
 }
 sub split_utl_file_dir() {
   my $utlFileDir = shift ; 	
   my $maxRows = shift;
   my @utlFileDirList = split(/, /,$utlFileDir); 
   #Remove the duplicates in array. This is definied in esaUtil.pl
   @utlFileDirList = uniq_array(@utlFileDirList); 
   my $dir ;
   if(defined($maxRows) && ($maxRows >= 0)){
    splice(@utlFileDirList, $maxRows);
   }
   #my @dNameList ;
   for $dir (@utlFileDirList){  
       $dir = check_512char($dir); 
       print "em_result=$globalProperty|$dir\n" ; 
       #util_print($dir); 
       #@dNameList = util_print(@dNameList,$dir);
   }
 }
