# 
# $Header: suse_network-stage-directive.pl 09-aug-2006.00:13:53 ssdas Exp $
#
# network_stage.pl
# 
# Copyright (c) 2005, 2006, Oracle. All rights reserved.  
#
#    NAME
#      network_stage.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ssdas       07/27/06 - creating for suse 
#    adeb        05/25/06 - fix hostname change issue 
#    pshroff     08/05/05 - pshroff_stagepath_dirs
#    pshroff     06/30/05 - Creation
#
 

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

use strict;
use LWP::Simple;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";

#Staging directive for network profile component

main();

sub main()
{
    print "Creating Network Kickstart file\n";

    createAndAppendToKickstart();

    my $DeviceNameProperty = "NAME_NetworkConfig[0].NAME_DeviceName";

    my $deviceName = get_oraComponentProperty($DeviceNameProperty); 

    my $addrType = get_oraComponentProperty("NAME_NetworkConfig[0].NAME_AddrType");
       
#    my $networkprofile_entry;
        
    if($addrType=~/ADDR_Dynamic/)
    { 
 #           $networkprofile_entry="network --bootproto=dhcp --device=$deviceName\n";
	appendDynamicToKickstart($deviceName) ;
    }
    else
    {    
            my $hostName = get_oraComponentProperty("NAME_NetworkConfig[0].NAME_Hostname");
            my $domainName = get_oraComponentProperty("NAME_NetworkConfig[0].NAME_DomainName");
            my $ipAddr = get_oraComponentProperty("NAME_NetworkConfig[0].NAME_IPAddr");
            my $subnetMask = get_oraComponentProperty("NAME_NetworkConfig[0].NAME_SubnetMask");
            my $gateway = get_oraComponentProperty("NAME_NetworkConfig[0].NAME_Gateways");
            my $dnsserver = get_oraComponentProperty("NAME_NetworkConfig[0].NAME_DNSServers");
            #$networkprofile_entry="network --device $deviceName --bootproto static --ip $ipAddr --netmask $subnetMask --gateway $gateway --nameserver $dnsserver --hostname $hostName.$domainName\n";
	    appendStaticToKickstart($deviceName,$hostName,$domainName,$ipAddr,$subnetMask,$gateway,$dnsserver);
    }
    appendFinalToKickstart();
}

sub appendStaticToKickstart(){
        my($deviceName,$hostName,$domainName,$ipAddr,$subnetMask,$gateway,$dnsserver) = @_;
        open OUT,">>network-kickstart" or die "Cann't open network kickstart file";

        print OUT "<networking>\n";
        print OUT "<dns>\n";
        print OUT "<dhcp_hostname config:type=\"boolean\">false</dhcp_hostname>\n";
        print OUT "<dhcp_resolv config:type=\"boolean\">false</dhcp_resolv>\n";
        print OUT "<domain>$domainName</domain>\n";
        print OUT "<hostname>$hostName</hostname>\n";
        print OUT "<nameservers config:type=\"list\">\n";
        my $temp_var;
        chomp($dnsserver);
        my @m_nameserver_list = split(/,/,$dnsserver);
        foreach $temp_var (@m_nameserver_list){
                print OUT "<nameserver>$temp_var</nameserver>\n";
        }
        print OUT "</nameservers>\n";
        print OUT "<searchlist config:type=\"list\">\n<search>$domainName</search>\n</searchlist>\n";
        print OUT "</dns>\n";
        print OUT "<interfaces config:type=\"list\">\n";
        print OUT "<interface>\n";
        print OUT "<bootproto>static</bootproto>\n";
        print OUT "<device>$deviceName</device>\n";
        print OUT "<ipaddr>$ipAddr</ipaddr>\n";
        print OUT "<netmask>$subnetMask</netmask>\n";
        print OUT "<startmode>onboot</startmode>\n";
        print OUT "</interface>\n";
        print OUT "</interfaces>\n";
        print OUT "<routing>\n";
        print OUT "<ip_forward config:type=\"boolean\">false</ip_forward>\n";
        print OUT "<routes config:type=\"list\">\n";
        chomp($gateway);
        my @m_gateways_list = split(/,/,$gateway);
        my $m_gateways_list_len = @m_gateways_list;
        print OUT "<route>\n<destination>default</destination>\n<device>-</device>\n";
        print OUT "<gateway>@m_gateways_list[0]</gateway>\n<netmask>-</netmask>\n";
        print OUT "</route>\n";
	my $i;

        for ($i=1;$i<$m_gateways_list_len;$i++){
                print OUT "<route>\n";
                print OUT "<gateway>@m_gateways_list[$i]</gateway>\n";
                print OUT "</route>\n";
        }
        print OUT "</routes>\n";
        print OUT "</routing>\n";
        print OUT "</networking>\n";

        close OUT;


}
sub appendFinalToKickstart(){
        open OUT,">>network-kickstart" or die "Cann't open network kickstart file";
	print OUT "<runlevel>\n";
        print OUT "<default>3</default>\n";
        print OUT "<services config:type=\"list\">\n";
        print OUT "<service/>\n";
        print OUT "</services>\n";
        print OUT "</runlevel>\n";
        #print OUT "</configure>\n";
	close OUT;
}
sub appendDynamicToKickstart(){
	my ($m_deviceName) = @_;
        open OUT,">>network-kickstart" or die "Cann't open network kickstart file";
	print OUT "<networking>\n";
        print OUT "<dns>\n";
        print OUT "<dhcp_hostname config:type=\"boolean\">true</dhcp_hostname>\n";
        print OUT "<dhcp_resolv config:type=\"boolean\">true</dhcp_resolv>\n";
        print OUT "<domain>local</domain>\n";
        print OUT "<hostname>linux</hostname>\n";
        print OUT "</dns>\n";
        print OUT "<interfaces config:type=\"list\">\n";
        print OUT "<interface>\n";
        print OUT "<bootproto>dhcp</bootproto>\n";
        print OUT "<device>$m_deviceName</device>\n";
        print OUT "<startmode>onboot</startmode>\n";
        print OUT "</interface>\n";
        print OUT "</interfaces>\n";
        print OUT "<routing>\n";
        print OUT "<ip_forward config:type=\"boolean\">false</ip_forward>\n";
        print OUT "<routes config:type=\"list\"/>\n";
        print OUT "</routing>\n";
        print OUT "</networking>\n";

	close OUT;
}

sub createAndAppendToKickstart()
{
    my $ksfilename="network-kickstart";
    
    open OUT, ">$ksfilename" or die "Can find kickstart file $!" ;

   # print OUT "<configure>\n";
   # print OUT "<start_autofs config:type=\"boolean\">false</start_autofs>\n"; 
    
    close OUT;
}


