#!/usr/local/bin/perl
# 
# $Header: suseos-stage-directive.pl 09-aug-2007.00:57:30 rattipal Exp $
#
# linuxos-stage-directive.pl
# 
# Copyright (c) 2005, 2007, Oracle. All rights reserved.  
#
#    NAME
#      linuxos-stage-directive.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#     Staging directive for linux os component
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    gaurgupt    07/25/07 - fixing the bug# 5662267
#    gaurgupt    07/25/07 - fixing the bug# 6275723
#    rattipal    07/29/07 - 
#    gaurgupt    11/18/06 - modifying default disk partition
#    gaurgupt    09/14/06 - coping the rpm repository
#    sacgoel     09/07/06 - adding http support
#    gaurgupt    08/28/06 - 
#    ssdas       08/04/06 - adding the network component for the default image
#    ssdas       07/19/06 - testing
#    pshroff     11/30/05 - to support NAS mount commands for solaris as well as to use 
#                           one mount instead of three mounts in post section
#    pshroff     07/28/05 - adding oms.properties file in post section 
#    pshroff     07/24/05 - removed partitioning info
#    pshroff     07/21/05 - removing xconfig 
#    rbhanush    06/23/05 - removing isencrypted option 
#    rbhanush    06/10/05 - Adding more entries in kickstart
#    rbhanush    05/30/05 - Extracting rhelos.tar
#    rbhanush    05/24/05 - rbhanush_update_props
#    rbhanush    05/19/05 - Creation
# 

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";
use LWP::Simple;
use strict;

my $BOOT_SERVER_PATH_PROP = "NAME_BootServerPath";

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";

main();

sub main()
{
    print "Creating kickstart file\n";
    createAndAppendToKickstart();
    print "Extracting rhelos.tar\n";
    my $stageTopDir=get_oraProperty("NAME_StageSharedMountPoint");

# Finding the name of OS component
    my $os_comp_path=`pwd`;
    chomp $os_comp_path;
    my $parent_path="..";
    chdir $parent_path;

    my $image_hw_path=`pwd`;
    chomp $image_hw_path;
    chdir $os_comp_path;

    my $os_toplevel_path=$stageTopDir."/OS";
    my $temp_image_hw_path=$image_hw_path."/";
    my $os_comp_guid=$os_comp_path;

    $os_comp_guid=~ s/$temp_image_hw_path//;   # This is the OS component name (OS compguid)
 #  my $dest_os_path=$os_toplevel_path."/".$os_comp_guid;       # Destination OS component directory <stage_top_dir>/OS/compguid
    if(!( -d $os_comp_guid))
    {
        system("mkdir -p -m 755 $os_comp_guid");
        print "Extracting rhelos.tar\n";
        my $tar_extract_cmd="tar -xvf rhelos.tar -C $os_comp_guid";             # untaring to a local folder which then moved to actual place
        system($tar_extract_cmd);
        my $exitstatus = $? >> 8;
        if ($exitstatus != 0)
        {
            print "\n Failed while untaring the OS Image Binary \n";
            exit $exitstatus;
        }
    }
    system("rm -f rhelos.tar");

   #creatingsusedirectory();
    my $m_bootServerPath=get_oraProperty($BOOT_SERVER_PATH_PROP);
    copyDefaultFile($os_toplevel_path,$os_comp_guid."/SuseOSRoot/");

    my $repository_url_File = $os_comp_guid."/SuseOSRoot/repository_url";
    open IN_URL, "$repository_url_File" or die " cann't open the $repository_url_File $!";
    my $url_path = <IN_URL>;
    my @url_path_arr = split /\/+/ ,$url_path;
    my $SuseRepositoryName;
    my $url_path_arr_len = $#url_path_arr;
    for(my $i=1;$i <= $url_path_arr_len;$i++){
        $SuseRepositoryName = $SuseRepositoryName."$url_path_arr[$i]/";
    }

    system("cp $os_toplevel_path/$SuseRepositoryName/boot/loader/initrd ../");

    #timezone
    my $osTimeZone = get_oraComponentProperty("NAME_TimeZone");
    AppendClockToKickstart($osTimeZone);
    appendDefault("$os_comp_guid/SuseOSRoot");

    #my $dummy_passwd="rootpw --iscrypted $1$UOG2nAQn$J745.WTWWcluPTszuUgBy/";
    my $passwd= get_oraComponentProperty("NAME_RootPassword");
    my $passwd_encrypt= get_oraComponentProperty("NAME_RootPasswordEncrypt");
    appendPasswdToKickstart($passwd,$passwd_encrypt);


    #Get Base URl and always relplace Stage Dir with BaseURl entry
    my $stageTopDir=get_oraProperty("NAME_StageSharedMountPoint");
    my $base_url = get_oraProperty("NAME_StageBaseUrl");
    print "\n Base URL is:$base_url\n";
    my (@url_info, $len, $count, $url_entry, $dir, $nfs_host_name, $nfs_host_dir);
    $nfs_host_dir="";
    @url_info = split /\/+/ ,$base_url ;
    $len = $#url_info;
    for($count=1;$count<=$len;$count++)
    {
        $url_entry=$url_info[$count];
        if($count ==1)
        {
            $nfs_host_name = $url_info[$count];
        }
        if($count >1)
        {
            $nfs_host_dir = $nfs_host_dir."/".$url_info[$count];
        }
    }
    my $rel_os_path="OS/".$SuseRepositoryName;
    print "\n Host is:$nfs_host_name and Directory is :$nfs_host_dir\n";
    createNFSEntry($base_url,$nfs_host_name, $nfs_host_dir, $rel_os_path );


    #Creating post section script
    my $rel_image_hw_path=$image_hw_path;
    $rel_image_hw_path=~ s/$stageTopDir//;
    createPostSectionFile($base_url,$nfs_host_name, $nfs_host_dir, $stageTopDir, $rel_image_hw_path);


    #creating networking kickstart here for testing purposes
    createNetworkKickstart();

}


sub copyDefaultFile(){
        my ($repos_toplevel_path,$repository_url_File) = @_;
        my $temp_repositry_url = $repository_url_File;
        $repository_url_File = $repository_url_File."/repository_url";
        open IN, "$repository_url_File" or die " cann't open $repository_url_File $!";
        my $repository_url;
        if($repository_url = <IN>){
                my @url_path_arr = split /\/+/ ,$repository_url;
                my $SuseRepositoryName;
                my $url_path_arr_len = $#url_path_arr;
                for(my $i=1;$i <= $url_path_arr_len;$i++){
                        $SuseRepositoryName = $SuseRepositoryName."$url_path_arr[$i]/";
                }
                $repos_toplevel_path = $repos_toplevel_path."/".$SuseRepositoryName;

                system("cp $temp_repositry_url/default.sel $repos_toplevel_path/sles10/suse/setup/descr");

        }
        close IN;
}

sub createNFSEntry()
{
    my ($base_url,$mount_nfs_host_name,$mount_nfs_host_dir,$rel_os_path) = @_;

    my $LinuxOSRootFolderName="SuseOSRoot";

    #Get the ip address
    #my $ipaddress_cmd="hostname --ip-address";
    #my $stageserver_ip=`$ipaddress_cmd`;
    #chomp $stageserver_ip ;

    #Get the current folder
    my $linuxos_path=$rel_os_path;

    my $OS_PATH = "../OS_PATH";
    if($base_url=~ /^file:/ || $base_url=~ /^FILE:/)
    {
        #Create a new nfs entry
        my $imagePath=$mount_nfs_host_dir."/".$linuxos_path;
        my $nfs_entry="nfs://$mount_nfs_host_name:$imagePath/";
	
	open OSPATH,">$OS_PATH" or die " could not write the path for the OS $!";
	print OSPATH $nfs_entry;
	close OSPATH;
    }
    else
    {
        my $completeurl=$base_url."/".$linuxos_path;
	open OSPATH,">$OS_PATH" or die " could not write the path for the OS $!";
	print OSPATH $completeurl;
	close OSPATH;
    }
}




sub createNetworkKickstart(){
	open OUT,">network-kickstart" or die "Cann't open network kickstart file";
	
 	print OUT "<networking>\n";
 	print OUT "<dns>\n";
 	print OUT "<dhcp_hostname config:type=\"boolean\">true</dhcp_hostname>\n";
 	print OUT "<dhcp_resolv config:type=\"boolean\">true</dhcp_resolv>\n";
 	print OUT "<domain>local</domain>\n";
 	print OUT "<hostname>linux</hostname>\n";
 	print OUT "</dns>\n";
 	print OUT "<interfaces config:type=\"list\">\n";
 	print OUT "<interface>\n";
 	print OUT "<bootproto>dhcp</bootproto>\n";
 	print OUT "<device>eth0</device>\n";
 	print OUT "<startmode>onboot</startmode>\n";
 	print OUT "</interface>\n";
 	print OUT "</interfaces>\n";
 	print OUT "<routing>\n";
 	print OUT "<ip_forward config:type=\"boolean\">false</ip_forward>\n";
 	print OUT "<routes config:type=\"list\"/>\n";
 	print OUT "</routing>\n";
 	print OUT "</networking>\n";
 	print OUT "<runlevel>\n";
 	print OUT "<default>3</default>\n";
 	print OUT "<services config:type=\"list\">\n";
 	print OUT "<service/>\n";
 	print OUT "</services>\n";
 	print OUT "</runlevel>\n";

	close OUT;
}


sub AppendClockToKickstart()
{
    my $clockEntry = @_[0];
    my $ksfilename="suseos-kickstart";
    
    open OUT, ">>$ksfilename" or die "Can find kickstart file" ;
    
    print OUT "<general>\n";

    print OUT "<clock>\n";
    print OUT "<hwclock>localtime</hwclock>\n";
    print OUT "<timezone>".$clockEntry."</timezone>\n";
    print OUT "</clock>\n";

    print OUT "<keyboard>\n";
    print OUT "<keymap>english-us</keymap>\n";
    print OUT "</keyboard>\n";
    print OUT "<language>en_US</language>\n";

    print OUT "<mode>\n";
    print OUT "<confirm config:type=\"boolean\">false</confirm>\n";
    print OUT "<forceboot config:type=\"boolean\">false</forceboot>\n";
    print OUT "</mode>\n";

    print OUT "<mouse>\n";
    print OUT "<id>none</id>\n";
    print OUT "</mouse>\n";

    print OUT "</general>\n";
    
    close OUT;
}
sub appendDefault(){
    my ($rpm_list) = @_;
    $rpm_list= $rpm_list."/rpms_list";

    my $ksfilename="suseos-kickstart";

    open OUT, ">>$ksfilename" or die "Can find kickstart file" ;

    print OUT "<partitioning config:type=\"list\">\n";
    print OUT "<drive>\n";
    print OUT  "<device>/dev/hda</device>\n";
    print OUT "<initialize config:type=\"boolean\">true</initialize>\n";	
    print OUT "<use>all</use>\n";
    print OUT "</drive>\n";
    print OUT "<drive>\n";
    print OUT  "<device>/dev/sda</device>\n";
    print OUT "<initialize config:type=\"boolean\">true</initialize>\n";	
    print OUT "<use>all</use>\n";
    print OUT "</drive>\n";
    print OUT "</partitioning>\n";

    print OUT "<software>\n";
    print OUT "<base>default</base>\n";
    open IN, "$rpm_list" or die "Cann't open the $rpm_list $!";
    print OUT "<packages  config:type=\"list\">\n";
    my $rpm_name;
    while($rpm_name = <IN>){
        chomp($rpm_name);
        print OUT "<package>$rpm_name</package>\n";
    }
    close IN;
    print OUT "</packages>\n";
    print OUT "</software>\n";

    print OUT "<security>\n";
    print OUT "<encryption>md5</encryption>\n";
    print OUT "</security>\n";

    close OUT;

}

sub createAndAppendToKickstart(){
    my $ksfilename="suseos-kickstart";

    open OUT, ">$ksfilename" or die "Can find kickstart file" ;
    close OUT;
}

sub appendPasswdToKickstart(){
    my($passwd,$passwd_encrypt)=@_;
    my $ksfilename="suseos-kickstart";

    open OUT, ">>$ksfilename" or die "Can find kickstart file" ;    
    
    print OUT "<users config:type=\"list\">\n";
    print OUT "<user>\n";
    print OUT "<username>root</username>\n";
    print OUT "<user_password>".$passwd."</user_password>\n";
    print OUT "<encrypted config:type=\"boolean\">".$passwd_encrypt."</encrypted>\n";
    print OUT "</user>\n";
    print OUT "</users>\n";
}



sub createPostSectionFile()
{
    my ($base_url,$nfs_host_name, $nfs_host_dir,$stage_top_dir, $rel_image_hw_path) = @_;
      
    #Create post-ks.cfg
    my $post_file="post-ks.cfg";
    open OUT, ">$post_file" or die "Can not create post section file : $!" ;

    #Add the post header
    print OUT "<scripts>\n";
    print OUT "<init-scripts config:type=\"list\">\n";
    print OUT "<script>\n";
    print OUT "<interpreter>shell</interpreter>\n";
    print OUT "<source><![CDATA[\n";
    print OUT "#!/bin/sh\n";
    #rpm --import /usr/share/rhn/RPM-GPG-KEY
    my $rpm_gpg_key="rpm --import /usr/share/rhn/RPM-GPG-KEY";
    print OUT "$rpm_gpg_key\n";
    my $baremetalprov_folder="/baremetalprov"; 	
    my $mount_dir_path = "";
    my $current_folder = `pwd`;
    chomp $current_folder;
    my $complete4RpmPath = $current_folder."/../../emagent-10.2.0.0.0-4.i386.rpm";
    my $complete3RpmPath = $current_folder."/../../emagent-10.2.0.0.0-3.i386.rpm";
    my $emagent_rpm_name="emagent-10.2.0.0.0-4.i386.rpm";
    if ( -e $complete4RpmPath)
    {
        $emagent_rpm_name="emagent-10.2.0.0.0-4.i386.rpm";
    }
    elsif(-e $complete3RpmPath)
    {
        $emagent_rpm_name="emagent-10.2.0.0.0-3.i386.rpm";
    }
		
		
	if($base_url=~ /^file:/  || $base_url=~ /^FILE:/)
	    {
		my $emagent_extra_folder="/emagent-extra";
		#mkdir /emagent-extra
		my $create_folder="mkdir $emagent_extra_folder";
		print OUT "$create_folder\n";
		
		$mount_dir_path= $nfs_host_name.":".$nfs_host_dir; 
	    	#my $mount_dir_path= (substr($base_url, (index($base_url,":")+1)));
	    	my $mount_entry="mount ".$mount_dir_path." ".$emagent_extra_folder;
	    	print OUT "$mount_entry\n";

		#rpm -ivh emagent-10.2.0.0.0-1.i386.rpm 
	    	my ($rpm_install,$stage_base_url, $emagent_rpm_entry);
	    	$rpm_install="rpm -ivh ";
		$stage_base_url=$emagent_extra_folder."/";
	    	$emagent_rpm_entry=$rpm_install.$stage_base_url.$emagent_rpm_name;

	    	print OUT "mkdir -p -m 777 $baremetalprov_folder\n";		
		my $image_hw_path = $current_folder;
		$image_hw_path =~ s/$stage_top_dir/$emagent_extra_folder/; 		

	    	my $cp_oms_prop="cp -f $image_hw_path/../oms.properties $baremetalprov_folder";
		print OUT "$cp_oms_prop\n";
		my $cp_agent_prop="cp -f $image_hw_path/../agent.properties $baremetalprov_folder";
		print OUT "$cp_agent_prop\n";
		my $cp_install_prop="cp -f $image_hw_path/../installuser.properties $baremetalprov_folder";
		print OUT "$cp_install_prop\n";

		print OUT "$emagent_rpm_entry\n"; 

		
   
		my $umount="umount ".$emagent_extra_folder;
		print OUT "$umount\n"; 

		#rm -rf /emagent-extra
		my $rm_emagent_extra="rm -rf ".$emagent_extra_folder;
		print OUT "$rm_emagent_extra\n";
	
		} 
	
	else
	{
		my $complete_url_agentrpm=$base_url."/".$emagent_rpm_name;
	    	print OUT "mkdir -p -m 777 $baremetalprov_folder\n";
		my $image_hw_url=$base_url.$rel_image_hw_path;
	    	my $cp_oms_prop="wget $image_hw_url/oms.properties -O $baremetalprov_folder/oms.properties";
	    	print OUT "$cp_oms_prop\n";
		my $cp_agent_prop="wget $image_hw_url/agent.properties -O $baremetalprov_folder/agent.properties";
		print OUT "$cp_agent_prop\n";
		my $cp_install_prop="wget $image_hw_url/installuser.properties -O $baremetalprov_folder/installuser.properties";
		print OUT "$cp_install_prop\n";
		print OUT "wget $complete_url_agentrpm -O $baremetalprov_folder/$emagent_rpm_name\n";
		my $rpm_install_command="rpm -ivh $baremetalprov_folder/$emagent_rpm_name";
		print OUT "$rpm_install_command\n";
		print OUT "rm -rf $baremetalprov_folder/$emagent_rpm_name\n";


	}
    
	print OUT "]]>\n";
	print OUT "</source>\n";
	print OUT "</script>\n";
	print OUT "</init-scripts>\n";
	print OUT "</scripts>\n";
    close OUT;
}   
