Rem
Rem $Header: sdo/admin/catsem.sql /main/2 2009/05/21 14:57:52 matperry Exp $
Rem
Rem catsem.sql
Rem
Rem Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
Rem
Rem    NAME
Rem      catsem.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ayalaman    05/15/09 - include secure access and semantic index
Rem                           components
Rem    matperry    02/11/09 - Created
Rem

----------------------------------------------------------------------------
-- Creates SEM types and then calls semrelod to load PL/SQL packages and  --
-- sodrdf.jar                                                             --
----------------------------------------------------------------------------

set echo off;
WHENEVER SQLERROR CONTINUE;

COLUMN :script_name1 NEW_VALUE comp_file1 NOPRINT
VARIABLE script_name1 VARCHAR2(50)

COLUMN :script_name2 NEW_VALUE comp_file2 NOPRINT
VARIABLE script_name2 VARCHAR2(50)

-- first we need to make sure that semantic component has not been installed --
-- if so, we need to raise an error an do nothing --
declare
  sem_exists NUMBER;

begin

  -- determine if the semantic component has been installed --

  -- see if SDO_RDF_TRIPLE_S type is present in DB
  SELECT count(*) INTO sem_exists FROM ALL_TYPE_ATTRS
  WHERE type_name='SDO_RDF_TRIPLE_S' AND owner='MDSYS';

  -- if semantic component is installed then raise an error --
  if (sem_exists > 0) then

    raise_application_error(-20000, 
      'Not installing semantic component. Semantic component is already installed.');

  end if;

end;
/
show errors;


-- recheck for semantic component and get the approprate scripts
-- this second PL/SQL block is needed because we lose the script names
-- after raise_application_error, so we can't raise an error and set
-- the scripts to nothing script in the same block
declare
  sem_exists NUMBER;
begin

  -- determine if the semantic component has been installed --

  -- see if SDO_RDF_TRIPLE_S type is present in DB
  SELECT count(*) INTO sem_exists FROM ALL_TYPE_ATTRS
  WHERE type_name='SDO_RDF_TRIPLE_S' AND owner='MDSYS';

  -- semantic component is installed so get nothing scripts --
  if (sem_exists > 0) then

    :script_name1 := dbms_registry.nothing_script;
    :script_name2 := dbms_registry.nothing_script;

  -- semantic component is not installed so get installation scripts --
  else

    :script_name1 := '@sdordfty.sql';
    :script_name2 := '@semrelod.sql';

  end if;
end; 
/

show errors;

alter session set current_schema=MDSYS;

set define on; 
SELECT :script_name1 FROM DUAL;
@&comp_file1

SELECT :script_name2 FROM DUAL;
@&comp_file2

alter session set current_schema=SYS;
