set echo off
Rem
Rem $Header: sdo/admin/catsem10i.sql /main/15 2009/05/21 14:57:53 matperry Exp $
Rem
Rem catsem10i.sql
Rem
Rem Copyright (c) 2006, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catsem10i.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    matperry    05/13/09 - add back removal of 10.2
Rem    sdas        06/23/07 - set echo off: avoid header and mod hist in log
Rem    alwu        06/25/07 - remove sdo_drop_user_before trigger from 102
Rem    sdas        06/16/07 - move save and restore functionality 
Rem                           from catsem10i to the upgrade package
Rem    sdas        06/15/07 - change CREATE CONTEXT to CREATE or REPLACE
Rem    sdas        06/14/07 - upgrade: rulebase and rulesIndex handling
Rem    sdas        06/10/07 - fix CLOB handling during upgrade
Rem    sdas        05/16/07 - put conditonal code to allow simulation testing
Rem    sdas        05/13/07 - data migration from 10.2
Rem    alwu        02/23/07 - change order
Rem    sdas        01/23/07 - drop VALUE_CACHE package
Rem    alwu        11/02/06 - add more triggers
Rem    mannamal    08/28/06 - Add sem indextype stat script
Rem    alwu        08/24/06 - add inf ms related
Rem    alwu        06/14/06 - change order for dependency 
Rem    mannamal    06/11/06 - Add SEM operator scripts 
Rem    alwu        06/05/06 - start
Rem    alwu        06/05/06 - start
Rem    alwu        06/05/06 - Created
Rem

set echo off
WHENEVER SQLERROR EXIT FAILURE;

prompt check privileges
Rem check user
begin
  if ('SYS' = sys_context('userenv', 'current_user') and 
      'TRUE' = sys_context('userenv', 'isdba')) then
    null; -- ok to go ahead
  else
    raise_application_error(-20000, 
    'Cannot proceed. Only SYS with DBA privilege can perform this operation.');
  end if;

  begin
    -- In upgrade code path, this trigger from 102 is not needed.
    execute immediate 'drop trigger mdsys.sdo_drop_user_before';
  exception when others then 
    null; 
  end;
end;
/

-- load the upgrade package
set echo off
@@sdosemdmh.sql
@@sdosemdmb.plb
set echo on
describe sem_upgrade_to_11;
set echo off

-- save the RDF Network from 10.2 in a way that can be restored in 11
-- Saved info: RDF models (triples + non-RDF cols), rulebases, rules index defs
prompt save 10.2 RDF data ...
exec sem_upgrade_to_11.save_10_2_RDF_network_for_11;
prompt save 10.2 RDF data ... DONE

-- Uninstall 10.2 RDF => DONE INSIDE catsem11i.sql anyway
prompt uninstall RDF ...
@@semremov.sql

-- Install 11 SEM
set echo off
@@catsem11i.sql

set echo off
-- this load is needed because upgrade package calls procs from the ..._UTL pkg
@@sdosemdgu.plb
set echo on
describe SDO_SEM_DOWNGRADE_UTL;

set echo off
-- also load upgrade package, just in case ...
@@sdosemdmh.sql
@@sdosemdmb.plb
set echo on
describe sem_upgrade_to_11;
set echo off

-- Restore the RDF network from 10.2 in 11
prompt restore 10.2 RDF data in 11 ...
exec sem_upgrade_to_11.restore_10_2_RDF_network_in_11;
prompt restore 10.2 RDF data in 11 ... DONE

set echo on
