ALTER SESSION SET current_schema=SYS;
DECLARE
  platform NUMBER;
  ORCL_HOME_DIR VARCHAR2(128);  
BEGIN
  SELECT platform_id INTO platform FROM v$database;

  IF(platform=15) THEN 
    EXECUTE IMMEDIATE 'CREATE OR REPLACE LIBRARY 
      MDSYS.SDO_GEOR_LIZARDTECH_LIB AS 
      ''ORA_ROOT:[MD.DLL]' || '/liblt_dbmrsid_oci.so''';

  ELSIF(platform=16) THEN 
    DBMS_SYSTEM.GET_ENV('ORACLE_HOME', ORCL_HOME_DIR);
    EXECUTE IMMEDIATE 'CREATE OR REPLACE LIBRARY 
      MDSYS.SDO_GEOR_LIZARDTECH_LIB AS 
      ''' || ORCL_HOME_DIR || '/md/dll/lt_dbmrsid_oci.dylib''';

  ELSIF(platform=7 OR platform=8 OR platform=12) THEN 
    DBMS_SYSTEM.GET_ENV('ORACLE_HOME', ORCL_HOME_DIR);
    EXECUTE IMMEDIATE 'CREATE OR REPLACE LIBRARY 
      MDSYS.SDO_GEOR_LIZARDTECH_LIB AS 
      ''' || ORCL_HOME_DIR || '\md\dll\lt_dbmrsid_oci.dll''';

  ELSIF(platform=3 OR platform=4 OR platform=5) THEN 
    DBMS_SYSTEM.GET_ENV('ORACLE_HOME', ORCL_HOME_DIR);
    EXECUTE IMMEDIATE 'CREATE OR REPLACE LIBRARY 
      MDSYS.SDO_GEOR_LIZARDTECH_LIB AS 
      ''' || ORCL_HOME_DIR || '/md/dll/liblt_dbmrsid_oci.sl''';

  ELSE 
    DBMS_SYSTEM.GET_ENV('ORACLE_HOME', ORCL_HOME_DIR);
    EXECUTE IMMEDIATE 'CREATE OR REPLACE LIBRARY 
      MDSYS.SDO_GEOR_LIZARDTECH_LIB AS 
      ''' || ORCL_HOME_DIR || '/md/dll/liblt_dbmrsid_oci.so''';
  END IF;
END;
/
show errors;
ALTER SESSION SET current_schema=MDSYS;
BEGIN
  BEGIN
    EXECUTE IMMEDIATE 'REVOKE EXECUTE ON sdo_geor_lizardtech FROM PUBLIC';
    EXCEPTION WHEN OTHERS THEN NULL;
  END;
END;
/
CREATE OR REPLACE PACKAGE sdo_geor_lizardtech wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
1a55 487
jQJQaL/pEfWPlYqZsY09YHlxJZ0wg81ULq6GfC9Vxz8Clb0U0V2X+i0u4Pfb982g3WOXJefI
njV5KwpVD53cg88x3Gk60+AFXtqCZEFfmjRY3zd905I2fqeVBtGWPG09app+7VZOBRKmXohp
dGmXrfRDZpRGHRZuAIcf3l8UAX9n+18QwK8wNmzg+g3HiqaO84h8zzkRdMnICi+5QXupC951
fd/F3O/QuAFnFHR/oZF8S8DfxiHT0kB01pMRghJ81N/a/uZA0dXHtVkOvBdH7pOkyw7uWQwS
+NviMzDjhFwUABfU6eHzfwqG7D1SgEFwEYDvnyDb4pssq2YwjXHHBMx28Yi91SwMQ/+7bqbc
kZeYaKaUysP+QSs2hMtpZARgNnY78vVPAFVDH5WSf9XMCOTBTTNAd4bIDx03MRVJX5bmIx09
traOTcSHpIKw/DzzbWy+8Q2oN8XvZr0fxoEXUDCuE9CycgRR5sCr+EAH1HVmFoggeiq98M6k
KoFURXO5YVmQPePN4/amkm48rn3jeUHrSe0/o8bPTlM/6hFTP/YE3TiafVgzo2uE4W2xWZ/T
GOgOQZQnUquFRemyheJSgTYTuaSG9/avfroF2D/rm4vwKhAgQSWxNrdk4o1k4o1k4o1kuXcQ
g8odVQTt3JnTLqjtPhp4AthE2Z8Tp1RM2XR1Pp8jeWEneOAkrb8zPw2GCRpBypt8FCS4WvzW
2DLnvb7DXGXw/DQ3f8p3KF3dIbBUCr9cNWtJToFboM6Bx7ecBy3PBNmaUlaqd1Pk2FIkAL7o
xisKIDnisM/fWWyqn0crBCpH3KSyogrso+Qre/ClYMxi7cpHUSonElQLGXnw+5Zk1XXKb2xu
5zdrRu0NlW7Zi1T5ZV5Y5QjbhOEXGK7WcFaRgqE9DUIS18xumm/Qch7PA6+TWNcsQaeVu651
5YzgET3mCo6jjVDFRlsQIwoisk0Xn/nIdasrLQP+MwD4mJoGggQJPWhdO7L5ayTytDSNXM3q
vZmAej2/MXE8TJKUEtJWugBWA2VkRbX4/nPEmoz4dANWJYTh7CncNypKo8Bhazu5lsJsoAbu
tjF5AyAJ0Bm82OhStr7qgJJC9BhcLRl6F8Q6qlDxZHOACEOZSX9hjYrkxiTcxIJH

/
show errors;
GRANT EXECUTE ON mdsys.sdo_geor_lizardtech TO PUBLIC;
