delete from mdsys.OpenLS_Namespaces;
INSERT INTO mdsys.OpenLS_Namespaces(
  shortcut,
  version,
  uri)
VALUES (
  'xls',
  '1.0',
  'http://www.opengis.net/xls');
INSERT INTO mdsys.OpenLS_Namespaces(
  shortcut,
  version,
  uri)
VALUES (
  'gml',
  '1.0',
  'http://www.opengis.net/gml');
INSERT INTO mdsys.OpenLS_Namespaces(
  shortcut,
  version,
  uri) (
    SELECT
      shortcut,
      '1.1',
      uri
    FROM
      mdsys.OpenLS_Namespaces
    WHERE
      version = '1.0');
delete from mdsys.OpenLS_Classifications;
INSERT INTO mdsys.OpenLS_Classifications (
  criterion,
  classification,
  version,
  characteristic_XPath)
VALUES (
  'address format',
  'by street address',
  '1.0',
  '/xls:Address/xls:StreetAddress');
INSERT INTO mdsys.OpenLS_Classifications (
  criterion,
  classification,
  version,
  characteristic_XPath)
VALUES (
  'address format',
  'by street intersection',
  '1.0',
  '/xls:Address/xls:StreetIntersection');
INSERT INTO mdsys.OpenLS_Classifications (
  criterion,
  classification,
  version,
  characteristic_XPath)
VALUES (
  'location type',
  'street address',
  '1.0',
  '/*/xls:Address/xls:StreetAddress');
INSERT INTO mdsys.OpenLS_Classifications (
  criterion,
  classification,
  version,
  characteristic_XPath)
VALUES (
  'location type',
  'street intersection address',
  '1.0',
  '/*/xls:Address/xls:StreetIntersection');
INSERT INTO mdsys.OpenLS_Classifications (
  criterion,
  classification,
  version,
  characteristic_XPath)
VALUES (
  'location type',
  'position point',
  '1.0',
  '/*/xls:Position/gml:Point');
INSERT INTO mdsys.OpenLS_Classifications (
  criterion,
  classification,
  version,
  characteristic_XPath)
VALUES (
  'location type',
  'POI point',
  '1.0',
  '/*/xls:POI/gml:Point');
INSERT INTO mdsys.OpenLS_Classifications (
  criterion,
  classification,
  version,
  characteristic_XPath)
VALUES (
  'location type',
  'POI street address',
  '1.0',
  '/*/xls:POI/xls:Address/xls:StreetAddress');
INSERT INTO mdsys.OpenLS_Classifications (
  criterion,
  classification,
  version,
  characteristic_XPath)
VALUES (
  'location type',
  'POI street intersection address',
  '1.0',
  '/*/xls:POI/xls:Address/xls:StreetIntersection');
INSERT INTO mdsys.OpenLS_Classifications (
  criterion,
  classification,
  version,
  characteristic_XPath)
VALUES (
  'map bounding box definition',
  'by bounding box',
  '1.0',
  '/*/xls:BBoxContext');
INSERT INTO mdsys.OpenLS_Classifications (
  criterion,
  classification,
  version,
  characteristic_XPath)
VALUES (
  'map bounding box definition',
  'by center and radius',
  '1.0',
  '/*/xls:CenterContext/xls:Radius');
INSERT INTO mdsys.OpenLS_Classifications (
  criterion,
  classification,
  version,
  characteristic_XPath)
VALUES (
  'map bounding box definition',
  'by center and scale',
  '1.0',
  '/*/xls:CenterContext/xls:DisplayScale');
INSERT INTO mdsys.OpenLS_Classifications (
  criterion,
  classification,
  version,
  characteristic_XPath) (
    SELECT
      criterion,
      classification,
      '1.1',
      characteristic_XPath
    FROM
      mdsys.OpenLS_Classifications
    WHERE
      version = '1.0');
delete from mdsys.OpenLS_Nodes;
INSERT INTO mdsys.OpenLS_Nodes (
  name,
  version,
  OpenLS)
VALUES (
  'map response',
  '1.0',
  XMLTYPE('<xls:XLS xmlns:xls="http://www.opengis.net/xls" xmlns:gml="http://www.opengis.net/gml" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.opengis.net/xls C:\WebServicesProject\OPENLS~2\PresentationService.xsd" version="1.1">
  <xls:ResponseHeader/>
  <xls:Response numberOfResponses="1" requestID="place holder" version="place holder">
    <xls:PortrayMapResponse>
      <xls:Map>
        <xls:Content format="place holder" height="place holder" width="place holder">
          <xls:URL>place holder</xls:URL>
        </xls:Content>
        <xls:BBoxContext srsName="4326">
          <gml:pos>place holder</gml:pos>
          <gml:pos>place holder</gml:pos>
        </xls:BBoxContext>
      </xls:Map>
    </xls:PortrayMapResponse>
  </xls:Response>
</xls:XLS>'));
INSERT INTO mdsys.OpenLS_Nodes (
  name,
  version,
  OpenLS)
VALUES (
  'route response',
  '1.0',
  XMLTYPE('<xls:XLS xmlns:xls="http://www.opengis.net/xls" xmlns:gml="http://www.opengis.net/gml" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.opengis.net/xls C:\WebServicesProject\OPENLS~2\PresentationService.xsd" version="1.1">
  <xls:ResponseHeader/>
  <xls:Response numberOfResponses="1" requestID="place holder" version="place holder">
		<xls:DetermineRouteResponse>
			<xls:RouteSummary>
				<xls:TotalTime>place holder</xls:TotalTime>
				<xls:TotalDistance uom="place holder" value="place holder"/>
				<xls:BoundingBox srsName="4326">
					<gml:pos dimension="2" srsName="4326">place holder</gml:pos>
					<gml:pos dimension="2" srsName="4326">place holder</gml:pos>
				</xls:BoundingBox>
			</xls:RouteSummary>
			<xls:RouteGeometry>
				<gml:LineString srsName="4326">
					<gml:pos dimension="2" srsName="4326">place holder</gml:pos>
				</gml:LineString>
			</xls:RouteGeometry>
			<xls:RouteInstructionsList xls:lang="US">
				<xls:RouteInstruction duration="place holder">
					<xls:Instruction>place holder</xls:Instruction>
					<xls:distance uom="place holder" value="place holder"/>
				</xls:RouteInstruction>
				<xls:RouteInstruction duration="place holder">
					<xls:Instruction>place holder</xls:Instruction>
					<xls:distance uom="place holder" value="place holder"/>
				</xls:RouteInstruction>
				<xls:RouteInstruction duration="place holder">
					<xls:Instruction>place holder</xls:Instruction>
					<xls:distance uom="place holder" value="place holder"/>
				</xls:RouteInstruction>
				<xls:RouteInstruction duration="place holder">
					<xls:Instruction>place holder</xls:Instruction>
					<xls:distance uom="place holder" value="place holder"/>
				</xls:RouteInstruction>
				<xls:RouteInstruction duration="place holder">
					<xls:Instruction>place holder</xls:Instruction>
					<xls:distance uom="place holder" value="place holder"/>
				</xls:RouteInstruction>
				<xls:RouteInstruction duration="place holder">
					<xls:Instruction>place holder</xls:Instruction>
					<xls:distance uom="place holder" value="place holder"/>
				</xls:RouteInstruction>
			</xls:RouteInstructionsList>
			<xls:RouteMap>
				<xls:Content format="place holder" height="place holder" width="place holder">
					<xls:URL>place holder</xls:URL>
				</xls:Content>
				<xls:BBoxContext srsName="4326">
					<gml:pos>place holder</gml:pos>
					<gml:pos>place holder</gml:pos>
				</xls:BBoxContext>
			</xls:RouteMap>
		</xls:DetermineRouteResponse>
	</xls:Response>
</xls:XLS>'));
INSERT INTO mdsys.OpenLS_Nodes (
  name,
  version,
  OpenLS)
VALUES (
  'geocode request',
  '1.0',
  XMLTYPE('<xls:XLS xmlns:xls="http://www.opengis.net/xls" xmlns:gml="http://www.opengis.net/gml" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.opengis.net/xls C:\\WebServicesProject\\OPENLS~1\\03-006r3\\schema\\LocationUtilityService.xsd" version="1.0">
	<xls:RequestHeader clientName="someName" clientPassword="somePwd"/>
	<xls:Request maximumResponses="10" methodName="GeocodeRequest" requestID="123" version="1.0">
		<xls:GeocodeRequest>
			<xls:Address countryCode="US">
				<xls:StreetAddress>
					<xls:Building number="400"/>
					<xls:Street>Post Street</xls:Street>
				</xls:StreetAddress>
				<xls:Place type="CountrySubdivision">CA</xls:Place>
				<xls:Place type="Municipality">San Francisco</xls:Place>
				<xls:PostalCode>94102</xls:PostalCode>
			</xls:Address>
		</xls:GeocodeRequest>
	</xls:Request>
</xls:XLS>'));
INSERT INTO mdsys.OpenLS_Nodes (
  name,
  version,
  OpenLS)
VALUES (
  'geocode response',
  '1.0',
  XMLTYPE('<xls:XLS xmlns:xls="http://www.opengis.net/xls" xmlns:gml="http://www.opengis.net/gml" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">
  <xls:ResponseHeader/>
  <xls:Response requestID="123" version="1.0">
    <xls:GeocodeResponse>
      <xls:GeocodeResponseList numberOfGeocodedAddresses="1">
        <xls:GeocodedAddress>
          <gml:Point>
            <gml:pos dimension="2" srsName="4326">-122.4083257 37.788208</gml:pos>
          </gml:Point>
          <xls:Address countryCode="US">
            <xls:StreetAddress>
              <xls:Building number="400"/>
              <xls:Street>POST ST</xls:Street>
            </xls:StreetAddress>
            <xls:Place type="CountrySubdivision">CA</xls:Place>
            <xls:Place type="Municipality">SAN FRANCISCO</xls:Place>
            <xls:PostalCode>94102</xls:PostalCode>
          </xls:Address>
        </xls:GeocodedAddress>
      </xls:GeocodeResponseList>
    </xls:GeocodeResponse>
  </xls:Response>
</xls:XLS>'));
INSERT INTO mdsys.OpenLS_Nodes (
  name,
  version,
  OpenLS)
VALUES (
  'yp response',
  '1.0',
  XMLTYPE('<xls:XLS xmlns:xls="http://www.opengis.net/xls" xmlns:gml="http://www.opengis.net/gml" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">
  <xls:ResponseHeader/>
  <xls:Response requestID="place holder" version="place holder">
    <xls:DirectoryResponse>
      <xls:POIContext>
        <xls:POI ID="place holder" POIName="place holder" phoneNumber="place holder" description="place holder">
          <xls:POIAttributeList>
            <xls:ReferenceSystem>
              <xls:SIC category="place holder" code="place holder" subType="place holder" type="place holder"/>
              <xls:NAICS category="place holder" subType="place holder" type="place holder"/>
              <xls:NACE division="place holder" group="place holder" class="place holder" description="place holder"/>
            </xls:ReferenceSystem>
          </xls:POIAttributeList>
          <gml:Point xmlns:gml="http://www.opengis.net/gml">
            <gml:pos dimension="2" srsName="4326">place holder</gml:pos>
          </gml:Point>
          <xls:Address countryCode="place holder">
            <xls:StreetAddress>
              <xls:Building number="place holder"/>
              <xls:Street>place holder</xls:Street>
            </xls:StreetAddress>
            <xls:Place type="CountrySubdivision">place holder</xls:Place>
            <xls:Place type="CountrySecondarySubdivision">place holder</xls:Place>
            <xls:Place type="Municipality">place holder</xls:Place>
            <xls:Place type="MunicipalitySubdivision">place holder</xls:Place>
            <xls:PostalCode>place holder</xls:PostalCode>
          </xls:Address>
        </xls:POI>
      </xls:POIContext>
      <xls:POIContext>
        <xls:POI ID="place holder" POIName="place holder" phoneNumber="place holder" description="place holder">
          <xls:POIAttributeList>
            <xls:ReferenceSystem>
              <xls:SIC category="place holder" code="place holder" subType="place holder" type="place holder"/>
              <xls:NAICS category="place holder" subType="place holder" type="place holder"/>
              <xls:NACE division="place holder" group="place holder" class="place holder" description="place holder"/>
            </xls:ReferenceSystem>
          </xls:POIAttributeList>
          <gml:Point xmlns:gml="http://www.opengis.net/gml">
            <gml:pos dimension="2" srsName="4326">place holder</gml:pos>
          </gml:Point>
          <xls:Address countryCode="place holder">
            <xls:StreetIntersection>
              <xls:Street>place holder</xls:Street>
              <xls:IntersectingStreet>place holder</xls:IntersectingStreet>
            </xls:StreetIntersection>
            <xls:Place type="CountrySubdivision">place holder</xls:Place>
            <xls:Place type="CountrySecondarySubdivision">place holder</xls:Place>
            <xls:Place type="Municipality">place holder</xls:Place>
            <xls:Place type="MunicipalitySubdivision">place holder</xls:Place>
            <xls:PostalCode>place holder</xls:PostalCode>
          </xls:Address>
        </xls:POI>
      </xls:POIContext>
    </xls:DirectoryResponse>
  </xls:Response>
</xls:XLS>'));
INSERT INTO mdsys.OpenLS_Nodes (
  name,
  version,
  OpenLS)
VALUES (
  'OpenLS error',
  '1.0',
  XMLTYPE('<xls:XLS xmlns:xls="http://www.opengis.net/xls" xmlns:gml="http://www.opengis.net/gml" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">
	<xls:ResponseHeader>
		<xls:ErrorList highestSeverity="Error">
			<xls:Error errorCode="DeliveryFailure"/>
			<xls:Error errorCode="Inconsistent"/>
			<xls:Error errorCode="NoDataAvailable"/>
			<xls:Error errorCode="NotSupported"/>
			<xls:Error errorCode="OtherXml"/>
			<xls:Error errorCode="RequestVersionMismatch"/>
			<xls:Error errorCode="ResponseVersionMismatch"/>
			<xls:Error errorCode="SecurityFailure"/>
			<xls:Error errorCode="Unknown"/>
			<xls:Error errorCode="ValueNotRecognized"/>
		</xls:ErrorList>
	</xls:ResponseHeader>
  <xls:Response numberOfResponses="0" requestID="place holder" version="place holder"/>
</xls:XLS>'));
INSERT INTO mdsys.OpenLS_Nodes (
  name,
  version,
  OpenLS)
VALUES (
  'Unknown OpenLS error',
  '1.0',
  XMLTYPE('<xls:XLS xmlns:xls="http://www.opengis.net/xls" xmlns:gml="http://www.opengis.net/gml" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">
	<xls:ResponseHeader>
		<xls:ErrorList highestSeverity="Error">
			<xls:Error severity="Error" errorCode="Unknown" message="Unknown error"/>
		</xls:ErrorList>
	</xls:ResponseHeader>
  <xls:Response numberOfResponses="0" requestID="place holder" version="place holder"/>
</xls:XLS>'));
INSERT INTO mdsys.OpenLS_Nodes (
  name,
  version,
  OpenLS) (
    SELECT
      name,
      '1.1',
      OpenLS
    FROM
      mdsys.OpenLS_Nodes
    WHERE
      version = '1.0');
INSERT INTO mdsys.OpenLS_Nodes (
  name,
  version,
  OpenLS)
VALUES (
  'Oracle Mapviewer request',
  '1.0',
  XMLTYPE('<?xml version="1.0" standalone="yes"?>
<map_request
  title="Oracle OpenLS Map"
  basemap="demo_map"
  datasource = "mvdemo"
  width="place holder"
  height="place holder"
  bgcolor="place holder"
  antialiase="false"
  srid="4326"
  format="place holder">
  <center size="place holder">
    <geoFeature>
      <geometricProperty typeName="center">
        <Point srsName="4326">
          <coordinates>place holder</coordinates>
        </Point>
      </geometricProperty>
    </geoFeature>
  </center>
  <themes>
    <theme name="" datasource=""/>
  </themes>
  <geoFeature label="some place" render_style="1397" text_style="9987">
    <geometricProperty>
      <Point srsName="4326">
        <coordinates>-122.2615 37.5266</coordinates>
      </Point>
    </geometricProperty>
  </geoFeature>
</map_request>'));
INSERT INTO mdsys.OpenLS_Nodes (
  name,
  version,
  OpenLS)
VALUES (
  'Oracle Mapviewer mbr',
  '1.0',
  XMLTYPE('<?xml version="1.0" standalone="yes"?>
<box srsName="default">
  <coordinates>-122.260443,37.531621 -120.345,39.543</coordinates>
</box>'));
INSERT INTO mdsys.OpenLS_Nodes (
  name,
  version,
  OpenLS)
VALUES (
  'Oracle router request',
  '1.0',
  XMLTYPE('<?xml version="1.0" standalone="yes"?>
<route_request id="8" 
               route_preference="shortest"
               road_preference="highway" 
               return_driving_directions="true"
               distance_unit="meter" 
               time_unit="second"
               return_route_geometry="true"
          >
  <start_location>
     <input_location id="1">
       <input_address>
         <gdf_form
           street="100 flower st"
           builtup_area="san francisco"
           order2_area="ca"
           country="US"/>
       </input_address>
     </input_location>
  </start_location>
  <end_location>
     <input_location id="2">
       <input_address>
         <gdf_form
           street="100 flower st"
           builtup_area="san francisco"
           order2_area="ca"
           country="US"/>
       </input_address>
     </input_location>
  </end_location>
</route_request>'));
COMMIT;
CREATE OR REPLACE PACKAGE BODY MDSYS.sdo_ols wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
2696 d8f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/
show errors;
GRANT EXECUTE ON MDSYS.sdo_ols TO PUBLIC;
