declare
  stmt VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_TABLES where owner = 'MDSYS' and table_name = 'CSW_TRG_TABLE_TEMP$';
  if(rec_count = 0) then
    stmt := 'create table mdsys.csw_trg_table_temp$ (r rowid)' ;
    execute immediate stmt;
  end if;
end;
/
show errors;
declare
  stmt VARCHAR2(10000);
  rec_count NUMBER;
begin
  select count(*) into rec_count from ALL_SEQUENCES where SEQUENCE_OWNER = 'MDSYS' and SEQUENCE_NAME = 'RT_SQ$';
  if(rec_count = 0) then
    stmt := ' CREATE SEQUENCE MDSYS.rt_sq$ START WITH 1 NOCACHE';
    execute immediate stmt;
  else
     stmt := ' drop sequence MDSYS.rt_sq$';
     execute immediate stmt;
     stmt := ' CREATE SEQUENCE MDSYS.rt_sq$ START WITH 1 NOCACHE';
     execute immediate stmt;
  end if;
end;
/
show errors;
grant select, alter on mdsys.rt_sq$ to spatial_csw_admin;
grant all on  MDSYS.CSW_TRG_TABLE_TEMP$ to spatial_csw_admin;
grant select, alter on mdsys.rt_sq$ to spatial_csw_admin_usr;
grant all on  MDSYS.CSW_TRG_TABLE_TEMP$ to spatial_csw_admin_usr;
grant all on  MDSYS.CSW_TRG_TABLE_TEMP$ to csw_usr_role;
CREATE OR REPLACE PACKAGE BODY MDSYS.SDO_CSW_PROCESS wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
20360 5739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==

/
show  errors;
grant execute on mdsys.sdo_csw_process to public;
