Rem
Rem $Header: sdo/admin/sdodbmig.sql /main/30 2009/05/21 14:57:52 matperry Exp $
Rem
Rem sdodbmig.sql
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      sdodbmig.sql - SDODBMIGration
Rem
Rem    DESCRIPTION
Rem      Script for upgrading SDO as part of the DB upgrade
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    matperry    05/19/09 - add semantic technologies upgrade
Rem    jcwang      04/07/09 - hide seq_id
Rem    hgong       03/24/09 - fix bug 8343434: reset ndm id generator
Rem    sdas        04/16/07 - remove rdf dummy upgrade/downgrade routines
Rem    mannamal    07/20/06 - fix lrg 2247076 (rdf upgrade) 
Rem    sravada     06/17/05 - bug 4420770 
Rem    sravada     06/13/05 - remove purge dba_recyclebin 
Rem    sravada     03/28/05 - bug 4217036 
Rem    sravada     03/14/05 - bug 4222305 
Rem    sravada     10/19/04 - lrg 1751186 
Rem    sravada     10/18/04 - move validate_sdo to SYS 
Rem    sravada     10/14/04 - 
Rem    sravada     09/03/04 - 
Rem    sravada     08/30/04 - remove cs_srs table 
Rem    sravada     08/18/04 - bug 3834721 
Rem    sravada     08/09/04 - add a PURGE at the end of upgrade 
Rem    sravada     07/29/04 - add exception handlers 
Rem    sravada     07/27/04 - bug 3676265 
Rem    mhorhamm    03/25/04 - Drop tables SDO_DATUMS, SDO_ELLIPSOIDS, 
Rem                           SDO_PROJECTIONS before catmd 
Rem    sravada     11/13/03 - topo filter 
Rem    sravada     07/15/03 - update tp anyint
Rem    ningan      06/18/03 - BUG2719909
Rem    sravada     06/12/03 - bug 2947458
Rem    sravada     04/01/03 - bug 2875254
Rem    sravada     02/05/03 - bug 2785356
Rem    rkothuri    01/13/03 - remove "drop package body mddict"
Rem    sravada     12/02/02 - fix alter indextype
Rem    sravada     10/08/02 - sravada_create_dbmig_script
Rem    sravada     10/08/02 - Created
Rem


Alter session set current_schema=MDSYS;


EXECUTE DBMS_REGISTRY.UPGRADING('SDO', NULL, 'validate_sdo');

@@sdomigrt.sql
@@catmd.sql
@@semdbmig.sql

REM reset ndm sequence id

DECLARE 
  id number;
BEGIN
  id :=  mdsys.md_net.reset_id_generator; 
END;
/

EXECUTE dbms_registry.upgraded('SDO');

REM Validate Oracle Spatial Installation
EXECUTE SYS.validate_sdo;

-- reset the session id back to SYS
Alter session set current_schema=SYS;

